/*
 * Decompiled with CFR 0.152.
 */
package me.leon.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.leon.DigestsKt;
import me.leon.config.ConfigKt;
import me.leon.controller.DigestController;
import me.leon.ext.ByteArrayKt;
import me.leon.ext.ConcurrencyKt;
import me.leon.ext.ExceptionKt;
import me.leon.ext.FileKt;
import me.leon.ext.StringKt;
import me.leon.ext.crypto.CrcKt;
import me.leon.ext.crypto.HashCrackKt;
import me.leon.ext.crypto.PasswordHashingType;
import me.leon.ext.crypto.TypesKt;
import me.leon.hash.CRCKt;
import me.leon.hash.CrcParam;
import me.leon.hash.WindowsHashKt;
import org.jetbrains.annotations.NotNull;
import tornadofx.Controller;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J*\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J&\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lme/leon/controller/DigestController;", "Ltornadofx/Controller;", "()V", "dicts", "", "", "getDicts", "()Ljava/util/List;", "crack", "method", "data", "digest", "inputEncode", "singleLine", "", "digestFile", "path", "maskCrack", "hashed", "mask", "dict", "passwordHashingCrack", "app"})
@SourceDebugExtension(value={"SMAP\nDigestController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigestController.kt\nme/leon/controller/DigestController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n3792#2:103\n4307#2,2:104\n1360#3:106\n1446#3,5:107\n*S KotlinDebug\n*F\n+ 1 DigestController.kt\nme/leon/controller/DigestController\n*L\n16#1:103\n16#1:104,2\n17#1:106\n17#1:107,5\n*E\n"})
public final class DigestController
extends Controller {
    /*
     * WARNING - void declaration
     */
    private final List<String> getDicts() {
        List list;
        List list2;
        File[] fileArray = FileKt.toFile(ConfigKt.getDICT_DIR()).listFiles();
        if (fileArray != null) {
            void $this$flatMapTo$iv$iv;
            File it;
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Iterable<void> destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".txt", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable list$iv$iv = FilesKt.readLines$default((File)it, null, (int)1, null);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final String digest(@NotNull String method, @NotNull String data, @NotNull String inputEncode, boolean singleLine) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)inputEncode, (String)"inputEncode");
        return (String)ExceptionKt.catch(digest.1.INSTANCE, (Function0)new Function0<String>(singleLine, data, this, method, inputEncode){
            final /* synthetic */ boolean $singleLine;
            final /* synthetic */ String $data;
            final /* synthetic */ DigestController this$0;
            final /* synthetic */ String $method;
            final /* synthetic */ String $inputEncode;
            {
                this.$singleLine = $singleLine;
                this.$data = $data;
                this.this$0 = $receiver;
                this.$method = $method;
                this.$inputEncode = $inputEncode;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.$singleLine ? StringKt.lineAction2String(this.$data, (Function1<? super String, String>)((Function1)new Function1<String, String>(this.this$0, this.$method, this.$inputEncode){
                    final /* synthetic */ DigestController this$0;
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $inputEncode;
                    {
                        this.this$0 = $receiver;
                        this.$method = $method;
                        this.$inputEncode = $inputEncode;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return DigestController.access$digest(this.this$0, this.$method, it, this.$inputEncode);
                    }
                })) : DigestController.access$digest(this.this$0, this.$method, this.$data, this.$inputEncode);
            }
        });
    }

    public static /* synthetic */ String digest$default(DigestController digestController, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "raw";
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return digestController.digest(string, string2, string3, bl);
    }

    private final String digest(String method, String data, String inputEncode) {
        String string;
        if (StringsKt.startsWith$default((String)method, (String)"CRC", (boolean)false, (int)2, null)) {
            CrcParam crcParam = CRCKt.getCRC_MAPPING().get(StringsKt.substringAfter$default((String)method, (String)"CRC", null, (int)2, null));
            Intrinsics.checkNotNull((Object)crcParam);
            string = CRCKt.crc(crcParam).digest(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (Intrinsics.areEqual((Object)method, (Object)"Adler32")) {
            string = CrcKt.adler32(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (Intrinsics.areEqual((Object)method, (Object)"NTLM")) {
            string = WindowsHashKt.ntlmHash$default(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null), null, 1, null);
        } else if (Intrinsics.areEqual((Object)method, (Object)"MD5_MIDDLE")) {
            String string2 = DigestsKt.hash2String$default(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null), null, 1, null).substring(8, 24);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (Intrinsics.areEqual((Object)method, (Object)"LM")) {
            string = WindowsHashKt.lmHash(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else if (TypesKt.passwordHashingType(method) != null) {
            PasswordHashingType passwordHashingType = TypesKt.passwordHashingType(method);
            Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
            string = passwordHashingType.hash(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null));
        } else {
            string = DigestsKt.hash2String(ByteArrayKt.decodeToByteArray$default(data, inputEncode, null, 2, null), method);
        }
        return string;
    }

    @NotNull
    public final String passwordHashingCrack(@NotNull String method, @NotNull String hashed) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
        return (String)ExceptionKt.catch(passwordHashingCrack.1.INSTANCE, (Function0)new Function0<String>(method, hashed, this){
            final /* synthetic */ String $method;
            final /* synthetic */ String $hashed;
            final /* synthetic */ DigestController this$0;
            {
                this.$method = $method;
                this.$hashed = $hashed;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                Object v2;
                block3: {
                    PasswordHashingType passwordHashingType = TypesKt.passwordHashingType(this.$method);
                    Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
                    if (!(passwordHashingType.hash(new byte[0]).length() == this.$hashed.length())) {
                        boolean bl = false;
                        String string2 = "Wrong Method!!! ";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    Iterable iterable = DigestController.access$getDicts(this.this$0);
                    String string3 = this.$method;
                    String string4 = this.$hashed;
                    Iterable iterable2 = iterable;
                    for (T t : iterable2) {
                        String pw = (String)t;
                        boolean bl = false;
                        PasswordHashingType passwordHashingType2 = TypesKt.passwordHashingType(string3);
                        Intrinsics.checkNotNull((Object)((Object)passwordHashingType2));
                        if (!passwordHashingType2.check(pw, string4)) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                if ((string = (String)v2) == null) {
                    string = "";
                }
                return string;
            }
        });
    }

    @NotNull
    public final String digestFile(@NotNull String method, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (String)ExceptionKt.catch(digestFile.1.INSTANCE, (Function0)new Function0<String>(path, method){
            final /* synthetic */ String $path;
            final /* synthetic */ String $method;
            {
                this.$path = $path;
                this.$method = $method;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                if (((CharSequence)this.$path).length() == 0) {
                    string = "";
                } else if (StringsKt.startsWith$default((String)this.$method, (String)"CRC", (boolean)false, (int)2, null)) {
                    File file = FileKt.toFile(this.$path);
                    CrcParam crcParam = CRCKt.getCRC_MAPPING().get(StringsKt.substringAfter$default((String)this.$method, (String)"CRC", null, (int)2, null));
                    Intrinsics.checkNotNull((Object)crcParam);
                    string = CRCKt.crc(file, crcParam);
                } else if (Intrinsics.areEqual((Object)this.$method, (Object)"Adler32")) {
                    string = CrcKt.adler32File(this.$path);
                } else {
                    if (TypesKt.passwordHashingType(this.$method) != null) {
                        throw new IllegalStateException("not support".toString());
                    }
                    if (Intrinsics.areEqual((Object)this.$method, (Object)"MD5_MIDDLE")) {
                        String string2 = DigestsKt.fileHash$default(this.$path, null, 1, null).substring(8, 24);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    } else {
                        string = DigestsKt.fileHash(this.$path, this.$method);
                    }
                }
                return string;
            }
        });
    }

    @NotNull
    public final String crack(@NotNull String method, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return (String)ExceptionKt.catch(crack.1.INSTANCE, (Function0)new Function0<String>(data, this, method){
            final /* synthetic */ String $data;
            final /* synthetic */ DigestController this$0;
            final /* synthetic */ String $method;
            {
                this.$data = $data;
                this.this$0 = $receiver;
                this.$method = $method;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.$data.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String lower = string;
                if (!(DigestController.access$digest(this.this$0, this.$method, "", "raw").length() == this.$data.length())) {
                    boolean bl = false;
                    String string2 = "Wrong Method!!! ";
                    throw new IllegalArgumentException(string2.toString());
                }
                System.out.println((Object)("crack " + this.$method + ' ' + this.$data));
                return ConcurrencyKt.findParallel(DigestController.access$getDicts(this.this$0), "", (Function1)new Function1<String, Boolean>(this.this$0, this.$method, lower){
                    final /* synthetic */ DigestController this$0;
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $lower;
                    {
                        this.this$0 = $receiver;
                        this.$method = $method;
                        this.$lower = $lower;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)DigestController.access$digest(this.this$0, this.$method, it, "raw"), (Object)this.$lower);
                    }
                });
            }
        });
    }

    @NotNull
    public final String maskCrack(@NotNull String method, @NotNull String hashed, @NotNull String mask, @NotNull String dict) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
        return (String)ExceptionKt.catch(maskCrack.1.INSTANCE, (Function0)new Function0<String>(hashed, this, method, mask, dict){
            final /* synthetic */ String $hashed;
            final /* synthetic */ DigestController this$0;
            final /* synthetic */ String $method;
            final /* synthetic */ String $mask;
            final /* synthetic */ String $dict;
            {
                this.$hashed = $hashed;
                this.this$0 = $receiver;
                this.$method = $method;
                this.$mask = $mask;
                this.$dict = $dict;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.$hashed.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String lower = string;
                if (!(DigestController.access$digest(this.this$0, this.$method, "", "raw").length() == this.$hashed.length())) {
                    boolean bl = false;
                    String string2 = "Wrong Method!!! ";
                    throw new IllegalArgumentException(string2.toString());
                }
                Function1 cond2 = StringsKt.startsWith$default((String)this.$method, (String)"SpringSecurity", (boolean)false, (int)2, null) ? (Function1)new Function1<String, Boolean>(this.$method, lower){
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $lower;
                    {
                        this.$method = $method;
                        this.$lower = $lower;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String pw) {
                        Intrinsics.checkNotNullParameter((Object)pw, (String)"pw");
                        PasswordHashingType passwordHashingType = TypesKt.passwordHashingType(this.$method);
                        Intrinsics.checkNotNull((Object)((Object)passwordHashingType));
                        return passwordHashingType.check(pw, this.$lower);
                    }
                } : (Function1)new Function1<String, Boolean>(this.this$0, this.$method, lower){
                    final /* synthetic */ DigestController this$0;
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $lower;
                    {
                        this.this$0 = $receiver;
                        this.$method = $method;
                        this.$lower = $lower;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String pw) {
                        Intrinsics.checkNotNullParameter((Object)pw, (String)"pw");
                        return Intrinsics.areEqual((Object)DigestController.access$digest(this.this$0, this.$method, pw, "raw"), (Object)this.$lower);
                    }
                };
                String string3 = HashCrackKt.maskParallel(this.$mask, this.$dict, (Function1<? super String, Boolean>)cond2);
                if (string3 == null) {
                    string3 = "";
                }
                return string3;
            }
        });
    }

    public static final /* synthetic */ String access$digest(DigestController $this, String method, String data, String inputEncode) {
        return $this.digest(method, data, inputEncode);
    }

    public static final /* synthetic */ List access$getDicts(DigestController $this) {
        return $this.getDicts();
    }
}

