/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.leon.ctf.BrainFuckToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0019\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\"B'\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0010\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\b\b\u0002\u0010 \u001a\u00020!R\u0012\u0010\t\u001a\u00020\u00038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00038\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u00058\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lme/leon/ctf/BrainfuckEngine;", "", "cells", "", "out", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "(ILjava/io/OutputStream;Ljava/io/InputStream;)V", "charPointer", "columnCount", "consoleReader", "Ljava/io/InputStreamReader;", "data", "", "dataPointer", "lineCount", "getLineCount$annotations", "()V", "outWriter", "initiate", "", "interpret", "c", "", "chars", "", "", "str", "isValidToken", "", "token", "tokens", "Lme/leon/ctf/BrainFuckToken;", "Token", "app"})
public class BrainfuckEngine {
    @JvmField
    @Nullable
    protected byte[] data;
    @JvmField
    protected int dataPointer;
    @JvmField
    protected int charPointer;
    @JvmField
    @NotNull
    protected InputStreamReader consoleReader;
    @JvmField
    @NotNull
    protected OutputStream outWriter;
    private int lineCount;
    private int columnCount;

    @JvmOverloads
    public BrainfuckEngine(int cells, @NotNull OutputStream out, @Nullable InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.initiate(cells);
        this.outWriter = out;
        this.consoleReader = new InputStreamReader(inputStream);
    }

    public /* synthetic */ BrainfuckEngine(int n, OutputStream outputStream, InputStream inputStream, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            outputStream = new ByteArrayOutputStream();
        }
        if ((n2 & 4) != 0) {
            inputStream = System.in;
        }
        this(n, outputStream, inputStream);
    }

    private static /* synthetic */ void getLineCount$annotations() {
    }

    protected final void initiate(int cells) {
        this.data = new byte[cells];
        this.dataPointer = 0;
        this.charPointer = 0;
    }

    @NotNull
    public String interpret(@NotNull String str) throws Exception {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        OutputStream outputStream = this.outWriter;
        Intrinsics.checkNotNull((Object)outputStream, (String)"null cannot be cast to non-null type java.io.ByteArrayOutputStream");
        ((ByteArrayOutputStream)outputStream).reset();
        while (this.charPointer < str.length()) {
            char c = str.charAt(this.charPointer);
            char[] cArray = str.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            this.interpret(c, cArray);
            int n = this.charPointer;
            this.charPointer = n + 1;
        }
        Intrinsics.checkNotNull((Object)this.data);
        this.initiate(this.data.length);
        return this.outWriter.toString();
    }

    protected final void interpret(char c, @NotNull char[] chars) throws IndexOutOfBoundsException {
        block22: {
            Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
            if (this.data == null) break block22;
            byte[] it = this.data;
            boolean bl = false;
            String string = String.valueOf(c);
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getNext())) {
                if (this.dataPointer + 1 > it.length) {
                    throw new IndexOutOfBoundsException("Error on line " + this.lineCount + ", column " + this.columnCount + ":data pointer (" + this.dataPointer + " ) on position " + this.charPointer + "  out of range.");
                }
                int n = this.dataPointer;
                this.dataPointer = n + 1;
            } else if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getPre())) {
                if (this.dataPointer - 1 < 0) {
                    throw new IndexOutOfBoundsException("Error on line " + this.lineCount + ", column " + this.columnCount + " :data pointer (" + this.dataPointer + " ) on position " + this.charPointer + "   negative.");
                }
                int n = this.dataPointer;
                this.dataPointer = n + -1;
            } else if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getPlus())) {
                int n = this.dataPointer;
                byte by = it[n];
                it[n] = (byte)(by + 1);
            } else if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getMinus())) {
                int n = this.dataPointer;
                byte by = it[n];
                it[n] = (byte)(by + -1);
            } else if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getOutput())) {
                this.outWriter.write(it[this.dataPointer]);
            } else if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getInput())) {
                it[this.dataPointer] = (byte)this.consoleReader.read();
            } else if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getBracketLeft())) {
                if (it[this.dataPointer] == 0) {
                    int i = 1;
                    while (i > 0) {
                        ++this.charPointer;
                        char c2 = chars[this.charPointer];
                        if (Intrinsics.areEqual((Object)String.valueOf(c2), (Object)Token.INSTANCE.getBracketLeft())) {
                            ++i;
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)String.valueOf(c2), (Object)Token.INSTANCE.getBracketRight())) continue;
                        --i;
                    }
                }
            } else if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getBracketRight())) {
                int i = 1;
                while (i > 0) {
                    this.charPointer += -1;
                    char c2 = chars[this.charPointer];
                    if (Intrinsics.areEqual((Object)String.valueOf(c2), (Object)Token.INSTANCE.getBracketLeft())) {
                        --i;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)String.valueOf(c2), (Object)Token.INSTANCE.getBracketRight())) continue;
                    ++i;
                }
                int n = this.charPointer;
                this.charPointer = n + -1;
            }
            int n = this.columnCount;
            this.columnCount = n + 1;
        }
    }

    public final boolean isValidToken(@NotNull String token, @NotNull BrainFuckToken tokens2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)tokens2, (String)"tokens");
        return StringsKt.equals((String)token, (String)tokens2.getStart(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getNext(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getPre(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getPlus(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getMinus(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getOutput(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getInput(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getBracketLeft(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getBracketRight(), (boolean)true) || StringsKt.equals((String)token, (String)tokens2.getEnd(), (boolean)true);
    }

    public static /* synthetic */ boolean isValidToken$default(BrainfuckEngine brainfuckEngine, String string, BrainFuckToken brainFuckToken, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isValidToken");
        }
        if ((n & 2) != 0) {
            brainFuckToken = Token.INSTANCE;
        }
        return brainfuckEngine.isValidToken(string, brainFuckToken);
    }

    @JvmOverloads
    public BrainfuckEngine(int cells, @NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(cells, out, null, 4, null);
    }

    @JvmOverloads
    public BrainfuckEngine(int cells) {
        this(cells, null, null, 6, null);
    }

    @JvmOverloads
    public BrainfuckEngine() {
        this(0, null, null, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lme/leon/ctf/BrainfuckEngine$Token;", "Lme/leon/ctf/BrainFuckToken;", "()V", "bracketLeft", "", "getBracketLeft", "()Ljava/lang/String;", "bracketRight", "getBracketRight", "end", "getEnd", "input", "getInput", "minus", "getMinus", "next", "getNext", "output", "getOutput", "plus", "getPlus", "pre", "getPre", "start", "getStart", "app"})
    public static final class Token
    implements BrainFuckToken {
        @NotNull
        public static final Token INSTANCE = new Token();
        @NotNull
        private static final String next = ">";
        @NotNull
        private static final String pre = "<";
        @NotNull
        private static final String plus = "+";
        @NotNull
        private static final String minus = "-";
        @NotNull
        private static final String output = ".";
        @NotNull
        private static final String input = ",";
        @NotNull
        private static final String bracketLeft = "[";
        @NotNull
        private static final String bracketRight = "]";
        @NotNull
        private static final String start = "";
        @NotNull
        private static final String end = "";

        private Token() {
        }

        @Override
        @NotNull
        public String getNext() {
            return next;
        }

        @Override
        @NotNull
        public String getPre() {
            return pre;
        }

        @Override
        @NotNull
        public String getPlus() {
            return plus;
        }

        @Override
        @NotNull
        public String getMinus() {
            return minus;
        }

        @Override
        @NotNull
        public String getOutput() {
            return output;
        }

        @Override
        @NotNull
        public String getInput() {
            return input;
        }

        @Override
        @NotNull
        public String getBracketLeft() {
            return bracketLeft;
        }

        @Override
        @NotNull
        public String getBracketRight() {
            return bracketRight;
        }

        @Override
        @NotNull
        public String getStart() {
            return start;
        }

        @Override
        @NotNull
        public String getEnd() {
            return end;
        }
    }
}

