/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.leon.ctf.BrainFuckToken;
import me.leon.ctf.BrainfuckEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0015B)\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0002R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lme/leon/ctf/TrollScriptEngine;", "Lme/leon/ctf/BrainfuckEngine;", "cells", "", "out", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "(ILjava/io/OutputStream;Ljava/io/InputStream;)V", "defaultTokenLength", "getDefaultTokenLength", "()I", "setDefaultTokenLength", "(I)V", "interpret", "", "str", "parseTokens", "", "tokens", "", "Token", "app"})
public class TrollScriptEngine
extends BrainfuckEngine {
    private int defaultTokenLength;

    @JvmOverloads
    public TrollScriptEngine(int cells, @Nullable OutputStream out, @Nullable InputStream inputStream) {
        OutputStream outputStream = out;
        Intrinsics.checkNotNull((Object)outputStream);
        super(cells, outputStream, inputStream);
        this.defaultTokenLength = 3;
    }

    public /* synthetic */ TrollScriptEngine(int n, OutputStream outputStream, InputStream inputStream, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        if ((n2 & 2) != 0) {
            outputStream = new ByteArrayOutputStream();
        }
        if ((n2 & 4) != 0) {
            inputStream = System.in;
        }
        this(n, outputStream, inputStream);
    }

    public int getDefaultTokenLength() {
        return this.defaultTokenLength;
    }

    public void setDefaultTokenLength(int n) {
        this.defaultTokenLength = n;
    }

    @Override
    @NotNull
    public String interpret(@NotNull String str) throws Exception {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        OutputStream outputStream = this.outWriter;
        Intrinsics.checkNotNull((Object)outputStream, (String)"null cannot be cast to non-null type java.io.ByteArrayOutputStream");
        ((ByteArrayOutputStream)outputStream).reset();
        boolean started = false;
        List tokens2 = new ArrayList();
        while (this.charPointer < str.length()) {
            String string;
            if (this.charPointer + this.getDefaultTokenLength() <= str.length()) {
                String string2 = str.substring(this.charPointer, this.charPointer + this.getDefaultTokenLength());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                String string3 = str.substring(this.charPointer, this.charPointer + (str.length() - this.charPointer));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            String token = string;
            if (this.isValidToken(token, Token.INSTANCE)) {
                if (StringsKt.equals((String)token, (String)Token.INSTANCE.getStart(), (boolean)true)) {
                    started = true;
                } else {
                    if (StringsKt.equals((String)token, (String)Token.INSTANCE.getEnd(), (boolean)true)) break;
                    if (started) {
                        tokens2.add(token);
                    }
                }
                this.charPointer += this.getDefaultTokenLength();
                continue;
            }
            if (this.charPointer + this.getDefaultTokenLength() > str.length()) {
                this.charPointer += str.length() - this.charPointer;
                continue;
            }
            int n = this.charPointer;
            this.charPointer = n + 1;
        }
        this.parseTokens(tokens2);
        Intrinsics.checkNotNull((Object)this.data);
        this.initiate(this.data.length);
        return this.outWriter.toString();
    }

    private final void parseTokens(List<String> tokens2) {
        for (int tokenPointer = 0; tokenPointer < tokens2.size(); ++tokenPointer) {
            byte by;
            int n;
            String string;
            Intrinsics.checkNotNullExpressionValue((Object)tokens2.get(tokenPointer).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getNext())) {
                Intrinsics.checkNotNull((Object)this.data);
                this.dataPointer = this.dataPointer == this.data.length - 1 ? 0 : this.dataPointer + 1;
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getPre())) {
                int n2;
                if (this.dataPointer == 0) {
                    Intrinsics.checkNotNull((Object)this.data);
                    n2 = this.data.length - 1;
                } else {
                    n2 = this.dataPointer - 1;
                }
                this.dataPointer = n2;
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getPlus())) {
                Intrinsics.checkNotNull((Object)this.data);
                byte[] byArray = this.data;
                n = this.dataPointer;
                by = byArray[n];
                byArray[n] = (byte)(by + 1);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getMinus())) {
                Intrinsics.checkNotNull((Object)this.data);
                byte[] byArray = this.data;
                n = this.dataPointer;
                by = byArray[n];
                byArray[n] = (byte)(by + -1);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getOutput())) {
                Intrinsics.checkNotNull((Object)this.data);
                this.outWriter.write(this.data[this.dataPointer]);
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getInput())) {
                Intrinsics.checkNotNull((Object)this.data);
                this.data[this.dataPointer] = (byte)this.consoleReader.read();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getBracketLeft())) {
                Intrinsics.checkNotNull((Object)this.data);
                if (this.data[this.dataPointer] != 0) continue;
                int level = 1;
                while (level > 0) {
                    if (StringsKt.equals((String)tokens2.get(++tokenPointer), (String)Token.INSTANCE.getBracketLeft(), (boolean)true)) {
                        ++level;
                        continue;
                    }
                    if (!StringsKt.equals((String)tokens2.get(tokenPointer), (String)Token.INSTANCE.getBracketRight(), (boolean)true)) continue;
                    --level;
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)Token.INSTANCE.getBracketRight())) continue;
            Intrinsics.checkNotNull((Object)this.data);
            if (this.data[this.dataPointer] == 0) continue;
            int level = 1;
            while (level > 0) {
                if (StringsKt.equals((String)tokens2.get(--tokenPointer), (String)Token.INSTANCE.getBracketLeft(), (boolean)true)) {
                    --level;
                    continue;
                }
                if (!StringsKt.equals((String)tokens2.get(tokenPointer), (String)Token.INSTANCE.getBracketRight(), (boolean)true)) continue;
                ++level;
            }
        }
    }

    @JvmOverloads
    public TrollScriptEngine(int cells, @Nullable OutputStream out) {
        this(cells, out, null, 4, null);
    }

    @JvmOverloads
    public TrollScriptEngine(int cells) {
        this(cells, null, null, 6, null);
    }

    @JvmOverloads
    public TrollScriptEngine() {
        this(0, null, null, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lme/leon/ctf/TrollScriptEngine$Token;", "Lme/leon/ctf/BrainFuckToken;", "()V", "bracketLeft", "", "getBracketLeft", "()Ljava/lang/String;", "bracketRight", "getBracketRight", "end", "getEnd", "input", "getInput", "minus", "getMinus", "next", "getNext", "output", "getOutput", "plus", "getPlus", "pre", "getPre", "start", "getStart", "app"})
    public static final class Token
    implements BrainFuckToken {
        @NotNull
        public static final Token INSTANCE = new Token();
        @NotNull
        private static final String start = "tro";
        @NotNull
        private static final String next = "ooo";
        @NotNull
        private static final String pre = "ool";
        @NotNull
        private static final String plus = "olo";
        @NotNull
        private static final String minus = "oll";
        @NotNull
        private static final String output = "loo";
        @NotNull
        private static final String input = "lol";
        @NotNull
        private static final String bracketLeft = "llo";
        @NotNull
        private static final String bracketRight = "lll";
        @NotNull
        private static final String end = "ll.";

        private Token() {
        }

        @Override
        @NotNull
        public String getStart() {
            return start;
        }

        @Override
        @NotNull
        public String getNext() {
            return next;
        }

        @Override
        @NotNull
        public String getPre() {
            return pre;
        }

        @Override
        @NotNull
        public String getPlus() {
            return plus;
        }

        @Override
        @NotNull
        public String getMinus() {
            return minus;
        }

        @Override
        @NotNull
        public String getOutput() {
            return output;
        }

        @Override
        @NotNull
        public String getInput() {
            return input;
        }

        @Override
        @NotNull
        public String getBracketLeft() {
            return bracketLeft;
        }

        @Override
        @NotNull
        public String getBracketRight() {
            return bracketRight;
        }

        @Override
        @NotNull
        public String getEnd() {
            return end;
        }
    }
}

