/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ctf.rsa;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.leon.ctf.rsa.FactorsKt;
import me.leon.ext.math.BigIntegerKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u0001\u001aE\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u000121\u0010\f\u001a-\u0012)\u0012'\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\u000ej\u0002`\u00120\rH\u0002\u001a\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u001a0\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00170\u0016*\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u001a\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\r*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u001a\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\r*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u001a\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u001a\u001e\u0010\u001d\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u0007\u001a$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u001e\u001a\u00020\u0001\u001a\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\u00012\b\b\u0002\u0010!\u001a\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003*L\u0010\"\"#\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\u000e2#\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\u000e\u00a8\u0006#"}, d2={"MAX_DIVIDER", "Ljava/math/BigInteger;", "getMAX_DIVIDER", "()Ljava/math/BigInteger;", "THREE", "getTHREE", "TIME_OUT", "", "TWO", "getTWO", "factor", "", "funList", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "integer", "Lme/leon/ctf/rsa/FactorFun;", "fermat", "timeOut", "fermatMore", "", "Lkotlin/Pair;", "num", "fullFermat", "fullFermat2", "pMinus1", "pollardsPM1Factors", "pollardsRho", "funBias", "pollardsRhoFactors", "trialDivide", "maxDivider", "FactorFun", "app"})
@SourceDebugExtension(value={"SMAP\nFactors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Factors.kt\nme/leon/ctf/rsa/FactorsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n1#2:278\n1549#3:279\n1620#3,3:280\n*S KotlinDebug\n*F\n+ 1 Factors.kt\nme/leon/ctf/rsa/FactorsKt\n*L\n113#1:279\n113#1:280,3\n*E\n"})
public final class FactorsKt {
    @NotNull
    private static final BigInteger THREE;
    @NotNull
    private static final BigInteger TWO;
    @NotNull
    private static final BigInteger MAX_DIVIDER;
    public static final int TIME_OUT = 2000;

    @NotNull
    public static final BigInteger getTHREE() {
        return THREE;
    }

    @NotNull
    public static final BigInteger getTWO() {
        return TWO;
    }

    @NotNull
    public static final BigInteger getMAX_DIVIDER() {
        return MAX_DIVIDER;
    }

    @NotNull
    public static final List<BigInteger> trialDivide(@NotNull BigInteger $this$trialDivide, @NotNull BigInteger maxDivider) {
        Intrinsics.checkNotNullParameter((Object)$this$trialDivide, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)maxDivider, (String)"maxDivider");
        if ($this$trialDivide.isProbablePrime(100)) {
            Object[] objectArray = new BigInteger[]{$this$trialDivide};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        List factors = new ArrayList();
        if ($this$trialDivide.bitLength() > 100) {
            List list;
            List $this$trialDivide_u24lambda_u240 = list = factors;
            boolean bl = false;
            BigInteger bigInteger = $this$trialDivide.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate(...)");
            $this$trialDivide_u24lambda_u240.add(bigInteger);
            return list;
        }
        BigInteger n = $this$trialDivide;
        while (true) {
            BigInteger bigInteger = n.remainder(TWO);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"remainder(...)");
            if (!Intrinsics.areEqual((Object)bigInteger, (Object)BigInteger.ZERO)) break;
            factors.add(TWO);
            Intrinsics.checkNotNullExpressionValue((Object)n.divide(TWO), (String)"divide(...)");
        }
        BigInteger f2 = THREE;
        while (f2.pow(2).compareTo(n) <= 0 && !n.isProbablePrime(100)) {
            BigInteger bigInteger = n.remainder(f2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"remainder(...)");
            if (Intrinsics.areEqual((Object)bigInteger, (Object)BigInteger.ZERO)) {
                factors.add(f2);
                Intrinsics.checkNotNullExpressionValue((Object)n.divide(f2), (String)"divide(...)");
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)f2.nextProbablePrime(), (String)"nextProbablePrime(...)");
            }
            if (f2.compareTo(maxDivider) <= 0) continue;
        }
        if (!Intrinsics.areEqual((Object)n, (Object)BigInteger.ONE)) {
            BigInteger bigInteger = n.isProbablePrime(100) ? n : n.negate();
            Intrinsics.checkNotNull((Object)bigInteger);
            factors.add(bigInteger);
        }
        return factors;
    }

    public static /* synthetic */ List trialDivide$default(BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger2 = MAX_DIVIDER;
        }
        return FactorsKt.trialDivide(bigInteger, bigInteger2);
    }

    @NotNull
    public static final List<BigInteger> fermat(@NotNull BigInteger $this$fermat, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)$this$fermat, (String)"<this>");
        Object[] $this$fermat_u24lambda_u241 = BigIntegerKt.root$default($this$fermat, 0, 1, null);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])$this$fermat_u24lambda_u241), (Object)BigInteger.ZERO)) {
            BigInteger bigInteger = (BigInteger)ArraysKt.first((Object[])$this$fermat_u24lambda_u241);
            BigInteger bigInteger2 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"add(...)");
            BigInteger a = bigInteger3;
            int count = 0;
            BigInteger b = null;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < (long)timeOut) {
                BigInteger b1;
                BigInteger bigInteger4 = a.pow(2);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"pow(...)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4.subtract($this$fermat), (String)"subtract(...)");
                b = BigIntegerKt.root$default(b1, 0, 1, null)[0];
                ++count;
                BigInteger bigInteger5 = b.multiply(b);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"multiply(...)");
                if (Intrinsics.areEqual((Object)bigInteger5, (Object)b1)) {
                    StringBuilder stringBuilder = new StringBuilder().append("solved iteration ").append(count).append(" \n\tp = ");
                    BigInteger bigInteger6 = a.add(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"add(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append(bigInteger6).append(" \n\tq= ");
                    BigInteger bigInteger7 = a.subtract(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"subtract(...)");
                    System.out.println((Object)stringBuilder2.append(bigInteger7).append('\n').toString());
                    Object[] objectArray = new BigInteger[2];
                    Intrinsics.checkNotNullExpressionValue((Object)a.add(b), (String)"add(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)a.subtract(b), (String)"subtract(...)");
                    return CollectionsKt.mutableListOf((Object[])objectArray);
                }
                Intrinsics.checkNotNullExpressionValue((Object)a.add(BigInteger.ONE), (String)"add(...)");
            }
        }
        System.out.println((Object)"no fermat solution");
        Object[] objectArray = new BigInteger[1];
        Intrinsics.checkNotNullExpressionValue((Object)$this$fermat.negate(), (String)"negate(...)");
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public static /* synthetic */ List fermat$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2000;
        }
        return FactorsKt.fermat(bigInteger, n);
    }

    @NotNull
    public static final Set<Pair<BigInteger, BigInteger>> fermatMore(@NotNull BigInteger $this$fermatMore, int num, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)$this$fermatMore, (String)"<this>");
        Set result = new LinkedHashSet();
        Object[] $this$fermatMore_u24lambda_u242 = BigIntegerKt.root$default($this$fermatMore, 0, 1, null);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])$this$fermatMore_u24lambda_u242), (Object)BigInteger.ZERO)) {
            BigInteger bigInteger = (BigInteger)ArraysKt.first((Object[])$this$fermatMore_u24lambda_u242);
            BigInteger bigInteger2 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"add(...)");
            BigInteger a = bigInteger3;
            int count = 0;
            BigInteger b = null;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < (long)timeOut) {
                BigInteger b1;
                BigInteger bigInteger4 = a.pow(2);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"pow(...)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4.subtract($this$fermatMore), (String)"subtract(...)");
                b = BigIntegerKt.root$default(b1, 0, 1, null)[0];
                ++count;
                BigInteger bigInteger5 = b.multiply(b);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"multiply(...)");
                if (Intrinsics.areEqual((Object)bigInteger5, (Object)b1)) {
                    StringBuilder stringBuilder = new StringBuilder().append("solved iteration ").append(count).append(" \n\tp = ");
                    BigInteger bigInteger6 = a.add(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"add(...)");
                    StringBuilder stringBuilder2 = stringBuilder.append(bigInteger6).append(" \n\tq= ");
                    BigInteger bigInteger7 = a.subtract(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"subtract(...)");
                    System.out.println((Object)stringBuilder2.append(bigInteger7).append('\n').toString());
                    BigInteger bigInteger8 = a.add(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"add(...)");
                    BigInteger bigInteger9 = a.subtract(b);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"subtract(...)");
                    result.add(TuplesKt.to((Object)bigInteger8, (Object)bigInteger9));
                    if (result.size() == num) {
                        return result;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)a.add(BigInteger.ONE), (String)"add(...)");
            }
        }
        if (result.size() == 0) {
            System.out.println((Object)"no fermat solution");
        }
        return result;
    }

    public static /* synthetic */ Set fermatMore$default(BigInteger bigInteger, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 2;
        }
        if ((n3 & 2) != 0) {
            n2 = 2000;
        }
        return FactorsKt.fermatMore(bigInteger, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<BigInteger> fullFermat(@NotNull BigInteger $this$fullFermat, int timeOut) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fullFermat, (String)"<this>");
        if ($this$fullFermat.isProbablePrime(100)) {
            return CollectionsKt.listOf((Object)$this$fullFermat);
        }
        Object object2 = $this$fullFermat;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BigInteger $this$fullFermat_u24lambda_u245 = object2;
            boolean bl = false;
            Iterable iterable = FactorsKt.fermat($this$fullFermat_u24lambda_u245, timeOut);
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List list;
                BigInteger bigInteger = (BigInteger)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                List it2 = list = FactorsKt.fullFermat((BigInteger)it, timeOut);
                boolean bl3 = false;
                List list2 = it2.size() > 1 ? list : null;
                if (list2 == null) {
                    list2 = CollectionsKt.listOf((Object)it);
                }
                collection.add(list2);
            }
            object = Result.constructor-impl((Object)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = CollectionsKt.listOf((Object)$this$fullFermat.negate());
        return (List)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    public static /* synthetic */ List fullFermat$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2000;
        }
        return FactorsKt.fullFermat(bigInteger, n);
    }

    @NotNull
    public static final List<BigInteger> fullFermat2(@NotNull BigInteger $this$fullFermat2, int timeOut) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$fullFermat2, (String)"<this>");
        System.out.println((Object)("full " + $this$fullFermat2));
        if ($this$fullFermat2.isProbablePrime(100)) {
            return CollectionsKt.listOf((Object)$this$fullFermat2);
        }
        Set fermatMore = FactorsKt.fermatMore$default($this$fullFermat2, timeOut, 0, 2, null);
        if (fermatMore.size() >= 2) {
            Pair pair = (Pair)CollectionsKt.toList((Iterable)fermatMore).get(0);
            BigInteger p1q1 = (BigInteger)pair.component1();
            BigInteger p2q2 = (BigInteger)pair.component2();
            Pair pair2 = (Pair)CollectionsKt.toList((Iterable)fermatMore).get(1);
            BigInteger p1q2 = (BigInteger)pair2.component1();
            BigInteger p2q1 = (BigInteger)pair2.component2();
            Object[] objectArray = new BigInteger[]{p1q1.gcd(p1q2), p2q2.gcd(p2q1), p1q1.gcd(p2q1), p2q2.gcd(p1q2)};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)$this$fullFermat2.negate());
        }
        return list;
    }

    public static /* synthetic */ List fullFermat2$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2000;
        }
        return FactorsKt.fullFermat2(bigInteger, n);
    }

    @NotNull
    public static final List<BigInteger> pollardsRhoFactors(@NotNull BigInteger $this$pollardsRhoFactors, int timeOut, @NotNull BigInteger funBias) {
        Intrinsics.checkNotNullParameter((Object)$this$pollardsRhoFactors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)funBias, (String)"funBias");
        if ($this$pollardsRhoFactors.isProbablePrime(100)) {
            Object[] objectArray = new BigInteger[]{$this$pollardsRhoFactors};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        List factors = new ArrayList();
        BigInteger n = $this$pollardsRhoFactors;
        BigInteger rho = null;
        while (true) {
            Object object = FactorsKt.pollardsRho(n, funBias, timeOut);
            BigInteger it = object;
            boolean bl = false;
            rho = it;
            if (Intrinsics.areEqual((Object)object, (Object)n)) break;
            System.out.println((Object)("rho " + rho));
            if (rho.compareTo(BigInteger.ZERO) < 0) {
                Object $this$pollardsRhoFactors_u24lambda_u247 = object = factors;
                boolean bl2 = false;
                $this$pollardsRhoFactors_u24lambda_u247.add(rho);
                return object;
            }
            factors.add(rho);
            Intrinsics.checkNotNullExpressionValue((Object)n.divide(rho), (String)"divide(...)");
        }
        if (!Intrinsics.areEqual((Object)n, (Object)BigInteger.ONE)) {
            factors.add(n);
        }
        return factors;
    }

    public static /* synthetic */ List pollardsRhoFactors$default(BigInteger bigInteger, int n, BigInteger bigInteger2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2000;
        }
        if ((n2 & 2) != 0) {
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            bigInteger2 = bigInteger3;
        }
        return FactorsKt.pollardsRhoFactors(bigInteger, n, bigInteger2);
    }

    @NotNull
    public static final BigInteger pollardsRho(@NotNull BigInteger $this$pollardsRho, @NotNull BigInteger funBias, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)$this$pollardsRho, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)funBias, (String)"funBias");
        if ($this$pollardsRho.isProbablePrime(100)) {
            return $this$pollardsRho;
        }
        System.out.println((Object)("rho: start factor " + $this$pollardsRho));
        long iteration = 0L;
        BigInteger x = TWO;
        BigInteger y = TWO;
        BigInteger d = BigInteger.ONE;
        long startTime = System.currentTimeMillis();
        Function1 f2 = (Function1)new Function1<BigInteger, BigInteger>($this$pollardsRho, funBias){
            final /* synthetic */ BigInteger $this_pollardsRho;
            final /* synthetic */ BigInteger $funBias;
            {
                this.$this_pollardsRho = $receiver;
                this.$funBias = $funBias;
                super(1);
            }

            @NotNull
            public final BigInteger invoke(@NotNull BigInteger a) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                BigInteger bigInteger = this.$this_pollardsRho;
                BigInteger bigInteger2 = BigInteger.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
                BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"subtract(...)");
                BigInteger bigInteger4 = a.modPow(bigInteger3, this.$this_pollardsRho);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"modPow(...)");
                BigInteger bigInteger5 = bigInteger4;
                BigInteger bigInteger6 = bigInteger5.add(this.$funBias);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"add(...)");
                bigInteger5 = bigInteger6;
                BigInteger bigInteger7 = bigInteger5.remainder(this.$this_pollardsRho);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"remainder(...)");
                return bigInteger7;
            }
        };
        while (Intrinsics.areEqual((Object)d, (Object)BigInteger.ONE)) {
            long l = iteration;
            iteration = l + 1L;
            x = (BigInteger)f2.invoke((Object)x);
            y = (BigInteger)f2.invoke(f2.invoke((Object)y));
            BigInteger bigInteger = x.subtract(y);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
            d = $this$pollardsRho.gcd(bigInteger.abs());
            if (System.currentTimeMillis() - startTime < (long)timeOut) continue;
            BigInteger bigInteger2 = $this$pollardsRho.negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"negate(...)");
            return bigInteger2;
        }
        System.out.println((Object)("rho: iteration " + iteration + " found " + d + ' '));
        BigInteger bigInteger = d;
        Intrinsics.checkNotNull((Object)bigInteger);
        return bigInteger;
    }

    public static /* synthetic */ BigInteger pollardsRho$default(BigInteger bigInteger, BigInteger bigInteger2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            bigInteger2 = bigInteger3;
        }
        if ((n2 & 2) != 0) {
            n = 2000;
        }
        return FactorsKt.pollardsRho(bigInteger, bigInteger2, n);
    }

    @NotNull
    public static final List<BigInteger> pollardsPM1Factors(@NotNull BigInteger $this$pollardsPM1Factors, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)$this$pollardsPM1Factors, (String)"<this>");
        if ($this$pollardsPM1Factors.isProbablePrime(100)) {
            Object[] objectArray = new BigInteger[]{$this$pollardsPM1Factors};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        List factors = new ArrayList();
        BigInteger n = $this$pollardsPM1Factors;
        BigInteger rho = null;
        while (true) {
            BigInteger bigInteger;
            BigInteger it = bigInteger = FactorsKt.pMinus1(n, timeOut);
            boolean bl = false;
            rho = it;
            if (Intrinsics.areEqual((Object)bigInteger, (Object)n)) break;
            System.out.println((Object)("rho " + rho));
            factors.add(rho);
            if (rho.compareTo(BigInteger.ZERO) < 0) {
                return factors;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n.divide(rho), (String)"divide(...)");
        }
        if (!Intrinsics.areEqual((Object)n, (Object)BigInteger.ONE)) {
            factors.add(n);
        }
        return factors;
    }

    public static /* synthetic */ List pollardsPM1Factors$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2000;
        }
        return FactorsKt.pollardsPM1Factors(bigInteger, n);
    }

    @NotNull
    public static final BigInteger pMinus1(@NotNull BigInteger $this$pMinus1, int timeOut) {
        Intrinsics.checkNotNullParameter((Object)$this$pMinus1, (String)"<this>");
        if ($this$pMinus1.isProbablePrime(100)) {
            return $this$pMinus1;
        }
        System.out.println((Object)("pm1: start factor " + $this$pMinus1));
        BigInteger m = TWO;
        BigInteger i = BigInteger.ONE;
        long iteration = 0L;
        long startTime = System.currentTimeMillis();
        while (i.compareTo($this$pMinus1) < 0) {
            long l = iteration;
            iteration = l + 1L;
            BigInteger bigInteger = m.pow(i.intValue());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pow(...)");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger.remainder($this$pMinus1), (String)"remainder(...)");
            BigInteger bigInteger2 = m;
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"subtract(...)");
            BigInteger gcd = $this$pMinus1.gcd(bigInteger4);
            if (!Intrinsics.areEqual((Object)gcd, (Object)BigInteger.ONE)) {
                System.out.println((Object)("pm1: found " + gcd + " iteration: " + iteration));
                Intrinsics.checkNotNull((Object)gcd);
                return gcd;
            }
            if (System.currentTimeMillis() - startTime >= (long)timeOut) break;
            bigInteger2 = i;
            Intrinsics.checkNotNull((Object)bigInteger2);
            BigInteger bigInteger5 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ONE");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.add(bigInteger5), (String)"add(...)");
        }
        System.out.println((Object)"pm1: not found");
        BigInteger bigInteger = $this$pMinus1.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"negate(...)");
        return bigInteger;
    }

    public static /* synthetic */ BigInteger pMinus1$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2000;
        }
        return FactorsKt.pMinus1(bigInteger, n);
    }

    @NotNull
    public static final List<BigInteger> factor(@NotNull BigInteger $this$factor) {
        Intrinsics.checkNotNullParameter((Object)$this$factor, (String)"<this>");
        Object[] objectArray = new Function1[]{factor.1.INSTANCE, factor.2.INSTANCE, factor.3.INSTANCE, factor.4.INSTANCE, factor.5.INSTANCE, factor.6.INSTANCE, factor.7.INSTANCE, factor.8.INSTANCE};
        return FactorsKt.factor($this$factor, CollectionsKt.listOf((Object[])objectArray));
    }

    private static final List<BigInteger> factor(BigInteger $this$factor, List<? extends Function1<? super BigInteger, ? extends List<? extends BigInteger>>> funList) {
        if ($this$factor.compareTo(THREE) <= 0) {
            Object[] objectArray = new BigInteger[]{$this$factor};
            return CollectionsKt.mutableListOf((Object[])objectArray);
        }
        BigInteger last = $this$factor;
        List factors = new ArrayList();
        for (Function1<? super BigInteger, ? extends List<? extends BigInteger>> function1 : funList) {
            BigInteger bigInteger = last.abs();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"abs(...)");
            factors.addAll((Collection)function1.invoke((Object)bigInteger));
            last = (BigInteger)CollectionsKt.last((List)factors);
            if (last.compareTo(BigInteger.ZERO) >= 0) break;
            factors.remove(last);
        }
        if (last.compareTo(BigInteger.ZERO) < 0) {
            factors.add(last);
        }
        return factors;
    }

    static {
        BigInteger bigInteger = BigInteger.valueOf(3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        THREE = bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        TWO = bigInteger2;
        BigInteger bigInteger3 = BigInteger.valueOf(10000);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
        MAX_DIVIDER = bigInteger3;
    }
}

