/*
 * Decompiled with CFR 0.152.
 */
package me.leon.encode.base;

import java.io.ByteArrayOutputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/leon/encode/base/Base91;", "", "()V", "AVERAGE_ENCODING_RATIO", "", "BASE", "", "ENCODING_TABLE", "", "decode", "data", "dict", "encode", "app"})
public final class Base91 {
    @NotNull
    public static final Base91 INSTANCE = new Base91();
    @NotNull
    private static final byte[] ENCODING_TABLE;
    private static final int BASE;
    private static final float AVERAGE_ENCODING_RATIO = 1.2297f;

    private Base91() {
    }

    @NotNull
    public final byte[] encode(@NotNull byte[] data, @NotNull byte[] dict) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
        int estimatedSize = (int)Math.ceil((float)data.length * 1.2297f);
        ByteArrayOutputStream output = new ByteArrayOutputStream(estimatedSize);
        int ebq = 0;
        int en = 0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            ebq |= (data[i] & 0xFF) << en;
            if ((en += 8) <= 13) continue;
            int ev = ebq & 0x1FFF;
            if (ev > 88) {
                ebq >>= 13;
                en -= 13;
            } else {
                ev = ebq & 0x3FFF;
                ebq >>= 14;
                en -= 14;
            }
            output.write(dict[ev % BASE]);
            output.write(dict[ev / BASE]);
        }
        if (en > 0) {
            output.write(dict[ebq % BASE]);
            if (en > 7 || ebq > 90) {
                output.write(dict[ebq / BASE]);
            }
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] encode$default(Base91 base91, byte[] byArray, byte[] byArray2, int n, Object object) {
        if ((n & 2) != 0) {
            byArray2 = ENCODING_TABLE;
        }
        return base91.encode(byArray, byArray2);
    }

    @NotNull
    public final byte[] decode(@NotNull byte[] data, @NotNull byte[] dict) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dict, (String)"dict");
        int dbq = 0;
        int dn = 0;
        int dv = -1;
        int estimatedSize = MathKt.roundToInt((float)((float)data.length / 1.2297f));
        ByteArrayOutputStream output = new ByteArrayOutputStream(estimatedSize);
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (ArraysKt.indexOf((byte[])dict, (byte)data[i]) == -1) continue;
            if (dv == -1) {
                dv = ArraysKt.indexOf((byte[])dict, (byte)data[i]);
                continue;
            }
            dbq |= (dv += ArraysKt.indexOf((byte[])dict, (byte)data[i]) * BASE) << dn;
            dn += (dv & 0x1FFF) > 88 ? 13 : 14;
            do {
                output.write(dbq);
                dbq >>= 8;
            } while ((dn -= 8) > 7);
            dv = -1;
        }
        if (dv != -1) {
            output.write((byte)(dbq | dv << dn));
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] decode$default(Base91 base91, byte[] byArray, byte[] byArray2, int n, Object object) {
        if ((n & 2) != 0) {
            byArray2 = ENCODING_TABLE;
        }
        return base91.decode(byArray, byArray2);
    }

    static {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ENCODING_TABLE = byArray;
        BASE = ENCODING_TABLE.length;
    }
}

