/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.DigestsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.crypto.SymmetricCryptoKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\f\u001a,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0001H\u0002\u001a,\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0001H\u0002\u001a8\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a@\u0010\u0010\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"SALT_PREFIX", "", "SALT_SIZE", "", "kdf", "", "pass", "salt", "outputSize", "hash", "parseKdf", "d", "openSslDecrypt", "alg", "keySize", "ivSize", "openSslEncrypt", "app"})
public final class OpenSslSaltedKt {
    public static final int SALT_SIZE = 8;
    @NotNull
    public static final String SALT_PREFIX = "Salted__";

    @NotNull
    public static final String openSslEncrypt(@NotNull String $this$openSslEncrypt, @NotNull String alg, @NotNull byte[] pass, @NotNull byte[] salt, int keySize, int ivSize, @NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)$this$openSslEncrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        byte[] kdf = OpenSslSaltedKt.kdf(pass, salt, keySize + ivSize, hash);
        Cipher $this$openSslEncrypt_u24lambda_u240 = SymmetricCryptoKt.makeCipher$default(alg, ArraysKt.sliceArray((byte[])kdf, (IntRange)RangesKt.until((int)0, (int)keySize)), ArraysKt.sliceArray((byte[])kdf, (IntRange)new IntRange(keySize, ArraysKt.getLastIndex((byte[])kdf))), 1, null, 16, null);
        boolean bl = false;
        byte[] byArray = SALT_PREFIX.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = ArraysKt.plus((byte[])byArray, (byte[])salt);
        byte[] byArray3 = $this$openSslEncrypt.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        byte[] byArray4 = $this$openSslEncrypt_u24lambda_u240.doFinal(byArray3);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"doFinal(...)");
        return Base64Kt.base64$default(ArraysKt.plus((byte[])byArray2, (byte[])byArray4), null, false, 3, null);
    }

    public static /* synthetic */ String openSslEncrypt$default(String string, String string2, byte[] byArray, byte[] byArray2, int n, int n2, String string3, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 32;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 16;
        }
        if ((n3 & 0x20) != 0) {
            string3 = "MD5";
        }
        return OpenSslSaltedKt.openSslEncrypt(string, string2, byArray, byArray2, n, n2, string3);
    }

    @NotNull
    public static final String openSslDecrypt(@NotNull String $this$openSslDecrypt, @NotNull String alg, @NotNull byte[] pass, int keySize, int ivSize, @NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)$this$openSslDecrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        byte[] kdf = OpenSslSaltedKt.parseKdf($this$openSslDecrypt, pass, keySize + ivSize, hash);
        Cipher $this$openSslDecrypt_u24lambda_u241 = SymmetricCryptoKt.makeCipher$default(alg, ArraysKt.sliceArray((byte[])kdf, (IntRange)RangesKt.until((int)0, (int)keySize)), ArraysKt.sliceArray((byte[])kdf, (IntRange)new IntRange(keySize, ArraysKt.getLastIndex((byte[])kdf))), 2, null, 16, null);
        boolean bl = false;
        byte[] base64Decode2 = Base64Kt.base64Decode$default($this$openSslDecrypt, null, 1, null);
        byte[] byArray = $this$openSslDecrypt_u24lambda_u241.doFinal(ArraysKt.sliceArray((byte[])base64Decode2, (IntRange)new IntRange(16, ArraysKt.getLastIndex((byte[])base64Decode2))));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return StringsKt.decodeToString((byte[])byArray);
    }

    public static /* synthetic */ String openSslDecrypt$default(String string, String string2, byte[] byArray, int n, int n2, String string3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 32;
        }
        if ((n3 & 8) != 0) {
            n2 = 16;
        }
        if ((n3 & 0x10) != 0) {
            string3 = "MD5";
        }
        return OpenSslSaltedKt.openSslDecrypt(string, string2, byArray, n, n2, string3);
    }

    private static final byte[] kdf(byte[] pass, byte[] salt, int outputSize, String hash) {
        byte[] key2;
        byte[] tmpKey = ArraysKt.plus((byte[])pass, (byte[])salt);
        byte[] resultKey = key2 = DigestsKt.hash(tmpKey, hash);
        while (resultKey.length < outputSize) {
            key2 = DigestsKt.hash(ArraysKt.plus((byte[])key2, (byte[])tmpKey), hash);
            resultKey = ArraysKt.plus((byte[])resultKey, (byte[])key2);
        }
        int n = resultKey.length;
        System.out.println(n);
        return ArraysKt.sliceArray((byte[])resultKey, (IntRange)RangesKt.until((int)0, (int)outputSize));
    }

    static /* synthetic */ byte[] kdf$default(byte[] byArray, byte[] byArray2, int n, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 48;
        }
        if ((n2 & 8) != 0) {
            string = "MD5";
        }
        return OpenSslSaltedKt.kdf(byArray, byArray2, n, string);
    }

    private static final byte[] parseKdf(String d, byte[] pass, int outputSize, String hash) {
        byte[] salt = ArraysKt.sliceArray((byte[])Base64Kt.base64Decode$default(d, null, 1, null), (IntRange)RangesKt.until((int)8, (int)16));
        return OpenSslSaltedKt.kdf(pass, salt, outputSize, hash);
    }

    static /* synthetic */ byte[] parseKdf$default(String string, byte[] byArray, int n, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 48;
        }
        if ((n2 & 8) != 0) {
            string2 = "MD5";
        }
        return OpenSslSaltedKt.parseKdf(string, byArray, n, string2);
    }
}

