/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.crypto.OpenSslSaltedKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000fJ:\u0010\u0013\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000fJ@\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\b\b\u0002\u0010\u001c\u001a\u00020\u000fJ@\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fH\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\""}, d2={"Lme/leon/ext/crypto/PBE;", "", "()V", "PBE_CRYPTO", "", "", "getPBE_CRYPTO", "()[Ljava/lang/String;", "[Ljava/lang/String;", "PBE_HMAC", "getPBE_HMAC", "decrypt", "password", "data", "saltLength", "", "alg", "iteration", "keyLength", "encrypt", "salt", "", "generatePBEKey", "Ljavax/crypto/SecretKey;", "keyLen", "saltLen", "iterations", "getSalt", "len", "makeCipher", "Ljavax/crypto/Cipher;", "kotlin.jvm.PlatformType", "pwd", "cipherMode", "app"})
@SourceDebugExtension(value={"SMAP\nPBE.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PBE.kt\nme/leon/ext/crypto/PBE\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class PBE {
    @NotNull
    public static final PBE INSTANCE = new PBE();
    @NotNull
    private static final String[] PBE_HMAC;
    @NotNull
    private static final String[] PBE_CRYPTO;

    private PBE() {
    }

    @NotNull
    public final String[] getPBE_HMAC() {
        return PBE_HMAC;
    }

    @NotNull
    public final String[] getPBE_CRYPTO() {
        return PBE_CRYPTO;
    }

    @NotNull
    public final String decrypt(@NotNull String password, @NotNull String data, int saltLength, @NotNull String alg, int iteration, int keyLength) {
        String string;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        byte[] base64Decode2 = Base64Kt.base64Decode$default(data, null, 1, null);
        byte[] salt = ArraysKt.sliceArray((byte[])base64Decode2, (IntRange)RangesKt.until((int)8, (int)(8 + saltLength)));
        if (StringsKt.contains((CharSequence)alg, (CharSequence)"HMAC", (boolean)true)) {
            byte[] byArray = PBE.generatePBEKey$default(this, password, salt, alg, keyLength, iteration, 0, 32, null).getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            string = Base64Kt.base64$default(byArray, null, false, 3, null);
        } else if (Intrinsics.areEqual((Object)alg, (Object)"PBEWithMD5andRC4")) {
            String string2 = password;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = OpenSslSaltedKt.openSslDecrypt$default(data, "RC4", byArray, 32, 0, null, 16, null);
        } else if (Intrinsics.areEqual((Object)alg, (Object)"PBEWithMD5andTripleDES")) {
            String string3 = password;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = OpenSslSaltedKt.openSslDecrypt$default(data, "DESede/CBC/PKCS5Padding", byArray, 24, 8, null, 16, null);
        } else {
            Cipher $this$decrypt_u24lambda_u240 = this.makeCipher(alg, password, salt, iteration, keyLength, 2);
            boolean bl = false;
            byte[] byArray = $this$decrypt_u24lambda_u240.doFinal(ArraysKt.sliceArray((byte[])base64Decode2, (IntRange)new IntRange(8 + saltLength, ArraysKt.getLastIndex((byte[])base64Decode2))));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
            string = StringsKt.decodeToString((byte[])byArray);
        }
        return string;
    }

    public static /* synthetic */ String decrypt$default(PBE pBE, String string, String string2, int n, String string3, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n2 = 1;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 128;
        }
        return pBE.decrypt(string, string2, n, string3, n2, n3);
    }

    @NotNull
    public final String encrypt(@NotNull String password, @NotNull String data, @NotNull byte[] salt, @NotNull String alg, int iteration, int keyLength) {
        String string;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        if (StringsKt.contains((CharSequence)alg, (CharSequence)"HMAC", (boolean)true)) {
            byte[] byArray = PBE.generatePBEKey$default(this, password, salt, alg, keyLength, iteration, 0, 32, null).getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            string = Base64Kt.base64$default(byArray, null, false, 3, null);
        } else if (Intrinsics.areEqual((Object)alg, (Object)"PBEWithMD5andRC4")) {
            String string2 = password;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = OpenSslSaltedKt.openSslEncrypt$default(data, "RC4", byArray, salt, 32, 0, null, 32, null);
        } else if (Intrinsics.areEqual((Object)alg, (Object)"PBEWithMD5andTripleDES")) {
            String string3 = password;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = OpenSslSaltedKt.openSslEncrypt$default(data, "DESede/CBC/PKCS5Padding", byArray, salt, 24, 8, null, 32, null);
        } else {
            Cipher $this$encrypt_u24lambda_u241 = this.makeCipher(alg, password, salt, iteration, keyLength, 1);
            boolean bl = false;
            byte[] byArray = "Salted__".getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = ArraysKt.plus((byte[])byArray, (byte[])salt);
            byte[] byArray3 = data.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
            byte[] byArray4 = $this$encrypt_u24lambda_u241.doFinal(byArray3);
            Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"doFinal(...)");
            string = Base64Kt.base64$default(ArraysKt.plus((byte[])byArray2, (byte[])byArray4), null, false, 3, null);
        }
        return string;
    }

    public static /* synthetic */ String encrypt$default(PBE pBE, String string, String string2, byte[] byArray, String string3, int n, int n2, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n = 1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 128;
        }
        return pBE.encrypt(string, string2, byArray, string3, n, n2);
    }

    @NotNull
    public final byte[] getSalt(int len) throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[len];
        sr.nextBytes(salt);
        return salt;
    }

    public static /* synthetic */ byte[] getSalt$default(PBE pBE, int n, int n2, Object object) throws NoSuchAlgorithmException {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        return pBE.getSalt(n);
    }

    private final Cipher makeCipher(String alg, String pwd, byte[] salt, int iteration, int keyLength, int cipherMode) {
        String string;
        byte[] byArray;
        Cipher cipher;
        Cipher $this$makeCipher_u24lambda_u242 = cipher = Cipher.getInstance(alg);
        boolean bl = false;
        SecretKey key2 = PBE.generatePBEKey$default(INSTANCE, pwd, salt, alg, keyLength, iteration, 0, 32, null);
        PBEParameterSpec pbeParameterSpec = new PBEParameterSpec(salt, iteration);
        $this$makeCipher_u24lambda_u242.init(cipherMode, (Key)key2, pbeParameterSpec);
        StringBuilder stringBuilder = new StringBuilder().append("key ");
        byte[] byArray2 = key2.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        StringBuilder stringBuilder2 = stringBuilder.append(Base64Kt.base64$default(byArray2, null, false, 3, null)).append("  iv ");
        if (byArray != null) {
            byArray = $this$makeCipher_u24lambda_u242.getIV();
            Intrinsics.checkNotNull((Object)byArray);
            string = Base64Kt.base64$default(byArray, null, false, 3, null);
        } else {
            string = null;
        }
        System.out.println((Object)stringBuilder2.append(string).toString());
        return cipher;
    }

    private final SecretKey generatePBEKey(String password, byte[] salt, String alg, int keyLen, int saltLen, int iterations) {
        byte[] byArray;
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        byte[] it = byArray = salt;
        boolean bl = false;
        byte[] byArray2 = (byte[])(!(it.length == 0) ? byArray : null);
        if (byArray2 == null) {
            byArray2 = this.getSalt(saltLen);
        }
        byte[] saltBytes = byArray2;
        PBEKeySpec spec = new PBEKeySpec(chars, saltBytes, iterations, keyLen);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(alg);
        SecretKey secretKey = skf.generateSecret(spec);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateSecret(...)");
        return secretKey;
    }

    static /* synthetic */ SecretKey generatePBEKey$default(PBE pBE, String string, byte[] byArray, String string2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            byArray = new byte[]{};
        }
        if ((n4 & 8) != 0) {
            n = 128;
        }
        if ((n4 & 0x10) != 0) {
            n2 = 8;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 1;
        }
        return pBE.generatePBEKey(string, byArray, string2, n, n2, n3);
    }

    static {
        String[] stringArray = new String[]{"PBKDF2WithHmacSHA1", "PBKDF2WithHmacSHA224", "PBKDF2WithHmacSHA256", "PBKDF2WithHmacSHA384", "PBKDF2WithHmacSHA512", "PBKDF2WithHmacGOST3411", "PBKDF2WithHmacSHA3-224", "PBKDF2WithHmacSHA3-256", "PBKDF2WithHmacSHA3-384", "PBKDF2WithHmacSHA3-512", "PBEWithHmacTIGER", "PBEWithHmacSHA256", "PBEWithHmacRIPEMD160", "PBEWithHmacGOST3411", "PBKDF2WithHmacSM3"};
        PBE_HMAC = stringArray;
        stringArray = new String[]{"MD5and256bitAES-CBC-OPENSSL", "MD5andRC4", "MD5andDES", "MD5andTripleDES", "MD5and192bitAES-CBC-OPENSSL", "MD5and128bitAES-CBC-OPENSSL", "MD5andRC2", "MD2andDES", "SHA1andDES", "SHA1andRC2", "SHA256and256bitAES-CBC-BC", "SHA256and192bitAES-CBC-BC", "SHA256and128bitAES-CBC-BC", "SHAand256bitAES-CBC-BC", "SHAand192bitAES-CBC-BC", "SHAand128bitAES-CBC-BC", "SHAand3-keyTripleDES-CBC", "SHAand2-keyTripleDES-CBC", "SHAand128bitRC4", "SHAand40bitRC4", "SHAand128bitRC2-CBC", "SHAand40bitRC2-CBC", "SHAandTwoFISH-CBC", "SHAandIDEA-CBC"};
        PBE_CRYPTO = stringArray;
    }
}

