/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.DigestsKt;
import me.leon.ext.crypto.MysqlKt;
import me.leon.ext.crypto.PasswordHashingTypeKt;
import me.leon.hash.password.Pbkdf2PasswordEncoder;
import me.leon.hash.password.Pbkdf2PasswordEncoderKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b#\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.\u00a8\u0006/"}, d2={"Lme/leon/ext/crypto/PasswordHashingType;", "", "alg", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getAlg", "()Ljava/lang/String;", "check", "", "pass", "hash", "data", "", "DoubleMd5", "DoubleMd5Uppercase", "TripleMd5", "TripleMd5Uppercase", "Md5Sha1", "Md5Sha256", "Md5Sha384", "Md5Sha512", "MySql", "MySql5", "SpringSecurityMD4", "SpringSecurityMD5", "SpringSecuritySHA1", "SpringSecuritySHA256", "SpringSecurityLDAP", "SpringSecuritySCRYPT", "SpringSecurityBRYPT", "SpringSecurityARGON2", "SpringSecurityPBKDF2WithHmacSHA1", "SpringSecurityPBKDF2WithHmacSHA256", "SpringSecurityPBKDF2WithHmacSHA512", "SpringSecurityPBEWithHmacTIGER", "SpringSecurityPBEWithHmacSHA256", "SpringSecurityPBKDF2WithHmacSHA224", "SpringSecurityPBEWithHmacRIPEMD160", "SpringSecurityPBKDF2WithHmacSHA3_384", "SpringSecurityPBKDF2WithHmacGOST3411", "SpringSecurityPBKDF2WithHmacSM3", "SpringSecurityPBKDF2WithHmacSHA384", "SpringSecurityPBKDF2WithHmacSHA3_512", "SpringSecurityPBEWithHmacSHA1", "SpringSecurityPBEWithHmacGOST3411", "SpringSecurityPBKDF2WithHmacSHA3_256", "SpringSecurityPBKDF2WithHmacSHA3_224", "app"})
public abstract class PasswordHashingType
extends Enum<PasswordHashingType> {
    @NotNull
    private final String alg;
    public static final /* enum */ PasswordHashingType DoubleMd5 = new DoubleMd5("DoubleMd5", 0);
    public static final /* enum */ PasswordHashingType DoubleMd5Uppercase = new DoubleMd5Uppercase("DoubleMd5Uppercase", 1);
    public static final /* enum */ PasswordHashingType TripleMd5 = new TripleMd5("TripleMd5", 2);
    public static final /* enum */ PasswordHashingType TripleMd5Uppercase = new TripleMd5Uppercase("TripleMd5Uppercase", 3);
    public static final /* enum */ PasswordHashingType Md5Sha1 = new Md5Sha1("Md5Sha1", 4);
    public static final /* enum */ PasswordHashingType Md5Sha256 = new Md5Sha256("Md5Sha256", 5);
    public static final /* enum */ PasswordHashingType Md5Sha384 = new Md5Sha384("Md5Sha384", 6);
    public static final /* enum */ PasswordHashingType Md5Sha512 = new Md5Sha512("Md5Sha512", 7);
    public static final /* enum */ PasswordHashingType MySql = new MySql("MySql", 8);
    public static final /* enum */ PasswordHashingType MySql5 = new MySql5("MySql5", 9);
    public static final /* enum */ PasswordHashingType SpringSecurityMD4 = new SpringSecurityMD4("SpringSecurityMD4", 10);
    public static final /* enum */ PasswordHashingType SpringSecurityMD5 = new SpringSecurityMD5("SpringSecurityMD5", 11);
    public static final /* enum */ PasswordHashingType SpringSecuritySHA1 = new SpringSecuritySHA1("SpringSecuritySHA1", 12);
    public static final /* enum */ PasswordHashingType SpringSecuritySHA256 = new SpringSecuritySHA256("SpringSecuritySHA256", 13);
    public static final /* enum */ PasswordHashingType SpringSecurityLDAP = new SpringSecurityLDAP("SpringSecurityLDAP", 14);
    public static final /* enum */ PasswordHashingType SpringSecuritySCRYPT = new SpringSecuritySCRYPT("SpringSecuritySCRYPT", 15);
    public static final /* enum */ PasswordHashingType SpringSecurityBRYPT = new SpringSecurityBRYPT("SpringSecurityBRYPT", 16);
    public static final /* enum */ PasswordHashingType SpringSecurityARGON2 = new SpringSecurityARGON2("SpringSecurityARGON2", 17);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA1 = new SpringSecurityPBKDF2WithHmacSHA1("SpringSecurityPBKDF2WithHmacSHA1", 18);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA256 = new SpringSecurityPBKDF2WithHmacSHA256("SpringSecurityPBKDF2WithHmacSHA256", 19);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA512 = new SpringSecurityPBKDF2WithHmacSHA512("SpringSecurityPBKDF2WithHmacSHA512", 20);
    public static final /* enum */ PasswordHashingType SpringSecurityPBEWithHmacTIGER = new SpringSecurityPBEWithHmacTIGER("SpringSecurityPBEWithHmacTIGER", 21);
    public static final /* enum */ PasswordHashingType SpringSecurityPBEWithHmacSHA256 = new SpringSecurityPBEWithHmacSHA256("SpringSecurityPBEWithHmacSHA256", 22);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA224 = new SpringSecurityPBKDF2WithHmacSHA224("SpringSecurityPBKDF2WithHmacSHA224", 23);
    public static final /* enum */ PasswordHashingType SpringSecurityPBEWithHmacRIPEMD160 = new SpringSecurityPBEWithHmacRIPEMD160("SpringSecurityPBEWithHmacRIPEMD160", 24);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA3_384 = new SpringSecurityPBKDF2WithHmacSHA3_384("SpringSecurityPBKDF2WithHmacSHA3_384", 25);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacGOST3411 = new SpringSecurityPBKDF2WithHmacGOST3411("SpringSecurityPBKDF2WithHmacGOST3411", 26);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSM3 = new SpringSecurityPBKDF2WithHmacSM3("SpringSecurityPBKDF2WithHmacSM3", 27);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA384 = new SpringSecurityPBKDF2WithHmacSHA384("SpringSecurityPBKDF2WithHmacSHA384", 28);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA3_512 = new SpringSecurityPBKDF2WithHmacSHA3_512("SpringSecurityPBKDF2WithHmacSHA3_512", 29);
    public static final /* enum */ PasswordHashingType SpringSecurityPBEWithHmacSHA1 = new SpringSecurityPBEWithHmacSHA1("SpringSecurityPBEWithHmacSHA1", 30);
    public static final /* enum */ PasswordHashingType SpringSecurityPBEWithHmacGOST3411 = new SpringSecurityPBEWithHmacGOST3411("SpringSecurityPBEWithHmacGOST3411", 31);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA3_256 = new SpringSecurityPBKDF2WithHmacSHA3_256("SpringSecurityPBKDF2WithHmacSHA3_256", 32);
    public static final /* enum */ PasswordHashingType SpringSecurityPBKDF2WithHmacSHA3_224 = new SpringSecurityPBKDF2WithHmacSHA3_224("SpringSecurityPBKDF2WithHmacSHA3_224", 33);
    private static final /* synthetic */ PasswordHashingType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PasswordHashingType(String alg) {
        this.alg = alg;
    }

    @NotNull
    public final String getAlg() {
        return this.alg;
    }

    @NotNull
    public abstract String hash(@NotNull byte[] var1);

    public boolean check(@NotNull String pass, @NotNull String hash) {
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        String string = pass;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return Intrinsics.areEqual((Object)this.hash(byArray), (Object)hash);
    }

    public static PasswordHashingType[] values() {
        return (PasswordHashingType[])$VALUES.clone();
    }

    public static PasswordHashingType valueOf(String value) {
        return Enum.valueOf(PasswordHashingType.class, value);
    }

    @NotNull
    public static EnumEntries<PasswordHashingType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ PasswordHashingType(String $enum$name, int $enum$ordinal, String alg, DefaultConstructorMarker $constructor_marker) {
        this(alg);
    }

    static {
        $VALUES = passwordHashingTypeArray = new PasswordHashingType[]{PasswordHashingType.DoubleMd5, PasswordHashingType.DoubleMd5Uppercase, PasswordHashingType.TripleMd5, PasswordHashingType.TripleMd5Uppercase, PasswordHashingType.Md5Sha1, PasswordHashingType.Md5Sha256, PasswordHashingType.Md5Sha384, PasswordHashingType.Md5Sha512, PasswordHashingType.MySql, PasswordHashingType.MySql5, PasswordHashingType.SpringSecurityMD4, PasswordHashingType.SpringSecurityMD5, PasswordHashingType.SpringSecuritySHA1, PasswordHashingType.SpringSecuritySHA256, PasswordHashingType.SpringSecurityLDAP, PasswordHashingType.SpringSecuritySCRYPT, PasswordHashingType.SpringSecurityBRYPT, PasswordHashingType.SpringSecurityARGON2, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA1, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA256, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA512, PasswordHashingType.SpringSecurityPBEWithHmacTIGER, PasswordHashingType.SpringSecurityPBEWithHmacSHA256, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA224, PasswordHashingType.SpringSecurityPBEWithHmacRIPEMD160, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA3_384, PasswordHashingType.SpringSecurityPBKDF2WithHmacGOST3411, PasswordHashingType.SpringSecurityPBKDF2WithHmacSM3, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA384, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA3_512, PasswordHashingType.SpringSecurityPBEWithHmacSHA1, PasswordHashingType.SpringSecurityPBEWithHmacGOST3411, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA3_256, PasswordHashingType.SpringSecurityPBKDF2WithHmacSHA3_224};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$DoubleMd5;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    @SourceDebugExtension(value={"SMAP\nPasswordHashingType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordHashingType.kt\nme/leon/ext/crypto/PasswordHashingType$DoubleMd5\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
    static final class DoubleMd5
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        DoubleMd5() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String hash = null;
            hash = StringsKt.decodeToString((byte[])data);
            int n = 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                String string = hash.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                hash = DigestsKt.hash$default(string, null, 1, null);
            }
            return hash;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$DoubleMd5Uppercase;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    @SourceDebugExtension(value={"SMAP\nPasswordHashingType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordHashingType.kt\nme/leon/ext/crypto/PasswordHashingType$DoubleMd5Uppercase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
    static final class DoubleMd5Uppercase
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        DoubleMd5Uppercase() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String hash = null;
            hash = StringsKt.decodeToString((byte[])data);
            int n = 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                String string = hash.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                hash = DigestsKt.hash$default(string, null, 1, null);
            }
            return hash;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$Md5Sha1;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    static final class Md5Sha1
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        Md5Sha1() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = DigestsKt.hash(StringsKt.decodeToString((byte[])data), "SHA1").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return DigestsKt.hash$default(string, null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$Md5Sha256;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    static final class Md5Sha256
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        Md5Sha256() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = DigestsKt.hash(StringsKt.decodeToString((byte[])data), "SHA256").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return DigestsKt.hash$default(string, null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$Md5Sha384;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    static final class Md5Sha384
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        Md5Sha384() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = DigestsKt.hash(StringsKt.decodeToString((byte[])data), "SHA384").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return DigestsKt.hash$default(string, null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$Md5Sha512;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    static final class Md5Sha512
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        Md5Sha512() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String string = DigestsKt.hash(StringsKt.decodeToString((byte[])data), "SHA512").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return DigestsKt.hash$default(string, null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$MySql;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    static final class MySql
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        MySql() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return MysqlKt.mysqlOld(data);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$MySql5;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    static final class MySql5
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        MySql5() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return MysqlKt.mysql(data);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityARGON2;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityARGON2
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityARGON2() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_ARGON2().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_ARGON2().matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityBRYPT;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityBRYPT
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityBRYPT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_BCRYPT().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_BCRYPT().matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityLDAP;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityLDAP
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityLDAP() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_LDAP().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_LDAP().matches((CharSequence)pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityMD4;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityMD4
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityMD4() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_MD4().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_MD4().matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityMD5;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityMD5
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityMD5() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_MD5().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_MD5().matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBEWithHmacGOST3411;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBEWithHmacGOST3411
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBEWithHmacGOST3411() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacGOST3411);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacGOST3411);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBEWithHmacRIPEMD160;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBEWithHmacRIPEMD160
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBEWithHmacRIPEMD160() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacRIPEMD160);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacRIPEMD160);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBEWithHmacSHA1;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBEWithHmacSHA1
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBEWithHmacSHA1() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacSHA1);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacSHA1);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBEWithHmacSHA256;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBEWithHmacSHA256
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBEWithHmacSHA256() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacSHA256);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacSHA256);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBEWithHmacTIGER;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBEWithHmacTIGER
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBEWithHmacTIGER() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacTIGER);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBEWithHmacTIGER);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacGOST3411;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacGOST3411
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacGOST3411() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacGOST3411);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacGOST3411);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA1;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA1
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA1() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA1);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA1);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA224;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA224
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA224() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA224);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA224);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA256;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA256
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA256() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA256);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA256);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA384;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA384
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA384() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA384);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA384);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA3_224;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA3_224
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA3_224() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-224);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-224);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA3_256;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA3_256
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA3_256() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-256);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-256);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA3_384;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA3_384
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA3_384() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-384);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-384);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA3_512;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA3_512
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA3_512() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-512);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-512);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSHA512;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSHA512
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSHA512() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA512);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA512);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecurityPBKDF2WithHmacSM3;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecurityPBKDF2WithHmacSM3
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecurityPBKDF2WithHmacSM3() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSM3);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Pbkdf2PasswordEncoder pbkdf2PasswordEncoder = Pbkdf2PasswordEncoderKt.getPBE_ENCODERS().get((Object)Pbkdf2PasswordEncoder.SecretKeyFactoryAlgorithm.PBKDF2WithHmacSM3);
            Intrinsics.checkNotNull((Object)pbkdf2PasswordEncoder);
            return pbkdf2PasswordEncoder.matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecuritySCRYPT;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecuritySCRYPT
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecuritySCRYPT() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_SCRYPT().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_SCRYPT().matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecuritySHA1;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecuritySHA1
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecuritySHA1() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_SHA1().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_SHA1().matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$SpringSecuritySHA256;", "Lme/leon/ext/crypto/PasswordHashingType;", "check", "", "pass", "", "hash", "data", "", "app"})
    static final class SpringSecuritySHA256
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        SpringSecuritySHA256() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return PasswordHashingTypeKt.getPH_SHA256().encode(StringsKt.decodeToString((byte[])data));
        }

        @Override
        public boolean check(@NotNull String pass, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return PasswordHashingTypeKt.getPH_SHA256().matches(pass, hash);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$TripleMd5;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    @SourceDebugExtension(value={"SMAP\nPasswordHashingType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordHashingType.kt\nme/leon/ext/crypto/PasswordHashingType$TripleMd5\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
    static final class TripleMd5
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        TripleMd5() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String hash = null;
            hash = StringsKt.decodeToString((byte[])data);
            int n = 3;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                String string = hash.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                hash = DigestsKt.hash$default(string, null, 1, null);
            }
            return hash;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lme/leon/ext/crypto/PasswordHashingType$TripleMd5Uppercase;", "Lme/leon/ext/crypto/PasswordHashingType;", "hash", "", "data", "", "app"})
    @SourceDebugExtension(value={"SMAP\nPasswordHashingType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordHashingType.kt\nme/leon/ext/crypto/PasswordHashingType$TripleMd5Uppercase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,302:1\n1#2:303\n*E\n"})
    static final class TripleMd5Uppercase
    extends PasswordHashingType {
        /*
         * WARNING - void declaration
         */
        TripleMd5Uppercase() {
            void var1_1;
        }

        @Override
        @NotNull
        public String hash(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            String hash = null;
            hash = StringsKt.decodeToString((byte[])data);
            int n = 3;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                String string = hash.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                hash = DigestsKt.hash$default(string, null, 1, null);
            }
            return hash;
        }
    }
}

