/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ExceptionKt;
import me.leon.ext.crypto.AsymmetircCryptoKt;
import me.leon.ext.crypto.SignatureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a\u0006\u0010\b\u001a\u00020\t\u001a\f\u0010\n\u001a\u00020\u0002*\u00020\u0002H\u0002\u001a\"\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0002\u001a*\u0010\u0010\u001a\u00020\u0011*\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\f\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"ecdsaCurveMap", "", "", "getEcdsaCurveMap", "()Ljava/util/Map;", "generateEcKeyPair", "Ljava/security/KeyPair;", "jwtAlg", "main", "", "properKeyPairAlg", "sign", "", "kpAlg", "sigAlg", "pri", "verify", "", "pub", "signed", "app"})
@SourceDebugExtension(value={"SMAP\nSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signature.kt\nme/leon/ext/crypto/SignatureKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class SignatureKt {
    @NotNull
    private static final Map<String, String> ecdsaCurveMap;

    private static final String properKeyPairAlg(String $this$properKeyPairAlg) {
        String string;
        String it = string = $this$properKeyPairAlg;
        boolean bl = false;
        String string2 = !StringsKt.equals((String)it, (String)"SM2", (boolean)true) ? string : null;
        if (string2 == null) {
            string2 = "EC";
        }
        return string2;
    }

    @NotNull
    public static final byte[] sign(@NotNull byte[] $this$sign, @NotNull String kpAlg, @NotNull String sigAlg, @NotNull String pri) {
        Signature signature;
        Intrinsics.checkNotNullParameter((Object)$this$sign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kpAlg, (String)"kpAlg");
        Intrinsics.checkNotNullParameter((Object)sigAlg, (String)"sigAlg");
        Intrinsics.checkNotNullParameter((Object)pri, (String)"pri");
        Signature $this$sign_u24lambda_u241 = signature = Signature.getInstance(SignatureKt.properKeyPairAlg(sigAlg));
        boolean bl = false;
        $this$sign_u24lambda_u241.initSign(AsymmetircCryptoKt.toPrivateKey(pri, kpAlg));
        $this$sign_u24lambda_u241.update($this$sign);
        byte[] byArray = signature.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }

    public static final boolean verify(@NotNull byte[] $this$verify, @NotNull String kpAlg, @NotNull String sigAlg, @NotNull String pub, @NotNull byte[] signed) {
        Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kpAlg, (String)"kpAlg");
        Intrinsics.checkNotNullParameter((Object)sigAlg, (String)"sigAlg");
        Intrinsics.checkNotNullParameter((Object)pub, (String)"pub");
        Intrinsics.checkNotNullParameter((Object)signed, (String)"signed");
        return (Boolean)ExceptionKt.catch(verify.1.INSTANCE, (Function0)new Function0<Boolean>(sigAlg, signed, pub, kpAlg, $this$verify){
            final /* synthetic */ String $sigAlg;
            final /* synthetic */ byte[] $signed;
            final /* synthetic */ String $pub;
            final /* synthetic */ String $kpAlg;
            final /* synthetic */ byte[] $this_verify;
            {
                this.$sigAlg = $sigAlg;
                this.$signed = $signed;
                this.$pub = $pub;
                this.$kpAlg = $kpAlg;
                this.$this_verify = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Signature signature = Signature.getInstance(SignatureKt.access$properKeyPairAlg(this.$sigAlg));
                String string = this.$pub;
                String string2 = this.$kpAlg;
                byte[] byArray = this.$this_verify;
                Signature $this$invoke_u24lambda_u240 = signature;
                boolean bl = false;
                $this$invoke_u24lambda_u240.initVerify(AsymmetircCryptoKt.toPublicKey(string, string2));
                $this$invoke_u24lambda_u240.update(byArray);
                return signature.verify(this.$signed);
            }
        });
    }

    @NotNull
    public static final Map<String, String> getEcdsaCurveMap() {
        return ecdsaCurveMap;
    }

    @Nullable
    public static final KeyPair generateEcKeyPair(@NotNull String jwtAlg) {
        Intrinsics.checkNotNullParameter((Object)jwtAlg, (String)"jwtAlg");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        ECGenParameterSpec spec = new ECGenParameterSpec(ecdsaCurveMap.get(jwtAlg));
        kpg.initialize(spec, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static /* synthetic */ KeyPair generateEcKeyPair$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "ES256";
        }
        return SignatureKt.generateEcKeyPair(string);
    }

    public static final void main() {
        block0: {
            KeyPair keyPair = SignatureKt.generateEcKeyPair$default(null, 1, null);
            if (keyPair == null) break block0;
            KeyPair it = keyPair;
            boolean bl = false;
            byte[] byArray = it.getPublic().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            System.out.println((Object)Base64Kt.base64$default(byArray, null, false, 3, null));
            byte[] byArray2 = it.getPrivate().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
            System.out.println((Object)Base64Kt.base64$default(byArray2, null, false, 3, null));
        }
    }

    public static /* synthetic */ void main(String[] args) {
        SignatureKt.main();
    }

    public static final /* synthetic */ String access$properKeyPairAlg(String $receiver) {
        return SignatureKt.properKeyPairAlg($receiver);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ES256", (Object)"secp256r1"), TuplesKt.to((Object)"ES384", (Object)"secp384r1"), TuplesKt.to((Object)"ES512", (Object)"secp521r1")};
        ecdsaCurveMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

