/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.math;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.leon.ConstantsKt;
import me.leon.ctf.rsa.FactorsKt;
import me.leon.domain.FactorDbResponse;
import me.leon.ext.GsonUtilKt;
import me.leon.ext.NetKt;
import me.leon.ext.math.Kgcd;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\"\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u001a0\u0017*\b\u0012\u0004\u0012\u00020\u00010\u0013\u001a\u001a\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u001a\u0010\u001e\u001a\u00020\u0015*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020 \u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013*\u00020\u0001\u001a\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010#*\u00020\u00012\u0006\u0010$\u001a\u00020\u0001\u00a2\u0006\u0002\u0010%\u001a\u0012\u0010&\u001a\u00020\u0001*\u00020\u00012\u0006\u0010'\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\u0001*\u00020\u00012\u0006\u0010$\u001a\u00020\u0001\u001a\u0012\u0010)\u001a\u00020\u0001*\u00020\u00012\u0006\u0010*\u001a\u00020\u0001\u001a\u0012\u0010+\u001a\u00020,*\u00020\u00012\u0006\u0010$\u001a\u00020\u0001\u001a\n\u0010-\u001a\u00020\u0015*\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\u0001*\u00020\u00012\u0006\u0010.\u001a\u00020\u0001\u001a\u0010\u0010'\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0013\u001a\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013*\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u00100\u001a\u00020\u0001\u001a\n\u00101\u001a\u00020\u0001*\u00020\u0001\u001a\u0010\u00102\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0013\u001a\u0018\u00103\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0014\u00104\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u00105\u001a\u00020\u0001\u001a\u001f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00010#*\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020 \u00a2\u0006\u0002\u00107\u001a\n\u00108\u001a\u00020\u0001*\u00020\u0015\u001a\n\u00109\u001a\u00020\u0001*\u00020:\u001a\u0014\u0010;\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0014\u0010<\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0003\"\u0011\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0003\u00a8\u0006="}, d2={"EIGHT", "Ljava/math/BigInteger;", "getEIGHT", "()Ljava/math/BigInteger;", "FIVE", "getFIVE", "FOUR", "getFOUR", "MAP", "", "getMAP", "()Ljava/util/Map;", "RANDOM", "Ljava/util/Random;", "SEVEN", "getSEVEN", "SIX", "getSIX", "getPrimeFromFactorDb", "", "digit", "", "continuedFraction", "", "another", "convergent", "Lkotlin/Pair;", "decrypt", "d", "n", "decrypt2String", "eulerPhi", "", "factorDb", "gcdExt", "", "other", "(Ljava/math/BigInteger;Ljava/math/BigInteger;)[Ljava/math/BigInteger;", "invert", "phi", "lcm", "multiplyInverse", "modular", "mutualPrime", "", "n2s", "q", "phiMutualPrime", "e", "preProbablePrime", "product", "propN", "random", "from", "root", "(Ljava/math/BigInteger;I)[Ljava/math/BigInteger;", "s2n", "toBigInteger", "", "wiener", "wienerPQ", "app"})
@SourceDebugExtension(value={"SMAP\nBigInteger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BigInteger.kt\nme/leon/ext/math/BigIntegerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,297:1\n1#2:298\n766#3:299\n857#3,2:300\n1477#3:302\n1502#3,3:303\n1505#3,3:313\n2661#3,7:320\n766#3:327\n857#3,2:328\n2661#3,7:330\n766#3:337\n857#3,2:338\n1789#3,3:340\n372#4,7:306\n125#5:316\n152#5,3:317\n*S KotlinDebug\n*F\n+ 1 BigInteger.kt\nme/leon/ext/math/BigIntegerKt\n*L\n43#1:299\n43#1:300,2\n44#1:302\n44#1:303,3\n44#1:313,3\n46#1:320,7\n48#1:327\n48#1:328,2\n52#1:330,7\n55#1:337\n55#1:338,2\n55#1:340,3\n44#1:306,7\n45#1:316\n45#1:317,3\n*E\n"})
public final class BigIntegerKt {
    @NotNull
    private static final Random RANDOM = new Random();
    @NotNull
    private static final BigInteger FOUR;
    @NotNull
    private static final BigInteger FIVE;
    @NotNull
    private static final BigInteger SIX;
    @NotNull
    private static final BigInteger SEVEN;
    @NotNull
    private static final BigInteger EIGHT;
    @NotNull
    private static final Map<BigInteger, BigInteger> MAP;

    @NotNull
    public static final BigInteger phi(@NotNull BigInteger $this$phi, @NotNull BigInteger q) {
        Intrinsics.checkNotNullParameter((Object)$this$phi, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        BigInteger bigInteger = $this$phi;
        BigInteger bigInteger2 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"subtract(...)");
        bigInteger = bigInteger3;
        BigInteger bigInteger4 = q;
        BigInteger bigInteger5 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ONE");
        BigInteger bigInteger6 = bigInteger4.subtract(bigInteger5);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"subtract(...)");
        bigInteger4 = bigInteger6;
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger4);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"multiply(...)");
        return bigInteger7;
    }

    @NotNull
    public static final BigInteger lcm(@NotNull BigInteger $this$lcm, @NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)$this$lcm, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        BigInteger bigInteger = $this$lcm.multiply(other);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"multiply(...)");
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = $this$lcm.gcd(other);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"gcd(...)");
        BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"divide(...)");
        return bigInteger4;
    }

    public static final boolean mutualPrime(@NotNull BigInteger $this$mutualPrime, @NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)$this$mutualPrime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$mutualPrime.gcd(other), (Object)BigInteger.ONE);
    }

    @NotNull
    public static final BigInteger invert(@NotNull BigInteger $this$invert, @NotNull BigInteger phi) {
        Intrinsics.checkNotNullParameter((Object)$this$invert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)phi, (String)"phi");
        BigInteger bigInteger = $this$invert.modInverse(phi);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modInverse(...)");
        return bigInteger;
    }

    @NotNull
    public static final BigInteger[] gcdExt(@NotNull BigInteger $this$gcdExt, @NotNull BigInteger other) {
        Intrinsics.checkNotNullParameter((Object)$this$gcdExt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Kgcd.INSTANCE.gcdext($this$gcdExt, other);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decrypt2String(@NotNull BigInteger $this$decrypt2String, @NotNull BigInteger d, @NotNull BigInteger n) {
        Object object;
        block3: {
            void var3_3;
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$decrypt2String, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                BigInteger bigInteger = $this$decrypt2String.modPow(d, n);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modPow(...)");
                String $this$decrypt2String_u24lambda_u241 = BigIntegerKt.n2s(bigInteger);
                boolean bl = false;
                object = Regex.find$default((Regex)ConstantsKt.getREG_NON_PRINTABLE(), (CharSequence)$this$decrypt2String_u24lambda_u241, (int)0, (int)2, null);
                if (object == null) break block2;
                MatchResult $this$decrypt2String_u24lambda_u241_u24lambda_u240 = object;
                boolean bl2 = false;
                String string = $this$decrypt2String.modPow(d, n).toString();
                object = string;
                if (string != null) break block3;
            }
            object = var3_3;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"with(...)");
        return object;
    }

    @NotNull
    public static final BigInteger decrypt(@NotNull BigInteger $this$decrypt, @NotNull BigInteger d, @NotNull BigInteger n) {
        Intrinsics.checkNotNullParameter((Object)$this$decrypt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        BigInteger bigInteger = $this$decrypt.modPow(d, n);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"modPow(...)");
        return bigInteger;
    }

    @NotNull
    public static final String n2s(@NotNull BigInteger $this$n2s) {
        Intrinsics.checkNotNullParameter((Object)$this$n2s, (String)"<this>");
        byte[] byArray = $this$n2s.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return StringsKt.decodeToString((byte[])byArray);
    }

    @NotNull
    public static final BigInteger s2n(@NotNull String $this$s2n) {
        Intrinsics.checkNotNullParameter((Object)$this$s2n, (String)"<this>");
        String string = $this$s2n;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new BigInteger(byArray);
    }

    @NotNull
    public static final BigInteger toBigInteger(@NotNull byte[] $this$toBigInteger) {
        Intrinsics.checkNotNullParameter((Object)$this$toBigInteger, (String)"<this>");
        return new BigInteger($this$toBigInteger);
    }

    @NotNull
    public static final List<BigInteger> factorDb(@NotNull BigInteger $this$factorDb) {
        Intrinsics.checkNotNullParameter((Object)$this$factorDb, (String)"<this>");
        return BigIntegerKt.getPrimeFromFactorDb($this$factorDb);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger phi(@NotNull List<? extends BigInteger> $this$phi) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Object $this$groupByTo$iv$iv;
        boolean bl;
        BigInteger it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$phi, (String)"<this>");
        Iterable $this$filter$iv = $this$phi;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (BigInteger)t;
            bl = false;
            if (!(it.compareTo(BigInteger.ZERO) > 0)) continue;
            destination$iv$iv.add(t);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t = iterator.next();
            it = (BigInteger)t;
            bl = false;
            BigInteger key$iv$iv = it;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = entry;
            Object object = destination$iv$iv;
            bl = false;
            object.add(BigIntegerKt.eulerPhi((BigInteger)it.getKey(), ((List)it.getValue()).size()));
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void phi;
            BigInteger $i$f$mapTo22 = (BigInteger)iterator$iv.next();
            BigInteger acc = (BigInteger)accumulator$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.multiply((BigInteger)phi), (String)"multiply(...)");
        }
        return (BigInteger)accumulator$iv;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<BigInteger> phiMutualPrime(@NotNull List<? extends BigInteger> $this$phiMutualPrime, @NotNull BigInteger e) {
        Intrinsics.checkNotNullParameter($this$phiMutualPrime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $this$filter$iv = $this$phiMutualPrime;
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (BigInteger)element$iv$iv;
            $i$a$-filter-BigIntegerKt$phiMutualPrime$1 = false;
            if (it.compareTo(BigInteger.ZERO) <= 0) ** GOTO lbl-1000
            var11_11 = it;
            v0 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ONE");
            v1 = var11_11.subtract(v0);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"subtract(...)");
            if (Intrinsics.areEqual((Object)e.gcd(v1), (Object)BigInteger.ONE)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger product(@NotNull List<? extends BigInteger> $this$product) {
        Intrinsics.checkNotNullParameter($this$product, (String)"<this>");
        Iterable $this$reduce$iv = $this$product;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void intVal;
            BigInteger bigInteger = (BigInteger)iterator$iv.next();
            BigInteger acc = (BigInteger)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.multiply((BigInteger)intVal), (String)"multiply(...)");
        }
        return (BigInteger)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BigInteger propN(@NotNull List<? extends BigInteger> $this$propN, @NotNull BigInteger n) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$propN, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Iterable $this$filter$iv = $this$propN;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BigInteger it = (BigInteger)element$iv$iv;
            boolean bl = false;
            if (!(it.compareTo(BigInteger.ZERO) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$fold$iv = (List)destination$iv$iv;
        boolean $i$f$fold = false;
        BigInteger accumulator$iv = n;
        for (Object element$iv : $this$fold$iv) {
            void bigInteger;
            BigInteger bigInteger2 = (BigInteger)element$iv;
            BigInteger acc = accumulator$iv;
            boolean bl = false;
            BigInteger bigInteger3 = acc;
            BigInteger bigInteger4 = bigInteger.abs();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"abs(...)");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3.divide(bigInteger4), (String)"divide(...)");
        }
        return accumulator$iv;
    }

    @NotNull
    public static final BigInteger eulerPhi(@NotNull BigInteger $this$eulerPhi, int n) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$eulerPhi, (String)"<this>");
        if (n == 1) {
            BigInteger bigInteger2 = $this$eulerPhi;
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
            bigInteger = bigInteger4;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"subtract(...)");
        } else {
            BigInteger bigInteger5 = $this$eulerPhi;
            BigInteger bigInteger6 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"ONE");
            BigInteger bigInteger7 = bigInteger5.subtract(bigInteger6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"subtract(...)");
            bigInteger5 = bigInteger7;
            BigInteger bigInteger8 = $this$eulerPhi.pow(n - 1);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"pow(...)");
            BigInteger bigInteger9 = bigInteger5.multiply(bigInteger8);
            bigInteger = bigInteger9;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"multiply(...)");
        }
        return bigInteger;
    }

    @NotNull
    public static final List<BigInteger> getPrimeFromFactorDb(@NotNull BigInteger digit) {
        Intrinsics.checkNotNullParameter((Object)digit, (String)"digit");
        String string = digit.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return BigIntegerKt.getPrimeFromFactorDb(string);
    }

    @NotNull
    public static final List<BigInteger> getPrimeFromFactorDb(@NotNull String digit) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)digit, (String)"digit");
        try {
            boolean bl = false;
            object2 = Result.constructor-impl(GsonUtilKt.fromJson(NetKt.readFromNet$default("http://factordb.com/api?query=" + digit, null, 3000, 1, null), FactorDbResponse.class).getFactorList());
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            Object[] objectArray = new BigInteger[]{new BigInteger(digit).negate()};
            object = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        return (List)object;
    }

    @NotNull
    public static final BigInteger[] root(@NotNull BigInteger $this$root, int n) {
        BigInteger it;
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$root, (String)"<this>");
        if (!(n > 0)) {
            boolean $i$a$-require-BigIntegerKt$root$32 = false;
            String $i$a$-require-BigIntegerKt$root$32 = "n must be > 0";
            throw new IllegalArgumentException($i$a$-require-BigIntegerKt$root$32.toString());
        }
        if (!($this$root.signum() >= 0 || $this$root.signum() < 0 && n % 2 != 0)) {
            boolean $i$a$-require-BigIntegerKt$root$42 = false;
            String $i$a$-require-BigIntegerKt$root$42 = $this$root + "  n =" + n + " must be even";
            throw new IllegalArgumentException($i$a$-require-BigIntegerKt$root$42.toString());
        }
        int sig = $this$root.signum();
        BigInteger v = $this$root.abs();
        BigInteger high = BigInteger.ONE;
        while (high.pow(n).compareTo(v) <= 0) {
            high = high.shiftLeft(1);
        }
        BigInteger low = high.shiftRight(1);
        BigInteger mid = BigInteger.ONE;
        int midCount = 0;
        while (low.compareTo(high) < 0) {
            bigInteger = low;
            Intrinsics.checkNotNull((Object)bigInteger);
            BigInteger bigInteger2 = high;
            Intrinsics.checkNotNull((Object)bigInteger2);
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"add(...)");
            mid = bigInteger3.shiftRight(1);
            if (low.compareTo(mid) < 0 && mid.pow(n).compareTo(v) <= 0) {
                low = mid;
            } else if (high.compareTo(mid) > 0 && mid.pow(n).compareTo(v) >= 0) {
                high = mid;
            } else {
                it = bigInteger = mid;
                boolean bl = false;
                ++midCount;
            }
            if (midCount <= true) continue;
        }
        bigInteger = mid;
        Intrinsics.checkNotNull((Object)bigInteger);
        BigInteger bigInteger4 = BigInteger.valueOf(sig);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
        it = bigInteger4;
        BigInteger bigInteger5 = bigInteger.multiply(it);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"multiply(...)");
        BigInteger $this$root_u24lambda_u2415 = bigInteger5;
        boolean bl = false;
        BigInteger[] bigIntegerArray = new BigInteger[2];
        bigIntegerArray[0] = $this$root_u24lambda_u2415;
        BigInteger bigInteger6 = $this$root;
        BigInteger bigInteger7 = $this$root_u24lambda_u2415.pow(n);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"pow(...)");
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6.subtract(bigInteger7), (String)"subtract(...)");
        return bigIntegerArray;
    }

    public static /* synthetic */ BigInteger[] root$default(BigInteger bigInteger, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return BigIntegerKt.root(bigInteger, n);
    }

    @NotNull
    public static final List<BigInteger> continuedFraction(@NotNull BigInteger $this$continuedFraction, @NotNull BigInteger another) {
        Intrinsics.checkNotNullParameter((Object)$this$continuedFraction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        BigInteger a = null;
        a = $this$continuedFraction;
        List list = new ArrayList();
        BigInteger b = null;
        b = another;
        while (!Intrinsics.areEqual((Object)b, (Object)BigInteger.ZERO)) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = a.divide(b);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"divide(...)");
            list.add(bigInteger2);
            BigInteger it = bigInteger = b;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)a.remainder(b), (String)"remainder(...)");
            a = bigInteger;
        }
        return list;
    }

    @NotNull
    public static final List<Pair<BigInteger, BigInteger>> convergent(@NotNull List<? extends BigInteger> $this$convergent) {
        Intrinsics.checkNotNullParameter($this$convergent, (String)"<this>");
        Pair pair = TuplesKt.to((Object)BigInteger.ZERO, (Object)BigInteger.ONE);
        Object pbe = null;
        pbe = pair.component1();
        Object paf = null;
        paf = pair.component2();
        Pair pair2 = TuplesKt.to((Object)BigInteger.ONE, (Object)BigInteger.ZERO);
        Object qbe = null;
        qbe = pair2.component1();
        Object qaf = null;
        qaf = pair2.component2();
        List convergent = new ArrayList();
        for (BigInteger bigInteger : $this$convergent) {
            Object object = paf;
            BigInteger it = (BigInteger)object;
            boolean bl = false;
            BigInteger bigInteger2 = bigInteger;
            Object object2 = paf;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
            BigInteger bigInteger3 = bigInteger2.multiply((BigInteger)object2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"multiply(...)");
            bigInteger2 = bigInteger3;
            Object object3 = pbe;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"element");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.add((BigInteger)object3), (String)"add(...)");
            pbe = object;
            object = qaf;
            it = (BigInteger)object;
            boolean bl2 = false;
            bigInteger2 = bigInteger;
            Object object4 = qaf;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"element");
            BigInteger bigInteger4 = bigInteger2.multiply((BigInteger)object4);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"multiply(...)");
            bigInteger2 = bigInteger4;
            Object object5 = qbe;
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"element");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.add((BigInteger)object5), (String)"add(...)");
            qbe = object;
            convergent.add(TuplesKt.to((Object)paf, (Object)qaf));
        }
        return convergent;
    }

    @Nullable
    public static final BigInteger wiener(@NotNull BigInteger $this$wiener, @NotNull BigInteger n) {
        Intrinsics.checkNotNullParameter((Object)$this$wiener, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        System.out.println((Object)"wiener attack-");
        BigInteger wienerPQ = BigIntegerKt.wienerPQ($this$wiener, n);
        if (wienerPQ != null) {
            return wienerPQ;
        }
        System.out.println((Object)"wiener attack slow");
        BigInteger q0 = BigInteger.ONE;
        BigInteger m = FactorsKt.getTWO();
        BigInteger c1 = m.modPow($this$wiener, n);
        List<Pair<BigInteger, BigInteger>> convergent = BigIntegerKt.convergent(BigIntegerKt.continuedFraction($this$wiener, n));
        Iterator<Pair<BigInteger, BigInteger>> iterator = convergent.iterator();
        while (iterator.hasNext()) {
            BigInteger q1 = (BigInteger)iterator.next().component2();
            for (int r2 = 0; r2 < 21; ++r2) {
                for (int s = 0; s < 21; ++s) {
                    BigInteger d;
                    BigInteger bigInteger;
                    BigInteger bigInteger2 = BigInteger.valueOf(r2);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2.multiply(q1), (String)"multiply(...)");
                    BigInteger bigInteger3 = BigInteger.valueOf(s);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
                    BigInteger bigInteger4 = bigInteger3;
                    BigInteger bigInteger5 = q0;
                    Intrinsics.checkNotNull((Object)bigInteger5);
                    BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"multiply(...)");
                    bigInteger4 = bigInteger6;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger.add(bigInteger4), (String)"add(...)");
                    BigInteger m1 = c1.modPow(d, n);
                    if (!Intrinsics.areEqual((Object)m1, (Object)m)) continue;
                    System.out.println((Object)("" + r2 + ' ' + s + ' ' + d));
                    return d;
                }
            }
            q0 = q1;
        }
        return null;
    }

    @Nullable
    public static final BigInteger wienerPQ(@NotNull BigInteger $this$wienerPQ, @NotNull BigInteger n) {
        block4: {
            BigInteger subtract;
            Object[] root2;
            BigInteger q0;
            Intrinsics.checkNotNullParameter((Object)$this$wienerPQ, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)n, (String)"n");
            System.out.println((Object)"wiener attack pq");
            if ($this$wienerPQ.compareTo(n.pow(2).multiply((BigInteger)ArraysKt.first((Object[])BigIntegerKt.root$default(n, 0, 1, null)))) > 0) {
                System.out.println((Object)"e > n^(1.5) -> this is not guaranteed to work");
            }
            BigInteger x = $this$wienerPQ;
            BigInteger y = n;
            BigInteger guessK = null;
            BigInteger guessDg = null;
            BigInteger guessD = null;
            BigInteger bigInteger = x.divide(y);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"divide(...)");
            BigInteger n0 = q0 = bigInteger;
            BigInteger d0 = BigInteger.ONE;
            BigInteger temp = x;
            x = y;
            BigInteger bigInteger2 = temp.add(y.multiply(q0).negate());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
            y = bigInteger2;
            BigInteger bigInteger3 = x.divide(y);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"divide(...)");
            BigInteger qI = bigInteger3;
            BigInteger bigInteger4 = q0.multiply(qI);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"multiply(...)");
            BigInteger bigInteger5 = bigInteger4;
            BigInteger bigInteger6 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"ONE");
            BigInteger bigInteger7 = bigInteger5.add(bigInteger6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"add(...)");
            BigInteger n1 = bigInteger7;
            BigInteger d1 = qI;
            BigInteger dI2 = d0;
            BigInteger dI1 = d1;
            BigInteger dI = null;
            BigInteger nI2 = n0;
            BigInteger nI1 = n1;
            BigInteger nI = null;
            int i = 1;
            long startTime = System.currentTimeMillis();
            do {
                BigInteger pPlusQDiv2;
                BigInteger phiN;
                BigInteger bigInteger8;
                BigInteger bigInteger9 = y.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"negate(...)");
                BigInteger bigInteger10 = bigInteger9.multiply(qI);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"multiply(...)");
                if (x.add(bigInteger10).signum() == 0 || System.currentTimeMillis() - startTime >= 500L) break block4;
                ++i;
                temp = x;
                x = y;
                BigInteger bigInteger11 = y.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"negate(...)");
                BigInteger bigInteger12 = bigInteger11.multiply(qI);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"multiply(...)");
                Intrinsics.checkNotNullExpressionValue((Object)temp.add(bigInteger12), (String)"add(...)");
                Intrinsics.checkNotNullExpressionValue((Object)x.divide(y), (String)"divide(...)");
                Intrinsics.checkNotNullExpressionValue((Object)qI.multiply(dI1), (String)"multiply(...)");
                BigInteger bigInteger13 = dI2;
                Intrinsics.checkNotNull((Object)bigInteger13);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger8.add(bigInteger13), (String)"add(...)");
                BigInteger bigInteger14 = qI.multiply(nI1);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger14, (String)"multiply(...)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger14.add(nI2), (String)"add(...)");
                dI2 = dI1;
                dI1 = dI;
                nI2 = nI1;
                nI1 = nI;
                if (i % 2 == 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)nI1.add(nI2), (String)"add(...)");
                    bigInteger8 = dI1;
                    bigInteger13 = dI2;
                    Intrinsics.checkNotNull((Object)bigInteger13);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger8.add(bigInteger13), (String)"add(...)");
                } else {
                    guessK = nI1;
                    guessDg = dI1;
                }
                BigInteger bigInteger15 = $this$wienerPQ.multiply(guessDg);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger15, (String)"multiply(...)");
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger15.divide(guessK), (String)"divide(...)");
                BigInteger bigInteger16 = n.subtract(phiN);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger16, (String)"subtract(...)");
                BigInteger bigInteger17 = bigInteger16;
                BigInteger bigInteger18 = BigInteger.ONE;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger18, (String)"ONE");
                BigInteger bigInteger19 = bigInteger17.add(bigInteger18);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger19, (String)"add(...)");
                bigInteger17 = bigInteger19;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger17.divide(FactorsKt.getTWO()), (String)"divide(...)");
                subtract = pPlusQDiv2.pow(2).subtract(n);
                if (subtract.compareTo(BigInteger.ZERO) < 0) break block4;
                Intrinsics.checkNotNull((Object)subtract);
            } while (!Intrinsics.areEqual((Object)ArraysKt.last((Object[])(root2 = BigIntegerKt.root$default(subtract, 0, 1, null))), (Object)BigInteger.ZERO));
            BigInteger bigInteger20 = $this$wienerPQ.multiply(guessDg);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger20, (String)"multiply(...)");
            BigInteger bigInteger21 = bigInteger20.remainder(guessK);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger21, (String)"remainder(...)");
            BigInteger bigInteger22 = guessDg.divide(bigInteger21);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger22, (String)"divide(...)");
            guessD = bigInteger22;
            System.out.println((Object)"Success");
            return guessD;
        }
        return null;
    }

    @NotNull
    public static final BigInteger multiplyInverse(@NotNull BigInteger $this$multiplyInverse, @NotNull BigInteger modular) {
        Intrinsics.checkNotNullParameter((Object)$this$multiplyInverse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modular, (String)"modular");
        BigInteger[] bigIntegerArray = BigIntegerKt.gcdExt($this$multiplyInverse, modular);
        BigInteger gcd = bigIntegerArray[0];
        BigInteger x = bigIntegerArray[1];
        if (!Intrinsics.areEqual((Object)gcd, (Object)BigInteger.ONE)) {
            boolean bl = false;
            String string = "has no multiplicative inverse";
            throw new IllegalArgumentException(string.toString());
        }
        BigInteger bigInteger = x.mod(modular);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"mod(...)");
        return bigInteger;
    }

    @NotNull
    public static final BigInteger random(@NotNull BigInteger $this$random, @NotNull BigInteger from) {
        Intrinsics.checkNotNullParameter((Object)$this$random, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        int bits = $this$random.bitLength();
        BigInteger r2 = new BigInteger(bits, RANDOM);
        while (r2.compareTo(from) < 0 || r2.compareTo($this$random) > 0) {
            r2 = new BigInteger(bits, RANDOM);
        }
        return r2;
    }

    public static /* synthetic */ BigInteger random$default(BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
        if ((n & 1) != 0) {
            BigInteger bigInteger3 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
            bigInteger2 = bigInteger3;
        }
        return BigIntegerKt.random(bigInteger, bigInteger2);
    }

    @NotNull
    public static final BigInteger getFOUR() {
        return FOUR;
    }

    @NotNull
    public static final BigInteger getFIVE() {
        return FIVE;
    }

    @NotNull
    public static final BigInteger getSIX() {
        return SIX;
    }

    @NotNull
    public static final BigInteger getSEVEN() {
        return SEVEN;
    }

    @NotNull
    public static final BigInteger getEIGHT() {
        return EIGHT;
    }

    @NotNull
    public static final Map<BigInteger, BigInteger> getMAP() {
        return MAP;
    }

    @NotNull
    public static final BigInteger preProbablePrime(@NotNull BigInteger $this$preProbablePrime) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$preProbablePrime, (String)"<this>");
        if ($this$preProbablePrime.compareTo(EIGHT) < 0) {
            BigInteger bigInteger2 = MAP.get($this$preProbablePrime);
            Intrinsics.checkNotNull((Object)bigInteger2);
            return bigInteger2;
        }
        BigInteger pre = null;
        BigInteger bigInteger3 = $this$preProbablePrime.divide(SIX);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"divide(...)");
        BigInteger bigInteger4 = bigInteger3.multiply(SIX);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"multiply(...)");
        BigInteger nn = bigInteger4;
        BigInteger bigInteger5 = $this$preProbablePrime.subtract(nn);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"subtract(...)");
        if (bigInteger5.compareTo(BigInteger.ONE) <= 0) {
            bigInteger = nn;
            BigInteger bigInteger6 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"ONE");
            BigInteger bigInteger7 = bigInteger.subtract(bigInteger6);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"subtract(...)");
            pre = bigInteger7;
            if (pre.isProbablePrime(100)) {
                return pre;
            }
            BigInteger bigInteger8 = pre.subtract(FOUR);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"subtract(...)");
            pre = bigInteger8;
        } else {
            bigInteger = nn;
            BigInteger bigInteger9 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"ONE");
            BigInteger bigInteger10 = bigInteger.add(bigInteger9);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"add(...)");
            pre = bigInteger10;
        }
        while (!pre.isProbablePrime(100)) {
            BigInteger bigInteger11 = pre.subtract(FactorsKt.getTWO());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger11, (String)"subtract(...)");
            pre = bigInteger11;
            if (pre.isProbablePrime(100)) break;
            BigInteger bigInteger12 = pre.subtract(FOUR);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger12, (String)"subtract(...)");
            pre = bigInteger12;
        }
        return pre;
    }

    static {
        BigInteger bigInteger = BigInteger.valueOf(4);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        FOUR = bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(5);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        FIVE = bigInteger2;
        BigInteger bigInteger3 = BigInteger.valueOf(6);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"valueOf(...)");
        SIX = bigInteger3;
        BigInteger bigInteger4 = BigInteger.valueOf(7);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"valueOf(...)");
        SEVEN = bigInteger4;
        BigInteger bigInteger5 = BigInteger.valueOf(8);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"valueOf(...)");
        EIGHT = bigInteger5;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FactorsKt.getTHREE(), (Object)FactorsKt.getTWO()), TuplesKt.to((Object)FOUR, (Object)FactorsKt.getTHREE()), TuplesKt.to((Object)FIVE, (Object)FactorsKt.getTHREE()), TuplesKt.to((Object)SIX, (Object)FIVE), TuplesKt.to((Object)SEVEN, (Object)FIVE)};
        MAP = MapsKt.mapOf((Pair[])pairArray);
    }
}

