/*
 * Decompiled with CFR 0.152.
 */
package me.leon.ext.voice;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.SourceDataLine;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import me.leon.ext.FileKt;
import me.leon.ext.NetKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\u001a2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u001c2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001c2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006%"}, d2={"Lme/leon/ext/voice/Audio;", "", "()V", "AAC", "Ljavax/sound/sampled/AudioFormat$Encoding;", "getAAC", "()Ljavax/sound/sampled/AudioFormat$Encoding;", "APE", "getAPE", "MPEG1L3", "getMPEG1L3", "MPEG2L3", "getMPEG2L3", "SPEEX", "getSPEEX", "VORBISENC", "getVORBISENC", "play", "Ljavax/sound/sampled/SourceDataLine;", "file", "Ljava/io/File;", "isAsync", "", "stream", "Ljava/io/InputStream;", "playAudioStream", "Ljavax/sound/sampled/AudioInputStream;", "playFromFile", "", "playFromUrl", "url", "writeData", "", "audioFormat", "Ljavax/sound/sampled/AudioFormat;", "srcDataLine", "ais", "app"})
@SourceDebugExtension(value={"SMAP\nAudio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Audio.kt\nme/leon/ext/voice/Audio\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class Audio {
    @NotNull
    public static final Audio INSTANCE = new Audio();
    @NotNull
    private static final AudioFormat.Encoding MPEG2L3 = new AudioFormat.Encoding("MPEG2L3");
    @NotNull
    private static final AudioFormat.Encoding MPEG1L3 = new AudioFormat.Encoding("MPEG1L3");
    @NotNull
    private static final AudioFormat.Encoding APE = new AudioFormat.Encoding("APE");
    @NotNull
    private static final AudioFormat.Encoding VORBISENC = new AudioFormat.Encoding("VORBISENC");
    @NotNull
    private static final AudioFormat.Encoding AAC = new AudioFormat.Encoding("AAC");
    @NotNull
    private static final AudioFormat.Encoding SPEEX = new AudioFormat.Encoding("SPEEX");

    private Audio() {
    }

    @NotNull
    public final AudioFormat.Encoding getMPEG2L3() {
        return MPEG2L3;
    }

    @NotNull
    public final AudioFormat.Encoding getMPEG1L3() {
        return MPEG1L3;
    }

    @NotNull
    public final AudioFormat.Encoding getAPE() {
        return APE;
    }

    @NotNull
    public final AudioFormat.Encoding getVORBISENC() {
        return VORBISENC;
    }

    @NotNull
    public final AudioFormat.Encoding getAAC() {
        return AAC;
    }

    @NotNull
    public final AudioFormat.Encoding getSPEEX() {
        return SPEEX;
    }

    @Nullable
    public final SourceDataLine playFromUrl(@NotNull String url, boolean isAsync) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ByteArrayInputStream it = new ByteArrayInputStream(NetKt.readBytesFromNet$default(url, null, 0, null, null, 15, null));
        boolean bl = false;
        return INSTANCE.play(it, isAsync);
    }

    public static /* synthetic */ SourceDataLine playFromUrl$default(Audio audio, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return audio.playFromUrl(string, bl);
    }

    @Nullable
    public final SourceDataLine playFromFile(@NotNull String file, boolean isAsync) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.play(FileKt.toFile(file), isAsync);
    }

    public static /* synthetic */ SourceDataLine playFromFile$default(Audio audio, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return audio.playFromFile(string, bl);
    }

    @Nullable
    public final SourceDataLine play(@NotNull File file, boolean isAsync) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        Intrinsics.checkNotNullExpressionValue((Object)audioInputStream, (String)"getAudioInputStream(...)");
        return this.playAudioStream(audioInputStream, isAsync);
    }

    public static /* synthetic */ SourceDataLine play$default(Audio audio, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return audio.play(file, bl);
    }

    @Nullable
    public final SourceDataLine play(@Nullable InputStream stream, boolean isAsync) {
        if (stream == null || stream.available() == 0) {
            return null;
        }
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(stream);
        Intrinsics.checkNotNullExpressionValue((Object)audioInputStream, (String)"getAudioInputStream(...)");
        return this.playAudioStream(audioInputStream, isAsync);
    }

    public static /* synthetic */ SourceDataLine play$default(Audio audio, InputStream inputStream, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return audio.play(inputStream, bl);
    }

    @Nullable
    public final SourceDataLine playAudioStream(@NotNull AudioInputStream stream, boolean isAsync) {
        AudioFormat newFormat;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Ref.ObjectRef ais = new Ref.ObjectRef();
        ais.element = stream;
        Ref.ObjectRef audioFormat = new Ref.ObjectRef();
        audioFormat.element = ((AudioInputStream)ais.element).getFormat();
        System.out.println((Object)("Format: " + audioFormat.element + ", BigEndian " + ((AudioFormat)audioFormat.element).isBigEndian()));
        if (((AudioFormat)audioFormat.element).getEncoding() == AudioFormat.Encoding.ULAW || ((AudioFormat)audioFormat.element).getEncoding() == AudioFormat.Encoding.ALAW) {
            newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)audioFormat.element).getSampleRate(), ((AudioFormat)audioFormat.element).getSampleSizeInBits() * 2, ((AudioFormat)audioFormat.element).getChannels(), ((AudioFormat)audioFormat.element).getFrameSize() * 2, ((AudioFormat)audioFormat.element).getFrameRate(), true);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(newFormat, (AudioInputStream)ais.element);
            Intrinsics.checkNotNullExpressionValue((Object)audioInputStream, (String)"getAudioInputStream(...)");
            ais.element = audioInputStream;
            audioFormat.element = newFormat;
        } else {
            newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, ((AudioFormat)audioFormat.element).getSampleRate(), 16, ((AudioFormat)audioFormat.element).getChannels(), ((AudioFormat)audioFormat.element).getChannels() * 2, ((AudioFormat)audioFormat.element).getSampleRate(), false);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(newFormat, (AudioInputStream)ais.element);
            Intrinsics.checkNotNullExpressionValue((Object)audioInputStream, (String)"getAudioInputStream(...)");
            ais.element = audioInputStream;
            audioFormat.element = newFormat;
        }
        DataLine.Info dataLine = new DataLine.Info(SourceDataLine.class, (AudioFormat)audioFormat.element);
        if (!AudioSystem.isLineSupported(dataLine)) {
            System.out.println((Object)("!!! not supported " + dataLine));
            return null;
        }
        System.out.println((Object)("==> supported " + dataLine));
        Line line = AudioSystem.getLine(dataLine);
        Intrinsics.checkNotNull((Object)line, (String)"null cannot be cast to non-null type javax.sound.sampled.SourceDataLine");
        SourceDataLine srcDataLine = (SourceDataLine)line;
        srcDataLine.open((AudioFormat)audioFormat.element);
        srcDataLine.start();
        srcDataLine.addLineListener(arg_0 -> Audio.playAudioStream$lambda$1(srcDataLine, arg_0));
        if (isAsync) {
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<AudioFormat>)audioFormat, srcDataLine, (Ref.ObjectRef<AudioInputStream>)ais){
                final /* synthetic */ Ref.ObjectRef<AudioFormat> $audioFormat;
                final /* synthetic */ SourceDataLine $srcDataLine;
                final /* synthetic */ Ref.ObjectRef<AudioInputStream> $ais;
                {
                    this.$audioFormat = $audioFormat;
                    this.$srcDataLine = $srcDataLine;
                    this.$ais = $ais;
                    super(0);
                }

                public final void invoke() {
                    Object object = this.$audioFormat.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
                    Audio.access$writeData(Audio.INSTANCE, (AudioFormat)object, this.$srcDataLine, (AudioInputStream)this.$ais.element);
                }
            }), (int)31, null);
        } else {
            Object object = audioFormat.element;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
            this.writeData((AudioFormat)object, srcDataLine, (AudioInputStream)ais.element);
        }
        return srcDataLine;
    }

    public static /* synthetic */ SourceDataLine playAudioStream$default(Audio audio, AudioInputStream audioInputStream, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return audio.playAudioStream(audioInputStream, bl);
    }

    private final void writeData(AudioFormat audioFormat, SourceDataLine srcDataLine, AudioInputStream ais) {
        int frameSize = audioFormat.getFrameSize();
        int bufferSize = srcDataLine.getBufferSize() / 8;
        int bufferLength = bufferSize * frameSize;
        byte[] soundData = new byte[bufferLength];
        int bytesLength = 0;
        while (true) {
            int n;
            int it = n = ais.read(soundData);
            boolean bl = false;
            bytesLength = it;
            if (n == -1) break;
            srcDataLine.write(soundData, 0, bytesLength);
        }
        srcDataLine.stop();
    }

    private static final void playAudioStream$lambda$1(SourceDataLine $srcDataLine, LineEvent it) {
        Intrinsics.checkNotNullParameter((Object)$srcDataLine, (String)"$srcDataLine");
        if (Intrinsics.areEqual((Object)it.getType(), (Object)LineEvent.Type.STOP)) {
            $srcDataLine.close();
        }
    }

    public static final /* synthetic */ void access$writeData(Audio $this, AudioFormat audioFormat, SourceDataLine srcDataLine, AudioInputStream ais) {
        $this.writeData(audioFormat, srcDataLine, ais);
    }
}

