/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.bcrypt;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/leon/hash/bcrypt/BCrypt;", "", "()V", "p", "", "s", "cryptRaw", "", "password", "salt", "logRounds", "", "signExtBug", "", "safety", "ekskey", "", "data", "key", "encipher", "lr", "off", "initKey", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nBCrypt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BCrypt.kt\nme/leon/hash/bcrypt/BCrypt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1831:1\n1#2:1832\n*E\n"})
public final class BCrypt {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int[] p;
    private int[] s;
    private static final int GENSALT_DEFAULT_LOG2_ROUNDS = 10;
    private static final int BCRYPT_SALT_LEN = 16;
    private static final int BLOWFISH_NUM_ROUNDS = 16;
    @NotNull
    private static final int[] P_orig;
    @NotNull
    private static final int[] S_orig;
    @NotNull
    private static final int[] bf_crypt_ciphertext;
    @NotNull
    private static final char[] base64_code;
    @NotNull
    private static final byte[] index_64;
    public static final int MIN_LOG_ROUNDS = 4;
    public static final int MAX_LOG_ROUNDS = 31;

    private final void encipher(int[] lr, int off) {
        int n = 0;
        int l = lr[off];
        int r2 = lr[off + 1];
        int[] nArray = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            nArray = null;
        }
        l ^= nArray[0];
        int i = 0;
        while (i <= 14) {
            int[] nArray2 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray2 = null;
            }
            n = nArray2[l >> 24 & 0xFF];
            int[] nArray3 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray3 = null;
            }
            n += nArray3[0x100 | l >> 16 & 0xFF];
            int[] nArray4 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray4 = null;
            }
            n ^= nArray4[0x200 | l >> 8 & 0xFF];
            int[] nArray5 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray5 = null;
            }
            n += nArray5[0x300 | l & 0xFF];
            int[] nArray6 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray6 = null;
            }
            r2 ^= n ^ nArray6[++i];
            int[] nArray7 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray7 = null;
            }
            n = nArray7[r2 >> 24 & 0xFF];
            int[] nArray8 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray8 = null;
            }
            n += nArray8[0x100 | r2 >> 16 & 0xFF];
            int[] nArray9 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray9 = null;
            }
            n ^= nArray9[0x200 | r2 >> 8 & 0xFF];
            int[] nArray10 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray10 = null;
            }
            n += nArray10[0x300 | r2 & 0xFF];
            int[] nArray11 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray11 = null;
            }
            l ^= n ^ nArray11[++i];
        }
        int[] nArray12 = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            nArray12 = null;
        }
        lr[off] = r2 ^ nArray12[17];
        lr[off + 1] = l;
    }

    private final void initKey() {
        this.p = (int[])P_orig.clone();
        this.s = (int[])S_orig.clone();
    }

    private final void key(byte[] key2, boolean signExtBug) {
        int i;
        int[] nArray = new int[]{0};
        int[] koffp = nArray;
        int[] nArray2 = new int[]{0, 0};
        int[] lr = nArray2;
        int[] nArray3 = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            nArray3 = null;
        }
        int plen = nArray3.length;
        int[] nArray4 = this.s;
        if (this.s == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"s");
            nArray4 = null;
        }
        int slen = nArray4.length;
        for (i = 0; i < plen; ++i) {
            if (!signExtBug) {
                int[] nArray5 = this.p;
                if (this.p == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    nArray5 = null;
                }
                int[] nArray6 = this.p;
                if (this.p == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                    nArray6 = null;
                }
                nArray5[i] = nArray6[i] ^ BCrypt.Companion.streamtoword(key2, koffp);
                continue;
            }
            int[] nArray7 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray7 = null;
            }
            int[] nArray8 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray8 = null;
            }
            nArray7[i] = nArray8[i] ^ BCrypt.Companion.streamtowordBug(key2, koffp);
        }
        for (i = 0; i < plen; i += 2) {
            this.encipher(lr, 0);
            int[] nArray9 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray9 = null;
            }
            nArray9[i] = lr[0];
            int[] nArray10 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray10 = null;
            }
            nArray10[i + 1] = lr[1];
        }
        for (i = 0; i < slen; i += 2) {
            this.encipher(lr, 0);
            int[] nArray11 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray11 = null;
            }
            nArray11[i] = lr[0];
            int[] nArray12 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray12 = null;
            }
            nArray12[i + 1] = lr[1];
        }
    }

    private final void ekskey(byte[] data, byte[] key2, boolean signExtBug, int safety) {
        int i;
        int[] nArray = new int[]{0};
        int[] koffp = nArray;
        int[] nArray2 = new int[]{0};
        int[] doffp = nArray2;
        int[] nArray3 = new int[]{0, 0};
        int[] lr = nArray3;
        int[] nArray4 = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            nArray4 = null;
        }
        int plen = nArray4.length;
        int[] nArray5 = this.s;
        if (this.s == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"s");
            nArray5 = null;
        }
        int slen = nArray5.length;
        int[] nArray6 = new int[]{0};
        int[] signp = nArray6;
        int diff = 0;
        for (i = 0; i < plen; ++i) {
            int[] words = BCrypt.Companion.streamtowords(key2, koffp, signp);
            diff |= words[0] ^ words[1];
            int[] nArray7 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray7 = null;
            }
            int[] nArray8 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray8 = null;
            }
            nArray7[i] = nArray8[i] ^ words[signExtBug ? 1 : 0];
        }
        int sign2 = signp[0];
        diff |= diff >> 16;
        diff &= 0xFFFF;
        sign2 <<= 9;
        sign2 &= ~(diff += 65535) & safety;
        int[] nArray9 = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            nArray9 = null;
        }
        int[] nArray10 = this.p;
        if (this.p == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"p");
            nArray10 = null;
        }
        nArray9[0] = nArray10[0] ^ sign2;
        for (i = 0; i < plen; i += 2) {
            lr[0] = lr[0] ^ BCrypt.Companion.streamtoword(data, doffp);
            lr[1] = lr[1] ^ BCrypt.Companion.streamtoword(data, doffp);
            this.encipher(lr, 0);
            int[] nArray11 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray11 = null;
            }
            nArray11[i] = lr[0];
            int[] nArray12 = this.p;
            if (this.p == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"p");
                nArray12 = null;
            }
            nArray12[i + 1] = lr[1];
        }
        for (i = 0; i < slen; i += 2) {
            lr[0] = lr[0] ^ BCrypt.Companion.streamtoword(data, doffp);
            lr[1] = lr[1] ^ BCrypt.Companion.streamtoword(data, doffp);
            this.encipher(lr, 0);
            int[] nArray13 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray13 = null;
            }
            nArray13[i] = lr[0];
            int[] nArray14 = this.s;
            if (this.s == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"s");
                nArray14 = null;
            }
            nArray14[i + 1] = lr[1];
        }
    }

    private final byte[] cryptRaw(byte[] password, byte[] salt, int logRounds, boolean signExtBug, int safety) {
        int i;
        int j = 0;
        int[] cdata = (int[])bf_crypt_ciphertext.clone();
        int clen = cdata.length;
        if (!(logRounds >= 4 && logRounds <= 31)) {
            boolean $i$a$-require-BCrypt$cryptRaw$32 = false;
            String $i$a$-require-BCrypt$cryptRaw$32 = "Bad number of rounds";
            throw new IllegalArgumentException($i$a$-require-BCrypt$cryptRaw$32.toString());
        }
        int rounds = 1 << logRounds;
        if (!(salt.length == 16)) {
            boolean $i$a$-require-BCrypt$cryptRaw$42 = false;
            String $i$a$-require-BCrypt$cryptRaw$42 = "Bad salt length";
            throw new IllegalArgumentException($i$a$-require-BCrypt$cryptRaw$42.toString());
        }
        this.initKey();
        this.ekskey(salt, password, signExtBug, safety);
        for (i = 0; i < rounds; ++i) {
            this.key(password, signExtBug);
            this.key(salt, false);
        }
        for (i = 0; i < 64; ++i) {
            for (j = 0; j < clen >> 1; ++j) {
                this.encipher(cdata, j << 1);
            }
        }
        byte[] ret = new byte[clen * 4];
        j = 0;
        for (i = 0; i < clen; ++i) {
            ret[j++] = (byte)(cdata[i] >> 24 & 0xFF);
            ret[j++] = (byte)(cdata[i] >> 16 & 0xFF);
            ret[j++] = (byte)(cdata[i] >> 8 & 0xFF);
            ret[j++] = (byte)(cdata[i] & 0xFF);
        }
        return ret;
    }

    @JvmStatic
    @NotNull
    public static final String hashpw(@NotNull String password, @Nullable String salt) {
        return Companion.hashpw(password, salt);
    }

    @JvmStatic
    @NotNull
    public static final String hashpw(@NotNull byte[] passwordb, @Nullable String salt) {
        return Companion.hashpw(passwordb, salt);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String genSalt(@NotNull String prefix, int logRounds, @NotNull SecureRandom random) throws IllegalArgumentException {
        return Companion.genSalt(prefix, logRounds, random);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String genSalt(@NotNull byte[] salt, @NotNull String prefix, int logRounds) throws IllegalArgumentException {
        return Companion.genSalt(salt, prefix, logRounds);
    }

    @JvmStatic
    public static final boolean checkPw(@NotNull String plaintext, @NotNull String hashed) {
        return Companion.checkPw(plaintext, hashed);
    }

    @JvmStatic
    public static final boolean checkPw(@NotNull byte[] password, @NotNull String hashed) {
        return Companion.checkPw(password, hashed);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String genSalt(@NotNull String prefix, int logRounds) throws IllegalArgumentException {
        return Companion.genSalt(prefix, logRounds);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String genSalt(@NotNull String prefix) throws IllegalArgumentException {
        return Companion.genSalt(prefix);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String genSalt() throws IllegalArgumentException {
        return Companion.genSalt();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String genSalt(@NotNull byte[] salt, @NotNull String prefix) throws IllegalArgumentException {
        return Companion.genSalt(salt, prefix);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String genSalt(@NotNull byte[] salt) throws IllegalArgumentException {
        return Companion.genSalt(salt);
    }

    static {
        Object[] objectArray = new int[]{608135816, -2052912941, 320440878, 57701188, -1542899678, 698298832, 137296536, -330404727, 1160258022, 953160567, -1101764913, 887688300, -1062458953, -914599715, 1065670069, -1253635817, -1843997223, -1988494565};
        P_orig = objectArray;
        objectArray = new int[]{-785314906, -1730169428, 805139163, -803545161, -1193168915, 1780907670, -1166241723, -248741991, 614570311, -1282315017, 134345442, -2054226922, 1667834072, 1901547113, -1537671517, -191677058, 227898511, 1921955416, 1904987480, -2112533778, 2069144605, -1034266187, -1674521287, 720527379, -976113629, 677414384, -901678824, -1193592593, -1904616272, 1614419982, 1822297739, -1340175810, -686458943, -1120842969, 2024746970, 1432378464, -430627341, -1437226092, 1464375394, 1676153920, 1439316330, 715854006, -1261675468, 289532110, -1588296017, 2087905683, -1276242927, 1668267050, 732546397, 1947742710, -832815594, -1685613794, -1344882125, 1814351708, 2050118529, 680887927, 999245976, 1800124847, -994056165, 1713906067, 1641548236, -81679983, 1216130144, 1575780402, -276538019, -377129551, -601480446, -345695352, 596196993, -745100091, 258830323, -2081144263, 772490370, -1534844924, 1774776394, -1642095778, 566650946, -152474470, 1728879713, -1412200208, 1783734482, -665571480, -1777359064, -1420741725, 1861159788, 326777828, -1170476976, 2130389656, -1578015459, 967770486, 1724537150, -2109534584, -1930525159, 1164943284, 2105845187, 998989502, -529566248, -2050940813, 1075463327, 1455516326, 1322494562, 910128902, 469688178, 1117454909, 936433444, -804646328, -619713837, 1240580251, 122909385, -2137449605, 634681816, -152510729, -469872614, -1233564613, -1754472259, 79693498, -1045868618, 1084186820, 1583128258, 426386531, 1761308591, 1047286709, 322548459, 995290223, 1845252383, -1691314900, -863943356, -1352745719, -1092366332, -567063811, 1712269319, 422464435, -1060394921, 1170764815, -771006663, -1177289765, 1434042557, 442511882, -694091578, 1076654713, 1738483198, -81812532, -1901729288, -617471240, 1014306527, -43947243, 793779912, -1392160085, 842905082, -48003232, 1395751752, 1040244610, -1638115397, -898659168, 445077038, -552113701, -717051658, 679411651, -1402522938, -1940957837, 1767581616, -1144366904, -503340195, -1192226400, 284835224, -48135240, 1258075500, 768725851, -1705778055, -1225243291, -762426948, 1274779536, -505548070, -1530167757, 1660621633, -823867672, -283063590, 913787905, -797008130, 737222580, -1780753843, -1366257256, -357724559, 1804850592, -795946544, -1345903136, -1908647121, -1904896841, -1879645445, -233690268, -2004305902, -1878134756, 1336762016, 1754252060, -774901359, -1280786003, 791618072, -1106372745, -361419266, -1962795103, -442446833, -1250986776, 413987798, -829824359, -1264037920, -49028937, 2093235073, -760370983, 375366246, -2137688315, -1815317740, 555357303, -424861595, 2008414854, -950779147, -73583153, -338841844, 2067696032, -700376109, -1373733303, 2428461, 544322398, 577241275, 1471733935, 610547355, -267798242, 1432588573, 1507829418, 2025931657, -648391809, 545086370, 48609733, -2094660746, 1653985193, 298326376, 1316178497, -1287180854, 2064951626, 458293330, -1705826027, -703637697, -1130641692, 727753846, -2115603456, 146436021, 1461446943, -224990101, 705550613, -1235000031, -407242314, -13368018, -981117340, 1404054877, -1449160799, 146425753, 1854211946, 1266315497, -1246549692, -613086930, -1004984797, -1385257296, 1235738493, -1662099272, -1880247706, -324367247, 1771706367, 1449415276, -1028546847, 422970021, 1963543593, -1604775104, -468174274, 1062508698, 1531092325, 1804592342, -1711849514, -1580033017, -269995787, 1294809318, -265986623, 1289560198, -2072974554, 1669523910, 35572830, 157838143, 1052438473, 1016535060, 1802137761, 1753167236, 1386275462, -1214491899, -1437595849, 1040679964, 2145300060, -1904392980, 1461121720, -1338320329, -263189491, -266592508, 33600511, -1374882534, 1018524850, 629373528, -603381315, -779021319, 2091462646, -1808644237, 586499841, 988145025, 935516892, -927631820, -1695294041, -1455136442, 265290510, -322386114, -1535828415, -499593831, 1005194799, 847297441, 406762289, 1314163512, 1332590856, 1866599683, -167115585, 750260880, 613907577, 1450815602, -1129346641, -560302305, -644675568, -1282691566, -590397650, 1427272223, 778793252, 1343938022, -1618686585, 2052605720, 1946737175, -1130390852, -380928628, -327488454, -612033030, 1661551462, -1000029230, -283371449, 840292616, -582796489, 616741398, 312560963, 711312465, 1351876610, 322626781, 1910503582, 271666773, -2119403562, 1594956187, 70604529, -677132437, 1007753275, 1495573769, -225450259, -1745748998, -1631928532, 504708206, -2031925904, -353800271, -2045878774, 1514023603, 1998579484, 1312622330, 694541497, -1712906993, -2143385130, 1382467621, 776784248, -1676627094, -971698502, -1797068168, -1510196141, 503983604, -218673497, 907881277, 423175695, 432175456, 1378068232, -149744970, -340918674, -356311194, -474200683, -1501837181, -1317062703, 26017576, -1020076561, -1100195163, 1700274565, 1756076034, -288447217, -617638597, 720338349, 1533947780, 354530856, 688349552, -321042571, 1637815568, 332179504, -345916010, 53804574, -1442618417, -1250730864, 1282449977, -711025141, -877994476, -288586052, 1617046695, -1666491221, -1292663698, 1686838959, 431878346, -1608291911, 1700445008, 1080580658, 1009431731, 832498133, -1071531785, -1688990951, -2023776103, -1778935426, 1648197032, -130578278, -1746719369, 300782431, 375919233, 238389289, -941219882, -1763778655, 2019080857, 1475708069, 455242339, -1685863425, 448939670, -843904277, 1395535956, -1881585436, 1841049896, 1491858159, 885456874, -30872223, -293847949, 1565136089, -396052509, 1108368660, 540939232, 1173283510, -1549095958, -613658859, -87339056, -951913406, -278217803, 1699691293, 1103962373, -669091426, -2038084153, -464828566, 1031889488, -815619598, 1535977030, -58162272, -1043876189, 2132092099, 1774941330, 1199868427, 1452454533, 157007616, -1390851939, 342012276, 595725824, 1480756522, 206960106, 497939518, 591360097, 863170706, -1919713727, -698356495, 1814182875, 2094937945, -873565088, 1082520231, -831049106, -1509457788, 435703966, -386934699, 1641649973, -1452693590, -989067582, 1510255612, -2146710820, -1639679442, -1018874748, -36346107, 236887753, -613164077, 274041037, 1734335097, -479771840, -976997275, 1899903192, 1026095262, -244449504, 356393447, -1884275382, -421290197, -612127241, -381855128, -1803468553, -162781668, -1805047500, 1091903735, 1979897079, -1124832466, -727580568, -737663887, 857797738, 1136121015, 1342202287, 507115054, -1759230650, 337727348, -1081374656, 1301675037, -1766485585, 1895095763, 1721773893, -1078195732, 62756741, 2142006736, 835421444, -1762973773, 1442658625, -635090970, -1412822374, 676362277, 1392781812, 170690266, -373920261, 1759253602, -683120384, 1745797284, 664899054, 1329594018, -393761396, -1249058810, 2062866102, -1429332356, -751345684, -830954599, 1080764994, 553557557, -638351943, -298199125, 991055499, 499776247, 1265440854, 648242737, -354183246, 980351604, -581221582, 1749149687, -898096901, -83167922, -654396521, 1161844396, -1169648345, 0x55533A3A, 545492359, -26498633, -795437749, 1437099964, -1592419752, -861329053, -1713251533, -1507177898, 1060185593, 1593081372, -1876348548, -34019326, 69676912, -2135222948, 86519011, -1782508216, -456757982, 1220612927, -955283748, 133810670, 1090789135, 1078426020, 1569222167, 845107691, -711212847, -222510705, 1091646820, 628848692, 1613405280, -537335645, 526609435, 236106946, 48312990, -1352249391, -892239595, 1797494240, 859738849, 992217954, -289490654, -2051890674, -424014439, -562951028, 765654824, -804095931, -1783130883, 1685915746, -405998096, 1414112111, -2021832454, -1013056217, -214004450, 172450625, -1724973196, 980381355, -185008841, -1475158944, -1578377736, -1726226100, -613520627, -964995824, 1835478071, 660984891, -590288892, -248967737, -872349789, -1254551662, 1762651403, 1719377915, -824476260, -1601057013, -652910941, -1156370552, 1364962596, 2073328063, 1983633131, 926494387, -871278215, -2144935273, -198299347, 1749200295, -966120645, 309677260, 2016342300, 1779581495, -1215147545, 111262694, 1274766160, 443224088, 298511866, 1025883608, -488520759, 1145181785, 168956806, -653464466, -710153686, 1689216846, -628709281, -1094719096, 1692713982, -1648590761, -252198778, 1618508792, 1610833997, -771914938, -164094032, 2001055236, -684262196, -2092799181, -266425487, -1333771897, 1006657119, 2006996926, -1108824540, 1430667929, -1084739999, 1314452623, -220332638, -193663176, -2021016126, 1399257539, -927756684, -1267338667, 1190975929, 2062231137, -1960976508, -2073424263, -1856006686, 1181637006, 548689776, -1932175983, -922558900, -1190417183, -1149106736, 296247880, 1970579870, -1216407114, -525738999, 1714227617, -1003338189, -396747006, 166772364, 1251581989, 493813264, 448347421, 195405023, -1584991729, 677966185, -591930749, 1463355134, -1578971493, 1338867538, 1343315457, -1492745222, -1610435132, 233230375, -1694987225, 2000651841, -1017099258, 1638401717, -266896856, -1057650976, 6314154, 819756386, 300326615, 590932579, 1405279636, -1027467724, -1144263082, -1866680610, -335774303, -833020554, 1862657033, 1266418056, 963775037, 2089974820, -2031914401, 1917689273, 448879540, -744572676, -313240200, 150775221, -667058989, 1303187396, 508620638, -1318983944, -1568336679, 1817252668, 1876281319, 1457606340, 908771278, -574175177, -677760460, -1838972398, 1729034894, 1080033504, 976866871, -738527793, -1413318857, 1522871579, 1555064734, 1336096578, -746444992, -1715692610, -720269667, -1089506539, -701686658, -956251013, -1215554709, 564236357, -1301368386, 1781952180, 1464380207, -1131123079, -962365742, 1699332808, 1393555694, 1183702653, -713881059, 1288719814, 691649499, -1447410096, -1399511320, -1101077756, -1577396752, 1781354906, 1676643554, -1702433246, -1064713544, 1126444790, -1524759638, -1661808476, -2084544070, -1679201715, -1880812208, -1167828010, 673620729, -1489356063, 1269405062, -279616791, -953159725, -145557542, 1057255273, 2012875353, -2132498155, -2018474495, -1693849939, 993977747, -376373926, -1640704105, 753973209, 36408145, -1764381638, 25011837, -774947114, 2088578344, 530523599, -1376601957, 1524020338, 1518925132, -534139791, -535190042, 1202760957, -309069157, -388774771, 674977740, -120232407, 2031300136, 2019492241, -311074731, -141160892, -472686964, 352677332, -1997247046, 60907813, 90501309, -1007968747, 1016092578, -1759044884, -1455814870, 457141659, 509813237, -174299397, 652014361, 1966332200, -1319764491, 55981186, -1967506245, 676427537, -1039476232, -1412673177, -861040033, 1307055953, 942726286, 933058658, -1826555503, -361066302, -79791154, 1361170020, 2001714738, -1464409218, -1020707514, 1222529897, 1679025792, -1565652976, -580013532, 1770335741, 151462246, -1281735158, 1682292957, 1483529935, 471910574, 1539241949, 458788160, -858652289, 1807016891, -576558466, 978976581, 1043663428, -1129001515, 1927990952, -94075717, -1922690386, -1086558393, -761535389, 1412390302, -1362987237, -162634896, 1947078029, -413461673, -126740879, -1353482915, 1077988104, 1320477388, 886195818, 18198404, -508558296, -1785185763, 112762804, -831610808, 1866414978, 891333506, 18488651, 661792760, 1628790961, -409780260, -1153795797, 876946877, -1601685023, 1372485963, 791857591, -1608533303, -534984578, -1127755274, -822013501, -1578587449, 445679433, -732971622, -790962485, -720709064, 54117162, -963561881, -1913048708, -525259953, -140617289, 1140177722, -220915201, 668550556, -1080614356, 367459370, 261225585, -1684794075, -85617823, -826893077, -1029151655, 314222801, -1228863650, -486184436, 282218597, -888953790, -521376242, 379116347, 1285071038, 846784868, -1625320142, -523005217, -744475605, -1989021154, 453669953, 1268987020, -977374944, -1015663912, -550133875, -1684459730, -435458233, 266596637, -447948204, 517658769, -832407089, -851542417, 370717030, -47440635, -2070949179, -151313767, -182193321, -1506642397, -1817692879, 1456262402, -1393524382, 1517677493, 1846949527, -1999473716, -560569710, -2118563376, 1280348187, 1908823572, -423180355, 846861322, 1172426758, -1007518822, -911584259, 1655181056, -1155153950, 901632758, 1897031941, -1308360158, -1228157060, -847864789, 1393639104, 373351379, 950779232, 625454576, -1170726756, -146354570, 2007998917, 544563296, -2050228658, -1964470824, 2058025392, 1291430526, 424198748, 50039436, 29584100, -689184263, -1865090967, -1503863136, 1057563949, -1039604065, -1219600078, -831004069, 1469046755, 985887462};
        S_orig = objectArray;
        objectArray = new int[]{1332899944, 1700884034, 1701343084, 1684370003, 1668446532, 1869963892};
        bf_crypt_ciphertext = objectArray;
        objectArray = new char[64];
        objectArray[0] = 46;
        objectArray[1] = 47;
        objectArray[2] = 65;
        objectArray[3] = 66;
        objectArray[4] = 67;
        objectArray[5] = 68;
        objectArray[6] = 69;
        objectArray[7] = 70;
        objectArray[8] = 71;
        objectArray[9] = 72;
        objectArray[10] = 73;
        objectArray[11] = 74;
        objectArray[12] = 75;
        objectArray[13] = 76;
        objectArray[14] = 77;
        objectArray[15] = 78;
        objectArray[16] = 79;
        objectArray[17] = 80;
        objectArray[18] = 81;
        objectArray[19] = 82;
        objectArray[20] = 83;
        objectArray[21] = 84;
        objectArray[22] = 85;
        objectArray[23] = 86;
        objectArray[24] = 87;
        objectArray[25] = 88;
        objectArray[26] = 89;
        objectArray[27] = 90;
        objectArray[28] = 97;
        objectArray[29] = 98;
        objectArray[30] = 99;
        objectArray[31] = 100;
        objectArray[32] = 101;
        objectArray[33] = 102;
        objectArray[34] = 103;
        objectArray[35] = 104;
        objectArray[36] = 105;
        objectArray[37] = 106;
        objectArray[38] = 107;
        objectArray[39] = 108;
        objectArray[40] = 109;
        objectArray[41] = 110;
        objectArray[42] = 111;
        objectArray[43] = 112;
        objectArray[44] = 113;
        objectArray[45] = 114;
        objectArray[46] = 115;
        objectArray[47] = 116;
        objectArray[48] = 117;
        objectArray[49] = 118;
        objectArray[50] = 119;
        objectArray[51] = 120;
        objectArray[52] = 121;
        objectArray[53] = 122;
        objectArray[54] = 48;
        objectArray[55] = 49;
        objectArray[56] = 50;
        objectArray[57] = 51;
        objectArray[58] = 52;
        objectArray[59] = 53;
        objectArray[60] = 54;
        objectArray[61] = 55;
        objectArray[62] = 56;
        objectArray[63] = 57;
        base64_code = (char[])objectArray;
        objectArray = new byte[128];
        objectArray[0] = -1;
        objectArray[1] = -1;
        objectArray[2] = -1;
        objectArray[3] = -1;
        objectArray[4] = -1;
        objectArray[5] = -1;
        objectArray[6] = -1;
        objectArray[7] = -1;
        objectArray[8] = -1;
        objectArray[9] = -1;
        objectArray[10] = -1;
        objectArray[11] = -1;
        objectArray[12] = -1;
        objectArray[13] = -1;
        objectArray[14] = -1;
        objectArray[15] = -1;
        objectArray[16] = -1;
        objectArray[17] = -1;
        objectArray[18] = -1;
        objectArray[19] = -1;
        objectArray[20] = -1;
        objectArray[21] = -1;
        objectArray[22] = -1;
        objectArray[23] = -1;
        objectArray[24] = -1;
        objectArray[25] = -1;
        objectArray[26] = -1;
        objectArray[27] = -1;
        objectArray[28] = -1;
        objectArray[29] = -1;
        objectArray[30] = -1;
        objectArray[31] = -1;
        objectArray[32] = -1;
        objectArray[33] = -1;
        objectArray[34] = -1;
        objectArray[35] = -1;
        objectArray[36] = -1;
        objectArray[37] = -1;
        objectArray[38] = -1;
        objectArray[39] = -1;
        objectArray[40] = -1;
        objectArray[41] = -1;
        objectArray[42] = -1;
        objectArray[43] = -1;
        objectArray[44] = -1;
        objectArray[45] = -1;
        objectArray[46] = 0;
        objectArray[47] = 1;
        objectArray[48] = 54;
        objectArray[49] = 55;
        objectArray[50] = 56;
        objectArray[51] = 57;
        objectArray[52] = 58;
        objectArray[53] = 59;
        objectArray[54] = 60;
        objectArray[55] = 61;
        objectArray[56] = 62;
        objectArray[57] = 63;
        objectArray[58] = -1;
        objectArray[59] = -1;
        objectArray[60] = -1;
        objectArray[61] = -1;
        objectArray[62] = -1;
        objectArray[63] = -1;
        objectArray[64] = -1;
        objectArray[65] = 2;
        objectArray[66] = 3;
        objectArray[67] = 4;
        objectArray[68] = 5;
        objectArray[69] = 6;
        objectArray[70] = 7;
        objectArray[71] = 8;
        objectArray[72] = 9;
        objectArray[73] = 10;
        objectArray[74] = 11;
        objectArray[75] = 12;
        objectArray[76] = 13;
        objectArray[77] = 14;
        objectArray[78] = 15;
        objectArray[79] = 16;
        objectArray[80] = 17;
        objectArray[81] = 18;
        objectArray[82] = 19;
        objectArray[83] = 20;
        objectArray[84] = 21;
        objectArray[85] = 22;
        objectArray[86] = 23;
        objectArray[87] = 24;
        objectArray[88] = 25;
        objectArray[89] = 26;
        objectArray[90] = 27;
        objectArray[91] = -1;
        objectArray[92] = -1;
        objectArray[93] = -1;
        objectArray[94] = -1;
        objectArray[95] = -1;
        objectArray[96] = -1;
        objectArray[97] = 28;
        objectArray[98] = 29;
        objectArray[99] = 30;
        objectArray[100] = 31;
        objectArray[101] = 32;
        objectArray[102] = 33;
        objectArray[103] = 34;
        objectArray[104] = 35;
        objectArray[105] = 36;
        objectArray[106] = 37;
        objectArray[107] = 38;
        objectArray[108] = 39;
        objectArray[109] = 40;
        objectArray[110] = 41;
        objectArray[111] = 42;
        objectArray[112] = 43;
        objectArray[113] = 44;
        objectArray[114] = 45;
        objectArray[115] = 46;
        objectArray[116] = 47;
        objectArray[117] = 48;
        objectArray[118] = 49;
        objectArray[119] = 50;
        objectArray[120] = 51;
        objectArray[121] = 52;
        objectArray[122] = 53;
        objectArray[123] = -1;
        objectArray[124] = -1;
        objectArray[125] = -1;
        objectArray[126] = -1;
        objectArray[127] = -1;
        index_64 = (byte[])objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0004J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00042\n\u0010\"\u001a\u00060#j\u0002`$J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0019H\u0002J$\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00102\b\b\u0002\u0010*\u001a\u00020\u00192\b\b\u0002\u0010+\u001a\u00020\u0004H\u0007J&\u0010(\u001a\u00020\u00192\b\b\u0002\u0010*\u001a\u00020\u00192\b\b\u0002\u0010+\u001a\u00020\u00042\b\b\u0002\u0010,\u001a\u00020-H\u0007J\u001a\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u00102\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0007J\u001a\u0010.\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00192\b\u0010)\u001a\u0004\u0018\u00010\u0019H\u0007J\u000e\u00100\u001a\u0002012\u0006\u0010+\u001a\u00020\u0004J\u0018\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\nH\u0002J\u0018\u00105\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\nH\u0002J \u00106\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\n2\u0006\u00107\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lme/leon/hash/bcrypt/BCrypt$Companion;", "", "()V", "BCRYPT_SALT_LEN", "", "BLOWFISH_NUM_ROUNDS", "GENSALT_DEFAULT_LOG2_ROUNDS", "MAX_LOG_ROUNDS", "MIN_LOG_ROUNDS", "P_orig", "", "S_orig", "base64_code", "", "bf_crypt_ciphertext", "index_64", "", "char64", "", "x", "", "checkPw", "", "password", "hashed", "", "plaintext", "decodeBase64", "s", "maxLen", "encodeBase64", "", "d", "len", "rs", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "equalsNoEarlyReturn", "a", "b", "genSalt", "salt", "prefix", "logRounds", "random", "Ljava/security/SecureRandom;", "hashpw", "passwordb", "roundsForLogRounds", "", "streamtoword", "data", "offp", "streamtowordBug", "streamtowords", "signp", "app"})
    @SourceDebugExtension(value={"SMAP\nBCrypt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BCrypt.kt\nme/leon/hash/bcrypt/BCrypt$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1831:1\n1#2:1832\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void encodeBase64(@NotNull byte[] d, int len, @NotNull StringBuilder rs) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            int off = 0;
            int c1 = 0;
            int c2 = 0;
            if (!(len > 0 && len <= d.length)) {
                boolean bl = false;
                String string = "Invalid len";
                throw new IllegalArgumentException(string.toString());
            }
            while (off < len) {
                c1 = d[off++] & 0xFF;
                rs.append(base64_code[c1 >> 2 & 0x3F]);
                c1 = (c1 & 3) << 4;
                if (off >= len) {
                    rs.append(base64_code[c1 & 0x3F]);
                    break;
                }
                c2 = d[off++] & 0xFF;
                rs.append(base64_code[(c1 |= c2 >> 4 & 0xF) & 0x3F]);
                c1 = (c2 & 0xF) << 2;
                if (off >= len) {
                    rs.append(base64_code[c1 & 0x3F]);
                    break;
                }
                c2 = d[off++] & 0xFF;
                rs.append(base64_code[(c1 |= c2 >> 6 & 3) & 0x3F]);
                rs.append(base64_code[c2 & 0x3F]);
            }
        }

        private final byte char64(char x) {
            return x < '\u0000' || x >= index_64.length ? (byte)-1 : index_64[x];
        }

        @NotNull
        public final byte[] decodeBase64(@NotNull String s, int maxLen) throws IllegalArgumentException {
            int olen;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            StringBuilder rs = new StringBuilder();
            int off = 0;
            int sLen = s.length();
            byte c1 = 0;
            byte c2 = 0;
            byte c3 = 0;
            byte c4 = 0;
            byte o = 0;
            if (!(maxLen > 0)) {
                boolean bl = false;
                String string = "Invalid maxolen";
                throw new IllegalArgumentException(string.toString());
            }
            for (olen = 0; off < sLen - 1 && olen < maxLen; ++olen) {
                c1 = this.char64(s.charAt(off++));
                c2 = this.char64(s.charAt(off++));
                if (c1 == -1 || c2 == -1) break;
                o = (byte)(c1 << 2);
                o = (byte)(o | (byte)(c2 & 0x30) >> 4);
                rs.append((char)(UShort.constructor-impl((short)o) & 0xFFFF));
                if (++olen >= maxLen || off >= sLen || (c3 = this.char64(s.charAt(off++))) == -1) break;
                o = (byte)((byte)(c2 & 0xF) << 4);
                o = (byte)(o | (byte)(c3 & 0x3C) >> 2);
                rs.append((char)(UShort.constructor-impl((short)o) & 0xFFFF));
                if (++olen >= maxLen || off >= sLen) break;
                c4 = this.char64(s.charAt(off++));
                o = (byte)((byte)(c3 & 3) << 6);
                o = (byte)(o | c4);
                rs.append((char)(UShort.constructor-impl((short)o) & 0xFFFF));
            }
            byte[] ret = new byte[olen];
            for (off = 0; off < olen; ++off) {
                ret[off] = (byte)rs.charAt(off);
            }
            return ret;
        }

        private final int[] streamtowords(byte[] data, int[] offp, int[] signp) {
            int[] nArray = new int[]{0, 0};
            int[] words = nArray;
            int off = offp[0];
            int sign2 = signp[0];
            for (int i = 0; i < 4; ++i) {
                words[0] = words[0] << 8 | data[off] & 0xFF;
                words[1] = words[1] << 8 | data[off];
                if (i > 0) {
                    sign2 |= words[1] & 0x80;
                }
                off = (off + 1) % data.length;
            }
            offp[0] = off;
            signp[0] = sign2;
            return words;
        }

        private final int streamtoword(byte[] data, int[] offp) {
            int[] nArray = new int[]{0};
            int[] signp = nArray;
            return this.streamtowords(data, offp, signp)[0];
        }

        private final int streamtowordBug(byte[] data, int[] offp) {
            int[] nArray = new int[]{0};
            return this.streamtowords(data, offp, nArray)[1];
        }

        public final long roundsForLogRounds(int logRounds) {
            if (!(logRounds >= 4 && logRounds <= 31)) {
                boolean bl = false;
                String string = "Bad number of rounds";
                throw new IllegalArgumentException(string.toString());
            }
            return 1L << logRounds;
        }

        @JvmStatic
        @NotNull
        public final String hashpw(@NotNull String password, @Nullable String salt) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            String string = password;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return this.hashpw(byArray, salt);
        }

        @JvmStatic
        @NotNull
        public final String hashpw(@NotNull byte[] passwordb, @Nullable String salt) {
            Intrinsics.checkNotNullParameter((Object)passwordb, (String)"passwordb");
            byte[] tmpPass = passwordb;
            byte[] hashed = null;
            char minor = '\u0000';
            int rounds = 0;
            int off = 0;
            StringBuilder rs = new StringBuilder();
            if (salt == null) {
                boolean $i$a$-requireNotNull-BCrypt$Companion$hashpw$22 = false;
                String $i$a$-requireNotNull-BCrypt$Companion$hashpw$22 = "salt cannot be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-BCrypt$Companion$hashpw$22.toString());
            }
            int saltLength = salt.length();
            if (!(saltLength >= 28)) {
                boolean $i$a$-require-BCrypt$Companion$hashpw$72 = false;
                String $i$a$-require-BCrypt$Companion$hashpw$72 = "Invalid salt";
                throw new IllegalArgumentException($i$a$-require-BCrypt$Companion$hashpw$72.toString());
            }
            if (!(salt.charAt(0) == '$' && salt.charAt(1) == '2')) {
                boolean $i$a$-require-BCrypt$Companion$hashpw$82 = false;
                String $i$a$-require-BCrypt$Companion$hashpw$82 = "Invalid salt version";
                throw new IllegalArgumentException($i$a$-require-BCrypt$Companion$hashpw$82.toString());
            }
            if (salt.charAt(2) == '$') {
                off = 3;
            } else {
                minor = salt.charAt(2);
                if (!((minor == 'a' || minor == 'x' || minor == 'y' || minor == 'b') && salt.charAt(3) == '$')) {
                    boolean $i$a$-require-BCrypt$Companion$hashpw$92 = false;
                    String $i$a$-require-BCrypt$Companion$hashpw$92 = "Invalid salt revision";
                    throw new IllegalArgumentException($i$a$-require-BCrypt$Companion$hashpw$92.toString());
                }
                off = 4;
            }
            if (!(Intrinsics.compare((int)salt.charAt(off + 2), (int)36) <= 0)) {
                boolean $i$a$-require-BCrypt$Companion$hashpw$102 = false;
                String $i$a$-require-BCrypt$Companion$hashpw$102 = "Missing salt rounds";
                throw new IllegalArgumentException($i$a$-require-BCrypt$Companion$hashpw$102.toString());
            }
            if (!(off != 4 || saltLength >= 29)) {
                boolean $i$a$-require-BCrypt$Companion$hashpw$112 = false;
                String $i$a$-require-BCrypt$Companion$hashpw$112 = "Invalid salt";
                throw new IllegalArgumentException($i$a$-require-BCrypt$Companion$hashpw$112.toString());
            }
            String string = salt.substring(off, off + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            rounds = Integer.parseInt(string);
            String string2 = salt.substring(off + 3, off + 25);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String realSalt = string2;
            byte[] saltB = this.decodeBase64(realSalt, 16);
            if (Intrinsics.compare((int)minor, (int)97) >= 0) {
                byte[] byArray = Arrays.copyOf(tmpPass, tmpPass.length + 1);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
                tmpPass = byArray;
            }
            BCrypt b = new BCrypt();
            hashed = b.cryptRaw(tmpPass, saltB, rounds, minor == 'x', minor == 'a' ? 65536 : 0);
            rs.append("$2");
            if (Intrinsics.compare((int)minor, (int)97) >= 0) {
                rs.append(minor);
            }
            rs.append("$");
            if (rounds < 10) {
                rs.append("0");
            }
            rs.append(rounds);
            rs.append("$");
            this.encodeBase64(saltB, saltB.length, rs);
            this.encodeBase64(hashed, bf_crypt_ciphertext.length * 4 - 1, rs);
            String string3 = rs.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return string3;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String genSalt(@NotNull String prefix, int logRounds, @NotNull SecureRandom random) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            byte[] rnd = new byte[16];
            random.nextBytes(rnd);
            return this.genSalt(rnd, prefix, logRounds);
        }

        public static /* synthetic */ String genSalt$default(Companion companion, String string, int n, SecureRandom secureRandom, int n2, Object object) throws IllegalArgumentException {
            if ((n2 & 1) != 0) {
                string = "$2a";
            }
            if ((n2 & 2) != 0) {
                n = 10;
            }
            if ((n2 & 4) != 0) {
                secureRandom = new SecureRandom();
            }
            return companion.genSalt(string, n, secureRandom);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String genSalt(@NotNull byte[] salt, @NotNull String prefix, int logRounds) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            StringBuilder rs = new StringBuilder();
            if (!(StringsKt.startsWith$default((String)prefix, (String)"$2", (boolean)false, (int)2, null) && (prefix.charAt(2) == 'a' || prefix.charAt(2) == 'y' || prefix.charAt(2) == 'b'))) {
                boolean $i$a$-require-BCrypt$Companion$genSalt$32 = false;
                String $i$a$-require-BCrypt$Companion$genSalt$32 = "Invalid prefix";
                throw new IllegalArgumentException($i$a$-require-BCrypt$Companion$genSalt$32.toString());
            }
            if (!(logRounds >= 4 && logRounds <= 31)) {
                boolean bl = false;
                String string = "Invalid logRounds";
                throw new IllegalArgumentException(string.toString());
            }
            rs.append("$2");
            rs.append(prefix.charAt(2));
            rs.append("$");
            if (logRounds < 10) {
                rs.append("0");
            }
            rs.append(logRounds);
            rs.append("$");
            this.encodeBase64(salt, salt.length, rs);
            String string = rs.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static /* synthetic */ String genSalt$default(Companion companion, byte[] byArray, String string, int n, int n2, Object object) throws IllegalArgumentException {
            if ((n2 & 2) != 0) {
                string = "$2a";
            }
            if ((n2 & 4) != 0) {
                n = 10;
            }
            return companion.genSalt(byArray, string, n);
        }

        @JvmStatic
        public final boolean checkPw(@NotNull String plaintext, @NotNull String hashed) {
            Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
            return this.equalsNoEarlyReturn(hashed, this.hashpw(plaintext, hashed));
        }

        @JvmStatic
        public final boolean checkPw(@NotNull byte[] password, @NotNull String hashed) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)hashed, (String)"hashed");
            return this.equalsNoEarlyReturn(hashed, this.hashpw(password, hashed));
        }

        private final boolean equalsNoEarlyReturn(String a, String b) {
            String string = a;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = b;
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            return MessageDigest.isEqual(byArray, byArray2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String genSalt(@NotNull String prefix, int logRounds) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return me.leon.hash.bcrypt.BCrypt$Companion.genSalt$default(this, prefix, logRounds, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String genSalt(@NotNull String prefix) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return me.leon.hash.bcrypt.BCrypt$Companion.genSalt$default(this, prefix, 0, null, 6, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String genSalt() throws IllegalArgumentException {
            return me.leon.hash.bcrypt.BCrypt$Companion.genSalt$default(this, null, 0, null, 7, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String genSalt(@NotNull byte[] salt, @NotNull String prefix) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return me.leon.hash.bcrypt.BCrypt$Companion.genSalt$default(this, salt, prefix, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String genSalt(@NotNull byte[] salt) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            return me.leon.hash.bcrypt.BCrypt$Companion.genSalt$default(this, salt, null, 0, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

