/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.password;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import me.leon.hash.keygen.Base64StringKeyGenerator;
import me.leon.hash.keygen.StringKeyGenerator;
import me.leon.hash.password.Digester;
import me.leon.hash.password.PasswordEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lme/leon/hash/password/MessageDigestPasswordEncoder;", "Lme/leon/hash/password/PasswordEncoder;", "algorithm", "", "(Ljava/lang/String;)V", "digester", "Lme/leon/hash/password/Digester;", "encodeHashAsBase64", "", "getEncodeHashAsBase64", "()Z", "setEncodeHashAsBase64", "(Z)V", "saltGenerator", "Lme/leon/hash/keygen/StringKeyGenerator;", "digest", "", "salt", "rawPassword", "", "encode", "password", "extractSalt", "prefixEncodedPassword", "matches", "encodedPassword", "setIterations", "", "iterations", "", "Companion", "app"})
public final class MessageDigestPasswordEncoder
implements PasswordEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringKeyGenerator saltGenerator;
    private boolean encodeHashAsBase64;
    @NotNull
    private final Digester digester;
    @NotNull
    private static final String PREFIX = "{";
    @NotNull
    private static final String SUFFIX = "}";

    public MessageDigestPasswordEncoder(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        this.saltGenerator = new Base64StringKeyGenerator(null, 0, 3, null);
        this.digester = new Digester(algorithm, 1);
    }

    public final boolean getEncodeHashAsBase64() {
        return this.encodeHashAsBase64;
    }

    public final void setEncodeHashAsBase64(boolean bl) {
        this.encodeHashAsBase64 = bl;
    }

    @Override
    @NotNull
    public String encode(@NotNull CharSequence password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String salt = '{' + this.saltGenerator.generateKey() + '}';
        return this.digest(salt, password);
    }

    @NotNull
    public final String digest(@NotNull String salt, @NotNull CharSequence rawPassword) {
        String saltedPassword;
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        String string = saltedPassword = rawPassword + salt;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] digest2 = this.digester.digest(byArray);
        String encoded = this.encode(digest2);
        return salt + encoded;
    }

    @NotNull
    public final byte[] digest(@NotNull byte[] salt, @NotNull byte[] rawPassword) {
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        return ArraysKt.plus((byte[])salt, (byte[])this.digester.digest(ArraysKt.plus((byte[])salt, (byte[])rawPassword)));
    }

    private final String encode(byte[] digest2) {
        return this.encodeHashAsBase64 ? Base64Kt.base64$default(digest2, null, false, 3, null) : ConverterKt.toHex(digest2);
    }

    @Override
    public boolean matches(@NotNull CharSequence password, @NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        String salt = this.extractSalt(encodedPassword);
        return Intrinsics.areEqual((Object)encodedPassword, (Object)this.digest(salt, password));
    }

    public final void setIterations(int iterations) {
        this.digester.setIterations(iterations);
    }

    private final String extractSalt(String prefixEncodedPassword) {
        String string;
        int start = StringsKt.indexOf$default((CharSequence)prefixEncodedPassword, (String)PREFIX, (int)0, (boolean)false, (int)6, null);
        if (start != 0) {
            return "";
        }
        int end = StringsKt.indexOf$default((CharSequence)prefixEncodedPassword, (String)SUFFIX, (int)start, (boolean)false, (int)4, null);
        if (end < 0) {
            string = "";
        } else {
            String string2 = prefixEncodedPassword.substring(start, end + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        }
        return string;
    }

    @Override
    public boolean upgradeEncoding(@NotNull String encodedPassword) {
        return PasswordEncoder.DefaultImpls.upgradeEncoding(this, encodedPassword);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/leon/hash/password/MessageDigestPasswordEncoder$Companion;", "", "()V", "PREFIX", "", "SUFFIX", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

