/*
 * Decompiled with CFR 0.152.
 */
package me.leon.hash.password;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import me.leon.encode.base.Base64Kt;
import me.leon.ext.ConverterKt;
import me.leon.hash.keygen.BytesKeyGenerator;
import me.leon.hash.keygen.KeyGenerators;
import me.leon.hash.password.PasswordEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002#$B/\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0013J\u0016\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u001e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0013J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lme/leon/hash/password/Pbkdf2PasswordEncoder;", "Lme/leon/hash/password/PasswordEncoder;", "secret", "", "saltLength", "", "iterations", "hashWidth", "(Ljava/lang/String;III)V", "algorithm", "encodeHashAsBase64", "", "getEncodeHashAsBase64", "()Z", "setEncodeHashAsBase64", "(Z)V", "saltGenerator", "Lme/leon/hash/keygen/BytesKeyGenerator;", "decode", "", "encodedBytes", "encode", "bytes", "password", "", "rawPassword", "salt", "encodeWithSalt", "matches", "encodedPassword", "matchesWithSalt", "setAlgorithm", "", "secretKeyFactoryAlgorithm", "Lme/leon/hash/password/Pbkdf2PasswordEncoder$SecretKeyFactoryAlgorithm;", "Companion", "SecretKeyFactoryAlgorithm", "app"})
public final class Pbkdf2PasswordEncoder
implements PasswordEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String secret;
    private int iterations;
    private int hashWidth;
    @NotNull
    private final BytesKeyGenerator saltGenerator;
    @NotNull
    private String algorithm;
    private boolean encodeHashAsBase64;
    private static final int DEFAULT_SALT_LENGTH = 8;
    private static final int DEFAULT_HASH_WIDTH = 256;
    private static final int DEFAULT_ITERATIONS = 185000;

    @JvmOverloads
    public Pbkdf2PasswordEncoder(@NotNull String secret, int saltLength, int iterations, int hashWidth) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.secret = secret;
        this.iterations = iterations;
        this.hashWidth = hashWidth;
        this.algorithm = "PBKDF2WithHmacSHA1";
        this.saltGenerator = KeyGenerators.secureRandom(saltLength);
    }

    public /* synthetic */ Pbkdf2PasswordEncoder(String string, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = "";
        }
        if ((n4 & 2) != 0) {
            n = 8;
        }
        if ((n4 & 4) != 0) {
            n2 = 185000;
        }
        if ((n4 & 8) != 0) {
            n3 = 256;
        }
        this(string, n, n2, n3);
    }

    public final boolean getEncodeHashAsBase64() {
        return this.encodeHashAsBase64;
    }

    public final void setEncodeHashAsBase64(boolean bl) {
        this.encodeHashAsBase64 = bl;
    }

    public final void setAlgorithm(@NotNull SecretKeyFactoryAlgorithm secretKeyFactoryAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)((Object)secretKeyFactoryAlgorithm), (String)"secretKeyFactoryAlgorithm");
        String algorithmName = secretKeyFactoryAlgorithm.name();
        try {
            SecretKeyFactory.getInstance(algorithmName);
            this.algorithm = algorithmName;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Invalid algorithm '" + algorithmName + "'.", ex);
        }
    }

    @Override
    @NotNull
    public String encode(@NotNull CharSequence password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        byte[] salt = this.saltGenerator.generateKey();
        byte[] encoded = this.encode(password, salt);
        return this.encode(encoded);
    }

    @NotNull
    public final String encodeWithSalt(@NotNull CharSequence rawPassword, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        byte[] encoded = this.encode(rawPassword, salt);
        return this.encode(encoded);
    }

    private final String encode(byte[] bytes) {
        return this.encodeHashAsBase64 ? Base64Kt.base64$default(bytes, null, false, 3, null) : ConverterKt.toHex(bytes);
    }

    @Override
    public boolean matches(@NotNull CharSequence password, @NotNull String encodedPassword) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        byte[] digested = this.decode(encodedPassword);
        byte[] salt = ArraysKt.sliceArray((byte[])digested, (IntRange)RangesKt.until((int)0, (int)this.saltGenerator.getKeyLength()));
        return MessageDigest.isEqual(digested, this.encode(password, salt));
    }

    public final boolean matchesWithSalt(@NotNull CharSequence rawPassword, @NotNull String encodedPassword, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        Intrinsics.checkNotNullParameter((Object)encodedPassword, (String)"encodedPassword");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        byte[] digested = this.decode(encodedPassword);
        return MessageDigest.isEqual(digested, this.encode(rawPassword, salt));
    }

    private final byte[] decode(String encodedBytes) {
        byte[] byArray;
        if (this.encodeHashAsBase64) {
            byte[] byArray2 = Base64.getDecoder().decode(encodedBytes);
            Intrinsics.checkNotNull((Object)byArray2);
            byArray = byArray2;
        } else {
            byArray = ConverterKt.hex2ByteArray(encodedBytes);
        }
        return byArray;
    }

    @NotNull
    public final byte[] encode(@NotNull CharSequence rawPassword, @NotNull byte[] salt) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)rawPassword, (String)"rawPassword");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        try {
            char[] cArray = ((Object)rawPassword).toString().toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            String string = this.secret;
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            PBEKeySpec spec = new PBEKeySpec(cArray, ArraysKt.plus((byte[])salt, (byte[])byArray2), this.iterations, this.hashWidth);
            byte[] byArray3 = SecretKeyFactory.getInstance(this.algorithm).generateSecret(spec).getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getEncoded(...)");
            byArray = ArraysKt.plus((byte[])salt, (byte[])byArray3);
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Could not create hash", ex);
        }
        return byArray;
    }

    @Override
    public boolean upgradeEncoding(@NotNull String encodedPassword) {
        return PasswordEncoder.DefaultImpls.upgradeEncoding(this, encodedPassword);
    }

    @JvmOverloads
    public Pbkdf2PasswordEncoder(@NotNull String secret, int saltLength, int iterations) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this(secret, saltLength, iterations, 0, 8, null);
    }

    @JvmOverloads
    public Pbkdf2PasswordEncoder(@NotNull String secret, int saltLength) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this(secret, saltLength, 0, 0, 12, null);
    }

    @JvmOverloads
    public Pbkdf2PasswordEncoder(@NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this(secret, 0, 0, 0, 14, null);
    }

    @JvmOverloads
    public Pbkdf2PasswordEncoder() {
        this(null, 0, 0, 0, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/leon/hash/password/Pbkdf2PasswordEncoder$Companion;", "", "()V", "DEFAULT_HASH_WIDTH", "", "DEFAULT_ITERATIONS", "DEFAULT_SALT_LENGTH", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0012\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lme/leon/hash/password/Pbkdf2PasswordEncoder$SecretKeyFactoryAlgorithm;", "", "(Ljava/lang/String;I)V", "PBKDF2WithHmacSHA1", "PBKDF2WithHmacSHA256", "PBKDF2WithHmacSHA512", "PBEWithHmacTIGER", "PBEWithHmacSHA256", "PBKDF2WithHmacSHA224", "PBEWithHmacRIPEMD160", "PBKDF2WithHmacSHA3-384", "PBKDF2WithHmacGOST3411", "PBKDF2WithHmacSM3", "PBKDF2WithHmacSHA384", "PBKDF2WithHmacSHA3-512", "PBEWithHmacSHA1", "PBEWithHmacGOST3411", "PBKDF2WithHmacSHA3-256", "PBKDF2WithHmacSHA3-224", "app"})
    public static final class SecretKeyFactoryAlgorithm
    extends Enum<SecretKeyFactoryAlgorithm> {
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA1 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA256 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA512 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBEWithHmacTIGER = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBEWithHmacSHA256 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA224 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBEWithHmacRIPEMD160 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA3-384 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacGOST3411 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSM3 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA384 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA3-512 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBEWithHmacSHA1 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBEWithHmacGOST3411 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA3-256 = new SecretKeyFactoryAlgorithm();
        public static final /* enum */ SecretKeyFactoryAlgorithm PBKDF2WithHmacSHA3-224 = new SecretKeyFactoryAlgorithm();
        private static final /* synthetic */ SecretKeyFactoryAlgorithm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SecretKeyFactoryAlgorithm[] values() {
            return (SecretKeyFactoryAlgorithm[])$VALUES.clone();
        }

        public static SecretKeyFactoryAlgorithm valueOf(String value) {
            return Enum.valueOf(SecretKeyFactoryAlgorithm.class, value);
        }

        @NotNull
        public static EnumEntries<SecretKeyFactoryAlgorithm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = secretKeyFactoryAlgorithmArray = new SecretKeyFactoryAlgorithm[]{SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA1, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA256, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA512, SecretKeyFactoryAlgorithm.PBEWithHmacTIGER, SecretKeyFactoryAlgorithm.PBEWithHmacSHA256, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA224, SecretKeyFactoryAlgorithm.PBEWithHmacRIPEMD160, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-384, SecretKeyFactoryAlgorithm.PBKDF2WithHmacGOST3411, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSM3, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA384, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-512, SecretKeyFactoryAlgorithm.PBEWithHmacSHA1, SecretKeyFactoryAlgorithm.PBEWithHmacGOST3411, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-256, SecretKeyFactoryAlgorithm.PBKDF2WithHmacSHA3-224};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

