/*
 * Decompiled with CFR 0.152.
 */
package me.leon.toolsfx.plugin.ext;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u00a8\u0006\n"}, d2={"color", "Ljava/awt/Color;", "Ljavax/imageio/metadata/IIOMetadataNode;", "parseBackground", "backgroundColor", "parseSize", "Ljava/awt/Rectangle;", "splitGif", "", "Ljava/io/File;", "plugin-image"})
public final class GifSplitterKt {
    @NotNull
    public static final String splitGif(@NotNull File $this$splitGif) {
        ImageReader imageReader;
        Intrinsics.checkNotNullParameter((Object)$this$splitGif, (String)"<this>");
        File outputDir = new File($this$splitGif.getParent(), FilesKt.getNameWithoutExtension((File)$this$splitGif));
        outputDir.mkdirs();
        ImageReader $this$splitGif_u24lambda_u240 = imageReader = ImageIO.getImageReadersByFormatName("gif").next();
        boolean bl = false;
        $this$splitGif_u24lambda_u240.setInput(ImageIO.createImageInputStream(new FileInputStream($this$splitGif)));
        ImageReader reader = imageReader;
        Rectangle size = null;
        size = new Rectangle();
        IIOMetadata metadata = reader.getStreamMetadata();
        Color backgroundColor = null;
        if (metadata != null) {
            Node node = metadata.getAsTree(metadata.getNativeMetadataFormatName());
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
            IIOMetadataNode globalRoot = (IIOMetadataNode)node;
            size = GifSplitterKt.parseSize(globalRoot);
            backgroundColor = GifSplitterKt.parseBackground$default(globalRoot, null, 1, null);
        }
        BufferedImage masterImage = null;
        int frameIndex = 0;
        while (true) {
            BufferedImage bufferedImage;
            try {
                bufferedImage = reader.read(frameIndex);
                Intrinsics.checkNotNull((Object)bufferedImage);
            }
            catch (Exception ignored) {
                break;
            }
            BufferedImage image = bufferedImage;
            if (size.isEmpty()) {
                size.width = image.getWidth();
                size.height = image.getHeight();
            }
            Node node = reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
            IIOMetadataNode root2 = (IIOMetadataNode)node;
            NodeList children = root2.getChildNodes();
            if (masterImage == null) {
                Graphics2D graphics2D;
                BufferedImage bufferedImage2;
                BufferedImage it = bufferedImage2 = new BufferedImage(size.width, size.height, 2);
                boolean bl2 = false;
                Graphics2D $this$splitGif_u24lambda_u242_u24lambda_u241 = graphics2D = it.createGraphics();
                boolean bl3 = false;
                $this$splitGif_u24lambda_u242_u24lambda_u241.setColor(backgroundColor);
                $this$splitGif_u24lambda_u242_u24lambda_u241.fillRect(0, 0, size.width, size.height);
                $this$splitGif_u24lambda_u242_u24lambda_u241.drawImage((Image)image, 0, 0, null);
                masterImage = bufferedImage2;
            } else {
                Point currentPoint = new Point();
                int n = children.getLength();
                for (int nodeIndex = 0; nodeIndex < n; ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    Integer n2 = Integer.valueOf(map.getNamedItem("imageLeftPosition").getNodeValue());
                    Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"valueOf(...)");
                    currentPoint.x = ((Number)n2).intValue();
                    Integer n3 = Integer.valueOf(map.getNamedItem("imageTopPosition").getNodeValue());
                    Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"valueOf(...)");
                    currentPoint.y = ((Number)n3).intValue();
                    break;
                }
                Graphics2D graphics2D = masterImage.createGraphics();
                if (graphics2D != null) {
                    graphics2D.drawImage((Image)image, currentPoint.x, currentPoint.y, null);
                }
                ImageIO.write((RenderedImage)masterImage, "PNG", new File(outputDir, frameIndex + ".png"));
            }
            masterImage.flush();
            ++frameIndex;
        }
        reader.dispose();
        return "saved to " + outputDir.getAbsolutePath();
    }

    private static final Color parseBackground(IIOMetadataNode $this$parseBackground, Color backgroundColor) {
        IIOMetadataNode colorTable;
        Color tmp = backgroundColor;
        NodeList globalColorTable = $this$parseBackground.getElementsByTagName("GlobalColorTable");
        if (globalColorTable.getLength() > 0 && (colorTable = (IIOMetadataNode)globalColorTable.item(0)) != null) {
            String bgIndex = colorTable.getAttribute("backgroundColorIndex");
            IIOMetadataNode colorEntry = (IIOMetadataNode)colorTable.getFirstChild();
            while (colorEntry != null) {
                if (Intrinsics.areEqual((Object)colorEntry.getAttribute("index"), (Object)bgIndex)) {
                    tmp = GifSplitterKt.color(colorEntry);
                    break;
                }
                Node node = colorEntry.getNextSibling();
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
                colorEntry = (IIOMetadataNode)node;
            }
        }
        return tmp;
    }

    static /* synthetic */ Color parseBackground$default(IIOMetadataNode iIOMetadataNode, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            color = null;
        }
        return GifSplitterKt.parseBackground(iIOMetadataNode, color);
    }

    private static final Rectangle parseSize(IIOMetadataNode $this$parseSize) {
        Rectangle rect = new Rectangle();
        NodeList globalScreeDescriptor = $this$parseSize.getElementsByTagName("LogicalScreenDescriptor");
        if (globalScreeDescriptor.getLength() > 0) {
            Node node = globalScreeDescriptor.item(0);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
            IIOMetadataNode screenDescriptor = (IIOMetadataNode)node;
            String string = screenDescriptor.getAttribute("logicalScreenWidth");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
            int n = Integer.parseInt(string);
            String string2 = screenDescriptor.getAttribute("logicalScreenHeight");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(...)");
            rect = new Rectangle(n, Integer.parseInt(string2));
        }
        return rect;
    }

    private static final Color color(IIOMetadataNode $this$color) {
        String string = $this$color.getAttribute("red");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
        int n = Integer.parseInt(string);
        String string2 = $this$color.getAttribute("green");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttribute(...)");
        int n2 = Integer.parseInt(string2);
        String string3 = $this$color.getAttribute("blue");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttribute(...)");
        return new Color(n, n2, Integer.parseInt(string3));
    }
}

