/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class Extract
extends JFrame {
    private BufferedImage bi = null;
    private byte[] extract = null;
    private int mask = 0;
    private int maskbits = 0;
    private boolean lsbFirst = false;
    private boolean rowFirst = true;
    private int rgbOrder = 0;
    private int extractBitPos = 0;
    private int extractBytePos = 0;
    private StringBuilder prev = null;
    private JFileChooser fileChooser;
    private String ls = System.getProperty("line.separator");
    private JRadioButton BGRButton;
    private JRadioButton BRGButton;
    private JRadioButton GBRButton;
    private JRadioButton GRBButton;
    private JRadioButton LSBButton;
    private JRadioButton MSBButton;
    private JRadioButton RBGButton;
    private JRadioButton RGBButton;
    private JCheckBox ab0;
    private JCheckBox ab1;
    private JCheckBox ab2;
    private JCheckBox ab3;
    private JCheckBox ab4;
    private JCheckBox ab5;
    private JCheckBox ab6;
    private JCheckBox ab7;
    private JCheckBox aba;
    private JPanel alphaBitPanel;
    private JLabel alphaLabel;
    private JCheckBox bb0;
    private JCheckBox bb1;
    private JCheckBox bb2;
    private JCheckBox bb3;
    private JCheckBox bb4;
    private JCheckBox bb5;
    private JCheckBox bb6;
    private JCheckBox bb7;
    private JCheckBox bba;
    private ButtonGroup bitGroup;
    private JLabel bitOrderLabel;
    private JPanel bitOrderPanel;
    private JLabel bitPlaneOrderLabel;
    private JPanel bitPlaneOrderPanel;
    private JPanel bitPlanesPanel;
    private JPanel blueBitPanel;
    private JLabel blueLabel;
    private JPanel buttonsPanel;
    private JRadioButton byColumnButton;
    private ButtonGroup byGroup;
    private JRadioButton byRowButton;
    private JButton cancelButton;
    private JLabel exPreviewLabel;
    private JPanel exPreviewPanel;
    private JLabel extractByLabel;
    private JPanel extractByPanel;
    private JCheckBox gb0;
    private JCheckBox gb1;
    private JCheckBox gb2;
    private JCheckBox gb3;
    private JCheckBox gb4;
    private JCheckBox gb5;
    private JCheckBox gb6;
    private JCheckBox gb7;
    private JCheckBox gba;
    private JPanel greenBitPanel;
    private JLabel greenLabel;
    private JCheckBox hdInclude;
    private JLabel hdLabel;
    private JTextArea jPreview;
    private JScrollPane jScrollPane1;
    private JPanel lhSettingsPanel;
    private JPanel optionsPanel;
    private JPanel orderSettingsPanel;
    private ButtonGroup planeGroup;
    private JPanel prevSettingsPanel;
    private JButton previewButton;
    private JCheckBox rb0;
    private JCheckBox rb1;
    private JCheckBox rb2;
    private JCheckBox rb3;
    private JCheckBox rb4;
    private JCheckBox rb5;
    private JCheckBox rb6;
    private JCheckBox rb7;
    private JCheckBox rba;
    private JPanel redBitPanel;
    private JLabel redLabel;
    private JPanel rhSettingsPanel;
    private JButton saveBinButton;
    private JButton saveTextButton;

    public Extract(BufferedImage b) {
        this.bi = b;
        this.initComponents();
    }

    private void getMask() {
        this.mask = 0;
        this.maskbits = 0;
        if (this.ab7.isSelected()) {
            this.mask += Integer.MIN_VALUE;
            ++this.maskbits;
        }
        if (this.ab6.isSelected()) {
            this.mask += 0x40000000;
            ++this.maskbits;
        }
        if (this.ab5.isSelected()) {
            this.mask += 0x20000000;
            ++this.maskbits;
        }
        if (this.ab4.isSelected()) {
            this.mask += 0x10000000;
            ++this.maskbits;
        }
        if (this.ab3.isSelected()) {
            this.mask += 0x8000000;
            ++this.maskbits;
        }
        if (this.ab2.isSelected()) {
            this.mask += 0x4000000;
            ++this.maskbits;
        }
        if (this.ab1.isSelected()) {
            this.mask += 0x2000000;
            ++this.maskbits;
        }
        if (this.ab0.isSelected()) {
            this.mask += 0x1000000;
            ++this.maskbits;
        }
        if (this.rb7.isSelected()) {
            this.mask += 0x800000;
            ++this.maskbits;
        }
        if (this.rb6.isSelected()) {
            this.mask += 0x400000;
            ++this.maskbits;
        }
        if (this.rb5.isSelected()) {
            this.mask += 0x200000;
            ++this.maskbits;
        }
        if (this.rb4.isSelected()) {
            this.mask += 0x100000;
            ++this.maskbits;
        }
        if (this.rb3.isSelected()) {
            this.mask += 524288;
            ++this.maskbits;
        }
        if (this.rb2.isSelected()) {
            this.mask += 262144;
            ++this.maskbits;
        }
        if (this.rb1.isSelected()) {
            this.mask += 131072;
            ++this.maskbits;
        }
        if (this.rb0.isSelected()) {
            this.mask += 65536;
            ++this.maskbits;
        }
        if (this.gb7.isSelected()) {
            this.mask += 32768;
            ++this.maskbits;
        }
        if (this.gb6.isSelected()) {
            this.mask += 16384;
            ++this.maskbits;
        }
        if (this.gb5.isSelected()) {
            this.mask += 8192;
            ++this.maskbits;
        }
        if (this.gb4.isSelected()) {
            this.mask += 4096;
            ++this.maskbits;
        }
        if (this.gb3.isSelected()) {
            this.mask += 2048;
            ++this.maskbits;
        }
        if (this.gb2.isSelected()) {
            this.mask += 1024;
            ++this.maskbits;
        }
        if (this.gb1.isSelected()) {
            this.mask += 512;
            ++this.maskbits;
        }
        if (this.gb0.isSelected()) {
            this.mask += 256;
            ++this.maskbits;
        }
        if (this.bb7.isSelected()) {
            this.mask += 128;
            ++this.maskbits;
        }
        if (this.bb6.isSelected()) {
            this.mask += 64;
            ++this.maskbits;
        }
        if (this.bb5.isSelected()) {
            this.mask += 32;
            ++this.maskbits;
        }
        if (this.bb4.isSelected()) {
            this.mask += 16;
            ++this.maskbits;
        }
        if (this.bb3.isSelected()) {
            this.mask += 8;
            ++this.maskbits;
        }
        if (this.bb2.isSelected()) {
            this.mask += 4;
            ++this.maskbits;
        }
        if (this.bb1.isSelected()) {
            this.mask += 2;
            ++this.maskbits;
        }
        if (this.bb0.isSelected()) {
            ++this.mask;
            ++this.maskbits;
        }
    }

    private void getBitOrderOptions() {
        this.rowFirst = this.byRowButton.isSelected();
        this.lsbFirst = this.LSBButton.isSelected();
        this.rgbOrder = this.RGBButton.isSelected() ? 1 : (this.RBGButton.isSelected() ? 2 : (this.GRBButton.isSelected() ? 3 : (this.GBRButton.isSelected() ? 4 : (this.BRGButton.isSelected() ? 5 : 6))));
    }

    private void addBit(int num) {
        if (num != 0) {
            int n = this.extractBytePos;
            this.extract[n] = (byte)(this.extract[n] + this.extractBitPos);
        }
        this.extractBitPos >>= 1;
        if (this.extractBitPos >= 1) {
            return;
        }
        this.extractBitPos = 128;
        ++this.extractBytePos;
        if (this.extractBytePos < this.extract.length) {
            this.extract[this.extractBytePos] = 0;
        }
    }

    private void extract8Bits(int nextByte, int bitMask) {
        for (int i = 0; i < 8; ++i) {
            if ((this.mask & bitMask) != 0) {
                this.addBit(nextByte & bitMask);
            }
            if (this.lsbFirst) {
                bitMask <<= 1;
                continue;
            }
            bitMask >>>= 1;
        }
    }

    private void extractBits(int nextByte) {
        if (this.lsbFirst) {
            this.extract8Bits(nextByte, 0x1000000);
            switch (this.rgbOrder) {
                case 1: {
                    this.extract8Bits(nextByte, 65536);
                    this.extract8Bits(nextByte, 256);
                    this.extract8Bits(nextByte, 1);
                    break;
                }
                case 2: {
                    this.extract8Bits(nextByte, 65536);
                    this.extract8Bits(nextByte, 1);
                    this.extract8Bits(nextByte, 256);
                    break;
                }
                case 3: {
                    this.extract8Bits(nextByte, 256);
                    this.extract8Bits(nextByte, 65536);
                    this.extract8Bits(nextByte, 1);
                    break;
                }
                case 4: {
                    this.extract8Bits(nextByte, 256);
                    this.extract8Bits(nextByte, 1);
                    this.extract8Bits(nextByte, 65536);
                    break;
                }
                case 5: {
                    this.extract8Bits(nextByte, 1);
                    this.extract8Bits(nextByte, 65536);
                    this.extract8Bits(nextByte, 256);
                    break;
                }
                case 6: {
                    this.extract8Bits(nextByte, 1);
                    this.extract8Bits(nextByte, 256);
                    this.extract8Bits(nextByte, 65536);
                }
            }
        } else {
            this.extract8Bits(nextByte, Integer.MIN_VALUE);
            switch (this.rgbOrder) {
                case 1: {
                    this.extract8Bits(nextByte, 0x800000);
                    this.extract8Bits(nextByte, 32768);
                    this.extract8Bits(nextByte, 128);
                    break;
                }
                case 2: {
                    this.extract8Bits(nextByte, 0x800000);
                    this.extract8Bits(nextByte, 128);
                    this.extract8Bits(nextByte, 32768);
                    break;
                }
                case 3: {
                    this.extract8Bits(nextByte, 32768);
                    this.extract8Bits(nextByte, 0x800000);
                    this.extract8Bits(nextByte, 128);
                    break;
                }
                case 4: {
                    this.extract8Bits(nextByte, 32768);
                    this.extract8Bits(nextByte, 128);
                    this.extract8Bits(nextByte, 0x800000);
                    break;
                }
                case 5: {
                    this.extract8Bits(nextByte, 128);
                    this.extract8Bits(nextByte, 0x800000);
                    this.extract8Bits(nextByte, 32768);
                    break;
                }
                case 6: {
                    this.extract8Bits(nextByte, 128);
                    this.extract8Bits(nextByte, 32768);
                    this.extract8Bits(nextByte, 0x800000);
                }
            }
        }
    }

    private void generateExtract() {
        this.getMask();
        this.getBitOrderOptions();
        int len = this.bi.getHeight() * this.bi.getWidth();
        len *= this.maskbits;
        len = (len + 7) / 8;
        this.extract = new byte[len];
        this.extractBitPos = 128;
        this.extractBytePos = 0;
        if (this.rowFirst) {
            for (int j = 0; j < this.bi.getHeight(); ++j) {
                for (int i = 0; i < this.bi.getWidth(); ++i) {
                    this.extractBits(this.bi.getRGB(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.bi.getWidth(); ++i) {
                for (int j = 0; j < this.bi.getHeight(); ++j) {
                    this.extractBits(this.bi.getRGB(i, j));
                }
            }
        }
    }

    private void generatePreview() {
        boolean hexDump = this.hdInclude.isSelected();
        this.prev = new StringBuilder();
        for (int i = 0; i < this.extract.length; i += 16) {
            int j;
            if (hexDump) {
                for (j = 0; j < 16 && i + j < this.extract.length; ++j) {
                    this.prev.append(this.m2(Integer.toHexString(this.extract[i + j] & 0xFF)));
                    if (j != 7) continue;
                    this.prev.append(' ');
                }
                this.prev.append("  ");
            }
            for (j = 0; j < 16 && i + j < this.extract.length; ++j) {
                char c = (char)this.extract[i + j];
                if (c >= ' ' && c <= '\u0080') {
                    this.prev.append(c);
                } else {
                    this.prev.append('.');
                }
                if (j != 7) continue;
                this.prev.append(' ');
            }
            this.prev.append(this.ls);
        }
        this.jPreview.setText(this.prev.toString());
    }

    private void savePreview() {
        this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
        int rVal = this.fileChooser.showSaveDialog(this);
        System.setProperty("user.dir", this.fileChooser.getCurrentDirectory().getAbsolutePath());
        File sfile = null;
        if (rVal == 0) {
            sfile = this.fileChooser.getSelectedFile();
            try {
                FileWriter fw = new FileWriter(sfile);
                fw.write(this.jPreview.getText());
                fw.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to write file: " + e.toString());
            }
        }
    }

    private void saveExtract() {
        this.fileChooser = new JFileChooser(System.getProperty("user.dir"));
        int rVal = this.fileChooser.showSaveDialog(this);
        System.setProperty("user.dir", this.fileChooser.getCurrentDirectory().getAbsolutePath());
        File sfile = null;
        if (rVal == 0) {
            sfile = this.fileChooser.getSelectedFile();
            try {
                FileOutputStream fw = new FileOutputStream(sfile);
                fw.write(this.extract);
                fw.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to write file: " + e.toString());
            }
        }
    }

    private String m2(String hx) {
        if (hx.length() < 2) {
            return "0" + hx;
        }
        return hx;
    }

    private void initComponents() {
        this.byGroup = new ButtonGroup();
        this.bitGroup = new ButtonGroup();
        this.planeGroup = new ButtonGroup();
        this.optionsPanel = new JPanel();
        this.lhSettingsPanel = new JPanel();
        this.bitPlanesPanel = new JPanel();
        this.alphaBitPanel = new JPanel();
        this.alphaLabel = new JLabel();
        this.aba = new JCheckBox();
        this.ab7 = new JCheckBox();
        this.ab6 = new JCheckBox();
        this.ab5 = new JCheckBox();
        this.ab4 = new JCheckBox();
        this.ab3 = new JCheckBox();
        this.ab2 = new JCheckBox();
        this.ab1 = new JCheckBox();
        this.ab0 = new JCheckBox();
        this.redBitPanel = new JPanel();
        this.redLabel = new JLabel();
        this.rba = new JCheckBox();
        this.rb7 = new JCheckBox();
        this.rb6 = new JCheckBox();
        this.rb5 = new JCheckBox();
        this.rb4 = new JCheckBox();
        this.rb3 = new JCheckBox();
        this.rb2 = new JCheckBox();
        this.rb1 = new JCheckBox();
        this.rb0 = new JCheckBox();
        this.greenBitPanel = new JPanel();
        this.greenLabel = new JLabel();
        this.gba = new JCheckBox();
        this.gb7 = new JCheckBox();
        this.gb6 = new JCheckBox();
        this.gb5 = new JCheckBox();
        this.gb4 = new JCheckBox();
        this.gb3 = new JCheckBox();
        this.gb2 = new JCheckBox();
        this.gb1 = new JCheckBox();
        this.gb0 = new JCheckBox();
        this.blueBitPanel = new JPanel();
        this.blueLabel = new JLabel();
        this.bba = new JCheckBox();
        this.bb7 = new JCheckBox();
        this.bb6 = new JCheckBox();
        this.bb5 = new JCheckBox();
        this.bb4 = new JCheckBox();
        this.bb3 = new JCheckBox();
        this.bb2 = new JCheckBox();
        this.bb1 = new JCheckBox();
        this.bb0 = new JCheckBox();
        this.prevSettingsPanel = new JPanel();
        this.hdLabel = new JLabel();
        this.hdInclude = new JCheckBox();
        this.rhSettingsPanel = new JPanel();
        this.orderSettingsPanel = new JPanel();
        this.extractByPanel = new JPanel();
        this.extractByLabel = new JLabel();
        this.byRowButton = new JRadioButton();
        this.byColumnButton = new JRadioButton();
        this.bitOrderPanel = new JPanel();
        this.bitOrderLabel = new JLabel();
        this.MSBButton = new JRadioButton();
        this.LSBButton = new JRadioButton();
        this.bitPlaneOrderPanel = new JPanel();
        this.bitPlaneOrderLabel = new JLabel();
        this.RGBButton = new JRadioButton();
        this.RBGButton = new JRadioButton();
        this.GBRButton = new JRadioButton();
        this.GRBButton = new JRadioButton();
        this.BRGButton = new JRadioButton();
        this.BGRButton = new JRadioButton();
        this.exPreviewPanel = new JPanel();
        this.exPreviewLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPreview = new JTextArea();
        this.buttonsPanel = new JPanel();
        this.previewButton = new JButton();
        this.saveTextButton = new JButton();
        this.saveBinButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(790, 560));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.optionsPanel.setMinimumSize(new Dimension(720, 280));
        this.optionsPanel.setPreferredSize(new Dimension(720, 280));
        this.optionsPanel.setLayout(new BorderLayout());
        this.lhSettingsPanel.setMinimumSize(new Dimension(360, 280));
        this.lhSettingsPanel.setPreferredSize(new Dimension(360, 280));
        int bitPlanesWidth = 480;
        this.bitPlanesPanel.setBorder(BorderFactory.createTitledBorder("Bit Planes"));
        this.bitPlanesPanel.setMinimumSize(new Dimension(bitPlanesWidth, 200));
        this.bitPlanesPanel.setPreferredSize(new Dimension(bitPlanesWidth, 200));
        this.alphaBitPanel.setName("alphaBitPanel");
        this.alphaBitPanel.setPreferredSize(new Dimension(bitPlanesWidth - 10, 34));
        this.alphaLabel.setHorizontalAlignment(0);
        this.alphaLabel.setText("Alpha");
        this.alphaLabel.setHorizontalTextPosition(0);
        this.alphaLabel.setMaximumSize(new Dimension(40, 14));
        this.alphaLabel.setMinimumSize(new Dimension(40, 14));
        this.alphaLabel.setPreferredSize(new Dimension(40, 14));
        this.alphaBitPanel.add(this.alphaLabel);
        this.aba.setText("all");
        this.alphaBitPanel.add(this.aba);
        this.checkAllListener(this.aba, this.ab7, this.ab6, this.ab5, this.ab4, this.ab3, this.ab2, this.ab1, this.ab0);
        this.ab7.setText("7");
        this.alphaBitPanel.add(this.ab7);
        this.ab6.setText("6");
        this.alphaBitPanel.add(this.ab6);
        this.ab5.setText("5");
        this.alphaBitPanel.add(this.ab5);
        this.ab4.setText("4");
        this.alphaBitPanel.add(this.ab4);
        this.ab3.setText("3");
        this.alphaBitPanel.add(this.ab3);
        this.ab2.setText("2");
        this.alphaBitPanel.add(this.ab2);
        this.ab1.setText("1");
        this.alphaBitPanel.add(this.ab1);
        this.ab0.setText("0");
        this.alphaBitPanel.add(this.ab0);
        this.bitPlanesPanel.add(this.alphaBitPanel);
        this.alphaBitPanel.getAccessibleContext().setAccessibleName("alphaBitPanel");
        this.redBitPanel.setPreferredSize(new Dimension(bitPlanesWidth - 10, 34));
        this.redLabel.setHorizontalAlignment(0);
        this.redLabel.setText("Red");
        this.redLabel.setHorizontalTextPosition(0);
        this.redLabel.setMaximumSize(new Dimension(40, 14));
        this.redLabel.setMinimumSize(new Dimension(40, 14));
        this.redLabel.setPreferredSize(new Dimension(40, 14));
        this.redBitPanel.add(this.redLabel);
        this.rba.setText("all");
        this.redBitPanel.add(this.rba);
        this.checkAllListener(this.rba, this.rb7, this.rb6, this.rb5, this.rb4, this.rb3, this.rb2, this.rb1, this.rb0);
        this.rb7.setText("7");
        this.redBitPanel.add(this.rb7);
        this.rb6.setText("6");
        this.redBitPanel.add(this.rb6);
        this.rb5.setText("5");
        this.redBitPanel.add(this.rb5);
        this.rb4.setText("4");
        this.redBitPanel.add(this.rb4);
        this.rb3.setText("3");
        this.redBitPanel.add(this.rb3);
        this.rb2.setText("2");
        this.redBitPanel.add(this.rb2);
        this.rb1.setText("1");
        this.redBitPanel.add(this.rb1);
        this.rb0.setText("0");
        this.redBitPanel.add(this.rb0);
        this.bitPlanesPanel.add(this.redBitPanel);
        this.greenBitPanel.setPreferredSize(new Dimension(bitPlanesWidth - 10, 34));
        this.greenLabel.setHorizontalAlignment(0);
        this.greenLabel.setText("Green");
        this.greenLabel.setHorizontalTextPosition(0);
        this.greenLabel.setMaximumSize(new Dimension(40, 14));
        this.greenLabel.setMinimumSize(new Dimension(40, 14));
        this.greenLabel.setPreferredSize(new Dimension(40, 14));
        this.greenBitPanel.add(this.greenLabel);
        this.gba.setText("all");
        this.greenBitPanel.add(this.gba);
        this.checkAllListener(this.gba, this.gb7, this.gb6, this.gb5, this.gb4, this.gb3, this.gb2, this.gb1, this.gb0);
        this.gb7.setText("7");
        this.greenBitPanel.add(this.gb7);
        this.gb6.setText("6");
        this.greenBitPanel.add(this.gb6);
        this.gb5.setText("5");
        this.greenBitPanel.add(this.gb5);
        this.gb4.setText("4");
        this.greenBitPanel.add(this.gb4);
        this.gb3.setText("3");
        this.greenBitPanel.add(this.gb3);
        this.gb2.setText("2");
        this.greenBitPanel.add(this.gb2);
        this.gb1.setText("1");
        this.greenBitPanel.add(this.gb1);
        this.gb0.setText("0");
        this.greenBitPanel.add(this.gb0);
        this.bitPlanesPanel.add(this.greenBitPanel);
        this.blueBitPanel.setPreferredSize(new Dimension(bitPlanesWidth - 10, 34));
        this.blueLabel.setHorizontalAlignment(0);
        this.blueLabel.setText("Blue");
        this.blueLabel.setHorizontalTextPosition(0);
        this.blueLabel.setMaximumSize(new Dimension(40, 14));
        this.blueLabel.setMinimumSize(new Dimension(40, 14));
        this.blueLabel.setPreferredSize(new Dimension(40, 14));
        this.blueBitPanel.add(this.blueLabel);
        this.bba.setText("all");
        this.blueBitPanel.add(this.bba);
        this.checkAllListener(this.bba, this.bb7, this.bb6, this.bb5, this.bb4, this.bb3, this.bb2, this.bb1, this.bb0);
        this.bb7.setText("7");
        this.blueBitPanel.add(this.bb7);
        this.bb6.setText("6");
        this.blueBitPanel.add(this.bb6);
        this.bb5.setText("5");
        this.blueBitPanel.add(this.bb5);
        this.bb4.setText("4");
        this.blueBitPanel.add(this.bb4);
        this.bb3.setText("3");
        this.blueBitPanel.add(this.bb3);
        this.bb2.setText("2");
        this.blueBitPanel.add(this.bb2);
        this.bb1.setText("1");
        this.blueBitPanel.add(this.bb1);
        this.bb0.setText("0");
        this.blueBitPanel.add(this.bb0);
        this.bitPlanesPanel.add(this.blueBitPanel);
        this.lhSettingsPanel.add(this.bitPlanesPanel);
        this.prevSettingsPanel.setBorder(BorderFactory.createTitledBorder("Preview Settings"));
        this.prevSettingsPanel.setMinimumSize(new Dimension(360, 50));
        this.prevSettingsPanel.setPreferredSize(new Dimension(360, 50));
        this.prevSettingsPanel.setLayout(new FlowLayout(1, 5, 0));
        this.hdLabel.setText("Include Hex Dump In Preview");
        this.prevSettingsPanel.add(this.hdLabel);
        this.hdInclude.setSelected(true);
        this.prevSettingsPanel.add(this.hdInclude);
        this.lhSettingsPanel.add(this.prevSettingsPanel);
        this.optionsPanel.add((Component)this.lhSettingsPanel, "Center");
        this.rhSettingsPanel.setMinimumSize(new Dimension(300, 280));
        this.rhSettingsPanel.setPreferredSize(new Dimension(300, 280));
        this.rhSettingsPanel.setLayout(new FlowLayout(1, 0, 5));
        this.orderSettingsPanel.setBorder(BorderFactory.createTitledBorder("Order settings"));
        this.orderSettingsPanel.setPreferredSize(new Dimension(280, 260));
        this.orderSettingsPanel.setLayout(new FlowLayout(0));
        this.extractByLabel.setText("Extract By");
        this.extractByPanel.add(this.extractByLabel);
        this.byGroup.add(this.byRowButton);
        this.byRowButton.setSelected(true);
        this.byRowButton.setText("Row");
        this.extractByPanel.add(this.byRowButton);
        this.byGroup.add(this.byColumnButton);
        this.byColumnButton.setText("Column");
        this.extractByPanel.add(this.byColumnButton);
        this.orderSettingsPanel.add(this.extractByPanel);
        this.bitOrderPanel.setPreferredSize(new Dimension(250, 41));
        this.bitOrderPanel.setLayout(new FlowLayout(0));
        this.bitOrderLabel.setText("Bit Order");
        this.bitOrderPanel.add(this.bitOrderLabel);
        this.bitGroup.add(this.MSBButton);
        this.MSBButton.setSelected(true);
        this.MSBButton.setText("MSB First");
        this.bitOrderPanel.add(this.MSBButton);
        this.bitGroup.add(this.LSBButton);
        this.LSBButton.setText("LSB First");
        this.bitOrderPanel.add(this.LSBButton);
        this.orderSettingsPanel.add(this.bitOrderPanel);
        this.bitPlaneOrderPanel.setPreferredSize(new Dimension(250, 130));
        this.bitPlaneOrderLabel.setText("Bit Plane Order");
        this.planeGroup.add(this.RGBButton);
        this.RGBButton.setSelected(true);
        this.RGBButton.setText("RGB");
        this.planeGroup.add(this.RBGButton);
        this.RBGButton.setText("RBG");
        this.planeGroup.add(this.GBRButton);
        this.GBRButton.setText("GBR");
        this.planeGroup.add(this.GRBButton);
        this.GRBButton.setText("GRB");
        this.planeGroup.add(this.BRGButton);
        this.BRGButton.setText("BRG");
        this.planeGroup.add(this.BGRButton);
        this.BGRButton.setText("BGR");
        GroupLayout bitPlaneOrderPanelLayout = new GroupLayout(this.bitPlaneOrderPanel);
        this.bitPlaneOrderPanel.setLayout(bitPlaneOrderPanelLayout);
        bitPlaneOrderPanelLayout.setHorizontalGroup(bitPlaneOrderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bitPlaneOrderPanelLayout.createSequentialGroup().addContainerGap().addGroup(bitPlaneOrderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bitPlaneOrderLabel).addGroup(bitPlaneOrderPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(bitPlaneOrderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bitPlaneOrderPanelLayout.createSequentialGroup().addComponent(this.RBGButton).addGap(18, 18, 18).addComponent(this.BRGButton)).addGroup(bitPlaneOrderPanelLayout.createSequentialGroup().addComponent(this.RGBButton).addGap(18, 18, 18).addComponent(this.GRBButton)).addGroup(bitPlaneOrderPanelLayout.createSequentialGroup().addComponent(this.GBRButton).addGap(18, 18, 18).addComponent(this.BGRButton))))).addContainerGap(72, Short.MAX_VALUE)));
        bitPlaneOrderPanelLayout.setVerticalGroup(bitPlaneOrderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bitPlaneOrderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.bitPlaneOrderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(bitPlaneOrderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RGBButton).addComponent(this.GRBButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(bitPlaneOrderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.RBGButton).addComponent(this.BRGButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(bitPlaneOrderPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.GBRButton).addComponent(this.BGRButton)).addContainerGap(13, Short.MAX_VALUE)));
        this.orderSettingsPanel.add(this.bitPlaneOrderPanel);
        this.rhSettingsPanel.add(this.orderSettingsPanel);
        this.optionsPanel.add((Component)this.rhSettingsPanel, "East");
        this.getContentPane().add((Component)this.optionsPanel, "Center");
        this.optionsPanel.getAccessibleContext().setAccessibleName("saveText");
        this.exPreviewPanel.setLayout(new BorderLayout());
        this.exPreviewLabel.setHorizontalAlignment(0);
        this.exPreviewLabel.setText("Extract Preview");
        this.exPreviewLabel.setHorizontalTextPosition(0);
        this.exPreviewLabel.setMinimumSize(new Dimension(20, 14));
        this.exPreviewPanel.add((Component)this.exPreviewLabel, "Center");
        this.exPreviewLabel.getAccessibleContext().setAccessibleName("previewLabel");
        this.jPreview.setColumns(20);
        this.jPreview.setEditable(false);
        this.jPreview.setFont(new Font("Courier New", 0, 14));
        this.jPreview.setRows(10);
        this.jPreview.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane1.setViewportView(this.jPreview);
        this.exPreviewPanel.add((Component)this.jScrollPane1, "Last");
        this.getContentPane().add((Component)this.exPreviewPanel, "North");
        this.previewButton.setText("Preview");
        this.previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extract.this.previewButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.previewButton);
        this.previewButton.getAccessibleContext().setAccessibleName("previewButton");
        this.saveTextButton.setText("Save Text");
        this.saveTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extract.this.saveTextButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.saveTextButton);
        this.saveTextButton.getAccessibleContext().setAccessibleName("saveTextButton");
        this.saveBinButton.setText("Save Bin");
        this.saveBinButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extract.this.saveBinButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.saveBinButton);
        this.saveBinButton.getAccessibleContext().setAccessibleName("saveBinButton");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Extract.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonsPanel.add(this.cancelButton);
        this.cancelButton.getAccessibleContext().setAccessibleName("cancelButton");
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.pack();
    }

    private void checkAllListener(JCheckBox ca, JCheckBox c7, JCheckBox c6, JCheckBox c5, JCheckBox c4, JCheckBox c3, JCheckBox c2, JCheckBox c1, JCheckBox c0) {
        ca.addItemListener(e -> {
            c7.setSelected(ca.isSelected());
            c6.setSelected(ca.isSelected());
            c5.setSelected(ca.isSelected());
            c4.setSelected(ca.isSelected());
            c3.setSelected(ca.isSelected());
            c2.setSelected(ca.isSelected());
            c1.setSelected(ca.isSelected());
            c0.setSelected(ca.isSelected());
        });
    }

    private void previewButtonActionPerformed(ActionEvent evt) {
        this.generateExtract();
        this.generatePreview();
    }

    private void saveTextButtonActionPerformed(ActionEvent evt) {
        this.generateExtract();
        this.generatePreview();
        this.savePreview();
    }

    private void saveBinButtonActionPerformed(ActionEvent evt) {
        this.generateExtract();
        this.saveExtract();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

