/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import stegsolve.DPanel;

public class FrameBrowser
extends JFrame {
    private JLabel nowShowing;
    private JPanel buttonPanel;
    private JButton forwardButton;
    private JButton backwardButton;
    private JButton saveButton;
    private DPanel dp;
    private JScrollPane scrollPane;
    private BufferedImage bi = null;
    private List<BufferedImage> frames = null;
    private int fnum = 0;
    private int numframes = 0;
    private Action backButtonPress = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FrameBrowser.this.backwardButtonActionPerformed(e);
        }
    };
    private Action forwardButtonPress = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FrameBrowser.this.forwardButtonActionPerformed(e);
        }
    };

    public FrameBrowser(BufferedImage b, File f) {
        this.bi = b;
        this.initComponents();
        this.fnum = 0;
        this.numframes = 0;
        this.frames = new ArrayList<BufferedImage>();
        try {
            BufferedImage bnext;
            ImageReader rr;
            ImageInputStream ii = ImageIO.createImageInputStream(f);
            if (ii == null) {
                System.out.println("Couldn't create input stream");
            }
            if ((rr = ImageIO.getImageReaders(ii).next()) == null) {
                System.out.println("No image reader");
            }
            rr.setInput(ii);
            int fread = rr.getMinIndex();
            while ((bnext = rr.read(this.numframes + fread)) != null) {
                this.frames.add(bnext);
                ++this.numframes;
            }
            System.out.println("total frames " + this.numframes);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Failed to load file: " + e.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.newImage();
    }

    private void initComponents() {
        this.nowShowing = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.nowShowing, "North");
        this.buttonPanel = new JPanel();
        this.backwardButton = new JButton("<");
        this.backwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameBrowser.this.backwardButtonActionPerformed(evt);
            }
        });
        this.forwardButton = new JButton(">");
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameBrowser.this.forwardButtonActionPerformed(evt);
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameBrowser.this.saveButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.backwardButton);
        this.buttonPanel.add(this.forwardButton);
        this.buttonPanel.add(this.saveButton);
        this.add((Component)this.buttonPanel, "South");
        this.backwardButton.getInputMap(2).put(KeyStroke.getKeyStroke(37, 0), "back");
        this.backwardButton.getActionMap().put("back", this.backButtonPress);
        this.forwardButton.getInputMap(2).put(KeyStroke.getKeyStroke(39, 0), "forward");
        this.forwardButton.getActionMap().put("forward", this.forwardButtonPress);
        this.dp = new DPanel();
        this.scrollPane = new JScrollPane(this.dp);
        this.add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void backwardButtonActionPerformed(ActionEvent evt) {
        --this.fnum;
        if (this.fnum < 0) {
            this.fnum = this.numframes - 1;
        }
        this.updateImage();
    }

    private void forwardButtonActionPerformed(ActionEvent evt) {
        ++this.fnum;
        if (this.fnum >= this.numframes) {
            this.fnum = 0;
        }
        this.updateImage();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        File sfile = null;
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "gif", "png", "bmp");
        fileChooser.setFileFilter(filter);
        fileChooser.setSelectedFile(new File("frame" + (this.fnum + 1) + ".bmp"));
        int rVal = fileChooser.showSaveDialog(this);
        System.setProperty("user.dir", fileChooser.getCurrentDirectory().getAbsolutePath());
        if (rVal == 0) {
            sfile = fileChooser.getSelectedFile();
            try {
                BufferedImage bbx = this.frames.get(this.fnum);
                int rns = sfile.getName().lastIndexOf(".") + 1;
                if (rns == 0) {
                    ImageIO.write((RenderedImage)bbx, "bmp", sfile);
                } else {
                    ImageIO.write((RenderedImage)bbx, sfile.getName().substring(rns), sfile);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to write file: " + e.toString());
            }
        }
    }

    private void updateImage() {
        this.nowShowing.setText("Frame : " + (this.fnum + 1) + " of " + this.numframes);
        if (this.numframes == 0) {
            return;
        }
        this.dp.setImage(this.frames.get(this.fnum));
        this.repaint();
    }

    private void newImage() {
        this.nowShowing.setText("Frame : " + (this.fnum + 1) + " of " + this.numframes);
        if (this.numframes == 0) {
            return;
        }
        this.dp.setImage(this.frames.get(this.fnum));
        this.dp.setSize(this.bi.getWidth(), this.bi.getHeight());
        this.dp.setPreferredSize(new Dimension(this.bi.getWidth(), this.bi.getHeight()));
        this.setMaximumSize(this.getToolkit().getScreenSize());
        this.pack();
        this.scrollPane.revalidate();
        this.repaint();
    }
}

