/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.image.BufferedImage;

public class StereoTransform {
    private BufferedImage originalImage;
    private BufferedImage transform;
    private int transNum;

    StereoTransform(BufferedImage bi) {
        this.originalImage = bi;
        this.transNum = 0;
        this.calcTrans();
    }

    private void calcTrans() {
        this.transform = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), 1);
        for (int i = 0; i < this.originalImage.getWidth(); ++i) {
            for (int j = 0; j < this.originalImage.getHeight(); ++j) {
                int col = 0;
                int fcol = this.originalImage.getRGB(i, j);
                col = fcol ^ this.originalImage.getRGB((i + this.transNum) % this.originalImage.getWidth(), j) & 0xFFFFFF;
                this.transform.setRGB(i, j, col);
            }
        }
    }

    public void back() {
        --this.transNum;
        if (this.transNum < 0) {
            this.transNum = this.originalImage.getWidth() - 1;
        }
        this.calcTrans();
    }

    public void forward() {
        ++this.transNum;
        if (this.transNum >= this.originalImage.getWidth()) {
            this.transNum = 0;
        }
        this.calcTrans();
    }

    public String getText() {
        return "Offset: " + this.transNum;
    }

    public BufferedImage getImage() {
        return this.transform;
    }
}

