/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.util.Random;

public class Transform {
    private BufferedImage originalImage;
    private BufferedImage transform;
    private int transNum;
    private static final int MAXTRANS = 41;

    Transform(BufferedImage bi) {
        this.transform = this.originalImage = bi;
        this.transNum = 0;
    }

    private void transfrombit(int d) {
        this.transform = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), 1);
        for (int i = 0; i < this.originalImage.getWidth(); ++i) {
            for (int j = 0; j < this.originalImage.getHeight(); ++j) {
                int col = 0;
                int fcol = this.originalImage.getRGB(i, j);
                if ((fcol >>> d & 1) > 0) {
                    col = 0xFFFFFF;
                }
                this.transform.setRGB(i, j, col);
            }
        }
    }

    private void transmask(int mask) {
        this.transform = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), 1);
        for (int i = 0; i < this.originalImage.getWidth(); ++i) {
            for (int j = 0; j < this.originalImage.getHeight(); ++j) {
                int col = 0;
                int fcol = this.originalImage.getRGB(i, j);
                col = fcol & mask;
                if (col > 0xFFFFFF || col < 0) {
                    col >>>= 8;
                }
                this.transform.setRGB(i, j, col);
            }
        }
    }

    private void inversion() {
        this.transform = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), 1);
        for (int i = 0; i < this.originalImage.getWidth(); ++i) {
            for (int j = 0; j < this.originalImage.getHeight(); ++j) {
                int col = 0;
                int fcol = this.originalImage.getRGB(i, j);
                col = fcol ^ 0xFFFFFF;
                this.transform.setRGB(i, j, col);
            }
        }
    }

    private void graybits() {
        this.transform = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), 1);
        for (int i = 0; i < this.originalImage.getWidth(); ++i) {
            for (int j = 0; j < this.originalImage.getHeight(); ++j) {
                int col = 0;
                int fcol = this.originalImage.getRGB(i, j);
                if ((fcol & 0xFF) == (fcol & 0xFF00) >> 8 && (fcol & 0xFF) == (fcol & 0xFF0000) >> 16) {
                    col = 0xFFFFFF;
                }
                this.transform.setRGB(i, j, col);
            }
        }
    }

    private void random_colormap() {
        Random rnd = new Random();
        int bm = rnd.nextInt(256);
        int ba = rnd.nextInt(256);
        int bx = rnd.nextInt(256);
        int gm = rnd.nextInt(256);
        int ga = rnd.nextInt(256);
        int gx = rnd.nextInt(256);
        int rm = rnd.nextInt(256);
        int ra = rnd.nextInt(256);
        int rx = rnd.nextInt(256);
        this.transform = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), 1);
        for (int i = 0; i < this.originalImage.getWidth(); ++i) {
            for (int j = 0; j < this.originalImage.getHeight(); ++j) {
                int col = 0;
                int fcol = this.originalImage.getRGB(i, j);
                int b = (fcol & 0xFF) * bm;
                b = (b * bm ^ bx) + ba;
                int g = ((fcol & 0xFF00) >> 8) * gm;
                g = (g * gm ^ gx) + ga;
                int r = ((fcol & 0xFF0000) >> 16) * rm;
                r = (r * rm ^ rx) + ra;
                col = (r << 16) + (g << 8) + b + (fcol & 0xFF000000);
                this.transform.setRGB(i, j, col);
            }
        }
    }

    private void random_indexmap() {
        int bits;
        Random rnd = new Random();
        IndexColorModel cm = (IndexColorModel)this.originalImage.getColorModel();
        int[] gcs = cm.getComponentSize();
        if (gcs[1] > (bits = gcs[0])) {
            bits = gcs[1];
        }
        if (gcs[2] > bits) {
            bits = gcs[2];
        }
        int size = cm.getMapSize();
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        cm.getReds(r);
        cm.getGreens(g);
        cm.getBlues(b);
        for (int i = 0; i < size; ++i) {
            r[i] = (byte)rnd.nextInt(256);
            g[i] = (byte)rnd.nextInt(256);
            b[i] = (byte)rnd.nextInt(256);
        }
        this.transform = new BufferedImage(this.originalImage.getWidth(), this.originalImage.getHeight(), 13, new IndexColorModel(bits, size, r, g, b));
        this.transform.setData(this.originalImage.getRaster());
    }

    private void randommap() {
        ColorModel cm = this.originalImage.getColorModel();
        if (cm instanceof ComponentColorModel) {
            this.random_colormap();
        } else if (cm instanceof IndexColorModel) {
            this.random_indexmap();
        } else if (cm instanceof PackedColorModel) {
            this.random_colormap();
        }
    }

    private void calcTrans() {
        switch (this.transNum) {
            case 0: {
                this.transform = this.originalImage;
                return;
            }
            case 1: {
                this.inversion();
                return;
            }
            case 2: {
                this.transfrombit(31);
                return;
            }
            case 3: {
                this.transfrombit(30);
                return;
            }
            case 4: {
                this.transfrombit(29);
                return;
            }
            case 5: {
                this.transfrombit(28);
                return;
            }
            case 6: {
                this.transfrombit(27);
                return;
            }
            case 7: {
                this.transfrombit(26);
                return;
            }
            case 8: {
                this.transfrombit(25);
                return;
            }
            case 9: {
                this.transfrombit(24);
                return;
            }
            case 10: {
                this.transfrombit(23);
                return;
            }
            case 11: {
                this.transfrombit(22);
                return;
            }
            case 12: {
                this.transfrombit(21);
                return;
            }
            case 13: {
                this.transfrombit(20);
                return;
            }
            case 14: {
                this.transfrombit(19);
                return;
            }
            case 15: {
                this.transfrombit(18);
                return;
            }
            case 16: {
                this.transfrombit(17);
                return;
            }
            case 17: {
                this.transfrombit(16);
                return;
            }
            case 18: {
                this.transfrombit(15);
                return;
            }
            case 19: {
                this.transfrombit(14);
                return;
            }
            case 20: {
                this.transfrombit(13);
                return;
            }
            case 21: {
                this.transfrombit(12);
                return;
            }
            case 22: {
                this.transfrombit(11);
                return;
            }
            case 23: {
                this.transfrombit(10);
                return;
            }
            case 24: {
                this.transfrombit(9);
                return;
            }
            case 25: {
                this.transfrombit(8);
                return;
            }
            case 26: {
                this.transfrombit(7);
                return;
            }
            case 27: {
                this.transfrombit(6);
                return;
            }
            case 28: {
                this.transfrombit(5);
                return;
            }
            case 29: {
                this.transfrombit(4);
                return;
            }
            case 30: {
                this.transfrombit(3);
                return;
            }
            case 31: {
                this.transfrombit(2);
                return;
            }
            case 32: {
                this.transfrombit(1);
                return;
            }
            case 33: {
                this.transfrombit(0);
                return;
            }
            case 34: {
                this.transmask(-16777216);
                return;
            }
            case 35: {
                this.transmask(0xFF0000);
                return;
            }
            case 36: {
                this.transmask(65280);
                return;
            }
            case 37: {
                this.transmask(255);
                return;
            }
            case 38: {
                this.randommap();
                return;
            }
            case 39: {
                this.randommap();
                return;
            }
            case 40: {
                this.randommap();
                return;
            }
            case 41: {
                this.graybits();
                return;
            }
        }
        this.transform = this.originalImage;
    }

    public void back() {
        --this.transNum;
        if (this.transNum < 0) {
            this.transNum = 41;
        }
        this.calcTrans();
    }

    public void forward() {
        ++this.transNum;
        if (this.transNum > 41) {
            this.transNum = 0;
        }
        this.calcTrans();
    }

    public String getText() {
        switch (this.transNum) {
            case 0: {
                return "Normal Image";
            }
            case 1: {
                return "Colour Inversion (Xor)";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "Alpha plane " + (9 - this.transNum);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return "Red plane " + (17 - this.transNum);
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return "Green plane " + (25 - this.transNum);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return "Blue plane " + (33 - this.transNum);
            }
            case 34: {
                return "Full alpha";
            }
            case 35: {
                return "Full red";
            }
            case 36: {
                return "Full green";
            }
            case 37: {
                return "Full blue";
            }
            case 38: {
                return "Random colour map 1";
            }
            case 39: {
                return "Random colour map 2";
            }
            case 40: {
                return "Random colour map 3";
            }
            case 41: {
                return "Gray bits";
            }
        }
        return "";
    }

    public BufferedImage getImage() {
        return this.transform;
    }
}

