/*
 * Decompiled with CFR 0.152.
 */
package stegsolve;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import stegsolve.SliderChangeListener;

public class ZoomSlider
extends JPanel {
    private JSlider slider;
    private JTextField textBox;
    private int value;
    private List<SliderChangeListener> changeListeners = new ArrayList<SliderChangeListener>();

    public int getValue() {
        return this.value;
    }

    void setValue(int value) {
        this.slider.setValue(value);
        this.textBox.setText(String.valueOf(value));
        this.value = value;
        for (SliderChangeListener scl : this.changeListeners) {
            scl.change(value);
        }
    }

    ZoomSlider(int min, int max, int defaultValue) {
        JLabel tip = new JLabel("Zoom:");
        this.add(tip);
        this.slider = new JSlider(min, max, defaultValue);
        this.slider.addChangeListener((ChangeEvent e) -> this.setValue(this.slider.getValue()));
        this.add(this.slider);
        this.textBox = new JTextField(String.valueOf(defaultValue), 5);
        this.textBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ZoomSlider.this.setValue(Integer.parseInt(ZoomSlider.this.textBox.getText()));
                }
            }
        });
        this.slider.setMaximumSize(new Dimension(500, 25));
        this.add(this.textBox);
        this.value = defaultValue;
    }

    void addChangeListener(SliderChangeListener listener) {
        this.changeListeners.add(listener);
    }
}

