/*
 * Decompiled with CFR 0.152.
 */
package com.azul.tooling.in;

import com.azul.tooling.in.Model;
import com.azul.tooling.in.Tooling;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;

@Model(value="com.azul.tooling.AnyConnectionEventModel")
public final class NetConnectionEvent
implements Tooling.ToolingEvent {
    private static final boolean isEnabled = Tooling.isEventTypeEnabled(NetConnectionEvent.class);
    public final String protocol;
    public final InetAddress toAddress;
    public final int toPort;
    public final InetAddress fromAddress;
    public final int fromPort;
    public final long connectionInitiatedTime;
    public final long connectionEstablishedTime;
    public final Map<String, List<String>> headers;
    public final String url;
    public final boolean originating;

    private NetConnectionEvent(String string, InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, long l, long l2, boolean bl, Map<String, List<String>> map, String string2) {
        this.protocol = string;
        this.toAddress = inetAddress;
        this.toPort = n;
        this.fromAddress = inetAddress2;
        this.fromPort = n2;
        this.connectionInitiatedTime = l;
        this.connectionEstablishedTime = l2;
        this.originating = bl;
        this.headers = map;
        this.url = string2;
    }

    public static NetConnectionEvent udpConnectionEvent(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, long l, boolean bl) {
        return new NetConnectionEvent("udp", inetAddress, n, inetAddress2, n2, -1L, l, bl, null, null);
    }

    public static NetConnectionEvent httpConnectionEvent(String string, InetAddress inetAddress, int n, Map<String, List<String>> map, String string2) {
        return new NetConnectionEvent(string, inetAddress, n, null, -1, -1L, System.currentTimeMillis(), true, map, string2);
    }

    public static NetConnectionEvent tcpConnectionEvent(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, long l, long l2, boolean bl) {
        return new NetConnectionEvent("tcp", inetAddress, n, inetAddress2, n2, l, l2, bl, null, null);
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public boolean isEventEnabled() {
        return NetConnectionEvent.isEnabled();
    }
}

