/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.util.Date;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5ProxyCredential;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KerberosSecrets;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Krb5InitCredential
extends KerberosTicket
implements Krb5CredElement {
    private static final long serialVersionUID = 7723415700837898232L;
    private Krb5NameElement name;
    private Credentials krb5Credentials;
    public KerberosTicket proxyTicket;

    private Krb5InitCredential(Krb5NameElement krb5NameElement, byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, KerberosPrincipal kerberosPrincipal3, KerberosPrincipal kerberosPrincipal4, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws GSSException {
        super(byArray, kerberosPrincipal, kerberosPrincipal3, byArray2, n, blArray, date, date2, date3, date4, inetAddressArray);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetClientAlias(this, kerberosPrincipal2);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetServerAlias(this, kerberosPrincipal4);
        this.name = krb5NameElement;
        try {
            this.krb5Credentials = new Credentials(byArray, kerberosPrincipal.getName(), kerberosPrincipal2 != null ? kerberosPrincipal2.getName() : null, kerberosPrincipal3.getName(), kerberosPrincipal4 != null ? kerberosPrincipal4.getName() : null, byArray2, n, blArray, date, date2, date3, date4, inetAddressArray);
        }
        catch (KrbException krbException) {
            throw new GSSException(13, -1, krbException.getMessage());
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.getMessage());
        }
    }

    private Krb5InitCredential(Krb5NameElement krb5NameElement, Credentials credentials, byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, KerberosPrincipal kerberosPrincipal3, KerberosPrincipal kerberosPrincipal4, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws GSSException {
        super(byArray, kerberosPrincipal, kerberosPrincipal3, byArray2, n, blArray, date, date2, date3, date4, inetAddressArray);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetClientAlias(this, kerberosPrincipal2);
        KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetServerAlias(this, kerberosPrincipal4);
        this.name = krb5NameElement;
        this.krb5Credentials = credentials;
    }

    static Krb5InitCredential getInstance(GSSCaller gSSCaller, Krb5NameElement krb5NameElement, int n) throws GSSException {
        Object object;
        KerberosTicket kerberosTicket = Krb5InitCredential.getTgt(gSSCaller, krb5NameElement, n);
        if (kerberosTicket == null) {
            throw new GSSException(13, -1, "Failed to find any Kerberos tgt");
        }
        if (krb5NameElement == null) {
            object = kerberosTicket.getClient().getName();
            krb5NameElement = Krb5NameElement.getInstance((String)object, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        object = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetClientAlias(kerberosTicket);
        KerberosPrincipal kerberosPrincipal = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetServerAlias(kerberosTicket);
        Krb5InitCredential krb5InitCredential = new Krb5InitCredential(krb5NameElement, kerberosTicket.getEncoded(), kerberosTicket.getClient(), (KerberosPrincipal)object, kerberosTicket.getServer(), kerberosPrincipal, kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
        krb5InitCredential.proxyTicket = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetProxy(kerberosTicket);
        return krb5InitCredential;
    }

    static Krb5InitCredential getInstance(Krb5NameElement krb5NameElement, Credentials credentials) throws GSSException {
        EncryptionKey encryptionKey = credentials.getSessionKey();
        PrincipalName principalName = credentials.getClient();
        PrincipalName principalName2 = credentials.getClientAlias();
        PrincipalName principalName3 = credentials.getServer();
        PrincipalName principalName4 = credentials.getServerAlias();
        KerberosPrincipal kerberosPrincipal = null;
        KerberosPrincipal kerberosPrincipal2 = null;
        KerberosPrincipal kerberosPrincipal3 = null;
        KerberosPrincipal kerberosPrincipal4 = null;
        Krb5NameElement krb5NameElement2 = null;
        if (principalName != null) {
            String string = principalName.getName();
            krb5NameElement2 = Krb5NameElement.getInstance(string, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
            kerberosPrincipal = new KerberosPrincipal(string);
        }
        if (principalName2 != null) {
            kerberosPrincipal2 = new KerberosPrincipal(principalName2.getName());
        }
        if (principalName3 != null) {
            kerberosPrincipal3 = new KerberosPrincipal(principalName3.getName(), 2);
        }
        if (principalName4 != null) {
            kerberosPrincipal4 = new KerberosPrincipal(principalName4.getName());
        }
        return new Krb5InitCredential(krb5NameElement2, credentials, credentials.getEncoded(), kerberosPrincipal, kerberosPrincipal2, kerberosPrincipal3, kerberosPrincipal4, encryptionKey.getBytes(), encryptionKey.getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
    }

    @Override
    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        Date date = this.getEndTime();
        if (date == null) {
            return 0;
        }
        long l = date.getTime() - System.currentTimeMillis();
        return (int)(l / 1000L);
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return 0;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return true;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return false;
    }

    @Override
    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    Credentials getKrb5Credentials() {
        return this.krb5Credentials;
    }

    @Override
    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException destroyFailedException) {
            GSSException gSSException = new GSSException(11, -1, "Could not destroy credentials - " + destroyFailedException.getMessage());
            gSSException.initCause(destroyFailedException);
        }
    }

    private static KerberosTicket getTgt(GSSCaller gSSCaller, Krb5NameElement krb5NameElement, int n) throws GSSException {
        final String string = krb5NameElement != null ? krb5NameElement.getKrb5PrincipalName().getName() : null;
        final AccessControlContext accessControlContext = AccessController.getContext();
        try {
            final GSSCaller gSSCaller2 = gSSCaller == GSSCaller.CALLER_UNKNOWN ? GSSCaller.CALLER_INITIATE : gSSCaller;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosTicket>(){

                @Override
                public KerberosTicket run() throws Exception {
                    return Krb5Util.getInitialTicket(gSSCaller2, string, accessControlContext);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            GSSException gSSException = new GSSException(13, -1, "Attempt to obtain new INITIATE credentials failed! (" + privilegedActionException.getMessage() + ")");
            gSSException.initCause(privilegedActionException.getException());
            throw gSSException;
        }
    }

    @Override
    public GSSCredentialSpi impersonate(GSSNameSpi gSSNameSpi) throws GSSException {
        try {
            Krb5NameElement krb5NameElement = (Krb5NameElement)gSSNameSpi;
            Credentials credentials = Credentials.acquireS4U2selfCreds(krb5NameElement.getKrb5PrincipalName(), this.krb5Credentials);
            return new Krb5ProxyCredential(this, krb5NameElement, credentials);
        }
        catch (IOException | KrbException exception) {
            GSSException gSSException = new GSSException(11, -1, "Attempt to obtain S4U2self credentials failed!");
            gSSException.initCause(exception);
            throw gSSException;
        }
    }
}

