/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.build;

import com.jpexs.helpers.Helper;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetainfoUpdater {
    public static final String METAINFO_FILENAME = "resources/com.jpexs.decompiler.flash.metainfo.xml";
    private static final String CHANGELOG_FILENAME = "CHANGELOG.md";

    public static void main(String[] args) throws UnsupportedEncodingException {
        String metainfo = Helper.readTextFile((String[])new String[]{METAINFO_FILENAME});
        String changeLog = Helper.readTextFile((String[])new String[]{CHANGELOG_FILENAME});
        String newline = System.lineSeparator();
        Pattern metainfoVersionPattern = Pattern.compile("<release version=\"(?<version>[0-9]+\\.[0-9]+\\.[0-9]+)\" date=\"(?<date>[0-9]+-[0-9]+-[0-9]+)\">");
        Matcher metainfoVersionMatcher = metainfoVersionPattern.matcher(metainfo);
        if (!metainfoVersionMatcher.find()) {
            throw new IllegalArgumentException("No last metainfo version found");
        }
        String latestMetainfoVersion = metainfoVersionMatcher.group("version");
        Pattern changelogVersionPattern = Pattern.compile("## \\[(?<version>[0-9]+\\.[0-9]+\\.[0-9]+)\\] - (?<date>[0-9]+-[0-9]+-[0-9]+)");
        Matcher changelogVersionMatcher = changelogVersionPattern.matcher(changeLog);
        int prevMatchEnd = -1;
        String prevVersion = null;
        String prevDate = null;
        String releases = "";
        while (changelogVersionMatcher.find()) {
            if (prevMatchEnd != -1) {
                if (prevVersion.equals(latestMetainfoVersion)) break;
                String versionChangelog = changeLog.substring(prevMatchEnd, changelogVersionMatcher.start()).trim();
                String[] parts = (versionChangelog + "\r\n").split("\r?\n");
                Object prev = null;
                String description = "";
                String li = "";
                for (String s : parts) {
                    if (s.startsWith("### ")) {
                        if (!li.isEmpty()) {
                            description = description + "\t\t\t\t\t<li>" + MetainfoUpdater.filterLiText(li) + "</li>" + newline;
                            li = "";
                        }
                        if (!description.isEmpty()) {
                            description = description + "\t\t\t\t</ul>" + newline;
                        }
                        description = description + "\t\t\t\t<p>" + s.substring(4).trim() + "</p>" + newline;
                        description = description + "\t\t\t\t<ul>" + newline;
                        continue;
                    }
                    if (s.startsWith("- ")) {
                        if (!li.isEmpty()) {
                            description = description + "\t\t\t\t\t<li>" + MetainfoUpdater.filterLiText(li) + "</li>" + newline;
                        }
                        li = s.trim().substring(2);
                        continue;
                    }
                    if (s.trim().isEmpty()) continue;
                    li = li + " " + s.trim();
                }
                if (!li.isEmpty()) {
                    description = description + "\t\t\t\t\t<li>" + MetainfoUpdater.filterLiText(li) + "</li>" + newline;
                }
                if (!description.isEmpty()) {
                    description = description + "\t\t\t\t</ul>" + newline;
                }
                String release = "\t\t<release version=\"" + prevVersion + "\" date=\"" + prevDate + "\">" + newline + "\t\t\t<description>" + newline + description + "\t\t\t</description>" + newline + "\t\t</release>" + newline;
                releases = releases + release;
            }
            prevVersion = changelogVersionMatcher.group("version");
            prevDate = changelogVersionMatcher.group("date");
            prevMatchEnd = changelogVersionMatcher.end();
        }
        metainfo = metainfo.replaceAll("<releases>", ("<releases>" + newline + releases).trim());
        Helper.writeFile((String)METAINFO_FILENAME, (byte[][])new byte[][]{metainfo.getBytes("UTF-8")});
    }

    private static String filterLiText(String li) {
        li = li.replaceAll("\\[(#[0-9]+)\\]", "$1");
        li = li.replaceAll("\\[(PR[0-9]+)\\]", "$1");
        li = li.replace("&", "&amp;");
        li = li.replace("<", "&lt;");
        li = li.replace(">", "&gt;");
        return li;
    }
}

