/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.console;

import com.jpexs.decompiler.flash.OpenableSourceInfo;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.UrlResolver;
import com.jpexs.decompiler.flash.configuration.Configuration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;

public class ConsoleUrlResolver
implements UrlResolver {
    private final boolean doResolve;
    private final boolean doAsk;
    private final boolean localOnly;
    private boolean ignoredInfoPrinted = false;
    private Character toAll = null;
    private Map<String, String> importSources = new HashMap<String, String>();

    public ConsoleUrlResolver(boolean doResolve, boolean doAsk, boolean localOnly, Map<String, String> importSources) {
        this.doResolve = doResolve;
        this.doAsk = doAsk;
        this.localOnly = localOnly;
        this.importSources = importSources;
    }

    public SWF resolveUrl(String basePath, String url) {
        Character choice = this.toAll;
        String currentUrl = url;
        if (this.importSources.containsKey(url)) {
            currentUrl = this.importSources.get(url);
            if (currentUrl.isEmpty()) {
                return null;
            }
            choice = Character.valueOf('y');
        } else {
            if (choice == null && this.doResolve) {
                choice = Character.valueOf('y');
            }
            if (!this.doResolve && !this.doAsk) {
                if (!this.ignoredInfoPrinted) {
                    System.out.println("WARNING: SWF tried to import assets from external SWF, the request was ignored. (See --help -importAssets for more options)");
                }
                this.ignoredInfoPrinted = true;
                return null;
            }
            if (choice == null && this.doAsk) {
                choice = Character.valueOf(this.ask(url));
            }
        }
        while (choice.charValue() != 'n') {
            SWF ret;
            if (choice.charValue() == 'c') {
                System.out.println("Enter new location instead (empty to cancel):");
                Scanner sc = new Scanner(System.in);
                String newUrl = sc.nextLine();
                this.importSources.put(url, newUrl);
                currentUrl = newUrl;
                if (currentUrl.isEmpty()) {
                    return null;
                }
            }
            if (currentUrl.startsWith("http://") || currentUrl.startsWith("https://")) {
                if (this.localOnly && choice.charValue() != 'c') {
                    return null;
                }
                try {
                    URL u = URI.create(currentUrl).toURL();
                    ret = this.open(u.openStream(), null, currentUrl);
                    return ret;
                }
                catch (Exception u) {}
            } else {
                File gfx;
                File swf = new File(new File(basePath).getParentFile(), currentUrl);
                if (swf.exists()) {
                    try {
                        ret = this.open(new FileInputStream(swf), swf.getAbsolutePath(), swf.getName());
                        return ret;
                    }
                    catch (Exception ret2) {
                        // empty catch block
                    }
                }
                if (currentUrl.endsWith(".swf") && (gfx = new File(new File(basePath).getParentFile(), url.substring(0, url.length() - 4) + ".gfx")).exists()) {
                    try {
                        SWF ret3 = this.open(new FileInputStream(gfx), gfx.getAbsolutePath(), gfx.getName());
                        return ret3;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            System.err.println("Cannot load imported SWF " + currentUrl);
            if (this.doAsk) {
                choice = Character.valueOf('c');
                continue;
            }
            choice = Character.valueOf('n');
        }
        return null;
    }

    private SWF open(InputStream is, String file, String fileTitle) throws Exception {
        OpenableSourceInfo sourceInfo = new OpenableSourceInfo(is, file, fileTitle);
        return new SWF((InputStream)new BufferedInputStream(is), sourceInfo.getFile(), sourceInfo.getFileTitle(), null, ((Boolean)Configuration.parallelSpeedUp.get()).booleanValue(), false, true, (UrlResolver)this, null);
    }

    private String prompt() {
        Scanner sc = new Scanner(System.in);
        System.out.print("Select action: (Y)es, (N)o, (C)ustom, (YA) Yes to all, (NA) No to all: ");
        String s = sc.nextLine();
        s = s.toLowerCase(Locale.ENGLISH);
        return s;
    }

    private char ask(String url) {
        String s;
        if (this.toAll != null) {
            s = "" + this.toAll;
        } else {
            System.out.println("The SWF file is trying to import assets from the following location:");
            System.out.println(url);
            s = this.prompt();
        }
        while (true) {
            switch (s) {
                case "ya": {
                    this.toAll = Character.valueOf('y');
                    return 'y';
                }
                case "na": {
                    this.toAll = Character.valueOf('n');
                    return 'n';
                }
                case "y": {
                    return 'y';
                }
                case "n": {
                    return 'n';
                }
                case "c": {
                    return 'c';
                }
            }
            System.out.println("Invalid action.");
            s = this.prompt();
        }
    }
}

