/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.DefineBeforeUsageFixer;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.easygui.CharacterTagTransferable;
import com.jpexs.decompiler.flash.easygui.DoableOperation;
import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.easygui.EasyTagNameResolver;
import com.jpexs.decompiler.flash.easygui.FrameSelectionListener;
import com.jpexs.decompiler.flash.easygui.LibraryTreeTable;
import com.jpexs.decompiler.flash.easygui.TimelinePanel;
import com.jpexs.decompiler.flash.easygui.TimelinedTagListDoableOperation;
import com.jpexs.decompiler.flash.easygui.UndoManager;
import com.jpexs.decompiler.flash.easygui.properties.panels.DocumentPropertiesPanel;
import com.jpexs.decompiler.flash.easygui.properties.panels.InstancePropertiesPanel;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.ImagePanel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.RegistrationPointPosition;
import com.jpexs.decompiler.flash.gui.TimelinedMaker;
import com.jpexs.decompiler.flash.gui.TransformPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.controls.JPersistentSplitPane;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.ZoomPanel;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.PlaceObject2Tag;
import com.jpexs.decompiler.flash.tags.RemoveObject2Tag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.MATRIX;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class EasySwfPanel
extends JPanel {
    private LibraryTreeTable libraryTreeTable;
    private JSplitPane verticalSplitPane;
    private JSplitPane horizontalSplitPane;
    private ImagePanel libraryPreviewPanel;
    private ImagePanel stagePanel;
    private TimelinePanel timelinePanel;
    private JButton undoButton;
    private JButton redoButton;
    private UndoManager undoManager;
    private JTabbedPane rightTabbedPane;
    private TransformPanel transformPanel;
    private Timelined timelined;
    private JLabel timelineLabel;
    private JButton closeTimelineButton;
    private JPanel propertiesPanel;
    private static final String PROPERTIES_DOCUMENT = "Document";
    private static final String PROPERTIES_INSTANCE = "Instance";
    private static final String PROPERTIES_TEXT = "Text";
    private DocumentPropertiesPanel documentPropertiesPanel;
    private InstancePropertiesPanel instancePropertiesPanel;
    private InstancePropertiesPanel textInstancePropertiesPanel;
    private final MainPanel mainPanel;

    public EasySwfPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.setLayout(new BorderLayout());
        this.stagePanel = new ImagePanel();
        this.stagePanel.setTagNameResolver(new EasyTagNameResolver());
        this.stagePanel.setShowAllDepthLevelsInfo(false);
        this.stagePanel.setSelectionMode(true);
        this.stagePanel.setMultiSelect(true);
        this.stagePanel.addEventListener(new MediaDisplayListener(){

            @Override
            public void mediaDisplayStateChanged(MediaDisplay source) {
                if (EasySwfPanel.this.stagePanel.getTimelined() != EasySwfPanel.this.timelined) {
                    View.execInEventDispatchLater(new Runnable(){

                        @Override
                        public void run() {
                            EasySwfPanel.this.setTimelined(EasySwfPanel.this.stagePanel.getTimelined(), false);
                        }
                    });
                } else {
                    EasySwfPanel.this.timelinePanel.setFrame(EasySwfPanel.this.stagePanel.getFrame(), EasySwfPanel.this.stagePanel.getSelectedDepths());
                }
            }

            @Override
            public void playingFinished(MediaDisplay source) {
            }

            @Override
            public void statusChanged(String status) {
            }
        });
        this.stagePanel.addPlaceObjectSelectedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Integer> depths = EasySwfPanel.this.stagePanel.getSelectedDepths();
                EasySwfPanel.this.timelinePanel.setDepths(depths);
                EasySwfPanel.this.transformPanel.setVisible(!depths.isEmpty());
                EasySwfPanel.this.updatePropertiesPanel();
            }
        });
        this.stagePanel.addTransformChangeListener(new Runnable(){

            @Override
            public void run() {
                final List<Integer> depths = EasySwfPanel.this.stagePanel.getSelectedDepths();
                final int frame = EasySwfPanel.this.stagePanel.getFrame();
                Matrix parentMatrix = EasySwfPanel.this.stagePanel.getParentMatrix();
                final Matrix newMatrix = parentMatrix.inverse().concatenate(EasySwfPanel.this.stagePanel.getNewMatrix()).concatenate(parentMatrix);
                final Point2D regPoint = EasySwfPanel.this.stagePanel.getRegistrationPoint();
                final RegistrationPointPosition regPointPos = EasySwfPanel.this.stagePanel.getRegistrationPointPosition();
                final ArrayList<MATRIX> fpreviousMatrices = new ArrayList<MATRIX>();
                List<DepthState> dss = EasySwfPanel.this.getSelectedDepthStates();
                for (DepthState ds : dss) {
                    if (ds == null) {
                        fpreviousMatrices.add(null);
                        continue;
                    }
                    fpreviousMatrices.add(ds.matrix);
                }
                final boolean transformEnabled = EasySwfPanel.this.transformEnabled();
                EasySwfPanel.this.undoManager.doOperation(new DoableOperation(){
                    private final List<Boolean> wasModified = new ArrayList<Boolean>();
                    Timelined timelined;
                    {
                        this.timelined = EasySwfPanel.this.stagePanel.getTimelined();
                    }

                    @Override
                    public void doOperation() {
                        if (this.timelined != EasySwfPanel.this.timelined) {
                            EasySwfPanel.this.setTimelined(this.timelined);
                        }
                        EasySwfPanel.this.timelinePanel.setFrame(frame, depths);
                        for (int i = 0; i < depths.size(); ++i) {
                            int depth = (Integer)depths.get(i);
                            DepthState ds = (DepthState)((EasySwfPanel)EasySwfPanel.this).stagePanel.getTimelined().getTimeline().getFrame((int)frame).layers.get(depth);
                            this.wasModified.add(ds.placeObjectTag == null ? false : ds.placeObjectTag.isModified());
                            Matrix contMat = newMatrix.concatenate(new Matrix((MATRIX)fpreviousMatrices.get(i)));
                            if (this.timelined instanceof ButtonTag) {
                                ButtonTag button = (ButtonTag)this.timelined;
                                BUTTONRECORD rec = button.getButtonRecordAt(frame, depth, true);
                                rec.placeMatrix = contMat.toMATRIX();
                                continue;
                            }
                            ds.placeObjectTag.setMatrix(contMat.toMATRIX());
                            ds.placeObjectTag.setPlaceFlagHasMatrix(newMatrix != null);
                            ds.placeObjectTag.setModified(true);
                        }
                        this.timelined.resetTimeline();
                        EasySwfPanel.this.stagePanel.repaint();
                        if (EasySwfPanel.this.transformEnabled()) {
                            EasySwfPanel.this.stagePanel.freeTransformDepths(depths);
                            EasySwfPanel.this.stagePanel.setRegistrationPoint(regPoint);
                            if (regPointPos != null) {
                                EasySwfPanel.this.stagePanel.setRegistrationPointPosition(regPointPos);
                            }
                            EasySwfPanel.this.transformPanel.setVisible(true);
                        } else {
                            EasySwfPanel.this.stagePanel.selectDepths(depths);
                        }
                    }

                    @Override
                    public void undoOperation() {
                        EasySwfPanel.this.setTimelined(this.timelined);
                        EasySwfPanel.this.timelinePanel.setFrame(frame, depths);
                        for (int i = 0; i < depths.size(); ++i) {
                            int depth = (Integer)depths.get(i);
                            DepthState ds = (DepthState)((EasySwfPanel)EasySwfPanel.this).stagePanel.getTimelined().getTimeline().getFrame((int)frame).layers.get(depth);
                            if (this.timelined instanceof ButtonTag) {
                                ButtonTag button = (ButtonTag)this.timelined;
                                BUTTONRECORD rec = button.getButtonRecordAt(frame, depth, true);
                                rec.placeMatrix = (MATRIX)fpreviousMatrices.get(i);
                                continue;
                            }
                            ds.placeObjectTag.setMatrix((MATRIX)fpreviousMatrices.get(i));
                            ds.placeObjectTag.setPlaceFlagHasMatrix(fpreviousMatrices != null);
                            if (ds.placeObjectTag == null || this.wasModified.get(i).booleanValue()) continue;
                            ds.placeObjectTag.setModified(false);
                        }
                        EasySwfPanel.this.stagePanel.getTimelined().resetTimeline();
                        EasySwfPanel.this.stagePanel.repaint();
                        if (EasySwfPanel.this.transformEnabled()) {
                            EasySwfPanel.this.stagePanel.freeTransformDepths(depths);
                            EasySwfPanel.this.transformPanel.setVisible(true);
                        } else {
                            EasySwfPanel.this.stagePanel.selectDepths(depths);
                        }
                    }

                    @Override
                    public String getDescription() {
                        return EasyStrings.translate(transformEnabled ? "action.transform" : "action.move");
                    }
                }, EasySwfPanel.this.timelined.getSwf());
            }
        });
        this.stagePanel.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(CharacterTagTransferable.CHARACTERTAG_FLAVOR);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    Transferable transferable = support.getTransferable();
                    Integer characterId = (Integer)transferable.getTransferData(CharacterTagTransferable.CHARACTERTAG_FLAVOR);
                    final CharacterTag tag = EasySwfPanel.this.stagePanel.getTimelined().getSwf().getCharacter(characterId.intValue());
                    if (tag instanceof DefineSpriteTag || tag instanceof ShapeTag || tag instanceof TextTag || tag instanceof ButtonTag) {
                        EasySwfPanel.this.undoManager.doOperation(new TimelinedTagListDoableOperation(EasySwfPanel.this, EasySwfPanel.this.stagePanel.getTimelined()){
                            private List<Tag> swfTags;

                            @Override
                            public void doOperation() {
                                super.doOperation();
                                CharacterTag ch = tag;
                                int maxDepth = EasySwfPanel.this.timelined.getTimeline().getMaxDepth();
                                int newDepth = maxDepth + 1;
                                if (EasySwfPanel.this.timelined.getSwf() != EasySwfPanel.this.timelined) {
                                    this.swfTags = EasySwfPanel.this.timelined.getSwf().getTags().toArrayList();
                                }
                                ShowFrameTag showFrameTag = ((EasySwfPanel)EasySwfPanel.this).timelined.getTimeline().getFrame((int)this.fframe).showFrameTag;
                                PlaceObject2Tag place = new PlaceObject2Tag(EasySwfPanel.this.timelined.getSwf());
                                place.depth = newDepth;
                                place.placeFlagHasCharacter = true;
                                place.characterId = ch.getCharacterId();
                                place.matrix = new MATRIX();
                                place.placeFlagHasMatrix = true;
                                place.setTimelined(EasySwfPanel.this.timelined);
                                if (EasySwfPanel.this.timelined instanceof ButtonTag) {
                                    ButtonTag button = (ButtonTag)EasySwfPanel.this.timelined;
                                    button.getButtonRecordAt(this.fframe, newDepth, true).fromPlaceObject((PlaceObjectTypeTag)place);
                                } else if (showFrameTag == null) {
                                    EasySwfPanel.this.timelined.addTag((Tag)place);
                                } else {
                                    EasySwfPanel.this.timelined.addTag(EasySwfPanel.this.timelined.indexOfTag((Tag)showFrameTag), (Tag)place);
                                    if (this.fframe < EasySwfPanel.this.timelined.getFrameCount() - 1) {
                                        RemoveObject2Tag remove = new RemoveObject2Tag(EasySwfPanel.this.timelined.getSwf());
                                        remove.depth = newDepth;
                                        EasySwfPanel.this.timelined.addTag(EasySwfPanel.this.timelined.indexOfTag((Tag)showFrameTag) + 1, (Tag)remove);
                                    }
                                }
                                DefineBeforeUsageFixer fixer = new DefineBeforeUsageFixer();
                                boolean tagOrderChanged = fixer.fixDefineBeforeUsage(EasySwfPanel.this.timelined.getSwf());
                                if (!tagOrderChanged) {
                                    this.swfTags = null;
                                }
                                EasySwfPanel.this.timelined.resetTimeline();
                                EasySwfPanel.this.stagePanel.repaint();
                                EasySwfPanel.this.timelinePanel.refresh();
                                EasySwfPanel.this.timelinePanel.setDepth(newDepth);
                            }

                            @Override
                            public void undoOperation() {
                                super.undoOperation();
                                EasySwfPanel.this.timelined.resetTimeline();
                                if (this.swfTags != null) {
                                    int i;
                                    SWF swf = EasySwfPanel.this.timelined.getSwf();
                                    ReadOnlyTagList newTags = swf.getTags();
                                    int size = newTags.size();
                                    for (i = 0; i < size; ++i) {
                                        swf.removeTag(0);
                                    }
                                    for (i = 0; i < this.swfTags.size(); ++i) {
                                        swf.addTag(this.swfTags.get(i));
                                    }
                                    swf.resetTimeline();
                                }
                                EasySwfPanel.this.stagePanel.repaint();
                                EasySwfPanel.this.timelinePanel.refresh();
                                EasySwfPanel.this.timelinePanel.setFrame(this.fframe, this.fdepths);
                            }

                            @Override
                            public String getDescription() {
                                return EasyStrings.translate("action.addToStage");
                            }
                        }, EasySwfPanel.this.timelined.getSwf());
                        return true;
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    ex.printStackTrace();
                }
                return false;
            }
        });
        this.undoManager = new UndoManager();
        JPanel topPanel = new JPanel(new BorderLayout());
        this.undoButton = new JButton(View.getIcon("undo16"));
        this.undoButton.setMargin(new Insets(5, 5, 5, 5));
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EasySwfPanel.this.undoManager.undo(EasySwfPanel.this.timelined.getSwf());
            }
        });
        this.redoButton = new JButton(View.getIcon("redo16"));
        this.redoButton.setMargin(new Insets(5, 5, 5, 5));
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EasySwfPanel.this.undoManager.redo(EasySwfPanel.this.timelined.getSwf());
            }
        });
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        this.undoButton.setToolTipText(EasyStrings.translate("undo.cannot"));
        this.redoButton.setToolTipText(EasyStrings.translate("redo.cannot"));
        Runnable undoChangeListener = new Runnable(){

            @Override
            public void run() {
                EasySwfPanel.this.updateUndos();
            }
        };
        this.undoManager.addChangeListener(undoChangeListener);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        JPanel leftToolbar = new JPanel(new FlowLayout(0, 0, 0));
        leftToolbar.add(this.undoButton);
        leftToolbar.add(this.redoButton);
        leftToolbar.add(Box.createHorizontalStrut(10));
        this.timelineLabel = new JLabel("");
        leftToolbar.add(this.timelineLabel);
        leftToolbar.add(Box.createHorizontalStrut(5));
        this.closeTimelineButton = new JButton(View.getIcon("cancel16"));
        this.closeTimelineButton.setMargin(new Insets(5, 5, 5, 5));
        leftToolbar.add(this.closeTimelineButton);
        this.closeTimelineButton.setToolTipText(EasyStrings.translate("timeline.item.cancel"));
        this.closeTimelineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwfSpecificCustomConfiguration conf = Configuration.getOrCreateSwfSpecificCustomConfiguration((SWF)EasySwfPanel.this.timelined.getSwf());
                conf.setCustomData("easy.lastSelected.parentDepths", new ArrayList());
                conf.setCustomData("easy.lastSelected.parentFrames", new ArrayList());
                String firstParentFrame = conf.getCustomData("easy.lastSelected.firstParentFrame", "1");
                conf.setCustomData("easy.lastSelected.frame", firstParentFrame);
                EasySwfPanel.this.setTimelined((Timelined)EasySwfPanel.this.timelined.getSwf());
            }
        });
        toolbarPanel.add((Component)leftToolbar, "West");
        ZoomPanel zoomPanel = new ZoomPanel(this.stagePanel);
        toolbarPanel.add((Component)zoomPanel, "East");
        topPanel.add((Component)toolbarPanel, "North");
        topPanel.add((Component)this.stagePanel, "Center");
        this.timelinePanel = new TimelinePanel(this, this.undoManager);
        this.timelinePanel.addChangeListener(new Runnable(){

            @Override
            public void run() {
                EasySwfPanel.this.stagePanel.repaint();
            }
        });
        this.timelinePanel.addFrameSelectionListener(new FrameSelectionListener(){

            @Override
            public void frameSelected(int frame, List<Integer> depths) {
                EasySwfPanel.this.stagePanel.pause();
                EasySwfPanel.this.stagePanel.gotoFrame(frame + 1);
                EasySwfPanel.this.stagePanel.selectDepths(depths);
                if (EasySwfPanel.this.transformEnabled()) {
                    EasySwfPanel.this.stagePanel.freeTransformDepths(depths);
                }
                EasySwfPanel.this.transformPanel.setVisible(!depths.isEmpty());
                EasySwfPanel.this.updatePropertiesPanel();
            }
        });
        this.verticalSplitPane = new JPersistentSplitPane(0, topPanel, (Component)this.timelinePanel, (ConfigurationItem<Double>)Configuration.guiSplitPaneEasyVerticalDividerLocationPercent);
        this.libraryTreeTable = new LibraryTreeTable(this);
        FasterScrollPane libraryScrollPane = new FasterScrollPane(this.libraryTreeTable);
        JPanel libraryPanel = new JPanel(new BorderLayout());
        libraryPanel.add((Component)libraryScrollPane, "Center");
        this.libraryPreviewPanel = new ImagePanel();
        this.libraryPreviewPanel.setTopPanelVisible(false);
        libraryPanel.add((Component)this.libraryPreviewPanel, "North");
        this.libraryPreviewPanel.setPreferredSize(new Dimension(200, 200));
        this.rightTabbedPane = new JTabbedPane();
        this.propertiesPanel = new JPanel();
        this.documentPropertiesPanel = new DocumentPropertiesPanel(this.undoManager);
        this.propertiesPanel.setLayout(new CardLayout());
        this.instancePropertiesPanel = new InstancePropertiesPanel(this, this.undoManager, false);
        this.textInstancePropertiesPanel = new InstancePropertiesPanel(this, this.undoManager, true);
        this.propertiesPanel.add((Component)this.documentPropertiesPanel, PROPERTIES_DOCUMENT);
        this.propertiesPanel.add((Component)this.instancePropertiesPanel, PROPERTIES_INSTANCE);
        this.propertiesPanel.add((Component)this.textInstancePropertiesPanel, PROPERTIES_TEXT);
        this.rightTabbedPane.addTab(EasyStrings.translate("properties"), this.propertiesPanel);
        this.rightTabbedPane.addTab(EasyStrings.translate("library"), libraryPanel);
        JPanel transformTab = new JPanel(new BorderLayout());
        this.transformPanel = new TransformPanel(this.stagePanel, false);
        transformTab.add((Component)new FasterScrollPane(this.transformPanel), "Center");
        this.rightTabbedPane.addTab(EasyStrings.translate("transform"), transformTab);
        this.rightTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (EasySwfPanel.this.stagePanel.getTimelined() == null) {
                    return;
                }
                List<Integer> depths = EasySwfPanel.this.stagePanel.getSelectedDepths();
                if (EasySwfPanel.this.stagePanel.getFrame() >= EasySwfPanel.this.stagePanel.getTimelined().getFrameCount()) {
                    depths.clear();
                }
                if (!depths.isEmpty()) {
                    Frame frame = EasySwfPanel.this.stagePanel.getTimelined().getTimeline().getFrame(EasySwfPanel.this.stagePanel.getFrame());
                    if (frame == null) {
                        depths.clear();
                    } else {
                        for (int i = 0; i < depths.size(); ++i) {
                            DepthState ds = (DepthState)frame.layers.get(depths.get(i));
                            if (ds != null) continue;
                            depths.remove(i);
                            --i;
                        }
                    }
                }
                EasySwfPanel.this.transformPanel.setVisible(!depths.isEmpty());
                if (EasySwfPanel.this.transformEnabled()) {
                    EasySwfPanel.this.stagePanel.freeTransformDepths(depths);
                    EasySwfPanel.this.stagePanel.setTransformSelectionMode(true);
                } else {
                    EasySwfPanel.this.stagePanel.freeTransformDepth(-1);
                    EasySwfPanel.this.stagePanel.selectDepths(depths);
                    EasySwfPanel.this.stagePanel.setTransformSelectionMode(false);
                }
            }
        });
        this.horizontalSplitPane = new JPersistentSplitPane(1, this.verticalSplitPane, (Component)this.rightTabbedPane, (ConfigurationItem<Double>)Configuration.guiSplitPaneEasyHorizontalDividerLocationPercent);
        if (View.isOceanic()) {
            libraryScrollPane.getViewport().setBackground(Color.white);
        } else {
            libraryScrollPane.getViewport().setBackground(UIManager.getColor("Tree.background"));
        }
        this.add((Component)this.horizontalSplitPane, "Center");
        this.libraryTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = EasySwfPanel.this.libraryTreeTable.getSelectedRow();
                if (row == -1) {
                    return;
                }
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)EasySwfPanel.this.libraryTreeTable.getModel().getValueAt(row, 0);
                Object obj = n.getUserObject();
                if (obj instanceof Tag) {
                    Tag t = (Tag)obj;
                    EasySwfPanel.this.libraryPreviewPanel.setTimelined(TimelinedMaker.makeTimelined(t), t.getSwf(), -1, false, true, true, true, true, false, true, true, true);
                    EasySwfPanel.this.libraryPreviewPanel.zoomFit();
                } else {
                    EasySwfPanel.this.libraryPreviewPanel.clearAll();
                }
            }
        });
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    private void updatePropertiesPanel() {
        int chid;
        CardLayout cl = (CardLayout)this.propertiesPanel.getLayout();
        List<PlaceObjectTypeTag> places = this.getSelectedPlaceTags();
        if (places == null || places.isEmpty()) {
            cl.show(this.propertiesPanel, PROPERTIES_DOCUMENT);
            return;
        }
        if (places.size() == 1 && (chid = places.get(0).getCharacterId()) > -1 && places.get(0).getSwf().getCharacter(chid) instanceof TextTag) {
            this.textInstancePropertiesPanel.update();
            cl.show(this.propertiesPanel, PROPERTIES_TEXT);
            return;
        }
        this.instancePropertiesPanel.update();
        cl.show(this.propertiesPanel, PROPERTIES_INSTANCE);
    }

    private boolean transformEnabled() {
        return this.rightTabbedPane.getSelectedIndex() == 2;
    }

    public void setSwf(SWF swf) {
        CharacterTag ct;
        int timId;
        SwfSpecificCustomConfiguration conf;
        SWF tim = swf;
        if (swf != null && (conf = Configuration.getSwfSpecificCustomConfiguration((SWF)swf)) != null && (timId = Integer.parseInt(conf.getCustomData("easy.lastSelected.timeline", "-1"))) > -1 && (ct = swf.getCharacter(timId)) != null && ct instanceof Timelined) {
            tim = (Timelined)ct;
        }
        this.setTimelined((Timelined)tim);
    }

    public void setTimelined(Timelined timelined) {
        this.setTimelined(timelined, true);
    }

    private void setTimelined(Timelined timelined, boolean updateStage) {
        if (this.timelined == timelined) {
            return;
        }
        if (this.mainPanel.getCurrentView() != 2) {
            timelined = null;
        }
        this.timelined = timelined;
        if (timelined == null) {
            this.stagePanel.clearAll();
            this.timelinePanel.setTimelined(null);
            this.libraryTreeTable.setSwf(null);
            this.libraryPreviewPanel.clearAll();
            this.closeTimelineButton.setVisible(false);
            this.timelineLabel.setText("");
            this.documentPropertiesPanel.setSwf(null);
            this.instancePropertiesPanel.update();
            this.textInstancePropertiesPanel.update();
        } else {
            SWF swf = timelined.getSwf();
            this.documentPropertiesPanel.setSwf(swf);
            this.libraryTreeTable.setSwf(swf);
            this.libraryPreviewPanel.clearAll();
            if (timelined instanceof SWF) {
                this.timelineLabel.setText(EasyStrings.translate("timeline.main"));
                this.closeTimelineButton.setVisible(false);
            } else {
                EasyTagNameResolver nameResolver = new EasyTagNameResolver();
                this.timelineLabel.setText(EasyStrings.translate("timeline.item").replace("%item%", nameResolver.getTagName((Tag)timelined)));
                this.closeTimelineButton.setVisible(true);
            }
            this.timelinePanel.setTimelined(timelined);
            if (updateStage) {
                this.stagePanel.setTimelined(timelined, swf, 0, true, true, true, true, true, false, true, true, true);
                if (timelined instanceof CharacterTag) {
                    this.stagePanel.setGuidesCharacter(swf, ((CharacterTag)timelined).getCharacterId());
                } else {
                    this.stagePanel.setGuidesCharacter(swf, -1);
                }
                this.stagePanel.pause();
            }
            if (updateStage) {
                // empty if block
            }
            this.instancePropertiesPanel.update();
            this.textInstancePropertiesPanel.update();
        }
        this.updateUndos();
    }

    public Openable getOpenable() {
        return this.timelined.getSwf();
    }

    public void clearUndos() {
        this.undoManager.clear();
    }

    private void updateUndos() {
        this.undoButton.setEnabled(this.timelined != null && this.undoManager.canUndo(this.timelined.getSwf()));
        this.redoButton.setEnabled(this.timelined != null && this.undoManager.canRedo(this.timelined.getSwf()));
        if (this.timelined != null && this.undoManager.canUndo(this.timelined.getSwf())) {
            this.undoButton.setToolTipText(EasyStrings.translate("undo").replace("%action%", this.undoManager.getUndoName(this.timelined.getSwf())));
        } else {
            this.undoButton.setToolTipText(EasyStrings.translate("undo.cannot"));
        }
        if (this.timelined != null && this.undoManager.canRedo(this.timelined.getSwf())) {
            this.redoButton.setToolTipText(EasyStrings.translate("redo").replace("%action%", this.undoManager.getRedoName(this.timelined.getSwf())));
        } else {
            this.redoButton.setToolTipText(EasyStrings.translate("redo.cannot"));
        }
        if (this.stagePanel.getTimelined() == null) {
            return;
        }
        this.updatePropertiesPanel();
        Main.getMainFrame().getPanel().updateUiWithCurrentOpenable();
    }

    public void dispose() {
        this.setTimelined(null);
        this.undoManager.clear();
    }

    public List<Integer> getDepths() {
        return this.stagePanel.getSelectedDepths();
    }

    public int getFrame() {
        return this.stagePanel.getFrame();
    }

    public ImagePanel getStagePanel() {
        return this.stagePanel;
    }

    public SWF getSwf() {
        return this.timelined == null ? null : this.timelined.getSwf();
    }

    public List<DepthState> getSelectedDepthStates() {
        if (this.timelined == null) {
            return null;
        }
        int frame = this.stagePanel.getFrame();
        List<Integer> depths = this.stagePanel.getSelectedDepths();
        ArrayList<DepthState> ret = new ArrayList<DepthState>();
        for (int i = 0; i < depths.size(); ++i) {
            ret.add(this.timelined.getTimeline().getDepthState(frame, depths.get(i).intValue()));
        }
        return ret;
    }

    public List<PlaceObjectTypeTag> getSelectedPlaceTags() {
        List<DepthState> dss = this.getSelectedDepthStates();
        if (dss == null) {
            return null;
        }
        ArrayList<PlaceObjectTypeTag> ret = new ArrayList<PlaceObjectTypeTag>();
        for (DepthState ds : dss) {
            if (ds == null) {
                ret.add(null);
                continue;
            }
            if (ds.placeObjectTag == null) {
                ret.add(ds.toPlaceObjectTag(ds.depth));
                continue;
            }
            ret.add(ds.placeObjectTag);
        }
        return ret;
    }

    public Timelined getTimelined() {
        return this.timelined;
    }

    public void setFrame(int frame, List<Integer> depths) {
        this.timelinePanel.setFrame(frame, depths);
    }
}

