/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.easygui.EasyStrings;
import com.jpexs.decompiler.flash.gui.TagNameResolverInterface;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;

public class EasyTagNameResolver
implements TagNameResolverInterface {
    @Override
    public String getTagName(Tag tag) {
        if (tag instanceof ImageTag) {
            ImageTag it = (ImageTag)tag;
            return EasyStrings.translate("item.image") + " " + it.getCharacterId() + it.getImageFormat().getExtension();
        }
        if (tag instanceof ShapeTag) {
            ShapeTag st = (ShapeTag)tag;
            return EasyStrings.translate("item.graphic") + " " + st.getCharacterId();
        }
        if (tag instanceof MorphShapeTag) {
            MorphShapeTag mst = (MorphShapeTag)tag;
            return EasyStrings.translate("item.shapeTween") + " " + mst.getCharacterId();
        }
        if (tag instanceof TextTag) {
            TextTag t = (TextTag)tag;
            return EasyStrings.translate("item.text") + " " + t.getCharacterId();
        }
        if (tag instanceof FontTag) {
            FontTag f = (FontTag)tag;
            return EasyStrings.translate("item.font") + " " + f.getCharacterId();
        }
        if (tag instanceof DefineSpriteTag) {
            DefineSpriteTag st = (DefineSpriteTag)tag;
            return EasyStrings.translate("item.movieClip") + " " + st.getCharacterId();
        }
        if (tag instanceof ButtonTag) {
            ButtonTag bt = (ButtonTag)tag;
            return EasyStrings.translate("item.button") + " " + bt.getCharacterId();
        }
        if (tag instanceof SoundTag) {
            SoundTag st = (SoundTag)tag;
            return EasyStrings.translate("item.sound") + (st.getCharacterId() == -1 ? "" : " " + st.getCharacterId());
        }
        if (tag instanceof DefineVideoStreamTag) {
            DefineVideoStreamTag vt = (DefineVideoStreamTag)tag;
            return EasyStrings.translate("item.video") + " " + vt.getCharacterId();
        }
        return EasyStrings.translate("item.unknown");
    }
}

