/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui;

import com.jpexs.decompiler.flash.easygui.FrameSelectionListener;
import com.jpexs.decompiler.flash.easygui.TimelineBodyPanel;
import com.jpexs.decompiler.flash.easygui.TimelineDepthPanel;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.timeline.Timeline;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class TimelineTimePanel
extends JPanel
implements MouseListener {
    public static final Color BORDER_COLOR = Color.black;
    public static final int LINE_LENGTH = 3;
    public static final int LINE_TEXT_SPACE = 3;
    public static final Color FONT_COLOR = Color.black;
    public float fontSize = 10.0f;
    private int scrollOffset = 0;
    private int selectedFrame = -1;
    private Timeline timeline;
    private final List<FrameSelectionListener> listeners = new ArrayList<FrameSelectionListener>();
    private final TimelineDepthPanel depthPanel;

    public TimelineTimePanel(TimelineDepthPanel depthPanel) {
        Dimension dim = new Dimension(Integer.MAX_VALUE, 18);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.setMinimumSize(new Dimension(0, 18));
        this.addMouseListener(this);
        this.depthPanel = depthPanel;
    }

    public void setTimeline(Timeline timeline) {
        this.setFont(this.getFont().deriveFont(10.0f));
        this.timeline = timeline;
    }

    public void addFrameSelectionListener(FrameSelectionListener l) {
        this.listeners.add(l);
    }

    public void removeFrameSelectionListener(FrameSelectionListener l) {
        this.listeners.remove(l);
    }

    public void frameSelect(int frame) {
        if (this.selectedFrame == frame) {
            return;
        }
        this.selectedFrame = frame;
        this.repaint();
    }

    public void scroll(int offset) {
        this.scrollOffset = offset;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int f;
        Rectangle clip = g.getClipBounds();
        int frameWidth = TimelineBodyPanel.getFrameWidthForTimeline(this.timeline);
        int start_f = (this.scrollOffset + clip.x) / frameWidth;
        int end_f = (this.scrollOffset + clip.x + clip.width) / frameWidth;
        g.setColor(TimelineBodyPanel.getBackgroundColor());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(BORDER_COLOR);
        int xofs = -this.scrollOffset % frameWidth;
        for (f = 0; f <= end_f; ++f) {
            g.drawLine(xofs + f * frameWidth + 1, 17, xofs + f * frameWidth + 1, 15);
        }
        g.setFont(g.getFont().deriveFont(this.fontSize));
        for (f = 0; f <= end_f; ++f) {
            int w;
            String timeStr;
            int cur_f = start_f + f;
            if (this.selectedFrame == cur_f) {
                g.setColor(TimelineBodyPanel.SELECTED_COLOR);
                g.fillRect(xofs + f * frameWidth + 1, 0, frameWidth, 17);
                g.setColor(TimelineBodyPanel.SELECTED_BORDER_COLOR);
                g.drawRect(xofs + f * frameWidth + 1, 0, frameWidth, 17);
            }
            g.setColor(FONT_COLOR);
            if (this.timeline != null && this.timeline.timelined instanceof ButtonTag) {
                if (f >= 5) continue;
                timeStr = "";
                switch (f) {
                    case 0: {
                        timeStr = "Up";
                        break;
                    }
                    case 1: {
                        timeStr = "Over";
                        break;
                    }
                    case 2: {
                        timeStr = "Down";
                        break;
                    }
                    case 3: {
                        timeStr = "Hit";
                    }
                }
                w = g.getFontMetrics().stringWidth(timeStr);
                g.drawString(timeStr, xofs + f * frameWidth + frameWidth / 2 - w / 2 + 1, 12);
                continue;
            }
            if ((cur_f + 1) % 5 != 0 && cur_f != 0) continue;
            timeStr = Integer.toString(cur_f + 1);
            w = g.getFontMetrics().stringWidth(timeStr);
            g.drawString(timeStr, xofs + f * frameWidth + frameWidth / 2 - w / 2 + 1, 12);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int frame = (this.scrollOffset + e.getX()) / TimelineBodyPanel.getFrameWidthForTimeline(this.timeline);
        this.frameSelect(frame);
        for (FrameSelectionListener l : this.listeners) {
            l.frameSelected(frame, new ArrayList<Integer>());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

