/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.easygui.properties;

import com.jpexs.decompiler.flash.easygui.properties.AbstractPropertyField;
import com.jpexs.decompiler.flash.easygui.properties.PropertyValidationInterface;

public class IntegerPropertyField
extends AbstractPropertyField<Integer> {
    private PropertyValidationInterface<Integer> minValidation = null;
    private PropertyValidationInterface<Integer> maxValidation = null;

    public IntegerPropertyField(int value, int min, int max) {
        super("" + value);
        this.setMin(min);
        this.setMax(max);
        this.writeField.setColumns(("" + max).length());
    }

    public IntegerPropertyField(int value) {
        super("" + value);
    }

    public void setMax(final int max) {
        if (this.maxValidation != null) {
            this.removeValidation(this.maxValidation);
        }
        this.maxValidation = new PropertyValidationInterface<Integer>(){

            @Override
            public boolean validate(Integer value) {
                return value <= max;
            }
        };
        this.addValidation(this.maxValidation);
    }

    public void setMin(final int min) {
        if (this.minValidation != null) {
            this.removeValidation(this.minValidation);
        }
        this.minValidation = new PropertyValidationInterface<Integer>(){

            @Override
            public boolean validate(Integer value) {
                return value >= min;
            }
        };
        this.addValidation(this.minValidation);
    }

    @Override
    protected Integer textToValue(String text) {
        try {
            return Integer.valueOf(text);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    protected String valueToText(Integer value) {
        return "" + value;
    }
}

