/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.ConfigurationFile;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ConfigurationFileSelection
extends JPanel {
    private JTextField textField;

    public ConfigurationFileSelection(ConfigurationItem item, ConfigurationFile confFile, String value, String description) {
        this.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.setText(value);
        this.textField.setToolTipText(description);
        this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        this.add((Component)this.textField, "Center");
        JButton butSelect = new JButton(View.getIcon("folderopen16"));
        butSelect.setToolTipText(ResourceBundle.getBundle(AppStrings.getResourcePath(MainFrame.class)).getString("FileChooser.openButtonText"));
        butSelect.setMargin(new Insets(2, 2, 2, 2));
        butSelect.addActionListener(e -> this.textField.setText(ConfigurationFileSelection.selectConfigFile(item, this.textField.getText(), confFile.value())));
        this.add((Component)butSelect, "East");
    }

    private static String selectConfigFile(ConfigurationItem config, String current, final String pattern) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(current));
        fc.setMultiSelectionEnabled(false);
        fc.setCurrentDirectory(new File((String)config.get()));
        FileFilter allSupportedFilter = new FileFilter(){
            private final String[] supportedExtensions = new String[]{".swf", ".gfx", ".swc", ".zip", ".iggy"};

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().matches(pattern);
            }

            @Override
            public String getDescription() {
                return "";
            }
        };
        fc.setFileFilter(allSupportedFilter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showOpenDialog(Main.getDefaultMessagesComponent());
        if (returnVal == 0) {
            return Helper.fixDialogFile((File)fc.getSelectedFile()).getAbsolutePath();
        }
        return (String)config.get();
    }

    public String getValue() {
        return this.textField.getText();
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

