/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ConvertPlaceObjectTypeDialog
extends AppDialog {
    private List<JRadioButton> radios = new ArrayList<JRadioButton>();
    private int result = 0;

    public ConvertPlaceObjectTypeDialog(Window owner, final int currentPlaceObjectNum, int min) {
        super(owner);
        this.setTitle(this.translate("dialog.title"));
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        ButtonGroup radioGroup = new ButtonGroup();
        final JButton okButton = new JButton(this.translate("button.ok"));
        int i = 1;
        while (i <= 4) {
            String text = "PlaceObject" + (i > 1 ? "" + i : "");
            if (i == min) {
                text = text + " " + this.translate("minimum");
            }
            text = text + " - " + this.translate("place" + i);
            JRadioButton radio = new JRadioButton(text);
            radio.setAlignmentX(0.0f);
            if (i == currentPlaceObjectNum) {
                radio.setSelected(true);
            }
            final int fi = i++;
            radio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    okButton.setEnabled(fi != currentPlaceObjectNum);
                }
            });
            radioPanel.add(radio);
            radioGroup.add(radio);
            this.radios.add(radio);
        }
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.add((Component)radioPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        okButton.setEnabled(false);
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        cnt.add((Component)buttonsPanel, "South");
        this.pack();
        View.centerScreen(this);
        View.setWindowIcon(this, "placeobject");
        this.setModal(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        for (int i = 0; i < this.radios.size(); ++i) {
            if (!this.radios.get(i).isSelected()) continue;
            this.result = i + 1;
            break;
        }
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public int getResult() {
        return this.result;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }
}

