/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.helpers.Helper;
import dev.matrixlab.webp4j.WebPCodec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FileChooserImagePreview
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;
    public static final int PREVIEW_SIZE = 150;

    public FileChooserImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(150, 50));
        fc.addPropertyChangeListener(this);
        JLabel topLabel = new JLabel(AppStrings.translate("FileChooser.preview"), 0);
        Border b = UIManager.getBorder("FileChooser.listViewBorder");
        topLabel.setBorder(b);
        JPanel previewPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (FileChooserImagePreview.this.thumbnail == null) {
                    FileChooserImagePreview.this.loadImage();
                }
                if (FileChooserImagePreview.this.thumbnail != null) {
                    int x = this.getWidth() / 2 - FileChooserImagePreview.this.thumbnail.getIconWidth() / 2;
                    int y = this.getHeight() / 2 - FileChooserImagePreview.this.thumbnail.getIconHeight() / 2;
                    if (y < 0) {
                        y = 0;
                    }
                    if (x < 5) {
                        x = 5;
                    }
                    FileChooserImagePreview.this.thumbnail.paintIcon(this, g, x, y);
                } else {
                    String str = AppStrings.translate("FileChooser.previewNotAvailable");
                    g.drawString(str, this.getWidth() / 2 - g.getFontMetrics().stringWidth(str) / 2, this.getHeight() / 2 + g.getFontMetrics().getHeight() / 2);
                }
            }
        };
        JPanel fullPanel = new JPanel(new BorderLayout());
        fullPanel.add((Component)topLabel, "North");
        fullPanel.add((Component)previewPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(fullPanel), "Center");
    }

    public void loadImage() {
        if (this.file == null) {
            this.thumbnail = null;
            return;
        }
        BufferedImage img = null;
        if (this.file.getPath().toLowerCase().endsWith(".webp")) {
            if (ImageFormat.WEBP.available()) {
                try {
                    img = WebPCodec.decodeImage((byte[])Helper.readFile((String[])new String[]{this.file.getAbsolutePath()}));
                }
                catch (IOException iOException) {}
            }
        } else {
            try (FileInputStream fis2 = new FileInputStream(this.file);){
                img = ImageHelper.read((InputStream)fis2);
            }
            catch (IOException fis2) {
                // empty catch block
            }
        }
        if (img != null) {
            ImageIcon tmpIcon = new ImageIcon(img);
            this.thumbnail = tmpIcon.getImageLoadStatus() == 8 ? (tmpIcon.getIconWidth() > 150 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(150, -1, 1)) : tmpIcon) : null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }
}

