/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;

public class FolderListPanel
extends JPanel {
    private List<TreeItem> items;
    private TreePath parentPath;
    private int selectedIndex = -1;
    private Map<Integer, TreeItem> selectedItems = new TreeMap<Integer, TreeItem>();
    private static final int PREVIEW_SIZE = 150;
    private static final int BORDER_SIZE = 5;
    private static final int LABEL_HEIGHT = 20;
    private static final int CELL_HEIGHT = 180;
    private static final int CELL_WIDTH = 160;
    private static final Map<TreeNodeType, Icon> ICONS = new HashMap<TreeNodeType, Icon>();
    protected Map<TreeItem, Set<Integer>> missingNeededCharacters = new WeakHashMap<TreeItem, Set<Integer>>();
    private MainPanel mainPanel;
    private static final SerializableImage noImage;

    public FolderListPanel(final MainPanel mainPanel, List<TreeItem> items) {
        this.items = items;
        this.mainPanel = mainPanel;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    FolderListPanel.this.goToSelection();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FolderListPanel.this.requestFocusInWindow();
                int width = FolderListPanel.this.getWidth();
                int cols = width / 160;
                int rows = (int)Math.ceil((float)FolderListPanel.this.items.size() / (float)cols);
                int x = e.getX() / 160;
                int y = e.getY() / 180;
                int index = y * cols + x;
                if (index >= FolderListPanel.this.items.size()) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) || FolderListPanel.this.selectedItems.isEmpty()) {
                    if (!e.isControlDown()) {
                        FolderListPanel.this.selectedItems.clear();
                    }
                    int oldSelectedIndex = FolderListPanel.this.selectedIndex;
                    FolderListPanel.this.selectedIndex = index;
                    if (e.isShiftDown() && oldSelectedIndex > -1) {
                        int minindex = Math.min(FolderListPanel.this.selectedIndex, oldSelectedIndex);
                        int maxindex = Math.max(FolderListPanel.this.selectedIndex, oldSelectedIndex);
                        for (int i = minindex; i <= maxindex; ++i) {
                            FolderListPanel.this.selectedItems.put(i, FolderListPanel.this.items.get(i));
                        }
                        FolderListPanel.this.selectedIndex = oldSelectedIndex;
                    } else {
                        TreeItem ti = (TreeItem)FolderListPanel.this.items.get(index);
                        if (!FolderListPanel.this.selectedItems.containsKey(FolderListPanel.this.selectedIndex)) {
                            FolderListPanel.this.selectedItems.put(FolderListPanel.this.selectedIndex, ti);
                        } else {
                            FolderListPanel.this.selectedItems.remove(FolderListPanel.this.selectedIndex);
                            FolderListPanel.this.selectedIndex = -1;
                        }
                    }
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    mainPanel.getContextPopupMenu().update(FolderListPanel.this.getSelectedItemsSorted(), true);
                    mainPanel.getContextPopupMenu().show(FolderListPanel.this, e.getX(), e.getY());
                }
                FolderListPanel.this.repaint();
            }
        });
        this.setFocusable(true);
    }

    public void goToSelection() {
        if (this.selectedIndex > -1) {
            TreeItem selectedItem = this.items.get(this.selectedIndex);
            TreePath subPath = this.parentPath.pathByAddingChild(selectedItem);
            this.mainPanel.getCurrentTree().setSelectionPath(subPath);
        }
    }

    public synchronized void setItems(TreePath parentPath, List<TreeItem> items) {
        this.items = items;
        this.parentPath = parentPath;
        this.revalidate();
        this.repaint();
        this.selectedItems.clear();
        this.selectedIndex = -1;
        ((JScrollPane)this.getParent().getParent()).getVerticalScrollBar().setValue(0);
    }

    public void clear() {
        this.items = new ArrayList<TreeItem>();
        this.selectedItems.clear();
        this.selectedIndex = -1;
        this.parentPath = null;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.getParent().getSize().width - 1;
        int cols = width / 160;
        int rows = (int)Math.ceil((float)this.items.size() / (float)cols);
        int height = rows * 180;
        int prefWidth = cols * 160;
        return new Dimension(prefWidth, height);
    }

    @Override
    public void paint(Graphics g) {
        Color selectedTextColor;
        Color textColor;
        Color borderColor;
        Color selectedColor;
        Color color;
        super.paint(g);
        Rectangle r = this.getVisibleRect();
        int width = this.getWidth();
        int cols = width / 160;
        int start_y = r.y / 180;
        JLabel l = new JLabel();
        Font f = l.getFont().deriveFont(AffineTransform.getScaleInstance(0.8, 0.8));
        int finish_y = (int)Math.ceil((float)(r.y + r.height) / 180.0f);
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            SubstanceSkin skin = SubstanceLookAndFeel.getCurrentSkin();
            color = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
            selectedColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getBackgroundFillColor();
            borderColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED).getUltraDarkColor();
            textColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getForegroundColor();
            selectedTextColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getForegroundColor();
        } else {
            color = SystemColor.control;
            selectedColor = SystemColor.textHighlight;
            borderColor = SystemColor.controlShadow;
            textColor = SystemColor.controlText;
            selectedTextColor = SystemColor.textHighlightText;
        }
        for (int y = start_y; y <= finish_y; ++y) {
            for (int x = 0; x < cols; ++x) {
                int itemIndex;
                DoInitActionTag tag;
                String expName;
                ScriptPack sp;
                int index = y * cols + x;
                if (index >= this.items.size()) continue;
                g.setColor(color);
                if (this.selectedItems.containsKey(index)) {
                    g.setColor(selectedColor);
                }
                g.fillRect(x * 160, y * 180, 160, 180);
                TreeItem treeItem = this.items.get(index);
                TreeNodeType type = AbstractTagTree.getTreeNodeType(treeItem);
                if (treeItem instanceof FrameScript && ((FrameScript)treeItem).getSingleDoActionTag() != null) {
                    type = TreeNodeType.AS_FRAME;
                }
                Icon icon = ICONS.get((Object)type);
                if (treeItem instanceof ScriptPack && (sp = (ScriptPack)treeItem).isDocumentClass()) {
                    icon = View.getIcon("asclassmain32");
                }
                icon.paintIcon(l, g, x * 160 + 5 + 75 - icon.getIconWidth() / 2, y * 180 + 5 + 75 - icon.getIconHeight() / 2);
                String s = null;
                if (treeItem instanceof DoInitActionTag && (expName = (tag = (DoInitActionTag)treeItem).getSwf().getExportName(tag.getCharacterId())) != null && !expName.isEmpty()) {
                    String[] stringArray;
                    if (expName.contains(".")) {
                        stringArray = expName.split("\\.");
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = expName;
                    }
                    String[] pathParts = stringArray;
                    s = expName.startsWith("__Packages.") ? IdentifiersDeobfuscation.printIdentifier((SWF)tag.getSwf(), new LinkedHashSet(), (boolean)false, (String)pathParts[pathParts.length - 1], (String[])new String[0]) : Helper.escapeExportname((SWF)tag.getSwf(), (String)expName, (boolean)false);
                }
                if (s == null) {
                    if (treeItem instanceof Tag) {
                        Tag t = (Tag)treeItem;
                        String uniqueId = t.getUniqueId();
                        s = ((Tag)treeItem).getTagName();
                        if (uniqueId != null) {
                            s = s + " (" + uniqueId + ")";
                        }
                    } else {
                        s = treeItem.toString();
                    }
                }
                if ((itemIndex = this.mainPanel.getCurrentTree().getFullModel().getItemIndex(treeItem)) > 1) {
                    s = s + " [" + itemIndex + "]";
                }
                g.setFont(f);
                g.setColor(borderColor);
                g.drawLine(x * 160, y * 180 + 5 + 150, x * 160 + 160, y * 180 + 5 + 150);
                g.drawRect(x * 160, y * 180, 160, 180);
                g.setColor(textColor);
                if (this.selectedItems.containsKey(index)) {
                    g.setColor(selectedTextColor);
                }
                g.drawString(s, x * 160 + 5, y * 180 + 5 + 150 + 20);
            }
        }
    }

    public List<TreeItem> getSelectedItemsSorted() {
        return new ArrayList<TreeItem>(this.selectedItems.values());
    }

    public boolean isSomethingSelected() {
        return !this.selectedItems.isEmpty();
    }

    static {
        for (TreeNodeType treeNodeType : TreeNodeType.values()) {
            if (treeNodeType == TreeNodeType.UNKNOWN) continue;
            String tagTypeStr = treeNodeType.toString().toLowerCase(Locale.ENGLISH).replace("_", "");
            try {
                ICONS.put(treeNodeType, View.getIcon(tagTypeStr + "32"));
            }
            catch (NullPointerException npe) {
                System.err.println("ICON " + tagTypeStr + "32.png does not exist!");
                ICONS.put(treeNodeType, View.getIcon("about32"));
            }
        }
        noImage = new SerializableImage(150, 150, 2);
        noImage.fillTransparent();
    }
}

