/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Scene;
import com.jpexs.decompiler.flash.timeline.SceneFrame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;

public class FolderPreviewPanel
extends JPanel {
    private static ExecutorService executor;
    private List<TreeItem> items;
    private int selectedIndex = -1;
    private boolean repaintQueued;
    private Map<Integer, TreeItem> selectedItems = new TreeMap<Integer, TreeItem>();
    private Cache<Integer, SerializableImage> cachedPreviews;
    private MainPanel mainPanel;
    private static final int PREVIEW_SIZE = 150;
    private static final int BORDER_SIZE = 5;
    private static final int LABEL_HEIGHT = 20;
    private static final int CELL_HEIGHT = 180;
    private static final int CELL_WIDTH = 160;
    private static final SerializableImage noImage;

    public FolderPreviewPanel(final MainPanel mainPanel, List<TreeItem> items) {
        this.items = items;
        this.mainPanel = mainPanel;
        this.cachedPreviews = Cache.getInstance((boolean)false, (boolean)false, (String)"preview", (boolean)true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    FolderPreviewPanel.this.goToSelection();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                FolderPreviewPanel.this.requestFocusInWindow();
                int width = FolderPreviewPanel.this.getWidth();
                int cols = width / 160;
                int rows = (int)Math.ceil((float)FolderPreviewPanel.this.items.size() / (float)cols);
                int x = e.getX() / 160;
                int y = e.getY() / 180;
                int index = y * cols + x;
                if (index >= FolderPreviewPanel.this.items.size()) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e) || FolderPreviewPanel.this.selectedItems.isEmpty()) {
                    if (!e.isControlDown()) {
                        FolderPreviewPanel.this.selectedItems.clear();
                    }
                    int oldSelectedIndex = FolderPreviewPanel.this.selectedIndex;
                    FolderPreviewPanel.this.selectedIndex = index;
                    if (e.isShiftDown() && oldSelectedIndex > -1) {
                        int minindex = Math.min(FolderPreviewPanel.this.selectedIndex, oldSelectedIndex);
                        int maxindex = Math.max(FolderPreviewPanel.this.selectedIndex, oldSelectedIndex);
                        for (int i = minindex; i <= maxindex; ++i) {
                            FolderPreviewPanel.this.selectedItems.put(i, FolderPreviewPanel.this.items.get(i));
                        }
                        FolderPreviewPanel.this.selectedIndex = oldSelectedIndex;
                    } else {
                        TreeItem ti = (TreeItem)FolderPreviewPanel.this.items.get(index);
                        if (!FolderPreviewPanel.this.selectedItems.containsKey(FolderPreviewPanel.this.selectedIndex)) {
                            FolderPreviewPanel.this.selectedItems.put(FolderPreviewPanel.this.selectedIndex, ti);
                        } else {
                            FolderPreviewPanel.this.selectedItems.remove(FolderPreviewPanel.this.selectedIndex);
                            FolderPreviewPanel.this.selectedIndex = -1;
                        }
                    }
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    mainPanel.getContextPopupMenu().update(FolderPreviewPanel.this.getSelectedItemsSorted(), true);
                    mainPanel.getContextPopupMenu().show(FolderPreviewPanel.this, e.getX(), e.getY());
                }
                FolderPreviewPanel.this.repaint();
            }
        });
        this.setFocusable(true);
    }

    public void goToSelection() {
        if (this.selectedIndex > -1) {
            this.mainPanel.setTagTreeSelectedNode(this.mainPanel.getCurrentTree(), this.items.get(this.selectedIndex));
        }
    }

    public synchronized void setItems(List<TreeItem> items) {
        this.items = items;
        executor.shutdownNow();
        executor = Executors.newFixedThreadPool((Boolean)Configuration.parallelSpeedUp.get() != false ? Configuration.getParallelThreadCount() : 1);
        this.cachedPreviews.clear();
        this.selectedItems.clear();
        this.selectedIndex = -1;
        this.revalidate();
        this.repaint();
        ((JScrollPane)this.getParent().getParent()).getVerticalScrollBar().setValue(0);
    }

    public void clear() {
        this.items = new ArrayList<TreeItem>();
        executor.shutdownNow();
        this.cachedPreviews.clear();
        this.selectedItems.clear();
        this.selectedIndex = -1;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.getParent().getSize().width - 1;
        int cols = width / 160;
        int rows = (int)Math.ceil((float)this.items.size() / (float)cols);
        int height = rows * 180;
        int prefWidth = cols * 160;
        return new Dimension(prefWidth, height);
    }

    @Override
    public void paint(Graphics g) {
        Color selectedTextColor;
        Color textColor;
        Color borderColor;
        Color selectedColor;
        Color color;
        super.paint(g);
        this.repaintQueued = false;
        Rectangle r = this.getVisibleRect();
        int width = this.getWidth();
        int cols = width / 160;
        int start_y = r.y / 180;
        JLabel l = new JLabel();
        Font f = l.getFont().deriveFont(AffineTransform.getScaleInstance(0.8, 0.8));
        int finish_y = (int)Math.ceil((float)(r.y + r.height) / 180.0f);
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            SubstanceSkin skin = SubstanceLookAndFeel.getCurrentSkin();
            color = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
            selectedColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getBackgroundFillColor();
            borderColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED).getUltraDarkColor();
            textColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getForegroundColor();
            selectedTextColor = skin.getColorScheme(DecorationAreaType.GENERAL, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED).getForegroundColor();
        } else {
            color = SystemColor.control;
            selectedColor = SystemColor.textHighlight;
            borderColor = SystemColor.controlShadow;
            textColor = SystemColor.controlText;
            selectedTextColor = SystemColor.textHighlightText;
        }
        for (int y = start_y; y <= finish_y; ++y) {
            for (int x = 0; x < cols; ++x) {
                String s;
                int index = y * cols + x;
                if (index >= this.items.size()) continue;
                g.setColor(color);
                if (this.selectedItems.containsKey(index)) {
                    g.setColor(selectedColor);
                }
                g.fillRect(x * 160, y * 180, 160, 180);
                if (this.cachedPreviews.contains((Object)index)) {
                    SerializableImage sImg = (SerializableImage)this.cachedPreviews.get((Object)index);
                    if (sImg != null) {
                        BufferedImage img = ((SerializableImage)this.cachedPreviews.get((Object)index)).getBufferedImage();
                        g.drawImage(img, x * 160 + 5 + 75 - img.getWidth() / 2, y * 180 + 5 + 75 - img.getHeight() / 2, null);
                    }
                } else {
                    this.cachedPreviews.put((Object)index, (Object)noImage);
                    this.renderImageTask(index, this.items.get(index));
                }
                TreeItem treeItem = this.items.get(index);
                if (treeItem instanceof Tag) {
                    Tag t = (Tag)treeItem;
                    String uniqueId = t.getUniqueId();
                    s = ((Tag)treeItem).getTagName();
                    if (uniqueId != null) {
                        s = s + " (" + uniqueId + ")";
                    }
                } else {
                    s = treeItem.toString();
                }
                int itemIndex = this.mainPanel.getCurrentTree().getFullModel().getItemIndex(treeItem);
                if (itemIndex > 1) {
                    s = s + " [" + itemIndex + "]";
                }
                g.setFont(f);
                g.setColor(borderColor);
                g.drawLine(x * 160, y * 180 + 5 + 150, x * 160 + 160, y * 180 + 5 + 150);
                g.drawRect(x * 160, y * 180, 160, 180);
                g.setColor(textColor);
                if (this.selectedItems.containsKey(index)) {
                    g.setColor(selectedTextColor);
                }
                g.drawString(s, x * 160 + 5, y * 180 + 5 + 150 + 20);
            }
        }
    }

    private synchronized void renderImageTask(int index, TreeItem treeItem) {
        executor.submit(() -> {
            this.cachedPreviews.put((Object)index, (Object)this.renderImage((SWF)treeItem.getOpenable(), treeItem));
            if (!this.repaintQueued) {
                this.repaintQueued = true;
                View.execInEventDispatchLater(() -> this.repaint());
            }
            return null;
        });
    }

    private SerializableImage renderImage(SWF swf, TreeItem treeItem) {
        RECT rect;
        int width = 0;
        int height = 0;
        SerializableImage imgSrc = null;
        Matrix m = new Matrix();
        double ow = 1.0;
        double oh = 1.0;
        if (treeItem instanceof Scene) {
            treeItem = ((Scene)treeItem).getSceneFrame(0);
        }
        if (treeItem instanceof SceneFrame) {
            treeItem = ((SceneFrame)treeItem).getFrame();
        }
        if (treeItem instanceof Frame) {
            double ratio;
            Frame fn = (Frame)treeItem;
            rect = swf.displayRect;
            ow = rect.getWidth();
            oh = rect.getHeight();
            double zoom = 1.0;
            if (rect.getWidth() > 0 && (ratio = 2980.0 / (double)rect.getWidth()) < zoom) {
                zoom = ratio;
            }
            if (rect.getHeight() > 0 && (ratio = 2980.0 / (double)rect.getHeight()) < zoom) {
                zoom = ratio;
            }
            Timeline timeline = swf.getTimeline();
            String key = "frame_" + fn.frame + "_" + timeline.id + "_" + zoom;
            imgSrc = swf.getFromCache(key);
            if (imgSrc == null) {
                imgSrc = SWF.frameToImageGet((Timeline)timeline, (int)fn.frame, (int)0, null, (int)0, (RECT)rect, (Matrix)new Matrix(), null, (Color)(swf.getBackgroundColor() == null ? null : swf.getBackgroundColor().backgroundColor.toColor()), (double)zoom, ((Boolean)Configuration.disableBitmapSmoothing.get() == false ? 1 : 0) != 0);
                swf.putToCache(key, imgSrc);
            }
            width = imgSrc.getWidth();
            height = imgSrc.getHeight();
        } else if (treeItem instanceof ImageTag) {
            imgSrc = ((ImageTag)treeItem).getImageCached();
            width = imgSrc.getWidth();
            height = imgSrc.getHeight();
            ow = (double)width * 20.0;
            oh = (double)height * 20.0;
        } else if (treeItem instanceof BoundedTag) {
            BoundedTag boundedTag = (BoundedTag)treeItem;
            rect = boundedTag.getRect();
            ow = rect.getWidth();
            oh = rect.getHeight();
            width = (int)((double)rect.getWidth() / 20.0) + 1;
            height = (int)((double)rect.getHeight() / 20.0) + 1;
            m.translate((double)(-rect.Xmin), (double)(-rect.Ymin));
        }
        int w1 = width;
        int h1 = height;
        int w2 = 150;
        int h2 = 150;
        int h = h1 * w2 / w1;
        int w = h > h2 ? w1 * h2 / h1 : w2;
        double scale = (double)w / (double)w1;
        if (w1 <= w2 && h1 <= h2) {
            if (imgSrc != null) {
                return imgSrc;
            }
            scale = 1.0;
        }
        m = m.preConcatenate(Matrix.getScaleInstance((double)scale));
        width = (int)(scale * (double)width);
        height = (int)(scale * (double)height);
        if (width == 0 || height == 0) {
            return null;
        }
        SerializableImage image = new SerializableImage(width, height, SerializableImage.TYPE_INT_ARGB);
        image.fillTransparent();
        if (imgSrc == null) {
            DrawableTag drawable = (DrawableTag)treeItem;
            ExportRectangle viewRectangle = new ExportRectangle(0.0, 0.0, ow, oh);
            drawable.toImage(0, 0, 0, new RenderContext(), image, image, false, m, new Matrix(), m, m, null, scale, false, viewRectangle, viewRectangle, true, 0, 0, (Boolean)Configuration.disableBitmapSmoothing.get() == false);
        } else {
            Graphics2D g = (Graphics2D)image.getGraphics();
            g.setTransform(m.toTransform());
            g.drawImage((Image)imgSrc.getBufferedImage(), 0, 0, null);
        }
        return image;
    }

    public List<TreeItem> getSelectedItemsSorted() {
        return new ArrayList<TreeItem>(this.selectedItems.values());
    }

    public boolean isSomethingSelected() {
        return !this.selectedItems.isEmpty();
    }

    public Map<Integer, TreeItem> getSelectedItems() {
        return this.selectedItems;
    }

    public void setSelectedItems(Map<Integer, TreeItem> selectedItems) {
        this.selectedItems = selectedItems;
    }

    static {
        noImage = new SerializableImage(150, 150, 2);
        noImage.fillTransparent();
        executor = Executors.newFixedThreadPool((Boolean)Configuration.parallelSpeedUp.get() != false ? Configuration.getParallelThreadCount() : 1);
    }
}

