/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.GenericTagPanel;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.generictageditors.Amf3ValueEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.BinaryDataEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.BooleanEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ColorEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.EnumEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.FloatEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.FullSized;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.NumberEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.StringEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.UUIDEditor;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.HasSwfAndTag;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.ConditionalType;
import com.jpexs.decompiler.flash.types.annotations.DottedIdentifier;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Multiline;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.decompiler.flash.types.annotations.UUID;
import com.jpexs.decompiler.flash.types.annotations.parser.AnnotationParseException;
import com.jpexs.decompiler.flash.types.annotations.parser.ConditionEvaluator;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.ConcreteClasses;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GenericTagTreePanel
extends GenericTagPanel {
    private static final Logger logger = Logger.getLogger(GenericTagTreePanel.class.getName());
    private JTree tree;
    private Tag editedTag;
    private static final Map<Class, List<Field>> fieldCache = new HashMap<Class, List<Field>>();
    private static final int FIELD_INDEX = 0;
    private List<TreeModelListener> modelListeners = new ArrayList<TreeModelListener>();
    private Tag tag;

    public void addTreeModelListener(TreeModelListener listener) {
        this.modelListeners.add(listener);
        ((DefaultTreeModel)this.tree.getModel()).addTreeModelListener(listener);
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.removeTreeSelectionListener(listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.modelListeners.remove(listener);
        ((DefaultTreeModel)this.tree.getModel()).removeTreeModelListener(listener);
    }

    private static SWFType evalSwfType(MyTreeModel mod, String parentPath, final SWFType swfType) {
        if (swfType == null) {
            return null;
        }
        if ("".equals(swfType.alternateCondition())) {
            return swfType;
        }
        Conditional cond = new Conditional(){

            public String[] value() {
                return new String[]{swfType.alternateCondition()};
            }

            public int[] tags() {
                return new int[0];
            }

            public int minSwfVersion() {
                return 1;
            }

            public int maxSwfVersion() {
                return Integer.MAX_VALUE;
            }

            public int[] options() {
                return new int[0];
            }

            public boolean revert() {
                return false;
            }

            public Class<? extends Annotation> annotationType() {
                return Conditional.class;
            }
        };
        ConditionEvaluator ev = new ConditionEvaluator(cond);
        try {
            HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
            for (String sf : ev.getFields()) {
                String fulldf = parentPath + "." + sf;
                FieldNode condnode = (FieldNode)mod.getNodeByPath(fulldf);
                if (condnode != null) {
                    Object value = ReflectionTools.getValue((Object)condnode.obj, (Field)condnode.fieldSet.get(0), (int)condnode.index);
                    if (value instanceof Boolean) {
                        fieldMap.put(sf, (Boolean)value);
                        continue;
                    }
                    if (!(value instanceof Integer)) continue;
                    int intValue = (Integer)value;
                    boolean found = false;
                    for (int i : cond.options()) {
                        if (i != intValue) continue;
                        found = true;
                    }
                    fieldMap.put(sf, found);
                    continue;
                }
                fieldMap.put(sf, true);
            }
            if (!ev.eval(fieldMap, 0)) {
                return swfType;
            }
            return new SWFType(){

                public BasicType value() {
                    return swfType.alternateValue();
                }

                public BasicType alternateValue() {
                    return BasicType.NONE;
                }

                public String alternateCondition() {
                    return "";
                }

                public int count() {
                    return swfType.count();
                }

                public String countField() {
                    return swfType.countField();
                }

                public int countAdd() {
                    return swfType.countAdd();
                }

                public Class<? extends Annotation> annotationType() {
                    return SWFType.class;
                }

                public boolean canAdd() {
                    return swfType.canAdd();
                }
            };
        }
        catch (AnnotationParseException | IllegalAccessException | IllegalArgumentException ex) {
            logger.log(Level.SEVERE, null, ex);
            return swfType;
        }
    }

    @Override
    public boolean tryAutoSave() {
        if (((Boolean)Configuration.autoSaveTagModifications.get()).booleanValue()) {
            if (this.tag == null) {
                return true;
            }
            return this.save();
        }
        return true;
    }

    public GenericTagTreePanel(MainPanel mainPanel) {
        super(mainPanel);
        this.setLayout(new BorderLayout());
        this.tree = new MyTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.add((Component)new FasterScrollPane(this.tree), "Center");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FieldNode fnode;
                Field field;
                Object selObject;
                if (!GenericTagTreePanel.this.tree.isEditable()) {
                    return;
                }
                int selRow = GenericTagTreePanel.this.tree.getRowForLocation(e.getX(), e.getY());
                final TreePath selPath = GenericTagTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && selPath != null && e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e) && (selObject = selPath.getLastPathComponent()) instanceof FieldNode && ReflectionTools.needsIndex((Field)(field = (fnode = (FieldNode)selObject).fieldSet.get(0)))) {
                    SWFArray swfArray = fnode.fieldSet.get(0).getAnnotation(SWFArray.class);
                    SWFType swfType = fnode.fieldSet.get(0).getAnnotation(SWFType.class);
                    String itemStr = "";
                    if (swfArray != null) {
                        itemStr = swfArray.value();
                    }
                    if (((FieldNode)fnode).fieldSet.itemName != null && !((FieldNode)fnode).fieldSet.itemName.isEmpty()) {
                        itemStr = ((FieldNode)fnode).fieldSet.itemName;
                    }
                    if (itemStr.isEmpty()) {
                        itemStr = AppStrings.translate("generictag.array.item");
                    }
                    boolean canAdd = true;
                    if (!ReflectionTools.canAddToField((Object)fnode.obj, (Field)fnode.fieldSet.get(0))) {
                        canAdd = false;
                    }
                    if (swfArray != null && swfArray.count() > 0) {
                        canAdd = false;
                    }
                    if (swfType != null && !swfType.canAdd()) {
                        canAdd = false;
                    }
                    JPopupMenu p = new JPopupMenu();
                    Class subtype = ReflectionTools.getFieldSubType((Object)fnode.obj, (Field)fnode.fieldSet.get(0));
                    if (!canAdd && subtype.isAnnotationPresent(ConcreteClasses.class)) {
                        Class[] availableClasses = subtype.getAnnotation(ConcreteClasses.class).value();
                        JMenu mBegin = new JMenu(AppStrings.translate("generictag.array.insertbeginning").replace("%item%", itemStr));
                        p.add(mBegin);
                        JMenu mBefore = new JMenu(AppStrings.translate("generictag.array.insertbefore").replace("%item%", itemStr));
                        if (fnode.index > -1) {
                            p.add(mBefore);
                        }
                        JMenuItem mi = new JMenuItem(AppStrings.translate("generictag.array.remove").replace("%item%", itemStr));
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TreePath[] tps = GenericTagTreePanel.this.tree.getSelectionPaths();
                                if (tps == null) {
                                    tps = new TreePath[]{selPath};
                                }
                                boolean somethingRemoved = false;
                                for (int t = tps.length - 1; t >= 0; --t) {
                                    TreePath tp = tps[t];
                                    Object selObject = tp.getLastPathComponent();
                                    if (!(selObject instanceof FieldNode)) continue;
                                    FieldNode fnode2 = (FieldNode)selObject;
                                    GenericTagTreePanel.this.removeItem(fnode2.obj, fnode2.fieldSet.get(0), fnode2.index);
                                    somethingRemoved = true;
                                }
                                if (!somethingRemoved) {
                                    GenericTagTreePanel.this.removeItem(fnode.obj, fnode.fieldSet.get(0), fnode.index);
                                }
                            }
                        });
                        if (fnode.index > -1) {
                            p.add(mi);
                        }
                        JMenu mAfter = new JMenu(AppStrings.translate("generictag.array.insertafter").replace("%item%", itemStr));
                        if (fnode.index > -1) {
                            p.add(mAfter);
                        }
                        JMenu mEnd = new JMenu(AppStrings.translate("generictag.array.insertend").replace("%item%", itemStr));
                        p.add(mEnd);
                        for (Class c : availableClasses) {
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), 0, c));
                            mBegin.add(mi);
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index, c));
                            mBefore.add(mi);
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index + 1, c));
                            mAfter.add(mi);
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), ReflectionTools.getFieldSubSize((Object)fnode.obj, (Field)fnode.fieldSet.get(0)), c));
                            mEnd.add(mi);
                        }
                    } else {
                        JMenuItem mi = new JMenuItem(AppStrings.translate("generictag.array.insertbeginning").replace("%item%", itemStr));
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), 0, null);
                            }
                        });
                        if (!canAdd) {
                            mi.setEnabled(false);
                        }
                        p.add(mi);
                        if (fnode.index > -1) {
                            mi = new JMenuItem(AppStrings.translate("generictag.array.insertbefore").replace("%item%", itemStr));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index, null);
                                }
                            });
                            if (!canAdd) {
                                mi.setEnabled(false);
                            }
                            p.add(mi);
                            mi = new JMenuItem(AppStrings.translate("generictag.array.remove").replace("%item%", itemStr));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    TreePath[] tps = GenericTagTreePanel.this.tree.getSelectionPaths();
                                    if (tps == null) {
                                        tps = new TreePath[]{selPath};
                                    }
                                    boolean someRemoved = false;
                                    for (int t = tps.length - 1; t >= 0; --t) {
                                        FieldNode fnode2;
                                        TreePath tp = tps[t];
                                        Object selObject = tp.getLastPathComponent();
                                        if (!(selObject instanceof FieldNode) || (fnode2 = (FieldNode)selObject).index <= -1) continue;
                                        GenericTagTreePanel.this.removeItem(fnode2.obj, fnode2.fieldSet.get(0), fnode2.index);
                                        someRemoved = true;
                                    }
                                    if (!someRemoved) {
                                        GenericTagTreePanel.this.removeItem(fnode.obj, fnode.fieldSet.get(0), fnode.index);
                                    }
                                }
                            });
                            if (!canAdd) {
                                mi.setEnabled(false);
                            }
                            p.add(mi);
                            mi = new JMenuItem(AppStrings.translate("generictag.array.insertafter").replace("%item%", itemStr));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index + 1, null);
                                }
                            });
                            if (!canAdd) {
                                mi.setEnabled(false);
                            }
                            p.add(mi);
                        }
                        mi = new JMenuItem(AppStrings.translate("generictag.array.insertend").replace("%item%", itemStr));
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), ReflectionTools.getFieldSubSize((Object)fnode.obj, (Field)fnode.fieldSet.get(0)), null);
                            }
                        });
                        if (!canAdd) {
                            mi.setEnabled(false);
                        }
                        p.add(mi);
                    }
                    p.show(GenericTagTreePanel.this.tree, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void clear() {
        this.tag = null;
        this.editedTag = null;
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("root")));
        this.tree.setSelectionModel(new DefaultTreeSelectionModel());
        this.revalidate();
        this.repaint();
    }

    private TreeModel getModel() {
        if (this.editedTag == null) {
            return new DefaultTreeModel(new DefaultMutableTreeNode("root"));
        }
        return new MyTreeModel(this.editedTag);
    }

    @Override
    public void setEditMode(boolean edit, Tag tag) {
        if (tag == null) {
            tag = this.tag;
        }
        this.tag = tag;
        try {
            this.editedTag = tag == null ? null : tag.cloneTag();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (!edit && this.tree.isEditing()) {
            this.tree.stopEditing();
        }
        this.tree.setEditable(edit);
        if (this.editedTag != null) {
            this.tree.setCellEditor(new MyTreeCellEditor(this.tree, this.editedTag.getSwf()));
        }
        this.refreshTree();
    }

    @Override
    public boolean save() {
        CharacterTag parentCharacter;
        if (this.tree.isEditing() && !this.tree.stopEditing()) {
            return false;
        }
        if (this.tag == null) {
            return true;
        }
        SWF swf = this.tag.getSwf();
        this.assignTag(this.tag, this.editedTag);
        this.tag.setModified(true);
        this.tag.setSwf(swf);
        if (this.tag instanceof Timelined) {
            ((Timelined)this.tag).resetTimeline();
        }
        if (this.tag instanceof CharacterIdTag && !(this.tag instanceof CharacterTag) && (parentCharacter = swf.getCharacter(((CharacterIdTag)this.tag).getCharacterId())) instanceof Timelined) {
            ((Timelined)parentCharacter).resetTimeline();
        }
        swf.computeDependentCharacters();
        swf.computeDependentFrames();
        return true;
    }

    private void assignTag(Tag t, Tag assigned) {
        if (t.getClass() != assigned.getClass()) {
            return;
        }
        for (Field f : GenericTagTreePanel.getAvailableFields(t.getClass())) {
            try {
                f.set(t, f.get(assigned));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    private static boolean hasEditor(Object obj, Field field, int index) {
        Class<?> type;
        boolean isByteArray = field.getType().equals(byte[].class);
        if (!isByteArray && ReflectionTools.needsIndex((Field)field) && index == -1) {
            return false;
        }
        try {
            Object val = ReflectionTools.getValue((Object)obj, (Field)field, (int)index);
            if (val == null) {
                return false;
            }
            type = val.getClass();
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return false;
        }
        UUID uuid = field.getAnnotation(UUID.class);
        if (uuid != null) {
            return true;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Long.TYPE) || type.equals(Long.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(Float.TYPE) || type.equals(Float.class)) {
            return true;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return true;
        }
        if (type.equals(String.class)) {
            return true;
        }
        if (type.equals(RGB.class) || type.equals(RGBA.class) || type.equals(ARGB.class)) {
            return true;
        }
        if (isByteArray || type.equals(ByteArrayRange.class)) {
            return true;
        }
        return type.equals(Amf3Value.class);
    }

    private static List<FieldSet> filterFields(SWF swf, MyTreeModel mod, String parentPath, Class<?> cls, boolean limited, int parentTagId) {
        ArrayList<FieldSet> ret = new ArrayList<FieldSet>();
        List<Field> fields = GenericTagTreePanel.getAvailableFields(cls);
        HashMap<String, ArrayList<Field>> tables = new HashMap<String, ArrayList<Field>>();
        for (Field f : fields) {
            Table t;
            Conditional cond;
            if (limited && (cond = f.getAnnotation(Conditional.class)) != null) {
                ConditionEvaluator ev = new ConditionEvaluator(cond);
                try {
                    HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
                    for (String sf : ev.getFields()) {
                        String fulldf = parentPath + "." + sf;
                        FieldNode condnode = (FieldNode)mod.getNodeByPath(fulldf);
                        if (condnode != null) {
                            Object value = ReflectionTools.getValue((Object)condnode.obj, (Field)condnode.fieldSet.get(0), (int)condnode.index);
                            if (value instanceof Boolean) {
                                fieldMap.put(sf, (Boolean)value);
                                continue;
                            }
                            if (!(value instanceof Integer)) continue;
                            int intValue = (Integer)value;
                            boolean found = false;
                            for (int i : cond.options()) {
                                if (i != intValue) continue;
                                found = true;
                            }
                            fieldMap.put(sf, found);
                            continue;
                        }
                        if ("strippedShapes".equals(sf)) {
                            fieldMap.put(sf, swf.hasStrippedShapesFromFonts());
                            continue;
                        }
                        fieldMap.put(sf, true);
                    }
                    if (!ev.eval(fieldMap, parentTagId)) {
                        continue;
                    }
                }
                catch (AnnotationParseException | IllegalAccessException | IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if ((t = f.getAnnotation(Table.class)) != null) {
                String tableName = t.value();
                if (!tables.containsKey(tableName)) {
                    ArrayList<Field> ret1 = new ArrayList<Field>();
                    tables.put(tableName, ret1);
                    ret.add(new FieldSet(ret1, tableName, t.itemName()));
                }
                ((List)tables.get(tableName)).add(f);
                continue;
            }
            ret.add(new FieldSet(f));
        }
        return ret;
    }

    private static List<Field> getAvailableFields(Class<?> cls) {
        List<Field> ret = fieldCache.get(cls);
        if (ret == null) {
            Field[] fields;
            ret = new ArrayList<Field>();
            for (Field f : fields = cls.getFields()) {
                HideInRawEdit hide;
                if (Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                Internal inter = f.getAnnotation(Internal.class);
                if (inter != null || (hide = f.getAnnotation(HideInRawEdit.class)) != null) continue;
                ret.add(f);
            }
            fieldCache.put(cls, ret);
        }
        return ret;
    }

    private void addItem(Object obj, Field field, int index, Class<?> cls) {
        SWFArray swfArray = field.getAnnotation(SWFArray.class);
        String countFieldName = null;
        if (swfArray != null && !swfArray.countField().isEmpty()) {
            countFieldName = swfArray.countField();
        }
        if (countFieldName != null) {
            Field[] fields = obj.getClass().getDeclaredFields();
            ArrayList<Integer> sameFlds = new ArrayList<Integer>();
            for (int f = 0; f < fields.length; ++f) {
                SWFArray fieldSwfArray = fields[f].getAnnotation(SWFArray.class);
                String fieldCountFieldName = null;
                if (fieldSwfArray != null && !fieldSwfArray.countField().isEmpty()) {
                    fieldCountFieldName = fieldSwfArray.countField();
                }
                if (fieldCountFieldName == null || !fieldCountFieldName.equals(countFieldName)) continue;
                sameFlds.add(f);
                if (cls != null || ReflectionTools.canAddToField((Object)obj, (Field)fields[f])) continue;
                JOptionPane.showMessageDialog(this, "This field is abstract, cannot be instantiated, sorry.");
                return;
            }
            Iterator f = sameFlds.iterator();
            while (f.hasNext()) {
                int f2 = (Integer)f.next();
                ReflectionTools.addToField((Object)obj, (Field)fields[f2], (int)index, (boolean)true, cls);
                try {
                    Object v = ReflectionTools.getValue((Object)obj, (Field)fields[f2], (int)index);
                    if (v instanceof ASMSource) {
                        ASMSource asv = (ASMSource)v;
                        asv.setSourceTag(this.editedTag);
                    }
                    if (!(v instanceof HasSwfAndTag)) continue;
                    ((HasSwfAndTag)obj).setSourceTag(this.editedTag);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
            }
            try {
                Field countField = obj.getClass().getDeclaredField(countFieldName);
                int cnt = countField.getInt(obj);
                countField.setInt(obj, ++cnt);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException countField) {}
        } else {
            if (cls == null && !ReflectionTools.canAddToField((Object)obj, (Field)field)) {
                JOptionPane.showMessageDialog(this, "This field is abstract, cannot be instantiated, sorry.");
                return;
            }
            ReflectionTools.addToField((Object)obj, (Field)field, (int)index, (boolean)true, cls);
            try {
                Object v = ReflectionTools.getValue((Object)obj, (Field)field, (int)index);
                if (v instanceof ASMSource) {
                    ASMSource asv = (ASMSource)v;
                    asv.setSourceTag(this.editedTag);
                }
                if (obj instanceof CLIPACTIONS && v instanceof CLIPACTIONRECORD) {
                    ((CLIPACTIONRECORD)v).setParentClipActions((CLIPACTIONS)obj);
                }
                if (v instanceof GRADRECORD) {
                    ShapeTag shape;
                    GRADRECORD grad = (GRADRECORD)v;
                    grad.color = this.editedTag instanceof ShapeTag ? ((shape = (ShapeTag)this.editedTag).getShapeNum() >= 3 ? new RGBA(Color.black) : new RGB(Color.black)) : new RGBA(Color.black);
                }
                if (obj instanceof HasSwfAndTag) {
                    ((HasSwfAndTag)obj).setSourceTag(this.editedTag);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        ((MyTreeModel)this.tree.getModel()).vchanged(new TreePath(this.tree.getModel().getRoot()));
        this.refreshTree();
    }

    public void refreshTree() {
        View.refreshTree(this.tree, this.getModel());
        for (TreeModelListener listener : this.modelListeners) {
            ((DefaultTreeModel)this.tree.getModel()).addTreeModelListener(listener);
        }
        this.revalidate();
        this.repaint();
    }

    private void removeItem(Object obj, Field field, int index) {
        SWFArray swfArray = field.getAnnotation(SWFArray.class);
        String countFieldName = null;
        if (swfArray != null && !swfArray.countField().isEmpty()) {
            countFieldName = swfArray.countField();
        }
        if (countFieldName != null) {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (int f = 0; f < fields.length; ++f) {
                SWFArray fieldSwfArray = fields[f].getAnnotation(SWFArray.class);
                String fieldCountFieldName = null;
                if (fieldSwfArray != null && !fieldSwfArray.countField().isEmpty()) {
                    fieldCountFieldName = fieldSwfArray.countField();
                }
                if (fieldCountFieldName == null || !fieldCountFieldName.equals(countFieldName)) continue;
                ReflectionTools.removeFromField((Object)obj, (Field)fields[f], (int)index);
            }
            try {
                Field countField = obj.getClass().getDeclaredField(countFieldName);
                int cnt = countField.getInt(obj);
                countField.setInt(obj, --cnt);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        } else {
            ReflectionTools.removeFromField((Object)obj, (Field)field, (int)index);
        }
        this.refreshTree();
    }

    private static class FieldSet {
        public List<Field> fields;
        public String name;
        public String itemName;

        public FieldSet(Field field) {
            this.fields = new ArrayList<Field>();
            this.fields.add(field);
            this.name = field.getName();
        }

        public FieldSet(List<Field> fields, String name, String itemName) {
            this.fields = fields;
            this.name = name;
            this.itemName = itemName;
        }

        public Field get(int index) {
            return this.fields.get(index);
        }

        public int size() {
            return this.fields.size();
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + Objects.hashCode(this.fields);
            hash = 67 * hash + Objects.hashCode(this.name);
            hash = 67 * hash + Objects.hashCode(this.itemName);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldSet other = (FieldSet)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!Objects.equals(this.itemName, other.itemName)) {
                return false;
            }
            return Objects.equals(this.fields, other.fields);
        }
    }

    public static class MyTreeModel
    extends DefaultTreeModel {
        private final Tag mtroot;
        private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
        private final Map<String, Object> nodeCache = new HashMap<String, Object>();
        private final Map<Object, String> nodeCacheReverse = new HashMap<Object, String>();

        private Object getNodeByPath(String path) {
            if (this.nodeCache.containsKey(path)) {
                return this.nodeCache.get(path);
            }
            return null;
        }

        public String getNodePathName(Object find) {
            if (this.nodeCacheReverse.containsKey(find)) {
                return this.nodeCacheReverse.get(find);
            }
            return null;
        }

        public List<FieldNode> getDependentFields(FieldNode fnode) {
            ArrayList<FieldNode> ret = new ArrayList<FieldNode>();
            this.getDependentFields(this.getNodePathName(fnode), this.mtroot.getClass().getSimpleName(), this.mtroot, ret);
            return ret;
        }

        public void getDependentFields(String dependence, String currentPath, Object node, List<FieldNode> ret) {
            FieldNode fnode;
            Conditional cond;
            if (node instanceof FieldNode && (cond = (fnode = (FieldNode)node).fieldSet.get(0).getAnnotation(Conditional.class)) != null) {
                ConditionEvaluator ev = new ConditionEvaluator(cond);
                String parentPath = currentPath.indexOf(46) == -1 ? "" : currentPath.substring(0, currentPath.lastIndexOf(46));
                try {
                    for (String cname : ev.getFields()) {
                        String fullPath = parentPath + "." + cname;
                        if (!fullPath.equals(dependence)) continue;
                        ret.add(fnode);
                        break;
                    }
                }
                catch (AnnotationParseException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                FieldNode f = (FieldNode)this.getChild(node, i);
                this.getDependentFields(dependence, currentPath + "." + f.getName(0), f, ret);
            }
        }

        public MyTreeModel(Tag root) {
            super(new DefaultMutableTreeNode(root));
            this.mtroot = root;
            this.buildCache(root, "");
        }

        private void buildCache(Object obj, String parentPath) {
            if (!"".equals(parentPath)) {
                parentPath = parentPath + ".";
            }
            if (obj instanceof FieldNode) {
                FieldNode fn = (FieldNode)obj;
                parentPath = parentPath + fn.getName(0);
            } else {
                parentPath = parentPath + obj.getClass().getSimpleName();
            }
            this.nodeCache.put(parentPath, obj);
            this.nodeCacheReverse.put(obj, parentPath);
            int count = this.getChildCount(obj, false);
            for (int i = 0; i < count; ++i) {
                this.buildCache(this.getChild(obj, i, false), parentPath);
            }
        }

        @Override
        public Object getRoot() {
            return this.mtroot;
        }

        private Object getChild(Object parent, int index, boolean limited) {
            if (parent == this.mtroot) {
                return new FieldNode(null, this, this.mtroot, this.mtroot, (FieldSet)GenericTagTreePanel.filterFields(this.mtroot.getSwf(), this, this.mtroot.getClass().getSimpleName(), this.mtroot.getClass(), limited, this.mtroot.getId()).get(index), -1, this.mtroot.getSwf());
            }
            FieldNode fnode = (FieldNode)parent;
            Field field = fnode.fieldSet.get(0);
            if (ReflectionTools.needsIndex((Field)field) && fnode.index == -1) {
                return new FieldNode(parent, this, this.mtroot, fnode.obj, fnode.fieldSet, index, this.mtroot.getSwf());
            }
            parent = fnode.getValue(0);
            return new FieldNode(parent, this, this.mtroot, parent, (FieldSet)GenericTagTreePanel.filterFields(this.mtroot.getSwf(), this, this.getNodePathName(fnode), parent.getClass(), limited, this.mtroot.getId()).get(index), -1, this.mtroot.getSwf());
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.getChild(parent, index, true);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.getChildCount(parent, true);
        }

        private int getChildCount(Object parent, boolean limited) {
            if (parent == this.mtroot) {
                return GenericTagTreePanel.filterFields(this.mtroot.getSwf(), this, this.mtroot.getClass().getSimpleName(), this.mtroot.getClass(), limited, this.mtroot.getId()).size();
            }
            FieldNode fnode = (FieldNode)parent;
            Field field = fnode.fieldSet.get(0);
            boolean isByteArray = field.getType().equals(byte[].class);
            if (GenericTagTreePanel.hasEditor(fnode.obj, field, fnode.index) || isByteArray) {
                return 0;
            }
            if (ReflectionTools.needsIndex((Field)field) && fnode.index == -1) {
                try {
                    if (field.get(fnode.obj) == null) {
                        return 0;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    return 0;
                }
                return ReflectionTools.getFieldSubSize((Object)fnode.obj, (Field)field);
            }
            parent = fnode.getValue(0);
            return GenericTagTreePanel.filterFields(this.mtroot.getSwf(), this, this.getNodePathName(fnode), parent.getClass(), limited, this.mtroot.getId()).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildCount(node) == 0;
        }

        public void vchanged(TreePath path) {
            this.fireTreeNodesChanged(this, path.getPath(), null, null);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int cnt = this.getChildCount(parent);
            for (int i = 0; i < cnt; ++i) {
                if (!this.getChild(parent, i).equals(child)) continue;
                return i;
            }
            return -1;
        }
    }

    public static final class FieldNode
    extends DefaultMutableTreeNode {
        private Tag tag;
        private Object obj;
        private FieldSet fieldSet;
        private int index;
        private MyTreeModel model;
        private Object parentObject;
        private final SWF swf;

        public Object getParentObject() {
            return this.parentObject;
        }

        public FieldNode(Object parent, MyTreeModel model, Tag tag, Object obj, FieldSet fieldSet, int index, SWF swf) {
            this.tag = tag;
            this.obj = obj;
            this.fieldSet = fieldSet;
            this.index = index;
            this.model = model;
            this.parentObject = parent;
            for (int i = 0; i < fieldSet.size(); ++i) {
                if (this.getValue(i) != null) continue;
                try {
                    if (List.class.isAssignableFrom(fieldSet.get(i).getType())) {
                        ReflectionTools.setValue((Object)obj, (Field)fieldSet.get(i), new ArrayList());
                        continue;
                    }
                    if (!fieldSet.get(i).getType().isArray()) continue;
                    ReflectionTools.setValue((Object)obj, (Field)fieldSet.get(i), (Object)Array.newInstance(fieldSet.get(i).getType().getComponentType(), 0));
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            this.swf = swf;
        }

        @Override
        public void setUserObject(Object userObject) {
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            if (this.index > -1) {
                for (int i = 0; i < this.fieldSet.size(); ++i) {
                    if (i > 0) {
                        ret.append(", ");
                    }
                    ret.append(this.toString(i));
                }
                ret.insert(0, "<html>").append("</html>");
                return ret.toString();
            }
            if (this.fieldSet.size() == 1) {
                ret.append(this.toString(0));
            } else {
                ret.append(this.fieldSet.name);
            }
            ret.insert(0, "<html>").append("</html>");
            return ret.toString();
        }

        public String toString(int fieldIndex) {
            String valStr = "";
            Field field = this.fieldSet.get(fieldIndex);
            if (field.getAnnotation(UUID.class) != null) {
                StringBuilder sb = new StringBuilder();
                byte[] val = (byte[])this.getValue(fieldIndex);
                for (int i = 0; i < val.length; ++i) {
                    String h = Integer.toHexString(val[i] & 0xFF);
                    if (h.length() == 1) {
                        h = "0" + h;
                    }
                    sb.append(h);
                    if (i != 3 && i != 5 && i != 7 && i != 9) continue;
                    sb.append("-");
                }
                valStr = valStr + " = " + sb.toString();
            } else if (ReflectionTools.needsIndex((Field)field) && this.index == -1) {
                valStr = valStr + "";
            } else if (GenericTagTreePanel.hasEditor(this.obj, field, this.index)) {
                Object val = this.getValue(fieldIndex);
                Color color = null;
                String colorAdd = "";
                if (val instanceof RGB) {
                    color = ((RGB)val).toColor();
                }
                if (val instanceof ARGB) {
                    color = ((ARGB)val).toColor();
                }
                if (color != null) {
                    colorAdd = "<cite style=\"color:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");\">\u25cf</cite> ";
                }
                EnumValues enumValues = field.getAnnotation(EnumValues.class);
                String enumAdd = "";
                if (enumValues != null && val instanceof Integer) {
                    HashMap<Integer, String> values = new HashMap<Integer, String>();
                    for (EnumValue enumValue : enumValues.value()) {
                        values.put(enumValue.value(), enumValue.text());
                    }
                    enumAdd = " - " + (String)values.get(val);
                }
                DottedIdentifier di = field.getAnnotation(DottedIdentifier.class);
                valStr = val instanceof String && di != null ? (di.exportName() ? valStr + " = " + this.escapeHtml(Helper.escapeExportname((SWF)this.swf, (String)val.toString(), (boolean)true)) : valStr + " = " + this.escapeHtml("\"" + Helper.escapePCodeString((String)val.toString()) + "\"")) : (val instanceof byte[] ? valStr + " = " + ((byte[])val).length + " byte" : (val instanceof ByteArrayRange ? valStr + " = " + ((ByteArrayRange)val).getLength() + " byte" : (val instanceof String ? valStr + " = \"" + this.escapeHtml(Helper.escapePCodeString((String)val.toString())) + "\"" : valStr + " = " + colorAdd + this.escapeHtml(val.toString()) + enumAdd)));
            }
            return this.getNameType(fieldIndex) + valStr;
        }

        private String escapeHtml(String val) {
            return val.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        }

        public String getType(int fieldIndex) {
            String typeStr;
            UUID uuid = this.fieldSet.get(fieldIndex).getAnnotation(UUID.class);
            if (uuid != null) {
                return "UUID";
            }
            SWFArray swfArray = this.fieldSet.get(fieldIndex).getAnnotation(SWFArray.class);
            Class<?> declaredType = this.fieldSet.get(fieldIndex).getType();
            boolean isArray = ReflectionTools.needsIndex((Field)this.fieldSet.get(fieldIndex)) || swfArray != null;
            boolean isArrayParent = isArray && this.index == -1;
            SWFType swfType = this.fieldSet.get(fieldIndex).getAnnotation(SWFType.class);
            String thisPath = this.model.getNodePathName(this);
            String parentPath = thisPath.substring(0, thisPath.lastIndexOf("."));
            if (isArray && !isArrayParent) {
                parentPath = parentPath.substring(0, parentPath.lastIndexOf("."));
            }
            swfType = GenericTagTreePanel.evalSwfType(this.model, parentPath, swfType);
            Class<?> declaredSubType = isArray ? ReflectionTools.getFieldSubType((Object)this.obj, (Field)this.fieldSet.get(fieldIndex)) : null;
            Class<?> type = declaredType;
            if (declaredSubType != null) {
                type = declaredSubType;
            }
            if (isArray && !isArrayParent) {
                try {
                    Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex), (int)this.index);
                    if (val != null) {
                        type = val.getClass();
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException val) {
                    // empty catch block
                }
            }
            if ("RGB".equals(typeStr = type.getSimpleName())) {
                try {
                    Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex), (int)this.index);
                    if (val instanceof RGBA) {
                        typeStr = "RGBA";
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException val) {
                    // empty catch block
                }
            }
            boolean bracketsDetected = false;
            if (swfType != null) {
                if (swfType.value() != BasicType.OTHER) {
                    typeStr = "" + swfType.value();
                }
                if (swfType.count() > 0) {
                    typeStr = typeStr + "[" + swfType.count();
                    if (swfType.countAdd() > 0) {
                        typeStr = typeStr + " + " + swfType.countAdd();
                    }
                    typeStr = typeStr + "]";
                    bracketsDetected = true;
                } else if (!swfType.countField().isEmpty()) {
                    typeStr = typeStr + "[" + swfType.countField();
                    if (swfType.countAdd() > 0) {
                        typeStr = typeStr + " + " + swfType.countAdd();
                    }
                    typeStr = typeStr + "]";
                    bracketsDetected = true;
                }
            }
            String arrayBrackets = "";
            if (isArrayParent && !bracketsDetected) {
                arrayBrackets = swfArray != null ? (swfArray.count() > 0 ? "[" + swfArray.count() + "]" : (!swfArray.countField().isEmpty() ? "[" + swfArray.countField() + "]" : "[]")) : "[]";
            }
            typeStr = typeStr + arrayBrackets;
            return typeStr;
        }

        public String getNameType(int fieldIndex) {
            String typeStr = this.getType(fieldIndex);
            return this.getName(fieldIndex) + (typeStr != null ? " : " + typeStr : "");
        }

        public String getName(int fieldIndex) {
            SWFArray swfArray = this.fieldSet.get(fieldIndex).getAnnotation(SWFArray.class);
            boolean isArray = ReflectionTools.needsIndex((Field)this.fieldSet.get(fieldIndex)) || swfArray != null;
            boolean isArrayParent = isArray && this.index == -1;
            String name = "";
            if (!isArray || isArrayParent) {
                name = this.fieldSet.get(fieldIndex).getName();
            } else if (swfArray != null && !isArrayParent) {
                name = swfArray.value();
            }
            if (!isArrayParent && isArray) {
                name = name + "[" + this.index + "]";
            }
            return name;
        }

        public Object getValue(int fieldIndex) {
            try {
                if (ReflectionTools.needsIndex((Field)this.fieldSet.get(fieldIndex)) && this.index == -1) {
                    return ReflectionTools.getValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex));
                }
                Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex), (int)this.index);
                if (val == null) {
                    try {
                        Class type = this.fieldSet.get(fieldIndex).getType();
                        ConditionalType cond = this.fieldSet.get(fieldIndex).getAnnotation(ConditionalType.class);
                        if (cond != null) {
                            boolean condEnabled = false;
                            int[] tags = cond.tags();
                            if (tags != null && tags.length > 0) {
                                int tagId = this.tag.getId();
                                for (int i = 0; i < tags.length; ++i) {
                                    if (tags[i] != tagId) continue;
                                    condEnabled = true;
                                    break;
                                }
                            }
                            if (condEnabled) {
                                type = cond.type();
                            }
                        }
                        val = ReflectionTools.newInstanceOf(type);
                        ReflectionTools.setValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex), (int)this.index, (Object)val);
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        return null;
                    }
                }
                return val;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                return null;
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + System.identityHashCode(this.obj);
            hash = 11 * hash + Objects.hashCode(this.fieldSet.get(0));
            hash = 11 * hash + this.index;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldNode other = (FieldNode)obj;
            if (this.obj != other.obj) {
                return false;
            }
            if (!Objects.equals(this.fieldSet.get(0), other.fieldSet.get(0))) {
                return false;
            }
            return this.index == other.index;
        }
    }

    private static final class TableFieldNodes
    extends DefaultMutableTreeNode {
        List<FieldNode> subnodes;

        public TableFieldNodes(List<FieldNode> subnodes) {
            this.subnodes = subnodes;
        }
    }

    public class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public MyTreeCellRenderer() {
            if (View.isOceanic()) {
                this.setUI(new BasicLabelUI());
                this.setOpaque(false);
                this.setBackgroundNonSelectionColor(Color.white);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component component = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (component instanceof JLabel) {
                JLabel lab = (JLabel)component;
                if (value == tree.getModel().getRoot() && GenericTagTreePanel.this.editedTag != null) {
                    lab.setIcon(AbstractTagTree.getIconForType(AbstractTagTree.getTreeNodeType((TreeItem)GenericTagTreePanel.this.editedTag)));
                }
            }
            return component;
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private List<GenericTagEditor> editors = null;
        private final JTree tree;
        private FieldNode fnode;
        private final SWF swf;

        public MyTreeCellEditor(JTree tree, SWF swf) {
            this.tree = tree;
            this.swf = swf;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Rectangle cellRect = tree.getPathBounds(tree.getPathForRow(row));
            Rectangle treeVisibleRect = tree.getVisibleRect();
            int scrollBarSize = (Integer)UIManager.get("ScrollBar.width");
            Rectangle cellMaxVisibleRect = new Rectangle(cellRect.x, cellRect.y, treeVisibleRect.width - cellRect.x - tree.getInsets().left - tree.getInsets().right - scrollBarSize, cellRect.height);
            if (value instanceof FieldNode) {
                this.fnode = (FieldNode)value;
                JPanel panSum = new JPanel(new FlowLayout(0, 0, 0));
                panSum.setOpaque(false);
                for (int i = 0; i < this.fnode.fieldSet.size(); ++i) {
                    Class<byte[]> type;
                    Field field = this.fnode.fieldSet.get(i);
                    int index = this.fnode.index;
                    Object obj = this.fnode.obj;
                    boolean isByteArray = field.getType().equals(byte[].class);
                    try {
                        type = isByteArray ? byte[].class : ReflectionTools.getValue((Object)obj, (Field)field, (int)index).getClass();
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        logger.log(Level.SEVERE, "Fixing characters order failed, recursion detected.");
                        return null;
                    }
                    JComponent editor = null;
                    SWFType swfType = field.getAnnotation(SWFType.class);
                    MyTreeModel model = (MyTreeModel)tree.getModel();
                    SWFArray swfArray = field.getAnnotation(SWFArray.class);
                    boolean isArray = ReflectionTools.needsIndex((Field)field) || swfArray != null;
                    boolean isArrayParent = isArray && index == -1;
                    String thisPath = model.getNodePathName(value);
                    String parentPath = thisPath.substring(0, thisPath.lastIndexOf("."));
                    if (isArray && !isArrayParent) {
                        parentPath = parentPath.substring(0, parentPath.lastIndexOf("."));
                    }
                    swfType = GenericTagTreePanel.evalSwfType(model, parentPath, swfType);
                    UUID uuid = field.getAnnotation(UUID.class);
                    Multiline multiline = field.getAnnotation(Multiline.class);
                    EnumValues enumValues = field.getAnnotation(EnumValues.class);
                    if (uuid != null) {
                        editor = new UUIDEditor(field.getName(), obj, field, index, type);
                    } else if (enumValues != null && (type.equals(Integer.TYPE) || type.equals(Integer.class))) {
                        HashMap<Integer, String> values = new HashMap<Integer, String>();
                        for (EnumValue enumValue : enumValues.value()) {
                            values.put(enumValue.value(), enumValue.text());
                        }
                        editor = new EnumEditor(field.getName(), obj, field, index, type, swfType, values);
                    } else if (type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(Float.TYPE) || type.equals(Float.class)) {
                        editor = new FloatEditor(field.getName(), obj, field, index, type, swfType);
                    } else if (type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Long.TYPE) || type.equals(Long.class)) {
                        editor = new NumberEditor(field.getName(), obj, field, index, type, swfType);
                    } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                        editor = new BooleanEditor(field.getName(), obj, field, index, type);
                    } else if (type.equals(String.class)) {
                        editor = new StringEditor(field.getName(), obj, field, index, type, multiline != null, this.swf);
                    } else if (type.equals(RGB.class) || type.equals(RGBA.class) || type.equals(ARGB.class)) {
                        editor = new ColorEditor(field.getName(), obj, field, index, type);
                    } else if (type.equals(byte[].class) || type.equals(ByteArrayRange.class)) {
                        editor = new BinaryDataEditor(GenericTagTreePanel.this.mainPanel, field.getName(), obj, field, index, type);
                    } else if (type.equals(Amf3Value.class)) {
                        editor = new Amf3ValueEditor(field.getName(), obj, field, index, type);
                    }
                    if (editor != null) {
                        if (this.editors == null) {
                            this.editors = new ArrayList<GenericTagEditor>();
                        }
                        this.editors.add((GenericTagEditor)((Object)editor));
                    }
                    JPanel pan = new JPanel();
                    FlowLayout fl = new FlowLayout(0, 0, 0);
                    fl.setAlignOnBaseline(true);
                    pan.setLayout(fl);
                    JLabel nameLabel = new JLabel(this.fnode.getNameType(i) + (editor == null ? "" : " = ")){

                        @Override
                        public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
                            return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                        }

                        @Override
                        public int getBaseline(int width, int height) {
                            return 0;
                        }
                    };
                    pan.setOpaque(false);
                    nameLabel.setAlignmentY(0.0f);
                    pan.add(nameLabel);
                    JComponent editorComponent = editor;
                    if (editorComponent != null) {
                        nameLabel.setSize(nameLabel.getWidth(), editorComponent.getHeight());
                        editorComponent.setAlignmentY(0.0f);
                        pan.add(editorComponent);
                        if (editorComponent instanceof FullSized) {
                            editorComponent.setPreferredSize(new Dimension(cellMaxVisibleRect.width - (int)nameLabel.getPreferredSize().getWidth() - 5, editorComponent.getPreferredSize().height));
                        }
                        if (editorComponent instanceof GenericTagEditor) {
                            ((GenericTagEditor)((Object)editorComponent)).added();
                        }
                        pan.setPreferredSize(new Dimension((int)nameLabel.getPreferredSize().getWidth() + 5 + (int)editorComponent.getPreferredSize().getWidth(), (int)editorComponent.getPreferredSize().getHeight()));
                    } else {
                        pan.setPreferredSize(new Dimension((int)nameLabel.getPreferredSize().getWidth(), (int)nameLabel.getPreferredSize().getHeight()));
                    }
                    panSum.add(pan);
                }
                panSum.setPreferredSize(new Dimension(cellMaxVisibleRect.width, panSum.getPreferredSize().height));
                return panSum;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (this.editors != null) {
                for (GenericTagEditor editor : this.editors) {
                    ret.add(editor.getChangedValue());
                }
            }
            return ret;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (!(e instanceof MouseEvent)) {
                return false;
            }
            MouseEvent me = (MouseEvent)e;
            TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
            if (path == null) {
                return false;
            }
            Object obj = path.getLastPathComponent();
            FieldNode fnode = (FieldNode)obj;
            Field field = fnode.fieldSet.get(0);
            boolean ret = super.isCellEditable(e) && this.tree.getModel().isLeaf(obj) && GenericTagTreePanel.hasEditor(fnode.obj, field, fnode.index);
            return ret;
        }

        @Override
        public boolean stopCellEditing() {
            boolean modified = false;
            if (this.editors != null) {
                for (GenericTagEditor editor : this.editors) {
                    try {
                        String fname;
                        editor.validateValue();
                        if (!editor.save()) continue;
                        if (editor.getObject() instanceof CONVOLUTIONFILTER && ("matrixX".equals(fname = editor.getFieldName()) || "matrixY".equals(fname))) {
                            CONVOLUTIONFILTER cf = (CONVOLUTIONFILTER)editor.getObject();
                            if (cf.matrix.length != cf.matrixX * cf.matrixY) {
                                float[] newmatrix = new float[cf.matrixX * cf.matrixY];
                                int copycount = cf.matrix.length;
                                if (copycount > cf.matrixX * cf.matrixY) {
                                    copycount = cf.matrixX * cf.matrixY;
                                }
                                System.arraycopy(cf.matrix, 0, newmatrix, 0, copycount);
                                cf.matrix = newmatrix;
                            }
                        }
                        modified = true;
                    }
                    catch (IllegalArgumentException iex) {
                        return false;
                    }
                }
            }
            super.stopCellEditing();
            this.editors = null;
            if (modified) {
                TreePath sp = this.tree.getSelectionPath();
                if (sp != null) {
                    ((MyTreeModel)this.tree.getModel()).vchanged(sp);
                }
                GenericTagTreePanel.this.refreshTree();
            }
            return true;
        }
    }

    private class MyTree
    extends JTree {
        public MyTree() {
            if (View.isOceanic()) {
                this.setBackground(Color.white);
            }
            this.setUI(new BasicTreeUI(){

                @Override
                public void paint(Graphics g, JComponent c) {
                    this.setHashColor(Color.gray);
                    super.paint(g, c);
                }
            });
            this.setCellRenderer(new MyTreeCellRenderer());
            this.setInvokesStopCellEditing(true);
        }
    }
}

