/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.Stage;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItemChangeListener;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.configuration.enums.GridSnapAccuracy;
import com.jpexs.decompiler.flash.configuration.enums.GuidesSnapAccuracy;
import com.jpexs.decompiler.flash.ecma.EcmaNumberToString;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.BoundsChangeListener;
import com.jpexs.decompiler.flash.gui.DefaultTagNameResolver;
import com.jpexs.decompiler.flash.gui.DisplayPoint;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.PointUpdateListener;
import com.jpexs.decompiler.flash.gui.RegistrationPointPosition;
import com.jpexs.decompiler.flash.gui.SoundTagPlayer;
import com.jpexs.decompiler.flash.gui.TagNameResolverInterface;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.Zoom;
import com.jpexs.decompiler.flash.math.BezierUtils;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DefineEditTextTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DisplayObjectCacheKey;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.StaticTextTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.ConstantColorColorTransform;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.filters.BlendComposite;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.Reference;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.Stopwatch;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;

public final class ImagePanel
extends JPanel
implements MediaDisplay {
    private static final int MAX_SOUND_CHANNELS = 8;
    private static final Logger logger = Logger.getLogger(ImagePanel.class.getName());
    private final List<MediaDisplayListener> listeners = new ArrayList<MediaDisplayListener>();
    private final List<Runnable> textChangedListeners = new ArrayList<Runnable>();
    private Timelined timelined;
    private boolean stillFrame = false;
    private volatile Timer timer;
    private int frame = -1;
    private int prevFrame = -1;
    private boolean loop;
    private LocalDataArea lda;
    private boolean zoomAvailable = false;
    private SWF swf;
    private boolean loaded;
    private int mouseButton;
    private static final String DEFAULT_DEBUG_LABEL_TEXT = " - ";
    private final JLabel debugLabel = new JLabel(" - ");
    private JPanel pointEditPanel;
    private JTextField pointXTextField;
    private JTextField pointYTextField;
    private Point cursorPosition = null;
    private MouseEvent lastMouseEvent = null;
    private final List<SoundTagPlayer> soundPlayers = new ArrayList<SoundTagPlayer>();
    private final Cache<DisplayObjectCacheKey, SerializableImage> displayObjectCache = Cache.getInstance((boolean)false, (boolean)false, (String)"displayObject", (boolean)true);
    private final IconPanel iconPanel;
    private int time = 0;
    private boolean doFreeTransform = false;
    private Zoom zoom = new Zoom();
    private final Object delayObject = new Object();
    private boolean drawReady;
    private final int drawWaitLimit = 50;
    private TextTag textTag;
    private TextTag newTextTag;
    private boolean showObjectsUnderCursor;
    private int msPerFrame;
    private final boolean lowQuality = false;
    private Object lock = new Object();
    private Point2D registrationPoint = null;
    private Point2D registrationPointUpdated = null;
    private int mode = 0;
    private Rectangle2D bounds;
    private Matrix transform;
    private AffineTransform transformUpdated;
    private final double LQ_FACTOR = 2.0;
    private static final int TOLERANCE_SCALESHEAR = 8;
    private static final int TOLERANCE_ROTATE = 30;
    private static final int REGISTRATION_TOLERANCE = 8;
    private static final double CENTER_POINT_SIZE = 8.0;
    private static final double HANDLES_WIDTH = 5.0;
    private static final int HANDLES_STROKE_WIDTH = 2;
    private static final int MODE_ROTATE_NE = -1;
    private static final int MODE_ROTATE_SE = -2;
    private static final int MODE_ROTATE_NW = -3;
    private static final int MODE_ROTATE_SW = -4;
    private static final int MODE_SHEAR_S = -5;
    private static final int MODE_SHEAR_E = -6;
    private static final int MODE_SHEAR_N = -7;
    private static final int MODE_SHEAR_W = -8;
    private static final int MODE_GUIDE_X = -9;
    private static final int MODE_GUIDE_Y = -10;
    private static Cursor moveCursor;
    private static Cursor moveRegPointCursor;
    private static Cursor resizeNWSECursor;
    private static Cursor resizeSWNECursor;
    private static Cursor resizeXCursor;
    private static Cursor resizeYCursor;
    private static Cursor rotateCursor;
    private static Cursor selectCursor;
    private static Cursor shearXCursor;
    private static Cursor shearYCursor;
    private static Cursor movePointCursor;
    private static Cursor defaultCursor;
    private static Cursor addPointCursor;
    private static Cursor guideXCursor;
    private static Cursor guideYCursor;
    private static Cursor textCursor;
    private Point2D offsetPoint = new Point2D.Double(0.0, 0.0);
    private ExportRectangle _viewRect = new ExportRectangle(0.0, 0.0, 1.0, 1.0);
    private boolean playing = false;
    private boolean autoPlayed = false;
    private boolean frozen = false;
    private boolean frozenButtons = false;
    private boolean muted = false;
    private boolean mutable = false;
    private boolean alwaysDisplay = false;
    private boolean allowSelectAllTextTypes = false;
    private RegistrationPointPosition registrationPointPosition = RegistrationPointPosition.CENTER;
    private DepthState depthStateUnderCursor = null;
    private List<ActionListener> placeObjectSelectedListeners = new ArrayList<ActionListener>();
    private Point[] hilightedEdge = null;
    private List<DisplayPoint> hilightedPoints = null;
    private DisplayPoint touchPointOffset = null;
    private static final int TOUCH_POINT_DISTANCE = 15;
    private Point2D snapOffset = new Point2D.Double(0.0, 0.0);
    private DisplayPoint snapAlignXPoint1 = null;
    private DisplayPoint snapAlignXPoint2 = null;
    private DisplayPoint snapAlignYPoint1 = null;
    private DisplayPoint snapAlignYPoint2 = null;
    private static final int SNAP_ALIGN_DISTANCE = 5;
    private static final int SNAP_TO_OBJECTS_DISTANCE = 10;
    private static final int SNAP_ALIGN_AFTER_LINE = 50;
    private List<Integer> pointsUnderCursor = new ArrayList<Integer>();
    private List<Integer> selectedPoints = new ArrayList<Integer>();
    private List<DistanceItem> pathPointsUnderCursor = new ArrayList<DistanceItem>();
    private DisplayPoint closestPoint = null;
    private List<DisplayPoint> selectedPointsOriginalValues = new ArrayList<DisplayPoint>();
    private int hilightEdgeColorStep = 10;
    private int hilightEdgeColor = 0;
    private static final DecimalFormat DECIMAL_FORMAT;
    private JScrollBar horizontalScrollBar;
    private JScrollBar verticalScrollBar;
    private boolean updatingScrollBars = false;
    private final int SCROLL_SPACE_BEFORE = 10000;
    private List<Point> showPoints1 = new ArrayList<Point>();
    private List<Point> showPoints2 = new ArrayList<Point>();
    private int displayedFrame = 0;
    private JPanel topPanel;
    private TagNameResolverInterface tagNameResolver = new DefaultTagNameResolver();
    private boolean showAllDepthLevelsInfo = true;
    private boolean selectionMode = false;
    private boolean transformSelectionMode = false;
    private boolean multiSelect = false;
    private boolean inMoving = false;
    private List<Integer> selectedDepths = new ArrayList<Integer>();
    private final List<Integer> parentFrames = new ArrayList<Integer>();
    private final List<Integer> parentDepths = new ArrayList<Integer>();
    private final List<Timelined> parentTimelineds = new ArrayList<Timelined>();
    private JPanel topRuler;
    private JPanel leftRuler;
    private boolean draggingGuideY = false;
    private boolean draggingGuideX = false;
    private int guideDragX = -1;
    private int guideDragY = -1;
    private boolean contentCanHaveRuler = false;
    private List<Double> guidesX = new ArrayList<Double>();
    private List<Double> guidesY = new ArrayList<Double>();
    private static final int GUIDE_THICKNESS = 20;
    private static final int GUIDE_FONT_HEIGHT = 11;
    private static final int GUIDE_TEXT_OFFSET = 10;
    private static final int GUIDE_MOVE_TOLERANCE = 2;
    private SWF guidesSwf = null;
    private int guidesCharacterId = -1;
    private Rectangle2D textSelectionStartGlyphRect = null;
    private Double textSelectionStartGlyphXPosition = null;
    private Double textSelectionStartPrecise = null;
    private Double textSelectionEndPrecise = null;
    private TextTag lastMouseOverText = null;
    private TextTag textSelectionText = null;
    private boolean selectingText = false;
    private boolean textCursorBlinkOn = false;
    private boolean editTexts = false;
    private Timer textCursorBlinkTimer;
    private SerializableImage imgPlay = null;
    private List<BoundsChangeListener> boundsChangeListeners = new ArrayList<BoundsChangeListener>();
    private List<PointUpdateListener> pointUpdateListeners = new ArrayList<PointUpdateListener>();
    private List<Runnable> transformChangeListeners = new ArrayList<Runnable>();
    private Timer setTimelinedTimer = null;
    private long startRun = 0L;
    private final long startDrop = 0L;
    private int skippedFrames = 0;
    private float fpsShouldBe = 0.0f;
    private float fpsIs = 0.0f;
    private Timer fpsTimer;
    private int startFrame = 0;
    private static final int ZOOM_DECADE_STEPS = 10;
    private static final double ZOOM_MULTIPLIER;
    private final double MAX_ZOOM = 1000000.0;

    private void setTextSelection(int value) {
        int selStart = this.getSelectionStartInt();
        int delta = value - selStart;
        this.changeTextSelection(delta);
    }

    private void changeTextSelection(int delta) {
        TextTag text = this.textSelectionText;
        if (text == null) {
            return;
        }
        int selStart = this.getSelectionStartInt();
        List textRecords = new ArrayList();
        if (text instanceof StaticTextTag) {
            textRecords = ((StaticTextTag)text).textRecords;
        }
        if (text instanceof DefineEditTextTag) {
            textRecords = ((DefineEditTextTag)text).getTextRecords(text.getSwf());
        }
        List glyphPositions = TextTag.getGlyphEntriesPositions(textRecords, (SWF)text.getSwf());
        if ((selStart += delta) < 0) {
            selStart = 0;
        }
        if (selStart > glyphPositions.size()) {
            selStart = glyphPositions.size();
        }
        if (glyphPositions.size() == 0) {
            this.textSelectionStartPrecise = selStart;
            this.textSelectionEndPrecise = selStart;
            return;
        }
        RECT gp = (RECT)glyphPositions.get(selStart == glyphPositions.size() ? selStart - 1 : selStart);
        Rectangle2D.Double r = new Rectangle2D.Double(gp.Xmin, gp.Ymin, gp.Xmax - gp.Xmin, gp.Ymax - gp.Ymin);
        this.textSelectionStartGlyphRect = r;
        this.textSelectionStartGlyphXPosition = ((RectangularShape)r).getX();
        if (selStart == glyphPositions.size()) {
            this.textSelectionStartGlyphXPosition = r.getMaxX();
        }
        this.textSelectionStartPrecise = selStart;
        this.textSelectionEndPrecise = selStart;
    }

    private static int getSnapGuidesDistance() {
        return ((GuidesSnapAccuracy)Configuration.guidesSnapAccuracy.get()).getDistance();
    }

    private static int getSnapGridDistance() {
        return ((GridSnapAccuracy)Configuration.gridSnapAccuracy.get()).getDistance();
    }

    @Override
    public boolean canHaveRuler() {
        return this.contentCanHaveRuler;
    }

    @Override
    public boolean canUseSnapping() {
        return this.selectionMode || this.doFreeTransform || this.hilightedPoints != null;
    }

    public void setFrozenButtons(boolean frozenButtons) {
        this.frozenButtons = frozenButtons;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setSelectionMode(boolean selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setTransformSelectionMode(boolean transformSelectionMode) {
        this.transformSelectionMode = transformSelectionMode;
    }

    public void setTagNameResolver(TagNameResolverInterface tagNameResolver) {
        this.tagNameResolver = tagNameResolver;
    }

    public void setShowAllDepthLevelsInfo(boolean showAllDepthLevelsInfo) {
        this.showAllDepthLevelsInfo = showAllDepthLevelsInfo;
    }

    public void setTopPanelVisible(boolean visible) {
        this.topPanel.setVisible(visible);
        this.updateRulerVisibility();
    }

    public void setShowPoints(List<Point> showPoints1, List<Point> showPoints2) {
        this.showPoints1 = showPoints1;
        this.showPoints2 = showPoints2;
    }

    private static String formatDouble(double value) {
        return DECIMAL_FORMAT.format(value);
    }

    private static double parseDouble(String value) {
        try {
            return DECIMAL_FORMAT.parse(value).doubleValue();
        }
        catch (ParseException ex) {
            throw new NumberFormatException();
        }
    }

    private static Cursor loadCursor(String name, int x, int y) throws IOException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        BufferedImage image = ImageIO.read(MainPanel.class.getResource("/com/jpexs/decompiler/flash/gui/graphics/cursors/" + name + ".png"));
        return toolkit.createCustomCursor(image, new Point(x, y), name);
    }

    public void addTransformChangeListener(Runnable listener) {
        this.transformChangeListeners.add(listener);
    }

    public void removeTransformChangeListener(Runnable listener) {
        this.transformChangeListeners.remove(listener);
    }

    public void addPointUpdateListener(PointUpdateListener listener) {
        this.pointUpdateListeners.add(listener);
    }

    public void removePointUpdateListener(PointUpdateListener listener) {
        this.pointUpdateListeners.remove(listener);
    }

    private void firePointsUpdated(List<DisplayPoint> points) {
        for (PointUpdateListener listener : this.pointUpdateListeners) {
            listener.pointsUpdated(points);
        }
    }

    private void fireTransformChanged() {
        for (Runnable listener : this.transformChangeListeners) {
            listener.run();
        }
    }

    private void fireStatusChanged(String status) {
        for (MediaDisplayListener listener : this.listeners) {
            listener.statusChanged(status);
        }
    }

    private boolean fireEdgeSplit(int position, double splitPoint) {
        boolean result = true;
        for (PointUpdateListener listener : this.pointUpdateListeners) {
            result = result && listener.edgeSplit(position, splitPoint);
        }
        return result;
    }

    private boolean firePointRemoved(int position) {
        boolean result = true;
        for (PointUpdateListener listener : this.pointUpdateListeners) {
            result = result && listener.pointRemoved(position);
        }
        return result;
    }

    private void applyPointsXY() {
        try {
            int x = (int)Math.round(ImagePanel.parseDouble(this.pointXTextField.getText()) * 20.0);
            int y = (int)Math.round(ImagePanel.parseDouble(this.pointYTextField.getText()) * 20.0);
            Point minSelectedPoint = this.getMinSelectedPoint();
            if (minSelectedPoint == null) {
                return;
            }
            for (int index : this.selectedPoints) {
                DisplayPoint point = this.hilightedPoints.get(index);
                point.x = point.x - minSelectedPoint.x + x;
                point.y = point.y - minSelectedPoint.y + y;
            }
            this.firePointsUpdated(this.hilightedPoints);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private Point getMinSelectedPoint() {
        if (this.selectedPoints.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (int index : this.selectedPoints) {
            DisplayPoint point = this.hilightedPoints.get(index);
            if (point.x < minX) {
                minX = point.x;
            }
            if (point.y >= minY) continue;
            minY = point.y;
        }
        return new Point(minX, minY);
    }

    private void calculatePointsXY() {
        Point minPoint = this.getMinSelectedPoint();
        if (minPoint == null) {
            this.pointXTextField.setText("");
            this.pointYTextField.setText("");
            return;
        }
        this.pointXTextField.setText(ImagePanel.formatDouble(((Point2D)minPoint).getX() / 20.0));
        this.pointYTextField.setText(ImagePanel.formatDouble(((Point2D)minPoint).getY() / 20.0));
    }

    public void setHilightedPoints(List<DisplayPoint> hilightedPoints) {
        this.hilightedEdge = null;
        this.selectedPoints = new ArrayList<Integer>();
        this.calculatePointsXY();
        this.hilightedPoints = hilightedPoints;
        this.pointEditPanel.setVisible(hilightedPoints != null);
        this.redraw();
    }

    public void setHilightedEdge(Point[] hilightedEdge) {
        this.hilightedEdge = hilightedEdge;
        this.hilightedPoints = null;
        this.hilightEdgeColor = 255;
        this.pointEditPanel.setVisible(false);
        this.redraw();
    }

    public void setStatus(String status) {
        this.fireStatusChanged(status);
    }

    public void setNoStatus() {
        this.fireStatusChanged("");
    }

    public void addBoundsChangeListener(BoundsChangeListener listener) {
        this.boundsChangeListeners.add(listener);
    }

    public void addPlaceObjectSelectedListener(ActionListener listener) {
        this.placeObjectSelectedListeners.add(listener);
    }

    public void removePlaceObjectSelectedListener(ActionListener listener) {
        this.placeObjectSelectedListeners.remove(listener);
    }

    private void firePlaceObjectSelected() {
        ActionEvent e = new ActionEvent(this, 0, "");
        for (ActionListener listener : this.placeObjectSelectedListeners) {
            listener.actionPerformed(e);
        }
    }

    public PlaceObjectTypeTag getPlaceTagUnderCursor() {
        if (this.depthStateUnderCursor == null) {
            return null;
        }
        return this.depthStateUnderCursor.placeObjectTag;
    }

    public void removeBoundsChangeListener(BoundsChangeListener listener) {
        this.boundsChangeListeners.remove(listener);
    }

    private void fireBoundsChange(Rectangle2D bounds, Point2D registrationPoint, RegistrationPointPosition registrationPointPosition) {
        for (BoundsChangeListener listener : this.boundsChangeListeners) {
            listener.boundsChanged(bounds, registrationPoint, registrationPointPosition);
        }
    }

    private SerializableImage getImagePlay() {
        Color fgColor;
        if (this.imgPlay != null) {
            return this.imgPlay;
        }
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            SubstanceSkin skin = SubstanceLookAndFeel.getCurrentSkin();
            Color bgColor = skin.getColorScheme(DecorationAreaType.HEADER, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getBackgroundFillColor();
        } else {
            SystemColor bgColor = SystemColor.control;
        }
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            SubstanceSkin skin = SubstanceLookAndFeel.getCurrentSkin();
            fgColor = skin.getColorScheme(DecorationAreaType.HEADER, ColorSchemeAssociationKind.FILL, ComponentState.ENABLED).getForegroundColor();
        } else {
            fgColor = SystemColor.controlText;
        }
        int size = 200;
        this.imgPlay = new SerializableImage(size, size, 3);
        this.imgPlay.fillTransparent();
        Graphics2D g2d = (Graphics2D)this.imgPlay.getGraphics();
        g2d.setStroke(new BasicStroke(4.0f, 1, 1));
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(size, size / 2);
        path.lineTo(0.0f, size);
        path.closePath();
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setPaint(new Color(fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue(), fgColor.getAlpha() / 2));
        g2d.fill(path);
        g2d.setPaint(fgColor);
        g2d.draw(path);
        return this.imgPlay;
    }

    private Matrix getNewToImageMatrix(Matrix newMatrix) {
        double zoomDouble;
        Matrix m = new Matrix();
        double zoom = zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        m.translate(-this._viewRect.xMin * zoom, -this._viewRect.yMin * zoom);
        m.scale(zoom);
        return Matrix.getScaleInstance((double)0.05).concatenate(m).concatenate(newMatrix);
    }

    public Matrix getNewMatrix() {
        if (this.transform == null) {
            return new Matrix();
        }
        return this.transform;
    }

    public Matrix getOriginalMatrix() {
        if (this.selectedDepths.size() == 1 && this.timelined != null) {
            int depth = this.selectedDepths.get(0);
            Frame fr = this.timelined.getTimeline().getFrame(this.frame);
            if (fr != null && fr.layers.containsKey(depth)) {
                return new Matrix(((DepthState)fr.layers.get((Object)Integer.valueOf((int)depth))).matrix);
            }
        }
        return new Matrix();
    }

    public synchronized void selectDepth(int depth) {
        ArrayList<Integer> depths = new ArrayList<Integer>();
        if (depth != -1) {
            depths.add(depth);
        }
        this.selectDepths(depths);
    }

    public synchronized void selectDepths(List<Integer> depths) {
        depths = new ArrayList<Integer>(depths);
        if (this.timelined == null) {
            depths = new ArrayList<Integer>();
        } else {
            Frame fr = this.timelined.getTimeline().getFrame(this.frame);
            for (int i = 0; i < depths.size(); ++i) {
                int depth = depths.get(i);
                if (fr != null && fr.layers.containsKey(depth)) continue;
                depths.remove(i);
                --i;
            }
        }
        this.transformUpdated = null;
        this.registrationPointUpdated = null;
        this.transform = null;
        this.selectedDepths = new ArrayList<Integer>(depths);
        this.doFreeTransform = false;
        if (this.selectionMode) {
            this.calculateFreeOrSelectionTransform();
        }
        this.hideMouseSelection();
        this.redraw();
    }

    public List<Integer> getSelectedDepths() {
        return new ArrayList<Integer>(this.selectedDepths);
    }

    private void calculateFreeOrSelectionTransform() {
        if (!this.doFreeTransform && !this.selectionMode) {
            return;
        }
        if (this.selectedDepths.isEmpty()) {
            return;
        }
        DepthState ds = null;
        Timeline timeline = this.timelined.getTimeline();
        if (timeline.getFrameCount() <= this.frame) {
            return;
        }
        if (this.selectedDepths.size() == 1) {
            ds = (DepthState)timeline.getFrame((int)this.frame).layers.get(this.selectedDepths.get(0));
        }
        this._viewRect = this.getViewRect();
        this.transform = new Matrix();
        Rectangle2D transformBounds = this.getTransformBounds();
        this.registrationPointPosition = RegistrationPointPosition.CENTER;
        this.fireBoundsChange(transformBounds, new Point2D.Double(transformBounds.getCenterX(), transformBounds.getCenterY()), this.registrationPointPosition);
    }

    public synchronized void freeTransformDepth(int depth) {
        ArrayList<Integer> depths = new ArrayList<Integer>();
        if (depth != -1) {
            depths.add(depth);
        }
        this.freeTransformDepths(depths);
    }

    public synchronized void freeTransformDepths(List<Integer> depths) {
        this.selectedDepths = new ArrayList<Integer>(depths);
        this.doFreeTransform = !depths.isEmpty();
        this.hilightedEdge = null;
        this.hilightedPoints = null;
        this.pointEditPanel.setVisible(false);
        this.registrationPoint = null;
        this.calculateFreeOrSelectionTransform();
        this.hideMouseSelection();
        this.redraw();
        this.iconPanel.requestFocusInWindow();
    }

    private void centerImage() {
        Timelined tim = this.timelined;
        if (tim == null) {
            return;
        }
        RECT rect = tim.getRect();
        double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        double w = (double)rect.getWidth() / 20.0 * zoomDouble;
        double h = (double)rect.getHeight() / 20.0 * zoomDouble;
        double dw = (double)rect.Xmin * zoomDouble / 20.0;
        double dh = (double)rect.Ymin * zoomDouble / 20.0;
        this.offsetPoint.setLocation((double)(this.iconPanel.getWidth() / 2) - w / 2.0 - dw, (double)(this.iconPanel.getHeight() / 2) - h / 2.0 - dh);
    }

    public void fireMediaDisplayStateChanged() {
        ArrayList<MediaDisplayListener> ls = new ArrayList<MediaDisplayListener>(this.listeners);
        for (MediaDisplayListener l : ls) {
            l.mediaDisplayStateChanged(this);
        }
    }

    @Override
    public void addEventListener(MediaDisplayListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(MediaDisplayListener listener) {
        this.listeners.remove(listener);
    }

    public void addTextChangedListener(Runnable listener) {
        this.textChangedListeners.add(listener);
    }

    public void removeTextChangedListener(Runnable listener) {
        this.textChangedListeners.remove(listener);
    }

    private void fireTextChanged() {
        for (Runnable r : this.textChangedListeners) {
            r.run();
        }
    }

    @Override
    public Color getBackgroundColor() {
        if (this.swf != null && this.swf.getBackgroundColor() != null) {
            return this.swf.getBackgroundColor().backgroundColor.toColor();
        }
        return Color.white;
    }

    @Override
    public void setDisplayed(boolean value) {
        this.autoPlayed = value;
        Configuration.autoPlayPreviews.set((Object)value);
    }

    @Override
    public void setFrozen(boolean value) {
        this.frozen = value;
    }

    @Override
    public boolean isDisplayed() {
        return this.autoPlayed;
    }

    @Override
    public boolean alwaysDisplay() {
        return this.alwaysDisplay;
    }

    @Override
    public void setMuted(boolean value) {
        this.muted = value;
        if (value) {
            this.stopAllSounds();
        } else {
            this.prevFrame = -1;
        }
    }

    private static void drawGridSwf(Graphics2D g, Rectangle realRect, double zoom) {
        Point2D.Double p2;
        Point2D.Double p1;
        g.setColor((Color)Configuration.gridColor.get());
        int minIx = 0;
        int minIy = 0;
        int ix = 0;
        while ((double)realRect.x + (double)(ix * (Integer)Configuration.gridHorizontalSpace.get()) * zoom < realRect.getMaxX()) {
            ++ix;
        }
        int maxIx = ix - 1;
        int iy = 0;
        while ((double)realRect.y + (double)(iy * (Integer)Configuration.gridVerticalSpace.get()) * zoom < realRect.getMaxY()) {
            ++iy;
        }
        int maxIy = iy - 1;
        for (ix = minIx; ix <= maxIx; ++ix) {
            double x = (double)realRect.x + (double)(ix * (Integer)Configuration.gridHorizontalSpace.get()) * zoom;
            p1 = new Point2D.Double(x, realRect.getMinY());
            p2 = new Point2D.Double(x, realRect.getMaxY());
            g.drawLine((int)Math.round(((Point2D)p1).getX()), (int)Math.round(((Point2D)p1).getY()), (int)Math.round(((Point2D)p2).getX()), (int)Math.round(((Point2D)p2).getY()));
        }
        for (iy = minIy; iy <= maxIy; ++iy) {
            double y = (double)realRect.y + (double)(iy * (Integer)Configuration.gridVerticalSpace.get()) * zoom;
            p1 = new Point2D.Double(realRect.getMinX(), y);
            p2 = new Point2D.Double(realRect.getMaxX(), y);
            g.drawLine((int)Math.round(((Point2D)p1).getX()), (int)Math.round(((Point2D)p1).getY()), (int)Math.round(((Point2D)p2).getX()), (int)Math.round(((Point2D)p2).getY()));
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.iconPanel != null) {
            this.iconPanel.setBackground(bg);
        }
        super.setBackground(bg);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.iconPanel.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.iconPanel.removeMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.iconPanel.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.iconPanel.removeMouseMotionListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePos(Timelined timelined, MouseEvent lastMouseEvent, Timer thisTimer) {
        if (timelined != null) {
            Timelined bounded = timelined;
            RECT rect = bounded.getRect();
            if (rect == null) {
                return;
            }
            int width = rect.getWidth();
            double scale = 1.0;
            Matrix m = Matrix.getTranslateInstance((double)(-rect.Xmin), (double)(-rect.Ymin));
            m.scale(scale);
            Point p = lastMouseEvent == null ? null : lastMouseEvent.getPoint();
            ImagePanel imagePanel = this;
            synchronized (imagePanel) {
                if (this.timer == thisTimer) {
                    this.cursorPosition = p;
                }
            }
        }
    }

    private void showSelectedName() {
        if (!this.selectedDepths.isEmpty() && this.frame > -1 && this.timelined != null) {
            Frame f = this.timelined.getTimeline().getFrame(this.frame);
            if (f == null) {
                return;
            }
            if (this.selectedDepths.size() == 1) {
                CharacterTag cht;
                DepthState ds = (DepthState)f.layers.get(this.selectedDepths.get(0));
                if (ds != null && (cht = ds.getCharacter()) != null) {
                    this.debugLabel.setText(cht.getName());
                }
            } else {
                this.debugLabel.setText("" + this.selectedDepths.size() + "x");
            }
        }
    }

    public void hideMouseSelection() {
        if (!this.selectedDepths.isEmpty()) {
            this.showSelectedName();
        } else {
            this.debugLabel.setText(DEFAULT_DEBUG_LABEL_TEXT);
        }
    }

    private Integer getRulerFullLinePixels(double z) {
        if (z < 0.0375) {
            return null;
        }
        int fullLinePixels = 2000;
        if (z >= 0.075) {
            fullLinePixels = 1000;
        }
        if (z >= 0.15) {
            fullLinePixels = 500;
        }
        if (z >= 0.31) {
            fullLinePixels = 100;
        }
        if (z >= 0.6) {
            fullLinePixels = 50;
        }
        if (z >= 1.5) {
            fullLinePixels = 20;
        }
        if (z >= 2.99) {
            fullLinePixels = 10;
        }
        if (z >= 5.95) {
            fullLinePixels = 5;
        }
        if (z >= 14.64) {
            fullLinePixels = 2;
        }
        return fullLinePixels;
    }

    public ImagePanel() {
        super(new BorderLayout());
        JPanel p = new JPanel();
        this.add((Component)p, "Center");
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            private MouseEvent convertMouseEvent(MouseEvent originalEvent, Component newSourceComponent) {
                Point newPoint = SwingUtilities.convertPoint(originalEvent.getComponent(), originalEvent.getPoint(), newSourceComponent);
                return new MouseEvent(newSourceComponent, originalEvent.getID(), originalEvent.getWhen(), originalEvent.getModifiersEx(), newPoint.x, newPoint.y, originalEvent.getClickCount(), originalEvent.isPopupTrigger(), originalEvent.getButton());
            }

            private MouseWheelEvent convertMouseWheelEvent(MouseWheelEvent originalEvent, Component newSourceComponent) {
                Point newPoint = SwingUtilities.convertPoint(originalEvent.getComponent(), originalEvent.getPoint(), newSourceComponent);
                return new MouseWheelEvent(newSourceComponent, originalEvent.getID(), originalEvent.getWhen(), originalEvent.getModifiersEx(), newPoint.x, newPoint.y, originalEvent.getClickCount(), originalEvent.isPopupTrigger(), originalEvent.getScrollType(), originalEvent.getScrollAmount(), originalEvent.getWheelRotation());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c != ImagePanel.this.iconPanel) {
                    return;
                }
                for (MouseListener l : ImagePanel.this.iconPanel.mouseListeners) {
                    l.mouseClicked(this.convertMouseEvent(e, ImagePanel.this.iconPanel));
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c == ImagePanel.this.topRuler) {
                    if (ImagePanel.this.topRuler.getCursor() != guideYCursor) {
                        ImagePanel.this.topRuler.setCursor(guideYCursor);
                    }
                } else if (c == ImagePanel.this.leftRuler && ImagePanel.this.leftRuler.getCursor() != guideXCursor) {
                    ImagePanel.this.leftRuler.setCursor(guideXCursor);
                }
                if (c != ImagePanel.this.iconPanel) {
                    return;
                }
                for (MouseMotionListener l : ImagePanel.this.iconPanel.mouseMotionListeners) {
                    l.mouseDragged(this.convertMouseEvent(e, ImagePanel.this.iconPanel));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c != ImagePanel.this.iconPanel) {
                    return;
                }
                for (MouseListener l : ImagePanel.this.iconPanel.mouseListeners) {
                    l.mouseEntered(this.convertMouseEvent(e, ImagePanel.this.iconPanel));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c != ImagePanel.this.iconPanel) {
                    return;
                }
                for (MouseListener l : ImagePanel.this.iconPanel.mouseListeners) {
                    l.mouseExited(this.convertMouseEvent(e, ImagePanel.this.iconPanel));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c != ImagePanel.this.iconPanel) {
                    return;
                }
                for (MouseMotionListener l : ImagePanel.this.iconPanel.mouseMotionListeners) {
                    l.mouseMoved(this.convertMouseEvent(e, ImagePanel.this.iconPanel));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c == ImagePanel.this.topRuler) {
                    ImagePanel.this.draggingGuideY = true;
                    ImagePanel.this.guideDragY = -1;
                    ImagePanel.this.topRuler.setCursor(guideYCursor);
                    ImagePanel.this.mode = -10;
                    ImagePanel.this.iconPanel.setCursor(guideYCursor);
                } else if (c == ImagePanel.this.leftRuler) {
                    ImagePanel.this.draggingGuideX = true;
                    ImagePanel.this.guideDragX = -1;
                    ImagePanel.this.leftRuler.setCursor(guideXCursor);
                    ImagePanel.this.mode = -9;
                    ImagePanel.this.iconPanel.setCursor(guideXCursor);
                } else if (c == ImagePanel.this.iconPanel) {
                    for (MouseListener l : ImagePanel.this.iconPanel.mouseListeners) {
                        l.mousePressed(this.convertMouseEvent(e, ImagePanel.this.iconPanel));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c == ImagePanel.this.iconPanel) {
                    double guide;
                    if (ImagePanel.this.draggingGuideX && ImagePanel.this.guideDragX > 0) {
                        guide = ((double)ImagePanel.this.guideDragX - ImagePanel.this.offsetPoint.getX()) / ImagePanel.this.getRealZoom();
                        ImagePanel.this.guidesX.add(guide);
                        ImagePanel.this.saveGuides();
                    }
                    if (ImagePanel.this.draggingGuideY && ImagePanel.this.guideDragY > 0) {
                        guide = ((double)ImagePanel.this.guideDragY - ImagePanel.this.offsetPoint.getY()) / ImagePanel.this.getRealZoom();
                        ImagePanel.this.guidesY.add(guide);
                        ImagePanel.this.saveGuides();
                    }
                }
                ImagePanel.this.draggingGuideX = false;
                ImagePanel.this.draggingGuideY = false;
                ImagePanel.this.guideDragX = -1;
                ImagePanel.this.guideDragY = -1;
                ImagePanel.this.topRuler.setCursor(Cursor.getPredefinedCursor(0));
                ImagePanel.this.leftRuler.setCursor(Cursor.getPredefinedCursor(0));
                if (c != ImagePanel.this.iconPanel) {
                    return;
                }
                for (MouseListener l : ImagePanel.this.iconPanel.mouseListeners) {
                    l.mouseReleased(this.convertMouseEvent(e, ImagePanel.this.iconPanel));
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Component c = SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY());
                if (c != ImagePanel.this.iconPanel) {
                    return;
                }
                for (MouseWheelListener l : ImagePanel.this.iconPanel.mouseWheelListeners) {
                    l.mouseWheelMoved(this.convertMouseWheelEvent(e, ImagePanel.this.iconPanel));
                }
            }
        };
        super.addMouseListener(mouseInputAdapter);
        super.addMouseMotionListener(mouseInputAdapter);
        super.addMouseWheelListener(mouseInputAdapter);
        this.setOpaque(true);
        this.setBackground(View.getDefaultBackgroundColor());
        this.loop = true;
        this.iconPanel = new IconPanel();
        this.add((Component)this.iconPanel, "Center");
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.debugLabel.setAlignmentX(0.0f);
        this.topPanel.add(this.debugLabel);
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImagePanel.this.applyPointsXY();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImagePanel.this.applyPointsXY();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ImagePanel.this.applyPointsXY();
            }
        };
        this.pointEditPanel = new JPanel(new FlowLayout(0));
        this.pointEditPanel.add(new JLabel(AppStrings.translate("edit.points.x")));
        this.pointXTextField = new JTextField(6);
        this.pointXTextField.getDocument().addDocumentListener(documentListener);
        this.pointEditPanel.add(this.pointXTextField);
        this.pointEditPanel.add(new JLabel(AppStrings.translate("edit.points.y")));
        this.pointYTextField = new JTextField(6);
        this.pointYTextField.getDocument().addDocumentListener(documentListener);
        this.pointEditPanel.add(this.pointYTextField);
        this.pointEditPanel.setAlignmentX(0.0f);
        this.topPanel.add(this.pointEditPanel);
        this.topRuler = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                double z = ImagePanel.this.getRealZoom();
                Integer fullLinePixels = ImagePanel.this.getRulerFullLinePixels(z);
                if (fullLinePixels == null) {
                    return;
                }
                double fullLineDistance = (double)fullLinePixels.intValue() * z;
                double leftOffset = 20.0;
                Graphics2D g2 = (Graphics2D)g;
                g2.setFont(new Font("Monospaced", 0, 11));
                GeneralPath gp = new GeneralPath();
                for (double minX = leftOffset + ImagePanel.this.offsetPoint.getX(); minX >= 0.0; minX -= fullLineDistance) {
                }
                for (double x = minX; x < (double)this.getWidth(); x += fullLineDistance) {
                    gp.moveTo(x, 0.0);
                    gp.lineTo(x, (double)this.getHeight());
                    int px = (int)Math.round((x - leftOffset - ImagePanel.this.offsetPoint.getX()) / z);
                    int smallLineLength = 4;
                    int smallerLineLength = 2;
                    int k = 0;
                    double i = 0.0;
                    while (i < fullLineDistance) {
                        gp.moveTo(x + i, 20.0);
                        gp.lineTo(x + i, (double)(20 - (k % 2 == 0 ? smallLineLength : smallerLineLength)));
                        i += fullLineDistance / 10.0;
                        ++k;
                    }
                    g2.drawString("" + px, (int)x + 5, 10);
                }
                g2.setStroke(new BasicStroke(1.0f, 2, 2));
                g2.draw(gp);
                if (ImagePanel.this.guideDragX == -1 && ImagePanel.this.lastMouseEvent != null) {
                    int triangleX = ImagePanel.this.lastMouseEvent.getX() + 20;
                    int triangleHalfWidth = 3;
                    int triangleHeight = 3;
                    int triangleYOffset = 3;
                    Polygon triangle = new Polygon(new int[]{triangleX - triangleHalfWidth, triangleX + triangleHalfWidth, triangleX}, new int[]{20 - triangleHeight - triangleYOffset, 20 - triangleHeight - triangleYOffset, 20 - triangleYOffset}, 3);
                    g2.setPaint(this.getForeground());
                    g2.fill(triangle);
                }
                g2.setPaint(this.getBackground());
                g2.fillRect(0, 0, 20, 20);
                if (ImagePanel.this.guideDragX > -1) {
                    g2.setColor((Color)Configuration.guidesColor.get());
                    g2.drawLine(20 + ImagePanel.this.guideDragX, 0, 20 + ImagePanel.this.guideDragX, 20);
                }
                if (!ImagePanel.this.selectedDepths.isEmpty() && ImagePanel.this.transform != null) {
                    Rectangle2D transformBounds = ImagePanel.this.transformUpdated == null ? ImagePanel.this.getTransformBounds() : ImagePanel.this.getTransformBounds(new Matrix(ImagePanel.this.transformUpdated));
                    g2.setColor(this.getForeground());
                    Rectangle2D imgBounds = ImagePanel.this.toImageRect(transformBounds);
                    g2.drawLine((int)Math.round(leftOffset + imgBounds.getMinX()), 0, (int)Math.round(leftOffset + imgBounds.getMinX()), this.getHeight());
                    g2.drawLine((int)Math.round(leftOffset + imgBounds.getMaxX()), 0, (int)Math.round(leftOffset + imgBounds.getMaxX()), this.getHeight());
                }
            }
        };
        this.topRuler.setPreferredSize(new Dimension(1, 20));
        this.topPanel.add(this.topRuler);
        this.leftRuler = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                double z = ImagePanel.this.getRealZoom();
                Integer fullLinePixels = ImagePanel.this.getRulerFullLinePixels(z);
                if (fullLinePixels == null) {
                    return;
                }
                double fullLineDistance = (double)fullLinePixels.intValue() * z;
                double topOffset = 0.0;
                Graphics2D g2 = (Graphics2D)g;
                g2.setFont(new Font("Monospaced", 0, 11));
                GeneralPath gp = new GeneralPath();
                for (double minY = topOffset + ImagePanel.this.offsetPoint.getY(); minY >= 0.0; minY -= fullLineDistance) {
                }
                AffineTransform origTransform = g2.getTransform();
                for (double y = minY; y < (double)this.getHeight(); y += fullLineDistance) {
                    gp.moveTo(0.0, y);
                    gp.lineTo((double)this.getWidth(), y);
                    int py = (int)Math.round((y - topOffset - ImagePanel.this.offsetPoint.getY()) / z);
                    int smallLineLength = 4;
                    int smallerLineLength = 2;
                    int k = 0;
                    double i = 0.0;
                    while (i < fullLineDistance) {
                        gp.moveTo(20.0, y + i);
                        gp.lineTo((double)(20 - (k % 2 == 0 ? smallLineLength : smallerLineLength)), y + i);
                        i += fullLineDistance / 10.0;
                        ++k;
                    }
                    g2.setTransform(origTransform);
                    String drawnString = "" + py;
                    int stringWidth = g2.getFontMetrics().stringWidth(drawnString);
                    AffineTransform fontTrans = new AffineTransform();
                    fontTrans.rotate(-1.5707963267948966, 10.0, 10.0);
                    g2.transform(fontTrans);
                    g2.drawString(drawnString, (float)((long)(20 - stringWidth) - Math.round(y) - 5L), 10.0f);
                }
                g2.setTransform(origTransform);
                if (ImagePanel.this.guideDragY == -1 && ImagePanel.this.lastMouseEvent != null) {
                    int triangleY = ImagePanel.this.lastMouseEvent.getY();
                    int triangleHalfHeight = 3;
                    int triangleWidth = 3;
                    int triangleXOffset = 3;
                    Polygon triangle = new Polygon(new int[]{20 - triangleWidth - triangleXOffset, 20 - triangleWidth - triangleXOffset, 20 - triangleXOffset}, new int[]{triangleY - triangleHalfHeight, triangleY + triangleHalfHeight, triangleY}, 3);
                    g2.setPaint(this.getForeground());
                    g2.fill(triangle);
                }
                g2.setStroke(new BasicStroke(1.0f, 2, 2));
                g2.draw(gp);
                if (ImagePanel.this.guideDragY > -1) {
                    g2.setColor((Color)Configuration.guidesColor.get());
                    g2.drawLine(0, ImagePanel.this.guideDragY, 20, ImagePanel.this.guideDragY);
                }
                if (!ImagePanel.this.selectedDepths.isEmpty() && ImagePanel.this.transform != null) {
                    Rectangle2D transformBounds = ImagePanel.this.transformUpdated == null ? ImagePanel.this.getTransformBounds() : ImagePanel.this.getTransformBounds(new Matrix(ImagePanel.this.transformUpdated));
                    g2.setColor(this.getForeground());
                    Rectangle2D imgBounds = ImagePanel.this.toImageRect(transformBounds);
                    g2.drawLine(0, (int)Math.round(imgBounds.getMinY()), this.getWidth(), (int)Math.round(imgBounds.getMinY()));
                    g2.drawLine(0, (int)Math.round(imgBounds.getMaxY()), this.getWidth(), (int)Math.round(imgBounds.getMaxY()));
                }
            }
        };
        this.leftRuler.setPreferredSize(new Dimension(20, 1));
        this.add((Component)this.leftRuler, "West");
        super.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!ImagePanel.this.draggingGuideX && !ImagePanel.this.draggingGuideY) {
                        return;
                    }
                    if (ImagePanel.this.iconPanel == SwingUtilities.getDeepestComponentAt(ImagePanel.this, e.getX(), e.getY())) {
                        Point p = SwingUtilities.convertPoint(ImagePanel.this, e.getX(), e.getY(), ImagePanel.this.iconPanel);
                        if (ImagePanel.this.draggingGuideX) {
                            ImagePanel.this.guideDragX = p.x;
                        }
                        if (ImagePanel.this.draggingGuideY) {
                            ImagePanel.this.guideDragY = p.y;
                        }
                        ImagePanel.this.iconPanel.repaint();
                    }
                }
            }
        });
        this.pointEditPanel.setVisible(false);
        this.add((Component)this.topPanel, "North");
        this.leftRuler.setVisible(false);
        this.topRuler.setVisible(false);
        Configuration.showRuler.addListener((ConfigurationItemChangeListener)new ConfigurationItemChangeListener<Boolean>(){

            public void configurationItemChanged(Boolean newValue) {
                ImagePanel.this.updateRulerVisibility();
            }
        });
        this.horizontalScrollBar = new JScrollBar(0);
        this.verticalScrollBar = new JScrollBar(1);
        this.horizontalScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ImagePanel.this.updatingScrollBars) {
                    return;
                }
                ImagePanel.this.updatingScrollBars = true;
                double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                ImagePanel.this.updateScrollBarMinMax();
                ImagePanel.this.offsetPoint.setLocation((double)(-ImagePanel.this.horizontalScrollBar.getValue()) * zoomDouble / 20.0, ImagePanel.this.offsetPoint.getY());
                ImagePanel.this.iconPanel.calcRect();
                ImagePanel.this._viewRect = ImagePanel.this.getViewRect();
                ImagePanel.this.updatingScrollBars = false;
                ImagePanel.this.redraw();
            }
        });
        this.verticalScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (ImagePanel.this.updatingScrollBars) {
                    return;
                }
                ImagePanel.this.updatingScrollBars = true;
                double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                ImagePanel.this.updateScrollBarMinMax();
                ImagePanel.this.offsetPoint.setLocation(ImagePanel.this.offsetPoint.getX(), (double)(-ImagePanel.this.verticalScrollBar.getValue()) * zoomDouble / 20.0);
                ImagePanel.this.iconPanel.calcRect();
                ImagePanel.this._viewRect = ImagePanel.this.getViewRect();
                ImagePanel.this.redraw();
                ImagePanel.this.updatingScrollBars = false;
            }
        });
        this.add((Component)this.horizontalScrollBar, "South");
        this.add((Component)this.verticalScrollBar, "East");
        this.iconPanel.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseEntered(MouseEvent e) {
                ImagePanel imagePanel = ImagePanel.this;
                synchronized (imagePanel) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseExited(MouseEvent e) {
                ImagePanel imagePanel = ImagePanel.this;
                synchronized (imagePanel) {
                    ImagePanel.this.lastMouseEvent = null;
                    ImagePanel.this.hideMouseSelection();
                    ImagePanel.this.redraw();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent e) {
                ImagePanel imagePanel = ImagePanel.this;
                synchronized (imagePanel) {
                    ImagePanel.this.mouseButton = e.getButton();
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    TextTag text = ImagePanel.this.iconPanel.mouseOverText;
                    if (text == null || !ImagePanel.this.allowSelectAllTextTypes && (!(text instanceof DefineEditTextTag) || ((DefineEditTextTag)text).noSelect)) {
                        text = null;
                    }
                    if (text != null && !ImagePanel.this.doFreeTransform && !ImagePanel.this.selectionMode) {
                        Rectangle2D glyphRect = ImagePanel.this.iconPanel.glyphUnderCursorRect;
                        if (ImagePanel.this.iconPanel.glyphPosUnderCursor > -1 && glyphRect != null) {
                            if (ImagePanel.this.mouseButton == 1) {
                                ImagePanel.this.textSelectionText = text;
                                ImagePanel.this.textSelectionStartPrecise = (double)ImagePanel.this.iconPanel.glyphPosUnderCursor + (glyphRect.getWidth() == 0.0 ? 0.0 : (ImagePanel.this.iconPanel.glyphUnderCursorXPosition - glyphRect.getX()) / glyphRect.getWidth());
                                ImagePanel.this.textSelectionEndPrecise = null;
                                ImagePanel.this.selectingText = true;
                                ImagePanel.this.textSelectionStartGlyphRect = ImagePanel.this.iconPanel.glyphUnderCursorRect;
                                ImagePanel.this.textSelectionStartGlyphXPosition = ImagePanel.this.iconPanel.glyphUnderCursorXPosition;
                            }
                        } else {
                            ImagePanel.this.textSelectionStartPrecise = null;
                        }
                    } else {
                        ImagePanel.this.textSelectionStartPrecise = null;
                    }
                    ButtonTag button = ImagePanel.this.iconPanel.mouseOverButton;
                    if (button != null && !ImagePanel.this.doFreeTransform && !ImagePanel.this.frozenButtons) {
                        CharacterTag soundCharTag;
                        DefineButtonSoundTag sounds = button.getSounds();
                        if (!ImagePanel.this.muted && sounds != null && sounds.buttonSoundChar2 != 0 && (soundCharTag = ImagePanel.this.swf.getCharacter(sounds.buttonSoundChar2)) instanceof SoundTag) {
                            ImagePanel.this.playSound((SoundTag)soundCharTag, sounds.buttonSoundInfo2, ImagePanel.this.timer);
                        }
                        ArrayList<ByteArrayRange> actions = new ArrayList<ByteArrayRange>();
                        if (button instanceof DefineButton2Tag) {
                            DefineButton2Tag button2 = (DefineButton2Tag)button;
                            for (BUTTONCONDACTION ca : button2.actions) {
                                if (!ca.condOverUpToOverDown) continue;
                                actions.add(ca.actionBytes);
                            }
                        }
                        if (button instanceof DefineButtonTag) {
                            DefineButtonTag button1 = (DefineButtonTag)button;
                            actions.add(button1.actionBytes);
                        }
                        for (ByteArrayRange actionBytes : actions) {
                            try {
                                int prevLength = actionBytes.getPos();
                                SWFInputStream rri = new SWFInputStream(ImagePanel.this.swf, actionBytes.getArray(), 0L, prevLength + actionBytes.getLength());
                                if (prevLength != 0) {
                                    rri.seek((long)prevLength);
                                }
                                ImagePanel.this.execute(rri);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                ImagePanel imagePanel = ImagePanel.this;
                synchronized (imagePanel) {
                    CharacterTag soundCharTag;
                    DefineButtonSoundTag sounds;
                    ImagePanel.this.mouseButton = 0;
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    TextTag text = ImagePanel.this.iconPanel.mouseOverText;
                    if (text == null || !ImagePanel.this.allowSelectAllTextTypes && (!(text instanceof DefineEditTextTag) || ((DefineEditTextTag)text).noSelect)) {
                        text = null;
                    }
                    if (ImagePanel.this.selectingText && ImagePanel.this.textSelectionStartPrecise != null && text != null && !ImagePanel.this.doFreeTransform && SwingUtilities.isLeftMouseButton(e)) {
                        Rectangle2D glyphRect = ImagePanel.this.iconPanel.glyphUnderCursorRect;
                        if (ImagePanel.this.iconPanel.glyphPosUnderCursor > -1 && glyphRect != null) {
                            ImagePanel.this.textSelectionEndPrecise = (double)ImagePanel.this.iconPanel.glyphPosUnderCursor + (glyphRect.getWidth() == 0.0 ? 0.0 : (ImagePanel.this.iconPanel.glyphUnderCursorXPosition - glyphRect.getX()) / glyphRect.getWidth());
                        }
                    }
                    ButtonTag button = ImagePanel.this.iconPanel.mouseOverButton;
                    if (!ImagePanel.this.muted && button != null && !ImagePanel.this.doFreeTransform && !ImagePanel.this.frozenButtons && (sounds = button.getSounds()) != null && sounds.buttonSoundChar3 != 0 && (soundCharTag = ImagePanel.this.swf.getCharacter(sounds.buttonSoundChar3)) instanceof SoundTag) {
                        ImagePanel.this.playSound((SoundTag)soundCharTag, sounds.buttonSoundInfo3, ImagePanel.this.timer);
                    }
                    ImagePanel.this.selectingText = false;
                }
            }
        });
        this.iconPanel.addMouseMotionListener(new MouseMotionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseMoved(MouseEvent e) {
                ImagePanel imagePanel = ImagePanel.this;
                synchronized (imagePanel) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent e) {
                ImagePanel imagePanel = ImagePanel.this;
                synchronized (imagePanel) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    TextTag text = ImagePanel.this.iconPanel.mouseOverText;
                    if (text == null || !ImagePanel.this.allowSelectAllTextTypes && (!(text instanceof DefineEditTextTag) || ((DefineEditTextTag)text).noSelect)) {
                        text = null;
                    }
                    if (ImagePanel.this.selectingText && ImagePanel.this.textSelectionStartPrecise != null && text != null && !ImagePanel.this.doFreeTransform && SwingUtilities.isLeftMouseButton(e)) {
                        Rectangle2D glyphRect = ImagePanel.this.iconPanel.glyphUnderCursorRect;
                        if (ImagePanel.this.iconPanel.glyphPosUnderCursor > -1 && glyphRect != null) {
                            ImagePanel.this.textSelectionEndPrecise = (double)ImagePanel.this.iconPanel.glyphPosUnderCursor + (glyphRect.getWidth() == 0.0 ? 0.0 : (ImagePanel.this.iconPanel.glyphUnderCursorXPosition - glyphRect.getX()) / glyphRect.getWidth());
                        }
                    }
                }
            }
        });
        this.textCursorBlinkTimer = new Timer();
        this.textCursorBlinkTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (ImagePanel.this.textSelectionStartPrecise != null && ImagePanel.this.editTexts) {
                    ImagePanel.this.textCursorBlinkOn = !ImagePanel.this.textCursorBlinkOn;
                    ImagePanel.this.repaint();
                }
            }
        }, 500L, 500L);
    }

    private synchronized void redraw() {
        final Timer thisTimer = this.timer;
        if (this.timelined == null) {
            return;
        }
        this.leftRuler.repaint();
        this.topRuler.repaint();
        if (thisTimer == null) {
            this.startTimer(this.timelined.getTimeline(), false);
        } else if (Float.compare(this.getFrameLoss(), 0.0f) == 0) {
            thisTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ImagePanel.this.drawFrame(thisTimer, true);
                }
            }, 0L);
        }
    }

    public Timelined getTimelined() {
        return this.timelined;
    }

    private void updateScrollBarMinMax() {
        if (this.timelined == null) {
            this.horizontalScrollBar.setVisible(false);
            this.verticalScrollBar.setVisible(false);
            return;
        }
        RECT timRect = this.timelined.getRect();
        if (timRect == null) {
            return;
        }
        int h_maximum = timRect.Xmax;
        if (this.hilightedPoints != null || this.doFreeTransform) {
            h_maximum += 10000;
        }
        int h_minimum = timRect.Xmin;
        if (this.hilightedPoints != null || this.doFreeTransform) {
            h_minimum = timRect.Xmin > 0 ? 0 : timRect.Xmin;
            h_minimum -= 10000;
        }
        this.horizontalScrollBar.setMinimum(h_minimum);
        this.horizontalScrollBar.setMaximum(h_maximum);
        int v_maximum = timRect.Ymax;
        if (this.hilightedPoints != null || this.doFreeTransform) {
            v_maximum += 10000;
        }
        int v_minimum = timRect.Ymin;
        if (this.hilightedPoints != null || this.doFreeTransform) {
            v_minimum = timRect.Ymin > 0 ? 0 : timRect.Ymin;
            v_minimum -= 10000;
        }
        this.verticalScrollBar.setMinimum(v_minimum);
        this.verticalScrollBar.setMaximum(v_maximum);
        this.horizontalScrollBar.setVisible(this.horizontalScrollBar.getVisibleAmount() < this.horizontalScrollBar.getMaximum() - this.horizontalScrollBar.getMinimum());
        this.verticalScrollBar.setVisible(this.verticalScrollBar.getVisibleAmount() < this.verticalScrollBar.getMaximum() - this.verticalScrollBar.getMinimum());
    }

    private synchronized void updateScrollBars() {
        if (!this.zoomAvailable) {
            View.execInEventDispatchLater(new Runnable(){

                @Override
                public void run() {
                    ImagePanel.this.horizontalScrollBar.setVisible(false);
                    ImagePanel.this.verticalScrollBar.setVisible(false);
                }
            });
            return;
        }
        View.execInEventDispatchLater(new Runnable(){

            @Override
            public void run() {
                if (ImagePanel.this.timelined == null) {
                    return;
                }
                ImagePanel.this.updatingScrollBars = true;
                double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                RECT timRect = ImagePanel.this.timelined.getRect();
                int w = ImagePanel.this.iconPanel.getWidth();
                int h = ImagePanel.this.iconPanel.getHeight();
                int h_visibleAmount = (int)Math.round((double)w * 20.0 / zoomDouble);
                Point2D leftTop = ImagePanel.this.toTransformPoint(new Point2D.Double(0.0, 0.0));
                Point2D rightBottom = ImagePanel.this.toTransformPoint(new Point2D.Double(w, h));
                int h_value = (int)Math.round(leftTop.getX());
                ImagePanel.this.horizontalScrollBar.setVisibleAmount(h_visibleAmount);
                ImagePanel.this.horizontalScrollBar.setValue(h_value);
                int v_visibleAmount = (int)Math.round((double)h * 20.0 / zoomDouble);
                int v_value = (int)Math.round(leftTop.getY());
                ImagePanel.this.verticalScrollBar.setVisibleAmount(v_visibleAmount);
                ImagePanel.this.verticalScrollBar.setValue(v_value);
                ImagePanel.this.updateScrollBarMinMax();
                if (((ImagePanel)ImagePanel.this).zoom.fit) {
                    ImagePanel.this.verticalScrollBar.setVisible(false);
                    ImagePanel.this.horizontalScrollBar.setVisible(false);
                    ImagePanel.this.updatingScrollBars = false;
                    return;
                }
                boolean hVisibleBefore = ImagePanel.this.horizontalScrollBar.isVisible();
                ImagePanel.this.horizontalScrollBar.setVisible(ImagePanel.this.horizontalScrollBar.getVisibleAmount() < ImagePanel.this.horizontalScrollBar.getMaximum() - ImagePanel.this.horizontalScrollBar.getMinimum());
                boolean hVisibleAfter = ImagePanel.this.horizontalScrollBar.isVisible();
                boolean vVisibleBefore = ImagePanel.this.verticalScrollBar.isVisible();
                ImagePanel.this.verticalScrollBar.setVisible(ImagePanel.this.verticalScrollBar.getVisibleAmount() < ImagePanel.this.verticalScrollBar.getMaximum() - ImagePanel.this.verticalScrollBar.getMinimum());
                boolean vVisibleAfter = ImagePanel.this.verticalScrollBar.isVisible();
                if (hVisibleAfter != hVisibleBefore || vVisibleAfter != vVisibleBefore) {
                    ImagePanel.this.updateScrollBars();
                }
                ImagePanel.this.updatingScrollBars = false;
            }
        });
    }

    @Override
    public synchronized void zoom(Zoom zoom) {
        this.zoom(zoom, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void zoom(Zoom zoom, boolean useCursor, boolean forced) {
        boolean modified;
        if (!this.zoomAvailable) {
            return;
        }
        double zoomDoubleBefore = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        boolean bl = modified = this.zoom.value != zoom.value || this.zoom.fit != zoom.fit;
        if (modified || forced) {
            Point localCursorPosition = this.cursorPosition;
            if (!useCursor || localCursorPosition == null) {
                localCursorPosition = new Point(this.iconPanel.getWidth() / 2, this.iconPanel.getHeight() / 2);
            }
            Point2D cursorTransBefore = this.toTransformPoint(localCursorPosition);
            ExportRectangle oldViewRect = new ExportRectangle(this._viewRect);
            this.zoom = zoom;
            this.displayObjectCache.clear();
            double zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
            this.iconPanel.calcRect();
            this._viewRect = this.getViewRect();
            Point2D cursorTransAfter = this.toTransformPoint(localCursorPosition);
            int dx = (int)((cursorTransAfter.getX() - cursorTransBefore.getX()) * zoomDouble / 20.0);
            int dy = (int)((cursorTransAfter.getY() - cursorTransBefore.getY()) * zoomDouble / 20.0);
            this.offsetPoint.setLocation(this.offsetPoint.getX() + (double)dx, this.offsetPoint.getY() + (double)dy);
            this.updateScrollBars();
            this.iconPanel.calcRect();
            this._viewRect = this.getViewRect();
            Object object = this.lock;
            synchronized (object) {
                if (this.registrationPoint != null) {
                    // empty if block
                }
            }
            this.redraw();
            if (this.textTag != null) {
                this.setText(this.textTag, this.newTextTag);
            }
            this.topRuler.repaint();
            this.leftRuler.repaint();
            this.fireMediaDisplayStateChanged();
        }
    }

    public void zoomFit() {
        Zoom z = new Zoom();
        z.value = 1.0;
        z.fit = true;
        this.zoom(z, false, true);
    }

    @Override
    public synchronized BufferedImage printScreen() {
        return this.iconPanel.getLastImage();
    }

    @Override
    public synchronized double getZoomToFit() {
        if (this.timelined != null) {
            double h2;
            double w2;
            RECT bounds = this.timelined.getRect();
            double w1 = (double)bounds.getWidth() / 20.0;
            double h1 = (double)bounds.getHeight() / 20.0;
            double h = h1 * (w2 = (double)this.iconPanel.getWidth()) / w1;
            double w = h > (h2 = (double)this.iconPanel.getHeight()) ? w1 * h2 / h1 : w2;
            if (w1 <= Double.MIN_NORMAL) {
                return 1.0;
            }
            return w / w1;
        }
        return 1.0;
    }

    @Override
    public synchronized boolean zoomAvailable() {
        return this.zoomAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimelined(Timelined drawable, final SWF swf, int frame, boolean showObjectsUnderCursor, boolean autoPlay, boolean frozen, boolean alwaysDisplay, boolean muted, boolean mutable, boolean allowZoom, boolean frozenButtons, boolean canHaveRuler) {
        Stage stage = new Stage(drawable){

            public void callFrame(int frame) {
                ImagePanel.this.executeFrame(frame);
            }

            public Object callFunction(long functionAddress, long functionLength, List<Object> args, Map<Integer, String> regNames, Object thisObj) {
                try {
                    SWFInputStream sis = new SWFInputStream(swf, swf.uncompressedData, functionAddress, (int)(functionAddress + functionLength));
                    return ImagePanel.this.execute(sis);
                }
                catch (IOException ex) {
                    Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
                    return Undefined.INSTANCE;
                }
            }

            public int getCurrentFrame() {
                return ImagePanel.this.getCurrentFrame();
            }

            public int getTotalFrames() {
                return ImagePanel.this.getTotalFrames();
            }

            public void gotoFrame(int frame) {
                ImagePanel.this.pause();
                ImagePanel.this.gotoFrame(frame);
            }

            public void gotoLabel(String label) {
            }

            public void pause() {
                ImagePanel.this.pause();
            }

            public void play() {
                ImagePanel.this.play();
            }

            public void trace(Object ... val) {
                for (Object o : val) {
                    System.out.println("trace:" + o.toString());
                }
            }
        };
        this.lda = new LocalDataArea(stage);
        Object object = this;
        synchronized (object) {
            this.updatingScrollBars = true;
            this.stopInternal();
            if (drawable instanceof ButtonTag) {
                frame = 0;
            }
            this.bounds = null;
            this.displayObjectCache.clear();
            this.timelined = drawable;
            this.parentTimelineds.clear();
            this.parentFrames.clear();
            this.parentDepths.clear();
            this.centerImage();
            this.swf = swf;
            this.zoomAvailable = allowZoom;
            if (frame > -1) {
                this.frame = frame;
                this.stillFrame = true;
            } else {
                this.frame = 0;
                this.stillFrame = false;
            }
            this.prevFrame = -1;
            this.displayedFrame = this.frame;
            RECT timRect = drawable.getRect();
            double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
            this.horizontalScrollBar.setMaximum(timRect.Xmax);
            this.horizontalScrollBar.setMinimum(timRect.Xmin);
            this.verticalScrollBar.setMaximum(timRect.Ymax);
            this.verticalScrollBar.setMinimum(timRect.Ymin);
            this.updateScrollBars();
            this.loaded = true;
            if (drawable.getTimeline().getFrameCount() == 0) {
                this.clearImagePanel();
                this.fireMediaDisplayStateChanged();
                return;
            }
            this.time = 0;
            this.drawReady = false;
            this.autoPlayed = autoPlay;
            this.alwaysDisplay = alwaysDisplay;
            this.frozen = frozen;
            this.frozenButtons = frozenButtons;
            this.muted = muted;
            this.mutable = mutable;
            this.depthStateUnderCursor = null;
            this.hilightedEdge = null;
            this.hilightedPoints = null;
            this.selectedDepths = new ArrayList<Integer>();
            this.selectedPoints = new ArrayList<Integer>();
            this.textSelectionEndPrecise = null;
            this.textSelectionStartPrecise = null;
            this.textSelectionStartGlyphRect = null;
            this.textSelectionStartGlyphXPosition = null;
            this.textSelectionText = null;
            this.pointEditPanel.setVisible(false);
            this.showObjectsUnderCursor = showObjectsUnderCursor;
            this.registrationPointPosition = RegistrationPointPosition.CENTER;
            this.iconPanel.calcRect();
            if (this.selectionMode) {
                SwfSpecificCustomConfiguration conf = Configuration.getOrCreateSwfSpecificCustomConfiguration((SWF)swf);
                int chid = -1;
                if (this.timelined instanceof CharacterTag) {
                    chid = ((CharacterTag)this.timelined).getCharacterId();
                }
                conf.setCustomData("easy.lastSelected.timeline", "" + chid);
                this.loadOpenedDepths();
            }
            this.clearGuidesInternal();
            this.setNoGuidesCharacter();
            this.contentCanHaveRuler = canHaveRuler;
            this.updateRulerVisibility();
            this.redraw();
            if (autoPlay) {
                this.play();
            }
        }
        object = this.delayObject;
        synchronized (object) {
            try {
                this.delayObject.wait(50L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        object = this;
        synchronized (object) {
            if (!this.drawReady) {
                this.clearImagePanel();
            }
        }
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized void clearGuides() {
        this.clearGuidesInternal();
        this.saveGuides();
        this.repaint();
    }

    private synchronized void clearGuidesInternal() {
        this.draggingGuideX = false;
        this.draggingGuideY = false;
        this.guideDragX = -1;
        this.guideDragY = -1;
        this.guidesX.clear();
        this.guidesY.clear();
    }

    public synchronized void addGuideX(double guidePixels) {
        this.guidesX.add(guidePixels);
        this.repaint();
    }

    public synchronized void addGuideY(double guidePixels) {
        this.guidesY.add(guidePixels);
        this.repaint();
    }

    public synchronized void setNoGuidesCharacter() {
        this.guidesSwf = null;
        this.guidesCharacterId = -1;
    }

    public synchronized void setGuidesCharacter(SWF swf, int characterId) {
        this.guidesSwf = swf;
        this.guidesCharacterId = characterId;
        this.loadGuidesCharacter();
    }

    private synchronized void loadGuidesCharacter() {
        this.clearGuidesInternal();
        if (this.guidesSwf == null) {
            return;
        }
        SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration((String)this.guidesSwf.getShortPathTitle());
        if (conf == null) {
            return;
        }
        String guides = conf.getCustomData("guides", "");
        if (guides.isEmpty()) {
            return;
        }
        ArrayList<Object> parts = new ArrayList();
        if (!guides.isEmpty()) {
            String[] partsArr = guides.split("\\|", -1);
            parts = new ArrayList<String>(Arrays.asList(partsArr));
        }
        for (String part : parts) {
            if (!part.startsWith("" + this.guidesCharacterId + ":")) continue;
            part = part.substring(part.indexOf(":") + 1);
            String[] xy = part.split(";", -1);
            String[] xArr = xy[0].split(",", -1);
            String[] yArr = xy[1].split(",", -1);
            try {
                if (!xy[0].isEmpty()) {
                    for (String x : xArr) {
                        this.guidesX.add(Double.parseDouble(x));
                    }
                }
                if (!xy[1].isEmpty()) {
                    for (String y : yArr) {
                        this.guidesY.add(Double.parseDouble(y));
                    }
                }
            }
            catch (NumberFormatException nfe) {
                Logger.getLogger(ImagePanel.class.getName()).warning("Invalid configuration of guides. Cannot load.");
            }
            return;
        }
    }

    private synchronized void saveGuides() {
        if (this.guidesSwf == null) {
            return;
        }
        SwfSpecificCustomConfiguration conf = Configuration.getOrCreateSwfSpecificCustomConfiguration((String)this.guidesSwf.getShortPathTitle());
        String previous = conf.getCustomData("guides", "");
        ArrayList<Object> parts = new ArrayList();
        if (!previous.isEmpty()) {
            String[] partsArr = previous.split("\\|", -1);
            parts = new ArrayList<String>(Arrays.asList(partsArr));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.guidesCharacterId);
        sb.append(":");
        boolean first = true;
        for (Double guide : this.guidesX) {
            if (!first) {
                sb.append(",");
            }
            sb.append(guide);
            first = false;
        }
        sb.append(";");
        first = true;
        for (Double guide : this.guidesY) {
            if (!first) {
                sb.append(",");
            }
            sb.append(guide);
            first = false;
        }
        String guidesStr = sb.toString();
        for (int i = 0; i < parts.size(); ++i) {
            if (((String)parts.get(i)).startsWith("" + this.guidesCharacterId + ":")) {
                parts.remove(i);
                --i;
                continue;
            }
            String part = (String)parts.get(0);
            String noChar = part.substring(part.indexOf(":") + 1);
            if (!";".equals(noChar)) continue;
            parts.remove(i);
            --i;
        }
        if (!("" + this.guidesCharacterId + ":;").equals(guidesStr)) {
            parts.add(guidesStr);
        }
        conf.setCustomData("guides", String.join((CharSequence)"|", parts));
    }

    public synchronized void setImage(SerializableImage image) {
        this.lda = null;
        this.setBackground(View.getSwfBackgroundColor());
        this.clear();
        this.timelined = null;
        this.loaded = true;
        this.stillFrame = true;
        this.zoomAvailable = false;
        this.hilightedEdge = null;
        this.hilightedPoints = null;
        this.pointEditPanel.setVisible(false);
        this.iconPanel.setImg(image);
        this.drawReady = true;
        this.horizontalScrollBar.setVisible(false);
        this.verticalScrollBar.setVisible(false);
        this.clearGuidesInternal();
        this.setNoGuidesCharacter();
        this.contentCanHaveRuler = false;
        this.updateRulerVisibility();
        this.fireMediaDisplayStateChanged();
    }

    private void updateRulerVisibility() {
        this.topRuler.setVisible(this.contentCanHaveRuler && this.topPanel.isVisible() && (Boolean)Configuration.showRuler.get() != false);
        this.leftRuler.setVisible(this.contentCanHaveRuler && this.topPanel.isVisible() && (Boolean)Configuration.showRuler.get() != false);
    }

    public synchronized void setText(TextTag textTag, TextTag newTextTag) {
        this.setBackground(View.getSwfBackgroundColor());
        this.clear();
        this.lda = null;
        this.timelined = null;
        this.loaded = true;
        this.stillFrame = true;
        this.zoomAvailable = true;
        this.contentCanHaveRuler = true;
        this.updateRulerVisibility();
        this.textTag = textTag;
        this.newTextTag = newTextTag;
        double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        RECT rect = textTag.getRect();
        int width = (int)((double)rect.Xmax * zoomDouble);
        int height = (int)((double)rect.Ymax * zoomDouble);
        SerializableImage image = new SerializableImage((int)((double)width / 20.0) + 1, (int)((double)height / 20.0) + 1, SerializableImage.TYPE_INT_ARGB);
        image.fillTransparent();
        Matrix m = Matrix.getTranslateInstance((double)((double)(-rect.Xmin) * zoomDouble), (double)((double)(-rect.Ymin) * zoomDouble));
        m.scale(zoomDouble);
        textTag.toImage(0, 0, 0, new RenderContext(), image, image, false, m, m, m, m, (ColorTransform)new ConstantColorColorTransform(-4144960), zoomDouble, false, new ExportRectangle(rect), new ExportRectangle(rect), true, 0, 0, false);
        if (newTextTag != null) {
            newTextTag.toImage(0, 0, 0, new RenderContext(), image, image, false, m, m, m, m, (ColorTransform)new ConstantColorColorTransform(-16777216), zoomDouble, false, new ExportRectangle(rect), new ExportRectangle(rect), true, 0, 0, false);
        }
        this.iconPanel.setImg(image);
        this.drawReady = true;
        this.fireMediaDisplayStateChanged();
    }

    private synchronized void clearImagePanel() {
        this.iconPanel.setImg(null);
    }

    @Override
    public synchronized int getCurrentFrame() {
        return this.frame + 1;
    }

    @Override
    public synchronized int getTotalFrames() {
        if (this.timelined == null) {
            return 0;
        }
        if (this.stillFrame) {
            return 0;
        }
        return this.timelined.getTimeline().getFrameCount();
    }

    @Override
    public void pause() {
        this.stopInternal();
        this.redraw();
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public void stop() {
        this.stopInternal();
        this.rewind();
        this.redraw();
        this.fireMediaDisplayStateChanged();
        this.fireStatusChanged("");
    }

    @Override
    public void close() throws IOException {
        this.stopInternal();
    }

    private synchronized void stopAllSounds() {
        for (int i = this.soundPlayers.size() - 1; i >= 0; --i) {
            SoundTagPlayer pl = this.soundPlayers.get(i);
            pl.close();
        }
        this.soundPlayers.clear();
    }

    private void clear() {
        Timer ptimer = this.timer;
        if (ptimer != null) {
            this.timer = null;
            ptimer.cancel();
            this.fireMediaDisplayStateChanged();
        }
        this.textTag = null;
        this.newTextTag = null;
        this.displayObjectCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextFrame(Timer thisTimer, int cnt, int timeShouldBe) {
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            if (this.timelined != null && this.timer == thisTimer) {
                int frameCount = this.timelined.getTimeline().getFrameCount();
                int oldFrame = this.frame;
                for (int i = 0; i < cnt; ++i) {
                    if (!this.stillFrame && frameCount > 0) {
                        this.frame = (this.frame + 1) % frameCount;
                    }
                    if (!this.stillFrame && this.frame == frameCount - 1 && !this.loop) {
                        this.stopInternal();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                    if (i >= cnt - 1) continue;
                    this.drawFrame(thisTimer, false);
                }
                if (this.frame != oldFrame) {
                    if (this.frame == 0) {
                        this.stopAllSounds();
                    }
                    this.time = 0;
                } else {
                    this.time = timeShouldBe;
                }
                this.drawFrame(thisTimer, true);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.fireMediaDisplayStateChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix getParentMatrix() {
        Object object = this.lock;
        synchronized (object) {
            Matrix parentMatrix = new Matrix();
            for (int i = 0; i < this.parentTimelineds.size(); ++i) {
                DepthState parentDepthState = this.parentTimelineds.get(i).getTimeline().getDepthState(this.parentFrames.get(i).intValue(), this.parentDepths.get(i).intValue());
                if (parentDepthState == null) continue;
                parentMatrix = parentMatrix.concatenate(new Matrix(parentDepthState.matrix));
            }
            return parentMatrix;
        }
    }

    public synchronized int getFrame() {
        return this.frame;
    }

    private static SerializableImage getFrame(Rectangle realRect, RECT rect, ExportRectangle viewRect, SWF swf, int frame, int time, Timelined drawable, RenderContext renderContext, List<Integer> selectedDepths, boolean doFreeTransform, double zoom, Reference<Point2D> registrationPointRef, Reference<Rectangle2D> boundsRef, Matrix transform, Matrix temporaryMatrix, Matrix newMatrix, boolean selectionMode, List<Timelined> parentTimelineds, List<Integer> parentDepths, List<Integer> parentFrames, Matrix parentMatrix) {
        DepthState ds;
        Object parentTimelined;
        Graphics2D g;
        Timeline timeline = drawable.getTimeline();
        int width = (int)(viewRect.getWidth() * zoom);
        int height = (int)(viewRect.getHeight() * zoom);
        if (width == 0) {
            width = 1;
        }
        if (height == 0) {
            height = 1;
        }
        SerializableImage image = new SerializableImage((int)Math.ceil((double)width / 20.0), (int)Math.ceil((double)height / 20.0), SerializableImage.TYPE_INT_ARGB);
        image.fillTransparent();
        Matrix m = new Matrix();
        m.translate(-viewRect.xMin * zoom, -viewRect.yMin * zoom);
        m.scale(zoom);
        Matrix fullM = m.clone();
        for (int i = 0; i < selectedDepths.size(); ++i) {
            DepthState ds2;
            Frame fr;
            if (newMatrix == null || (fr = timeline.getFrame(frame)) == null || (ds2 = (DepthState)fr.layers.get(selectedDepths.get(i))) == null) continue;
            ds2.temporaryMatrix = newMatrix.concatenate(new Matrix(ds2.matrix)).toMATRIX();
        }
        Frame fr = timeline.getFrame(frame);
        Frame bgFr = timeline.getFrame(frame);
        if (!parentTimelineds.isEmpty()) {
            bgFr = parentTimelineds.get(0).getTimeline().getFrame(parentFrames.get(0).intValue());
        }
        if (bgFr == null || fr == null) {
            return image;
        }
        RGB backgroundColor = bgFr.backgroundColor;
        if (backgroundColor != null) {
            g = (Graphics2D)image.getBufferedImage().getGraphics();
            g.setPaint(backgroundColor.toColor());
            g.fillRect(realRect.x, realRect.y, realRect.width, realRect.height);
        }
        if (((Boolean)Configuration.showGrid.get()).booleanValue() && drawable instanceof SWF && !((Boolean)Configuration.gridOverObjects.get()).booleanValue()) {
            g = (Graphics2D)image.getBufferedImage().getGraphics();
            ImagePanel.drawGridSwf(g, realRect, zoom);
        }
        parentMatrix = new Matrix();
        ArrayList<Integer> ignoreDepths = new ArrayList<Integer>();
        for (int i = 0; i < parentTimelineds.size(); ++i) {
            parentTimelined = parentTimelineds.get(i);
            DepthState parentDepthState = parentTimelineds.get(i).getTimeline().getDepthState(parentFrames.get(i).intValue(), parentDepths.get(i).intValue());
            ignoreDepths.add(parentDepthState.depth);
            if (((Boolean)Configuration.halfTransparentParentLayersEasy.get()).booleanValue()) {
                parentTimelined.getTimeline().toImage(parentFrames.get(i).intValue(), 0, new RenderContext(), image, image, false, parentMatrix.preConcatenate(m), new Matrix(), parentMatrix.preConcatenate(m), null, zoom, true, viewRect, viewRect, parentMatrix.preConcatenate(m), true, 0, 0, (Boolean)Configuration.disableBitmapSmoothing.get() == false, ignoreDepths);
            }
            parentMatrix = parentMatrix.concatenate(new Matrix(parentDepthState.matrix));
            ignoreDepths.clear();
        }
        if (!parentTimelineds.isEmpty()) {
            Graphics2D g2 = (Graphics2D)image.getBufferedImage().getGraphics();
            g2.setPaint(new Color(255, 255, 255, 128));
            g2.fillRect(realRect.x, realRect.y, realRect.width, realRect.height);
        }
        timeline.toImage(frame, time, renderContext, image, image, false, parentMatrix.preConcatenate(m), new Matrix(), parentMatrix.preConcatenate(m), null, zoom, true, viewRect, viewRect, parentMatrix.preConcatenate(m), true, 0, 0, (Boolean)Configuration.disableBitmapSmoothing.get() == false, ignoreDepths);
        Graphics2D gg = (Graphics2D)image.getGraphics();
        gg.setStroke(new BasicStroke(3.0f));
        gg.setPaint(Color.green);
        gg.setTransform(AffineTransform.getTranslateInstance(0.0, 0.0));
        if (!doFreeTransform) {
            parentTimelined = selectedDepths.iterator();
            while (parentTimelined.hasNext()) {
                CharacterTag cht;
                int selectedDepth = (Integer)parentTimelined.next();
                DepthState ds3 = null;
                if (selectedDepth > -1 && timeline.getFrameCount() > frame && fr != null) {
                    ds3 = (DepthState)fr.layers.get(selectedDepth);
                }
                if (ds3 == null || (cht = ds3.getCharacter()) == null || !(cht instanceof DrawableTag)) continue;
                DrawableTag dt = (DrawableTag)cht;
                int drawableFrameCount = dt.getNumFrames();
                if (drawableFrameCount == 0) {
                    drawableFrameCount = 1;
                }
                int dframe = time % drawableFrameCount;
                Matrix transformation = Matrix.getScaleInstance((double)0.05).concatenate(m.concatenate(parentMatrix).concatenate(new Matrix(ds3.matrix)));
                RECT dtRect = dt.getRect();
                Rectangle2D.Double dtRect2D = new Rectangle2D.Double(dtRect.Xmin, dtRect.Ymin, dtRect.getWidth(), dtRect.getHeight());
                Shape outline = transformation.toTransform().createTransformedShape(dtRect2D);
                Rectangle bounds = outline.getBounds();
                gg.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f));
                gg.setPaint(Color.red);
                gg.draw(bounds);
            }
        }
        Rectangle totalBounds = null;
        for (int i = 0; i < selectedDepths.size(); ++i) {
            CharacterTag cht;
            int selectedDepth = selectedDepths.get(i);
            ds = null;
            if (selectedDepth > -1 && timeline.getFrameCount() > frame && fr != null) {
                ds = (DepthState)fr.layers.get(selectedDepth);
            }
            if (ds == null || (cht = ds.getCharacter()) == null || !(cht instanceof DrawableTag)) continue;
            DrawableTag dt = (DrawableTag)cht;
            int drawableFrameCount = dt.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            int dframe = time % drawableFrameCount;
            if (cht instanceof ButtonTag) {
                dframe = 3;
            }
            Matrix transform2 = transform;
            transform2 = transform.concatenate(new Matrix(ds.matrix));
            Shape outline = dt.getOutline(true, dframe, time, ds.ratio, renderContext, transform2, true, viewRect, zoom);
            if (temporaryMatrix != null) {
                Matrix tMatrix = temporaryMatrix;
                tMatrix = tMatrix.concatenate(new Matrix(ds.matrix));
                Shape tempOutline = dt.getOutline(true, dframe, time, ds.ratio, renderContext, tMatrix, true, viewRect, zoom);
                gg.setStroke(new BasicStroke(1.0f));
                gg.setPaint(Color.black);
                gg.draw(tempOutline);
            }
            Rectangle bounds = outline.getBounds();
            if (totalBounds == null) {
                totalBounds = new Rectangle(bounds);
                continue;
            }
            totalBounds.add(bounds);
        }
        if (totalBounds == null) {
            totalBounds = new Rectangle(0, 0, 1, 1);
        }
        boundsRef.setVal(totalBounds);
        gg.setStroke(new BasicStroke(1.0f));
        gg.setPaint(Color.black);
        if (doFreeTransform) {
            gg.draw(totalBounds);
            ImagePanel.drawHandles(gg, totalBounds);
            Point2D regPoint = (Point2D)registrationPointRef.getVal();
            if (regPoint == null) {
                regPoint = new Point2D.Double(totalBounds.getCenterX(), totalBounds.getCenterY());
            }
            ImagePanel.drawRegistrationPoint(gg, regPoint);
        }
        if (timeline != null && timeline.getFrameCount() > frame) {
            for (int i = 0; i < selectedDepths.size(); ++i) {
                int selectedDepth = selectedDepths.get(i);
                ds = timeline.getDepthState(frame, selectedDepth);
                if (ds == null) continue;
                ds.temporaryMatrix = null;
            }
        }
        if (((Boolean)Configuration.showGrid.get()).booleanValue() && drawable instanceof SWF && ((Boolean)Configuration.gridOverObjects.get()).booleanValue()) {
            Graphics2D g3 = (Graphics2D)image.getBufferedImage().getGraphics();
            ImagePanel.drawGridSwf(g3, realRect, zoom);
        }
        SerializableImage img = image;
        return img;
    }

    private static void drawRegistrationPoint(Graphics2D g2, Point2D registrationPoint) {
        BasicStroke stroke = new BasicStroke(1.0f);
        g2.setStroke(stroke);
        g2.setColor(Color.white);
        Ellipse2D.Double registrationPointShape = new Ellipse2D.Double(registrationPoint.getX() - 4.0, registrationPoint.getY() - 4.0, 8.0, 8.0);
        g2.fill(registrationPointShape);
        g2.setColor(Color.black);
        g2.draw(registrationPointShape);
    }

    private static void drawHandles(Graphics2D g2, Rectangle bounds) {
        ImagePanel.drawHandle(g2, bounds.getX(), bounds.getY());
        ImagePanel.drawHandle(g2, bounds.getCenterX(), bounds.getY());
        ImagePanel.drawHandle(g2, bounds.getX() + bounds.getWidth(), bounds.getY());
        ImagePanel.drawHandle(g2, bounds.getX(), bounds.getCenterY());
        ImagePanel.drawHandle(g2, bounds.getX(), bounds.getY() + bounds.getHeight());
        ImagePanel.drawHandle(g2, bounds.getX() + bounds.getWidth(), bounds.getCenterY());
        ImagePanel.drawHandle(g2, bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        ImagePanel.drawHandle(g2, bounds.getCenterX(), bounds.getY() + bounds.getHeight());
    }

    private static void drawHandle(Graphics2D g2, double x, double y) {
        Rectangle2D.Double handleTopCenter = new Rectangle2D.Double(x - 2.5, y - 2.5, 7.0, 7.0);
        g2.setColor(Color.black);
        g2.fill(handleTopCenter);
        BasicStroke stroke = new BasicStroke(2.0f);
        g2.setStroke(stroke);
        g2.setColor(Color.white);
        g2.draw(handleTopCenter);
    }

    private Object execute(SWFInputStream sis) throws IOException {
        Action a;
        if (!((Boolean)Configuration.internalFlashViewerExecuteAs12.get()).booleanValue()) {
            return Undefined.INSTANCE;
        }
        if (this.lda == null) {
            return Undefined.INSTANCE;
        }
        long ip = sis.getPos();
        while ((a = sis.readAction()) != null) {
            int actionLengthWithHeader = a.getTotalActionLength();
            a.setAddress(ip);
            a.execute(this.lda);
            if (this.lda.returnValue != null) {
                return this.lda.returnValue;
            }
            if (this.lda.jump != null) {
                ip = this.lda.jump;
                this.lda.jump = null;
            } else {
                ip += (long)actionLengthWithHeader;
            }
            sis.seek(ip);
        }
        return Undefined.INSTANCE;
    }

    private void executeFrame(int frame) {
        if (!((Boolean)Configuration.internalFlashViewerExecuteAs12.get()).booleanValue()) {
            return;
        }
        if (this.timelined == null) {
            return;
        }
        Frame f = this.timelined.getTimeline().getFrame(frame);
        List actions = f.actions;
        if (this.lda != null) {
            this.lda.clear();
        }
        for (DoActionTag src : actions) {
            try {
                ByteArrayRange actionBytes = src.getActionBytes();
                int prevLength = actionBytes.getPos();
                SWFInputStream rri = new SWFInputStream(this.swf, actionBytes.getArray(), 0L, prevLength + actionBytes.getLength());
                if (prevLength != 0) {
                    rri.seek((long)prevLength);
                }
                this.execute(rri);
            }
            catch (IOException ex) {
                Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportRectangle getViewRect() {
        Zoom zoom;
        ImagePanel imagePanel = this;
        synchronized (imagePanel) {
            zoom = this.zoom;
            if (this.timelined == null) {
                return new ExportRectangle(0.0, 0.0, 1.0, 1.0);
            }
        }
        double zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
        RECT timRect = this.timelined.getRect();
        ExportRectangle viewRect = new ExportRectangle(new RECT());
        viewRect.xMin = -this.offsetPoint.getX();
        viewRect.yMin = -this.offsetPoint.getY();
        viewRect.xMin *= 20.0;
        viewRect.xMax *= 20.0;
        viewRect.yMin *= 20.0;
        viewRect.yMax *= 20.0;
        viewRect.xMin /= zoomDouble;
        viewRect.xMax /= zoomDouble;
        viewRect.yMin /= zoomDouble;
        viewRect.yMax /= zoomDouble;
        viewRect.xMax = viewRect.xMin + (double)((int)((double)this.iconPanel.getWidth() * 20.0 / zoomDouble));
        viewRect.yMax = viewRect.yMin + (double)((int)((double)this.iconPanel.getHeight() * 20.0 / zoomDouble));
        return viewRect;
    }

    private int getSelectionStartInt() {
        Double selStart = this.textSelectionStartPrecise;
        Double selEnd = this.textSelectionEndPrecise;
        if (selStart == null) {
            return -1;
        }
        if (selStart != null && selEnd != null && selStart > selEnd) {
            double tmp = selStart;
            selStart = selEnd;
            selEnd = tmp;
        }
        int selStartInt = (int)Math.floor(selStart);
        double startFract = selStart - (double)selStartInt;
        if (startFract > 0.7) {
            ++selStartInt;
        }
        return selStartInt;
    }

    private int getSelectionEndInt() {
        Double selStart = this.textSelectionStartPrecise;
        Double selEnd = this.textSelectionEndPrecise;
        if (selStart == null) {
            return -1;
        }
        if (selStart != null && selEnd != null && selStart > selEnd) {
            double tmp = selStart;
            selStart = selEnd;
            selEnd = tmp;
        }
        int selEndInt = (int)Math.floor(selEnd);
        double endFract = selEnd - (double)selEndInt;
        if (endFract > 0.7) {
            ++selEndInt;
        }
        return selEndInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFrame(Timer thisTimer, boolean display) {
        SerializableImage img;
        SWF swf;
        Zoom zoom;
        List<Integer> selectedDepths;
        int mouseButton;
        Point2D cursorPosition;
        int time;
        int frame;
        MouseEvent lastMouseEvent;
        Timelined timelined;
        ImagePanel imagePanel = this;
        synchronized (imagePanel) {
            timelined = this.timelined;
            lastMouseEvent = this.lastMouseEvent;
        }
        boolean shownAgain = false;
        ImagePanel imagePanel2 = this;
        synchronized (imagePanel2) {
            frame = this.frame;
            time = this.time;
            if (this.frame == this.prevFrame) {
                shownAgain = true;
            }
            this.prevFrame = this.frame;
            cursorPosition = this.cursorPosition;
            if (cursorPosition != null) {
                Point2D p2d = this.toTransformPoint(cursorPosition);
                cursorPosition = new Point2D.Double(p2d.getX() / 20.0, p2d.getY() / 20.0);
            }
            mouseButton = this.mouseButton;
            selectedDepths = this.selectedDepths;
            zoom = this.zoom;
            swf = this.swf;
        }
        if (timelined == null) {
            return;
        }
        RenderContext renderContext = new RenderContext();
        renderContext.displayObjectCache = this.displayObjectCache;
        if (cursorPosition != null) {
            DisplayPoint touchPoint = new DisplayPoint(cursorPosition);
            if (this.touchPointOffset != null) {
                touchPoint = new DisplayPoint((int)Math.round(cursorPosition.getX() + (double)this.touchPointOffset.x), (int)Math.round(cursorPosition.getY() + (double)this.touchPointOffset.y));
            }
            renderContext.cursorPosition = new Point((int)((double)touchPoint.x * 20.0), (int)((double)touchPoint.y * 20.0));
            renderContext.cursorPosition = this.getParentMatrix().transform(renderContext.cursorPosition);
        }
        renderContext.mouseButton = mouseButton;
        renderContext.stateUnderCursor = new ArrayList();
        renderContext.enableButtons = !this.frozenButtons;
        Double selStart = this.textSelectionStartPrecise;
        Double selEnd = this.textSelectionEndPrecise;
        if (selStart != null && selEnd != null) {
            if (selStart > selEnd) {
                double tmp = selStart;
                selStart = selEnd;
                selEnd = tmp;
            }
            int selStartInt = (int)Math.floor(selStart);
            double startFract = selStart - (double)selStartInt;
            int selEndInt = (int)Math.floor(selEnd);
            double endFract = selEnd - (double)selEndInt;
            if (endFract > 0.7) {
                ++selEndInt;
            }
            if (startFract > 0.7) {
                ++selStartInt;
            }
            renderContext.selectionStart = selStartInt;
            renderContext.selectionEnd = selEndInt;
            renderContext.selectionText = this.textSelectionText;
        }
        try {
            Object rect;
            Timeline timeline = timelined.getTimeline();
            if (frame >= timeline.getFrameCount()) {
                return;
            }
            double zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
            this.updatePos(timelined, lastMouseEvent, thisTimer);
            Matrix mat = new Matrix();
            mat.translateX = swf.displayRect.Xmin;
            mat.translateY = swf.displayRect.Ymin;
            img = null;
            if (display) {
                Stopwatch sw = Stopwatch.startNew();
                Reference boundsRef = new Reference(null);
                Timelined t = this.getTopTimelined();
                if (t == null) {
                    return;
                }
                rect = t.getRect();
                ImagePanel imagePanel3 = this;
                synchronized (imagePanel3) {
                    Object object = this.lock;
                    synchronized (object) {
                        this._viewRect = this.getViewRect();
                    }
                }
                Matrix trans2 = this.transform == null ? new Matrix() : this.transform.clone();
                trans2 = this.toImageMatrix(trans2);
                AffineTransform tempTrans2 = null;
                if (this.transformUpdated != null) {
                    Matrix matrixUpdated = new Matrix(this.transformUpdated);
                    matrixUpdated = this.toImageMatrix(matrixUpdated);
                    tempTrans2 = matrixUpdated.toTransform();
                }
                Rectangle realRect = new Rectangle(((RECT)rect).Xmin, ((RECT)rect).Ymin, ((RECT)rect).Xmax - ((RECT)rect).Xmin, ((RECT)rect).Ymax - ((RECT)rect).Ymin);
                realRect.x = (int)((double)realRect.x * zoomDouble);
                realRect.y = (int)((double)realRect.y * zoomDouble);
                realRect.width = (int)((double)realRect.width * zoomDouble);
                realRect.height = (int)((double)realRect.height * zoomDouble);
                realRect.x = (int)((double)realRect.x / 20.0);
                realRect.y = (int)((double)realRect.y / 20.0);
                realRect.width = (int)((double)realRect.width / 20.0);
                realRect.height = (int)((double)realRect.height / 20.0);
                realRect.x = (int)((double)realRect.x + this.offsetPoint.getX());
                realRect.y = (int)((double)realRect.y + this.offsetPoint.getY());
                Point2D rawRegistrationPoint = this.registrationPoint == null ? null : this.toImagePoint(this.registrationPoint);
                Reference registrationPointRef = new Reference((Object)rawRegistrationPoint);
                img = !this.autoPlayed ? this.getImagePlay() : (this._viewRect.getHeight() < 0.0 || this._viewRect.getWidth() < 0.0 ? new SerializableImage(1, 1, 6) : ImagePanel.getFrame(realRect, (RECT)rect, this._viewRect, swf, frame, this.frozen ? 0 : time, timelined, renderContext, selectedDepths, this.doFreeTransform, zoomDouble, (Reference<Point2D>)registrationPointRef, (Reference<Rectangle2D>)boundsRef, trans2, tempTrans2 == null ? null : new Matrix(tempTrans2), this.transform, this.selectionMode, this.parentTimelineds, this.parentDepths, this.parentFrames, this.getParentMatrix()));
                ImagePanel imagePanel4 = this;
                synchronized (imagePanel4) {
                    Object object = this.lock;
                    synchronized (object) {
                        Rectangle2D newBounds = this.getTransformBounds();
                        if (newBounds != null) {
                            this.bounds = newBounds;
                            if (this.registrationPoint == null) {
                                this.registrationPoint = new Point2D.Double(newBounds.getCenterX(), newBounds.getCenterY());
                            }
                        }
                    }
                }
                sw.stop();
                if (sw.getElapsedMilliseconds() > 100L && ((Boolean)Configuration.showSlowRenderingWarning.get()).booleanValue()) {
                    logger.log(Level.WARNING, "Slow rendering. {0}. frame, time={1}, {2}ms", new Object[]{frame, time, sw.getElapsedMilliseconds()});
                }
                if (renderContext.borderImage != null) {
                    img = renderContext.borderImage;
                }
            }
            if (this.autoPlayed) {
                if (!this.muted) {
                    CharacterTag c;
                    ArrayList<Integer> sounds = new ArrayList<Integer>();
                    ArrayList soundClasses = new ArrayList();
                    ArrayList soundInfos = new ArrayList();
                    timeline.getSounds(frame, time, renderContext.mouseOverButton, mouseButton, sounds, soundClasses, soundInfos);
                    rect = swf.getCharacters(true).keySet().iterator();
                    while (rect.hasNext()) {
                        int cid = (Integer)rect.next();
                        c = swf.getCharacter(cid);
                        for (int k = 0; k < soundClasses.size(); ++k) {
                            String cls = (String)soundClasses.get(k);
                            if (cls == null || !c.getClassNames().contains(cls)) continue;
                            sounds.set(k, cid);
                        }
                    }
                    for (int s = 0; s < sounds.size(); ++s) {
                        int sndId = (Integer)sounds.get(s);
                        if (sndId == -1 || !((c = swf.getCharacter(sndId)) instanceof SoundTag)) continue;
                        SoundTag st = (SoundTag)c;
                        this.playSound(st, (SOUNDINFO)soundInfos.get(s), thisTimer);
                    }
                }
                this.executeFrame(frame);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return;
        }
        if (display) {
            boolean handCursor;
            final StringBuilder ret = new StringBuilder();
            if (cursorPosition != null && this.autoPlayed) {
                ret.append(" [").append(ImagePanel.formatDouble(cursorPosition.getX())).append(";").append(ImagePanel.formatDouble(cursorPosition.getY())).append("]");
                if (this.showObjectsUnderCursor) {
                    ret.append(" : ");
                }
            }
            boolean bl = handCursor = renderContext.mouseOverButton != null || !this.autoPlayed && !this.frozenButtons;
            this.depthStateUnderCursor = this.autoPlayed ? (!renderContext.stateUnderCursor.isEmpty() ? (DepthState)renderContext.stateUnderCursor.get(renderContext.stateUnderCursor.size() - 1) : null) : null;
            if (this.showObjectsUnderCursor && this.autoPlayed) {
                boolean first = true;
                for (int i = renderContext.stateUnderCursor.size() - 1; i >= 0; --i) {
                    DepthState ds = (DepthState)renderContext.stateUnderCursor.get(i);
                    if (!first) {
                        if (!this.showAllDepthLevelsInfo) break;
                        ret.append(", ");
                    }
                    first = false;
                    CharacterTag c = ds.getCharacter();
                    ret.append(this.tagNameResolver.getTagName((Tag)c));
                    if (ds.depth <= -1) continue;
                    ret.append(" ");
                    ret.append(AppStrings.translate("imagePanel.depth"));
                    ret.append(" ");
                    ret.append(ds.depth);
                }
                if (first) {
                    ret.append(DEFAULT_DEBUG_LABEL_TEXT);
                }
            }
            final boolean doFreeTransform = this.doFreeTransform;
            Object object = this;
            synchronized (object) {
                if (this.timer == thisTimer) {
                    this.iconPanel.setImg(img);
                    ButtonTag lastMouseOverButton = this.iconPanel.mouseOverButton;
                    this.lastMouseOverText = this.iconPanel.mouseOverText;
                    this.iconPanel.mouseOverButton = renderContext.mouseOverButton;
                    this.iconPanel.mouseOverText = renderContext.mouseOverText;
                    this.iconPanel.selectionAbsMatrix = renderContext.selectionAbsMatrix;
                    this.iconPanel.glyphUnderCursorRect = renderContext.glyphUnderCursorRect;
                    this.iconPanel.glyphUnderCursorXPosition = renderContext.glyphUnderCursorXPosition;
                    this.iconPanel.glyphPosUnderCursor = renderContext.glyphPosUnderCursor;
                    View.execInEventDispatchLater(new Runnable(){

                        @Override
                        public void run() {
                            Cursor newCursor;
                            if (ret.length() == 0) {
                                ImagePanel.this.debugLabel.setText(ImagePanel.DEFAULT_DEBUG_LABEL_TEXT);
                            } else {
                                ImagePanel.this.debugLabel.setText(ret.toString());
                            }
                            if (ImagePanel.this.hilightedPoints != null) {
                                newCursor = !ImagePanel.this.pointsUnderCursor.isEmpty() ? movePointCursor : (!ImagePanel.this.pathPointsUnderCursor.isEmpty() ? (ImagePanel.this.iconPanel.isCtrlDown() ? addPointCursor : defaultCursor) : selectCursor);
                                if (ImagePanel.this.iconPanel.getCursor() != newCursor) {
                                    ImagePanel.this.iconPanel.setCursor(newCursor);
                                }
                            }
                            if (!doFreeTransform && ImagePanel.this.hilightedPoints == null) {
                                newCursor = ImagePanel.this.mode == -9 ? guideXCursor : (ImagePanel.this.mode == -10 ? guideYCursor : (ImagePanel.this.iconPanel.isAltDown() && !ImagePanel.this.selectionMode && !doFreeTransform ? (ImagePanel.this.depthStateUnderCursor == null ? Cursor.getPredefinedCursor(0) : Cursor.getPredefinedCursor(12)) : (handCursor ? Cursor.getPredefinedCursor(12) : (!ImagePanel.this.selectionMode && !doFreeTransform && (ImagePanel.this.selectingText || ImagePanel.this.iconPanel.mouseOverText != null && (ImagePanel.this.allowSelectAllTextTypes || ImagePanel.this.iconPanel.mouseOverText instanceof DefineEditTextTag && !((DefineEditTextTag)((IconPanel)((ImagePanel)ImagePanel.this).iconPanel).mouseOverText).noSelect)) ? textCursor : (ImagePanel.this.zoomAvailable && ImagePanel.this.iconPanel.hasAllowMove() ? Cursor.getPredefinedCursor(13) : Cursor.getPredefinedCursor(0))))));
                                if (ImagePanel.this.iconPanel.getCursor() != newCursor) {
                                    ImagePanel.this.iconPanel.setCursor(newCursor);
                                }
                            }
                        }
                    });
                    if (this.lastMouseOverText != renderContext.mouseOverText) {
                        // empty if block
                    }
                    if (!this.muted && lastMouseOverButton != renderContext.mouseOverButton) {
                        CharacterTag soundCharTag;
                        DefineButtonSoundTag sounds;
                        ButtonTag b = renderContext.mouseOverButton;
                        if (b != null && !doFreeTransform && (sounds = b.getSounds()) != null && sounds.buttonSoundChar1 != 0 && (soundCharTag = swf.getCharacter(sounds.buttonSoundChar1)) instanceof SoundTag) {
                            this.playSound((SoundTag)soundCharTag, sounds.buttonSoundInfo1, this.timer);
                        }
                        if ((b = lastMouseOverButton) != null && !doFreeTransform && (sounds = b.getSounds()) != null && sounds.buttonSoundChar0 != 0 && (soundCharTag = swf.getCharacter(sounds.buttonSoundChar0)) instanceof SoundTag) {
                            this.playSound((SoundTag)soundCharTag, sounds.buttonSoundInfo0, this.timer);
                        }
                    }
                    this.drawReady = true;
                }
            }
            object = this.delayObject;
            synchronized (object) {
                this.delayObject.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playSound(SoundTag st, SOUNDINFO soundInfo, Timer thisTimer) {
        ImagePanel imagePanel = this;
        synchronized (imagePanel) {
            if (soundInfo.syncNoMultiple || soundInfo.syncStop) {
                for (int s = this.soundPlayers.size() - 1; s >= 0; --s) {
                    SoundTagPlayer sp = this.soundPlayers.get(s);
                    if (sp.getTag() != st) continue;
                    if (soundInfo.syncNoMultiple) {
                        return;
                    }
                    if (!soundInfo.syncStop) continue;
                    sp.stop();
                }
                if (soundInfo.syncStop) {
                    return;
                }
            }
            if (this.soundPlayers.size() > 8) {
                return;
            }
        }
        try {
            int loopCount = 1;
            if (soundInfo != null && soundInfo.hasLoops) {
                loopCount = Math.max(1, soundInfo.loopCount);
            }
            final SoundTagPlayer sp = new SoundTagPlayer(soundInfo, st, loopCount, false);
            sp.addEventListener(new MediaDisplayListener(){

                @Override
                public void mediaDisplayStateChanged(MediaDisplay source) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void playingFinished(MediaDisplay source) {
                    ImagePanel imagePanel = ImagePanel.this;
                    synchronized (imagePanel) {
                        sp.close();
                        ImagePanel.this.soundPlayers.remove(sp);
                    }
                }

                @Override
                public void statusChanged(String status) {
                }
            });
            ImagePanel imagePanel2 = this;
            synchronized (imagePanel2) {
                if (this.timer != null && this.timer == thisTimer) {
                    this.soundPlayers.add(sp);
                    sp.play();
                } else {
                    sp.close();
                }
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
            logger.log(Level.SEVERE, "Error during playing sound", ex);
        }
    }

    public synchronized void clearAll() {
        this.stopInternal();
        this.clearImagePanel();
        this.timelined = null;
        this.swf = null;
        this.guidesSwf = null;
        this.lda = null;
        this.showObjectsUnderCursor = false;
        this.fireMediaDisplayStateChanged();
    }

    private synchronized void stopInternal() {
        this.clear();
        this.stopAllSounds();
    }

    @Override
    public synchronized void play() {
        this.autoPlayed = true;
        this.stopInternal();
        if (this.timelined != null) {
            Timeline timeline = this.timelined.getTimeline();
            if (!this.stillFrame && this.frame == timeline.getFrameCount() - 1) {
                this.frame = 0;
                this.prevFrame = -1;
            }
            this.startTimer(timeline, true);
        }
    }

    private synchronized void setMsPerFrame(int val) {
        this.msPerFrame = val;
    }

    private synchronized int getMsPerFrame() {
        return this.msPerFrame;
    }

    private synchronized void setFpsIs(float val) {
        this.fpsIs = val;
    }

    private synchronized float getFpsIs() {
        return this.fpsIs;
    }

    private synchronized float getFrameLoss() {
        return 100.0f - this.getFpsIs() / this.fpsShouldBe * 100.0f;
    }

    private synchronized void setSkippedFrames(int val) {
        this.skippedFrames = val;
    }

    private synchronized void addSkippedFrames(int val) {
        this.skippedFrames += val;
    }

    private synchronized int getSkippedFrames() {
        return this.skippedFrames;
    }

    private synchronized int getAndResetSkippedFrames() {
        int ret = this.skippedFrames;
        this.skippedFrames = 0;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTask(final boolean singleFrame, long msDelay, final boolean first) {
        TimerTask task = new TimerTask(){
            public final Timer thisTimer;
            public final boolean isSingleFrame;
            {
                this.thisTimer = ImagePanel.this.timer;
                this.isSingleFrame = singleFrame;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ImagePanel imagePanel = ImagePanel.this;
                    synchronized (imagePanel) {
                        if (ImagePanel.this.timer != this.thisTimer) {
                            return;
                        }
                    }
                    int curFrame = ImagePanel.this.frame;
                    long delay = ImagePanel.this.getMsPerFrame();
                    if (this.isSingleFrame) {
                        ImagePanel.this.drawFrame(this.thisTimer, true);
                        ImagePanel.this.fireMediaDisplayStateChanged();
                    } else {
                        int skipFrames;
                        int frameOverMaxShouldBeNow;
                        long frameTimeMsIs = System.currentTimeMillis();
                        int frameCount = ImagePanel.this.timelined.getTimeline().getFrameCount();
                        if (frameCount == 0) {
                            return;
                        }
                        int ticksFromStart = (int)Math.floor((double)(frameTimeMsIs - ImagePanel.this.startRun) / (double)ImagePanel.this.getMsPerFrame());
                        if (ImagePanel.this.stillFrame) {
                            frameOverMaxShouldBeNow = ticksFromStart;
                            skipFrames = ticksFromStart - ImagePanel.this.time;
                        } else {
                            frameOverMaxShouldBeNow = ImagePanel.this.startFrame + ticksFromStart;
                            int frameShouldBeNow = frameOverMaxShouldBeNow % frameCount;
                            skipFrames = frameShouldBeNow - curFrame;
                        }
                        if (skipFrames < 0) {
                            skipFrames += frameCount;
                        }
                        if (skipFrames > 1) {
                            ImagePanel.this.addSkippedFrames(skipFrames - 1);
                        }
                        int currentFrameTicks = 0;
                        if (frameCount == 1 || ImagePanel.this.stillFrame) {
                            currentFrameTicks = ticksFromStart;
                        }
                        if (first) {
                            ImagePanel.this.drawFrame(this.thisTimer, true);
                        } else {
                            ImagePanel.this.nextFrame(this.thisTimer, skipFrames, currentFrameTicks);
                        }
                        long afterDrawFrameTimeMsIs = System.currentTimeMillis();
                        int nextFrameOverMax = frameOverMaxShouldBeNow;
                        while (delay < 0L) {
                            long nextFrameOverMaxTimeMsShouldBe = ImagePanel.this.startRun + (long)(ImagePanel.this.getMsPerFrame() * ++nextFrameOverMax);
                            delay = nextFrameOverMaxTimeMsShouldBe - afterDrawFrameTimeMsIs;
                        }
                    }
                    ImagePanel imagePanel2 = ImagePanel.this;
                    synchronized (imagePanel2) {
                        if (ImagePanel.this.timer != this.thisTimer) {
                            return;
                        }
                    }
                    ImagePanel.this.scheduleTask(this.isSingleFrame, delay, false);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Frame drawing error", ex);
                }
            }
        };
        ImagePanel imagePanel = this;
        synchronized (imagePanel) {
            if (this.timer != null) {
                this.timer.schedule(task, msDelay);
            }
        }
    }

    private synchronized void startTimer(Timeline timeline, boolean playing) {
        boolean singleFrame;
        this.playing = playing;
        this.startRun = System.currentTimeMillis();
        this.startFrame = this.frame;
        float frameRate = timeline.frameRate;
        this.setMsPerFrame(frameRate == 0.0f ? 1000 : (int)(1000.0 / (double)frameRate));
        boolean bl = singleFrame = !playing || this.stillFrame && timeline.isSingleFrame(this.frame) || !this.stillFrame && timeline.getRealFrameCount() <= 1 && timeline.isSingleFrame();
        if (this.fpsTimer == null) {
            this.fpsTimer = new Timer();
            this.fpsTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    float skipped = ImagePanel.this.getAndResetSkippedFrames();
                    ImagePanel.this.setFpsIs(ImagePanel.this.fpsShouldBe - skipped);
                }
            }, 1000L, 1000L);
        }
        this.timer = new Timer();
        this.fpsIs = this.fpsShouldBe = timeline.frameRate;
        this.scheduleTask(singleFrame, 0L, true);
    }

    @Override
    public synchronized void rewind() {
        this.frame = 0;
        this.prevFrame = -1;
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized boolean isPlaying() {
        if (this.timelined == null || this.stillFrame) {
            return false;
        }
        return this.playing;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public synchronized void gotoFrame(int frame) {
        if (this.timelined == null) {
            return;
        }
        Timeline timeline = this.timelined.getTimeline();
        if (frame > timeline.getFrameCount()) {
            frame = timeline.getFrameCount();
        }
        if (frame < 1) {
            frame = 1;
        }
        this.autoPlayed = true;
        this.frame = frame - 1;
        this.prevFrame = -1;
        if (this.selectionMode) {
            SwfSpecificCustomConfiguration conf = Configuration.getOrCreateSwfSpecificCustomConfiguration((SWF)this.timelined.getSwf());
            conf.setCustomData("easy.lastSelected.frame", "" + frame);
        }
        this.stopInternal();
        this.redraw();
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized float getFrameRate() {
        if (this.timelined == null) {
            return 1.0f;
        }
        if (this.stillFrame) {
            return 1.0f;
        }
        return this.timelined.getTimeline().frameRate;
    }

    @Override
    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean loopAvailable() {
        return false;
    }

    @Override
    public boolean screenAvailable() {
        return true;
    }

    @Override
    public synchronized Zoom getZoom() {
        if (this.zoom.fit) {
            this.zoom.value = this.getZoomToFit();
        }
        return this.zoom;
    }

    private double getRealZoom() {
        if (this.zoom.fit) {
            return this.getZoomToFit();
        }
        return this.zoom.value;
    }

    private synchronized void zoomIn() {
        double currentRealZoom = this.getRealZoom();
        if (currentRealZoom >= 1000000.0) {
            return;
        }
        Zoom newZoom = new Zoom();
        newZoom.value = currentRealZoom * ZOOM_MULTIPLIER;
        newZoom.fit = false;
        this.zoom(newZoom, true, false);
    }

    private synchronized void zoomOut() {
        Zoom newZoom = new Zoom();
        newZoom.value = this.getRealZoom() / ZOOM_MULTIPLIER;
        newZoom.fit = false;
        this.zoom(newZoom, true, false);
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public Point2D getRegistrationPoint() {
        return this.registrationPoint;
    }

    public RegistrationPointPosition getRegistrationPointPosition() {
        return this.registrationPointPosition;
    }

    public void setRegistrationPoint(Point2D registrationPoint) {
        this.registrationPoint = registrationPoint;
        this.registrationPointPosition = null;
        this.redraw();
        this.fireBoundsChange(this.getTransformBounds(), registrationPoint, this.registrationPointPosition);
    }

    public void setRegistrationPointPosition(RegistrationPointPosition position) {
        Rectangle2D transformBounds = this.getTransformBounds();
        Point2D.Double newRegistrationPoint = new Point2D.Double(transformBounds.getX() + transformBounds.getWidth() * position.getPositionX(), transformBounds.getY() + transformBounds.getHeight() * position.getPositionY());
        this.registrationPoint = newRegistrationPoint;
        this.registrationPointPosition = position;
        this.redraw();
        this.fireBoundsChange(this.getTransformBounds(), this.registrationPoint, position);
    }

    public void applyTransformMatrix(Matrix matrix) {
        this.applyTransformMatrixInternal(matrix);
        this.redraw();
        this.fireBoundsChange(this.getTransformBounds(), this.registrationPoint, this.registrationPointPosition);
        this.fireTransformChanged();
    }

    private void applyTransformMatrixInternal(Matrix matrix) {
        Matrix parentMatrix = this.getParentMatrix();
        this.transform = parentMatrix.concatenate(matrix).concatenate(this.transform).concatenate(parentMatrix.inverse());
        Point2D.Double newRegistrationPoint = new Point2D.Double();
        matrix.toTransform().transform(this.registrationPoint, newRegistrationPoint);
        this.registrationPoint = newRegistrationPoint;
    }

    public void setFullTransformMatrix(Matrix matrix) {
        Matrix relativeMatrix = matrix.concatenate(this.getOriginalMatrix().inverse()).concatenate(this.transform.inverse());
        Matrix parentMatrix = this.getParentMatrix();
        this.transform = parentMatrix.concatenate(matrix).concatenate(this.getOriginalMatrix().inverse()).concatenate(parentMatrix.inverse());
        Point2D.Double newRegistrationPoint = new Point2D.Double();
        relativeMatrix.toTransform().transform(this.registrationPoint, newRegistrationPoint);
        this.registrationPoint = newRegistrationPoint;
        this.redraw();
        this.fireBoundsChange(this.getTransformBounds(), this.registrationPoint, this.registrationPointPosition);
        this.fireTransformChanged();
    }

    private Point2D toTransformPoint(Point2D point) {
        double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        double rx = (point.getX() - this.offsetPoint.getX()) * 20.0 / zoomDouble;
        double ry = (point.getY() - this.offsetPoint.getY()) * 20.0 / zoomDouble;
        Point2D ret = new Point2D.Double(rx, ry);
        ret = this.getParentMatrix().inverse().transform(ret);
        return ret;
    }

    private Matrix toImageMatrix(Matrix transform) {
        double zoomDouble;
        Matrix m = new Matrix();
        double zoom = zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        m.translate(-this._viewRect.xMin * zoom, -this._viewRect.yMin * zoom);
        m.scale(zoom);
        Matrix p = this.getParentMatrix();
        return Matrix.getScaleInstance((double)0.05).concatenate(m).concatenate(transform).concatenate(p);
    }

    private Point2D toImagePoint(Point2D point) {
        point = this.getParentMatrix().transform(point);
        double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        double rx = point.getX() * zoomDouble / 20.0 + this.offsetPoint.getX();
        double ry = point.getY() * zoomDouble / 20.0 + this.offsetPoint.getY();
        Point2D.Double ret = new Point2D.Double(rx, ry);
        return ret;
    }

    private Rectangle2D toImageRect(Rectangle2D rect) {
        Point2D topLeft = this.toImagePoint(new Point2D.Double(rect.getMinX(), rect.getMinY()));
        Point2D bottomRight = this.toImagePoint(new Point2D.Double(rect.getMaxX(), rect.getMaxY()));
        return new Rectangle2D.Double(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX(), bottomRight.getY() - topLeft.getY());
    }

    private Point2D toParentPoint(Point2D point) {
        point = this.getParentMatrix().transform(point);
        return point;
    }

    private Rectangle2D toParentRect(Rectangle2D rect) {
        Point2D topLeft = this.toParentPoint(new Point2D.Double(rect.getMinX(), rect.getMinY()));
        Point2D bottomRight = this.toParentPoint(new Point2D.Double(rect.getMaxX(), rect.getMaxY()));
        return new Rectangle2D.Double(topLeft.getX(), topLeft.getY(), bottomRight.getX() - topLeft.getX(), bottomRight.getY() - topLeft.getY());
    }

    private Rectangle2D getTransformBounds() {
        return this.getTransformBounds(this.getNewMatrix());
    }

    private Rectangle2D getTransformBounds(Matrix newMatrix) {
        if (this.timelined == null) {
            return null;
        }
        int time = this.frozen ? 0 : this.time;
        DepthState ds = null;
        Timeline timeline = this.timelined.getTimeline();
        if (timeline.getFrameCount() <= this.frame) {
            return new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        }
        if (newMatrix == null) {
            return new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        }
        RenderContext renderContext = new RenderContext();
        renderContext.displayObjectCache = this.displayObjectCache;
        if (this.cursorPosition != null && !this.doFreeTransform) {
            renderContext.cursorPosition = new Point((int)((double)this.cursorPosition.x * 20.0), (int)((double)this.cursorPosition.y * 20.0));
        }
        renderContext.mouseButton = this.mouseButton;
        renderContext.stateUnderCursor = new ArrayList();
        Rectangle2D totalBounds = null;
        for (int selectedDepth : this.selectedDepths) {
            CharacterTag cht;
            ds = (DepthState)timeline.getFrame((int)this.frame).layers.get(selectedDepth);
            if (ds == null || (cht = ds.getCharacter()) == null || !(cht instanceof DrawableTag)) continue;
            DrawableTag dt = (DrawableTag)cht;
            int drawableFrameCount = dt.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            Matrix b = newMatrix;
            int dframe = time % drawableFrameCount;
            if (cht instanceof ButtonTag) {
                dframe = 3;
            }
            double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
            Shape outline = dt.getOutline(true, dframe, time, ds.ratio, renderContext, b.concatenate(new Matrix(ds.matrix)), true, this._viewRect, zoomDouble);
            if (totalBounds == null) {
                Rectangle2D r = outline.getBounds2D();
                totalBounds = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                continue;
            }
            totalBounds.add(outline.getBounds2D());
        }
        if (totalBounds == null) {
            return new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        }
        return totalBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timelined getTopTimelined() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.parentTimelineds.isEmpty()) {
                return this.parentTimelineds.get(0);
            }
            return this.timelined;
        }
    }

    public void loadOpenedDepths() {
        SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration((SWF)this.swf);
        if (conf != null) {
            int chid = -1;
            if (!this.parentTimelineds.isEmpty()) {
                Timelined firstTimelined = this.parentTimelineds.get(0);
                if (firstTimelined instanceof CharacterTag) {
                    chid = ((CharacterTag)firstTimelined).getCharacterId();
                }
            } else if (this.timelined instanceof CharacterTag) {
                chid = ((CharacterTag)this.timelined).getCharacterId();
            }
            int lastChid = Integer.parseInt(conf.getCustomData("easy.lastSelected.timeline", "-1"));
            if (lastChid != chid) {
                return;
            }
            List parentDepths = conf.getCustomDataAsList("easy.lastSelected.parentDepths");
            List parentFrames = conf.getCustomDataAsList("easy.lastSelected.parentFrames");
            while (parentFrames.size() < parentDepths.size()) {
                parentFrames.add("0");
            }
            conf.setCustomData("easy.lastSelected.parentDepths", new ArrayList());
            conf.setCustomData("easy.lastSelected.parentFrames", new ArrayList());
            int frame = Integer.parseInt(conf.getCustomData("easy.lastSelected.frame", "1"));
            for (int i = 0; i < parentDepths.size(); ++i) {
                this.openDepth(Integer.parseInt((String)parentFrames.get(i)), Integer.parseInt((String)parentDepths.get(i)));
            }
            this.gotoFrame(frame);
        } else {
            this.gotoFrame(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDepth(int frame, int depth) {
        CharacterTag cht;
        Timelined tim = this.timelined;
        if (tim == null) {
            return;
        }
        if (tim.getTimeline().getFrame(frame) == null) {
            return;
        }
        DepthState ds = (DepthState)tim.getTimeline().getFrame((int)frame).layers.get(depth);
        if (ds != null && (cht = ds.getCharacter()) instanceof Timelined) {
            int newFrame = 0;
            Object object = this.lock;
            synchronized (object) {
                this.parentTimelineds.add(this.timelined);
                this.parentDepths.add(ds.depth);
                this.parentFrames.add(ds.frame.frame);
                this.timelined = (Timelined)cht;
                this.selectedDepths.clear();
                int time = ds.time;
                newFrame = time % this.timelined.getFrameCount();
                if (this.timelined instanceof ButtonTag) {
                    newFrame = 0;
                }
                frame = newFrame;
                SWF swf = this.parentTimelineds.get(0).getSwf();
                SwfSpecificCustomConfiguration conf = Configuration.getOrCreateSwfSpecificCustomConfiguration((SWF)swf);
                if (this.parentTimelineds.size() == 1) {
                    conf.setCustomData("easy.lastSelected.firstParentFrame", "" + (ds.frame.frame + 1));
                }
                List parentDepths = conf.getCustomDataAsList("easy.lastSelected.parentDepths");
                parentDepths.add("" + ds.depth);
                conf.setCustomData("easy.lastSelected.parentDepths", (Iterable)parentDepths);
                List parentFrames = conf.getCustomDataAsList("easy.lastSelected.parentFrames");
                parentFrames.add("" + ds.frame.frame);
                conf.setCustomData("easy.lastSelected.parentFrames", (Iterable)parentFrames);
            }
            this.gotoFrame(newFrame + 1);
            this.fireMediaDisplayStateChanged();
        }
    }

    static {
        DECIMAL_FORMAT = new DecimalFormat("0.##");
        try {
            moveCursor = ImagePanel.loadCursor("move", 0, 0);
            moveRegPointCursor = ImagePanel.loadCursor("move_regpoint", 0, 0);
            resizeNWSECursor = ImagePanel.loadCursor("resize_nw_se", 5, 5);
            resizeSWNECursor = ImagePanel.loadCursor("resize_sw_ne", 5, 5);
            resizeXCursor = ImagePanel.loadCursor("resize_x", 7, 4);
            resizeYCursor = ImagePanel.loadCursor("resize_y", 4, 7);
            rotateCursor = ImagePanel.loadCursor("rotate", 10, 7);
            selectCursor = ImagePanel.loadCursor("select", 0, 0);
            shearXCursor = ImagePanel.loadCursor("shear_x", 9, 5);
            shearYCursor = ImagePanel.loadCursor("shear_y", 5, 9);
            movePointCursor = ImagePanel.loadCursor("move_point", 0, 0);
            defaultCursor = ImagePanel.loadCursor("default", 0, 0);
            addPointCursor = ImagePanel.loadCursor("add_point", 0, 0);
            guideXCursor = ImagePanel.loadCursor("guide_x", 0, 0);
            guideYCursor = ImagePanel.loadCursor("guide_y", 0, 0);
            textCursor = Cursor.getPredefinedCursor(2);
        }
        catch (IOException ex) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        ZOOM_MULTIPLIER = Math.pow(10.0, 0.1);
    }

    class DistanceItem {
        public double distance;
        public int pathPoint;
        public double pathPosition;
        public DisplayPoint closestPoint;

        public DistanceItem(double distance, int pathPoint, double pathPosition, DisplayPoint closestPoint) {
            this.distance = distance;
            this.pathPoint = pathPoint;
            this.pathPosition = pathPosition;
            this.closestPoint = closestPoint;
        }
    }

    private class IconPanel
    extends JPanel {
        private SerializableImage _img;
        private ButtonTag mouseOverButton = null;
        private TextTag mouseOverText = null;
        private Matrix selectionAbsMatrix = null;
        private int glyphPosUnderCursor = -1;
        private Rectangle2D glyphUnderCursorRect = null;
        private double glyphUnderCursorXPosition = 0.0;
        private boolean autoFit = false;
        private boolean allowMove = true;
        private Point2D dragStart = null;
        private Point2D selectionEnd = null;
        private boolean canInvert = true;
        VolatileImage renderImage;
        private boolean ctrlDown = false;
        private boolean altDown = false;
        private boolean shiftDown = false;
        private List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
        private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
        private List<MouseWheelListener> mouseWheelListeners = new ArrayList<MouseWheelListener>();

        private Rectangle2D getSelectionRect() {
            Point2D selectStart = this.dragStart;
            Point2D selectEnd = this.selectionEnd;
            if (selectStart == null || selectEnd == null) {
                return null;
            }
            double startX = Math.min(selectStart.getX(), selectEnd.getX());
            double startY = Math.min(selectStart.getY(), selectEnd.getY());
            double endX = Math.max(selectStart.getX(), selectEnd.getX());
            double endY = Math.max(selectStart.getY(), selectEnd.getY());
            return new Rectangle2D.Double(startX, startY, endX - startX, endY - startY);
        }

        private synchronized Point2D getDragStart() {
            return this.dragStart;
        }

        private synchronized void setDragStart(Point dragStart) {
            this.dragStart = dragStart;
        }

        private synchronized SerializableImage getImg() {
            return this._img;
        }

        public boolean hasAllowMove() {
            return this.allowMove;
        }

        private void drawGridNoSwf(Graphics2D g2, int x, int y) {
            Point2D.Double p2;
            Point2D.Double p1;
            double zoomDouble = ImagePanel.this.getRealZoom();
            g2.setColor((Color)Configuration.gridColor.get());
            int ix = 0;
            int iy = 0;
            double sx = (double)x + ImagePanel.this.offsetPoint.getX();
            double sy = (double)y + ImagePanel.this.offsetPoint.getY();
            while (sx + (double)(ix * (Integer)Configuration.gridHorizontalSpace.get()) * zoomDouble > 0.0) {
                --ix;
            }
            int minIx = ix;
            ix = 0;
            while (sx + (double)(ix * (Integer)Configuration.gridHorizontalSpace.get()) * zoomDouble < (double)this.getWidth()) {
                ++ix;
            }
            int maxIx = ix;
            while (sy + (double)(iy * (Integer)Configuration.gridVerticalSpace.get()) * zoomDouble > 0.0) {
                --iy;
            }
            int minIy = iy;
            iy = 0;
            while (sy + (double)(iy * (Integer)Configuration.gridVerticalSpace.get()) * zoomDouble < (double)this.getHeight()) {
                ++iy;
            }
            int maxIy = iy;
            for (ix = minIx; ix <= maxIx; ++ix) {
                double gx = sx + (double)(ix * (Integer)Configuration.gridHorizontalSpace.get()) * zoomDouble;
                p1 = new Point2D.Double(gx, sy + (double)(minIy * (Integer)Configuration.gridVerticalSpace.get()) * zoomDouble);
                p2 = new Point2D.Double(gx, sy + (double)(maxIy * (Integer)Configuration.gridVerticalSpace.get()) * zoomDouble);
                g2.drawLine((int)Math.round(((Point2D)p1).getX()), (int)Math.round(((Point2D)p1).getY()), (int)Math.round(((Point2D)p2).getX()), (int)Math.round(((Point2D)p2).getY()));
            }
            for (iy = minIy; iy <= maxIy; ++iy) {
                double gy = sy + (double)(iy * (Integer)Configuration.gridVerticalSpace.get()) * zoomDouble;
                p1 = new Point2D.Double(sx + (double)(minIx * (Integer)Configuration.gridHorizontalSpace.get()) * zoomDouble, gy);
                p2 = new Point2D.Double(sx + (double)(maxIx * (Integer)Configuration.gridHorizontalSpace.get()) * zoomDouble, gy);
                g2.drawLine((int)Math.round(((Point2D)p1).getX()), (int)Math.round(((Point2D)p1).getY()), (int)Math.round(((Point2D)p2).getX()), (int)Math.round(((Point2D)p2).getY()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render() {
            VolatileImage ri;
            SerializableImage img = this.getImg();
            Graphics2D g2 = null;
            do {
                if ((ri = this.renderImage) == null) {
                    return;
                }
                int valid = ri.validate(View.getDefaultConfiguration());
                if (valid == 2) {
                    ri = View.createRenderImage(this.getWidth(), this.getHeight(), 3);
                }
                try {
                    Rectangle2D selectionRect;
                    double zoomDouble;
                    g2 = ri.createGraphics();
                    Color swfBackgroundColor = View.getSwfBackgroundColor();
                    if (swfBackgroundColor.getAlpha() < 255) {
                        g2.setPaint(View.transparentPaint);
                        g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                    }
                    g2.setComposite(AlphaComposite.Src);
                    g2.setPaint(View.getSwfBackgroundColor());
                    g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                    g2.setComposite(AlphaComposite.SrcOver);
                    if (img == null) continue;
                    int x = 0;
                    int y = 0;
                    if (ImagePanel.this.timelined == null || !ImagePanel.this.autoPlayed) {
                        x = (int)ImagePanel.this.offsetPoint.getX();
                        y = (int)ImagePanel.this.offsetPoint.getY();
                    }
                    double d = zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                    if (((Boolean)Configuration.showGrid.get()).booleanValue() && !(ImagePanel.this.timelined instanceof SWF) && !((Boolean)Configuration.gridOverObjects.get()).booleanValue()) {
                        this.drawGridNoSwf(g2, x, y);
                    }
                    g2.drawImage(img.getBufferedImage(), x, y, x + img.getWidth(), y + img.getHeight(), 0, 0, img.getWidth(), img.getHeight(), null);
                    if (((Boolean)Configuration.showGrid.get()).booleanValue() && !(ImagePanel.this.timelined instanceof SWF) && ((Boolean)Configuration.gridOverObjects.get()).booleanValue()) {
                        this.drawGridNoSwf(g2, x, y);
                    }
                    if (ImagePanel.this.hilightedEdge != null || ImagePanel.this.hilightedPoints != null) {
                        int pointSize;
                        int i;
                        RectangularShape pointShape;
                        List points;
                        ImagePanel.this.hilightEdgeColor = ImagePanel.this.hilightEdgeColor + ImagePanel.this.hilightEdgeColorStep;
                        if (ImagePanel.this.hilightEdgeColor < 100 || ImagePanel.this.hilightEdgeColor > 255) {
                            ImagePanel.this.hilightEdgeColorStep = -ImagePanel.this.hilightEdgeColorStep;
                            ImagePanel.this.hilightEdgeColor = ImagePanel.this.hilightEdgeColor + ImagePanel.this.hilightEdgeColorStep * 2;
                        }
                        RECT timRect = ImagePanel.this.timelined.getRect();
                        AffineTransform trans = new AffineTransform();
                        trans.translate(ImagePanel.this.offsetPoint.getX(), ImagePanel.this.offsetPoint.getY());
                        trans.scale(0.05, 0.05);
                        trans.scale(zoomDouble, zoomDouble);
                        AffineTransform oldTransform = g2.getTransform();
                        g2.transform(trans);
                        if (ImagePanel.this.hilightedEdge != null) {
                            g2.setStroke(new BasicStroke((float)(120.0 / zoomDouble)));
                            g2.setPaint(new Color(ImagePanel.this.hilightEdgeColor, ImagePanel.this.hilightEdgeColor, ImagePanel.this.hilightEdgeColor));
                            Point[] edge = ImagePanel.this.hilightedEdge;
                            GeneralPath path = new GeneralPath();
                            if (edge.length == 2) {
                                path.moveTo(edge[0].x, edge[0].y);
                                path.lineTo(edge[1].x, edge[1].y);
                            }
                            if (edge.length == 3) {
                                path.moveTo(edge[0].x, edge[0].y);
                                path.quadTo(edge[1].x, edge[1].y, edge[2].x, edge[2].y);
                            }
                            if (edge.length == 1) {
                                double crossSize = 200.0 / zoomDouble;
                                path.moveTo((double)edge[0].x - crossSize, (double)edge[0].y);
                                path.lineTo((double)edge[0].x + crossSize, (double)edge[0].y);
                                path.moveTo((double)edge[0].x, (double)edge[0].y - crossSize);
                                path.lineTo((double)edge[0].x, (double)edge[0].y + crossSize);
                            }
                            g2.draw(path);
                            double pointSize2 = 80.0 / zoomDouble;
                            g2.setPaint(Color.red);
                            g2.fill(new Ellipse2D.Double((double)edge[edge.length - 1].x - pointSize2, (double)edge[edge.length - 1].y - pointSize2, pointSize2 * 2.0, pointSize2 * 2.0));
                            g2.setPaint(Color.green);
                            g2.fill(new Ellipse2D.Double((double)edge[0].x - pointSize2, (double)edge[0].y - pointSize2, pointSize2 * 2.0, pointSize2 * 2.0));
                        }
                        if ((points = ImagePanel.this.hilightedPoints) != null) {
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                            g2.setStroke(new BasicStroke((float)(20.0 / zoomDouble)));
                            double pointSize3 = 80.0 / zoomDouble;
                            for (int i2 = 0; i2 < points.size(); ++i2) {
                                DisplayPoint p = (DisplayPoint)points.get(i2);
                                pointShape = p.onPath ? new Rectangle2D.Double((double)p.x - pointSize3, (double)p.y - pointSize3, pointSize3 * 2.0, pointSize3 * 2.0) : new Ellipse2D.Double((double)p.x - pointSize3, (double)p.y - pointSize3, pointSize3 * 2.0, pointSize3 * 2.0);
                                if (ImagePanel.this.selectedPoints.contains(i2)) {
                                    g2.setPaint(Color.black);
                                } else {
                                    g2.setPaint(Color.white);
                                }
                                g2.fill(pointShape);
                                if (ImagePanel.this.selectedPoints.contains(i2)) {
                                    g2.setPaint(Color.white);
                                } else {
                                    g2.setPaint(Color.black);
                                }
                                g2.draw(pointShape);
                            }
                        }
                        for (i = 0; i < ImagePanel.this.showPoints1.size(); ++i) {
                            int xt = ((Point)((ImagePanel)ImagePanel.this).showPoints1.get((int)i)).x;
                            pointSize = 3;
                            int yt = ((Point)((ImagePanel)ImagePanel.this).showPoints1.get((int)i)).y;
                            pointShape = new Ellipse2D.Double(xt - pointSize, yt - pointSize, pointSize * 2, pointSize * 2);
                            g2.setPaint(Color.blue);
                            g2.fill(pointShape);
                        }
                        for (i = 0; i < ImagePanel.this.showPoints2.size(); ++i) {
                            int xt = ((Point)((ImagePanel)ImagePanel.this).showPoints2.get((int)i)).x;
                            pointSize = 3;
                            int yt = ((Point)((ImagePanel)ImagePanel.this).showPoints2.get((int)i)).y;
                            pointShape = new Ellipse2D.Double(xt - pointSize, yt - pointSize, pointSize * 2, pointSize * 2);
                            g2.setPaint(Color.red);
                            g2.fill(pointShape);
                        }
                        g2.setTransform(oldTransform);
                    }
                    if (!(ImagePanel.this.timelined instanceof SWF) && (ImagePanel.this.doFreeTransform || ImagePanel.this.hilightedPoints != null)) {
                        float dp;
                        int axisX = 0;
                        int axisY = 0;
                        RECT timRect = ImagePanel.this.timelined.getRect();
                        axisX = (int)Math.round(ImagePanel.this.offsetPoint.getX());
                        axisY = (int)Math.round(ImagePanel.this.offsetPoint.getY());
                        if (this.canInvert) {
                            g2.setComposite((Composite)BlendComposite.Invert);
                        } else {
                            g2.setComposite(AlphaComposite.SrcOver);
                        }
                        g2.setPaint(new Color(255, 255, 255, 128));
                        for (dp = -((float)ImagePanel.this.offsetPoint.getY()); dp < 0.0f; dp += 10.0f) {
                        }
                        g2.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, dp));
                        GeneralPath p = new GeneralPath();
                        p.moveTo(axisX, 0.0f);
                        p.lineTo(axisX, this.getHeight());
                        g2.draw(p);
                        for (dp = -((float)ImagePanel.this.offsetPoint.getX()); dp < 0.0f; dp += 10.0f) {
                        }
                        g2.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{5.0f, 5.0f}, dp));
                        p = new GeneralPath();
                        p.moveTo(0.0f, axisY);
                        p.lineTo(this.getWidth(), axisY);
                        g2.draw(p);
                        g2.setComposite(AlphaComposite.SrcOver);
                    }
                    if ((selectionRect = this.getSelectionRect()) != null) {
                        g2.setStroke(new BasicStroke(1.0f, 2, 1, 0.0f, new float[]{2.0f, 2.0f}, 0.0f));
                        if (this.canInvert) {
                            g2.setComposite((Composite)BlendComposite.Invert);
                        } else {
                            g2.setComposite(AlphaComposite.SrcOver);
                        }
                        g2.draw(new Rectangle2D.Double(selectionRect.getX(), selectionRect.getY(), selectionRect.getWidth(), selectionRect.getHeight()));
                        g2.setComposite(AlphaComposite.SrcOver);
                    }
                    if (ImagePanel.this.touchPointOffset != null) {
                        boolean snapped = ImagePanel.this.snapOffset.getX() != 0.0 || ImagePanel.this.snapOffset.getY() != 0.0;
                        g2.setStroke(new BasicStroke(snapped ? 2 : 1));
                        Point2D.Double p = new Point2D.Double((double)(ImagePanel.this.lastMouseEvent.getX() + ((ImagePanel)ImagePanel.this).touchPointOffset.x) + ImagePanel.this.snapOffset.getX(), (double)(ImagePanel.this.lastMouseEvent.getY() + ((ImagePanel)ImagePanel.this).touchPointOffset.y) + ImagePanel.this.snapOffset.getY());
                        double pointSize = snapped ? 4 : 3;
                        Ellipse2D.Double pointShape = new Ellipse2D.Double(((Point2D)p).getX() - pointSize, ((Point2D)p).getY() - pointSize, pointSize * 2.0, pointSize * 2.0);
                        g2.setPaint(Color.black);
                        g2.draw(pointShape);
                    }
                    g2.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{2.0f}, 0.0f));
                    GeneralPath gp = new GeneralPath();
                    DisplayPoint snapAlignStart = ImagePanel.this.snapAlignXPoint1;
                    DisplayPoint snapAlignEnd = ImagePanel.this.snapAlignXPoint2;
                    if (snapAlignStart != null && snapAlignEnd != null) {
                        gp.moveTo(snapAlignStart.x, snapAlignStart.y);
                        gp.lineTo(snapAlignEnd.x, snapAlignEnd.y);
                    }
                    snapAlignStart = ImagePanel.this.snapAlignYPoint1;
                    snapAlignEnd = ImagePanel.this.snapAlignYPoint2;
                    if (snapAlignStart != null && snapAlignEnd != null) {
                        gp.moveTo(snapAlignStart.x, snapAlignStart.y);
                        gp.lineTo(snapAlignEnd.x, snapAlignEnd.y);
                    }
                    if (this.canInvert) {
                        g2.setComposite((Composite)BlendComposite.Invert);
                        g2.setPaint(Color.black);
                    } else {
                        g2.setComposite(AlphaComposite.SrcOver);
                        g2.setPaint(Color.cyan);
                    }
                    g2.draw(gp);
                    g2.setComposite(AlphaComposite.SrcOver);
                    Rectangle2D curRect = ImagePanel.this.textSelectionStartGlyphRect;
                    Matrix mat = ((ImagePanel)ImagePanel.this).iconPanel.selectionAbsMatrix;
                    Double xPos = ImagePanel.this.textSelectionStartGlyphXPosition;
                    if (!ImagePanel.this.textCursorBlinkOn || curRect == null || mat == null || ImagePanel.this.textSelectionStartPrecise == null || xPos == null) continue;
                    double rectPos = (xPos - curRect.getX()) / curRect.getWidth();
                    curRect = rectPos < 0.7 ? new Rectangle2D.Double(curRect.getX(), curRect.getY(), 20.0, curRect.getHeight()) : new Rectangle2D.Double(curRect.getMaxX(), curRect.getY(), 20.0, curRect.getHeight());
                    Matrix matScale = Matrix.getScaleInstance((double)0.05);
                    Shape shape = mat.preConcatenate(matScale).toTransform().createTransformedShape(curRect);
                    g2.setColor(Color.black);
                    g2.fill(shape);
                }
                catch (InternalError ie) {
                    if (!this.canInvert) continue;
                    this.canInvert = false;
                }
                finally {
                    if (g2 != null) {
                        g2.dispose();
                    }
                }
            } while (ri.contentsLost());
        }

        @Override
        public synchronized void addMouseMotionListener(MouseMotionListener l) {
            this.mouseMotionListeners.add(l);
        }

        @Override
        public synchronized void removeMouseMotionListener(MouseMotionListener l) {
            this.mouseMotionListeners.remove(l);
        }

        @Override
        public synchronized void addMouseListener(MouseListener l) {
            this.mouseListeners.add(l);
        }

        @Override
        public synchronized void removeMouseListener(MouseListener l) {
            this.mouseListeners.remove(l);
        }

        @Override
        public synchronized void addMouseWheelListener(MouseWheelListener l) {
            this.mouseWheelListeners.add(l);
        }

        @Override
        public synchronized void removeMouseWheelListener(MouseWheelListener l) {
            this.mouseWheelListeners.remove(l);
        }

        public boolean isAltDown() {
            return this.altDown;
        }

        public boolean isCtrlDown() {
            return this.ctrlDown;
        }

        public IconPanel() {
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.addKeyEventDispatcher(new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getID() == 401 || e.getID() == 402) {
                        IconPanel.this.ctrlDown = (e.getModifiersEx() & 0x80) == 128;
                        IconPanel.this.altDown = (e.getModifiersEx() & 0x200) == 512;
                        IconPanel.this.shiftDown = (e.getModifiersEx() & 0x40) == 64;
                    }
                    return false;
                }
            });
            this.addKeyListener(new KeyAdapter(){

                private void move(int x, int y) {
                    if (ImagePanel.this.hilightedPoints != null) {
                        Point minPoint = ImagePanel.this.getMinSelectedPoint();
                        if (minPoint != null) {
                            ImagePanel.this.pointXTextField.setText(ImagePanel.formatDouble((double)minPoint.x / 20.0 + (double)x));
                            ImagePanel.this.pointYTextField.setText(ImagePanel.formatDouble((double)minPoint.y / 20.0 + (double)y));
                            ImagePanel.this.applyPointsXY();
                        }
                    } else {
                        Matrix matrix = new Matrix();
                        matrix.translate((double)x * 20.0, (double)y * 20.0);
                        ImagePanel.this.applyTransformMatrix(matrix);
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    if (!ImagePanel.this.editTexts) {
                        return;
                    }
                    if (e.getKeyChar() == '\u007f') {
                        if (ImagePanel.this.textSelectionText != null) {
                            TextTag text = ImagePanel.this.textSelectionText;
                            int selStart = ImagePanel.this.getSelectionStartInt();
                            if (text != null && selStart > -1) {
                                text.removeCharacterGlyph(selStart);
                                ImagePanel.this.fireTextChanged();
                            }
                        }
                        return;
                    }
                    if (e.getKeyChar() == '\b') {
                        if (ImagePanel.this.textSelectionText != null) {
                            TextTag text = ImagePanel.this.textSelectionText;
                            int selStart = ImagePanel.this.getSelectionStartInt();
                            if (text != null && selStart > 0) {
                                ImagePanel.this.changeTextSelection(-1);
                                text.removeCharacterGlyph(selStart - 1);
                                ImagePanel.this.fireTextChanged();
                            }
                        }
                        return;
                    }
                    char c = e.getKeyChar();
                    TextTag text = ImagePanel.this.textSelectionText;
                    int selStart = ImagePanel.this.getSelectionStartInt();
                    if (text != null && selStart > -1) {
                        text.insertCharacterGlyph(selStart, c);
                        ImagePanel.this.fireTextChanged();
                        ImagePanel.this.changeTextSelection(1);
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (ImagePanel.this.textSelectionText != null) {
                        if (e.getKeyCode() == 39) {
                            ImagePanel.this.changeTextSelection(1);
                        }
                        if (e.getKeyCode() == 37) {
                            ImagePanel.this.changeTextSelection(-1);
                        }
                    }
                    if (ImagePanel.this.hilightedPoints != null && e.getKeyCode() == 127) {
                        ArrayList<Integer> selectedPointsDesc = new ArrayList<Integer>(ImagePanel.this.selectedPoints);
                        selectedPointsDesc.sort(new Comparator<Integer>(){

                            @Override
                            public int compare(Integer o1, Integer o2) {
                                return o2 - o1;
                            }
                        });
                        Iterator iterator = selectedPointsDesc.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            ImagePanel.this.firePointRemoved(i);
                        }
                        ImagePanel.this.selectedPoints.clear();
                        IconPanel.this.repaint();
                    }
                    if (ImagePanel.this.doFreeTransform || ImagePanel.this.hilightedPoints != null) {
                        if (e.getKeyCode() == 37) {
                            this.move(-1, 0);
                        }
                        if (e.getKeyCode() == 39) {
                            this.move(1, 0);
                        }
                        if (e.getKeyCode() == 38) {
                            this.move(0, -1);
                        }
                        if (e.getKeyCode() == 40) {
                            this.move(0, 1);
                        }
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int width = IconPanel.this.getWidth();
                    int height = IconPanel.this.getHeight();
                    IconPanel.this.renderImage = width > 0 && height > 0 ? View.createRenderImage(width, height, 3) : null;
                    IconPanel.this.calcRect();
                    ImagePanel.this.updateScrollBars();
                    IconPanel.this.render();
                    IconPanel.this.repaint();
                }
            });
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TextTag text;
                    if (SwingUtilities.isRightMouseButton(e) && !ImagePanel.this.selectionMode && !ImagePanel.this.doFreeTransform && (text = IconPanel.this.mouseOverText) != null && text instanceof DefineEditTextTag) {
                        DefineEditTextTag defineEditText = (DefineEditTextTag)text;
                        List recs = defineEditText.getTextRecords(defineEditText.getSwf());
                        FontTag font = null;
                        int pos = 0;
                        int selStart = ImagePanel.this.getSelectionStartInt();
                        int selEnd = ImagePanel.this.getSelectionEndInt();
                        StringBuilder sb = new StringBuilder();
                        int y = 0;
                        for (TEXTRECORD r : recs) {
                            if (r.styleFlagsHasFont) {
                                font = r.getFont(defineEditText.getSwf());
                            }
                            if (r.styleFlagsHasYOffset) {
                                int oldY = y;
                                y = r.yOffset;
                                if (text == ImagePanel.this.textSelectionText && pos >= selStart && pos < selEnd && y > oldY && sb.length() > 0) {
                                    sb.append("\n");
                                }
                            }
                            if (font == null) continue;
                            for (GLYPHENTRY g : r.glyphEntries) {
                                if (text == ImagePanel.this.textSelectionText && pos >= selStart && pos < selEnd) {
                                    sb.append(font.glyphToChar(g.glyphIndex));
                                }
                                ++pos;
                            }
                        }
                        final String textToCopy = sb.toString();
                        final int fullLength = pos;
                        JPopupMenu pm = new JPopupMenu();
                        JMenuItem copyMenuItem = new JMenuItem(AppStrings.translate("text.copy"), View.getIcon("copy16"));
                        copyMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                StringSelection stringSelection = new StringSelection(textToCopy);
                                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                clipboard.setContents(stringSelection, null);
                            }
                        });
                        JMenuItem selectAllMenuItem = new JMenuItem(AppStrings.translate("text.selectAll"), View.getIcon("selectall16"));
                        selectAllMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ImagePanel.this.textSelectionText = text;
                                ImagePanel.this.textSelectionStartPrecise = 0.0;
                                ImagePanel.this.textSelectionEndPrecise = Double.valueOf(fullLength);
                                ImagePanel.this.textSelectionStartGlyphRect = new Rectangle2D.Double();
                                ImagePanel.this.textSelectionStartGlyphXPosition = 0.0;
                                IconPanel.this.repaint();
                            }
                        });
                        if (!textToCopy.isEmpty()) {
                            pm.add(copyMenuItem);
                        }
                        pm.add(selectAllMenuItem);
                        pm.show(ImagePanel.this.iconPanel, e.getX(), e.getY());
                    }
                    if (e.getClickCount() == 2 && ((Boolean)Configuration.showGuides.get()).booleanValue() && !((Boolean)Configuration.lockGuides.get()).booleanValue()) {
                        Double guide;
                        int d;
                        Point mousePoint = e.getPoint();
                        for (d = 0; d < ImagePanel.this.guidesX.size(); ++d) {
                            guide = (Double)ImagePanel.this.guidesX.get(d);
                            int guideInPanel = (int)Math.round(guide * ImagePanel.this.getRealZoom() + ImagePanel.this.offsetPoint.getX());
                            if (mousePoint.x != guideInPanel) continue;
                            String newPositionStr = ViewMessages.showInputDialog(ImagePanel.this, AppStrings.translate("move_guide.position"), AppStrings.translate("move_guide"), View.getIcon("guidemovex32"), EcmaNumberToString.stringFor((double)guide));
                            if (newPositionStr != null) {
                                try {
                                    double newPosition = Double.parseDouble(newPositionStr);
                                    ImagePanel.this.guidesX.set(d, newPosition);
                                    ImagePanel.this.saveGuides();
                                    IconPanel.this.repaint();
                                }
                                catch (NumberFormatException newPosition) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                        for (d = 0; d < ImagePanel.this.guidesY.size(); ++d) {
                            guide = (Double)ImagePanel.this.guidesY.get(d);
                            int guideInPanel = (int)Math.round(guide * ImagePanel.this.getRealZoom() + ImagePanel.this.offsetPoint.getY());
                            if (mousePoint.y != guideInPanel) continue;
                            String newPositionStr = ViewMessages.showInputDialog(ImagePanel.this, AppStrings.translate("move_guide.position"), AppStrings.translate("move_guide"), View.getIcon("guidemovey32"), EcmaNumberToString.stringFor((double)guide));
                            if (newPositionStr != null) {
                                try {
                                    double newPosition = Double.parseDouble(newPositionStr);
                                    ImagePanel.this.guidesY.set(d, newPosition);
                                    ImagePanel.this.saveGuides();
                                    IconPanel.this.repaint();
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                    if (e.getClickCount() == 2 && ImagePanel.this.selectionMode && !ImagePanel.this.transformSelectionMode) {
                        DepthState ds = ImagePanel.this.depthStateUnderCursor;
                        if (ds != null) {
                            ImagePanel.this.openDepth(ImagePanel.this.frame, ds.depth);
                        }
                        return;
                    }
                    if (IconPanel.this.shiftDown) {
                        ArrayList<Integer> newSelectedPoints = new ArrayList<Integer>(ImagePanel.this.pointsUnderCursor);
                        Iterator iterator = ImagePanel.this.selectedPoints.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            if (!newSelectedPoints.contains(i)) {
                                newSelectedPoints.add(i);
                                continue;
                            }
                            newSelectedPoints.remove((Object)i);
                        }
                        ImagePanel.this.selectedPoints = newSelectedPoints;
                    } else {
                        ImagePanel.this.selectedPoints = new ArrayList(ImagePanel.this.pointsUnderCursor);
                    }
                    ImagePanel.this.calculatePointsXY();
                    if (IconPanel.this.altDown || ImagePanel.this.selectionMode) {
                        if (ImagePanel.this.depthStateUnderCursor != null) {
                            ArrayList<Integer> newSelectedDepths = new ArrayList<Integer>();
                            if (IconPanel.this.ctrlDown) {
                                newSelectedDepths.addAll(ImagePanel.this.selectedDepths);
                                if (newSelectedDepths.contains(((ImagePanel)ImagePanel.this).depthStateUnderCursor.depth)) {
                                    newSelectedDepths.remove((Object)((ImagePanel)ImagePanel.this).depthStateUnderCursor.depth);
                                } else {
                                    newSelectedDepths.add(((ImagePanel)ImagePanel.this).depthStateUnderCursor.depth);
                                }
                            } else {
                                newSelectedDepths.add(((ImagePanel)ImagePanel.this).depthStateUnderCursor.depth);
                            }
                            if (ImagePanel.this.transformSelectionMode) {
                                if (ImagePanel.this.mode == 0) {
                                    ImagePanel.this.freeTransformDepths(newSelectedDepths);
                                    ImagePanel.this.firePlaceObjectSelected();
                                }
                            } else if (IconPanel.this.altDown && !ImagePanel.this.selectionMode && !ImagePanel.this.doFreeTransform || ImagePanel.this.selectionMode) {
                                ImagePanel.this.selectDepths(newSelectedDepths);
                                ImagePanel.this.firePlaceObjectSelected();
                            }
                        } else if (ImagePanel.this.transformSelectionMode) {
                            if (ImagePanel.this.mode == 0) {
                                ImagePanel.this.freeTransformDepths(new ArrayList<Integer>());
                                ImagePanel.this.selectDepths(new ArrayList<Integer>());
                                ImagePanel.this.firePlaceObjectSelected();
                            }
                        } else if (IconPanel.this.altDown && !ImagePanel.this.selectionMode || ImagePanel.this.selectionMode) {
                            ImagePanel.this.selectDepths(new ArrayList<Integer>());
                            ImagePanel.this.firePlaceObjectSelected();
                        }
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (IconPanel.this.altDown || ImagePanel.this.selectionMode) {
                            if (ImagePanel.this.depthStateUnderCursor != null && ImagePanel.this.selectedDepths.contains(((ImagePanel)ImagePanel.this).depthStateUnderCursor.depth)) {
                                ImagePanel.this.inMoving = ImagePanel.this.selectionMode;
                                ImagePanel.this.calculateFreeOrSelectionTransform();
                            }
                            if (!ImagePanel.this.selectionMode) {
                                return;
                            }
                        }
                        this.mouseMoved(e);
                        if (((Boolean)Configuration.showGuides.get()).booleanValue() && !((Boolean)Configuration.lockGuides.get()).booleanValue()) {
                            int guideInPanel;
                            Double guide;
                            int d;
                            Point mousePoint = e.getPoint();
                            for (d = 0; d < ImagePanel.this.guidesX.size(); ++d) {
                                guide = (Double)ImagePanel.this.guidesX.get(d);
                                guideInPanel = (int)Math.round(guide * ImagePanel.this.getRealZoom() + ImagePanel.this.offsetPoint.getX());
                                if (mousePoint.x < guideInPanel - 2 || mousePoint.x > guideInPanel + 2) continue;
                                ImagePanel.this.guidesX.remove(d);
                                ImagePanel.this.guideDragX = guideInPanel;
                                ImagePanel.this.draggingGuideX = true;
                                ImagePanel.this.saveGuides();
                                return;
                            }
                            for (d = 0; d < ImagePanel.this.guidesY.size(); ++d) {
                                guide = (Double)ImagePanel.this.guidesY.get(d);
                                guideInPanel = (int)Math.round(guide * ImagePanel.this.getRealZoom() + ImagePanel.this.offsetPoint.getY());
                                if (mousePoint.y < guideInPanel - 2 || mousePoint.y > guideInPanel + 2) continue;
                                ImagePanel.this.guidesY.remove(d);
                                ImagePanel.this.guideDragY = guideInPanel;
                                ImagePanel.this.draggingGuideY = true;
                                ImagePanel.this.saveGuides();
                                return;
                            }
                        }
                        IconPanel.this.setDragStart(e.getPoint());
                        if (!IconPanel.this.shiftDown) {
                            boolean selectedUnderCursor = false;
                            Iterator d = ImagePanel.this.pointsUnderCursor.iterator();
                            while (d.hasNext()) {
                                int p = (Integer)d.next();
                                if (!ImagePanel.this.selectedPoints.contains(p)) continue;
                                selectedUnderCursor = true;
                                break;
                            }
                            if (!selectedUnderCursor) {
                                ImagePanel.this.selectedPoints = new ArrayList(ImagePanel.this.pointsUnderCursor);
                                ImagePanel.this.calculatePointsXY();
                            }
                        }
                        ArrayList<DisplayPoint> newPointsUnderCursorValues = new ArrayList<DisplayPoint>();
                        Iterator d = ImagePanel.this.selectedPoints.iterator();
                        while (d.hasNext()) {
                            int i = (Integer)d.next();
                            newPointsUnderCursorValues.add(new DisplayPoint((DisplayPoint)ImagePanel.this.hilightedPoints.get(i)));
                        }
                        ImagePanel.this.selectedPointsOriginalValues = newPointsUnderCursorValues;
                        if (ImagePanel.this.selectionMode && ImagePanel.this.depthStateUnderCursor != null && ImagePanel.this.selectedDepths.contains(((ImagePanel)ImagePanel.this).depthStateUnderCursor.depth) || !ImagePanel.this.selectionMode && ImagePanel.this.doFreeTransform && ImagePanel.this.depthStateUnderCursor != null) {
                            Matrix matrix = new Matrix();
                            if (((ImagePanel)ImagePanel.this).depthStateUnderCursor.matrix != null) {
                                matrix = matrix.preConcatenate(new Matrix(((ImagePanel)ImagePanel.this).depthStateUnderCursor.matrix));
                            }
                            matrix = matrix.concatenate(ImagePanel.this.getParentMatrix());
                            Matrix scaleMatrix = Matrix.getScaleInstance((double)(ImagePanel.this.getRealZoom() / 20.0));
                            matrix = matrix.preConcatenate(scaleMatrix);
                            matrix = matrix.preConcatenate(Matrix.getTranslateInstance((double)ImagePanel.this.offsetPoint.getX(), (double)ImagePanel.this.offsetPoint.getY()));
                            Point2D.Double cursorPos = new Point2D.Double(e.getX(), e.getY());
                            CharacterTag ch = ImagePanel.this.depthStateUnderCursor.getCharacter();
                            if (ch != null && ch instanceof BoundedTag) {
                                BoundedTag bt = (BoundedTag)ch;
                                RECT rect = bt.getRect();
                                Point2D[] importantPoints = new Point2D[]{new Point2D.Double(rect.Xmin, rect.Ymin), new Point2D.Double((double)(rect.Xmin + rect.Xmax) / 2.0, rect.Ymin), new Point2D.Double(rect.Xmax, rect.Ymin), new Point2D.Double(rect.Xmin, (double)(rect.Ymin + rect.Ymax) / 2.0), new Point2D.Double((double)(rect.Xmin + rect.Xmax) / 2.0, (double)(rect.Ymin + rect.Ymax) / 2.0), new Point2D.Double(rect.Xmax, (double)(rect.Ymin + rect.Ymax) / 2.0), new Point2D.Double(rect.Xmin, rect.Ymax), new Point2D.Double((double)(rect.Xmin + rect.Xmax) / 2.0, rect.Ymax), new Point2D.Double(rect.Xmax, rect.Ymax)};
                                Point2D nearestPoint = null;
                                double distance = Double.MAX_VALUE;
                                for (Point2D p : importantPoints) {
                                    Point2D windowPoint = matrix.transform(p);
                                    double d2 = windowPoint.distance(cursorPos);
                                    if (!(d2 < distance)) continue;
                                    distance = d2;
                                    nearestPoint = windowPoint;
                                }
                                if (distance < 15.0) {
                                    ImagePanel.this.touchPointOffset = new DisplayPoint((int)Math.round(nearestPoint.getX() - ((Point2D)cursorPos).getX()), (int)Math.round(nearestPoint.getY() - ((Point2D)cursorPos).getY()));
                                } else {
                                    ImagePanel.this.touchPointOffset = new DisplayPoint(0, 0);
                                }
                            }
                        }
                        if (!ImagePanel.this.autoPlayed) {
                            Configuration.autoPlayPreviews.set((Object)true);
                            ImagePanel.this.autoPlayed = true;
                            ImagePanel.this.play();
                        }
                    }
                    IconPanel.this.requestFocusInWindow();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        Rectangle2D selectionRect;
                        if (ImagePanel.this.hilightedPoints != null) {
                            selectionRect = IconPanel.this.getSelectionRect();
                            if (selectionRect != null) {
                                ArrayList newSelectedPoints = new ArrayList();
                                for (int i = 0; i < ImagePanel.this.hilightedPoints.size(); ++i) {
                                    DisplayPoint p = (DisplayPoint)ImagePanel.this.hilightedPoints.get(i);
                                    Point2D ip = ImagePanel.this.toImagePoint(new Point2D.Double(p.x, p.y));
                                    if (!selectionRect.contains(ip)) continue;
                                    newSelectedPoints.add(i);
                                }
                                if (IconPanel.this.shiftDown) {
                                    Iterator i = ImagePanel.this.selectedPoints.iterator();
                                    while (i.hasNext()) {
                                        int p = (Integer)i.next();
                                        if (newSelectedPoints.contains(p)) continue;
                                        newSelectedPoints.add(p);
                                    }
                                }
                                ImagePanel.this.selectedPoints = newSelectedPoints;
                                ImagePanel.this.calculatePointsXY();
                            }
                            if (IconPanel.this.ctrlDown && !ImagePanel.this.pathPointsUnderCursor.isEmpty()) {
                                for (DistanceItem di : ImagePanel.this.pathPointsUnderCursor) {
                                    ImagePanel.this.fireEdgeSplit(di.pathPoint, di.pathPosition);
                                }
                                ImagePanel.this.selectedPoints.clear();
                                ImagePanel.this.pointsUnderCursor.clear();
                                ImagePanel.this.pathPointsUnderCursor.clear();
                                IconPanel.this.repaint();
                            }
                            ImagePanel.this.updateScrollBarMinMax();
                        }
                        if (IconPanel.this.dragStart != null && !ImagePanel.this.inMoving && ImagePanel.this.multiSelect && (selectionRect = IconPanel.this.getSelectionRect()) != null) {
                            Frame fr = ImagePanel.this.timelined.getTimeline().getFrame(ImagePanel.this.frame);
                            ArrayList<Integer> newSelectedDepths = new ArrayList<Integer>();
                            if (fr != null) {
                                Iterator p = fr.layers.keySet().iterator();
                                while (p.hasNext()) {
                                    int d = (Integer)p.next();
                                    DepthState ds = (DepthState)fr.layers.get(d);
                                    CharacterTag cht = ds.getCharacter();
                                    if (!(cht instanceof DrawableTag)) continue;
                                    DrawableTag dt = (DrawableTag)cht;
                                    int drawableFrameCount = dt.getNumFrames();
                                    if (drawableFrameCount == 0) {
                                        drawableFrameCount = 1;
                                    }
                                    double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                                    Matrix m = new Matrix();
                                    m.translate(-((ImagePanel)ImagePanel.this)._viewRect.xMin * zoomDouble, -((ImagePanel)ImagePanel.this)._viewRect.yMin * zoomDouble);
                                    m.scale(zoomDouble);
                                    Matrix transformation = Matrix.getScaleInstance((double)0.05).concatenate(m.concatenate(new Matrix(ds.matrix)));
                                    RECT dtRect = dt.getRect();
                                    Rectangle2D.Double dtRect2D = new Rectangle2D.Double(dtRect.Xmin, dtRect.Ymin, dtRect.getWidth(), dtRect.getHeight());
                                    Shape outline = transformation.toTransform().createTransformedShape(dtRect2D);
                                    Rectangle bounds = outline.getBounds();
                                    if (!selectionRect.contains(bounds)) continue;
                                    newSelectedDepths.add(d);
                                }
                                if (ImagePanel.this.transformSelectionMode) {
                                    ImagePanel.this.freeTransformDepths(newSelectedDepths);
                                } else {
                                    ImagePanel.this.selectDepths(newSelectedDepths);
                                }
                                ImagePanel.this.firePlaceObjectSelected();
                            }
                        }
                        IconPanel.this.dragStart = null;
                        IconPanel.this.selectionEnd = null;
                        ImagePanel.this.inMoving = false;
                        ImagePanel.this.touchPointOffset = null;
                        ImagePanel.this.snapAlignXPoint1 = null;
                        ImagePanel.this.snapAlignXPoint2 = null;
                        ImagePanel.this.snapAlignYPoint1 = null;
                        ImagePanel.this.snapAlignYPoint2 = null;
                        if ((ImagePanel.this.doFreeTransform && ImagePanel.this.mode != 0 || ImagePanel.this.selectionMode && ImagePanel.this.transform != null) && ImagePanel.this.registrationPointUpdated != null && ImagePanel.this.transformUpdated != null) {
                            Object object = ImagePanel.this.lock;
                            synchronized (object) {
                                boolean isResize;
                                Rectangle2D transBoundsBefore = ImagePanel.this.getTransformBounds();
                                Point2D transRegPointBefore = ImagePanel.this.registrationPoint;
                                Point transRegPointBeforeTwip = new Point((int)Math.round(transRegPointBefore.getX() - transBoundsBefore.getX()), (int)Math.round(transRegPointBefore.getY() - transBoundsBefore.getY()));
                                Point2D.Double transRegPointPercentBefore = new Point2D.Double(transRegPointBeforeTwip.getX() / transBoundsBefore.getWidth(), transRegPointBeforeTwip.getY() / transBoundsBefore.getHeight());
                                ImagePanel.this.registrationPoint = new Point2D.Double(ImagePanel.this.registrationPointUpdated.getX(), ImagePanel.this.registrationPointUpdated.getY());
                                ImagePanel.this.transform = new Matrix(ImagePanel.this.transformUpdated);
                                ImagePanel.this.transformUpdated = null;
                                Rectangle2D transBoundsAfter = ImagePanel.this.getTransformBounds();
                                Point2D transRegPointAfter = ImagePanel.this.registrationPoint;
                                Point transRegPointAfterTwip = new Point((int)Math.round(transRegPointAfter.getX() - transBoundsAfter.getX()), (int)Math.round(transRegPointAfter.getY() - transBoundsAfter.getY()));
                                Point2D.Double transRegPointPercentAfter = new Point2D.Double(transRegPointAfterTwip.getX() / transBoundsAfter.getWidth(), transRegPointAfterTwip.getY() / transBoundsAfter.getHeight());
                                boolean bl = isResize = ImagePanel.this.mode == 11 || ImagePanel.this.mode == 7 || ImagePanel.this.mode == 6 || ImagePanel.this.mode == 8 || ImagePanel.this.mode == 5 || ImagePanel.this.mode == 4 || ImagePanel.this.mode == 9 || ImagePanel.this.mode == 10;
                                if (!isResize && ImagePanel.this.mode != 0 && !transRegPointPercentBefore.equals(transRegPointPercentAfter)) {
                                    ImagePanel.this.registrationPointPosition = null;
                                }
                            }
                            IconPanel.this.calcRect();
                            ImagePanel.this.fireBoundsChange(ImagePanel.this.getTransformBounds(), ImagePanel.this.registrationPoint, ImagePanel.this.registrationPointPosition);
                            ImagePanel.this.fireTransformChanged();
                            IconPanel.this.repaint();
                        }
                        if (!ImagePanel.this.selectionMode || !ImagePanel.this.doFreeTransform) {
                            // empty if block
                        }
                        if (ImagePanel.this.mode != -9 && ImagePanel.this.mode != -10) {
                            ImagePanel.this.mode = 0;
                        }
                        ImagePanel.this.snapOffset = new Point2D.Double(0.0, 0.0);
                    }
                }

                private void stopDragging() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseDragged(MouseEvent e) {
                    double ex;
                    Point2D mouseTransPoint;
                    Matrix parentMatrix;
                    Object snapOffsetX;
                    List points = ImagePanel.this.hilightedPoints;
                    if (IconPanel.this.dragStart != null && ImagePanel.this.multiSelect && !ImagePanel.this.inMoving && ImagePanel.this.mode == 0) {
                        IconPanel.this.selectionEnd = e.getPoint();
                        IconPanel.this.repaint();
                        return;
                    }
                    if (IconPanel.this.dragStart != null && (ImagePanel.this.selectionMode || ImagePanel.this.doFreeTransform && ImagePanel.this.mode == 13 || points != null && !ImagePanel.this.selectedPoints.isEmpty() && !ImagePanel.this.pointsUnderCursor.isEmpty())) {
                        CharacterTag ch;
                        Frame fr;
                        Point2D.Double touchPointPos = new Point2D.Double(e.getX(), e.getY());
                        if (ImagePanel.this.touchPointOffset != null) {
                            touchPointPos = new Point2D.Double(e.getX() + ((ImagePanel)ImagePanel.this).touchPointOffset.x, e.getY() + ((ImagePanel)ImagePanel.this).touchPointOffset.y);
                        }
                        snapOffsetX = null;
                        Double snapOffsetY = null;
                        double zoomDouble = ImagePanel.this.getRealZoom();
                        Matrix parentMatrix2 = ImagePanel.this.getParentMatrix();
                        if (((Boolean)Configuration.snapAlign.get()).booleanValue() && ImagePanel.this.timelined != null && points == null && ImagePanel.this.transform != null && (fr = ImagePanel.this.timelined.getTimeline().getFrame(ImagePanel.this.frame)) != null) {
                            Timeline timeline = ImagePanel.this.timelined.getTimeline();
                            Point2D mouseTransPoint2 = ImagePanel.this.toTransformPoint(new Point2D.Double(e.getX(), e.getY()));
                            double ex2 = mouseTransPoint2.getX();
                            double ey = mouseTransPoint2.getY();
                            Point2D dragStartTransPoint = ImagePanel.this.toTransformPoint(IconPanel.this.dragStart);
                            double dsx = dragStartTransPoint.getX();
                            double dsy = dragStartTransPoint.getY();
                            double deltaX = ex2 - dsx;
                            double deltaY = ey - dsy;
                            AffineTransform newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            AffineTransform t = parentMatrix2.toTransform();
                            t.translate(deltaX, deltaY);
                            AffineTransform tx = parentMatrix2.inverse().toTransform();
                            t.concatenate(tx);
                            newTransform.preConcatenate(t);
                            Rectangle2D selectedBounds = null;
                            for (int i = 0; i < ImagePanel.this.selectedDepths.size(); ++i) {
                                CharacterTag cht;
                                int selectedDepth = (Integer)ImagePanel.this.selectedDepths.get(i);
                                DepthState ds = null;
                                if (selectedDepth > -1 && timeline.getFrameCount() > ImagePanel.this.frame && fr != null) {
                                    ds = (DepthState)fr.layers.get(selectedDepth);
                                }
                                if (ds == null || (cht = ds.getCharacter()) == null || !(cht instanceof BoundedTag)) continue;
                                BoundedTag bt = (BoundedTag)cht;
                                RECT rect = bt.getRect();
                                Matrix matrix = ImagePanel.this.toImageMatrix(new Matrix(newTransform));
                                if (ds.matrix != null) {
                                    matrix = matrix.concatenate(new Matrix(ds.matrix));
                                }
                                Rectangle2D bounds = matrix.transform((Rectangle2D)new Rectangle2D.Double(rect.Xmin, rect.Ymin, rect.Xmax - rect.Xmin, rect.Ymax - rect.Ymin));
                                if (selectedBounds == null) {
                                    selectedBounds = bounds;
                                    continue;
                                }
                                selectedBounds.add(bounds);
                            }
                            if (selectedBounds != null) {
                                boolean snapAlignedX = false;
                                boolean snapAlignedY = false;
                                if (ImagePanel.this.timelined instanceof SWF) {
                                    RECT stageRect = ImagePanel.this.timelined.getRect();
                                    stageRect = new RECT((int)Math.round((double)stageRect.Xmin + (double)((Integer)Configuration.snapAlignStageBorder.get()).intValue() * 20.0), (int)Math.round((double)stageRect.Xmax - (double)((Integer)Configuration.snapAlignStageBorder.get()).intValue() * 20.0), (int)Math.round((double)stageRect.Ymin + (double)((Integer)Configuration.snapAlignStageBorder.get()).intValue() * 20.0), (int)Math.round((double)stageRect.Ymax - (double)((Integer)Configuration.snapAlignStageBorder.get()).intValue() * 20.0));
                                    Matrix scaleMatrix = Matrix.getScaleInstance((double)(zoomDouble / 20.0));
                                    Matrix matrix = new Matrix();
                                    matrix = matrix.concatenate(Matrix.getTranslateInstance((double)ImagePanel.this.offsetPoint.getX(), (double)ImagePanel.this.offsetPoint.getY()));
                                    Rectangle2D bounds = (matrix = matrix.concatenate(scaleMatrix)).transform((Rectangle2D)new Rectangle2D.Double(stageRect.Xmin, stageRect.Ymin, stageRect.getWidth(), stageRect.getHeight()));
                                    if (Math.abs(bounds.getMinX() - selectedBounds.getMinX()) < 5.0) {
                                        snapOffsetX = bounds.getMinX() - selectedBounds.getMinX();
                                        ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(selectedBounds.getMinY() - 50.0));
                                        ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(selectedBounds.getMaxY() + 50.0));
                                        snapAlignedX = true;
                                    } else if (Math.abs(bounds.getMaxX() - selectedBounds.getMinX()) < 5.0) {
                                        snapOffsetX = bounds.getMaxX() - selectedBounds.getMinX();
                                        ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(selectedBounds.getMinY() - 50.0));
                                        ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(selectedBounds.getMaxY() + 50.0));
                                        snapAlignedX = true;
                                    } else if (Math.abs(bounds.getMaxX() - selectedBounds.getMaxX()) < 5.0) {
                                        snapOffsetX = bounds.getMaxX() - selectedBounds.getMaxX();
                                        ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(selectedBounds.getMinY() - 50.0));
                                        ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(selectedBounds.getMaxY() + 50.0));
                                        snapAlignedX = true;
                                    } else if (Math.abs(bounds.getMinX() - selectedBounds.getMaxX()) < 5.0) {
                                        snapOffsetX = bounds.getMinX() - selectedBounds.getMaxX();
                                        ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(selectedBounds.getMinY() - 50.0));
                                        ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(selectedBounds.getMaxY() + 50.0));
                                        snapAlignedX = true;
                                    }
                                    if (Math.abs(bounds.getMinY() - selectedBounds.getMinY()) < 5.0) {
                                        snapOffsetY = bounds.getMinY() - selectedBounds.getMinY();
                                        ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(selectedBounds.getMinX() - 50.0), (int)Math.round(bounds.getMinY()));
                                        ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(selectedBounds.getMaxX() + 50.0), (int)Math.round(bounds.getMinY()));
                                        snapAlignedY = true;
                                    } else if (Math.abs(bounds.getMaxY() - selectedBounds.getMinY()) < 5.0) {
                                        snapOffsetY = bounds.getMaxY() - selectedBounds.getMinY();
                                        ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(selectedBounds.getMinX() - 50.0), (int)Math.round(bounds.getMaxY()));
                                        ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(selectedBounds.getMaxX() + 50.0), (int)Math.round(bounds.getMaxY()));
                                        snapAlignedY = true;
                                    } else if (Math.abs(bounds.getMaxY() - selectedBounds.getMaxY()) < 5.0) {
                                        snapOffsetY = bounds.getMaxY() - selectedBounds.getMaxY();
                                        ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(selectedBounds.getMinX() - 50.0), (int)Math.round(bounds.getMaxY()));
                                        ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(selectedBounds.getMaxX() + 50.0), (int)Math.round(bounds.getMaxY()));
                                        snapAlignedY = true;
                                    } else if (Math.abs(bounds.getMinY() - selectedBounds.getMaxY()) < 5.0) {
                                        snapOffsetY = bounds.getMinY() - selectedBounds.getMaxY();
                                        ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(selectedBounds.getMinX() - 50.0), (int)Math.round(bounds.getMinY()));
                                        ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(selectedBounds.getMaxX() + 50.0), (int)Math.round(bounds.getMinY()));
                                        snapAlignedY = true;
                                    }
                                }
                                for (DepthState ds : fr.layers.values()) {
                                    CharacterTag ct;
                                    if (ImagePanel.this.selectedDepths.contains(ds.depth) || (ct = ds.getCharacter()) == null || !(ct instanceof BoundedTag)) continue;
                                    BoundedTag bt = (BoundedTag)ct;
                                    RECT rect = bt.getRect();
                                    Matrix scaleMatrix = Matrix.getScaleInstance((double)(zoomDouble / 20.0));
                                    Matrix translateMatrix = Matrix.getTranslateInstance((double)ImagePanel.this.offsetPoint.getX(), (double)ImagePanel.this.offsetPoint.getY());
                                    Matrix matrix = translateMatrix.concatenate(scaleMatrix);
                                    Matrix dsMatrix = new Matrix();
                                    if (ds.matrix != null) {
                                        dsMatrix = new Matrix(ds.matrix);
                                    }
                                    dsMatrix = dsMatrix.concatenate(parentMatrix2);
                                    Rectangle2D bounds = dsMatrix.transform((Rectangle2D)new Rectangle2D.Double(rect.Xmin, rect.Ymin, rect.Xmax - rect.Xmin, rect.Ymax - rect.Ymin));
                                    bounds = new Rectangle2D.Double(bounds.getX() - (double)((Integer)Configuration.snapAlignObjectHorizontalSpace.get()).intValue() * 20.0, bounds.getY() - (double)((Integer)Configuration.snapAlignObjectVerticalSpace.get()).intValue() * 20.0, bounds.getWidth() + (double)(2 * (Integer)Configuration.snapAlignObjectHorizontalSpace.get()) * 20.0, bounds.getHeight() + (double)(2 * (Integer)Configuration.snapAlignObjectVerticalSpace.get()) * 20.0);
                                    bounds = matrix.transform(bounds);
                                    if (!snapAlignedX) {
                                        if (((Boolean)Configuration.snapAlignCenterAlignmentVertical.get()).booleanValue() && Math.abs(bounds.getCenterX() - selectedBounds.getCenterX()) < 5.0) {
                                            snapOffsetX = bounds.getCenterX() - selectedBounds.getCenterX();
                                            ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getCenterX()), (int)Math.round(Math.min(bounds.getMinY(), selectedBounds.getMinY()) - 50.0));
                                            ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getCenterX()), (int)Math.round(Math.max(bounds.getMaxY(), selectedBounds.getMaxY()) + 50.0));
                                            snapAlignedX = true;
                                        } else if (Math.abs(bounds.getMinX() - selectedBounds.getMinX()) < 5.0) {
                                            snapOffsetX = bounds.getMinX() - selectedBounds.getMinX();
                                            ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(Math.min(bounds.getMinY(), selectedBounds.getMinY()) - 50.0));
                                            ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(Math.max(bounds.getMaxY(), selectedBounds.getMaxY()) + 50.0));
                                            snapAlignedX = true;
                                        } else if (Math.abs(bounds.getMaxX() - selectedBounds.getMinX()) < 5.0) {
                                            snapOffsetX = bounds.getMaxX() - selectedBounds.getMinX();
                                            ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(Math.min(bounds.getMinY(), selectedBounds.getMinY()) - 50.0));
                                            ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(Math.max(bounds.getMaxY(), selectedBounds.getMaxY()) + 50.0));
                                            snapAlignedX = true;
                                        } else if (Math.abs(bounds.getMaxX() - selectedBounds.getMaxX()) < 5.0) {
                                            snapOffsetX = bounds.getMaxX() - selectedBounds.getMaxX();
                                            ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(Math.min(bounds.getMinY(), selectedBounds.getMinY()) - 50.0));
                                            ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMaxX()), (int)Math.round(Math.max(bounds.getMaxY(), selectedBounds.getMaxY()) + 50.0));
                                            snapAlignedX = true;
                                        } else if (Math.abs(bounds.getMinX() - selectedBounds.getMaxX()) < 5.0) {
                                            snapOffsetX = bounds.getMinX() - selectedBounds.getMaxX();
                                            ImagePanel.this.snapAlignXPoint1 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(Math.min(bounds.getMinY(), selectedBounds.getMinY()) - 50.0));
                                            ImagePanel.this.snapAlignXPoint2 = new DisplayPoint((int)Math.round(bounds.getMinX()), (int)Math.round(Math.max(bounds.getMaxY(), selectedBounds.getMaxY()) + 50.0));
                                            snapAlignedX = true;
                                        }
                                    }
                                    if (!snapAlignedY) {
                                        if (((Boolean)Configuration.snapAlignCenterAlignmentHorizontal.get()).booleanValue() && Math.abs(bounds.getCenterY() - selectedBounds.getCenterY()) < 5.0) {
                                            snapOffsetY = bounds.getCenterY() - selectedBounds.getCenterY();
                                            ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(Math.min(bounds.getMinX(), selectedBounds.getMinX()) - 50.0), (int)Math.round(bounds.getCenterY()));
                                            ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(Math.max(bounds.getMaxX(), selectedBounds.getMaxX()) + 50.0), (int)Math.round(bounds.getCenterY()));
                                            snapAlignedY = true;
                                        } else if (Math.abs(bounds.getMinY() - selectedBounds.getMinY()) < 5.0) {
                                            snapOffsetY = bounds.getMinY() - selectedBounds.getMinY();
                                            ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(Math.min(bounds.getMinX(), selectedBounds.getMinX()) - 50.0), (int)Math.round(bounds.getMinY()));
                                            ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(Math.max(bounds.getMaxX(), selectedBounds.getMaxX()) + 50.0), (int)Math.round(bounds.getMinY()));
                                            snapAlignedY = true;
                                        } else if (Math.abs(bounds.getMaxY() - selectedBounds.getMinY()) < 5.0) {
                                            snapOffsetY = bounds.getMaxY() - selectedBounds.getMinY();
                                            ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(Math.min(bounds.getMinX(), selectedBounds.getMinX()) - 50.0), (int)Math.round(bounds.getMaxY()));
                                            ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(Math.max(bounds.getMaxX(), selectedBounds.getMaxX()) + 50.0), (int)Math.round(bounds.getMaxY()));
                                            snapAlignedY = true;
                                        } else if (Math.abs(bounds.getMaxY() - selectedBounds.getMaxY()) < 5.0) {
                                            snapOffsetY = bounds.getMaxY() - selectedBounds.getMaxY();
                                            ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(Math.min(bounds.getMinX(), selectedBounds.getMinX()) - 50.0), (int)Math.round(bounds.getMaxY()));
                                            ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(Math.max(bounds.getMaxX(), selectedBounds.getMaxX()) + 50.0), (int)Math.round(bounds.getMaxY()));
                                            snapAlignedY = true;
                                        } else if (Math.abs(bounds.getMinY() - selectedBounds.getMaxY()) < 5.0) {
                                            snapOffsetY = bounds.getMinY() - selectedBounds.getMaxY();
                                            ImagePanel.this.snapAlignYPoint1 = new DisplayPoint((int)Math.round(Math.min(bounds.getMinX(), selectedBounds.getMinX()) - 50.0), (int)Math.round(bounds.getMinY()));
                                            ImagePanel.this.snapAlignYPoint2 = new DisplayPoint((int)Math.round(Math.max(bounds.getMaxX(), selectedBounds.getMaxX()) + 50.0), (int)Math.round(bounds.getMinY()));
                                            snapAlignedY = true;
                                        }
                                    }
                                    if (!snapAlignedX || !snapAlignedY) continue;
                                    break;
                                }
                                if (!snapAlignedX) {
                                    ImagePanel.this.snapAlignXPoint1 = null;
                                    ImagePanel.this.snapAlignXPoint2 = null;
                                }
                                if (!snapAlignedY) {
                                    ImagePanel.this.snapAlignYPoint1 = null;
                                    ImagePanel.this.snapAlignYPoint2 = null;
                                }
                            }
                        }
                        if (((Boolean)Configuration.snapToObjects.get()).booleanValue() && ImagePanel.this.depthStateUnderCursor != null && !ImagePanel.this.selectedDepths.contains(((ImagePanel)ImagePanel.this).depthStateUnderCursor.depth) && (ch = ImagePanel.this.depthStateUnderCursor.getCharacter()) != null && ch instanceof BoundedTag) {
                            BoundedTag bt = (BoundedTag)ch;
                            RECT rect = bt.getRect();
                            Matrix matrix = new Matrix();
                            if (((ImagePanel)ImagePanel.this).depthStateUnderCursor.matrix != null) {
                                matrix = matrix.preConcatenate(new Matrix(((ImagePanel)ImagePanel.this).depthStateUnderCursor.matrix));
                            }
                            matrix = matrix.concatenate(parentMatrix2);
                            Matrix scaleMatrix = Matrix.getScaleInstance((double)(zoomDouble / 20.0));
                            matrix = matrix.preConcatenate(scaleMatrix);
                            matrix = matrix.preConcatenate(Matrix.getTranslateInstance((double)ImagePanel.this.offsetPoint.getX(), (double)ImagePanel.this.offsetPoint.getY()));
                            Point2D[] importantPoints = new Point2D[]{new Point2D.Double(rect.Xmin, rect.Ymin), new Point2D.Double((double)(rect.Xmin + rect.Xmax) / 2.0, rect.Ymin), new Point2D.Double(rect.Xmax, rect.Ymin), new Point2D.Double(rect.Xmin, (double)(rect.Ymin + rect.Ymax) / 2.0), new Point2D.Double((double)(rect.Xmin + rect.Xmax) / 2.0, (double)(rect.Ymin + rect.Ymax) / 2.0), new Point2D.Double(rect.Xmax, (double)(rect.Ymin + rect.Ymax) / 2.0), new Point2D.Double(rect.Xmin, rect.Ymax), new Point2D.Double((double)(rect.Xmin + rect.Xmax) / 2.0, rect.Ymax), new Point2D.Double(rect.Xmax, rect.Ymax)};
                            Point2D nearestPoint = null;
                            double distance = Double.MAX_VALUE;
                            for (Point2D p : importantPoints) {
                                Point2D windowPoint = matrix.transform(p);
                                double d = windowPoint.distance(touchPointPos);
                                if (!(d < distance)) continue;
                                distance = d;
                                nearestPoint = windowPoint;
                            }
                            if (distance < 10.0) {
                                snapOffsetX = nearestPoint.getX() - ((Point2D)touchPointPos).getX();
                                snapOffsetY = nearestPoint.getY() - ((Point2D)touchPointPos).getY();
                            }
                        }
                        if (((Boolean)Configuration.snapToGuides.get()).booleanValue()) {
                            double d;
                            if (snapOffsetX == null) {
                                Double nearestGuideX = null;
                                double distance = Double.MAX_VALUE;
                                for (Double gx : ImagePanel.this.guidesX) {
                                    d = Math.abs((gx = Double.valueOf(gx * zoomDouble + ImagePanel.this.offsetPoint.getX())) - ((Point2D)touchPointPos).getX());
                                    if (!(d < distance)) continue;
                                    distance = d;
                                    nearestGuideX = gx;
                                }
                                if (distance < (double)ImagePanel.getSnapGuidesDistance()) {
                                    snapOffsetX = nearestGuideX - ((Point2D)touchPointPos).getX();
                                }
                            }
                            if (snapOffsetY == null) {
                                Double nearestGuideY = null;
                                double distance = Double.MAX_VALUE;
                                for (Double gy : ImagePanel.this.guidesY) {
                                    d = Math.abs((gy = Double.valueOf(gy * zoomDouble + ImagePanel.this.offsetPoint.getY())) - ((Point2D)touchPointPos).getY());
                                    if (!(d < distance)) continue;
                                    distance = d;
                                    nearestGuideY = gy;
                                }
                                if (distance < (double)ImagePanel.getSnapGuidesDistance()) {
                                    snapOffsetY = nearestGuideY - ((Point2D)touchPointPos).getY();
                                }
                            }
                        }
                        if (((Boolean)Configuration.showGrid.get()).booleanValue() && ((Boolean)Configuration.snapToGrid.get()).booleanValue()) {
                            if (snapOffsetX == null) {
                                int d;
                                int positionPxX = (int)Math.round((((Point2D)touchPointPos).getX() - ImagePanel.this.offsetPoint.getX()) / zoomDouble);
                                if ((double)(positionPxX - (d = positionPxX / (Integer)Configuration.gridHorizontalSpace.get() * (Integer)Configuration.gridHorizontalSpace.get())) * zoomDouble < (double)ImagePanel.getSnapGridDistance()) {
                                    snapOffsetX = (double)d * zoomDouble - ((Point2D)touchPointPos).getX() + ImagePanel.this.offsetPoint.getX();
                                } else if ((double)(d + (Integer)Configuration.gridHorizontalSpace.get() - positionPxX) * zoomDouble < (double)ImagePanel.getSnapGridDistance()) {
                                    snapOffsetX = (double)(d + (Integer)Configuration.gridHorizontalSpace.get()) * zoomDouble - ((Point2D)touchPointPos).getX() + ImagePanel.this.offsetPoint.getX();
                                }
                            }
                            if (snapOffsetY == null) {
                                int d;
                                int positionPxY = (int)Math.round((((Point2D)touchPointPos).getY() - ImagePanel.this.offsetPoint.getY()) / zoomDouble);
                                if ((double)(positionPxY - (d = positionPxY / (Integer)Configuration.gridVerticalSpace.get() * (Integer)Configuration.gridVerticalSpace.get())) * zoomDouble < (double)ImagePanel.getSnapGridDistance()) {
                                    snapOffsetY = (double)d * zoomDouble - ((Point2D)touchPointPos).getY() + ImagePanel.this.offsetPoint.getY();
                                } else if ((double)(d + (Integer)Configuration.gridVerticalSpace.get() - positionPxY) * zoomDouble < (double)ImagePanel.getSnapGridDistance()) {
                                    snapOffsetY = (double)(d + (Integer)Configuration.gridVerticalSpace.get()) * zoomDouble - ((Point2D)touchPointPos).getY() + ImagePanel.this.offsetPoint.getY();
                                }
                            }
                        }
                        if (((Boolean)Configuration.snapToPixels.get()).booleanValue()) {
                            if (snapOffsetX == null) {
                                int positionPxX = (int)Math.round((((Point2D)touchPointPos).getX() - ImagePanel.this.offsetPoint.getX()) / zoomDouble);
                                snapOffsetX = (double)positionPxX * zoomDouble - ((Point2D)touchPointPos).getX() + ImagePanel.this.offsetPoint.getX();
                            }
                            if (snapOffsetY == null) {
                                int positionPxY = (int)Math.round((((Point2D)touchPointPos).getY() - ImagePanel.this.offsetPoint.getY()) / zoomDouble);
                                snapOffsetY = (double)positionPxY * zoomDouble - ((Point2D)touchPointPos).getY() + ImagePanel.this.offsetPoint.getY();
                            }
                        }
                        if (snapOffsetX == null) {
                            snapOffsetX = 0.0;
                        }
                        if (snapOffsetY == null) {
                            snapOffsetY = 0.0;
                        }
                        ImagePanel.this.snapOffset = new Point2D.Double((Double)snapOffsetX, snapOffsetY);
                    }
                    if (IconPanel.this.dragStart != null && points != null) {
                        if (ImagePanel.this.pointsUnderCursor.isEmpty()) {
                            IconPanel.this.selectionEnd = e.getPoint();
                            ImagePanel.this.redraw();
                        }
                        if (!ImagePanel.this.selectedPoints.isEmpty() && !ImagePanel.this.pointsUnderCursor.isEmpty()) {
                            boolean selectedUnderCursor = false;
                            snapOffsetX = ImagePanel.this.pointsUnderCursor.iterator();
                            while (snapOffsetX.hasNext()) {
                                int p = (Integer)snapOffsetX.next();
                                if (!ImagePanel.this.selectedPoints.contains(p)) continue;
                                selectedUnderCursor = true;
                                break;
                            }
                            if (!selectedUnderCursor) {
                                return;
                            }
                            for (int i = 0; i < ImagePanel.this.selectedPoints.size(); ++i) {
                                int pointIndex = (Integer)ImagePanel.this.selectedPoints.get(i);
                                DisplayPoint pointStart = (DisplayPoint)ImagePanel.this.selectedPointsOriginalValues.get(i);
                                Point2D.Double dragEnd = new Point2D.Double((double)e.getX() + ImagePanel.this.snapOffset.getX(), (double)e.getY() + ImagePanel.this.snapOffset.getY());
                                Point2D startTransformPoint = ImagePanel.this.toTransformPoint(IconPanel.this.dragStart);
                                Point2D endTransformPoint = ImagePanel.this.toTransformPoint(dragEnd);
                                Point2D.Double delta = new Point2D.Double(endTransformPoint.getX() - startTransformPoint.getX(), endTransformPoint.getY() - startTransformPoint.getY());
                                DisplayPoint newPoint = new DisplayPoint((int)Math.round((double)pointStart.x + ((Point2D)delta).getX()), (int)Math.round((double)pointStart.y + ((Point2D)delta).getY()), pointStart.onPath);
                                points.set(pointIndex, newPoint);
                            }
                            ImagePanel.this.firePointsUpdated(points);
                            ImagePanel.this.calculatePointsXY();
                            IconPanel.this.repaint();
                            return;
                        }
                    }
                    if (IconPanel.this.dragStart != null && IconPanel.this.allowMove && ImagePanel.this.mode == 0 && !ImagePanel.this.selectingText) {
                        Point dragEnd = e.getPoint();
                        Point2D.Double delta = new Point2D.Double(((Point2D)dragEnd).getX() - IconPanel.this.dragStart.getX(), ((Point2D)dragEnd).getY() - IconPanel.this.dragStart.getY());
                        Point2D regPointImage = ImagePanel.this.registrationPoint == null ? null : ImagePanel.this.toImagePoint(ImagePanel.this.registrationPoint);
                        ImagePanel.this.offsetPoint.setLocation(ImagePanel.this.offsetPoint.getX() + ((Point2D)delta).getX(), ImagePanel.this.offsetPoint.getY() + ((Point2D)delta).getY());
                        ImagePanel.this.updateScrollBars();
                        ExportRectangle oldViewRect = new ExportRectangle(ImagePanel.this._viewRect);
                        IconPanel.this.dragStart = dragEnd;
                        ImagePanel.this.iconPanel.calcRect();
                        ImagePanel.this._viewRect = ImagePanel.this.getViewRect();
                        double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                        Object object = ImagePanel.this.lock;
                        synchronized (object) {
                            if (ImagePanel.this.transform != null && ImagePanel.this.registrationPoint != null) {
                                Point2D.Double regPointImageUpdated = new Point2D.Double(regPointImage.getX() + ((Point2D)delta).getX(), regPointImage.getY() + ((Point2D)delta).getY());
                                ImagePanel.this.registrationPoint = ImagePanel.this.toTransformPoint(regPointImageUpdated);
                            }
                        }
                        IconPanel.this.repaint();
                        return;
                    }
                    if (IconPanel.this.dragStart != null && ImagePanel.this.selectionMode && !ImagePanel.this.doFreeTransform) {
                        if (ImagePanel.this.transform == null) {
                            return;
                        }
                        parentMatrix = ImagePanel.this.getParentMatrix();
                        mouseTransPoint = ImagePanel.this.toTransformPoint(new Point2D.Double((double)e.getX() + ImagePanel.this.snapOffset.getX(), (double)e.getY() + ImagePanel.this.snapOffset.getY()));
                        Point2D mouseTransPointNoSnapOffset = ImagePanel.this.toTransformPoint(new Point2D.Double(e.getX(), e.getY()));
                        ex = mouseTransPoint.getX();
                        double ey = mouseTransPoint.getY();
                        Point2D dragStartTransPoint = ImagePanel.this.toTransformPoint(IconPanel.this.dragStart);
                        double dsx = dragStartTransPoint.getX();
                        double dsy = dragStartTransPoint.getY();
                        double deltaX = ex - dsx;
                        double deltaY = ey - dsy;
                        AffineTransform newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                        AffineTransform t = parentMatrix.toTransform();
                        t.translate(deltaX, deltaY);
                        AffineTransform tx = parentMatrix.inverse().toTransform();
                        t.concatenate(tx);
                        newTransform.preConcatenate(t);
                        Point2D newRegistrationPoint = new Matrix(t).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                        ImagePanel.this.transformUpdated = newTransform;
                        ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                        IconPanel.this.repaint();
                        return;
                    }
                    if (IconPanel.this.dragStart != null && ImagePanel.this.doFreeTransform) {
                        Point2D newRegistrationPoint;
                        AffineTransform t;
                        AffineTransform newTransform;
                        Point2D newRegistrationPoint2;
                        AffineTransform t2;
                        AffineTransform newTransform2;
                        Point2D newRegistrationPoint3;
                        AffineTransform t3;
                        Point2D newRegistrationPoint4;
                        Point2D bStart;
                        AffineTransform newTransform3;
                        if (ImagePanel.this.transform == null) {
                            return;
                        }
                        parentMatrix = ImagePanel.this.getParentMatrix();
                        mouseTransPoint = ImagePanel.this.toTransformPoint(new Point2D.Double(e.getX(), e.getY()));
                        Point2D mouseTransPointSnapped = ImagePanel.this.toTransformPoint(new Point2D.Double((double)e.getX() + ImagePanel.this.snapOffset.getX(), (double)e.getY() + ImagePanel.this.snapOffset.getY()));
                        ex = mouseTransPoint.getX();
                        double ey = mouseTransPoint.getY();
                        double exSnapped = mouseTransPointSnapped.getX();
                        double eySnapped = mouseTransPointSnapped.getY();
                        Point2D dragStartTransPoint = ImagePanel.this.toTransformPoint(IconPanel.this.dragStart);
                        Point2D parentRegistrationPoint = parentMatrix.transform(ImagePanel.this.registrationPoint);
                        double dsx = dragStartTransPoint.getX();
                        double dsy = dragStartTransPoint.getY();
                        if (ImagePanel.this.mode == -7) {
                            double shearX = -(ex - dsx) / ImagePanel.this.bounds.getHeight();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            AffineTransform t4 = new AffineTransform();
                            bStart = parentMatrix.transform((Point2D)new Point2D.Double(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY()));
                            t4.translate(bStart.getX(), bStart.getY());
                            t4.shear(shearX, 0.0);
                            t4.translate(-bStart.getX(), -bStart.getY());
                            t4.translate(ex - dsx, 0.0);
                            newTransform3.preConcatenate(t4);
                            newRegistrationPoint4 = new Matrix(t4).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint4;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -5) {
                            double shearX = (ex - dsx) / ImagePanel.this.bounds.getHeight();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            AffineTransform t5 = new AffineTransform();
                            bStart = parentMatrix.transform((Point2D)new Point2D.Double(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY()));
                            t5.translate(bStart.getX(), bStart.getY());
                            t5.shear(shearX, 0.0);
                            t5.translate(-bStart.getX(), -bStart.getY());
                            newTransform3.preConcatenate(t5);
                            newRegistrationPoint4 = new Matrix(t5).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint4;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -8) {
                            double shearY = -(ey - dsy) / ImagePanel.this.bounds.getWidth();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            AffineTransform t6 = new AffineTransform();
                            bStart = parentMatrix.transform((Point2D)new Point2D.Double(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY()));
                            t6.translate(bStart.getX(), bStart.getY());
                            t6.shear(0.0, shearY);
                            t6.translate(-bStart.getX(), -bStart.getY());
                            t6.translate(0.0, ey - dsy);
                            newTransform3.preConcatenate(t6);
                            newRegistrationPoint4 = new Matrix(t6).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint4;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -6) {
                            double shearY = (ey - dsy) / ImagePanel.this.bounds.getWidth();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            AffineTransform t7 = new AffineTransform();
                            bStart = parentMatrix.transform((Point2D)new Point2D.Double(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY()));
                            t7.translate(bStart.getX(), bStart.getY());
                            t7.shear(0.0, shearY);
                            t7.translate(-bStart.getX(), -bStart.getY());
                            newTransform3.preConcatenate(t7);
                            newRegistrationPoint4 = new Matrix(t7).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint4;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -2) {
                            double deltaStartX = Math.abs(dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs(dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs(ex - ImagePanel.this.registrationPoint.getX());
                            double deltaEndY = Math.abs(ey - ImagePanel.this.registrationPoint.getY());
                            double deltaTheta = 0.0;
                            if (ex >= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaEnd - thetaStart;
                            } else if (ex >= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = -(thetaStart + thetaEnd);
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + thetaEnd;
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            }
                            AffineTransform newTransform4 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            newTransform4.preConcatenate(t3);
                            newRegistrationPoint3 = new Matrix(t3).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform4;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -3) {
                            double deltaStartX = Math.abs(dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs(dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs(ex - ImagePanel.this.registrationPoint.getX());
                            double deltaEndY = Math.abs(ey - ImagePanel.this.registrationPoint.getY());
                            double deltaTheta = 0.0;
                            if (ex >= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            } else if (ex >= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + thetaEnd;
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = -(thetaStart + thetaEnd);
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaEnd - thetaStart;
                            }
                            AffineTransform newTransform5 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            newTransform5.preConcatenate(t3);
                            newRegistrationPoint3 = new Matrix(t3).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform5;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -1) {
                            double deltaStartX = Math.abs(dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs(dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs(ex - ImagePanel.this.registrationPoint.getX());
                            double deltaEndY = Math.abs(ey - ImagePanel.this.registrationPoint.getY());
                            double deltaTheta = 0.0;
                            if (ex >= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + thetaEnd;
                            } else if (ex >= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart - thetaEnd;
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = -(thetaStart + thetaEnd);
                            }
                            AffineTransform newTransform6 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            newTransform6.preConcatenate(t3);
                            newRegistrationPoint3 = new Matrix(t3).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform6;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -4) {
                            double deltaStartX = Math.abs(dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs(dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs(ex - ImagePanel.this.registrationPoint.getX());
                            double deltaEndY = Math.abs(ey - ImagePanel.this.registrationPoint.getY());
                            double deltaTheta = 0.0;
                            if (ex >= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = -(thetaStart + thetaEnd);
                            } else if (ex >= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart - thetaEnd;
                            } else if (ex <= ImagePanel.this.registrationPoint.getX() && ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + thetaEnd;
                            }
                            AffineTransform newTransform7 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            newTransform7.preConcatenate(t3);
                            newRegistrationPoint3 = new Matrix(t3).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform7;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 12) {
                            ImagePanel.this.transformUpdated = new AffineTransform(ImagePanel.this.transform.toTransform());
                            ImagePanel.this.registrationPointUpdated = new Point2D.Double(ex, ey);
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 13) {
                            double deltaX = exSnapped - dsx;
                            double deltaY = eySnapped - dsy;
                            AffineTransform newTransform8 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            AffineTransform t8 = parentMatrix.toTransform();
                            t8.translate(deltaX, deltaY);
                            t8.concatenate(parentMatrix.inverse().toTransform());
                            newTransform8.preConcatenate(t8);
                            Point2D newRegistrationPoint5 = new Matrix(t8).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform8;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint5;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 11) {
                            double deltaBefore = ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - ImagePanel.this.registrationPoint.getX();
                            double deltaX = ex - ImagePanel.this.registrationPoint.getX();
                            double scaleX = deltaX / deltaBefore;
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(parentRegistrationPoint.getX(), 0.0);
                            t2.scale(scaleX, 1.0);
                            t2.translate(-parentRegistrationPoint.getX(), 0.0);
                            newTransform2.preConcatenate(t2);
                            newRegistrationPoint2 = new Matrix(t2).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 10) {
                            double deltaBefore = ImagePanel.this.registrationPoint.getX() - ImagePanel.this.bounds.getX();
                            double deltaX = ImagePanel.this.registrationPoint.getX() - ex;
                            double scaleX = deltaX / deltaBefore;
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(parentRegistrationPoint.getX(), 0.0);
                            t2.scale(scaleX, 1.0);
                            t2.translate(-parentRegistrationPoint.getX(), 0.0);
                            newTransform2.preConcatenate(t2);
                            newRegistrationPoint2 = new Matrix(t2).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 9) {
                            double deltaBefore = ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - ImagePanel.this.registrationPoint.getY();
                            double deltaY = ey - ImagePanel.this.registrationPoint.getY();
                            double scaleY = deltaY / deltaBefore;
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(0.0, parentRegistrationPoint.getY());
                            t2.scale(1.0, scaleY);
                            t2.translate(0.0, -parentRegistrationPoint.getY());
                            newTransform2.preConcatenate(t2);
                            newRegistrationPoint2 = new Matrix(t2).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 8) {
                            double deltaBefore = ImagePanel.this.registrationPoint.getY() - ImagePanel.this.bounds.getY();
                            double deltaY = ImagePanel.this.registrationPoint.getY() - ey;
                            double scaleY = deltaY / deltaBefore;
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(0.0, parentRegistrationPoint.getY());
                            t2.scale(1.0, scaleY);
                            t2.translate(0.0, -parentRegistrationPoint.getY());
                            newTransform2.preConcatenate(t2);
                            newRegistrationPoint2 = new Matrix(t2).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 5) {
                            double deltaXBefore = ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - ImagePanel.this.registrationPoint.getX();
                            double deltaYBefore = ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - ImagePanel.this.registrationPoint.getY();
                            double deltaX = ex - ImagePanel.this.registrationPoint.getX();
                            double deltaY = ey - ImagePanel.this.registrationPoint.getY();
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-parentRegistrationPoint.getX(), -parentRegistrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Matrix(t).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 7) {
                            double deltaXBefore = ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - ImagePanel.this.registrationPoint.getX();
                            double deltaYBefore = ImagePanel.this.registrationPoint.getY() - ImagePanel.this.bounds.getY();
                            double deltaX = ex - ImagePanel.this.registrationPoint.getX();
                            double deltaY = ImagePanel.this.registrationPoint.getY() - ey;
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-parentRegistrationPoint.getX(), -parentRegistrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Matrix(t).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 4) {
                            double deltaXBefore = ImagePanel.this.registrationPoint.getX() - ImagePanel.this.bounds.getX();
                            double deltaYBefore = ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - ImagePanel.this.registrationPoint.getY();
                            double deltaX = ImagePanel.this.registrationPoint.getX() - ex;
                            double deltaY = ey - ImagePanel.this.registrationPoint.getY();
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-parentRegistrationPoint.getX(), -parentRegistrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Matrix(t).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 6) {
                            double deltaXBefore = ImagePanel.this.registrationPoint.getX() - ImagePanel.this.bounds.getX();
                            double deltaYBefore = ImagePanel.this.registrationPoint.getY() - ImagePanel.this.bounds.getY();
                            double deltaX = ImagePanel.this.registrationPoint.getX() - ex;
                            double deltaY = ImagePanel.this.registrationPoint.getY() - ey;
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(parentRegistrationPoint.getX(), parentRegistrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-parentRegistrationPoint.getX(), -parentRegistrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Matrix(t).preConcatenate(parentMatrix.inverse()).concatenate(parentMatrix).transform(ImagePanel.this.registrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    List points = ImagePanel.this.hilightedPoints;
                    if (points != null) {
                        int maxDistance = 5;
                        double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                        ArrayList<Integer> newPointsUnderCursor = new ArrayList<Integer>();
                        for (int i = 0; i < points.size(); ++i) {
                            DisplayPoint p = (DisplayPoint)points.get(i);
                            Point2D ip = ImagePanel.this.toImagePoint(new Point2D.Double(p.x, p.y));
                            int ex = e.getX();
                            int ey = e.getY();
                            if (!((double)ex > ip.getX() - (double)maxDistance) || !((double)ex < ip.getX() + (double)maxDistance) || !((double)ey > ip.getY() - (double)maxDistance) || !((double)ey < ip.getY() + (double)maxDistance)) continue;
                            newPointsUnderCursor.add(i);
                        }
                        Point2D p = ImagePanel.this.toTransformPoint(e.getPoint());
                        ArrayList<DistanceItem> distanceList = new ArrayList<DistanceItem>();
                        for (int i = 0; i < points.size() - 1; ++i) {
                            DisplayPoint p1;
                            DisplayPoint p0;
                            if (((DisplayPoint)points.get((int)i)).onPath && ((DisplayPoint)points.get((int)(i + 1))).onPath) {
                                Point2D.Double closestPoint;
                                double lineDistance;
                                p0 = (DisplayPoint)points.get(i);
                                p1 = (DisplayPoint)points.get(i + 1);
                                if (p1.x == p0.x) {
                                    lineDistance = Math.abs((double)p1.x - p.getX());
                                    closestPoint = new Point2D.Double(p1.x, p.getY());
                                } else if (p1.y == p0.y) {
                                    lineDistance = Math.abs((double)p1.y - p.getY());
                                    closestPoint = new Point2D.Double(p.getX(), p1.y);
                                } else {
                                    double m = (double)(p1.y - p0.y) / (double)(p1.x - p0.x);
                                    double b = (double)p0.y - m * (double)p0.x;
                                    double m_perp = -1.0 / m;
                                    double b_perp = p.getY() - m_perp * p.getX();
                                    double x = (b_perp - b) / (m - m_perp);
                                    double y = m * x + b;
                                    closestPoint = new Point2D.Double(x, y);
                                    lineDistance = p.distance(closestPoint);
                                }
                                double minX = (double)Math.min(p0.x, p1.x) - (double)maxDistance * 20.0 / zoomDouble;
                                double minY = (double)Math.min(p0.y, p1.y) - (double)maxDistance * 20.0 / zoomDouble;
                                double maxX = (double)Math.max(p0.x, p1.x) + (double)maxDistance * 20.0 / zoomDouble;
                                double maxY = (double)Math.max(p0.y, p1.y) + (double)maxDistance * 20.0 / zoomDouble;
                                if (p.getX() >= minX && p.getX() <= maxX && p.getY() >= minY && p.getY() <= maxY) {
                                    double t = p0.toPoint2D().distance(closestPoint) / p0.toPoint2D().distance(p1.toPoint2D());
                                    if (lineDistance <= (double)maxDistance * 20.0 / zoomDouble) {
                                        distanceList.add(new DistanceItem(lineDistance, i + 1, t, new DisplayPoint(closestPoint)));
                                    }
                                }
                            }
                            if (i >= points.size() - 2 || ((DisplayPoint)points.get((int)(i + 1))).onPath) continue;
                            p0 = (DisplayPoint)points.get(i);
                            p1 = (DisplayPoint)points.get(i + 1);
                            DisplayPoint p2 = (DisplayPoint)points.get(i + 2);
                            BezierUtils bezierUtils = new BezierUtils();
                            double t = bezierUtils.closestPointToBezier(p, p0.toPoint2D(), p1.toPoint2D(), p2.toPoint2D());
                            DisplayPoint closestPoint = new DisplayPoint(bezierUtils.pointAt(t, p0.toPoint2D(), p1.toPoint2D(), p2.toPoint2D()));
                            double curveDistance = Math.sqrt((p.getX() - (double)closestPoint.x) * (p.getX() - (double)closestPoint.x) + (p.getY() - (double)closestPoint.y) * (p.getY() - (double)closestPoint.y));
                            if (!(curveDistance <= (double)maxDistance * 20.0 / zoomDouble)) continue;
                            distanceList.add(new DistanceItem(curveDistance, i + 1, t, closestPoint));
                        }
                        distanceList.sort(new Comparator<DistanceItem>(){

                            @Override
                            public int compare(DistanceItem o1, DistanceItem o2) {
                                return o2.pathPoint - o1.pathPoint;
                            }
                        });
                        if (IconPanel.this.dragStart == null) {
                            ImagePanel.this.pathPointsUnderCursor = distanceList;
                            ImagePanel.this.pointsUnderCursor = newPointsUnderCursor;
                        }
                        return;
                    }
                    boolean nearGuideX = ImagePanel.this.draggingGuideX;
                    boolean nearGuideY = ImagePanel.this.draggingGuideY;
                    if (!ImagePanel.this.draggingGuideX && !ImagePanel.this.draggingGuideY && ((Boolean)Configuration.showGuides.get()).booleanValue() && !((Boolean)Configuration.lockGuides.get()).booleanValue()) {
                        int guideInPanel;
                        Double guide;
                        int d;
                        Point mousePoint = e.getPoint();
                        for (d = 0; d < ImagePanel.this.guidesX.size(); ++d) {
                            guide = (Double)ImagePanel.this.guidesX.get(d);
                            guideInPanel = (int)Math.round(guide * ImagePanel.this.getRealZoom() + ImagePanel.this.offsetPoint.getX());
                            if (mousePoint.x < guideInPanel - 2 || mousePoint.x > guideInPanel + 2) continue;
                            nearGuideX = true;
                            break;
                        }
                        for (d = 0; d < ImagePanel.this.guidesY.size(); ++d) {
                            guide = (Double)ImagePanel.this.guidesY.get(d);
                            guideInPanel = (int)Math.round(guide * ImagePanel.this.getRealZoom() + ImagePanel.this.offsetPoint.getY());
                            if (mousePoint.y < guideInPanel - 2 || mousePoint.y > guideInPanel + 2) continue;
                            nearGuideY = true;
                            break;
                        }
                    }
                    if (ImagePanel.this.doFreeTransform) {
                        Cursor cursor;
                        int newMode;
                        boolean shearY;
                        if (ImagePanel.this.bounds == null) {
                            return;
                        }
                        if (ImagePanel.this.registrationPoint == null) {
                            return;
                        }
                        Rectangle2D boundsImage = ImagePanel.this.toImageRect(ImagePanel.this.bounds);
                        Point2D regPointImage = ImagePanel.this.toImagePoint(ImagePanel.this.registrationPoint);
                        int ex = e.getX();
                        int ey = e.getY();
                        boolean left = (double)ex >= boundsImage.getX() - 8.0 && (double)ex <= boundsImage.getX() + 8.0;
                        boolean right = (double)ex >= boundsImage.getX() + boundsImage.getWidth() - 8.0 && (double)ex <= boundsImage.getX() + boundsImage.getWidth() + 8.0;
                        boolean top = (double)ey >= boundsImage.getY() - 8.0 && (double)ey <= boundsImage.getY() + 8.0;
                        boolean bottom = (double)ey >= boundsImage.getY() + boundsImage.getHeight() - 8.0 && (double)ey <= boundsImage.getY() + boundsImage.getHeight() + 8.0;
                        boolean xcenter = (double)ex >= boundsImage.getCenterX() - 8.0 && (double)ex <= boundsImage.getCenterX() + 8.0;
                        boolean ycenter = (double)ey >= boundsImage.getCenterY() - 8.0 && (double)ey <= boundsImage.getCenterY() + 8.0;
                        boolean registration = (double)ex >= regPointImage.getX() - 8.0 && (double)ex <= regPointImage.getX() + 8.0 && (double)ey >= regPointImage.getY() - 8.0 && (double)ey <= regPointImage.getY() + 8.0;
                        boolean rightRotate = (double)ex > boundsImage.getX() + boundsImage.getWidth() - 30.0 && (double)ex <= boundsImage.getX() + boundsImage.getWidth() + 30.0;
                        boolean bottomRotate = (double)ey > boundsImage.getY() + boundsImage.getHeight() - 30.0 && (double)ey <= boundsImage.getY() + boundsImage.getHeight() + 30.0;
                        boolean leftRotate = (double)ex < boundsImage.getX() + 30.0 && (double)ex >= boundsImage.getX() - 30.0;
                        boolean topRotate = (double)ey < boundsImage.getY() + 30.0 && (double)ey >= boundsImage.getY() - 30.0;
                        boolean inBounds = boundsImage.contains(ex, ey);
                        boolean shearX = (double)ex > boundsImage.getX() && (double)ex < boundsImage.getX() + boundsImage.getWidth();
                        boolean bl = shearY = (double)ey > boundsImage.getY() && (double)ey < boundsImage.getY() + boundsImage.getHeight();
                        if (top && left) {
                            newMode = 6;
                            cursor = resizeNWSECursor;
                        } else if (bottom && left) {
                            newMode = 4;
                            cursor = resizeSWNECursor;
                        } else if (top && right) {
                            newMode = 7;
                            cursor = resizeSWNECursor;
                        } else if (bottom && right) {
                            newMode = 5;
                            cursor = resizeNWSECursor;
                        } else if (top && xcenter) {
                            newMode = 8;
                            cursor = resizeYCursor;
                        } else if (bottom && xcenter) {
                            newMode = 9;
                            cursor = resizeYCursor;
                        } else if (left && ycenter) {
                            newMode = 10;
                            cursor = resizeXCursor;
                        } else if (right && ycenter) {
                            newMode = 11;
                            cursor = resizeXCursor;
                        } else if (registration) {
                            newMode = 12;
                            cursor = moveRegPointCursor;
                        } else if (!inBounds && rightRotate && topRotate) {
                            newMode = -1;
                            cursor = rotateCursor;
                        } else if (!inBounds && rightRotate && bottomRotate) {
                            newMode = -2;
                            cursor = rotateCursor;
                        } else if (!inBounds && leftRotate && topRotate) {
                            newMode = -3;
                            cursor = rotateCursor;
                        } else if (!inBounds && leftRotate && bottomRotate) {
                            newMode = -4;
                            cursor = rotateCursor;
                        } else if (shearY && (left || right)) {
                            newMode = left ? -8 : -6;
                            cursor = shearYCursor;
                        } else if (shearX && (top || bottom)) {
                            newMode = top ? -7 : -5;
                            cursor = shearXCursor;
                        } else if (nearGuideX) {
                            newMode = -9;
                            cursor = guideXCursor;
                        } else if (nearGuideY) {
                            newMode = -10;
                            cursor = guideYCursor;
                        } else if (inBounds) {
                            newMode = 13;
                            cursor = moveCursor;
                        } else {
                            newMode = 0;
                            cursor = defaultCursor;
                        }
                        if (IconPanel.this.getCursor() != cursor) {
                            IconPanel.this.setCursor(cursor);
                        }
                        ImagePanel.this.mode = newMode;
                    } else {
                        Object cursor = null;
                        Integer newMode = null;
                        newMode = nearGuideX ? Integer.valueOf(-9) : (nearGuideY ? Integer.valueOf(-10) : Integer.valueOf(0));
                        ImagePanel.this.mode = newMode;
                    }
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (IconPanel.this.ctrlDown && e.getScrollType() == 0) {
                        int rotation = e.getWheelRotation();
                        if (rotation < 0) {
                            ImagePanel.this.zoomIn();
                        } else {
                            ImagePanel.this.zoomOut();
                        }
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
            this.addMouseWheelListener(mouseInputAdapter);
        }

        public void setAutoFit(boolean autoFit) {
            this.autoFit = autoFit;
            this.repaint();
        }

        public synchronized BufferedImage getLastImage() {
            if (this._img == null) {
                return null;
            }
            return this._img.getBufferedImage();
        }

        public synchronized void setImg(SerializableImage img) {
            this._img = img;
            this.calcRect();
            View.execInEventDispatchLater(new Runnable(){

                @Override
                public void run() {
                    IconPanel.this.render();
                    IconPanel.this.repaint();
                }
            });
        }

        private void setAllowMove(boolean allowMove) {
            this.allowMove = allowMove;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calcRect() {
            ImagePanel imagePanel = ImagePanel.this;
            synchronized (imagePanel) {
                IconPanel iconPanel = this;
                synchronized (iconPanel) {
                    this.calcRect(ImagePanel.this.zoom);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calcRect(Zoom z) {
            ImagePanel imagePanel = ImagePanel.this;
            synchronized (imagePanel) {
                Timelined topTimelined = ImagePanel.this.getTopTimelined();
                if (this._img != null || topTimelined != null) {
                    int h;
                    int w;
                    int dy;
                    int dx;
                    int h1;
                    int w1;
                    double zoomDouble;
                    double d = zoomDouble = z.fit ? ImagePanel.this.getZoomToFit() : z.value;
                    if (topTimelined == null || !ImagePanel.this.autoPlayed && this._img != null) {
                        w1 = (int)((double)this._img.getWidth() * 1.0);
                        h1 = (int)((double)this._img.getHeight() * 1.0);
                        dx = 0;
                        dy = 0;
                    } else {
                        w1 = (int)((double)topTimelined.getRect().getWidth() * zoomDouble / 20.0);
                        h1 = (int)((double)topTimelined.getRect().getHeight() * zoomDouble / 20.0);
                        dx = (int)((double)topTimelined.getRect().Xmin * zoomDouble / 20.0);
                        dy = (int)((double)topTimelined.getRect().Ymin * zoomDouble / 20.0);
                    }
                    if (ImagePanel.this.doFreeTransform) {
                        // empty if block
                    }
                    int w2 = this.getWidth();
                    int h2 = this.getHeight();
                    if (this.autoFit) {
                        if (w1 <= w2 && h1 <= h2) {
                            w = w1;
                            h = h1;
                        } else {
                            h = h1 * w2 / w1;
                            if (h > h2) {
                                w = w1 * h2 / h1;
                                h = h2;
                            } else {
                                w = w2;
                            }
                        }
                    } else {
                        w = w1;
                        h = h1;
                    }
                    if (ImagePanel.this.hilightedPoints != null) {
                        this.setAllowMove(false);
                    } else if (ImagePanel.this.doFreeTransform) {
                        this.setAllowMove(true);
                    } else if (ImagePanel.this.selectionMode) {
                        this.setAllowMove(false);
                        if (h < h2 && w < w2) {
                            ImagePanel.this.offsetPoint.setLocation(ImagePanel.this.iconPanel.getWidth() / 2 - w / 2 - dx, ImagePanel.this.iconPanel.getHeight() / 2 - h / 2 - dy);
                            ImagePanel.this.updateScrollBars();
                        }
                    } else {
                        boolean doMove;
                        boolean bl = doMove = h > h2 || w > w2;
                        if (((ImagePanel)ImagePanel.this).zoom.fit) {
                            doMove = false;
                        }
                        this.setAllowMove(doMove);
                        if (!doMove) {
                            ImagePanel.this.offsetPoint.setLocation(ImagePanel.this.iconPanel.getWidth() / 2 - w / 2 - dx, ImagePanel.this.iconPanel.getHeight() / 2 - h / 2 - dy);
                            ImagePanel.this.updateScrollBars();
                        }
                    }
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            VolatileImage ri = this.renderImage;
            if (ri != null) {
                if (ri.validate(View.getDefaultConfiguration()) != 0) {
                    ri = View.createRenderImage(this.getWidth(), this.getHeight(), 3);
                    this.render();
                }
                if (ri != null) {
                    g2d.drawImage(ri, 0, 0, null);
                }
            }
            g2d.setColor((Color)Configuration.guidesColor.get());
            if (ImagePanel.this.draggingGuideX && ImagePanel.this.lastMouseEvent != null) {
                g2d.drawLine(ImagePanel.this.guideDragX, 0, ImagePanel.this.guideDragX, this.getHeight());
            }
            if (ImagePanel.this.draggingGuideY && ImagePanel.this.lastMouseEvent != null) {
                g2d.drawLine(0, ImagePanel.this.guideDragY, this.getWidth(), ImagePanel.this.guideDragY);
            }
            if (!(((Boolean)Configuration.showGuides.get()).booleanValue() || !ImagePanel.this.draggingGuideX && !ImagePanel.this.draggingGuideY || ImagePanel.this.guideDragX <= 0 && ImagePanel.this.guideDragY <= 0)) {
                Configuration.showGuides.set((Object)true);
            }
            if (((Boolean)Configuration.showGuides.get()).booleanValue()) {
                int guideRealPx;
                for (Double guide : ImagePanel.this.guidesX) {
                    guideRealPx = (int)Math.round(ImagePanel.this.offsetPoint.getX() + guide * ImagePanel.this.getRealZoom());
                    g2d.drawLine(guideRealPx, 0, guideRealPx, this.getHeight());
                }
                for (Double guide : ImagePanel.this.guidesY) {
                    guideRealPx = (int)Math.round(ImagePanel.this.offsetPoint.getY() + guide * ImagePanel.this.getRealZoom());
                    g2d.drawLine(0, guideRealPx, this.getWidth(), guideRealPx);
                }
            }
            if (((Boolean)Configuration._debugMode.get()).booleanValue()) {
                g2d.setColor(Color.red);
                DecimalFormat df = new DecimalFormat();
                df.setMaximumFractionDigits(2);
                df.setMinimumFractionDigits(0);
                df.setGroupingUsed(false);
                g2d.drawString("frameLoss:" + df.format(ImagePanel.this.getFrameLoss()) + "%", 20, 20);
            }
        }
    }
}

