/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.jpexs.debugger.flash.DebugConnectionListener;
import com.jpexs.debugger.flash.Debugger;
import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.debugger.flash.Variable;
import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.Bundle;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.OpenableSourceInfo;
import com.jpexs.decompiler.flash.OpenableSourceKind;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SearchMode;
import com.jpexs.decompiler.flash.SwfOpenException;
import com.jpexs.decompiler.flash.UrlResolver;
import com.jpexs.decompiler.flash.Version;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCInputStream;
import com.jpexs.decompiler.flash.abc.ABCOpenException;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.configuration.AppDirectoryProvider;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.SwfSpecificConfiguration;
import com.jpexs.decompiler.flash.configuration.SwfSpecificCustomConfiguration;
import com.jpexs.decompiler.flash.console.CommandLineArgumentParser;
import com.jpexs.decompiler.flash.console.ContextMenuTools;
import com.jpexs.decompiler.flash.exporters.modes.ExeExportMode;
import com.jpexs.decompiler.flash.exporters.swf.SwfToSwcExporter;
import com.jpexs.decompiler.flash.gfx.GfxConvertor;
import com.jpexs.decompiler.flash.gui.AboutDialog;
import com.jpexs.decompiler.flash.gui.AdvancedSettingsDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.DebugLogDialog;
import com.jpexs.decompiler.flash.gui.DebuggerHandler;
import com.jpexs.decompiler.flash.gui.ErrorLogFrame;
import com.jpexs.decompiler.flash.gui.FilesChangedDialog;
import com.jpexs.decompiler.flash.gui.LoadFromMemoryFrame;
import com.jpexs.decompiler.flash.gui.LoadingDialog;
import com.jpexs.decompiler.flash.gui.LogFormatter;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.MainFrameClassic;
import com.jpexs.decompiler.flash.gui.MainFrameRibbon;
import com.jpexs.decompiler.flash.gui.MainFrameStatusPanel;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.NewFileDialog;
import com.jpexs.decompiler.flash.gui.NewVersionDialog;
import com.jpexs.decompiler.flash.gui.OpenFileResult;
import com.jpexs.decompiler.flash.gui.OpenableOpened;
import com.jpexs.decompiler.flash.gui.SaveFileMode;
import com.jpexs.decompiler.flash.gui.SearchResultsStorage;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.debugger.DebugAdapter;
import com.jpexs.decompiler.flash.gui.debugger.DebugLoaderDataModified;
import com.jpexs.decompiler.flash.gui.debugger.DebuggerTools;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.Advapi32Util;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.Kernel32;
import com.jpexs.decompiler.flash.gui.jna.platform.win32.WinReg;
import com.jpexs.decompiler.flash.gui.pipes.FirstInstance;
import com.jpexs.decompiler.flash.gui.soleditor.CookiesChangedListener;
import com.jpexs.decompiler.flash.gui.soleditor.SharedObjectsStorage;
import com.jpexs.decompiler.flash.gui.soleditor.SolEditorFrame;
import com.jpexs.decompiler.flash.gui.taglistview.TagListTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTreeModel;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineVideoStreamTag;
import com.jpexs.decompiler.flash.tags.DoABC2Tag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.ReReadableInputStream;
import com.jpexs.helpers.Reference;
import com.jpexs.helpers.Stopwatch;
import com.jpexs.helpers.streams.SeekableInputStream;
import com.jpexs.helpers.utf8.Utf8Helper;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.MenuItem;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import jsyntaxpane.DefaultSyntaxKit;

public class Main {
    public static final String IMPORT_ASSETS_SEPARATOR = "{*sep*}";
    private static List<OpenableSourceInfo> sourceInfos = new ArrayList<OpenableSourceInfo>();
    public static LoadingDialog loadingDialog;
    private static boolean working;
    private static TrayIcon trayIcon;
    private static MenuItem stopMenuItem;
    private static volatile MainFrame mainFrame;
    public static final int UPDATE_SYSTEM_MAJOR = 1;
    public static final int UPDATE_SYSTEM_MINOR = 3;
    private static LoadFromMemoryFrame loadFromMemoryFrame;
    private static final Logger logger;
    public static DebugLogDialog debugDialog;
    private static Debugger flashDebugger;
    private static DebuggerHandler debugHandler;
    private static Process runProcess;
    private static boolean runProcessDebug;
    private static boolean runProcessDebugPCode;
    private static boolean inited;
    private static File runTempFile;
    private static CookiesChangedListener runCookieListener;
    private static List<File> runTempFiles;
    private static WatchService watcher;
    private static SwingWorker watcherWorker;
    private static Map<WatchKey, File> watchedDirectories;
    private static FilesChangedDialog filesChangedDialog;
    private static List<File> savedFiles;
    public static SearchResultsStorage searchResultsStorage;
    public static CancellableWorker importWorker;
    public static CancellableWorker deobfuscatePCodeWorker;
    public static CancellableWorker swfPrepareWorker;
    public static String currentDebuggerPackage;
    private static SWF runningSWF;
    private static SwfPreparation runningPreparation;
    private static boolean loggingFileLoaded;
    private static long lastTimeStartWork;
    private static final Timer statusTimer;
    private static FileHandler fileTxt;

    public static SWF getRunningSWF() {
        return runningSWF;
    }

    public static WatchService getWatcher() {
        return watcher;
    }

    public static boolean isSwfAir(Openable openable) {
        SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration((String)openable.getShortPathTitle());
        if (conf != null) {
            String libraryAsStr = conf.getCustomData("library", "1");
            int libraryAsInt = Integer.parseInt(libraryAsStr);
            return libraryAsInt == 0;
        }
        return false;
    }

    public static void startSaving(File savedFile) {
        savedFiles.add(savedFile);
    }

    public static void stopSaving(final File savedFile) {
        View.execInEventDispatchLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                savedFiles.remove(savedFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeRun() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (runTempFile != null) {
                Main.deleteCookiesAfterRun(runTempFile);
                runTempFile.delete();
                runTempFile = null;
            }
            for (File f : runTempFiles) {
                f.delete();
            }
            runTempFiles.clear();
            runProcess = null;
            runningSWF = null;
            runningPreparation = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (mainFrame != null && mainFrame.getPanel() != null) {
                mainFrame.getPanel().clearDebuggerColors();
            }
            if (runProcessDebug) {
                Main.getDebugHandler().disconnect();
            }
            return;
        }
    }

    public static synchronized boolean isDebugPaused() {
        return runProcess != null && runProcessDebug && Main.getDebugHandler().isPaused();
    }

    public static synchronized boolean isDebugRunning() {
        return runProcess != null && runProcessDebug;
    }

    public static synchronized boolean isDebugPCode() {
        return runProcessDebugPCode;
    }

    public static synchronized boolean isDebugConnected() {
        return Main.getDebugHandler().isConnected();
    }

    public static synchronized boolean isRunning() {
        return runProcess != null && !runProcessDebug;
    }

    public static synchronized void debugExportByteArray(Variable v, OutputStream os) throws IOException {
        try {
            long objectId = 0L;
            if (v.vType == 3 || v.vType == 5) {
                objectId = (Long)v.value;
            }
            Object oldPos = Main.getDebugHandler().getVariable((long)objectId, (String)"position", (boolean)false, (boolean)true).parent.value;
            Main.getDebugHandler().setVariable(objectId, "position", 0, 0);
            int length = (int)((Double)Main.getDebugHandler().getVariable((long)objectId, (String)"length", (boolean)false, (boolean)true).parent.value).doubleValue();
            for (int i = 0; i < length; ++i) {
                int b = (int)((Double)((Variable)Main.getDebugHandler().callFunction((boolean)false, (String)"readByte", (Variable)v, new ArrayList<Object>()).variables.get((int)0)).value).doubleValue();
                os.write(b);
            }
            Main.getDebugHandler().setVariable(objectId, "position", 0, oldPos);
        }
        catch (DebuggerHandler.ActionScriptException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static synchronized void debugImportByteArray(Variable v, InputStream is) throws IOException {
        try {
            int b;
            long objectId = 0L;
            if (v.vType == 3 || v.vType == 5) {
                objectId = (Long)v.value;
            }
            Double oldPos = (Double)Main.getDebugHandler().getVariable((long)objectId, (String)"position", (boolean)false, (boolean)true).parent.value;
            Main.getDebugHandler().setVariable(objectId, "length", 0, 0);
            Main.getDebugHandler().setVariable(objectId, "position", 0, 0);
            int length = 0;
            while ((b = is.read()) > -1) {
                Main.getDebugHandler().callFunction(false, "writeByte", v, Arrays.asList(b));
                ++length;
            }
            if (oldPos > (double)length) {
                oldPos = length;
            }
            Main.getDebugHandler().setVariable(objectId, "position", 0, oldPos);
        }
        catch (DebuggerHandler.ActionScriptException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static synchronized boolean addWatch(Variable v, long v_id, boolean watchRead, boolean watchWrite) {
        DebuggerCommands.Watch w = Main.getDebugHandler().addWatch(v, v_id, watchRead, watchWrite);
        return w != null;
    }

    public static void runPlayer(String title, final String exePath, String file, String flashVars) {
        if (!new File(file).exists()) {
            return;
        }
        if (flashVars != null && !flashVars.isEmpty()) {
            file = file + "?" + flashVars;
        }
        final String ffile = file;
        CancellableWorker runWorker = new CancellableWorker("runWorker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Object doInBackground() throws Exception {
                Process proc;
                try {
                    proc = Runtime.getRuntime().exec(new String[]{exePath, ffile});
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                    return null;
                }
                Class<Main> clazz = Main.class;
                synchronized (Main.class) {
                    block11: {
                        runProcess = proc;
                        boolean isDebug = runProcessDebug;
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        if (isDebug) {
                            mainFrame.getMenu().hilightPath("/debugging");
                        }
                        mainFrame.getMenu().updateComponents();
                        try {
                            if (proc != null) {
                                proc.waitFor();
                            }
                        }
                        catch (InterruptedException ex) {
                            if (proc == null) break block11;
                            try {
                                proc.destroy();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    Main.freeRun();
                    Main.stopDebugger();
                    mainFrame.getMenu().updateComponents();
                    return null;
                }
            }

            protected void done() {
                Main.stopWork();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void workerCancelled() {
                Main.stopWork();
                Class<Main> clazz = Main.class;
                synchronized (Main.class) {
                    if (runProcess != null) {
                        try {
                            runProcess.destroy();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    Main.freeRun();
                    mainFrame.getMenu().updateComponents();
                    return;
                }
            }
        };
        mainFrame.getMenu().updateComponents();
        Main.startWork(title + "...", runWorker);
        runWorker.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopRun() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (runProcess != null) {
                runProcess.destroy();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Main.freeRun();
            Main.stopDebugger();
            mainFrame.getMenu().updateComponents();
            return;
        }
    }

    private static void prepareSwf(String swfHash, SwfPreparation prep, File toPrepareFile, File origFile, File tempFilesDir, List<File> tempFiles) throws IOException, InterruptedException {
        Throwable throwable;
        SWF instrSWF = null;
        try {
            throwable = null;
            try (FileInputStream fis = new FileInputStream(toPrepareFile);){
                instrSWF = new SWF((InputStream)fis, toPrepareFile.getAbsolutePath(), origFile == null ? "unknown.swf" : origFile.getName(), false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (instrSWF != null) {
            if (origFile != null) {
                for (Tag t : instrSWF.getTags()) {
                    if (!(t instanceof ImportTag)) continue;
                    ImportTag it = (ImportTag)t;
                    String url = it.getUrl();
                    File importedFile = new File(origFile.getParentFile(), url);
                    if (!importedFile.exists()) continue;
                    File newTempFile = Main.createTempFileInDir(tempFilesDir, "~ffdec_run_import_", ".swf");
                    it.setUrl("./" + newTempFile.getName());
                    byte[] impData = Helper.readFile((String[])new String[]{importedFile.getAbsolutePath()});
                    Helper.writeFile((String)newTempFile.getAbsolutePath(), (byte[][])new byte[][]{impData});
                    tempFiles.add(newTempFile);
                    Main.prepareSwf("imported_" + Main.md5(impData), prep, newTempFile, importedFile, tempFilesDir, tempFiles);
                }
            }
            if (prep != null) {
                ArrayList<File> prepTempFiles = new ArrayList<File>();
                instrSWF = prep.prepare(instrSWF, swfHash, prepTempFiles);
                tempFiles.addAll(prepTempFiles);
            }
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(toPrepareFile);){
                instrSWF.saveTo((OutputStream)fos);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }

    private static File createTempFileInDir(File tempFilesDir, String prefix, String suffix) throws IOException {
        if (tempFilesDir == null || !tempFilesDir.isDirectory()) {
            return File.createTempFile(prefix, suffix);
        }
        try {
            return File.createTempFile(prefix, suffix, tempFilesDir);
        }
        catch (IOException ex) {
            return File.createTempFile(prefix, suffix);
        }
    }

    public static boolean runAsync(File swfFile) {
        String playerLocation = (String)Configuration.playerLocation.get();
        if (playerLocation.isEmpty() || !new File(playerLocation).exists()) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("message.playerpath.notset"), AppStrings.translate("error"), 0);
            Main.advancedSettings("paths");
            return false;
        }
        try {
            final Process process = Runtime.getRuntime().exec(new String[]{playerLocation, swfFile.getAbsolutePath()});
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                }
            });
            return true;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void run(SWF swf) {
        File tempFile;
        String flashVars = "";
        String playerLocation = (String)Configuration.playerLocation.get();
        if (playerLocation.isEmpty() || !new File(playerLocation).exists()) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("message.playerpath.notset"), AppStrings.translate("error"), 0);
            Main.advancedSettings("paths");
            return;
        }
        if (swf == null) {
            return;
        }
        File tempRunDir = swf.getFile() == null ? null : new File(swf.getFile()).getParentFile();
        ArrayList<File> tempFiles = new ArrayList<File>();
        try {
            tempFile = Main.createTempFileInDir(tempRunDir, "~ffdec_run_", ".swf");
            SWF swfToSave = swf;
            if (swf.gfx) {
                swfToSave = new GfxConvertor().convertSwf(swf);
            }
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                swfToSave.saveTo((OutputStream)fos, false, swf.gfx);
            }
            Main.prepareSwf("main", new SwfRunPrepare(), tempFile, swf.getFile() == null ? null : new File(swf.getFile()), tempRunDir, tempFiles);
        }
        catch (IOException ex) {
            return;
        }
        catch (InterruptedException ex) {
            return;
        }
        if (tempFile == null) return;
        Main.prepareCookiesForRun(tempFile, swf);
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            runTempFile = tempFile;
            runTempFiles = tempFiles;
            runProcessDebug = false;
            runningSWF = swf;
            runningPreparation = new SwfRunPrepare();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            Main.runPlayer(AppStrings.translate("work.running"), playerLocation, tempFile.getAbsolutePath(), flashVars);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCookiesAfterRun(File tempFile) {
        File origSolDir;
        SharedObjectsStorage.removeChangedListener(tempFile, runCookieListener);
        final File solDir = SharedObjectsStorage.getSolDirectoryForLocalFile(tempFile);
        File file = origSolDir = runningSWF.getFile() == null ? null : SharedObjectsStorage.getSolDirectoryForLocalFile(new File(runningSWF.getFile()));
        if (solDir != null) {
            WatchKey foundKey = null;
            for (WatchKey key : SharedObjectsStorage.watchedCookieDirectories.keySet()) {
                if (!SharedObjectsStorage.watchedCookieDirectories.get(key).equals(solDir)) continue;
                foundKey = key;
                break;
            }
            if (foundKey != null) {
                SharedObjectsStorage.watchedCookieDirectories.remove(foundKey);
            }
            View.execInEventDispatchLater(new Runnable(){

                @Override
                public void run() {
                    if (solDir.exists()) {
                        if (origSolDir != null && origSolDir.exists()) {
                            for (File f : origSolDir.listFiles()) {
                                f.delete();
                            }
                            for (File f : solDir.listFiles()) {
                                try {
                                    Files.copy(f.toPath(), origSolDir.toPath().resolve(f.getName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        for (File f : solDir.listFiles()) {
                            f.delete();
                        }
                        solDir.delete();
                    }
                }
            });
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            runCookieListener = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static void prepareCookiesForRun(File tempFile, final SWF swf) {
        if (swf.getFile() == null) {
            return;
        }
        File origSolDir = SharedObjectsStorage.getSolDirectoryForLocalFile(new File(swf.getFile()));
        if (origSolDir == null) {
            return;
        }
        File tempSolDir = SharedObjectsStorage.getSolDirectoryForLocalFile(tempFile);
        if (tempSolDir == null) {
            return;
        }
        tempSolDir.mkdirs();
        if (origSolDir.exists()) {
            for (File f : origSolDir.listFiles()) {
                try {
                    Files.copy(f.toPath(), tempSolDir.toPath().resolve(f.getName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        runCookieListener = new CookiesChangedListener(){

            @Override
            public void cookiesChanged(File swfFile, List<File> cookies) {
                File origSolDir = SharedObjectsStorage.getSolDirectoryForLocalFile(new File(swf.getFile()));
                if (cookies.isEmpty() && !origSolDir.exists()) {
                    return;
                }
                origSolDir.mkdirs();
                for (File f : origSolDir.listFiles()) {
                    f.delete();
                }
                for (File f : cookies) {
                    if (!f.exists()) continue;
                    try {
                        Files.copy(f.toPath(), origSolDir.toPath().resolve(f.getName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        SharedObjectsStorage.addChangedListener(tempFile, runCookieListener);
    }

    public static void runDebug(final SWF swf, final boolean doPCode) {
        final String flashVars = "";
        final String playerLocation = (String)Configuration.playerDebugLocation.get();
        if (playerLocation.isEmpty() || !new File(playerLocation).exists()) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("message.playerpath.debug.notset"), AppStrings.translate("error"), 0);
            Main.advancedSettings("paths");
            return;
        }
        if (swf == null) {
            return;
        }
        debugHandler.setMainDebuggedSwf(swf);
        final File tempRunDir = swf.getFile() == null ? null : new File(swf.getFile()).getParentFile();
        File tempFile = null;
        try {
            tempFile = Main.createTempFileInDir(tempRunDir, "~ffdec_debug_", ".swf");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tempFile != null) {
            final File fTempFile = tempFile;
            final ArrayList tempFiles = new ArrayList();
            CancellableWorker instrumentWorker = new CancellableWorker("instrumentWorker"){

                protected Object doInBackground() throws Exception {
                    SWF swfToSave = swf;
                    if (swf.gfx) {
                        swfToSave = new GfxConvertor().convertSwf(swf);
                    }
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fTempFile));){
                        swfToSave.saveTo((OutputStream)fos, false, swf.gfx);
                    }
                    Main.prepareSwf("main", new SwfDebugPrepare(doPCode), fTempFile, swf.getFile() == null ? null : new File(swf.getFile()), tempRunDir, tempFiles);
                    return null;
                }

                public void workerCancelled() {
                    Main.stopWork();
                }

                protected void onStart() {
                    swfPrepareWorker = this;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void done() {
                    Main.prepareCookiesForRun(fTempFile, swf);
                    Class<Main> clazz = Main.class;
                    synchronized (Main.class) {
                        runTempFile = fTempFile;
                        runProcessDebug = true;
                        runProcessDebugPCode = doPCode;
                        runTempFiles = tempFiles;
                        runningSWF = swf;
                        runningPreparation = new SwfDebugPrepare(doPCode);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        Main.stopWork();
                        Main.startWork(AppStrings.translate("work.debugging.start") + "...", null, true);
                        Main.startDebugger();
                        Main.runPlayer(AppStrings.translate("work.debugging.wait"), playerLocation, fTempFile.getAbsolutePath(), flashVars);
                        return;
                    }
                }
            };
            Main.startWork(AppStrings.translate("work.debugging.instrumenting"), instrumentWorker);
            instrumentWorker.execute();
        }
    }

    public static boolean isDebugging() {
        return Main.isDebugRunning();
    }

    public static synchronized int getIp(Object pack) {
        return Main.getDebugHandler().getBreakIp();
    }

    public static synchronized String getIpClass() {
        return Main.getDebugHandler().getBreakScriptName();
    }

    public static synchronized List<Integer> getStackLines() {
        return Main.getDebugHandler().getStackLines();
    }

    public static synchronized List<String> getStackClasses() {
        return Main.getDebugHandler().getStackScripts();
    }

    public static synchronized boolean isBreakPointValid(String scriptName, int line) {
        SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
        return !Main.getDebugHandler().isBreakpointInvalid(swf, scriptName, line);
    }

    public static synchronized void addBreakPoint(String scriptName, int line) {
        SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
        Main.getDebugHandler().addBreakPoint(swf, scriptName, line);
    }

    public static synchronized void removeBreakPoint(String scriptName, int line) {
        SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
        Main.getDebugHandler().removeBreakPoint(swf, scriptName, line);
    }

    public static synchronized boolean toggleBreakPoint(String scriptName, int line) {
        SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
        if (Main.getDebugHandler().isBreakpointToAdd(swf, scriptName, line) || Main.getDebugHandler().isBreakpointConfirmed(swf, scriptName, line) || Main.getDebugHandler().isBreakpointInvalid(swf, scriptName, line)) {
            Main.getDebugHandler().removeBreakPoint(swf, scriptName, line);
            return false;
        }
        Main.getDebugHandler().addBreakPoint(swf, scriptName, line);
        return true;
    }

    public static synchronized Map<String, Set<Integer>> getPackBreakPoints(boolean validOnly, String swfHash) {
        SWF swf = Main.getSwfByHash(swfHash);
        return Main.getDebugHandler().getAllBreakPoints(swf, validOnly);
    }

    public static synchronized Set<Integer> getScriptBreakPoints(String pack, boolean onlyValid) {
        SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
        return Main.getDebugHandler().getBreakPoints(swf, pack, onlyValid);
    }

    public static DebuggerHandler getDebugHandler() {
        return debugHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureMainFrame() {
        if (mainFrame != null) return;
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (mainFrame != null) return;
            MainFrame frame = (Boolean)Configuration.useRibbonInterface.get() != false ? new MainFrameRibbon() : new MainFrameClassic();
            frame.getPanel().setErrorState(ErrorLogFrame.getInstance().getErrorState());
            mainFrame = frame;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    public static Component getDefaultMessagesComponent() {
        if (mainFrame != null) {
            return mainFrame.getPanel();
        }
        return null;
    }

    public static Window getDefaultDialogsOwner() {
        if (mainFrame != null) {
            return mainFrame.getWindow();
        }
        return null;
    }

    public static void loadFromMemory() {
        if (loadFromMemoryFrame == null) {
            loadFromMemoryFrame = new LoadFromMemoryFrame(mainFrame);
        }
        loadFromMemoryFrame.setVisible(true);
    }

    public static void setVariable(long parentId, String varName, int valueType, Object value) {
        Main.getDebugHandler().setVariable(parentId, varName, valueType, value);
    }

    public static void setSubLimiter(boolean value) {
        AVM2Code.toSourceLimit = value ? (Integer)Configuration.sublimiter.get() : -1;
    }

    public static synchronized boolean isInited() {
        return inited;
    }

    public static synchronized void setSessionLoaded(boolean v) {
        inited = v;
    }

    public static boolean isWorking() {
        return working;
    }

    public static void continueWork(String name) {
        Main.continueWork(name, -1);
    }

    public static void continueWork(String name, int percent) {
        Main.startWork(name, percent, mainFrame.getPanel().getCurrentWorker());
    }

    public static void startWork(String name, CancellableWorker worker) {
        Main.startWork(name, -1, worker, false);
    }

    public static void startWork(String name, CancellableWorker worker, boolean force) {
        Main.startWork(name, -1, worker, force);
    }

    public static void startWork(String name, int percent, CancellableWorker worker) {
        Main.startWork(name, percent, worker, false);
    }

    public static void startWork(String name, int percent, CancellableWorker worker, boolean force) {
        working = true;
        long nowTime = System.currentTimeMillis();
        if (mainFrame != null && nowTime < lastTimeStartWork + 1000L) {
            mainFrame.getPanel().setWorkStatusHidden(name, worker);
            return;
        }
        lastTimeStartWork = nowTime;
        View.execInEventDispatchLater(() -> {
            if (mainFrame != null) {
                mainFrame.getPanel().setWorkStatus(name, worker);
                if (percent == -1) {
                    mainFrame.getPanel().hidePercent();
                } else {
                    mainFrame.getPanel().setPercent(percent);
                }
            }
            if (loadingDialog != null) {
                loadingDialog.setDetail(name);
                loadingDialog.setPercent(percent);
            }
        });
        if (CommandLineArgumentParser.isCommandLineMode()) {
            System.out.println(name);
        }
    }

    public static void stopWork() {
        working = false;
        lastTimeStartWork = 0L;
        View.execInEventDispatchLater(() -> {
            if (mainFrame != null) {
                mainFrame.getPanel().setWorkStatus("", null);
            }
            if (loadingDialog != null) {
                loadingDialog.setDetail("");
            }
        });
    }

    public static void populateSwfs(SWF swfParent, List<SWF> output) {
        for (Tag t : swfParent.getTags()) {
            if (!(t instanceof DefineBinaryDataTag)) continue;
            DefineBinaryDataTag b = (DefineBinaryDataTag)t;
            if (b.innerSwf == null) continue;
            output.add(b.innerSwf);
            Main.populateSwfs(b.innerSwf, output);
        }
    }

    public static OpenableList parseOpenable(final OpenableSourceInfo sourceInfo) throws Exception {
        OpenableList result = new OpenableList();
        InputStream inputStream = sourceInfo.getInputStream();
        Bundle bundle = null;
        FileInputStream fis = null;
        if (inputStream == null) {
            fis = new FileInputStream(sourceInfo.getFile());
            inputStream = new BufferedInputStream(fis);
            bundle = sourceInfo.getBundle(false, SearchMode.ALL);
            logger.log(Level.INFO, "Load file: {0}", sourceInfo.getFile());
        } else if (inputStream instanceof SeekableInputStream || inputStream instanceof BufferedInputStream) {
            try {
                inputStream.reset();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            logger.log(Level.INFO, "Load stream: {0}", sourceInfo.getFileTitle());
        }
        Stopwatch sw = Stopwatch.startNew();
        if (bundle != null) {
            if (bundle.isReadOnly()) {
                View.execInEventDispatchLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewMessages.showMessageDialog(Main.getMainFrame().getWindow(), AppStrings.translate("warning.readonly").replace("%file%", sourceInfo.getFileTitleOrName()), AppStrings.translate("message.warning"), 2, (ConfigurationItem<Boolean>)Configuration.warningOpeningReadOnly);
                    }
                });
            }
            result.bundle = bundle;
            final String fname = result.name = new File(sourceInfo.getFileTitleOrName()).getName();
            for (final Map.Entry streamEntry : bundle.getAll().entrySet()) {
                final InputStream stream = (InputStream)streamEntry.getValue();
                stream.reset();
                CancellableWorker worker = null;
                if (((String)streamEntry.getKey()).toLowerCase().endsWith(".abc")) {
                    CancellableWorker<ABC> abcWorker = new CancellableWorker<ABC>("parseOpenable"){

                        private ABC open(InputStream is, String file, String fileTitle) throws IOException, InterruptedException {
                            SWF dummySwf = new SWF();
                            dummySwf.setFileTitle(fileTitle != null ? fileTitle : file);
                            FileAttributesTag fileAttributes = new FileAttributesTag(dummySwf);
                            fileAttributes.actionScript3 = true;
                            dummySwf.addTag((Tag)fileAttributes);
                            fileAttributes.setTimelined((Timelined)dummySwf);
                            DoABC2Tag doABC2Tag = new DoABC2Tag(dummySwf);
                            dummySwf.addTag((Tag)doABC2Tag);
                            doABC2Tag.setTimelined((Timelined)dummySwf);
                            dummySwf.clearModified();
                            Main.startWork(AppStrings.translate("work.reading.abc"), this);
                            ABC abc = new ABC(new ABCInputStream(new MemoryInputStream(Helper.readStream((InputStream)is))), dummySwf, (ABCContainerTag)doABC2Tag, file, fileTitle);
                            doABC2Tag.setABC(abc);
                            return abc;
                        }

                        protected ABC doInBackground() throws Exception {
                            return this.open(stream, null, (String)streamEntry.getKey());
                        }

                        protected void done() {
                            Main.stopWork();
                        }
                    };
                    worker = abcWorker;
                } else {
                    CancellableWorker<SWF> swfWorker = new CancellableWorker<SWF>("bundleSwfWorker"){

                        public SWF doInBackground() throws Exception {
                            final 10 worker = this;
                            String fileKey = fname + "/" + (String)streamEntry.getKey();
                            SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration((String)fileKey);
                            String charset = conf == null ? Charset.defaultCharset().name() : conf.getCustomData("charset", Charset.defaultCharset().name());
                            SWF swf = new SWF(stream, null, (String)streamEntry.getKey(), new ProgressListener(){

                                public void progress(int p) {
                                    Main.startWork(AppStrings.translate("work.reading.swf"), p, worker);
                                }

                                public void status(String status) {
                                    if ("renaming.identifiers".equals(status)) {
                                        Main.startWork(AppStrings.translate("work.renaming.identifiers"), worker);
                                    }
                                }
                            }, ((Boolean)Configuration.parallelSpeedUp.get()).booleanValue(), charset);
                            return swf;
                        }
                    };
                    worker = swfWorker;
                }
                loadingDialog.setWorker(worker);
                worker.execute();
                try {
                    result.add((Openable)worker.get());
                }
                catch (CancellationException ex) {
                    logger.log(Level.WARNING, "Loading SWF {0} was cancelled.", streamEntry.getKey());
                }
            }
        } else {
            final InputStream fInputStream = inputStream;
            CancellableWorker worker = null;
            if (sourceInfo.getKind() == OpenableSourceKind.ABC) {
                CancellableWorker<ABC> abcWorker = new CancellableWorker<ABC>("abcWorker"){

                    private ABC open(InputStream is, String file, String fileTitle) throws IOException, InterruptedException {
                        SWF dummySwf = new SWF();
                        dummySwf.setFileTitle(fileTitle != null ? fileTitle : file);
                        FileAttributesTag fileAttributes = new FileAttributesTag(dummySwf);
                        fileAttributes.actionScript3 = true;
                        dummySwf.addTag((Tag)fileAttributes);
                        fileAttributes.setTimelined((Timelined)dummySwf);
                        DoABC2Tag doABC2Tag = new DoABC2Tag(dummySwf);
                        dummySwf.addTag((Tag)doABC2Tag);
                        doABC2Tag.setTimelined((Timelined)dummySwf);
                        dummySwf.clearModified();
                        Main.startWork(AppStrings.translate("work.reading.abc"), this);
                        ABC abc = new ABC(new ABCInputStream(new MemoryInputStream(Helper.readStream((InputStream)is))), dummySwf, (ABCContainerTag)doABC2Tag, file, fileTitle);
                        doABC2Tag.setABC(abc);
                        return abc;
                    }

                    protected ABC doInBackground() throws Exception {
                        return this.open(fInputStream, sourceInfo.getFile(), sourceInfo.getFileTitle());
                    }

                    protected void done() {
                        Main.stopWork();
                    }
                };
                worker = abcWorker;
            } else if (sourceInfo.getKind() == OpenableSourceKind.SWF) {
                final String[] yesno = new String[]{AppStrings.translate("button.yes"), AppStrings.translate("button.no"), AppStrings.translate("button.yes.all"), AppStrings.translate("button.no.all")};
                CancellableWorker<SWF> swfWorker = new CancellableWorker<SWF>("swfWorker"){
                    private boolean yestoall;
                    private boolean notoall;
                    {
                        super(x0);
                        this.yestoall = false;
                        this.notoall = false;
                    }

                    private SWF open(InputStream is, String file, String fileTitle) throws IOException, InterruptedException {
                        String impAssetsStr;
                        final 12 worker = this;
                        String shortName = fileTitle != null ? fileTitle : file;
                        String fileKey = shortName == null ? "" : new File(shortName).getName();
                        SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration((String)fileKey);
                        String charset = conf == null ? Charset.defaultCharset().name() : conf.getCustomData("charset", "WINDOWS-1252");
                        final ArrayList loadedUrls = new ArrayList();
                        final ArrayList loadedStatus = new ArrayList();
                        final HashMap<String, String> configuredImportAssets = new HashMap<String, String>();
                        if (conf != null && (impAssetsStr = conf.getCustomData("loadedImportAssets", "")) != null && !impAssetsStr.isEmpty()) {
                            String[] parts;
                            for (String s : parts = (impAssetsStr + Main.IMPORT_ASSETS_SEPARATOR).split(Pattern.quote(Main.IMPORT_ASSETS_SEPARATOR))) {
                                if (s.isEmpty()) continue;
                                String[] urlPlusStatus = (s + "|").split(Pattern.quote("|"));
                                String url = urlPlusStatus[0];
                                String status = urlPlusStatus[1];
                                configuredImportAssets.put(url, status);
                            }
                        }
                        SWF swf = new SWF(is, file, fileTitle, new ProgressListener(){

                            public void progress(int p) {
                                Main.startWork(AppStrings.translate("work.reading.swf"), p, worker);
                            }

                            public void status(String status) {
                                if ("renaming.identifiers".equals(status)) {
                                    Main.startWork(AppStrings.translate("work.renaming.identifiers"), worker);
                                }
                            }
                        }, ((Boolean)Configuration.parallelSpeedUp.get()).booleanValue(), false, true, new UrlResolver(){

                            public SWF resolveUrl(String file, final String url) {
                                loadedUrls.add(url);
                                File selFile = null;
                                int opt = -1;
                                if (configuredImportAssets.containsKey(url)) {
                                    String statusStr = (String)configuredImportAssets.get(url);
                                    if (statusStr.equals("NO")) {
                                        loadedStatus.add("NO");
                                        return null;
                                    }
                                    if (statusStr.startsWith("CUSTOM:")) {
                                        selFile = new File(statusStr.substring("CUSTOM:".length()));
                                    }
                                } else {
                                    if (!yestoall && !notoall) {
                                        opt = ViewMessages.showOptionDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("message.imported.swf").replace("%url%", url), AppStrings.translate("message.warning"), 0, 2, null, yesno, AppStrings.translate("button.yes"));
                                        if (opt == 2) {
                                            yestoall = true;
                                        }
                                        if (opt == 3) {
                                            notoall = true;
                                        }
                                    }
                                    if (yestoall) {
                                        opt = 0;
                                    } else if (notoall) {
                                        opt = 1;
                                    }
                                    if (opt == 1) {
                                        loadedStatus.add("NO");
                                        return null;
                                    }
                                }
                                if (selFile == null && (url.startsWith("http://") || url.startsWith("https://"))) {
                                    try {
                                        URL u = URI.create(url).toURL();
                                        SWF ret = this.open(u.openStream(), null, url);
                                        loadedStatus.add("YES");
                                        return ret;
                                    }
                                    catch (Exception u) {}
                                } else {
                                    File gfx;
                                    File swf;
                                    File file2 = swf = selFile != null ? selFile : new File(new File(file).getParentFile(), url);
                                    if (swf.exists()) {
                                        try {
                                            SWF ret = this.open(new FileInputStream(swf), swf.getAbsolutePath(), swf.getName());
                                            if (selFile != null) {
                                                loadedStatus.add("CUSTOM:" + selFile.getAbsolutePath());
                                            } else {
                                                loadedStatus.add("YES");
                                            }
                                            return ret;
                                        }
                                        catch (Exception ret) {
                                            // empty catch block
                                        }
                                    }
                                    if (selFile == null && url.endsWith(".swf") && (gfx = new File(new File(file).getParentFile(), url.substring(0, url.length() - 4) + ".gfx")).exists()) {
                                        try {
                                            SWF ret = this.open(new FileInputStream(gfx), gfx.getAbsolutePath(), gfx.getName());
                                            loadedStatus.add("YES");
                                            return ret;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                                final Reference ret = new Reference(null);
                                View.execInEventDispatch(new Runnable(){

                                    @Override
                                    public void run() {
                                        while (0 == ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("message.imported.swf.manually").replace("%url%", url), AppStrings.translate("error"), 0, 0)) {
                                            JFileChooser fc = new JFileChooser();
                                            fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
                                            FileFilter allSupportedFilter = new FileFilter(){
                                                private final String[] supportedExtensions = new String[]{".swf", ".spl", ".swt", ".gfx"};

                                                @Override
                                                public boolean accept(File f) {
                                                    String name = f.getName().toLowerCase(Locale.ENGLISH);
                                                    for (String ext : this.supportedExtensions) {
                                                        if (!name.endsWith(ext)) continue;
                                                        return true;
                                                    }
                                                    return f.isDirectory();
                                                }

                                                @Override
                                                public String getDescription() {
                                                    String exts = Helper.joinStrings((String[])this.supportedExtensions, (String)"*%s", (String)"; ");
                                                    return AppStrings.translate("filter.supported") + " (" + exts + ")";
                                                }
                                            };
                                            fc.setFileFilter(allSupportedFilter);
                                            FileFilter swfFilter = new FileFilter(){

                                                @Override
                                                public boolean accept(File f) {
                                                    return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swf") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".spl") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swt") || f.isDirectory();
                                                }

                                                @Override
                                                public String getDescription() {
                                                    return AppStrings.translate("filter.swf_spl_swt");
                                                }
                                            };
                                            fc.addChoosableFileFilter(swfFilter);
                                            FileFilter swtFilter = new FileFilter(){

                                                @Override
                                                public boolean accept(File f) {
                                                    return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swt") || f.isDirectory();
                                                }

                                                @Override
                                                public String getDescription() {
                                                    return AppStrings.translate("filter.swt");
                                                }
                                            };
                                            fc.addChoosableFileFilter(swtFilter);
                                            FileFilter gfxFilter = new FileFilter(){

                                                @Override
                                                public boolean accept(File f) {
                                                    return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".gfx") || f.isDirectory();
                                                }

                                                @Override
                                                public String getDescription() {
                                                    return AppStrings.translate("filter.gfx");
                                                }
                                            };
                                            fc.addChoosableFileFilter(gfxFilter);
                                            fc.setAcceptAllFileFilterUsed(false);
                                            int returnVal = fc.showOpenDialog(Main.getDefaultMessagesComponent());
                                            if (returnVal != 0) break;
                                            Configuration.lastOpenDir.set((Object)Helper.fixDialogFile((File)fc.getSelectedFile()).getParentFile().getAbsolutePath());
                                            File selFile = Helper.fixDialogFile((File)fc.getSelectedFile());
                                            try {
                                                ret.setVal((Object)this.open(new FileInputStream(selFile), selFile.getAbsolutePath(), selFile.getName()));
                                                loadedStatus.add("CUSTOM:" + selFile.getAbsolutePath());
                                                return;
                                            }
                                            catch (Exception exception) {
                                            }
                                        }
                                        loadedStatus.add("NO");
                                    }
                                });
                                return (SWF)ret.getVal();
                            }
                        }, charset);
                        if (!loadedUrls.isEmpty()) {
                            SwfSpecificCustomConfiguration cc2 = Configuration.getOrCreateSwfSpecificCustomConfiguration((String)swf.getShortPathTitle());
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < loadedUrls.size(); ++i) {
                                if (i > 0) {
                                    sb.append(Main.IMPORT_ASSETS_SEPARATOR);
                                }
                                sb.append((String)loadedUrls.get(i));
                                sb.append("|");
                                sb.append((String)loadedStatus.get(i));
                            }
                            cc2.setCustomData("loadedImportAssets", sb.toString());
                        }
                        return swf;
                    }

                    public SWF doInBackground() throws Exception {
                        return this.open(fInputStream, sourceInfo.getFile(), sourceInfo.getFileTitle());
                    }
                };
                worker = swfWorker;
            }
            if (loadingDialog != null) {
                loadingDialog.setWorker(worker);
            }
            worker.execute();
            try {
                result.add((Openable)worker.get());
                worker.free();
                worker = null;
            }
            catch (CancellationException ex) {
                logger.log(Level.WARNING, "Loading SWF {0} was cancelled.", sourceInfo.getFileTitleOrName());
            }
        }
        if (fis != null) {
            logger.log(Level.INFO, "File loaded in {0} seconds.", sw.getElapsedMilliseconds() / 1000L);
            fis.close();
        } else {
            logger.log(Level.INFO, "Stream loaded in {0} seconds.", sw.getElapsedMilliseconds() / 1000L);
        }
        result.sourceInfo = sourceInfo;
        boolean hasVideoStreams = false;
        for (Openable openable : result) {
            openable.setOpenableList(result);
            if (!(openable instanceof SWF)) continue;
            SWF swf = (SWF)openable;
            logger.log(Level.INFO, "");
            logger.log(Level.INFO, "== File information ==");
            logger.log(Level.INFO, "Size: {0}", Helper.formatFileSize((long)swf.fileSize));
            logger.log(Level.INFO, "Flash version: {0}", swf.version);
            int width = (int)((double)(swf.displayRect.Xmax - swf.displayRect.Xmin) / 20.0);
            int height = (int)((double)(swf.displayRect.Ymax - swf.displayRect.Ymin) / 20.0);
            logger.log(Level.INFO, "Width: {0}", width);
            logger.log(Level.INFO, "Height: {0}", height);
            for (Tag t : swf.getTags()) {
                if (!(t instanceof DefineVideoStreamTag)) continue;
                hasVideoStreams = true;
            }
            swf.addEventListener(new EventListener(){

                public void handleExportingEvent(String type, int index, int count, Object data) {
                    String text = AppStrings.translate("work.exporting");
                    if (type != null && type.length() > 0) {
                        text = text + " " + type;
                    }
                    Main.continueWork(text + " " + index + "/" + count + " " + data);
                }

                public void handleExportedEvent(String type, int index, int count, Object data) {
                    String text = AppStrings.translate("work.exported");
                    if (type != null && type.length() > 0) {
                        text = text + " " + type;
                    }
                    Main.continueWork(text + " " + index + "/" + count + " " + data);
                }

                public void handleEvent(String event, Object data) {
                    if (event.equals("exporting") || event.equals("exported")) {
                        throw new Error("Event is not supported by this handler.");
                    }
                    if (event.equals("getVariables")) {
                        Main.continueWork(AppStrings.translate("work.gettingvariables") + "..." + (String)data);
                    }
                    if (event.equals("deobfuscate")) {
                        Main.continueWork(AppStrings.translate("work.deobfuscating") + "..." + (String)data);
                    }
                    if (event.equals("deobfuscate_pcode")) {
                        Main.startWork(AppStrings.translate("work.deobfuscating_pcode") + "..." + (String)data, deobfuscatePCodeWorker);
                    }
                    if (event.equals("rename")) {
                        Main.continueWork(AppStrings.translate("work.renaming") + "..." + (String)data);
                    }
                    if (event.equals("importing_as")) {
                        Main.startWork(AppStrings.translate("work.importing_as") + "..." + (String)data, importWorker);
                    }
                    if (event.equals("uninitializedClassFields")) {
                        Main.continueWork(AppStrings.translate("work.decompiling") + "..." + (String)data);
                    }
                }
            });
        }
        if (hasVideoStreams && !DefineVideoStreamTag.displayAvailable()) {
            View.execInEventDispatchLater(new Runnable(){

                @Override
                public void run() {
                    ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("message.video.installvlc").replace("%file%", sourceInfo.getFileTitleOrName()), AppStrings.translate("message.warning"), 2, (ConfigurationItem<Boolean>)Configuration.warningVideoVlc);
                }
            });
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveFileToExe(SWF swf, ExeExportMode exeExportMode, File tmpFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(tmpFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            switch (exeExportMode) {
                case WRAPPER: {
                    InputStream exeStream = View.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/Swf2Exe.bin");
                    Helper.copyStream((InputStream)exeStream, (OutputStream)bos);
                    int width = swf.displayRect.Xmax - swf.displayRect.Xmin;
                    int height = swf.displayRect.Ymax - swf.displayRect.Ymin;
                    bos.write(width & 0xFF);
                    bos.write(width >> 8 & 0xFF);
                    bos.write(width >> 16 & 0xFF);
                    bos.write(width >> 24 & 0xFF);
                    bos.write(height & 0xFF);
                    bos.write(height >> 8 & 0xFF);
                    bos.write(height >> 16 & 0xFF);
                    bos.write(height >> 24 & 0xFF);
                    bos.write((Integer)Configuration.saveAsExeScaleMode.get());
                    break;
                }
                case PROJECTOR_WIN: 
                case PROJECTOR_MAC: 
                case PROJECTOR_LINUX: {
                    File projectorFile = Configuration.getProjectorFile((ExeExportMode)exeExportMode);
                    if (projectorFile == null) {
                        String message = "Projector not found, please place it to " + Configuration.getProjectorPath();
                        logger.log(Level.SEVERE, message);
                        throw new IOException(message);
                    }
                    Helper.copyStream((InputStream)new FileInputStream(projectorFile), (OutputStream)bos);
                    bos.flush();
                    break;
                }
            }
            long pos = fos.getChannel().position();
            swf.saveTo((OutputStream)bos);
            switch (exeExportMode) {
                case PROJECTOR_WIN: 
                case PROJECTOR_MAC: 
                case PROJECTOR_LINUX: {
                    bos.flush();
                    int swfSize = (int)(fos.getChannel().position() - pos);
                    bos.write(86);
                    bos.write(52);
                    bos.write(18);
                    bos.write(250);
                    bos.write(swfSize & 0xFF);
                    bos.write(swfSize >> 8 & 0xFF);
                    bos.write(swfSize >> 16 & 0xFF);
                    bos.write(swfSize >> 24 & 0xFF);
                    return;
                }
            }
            return;
        }
    }

    public static void saveFile(Openable openable, String outfile) throws IOException {
        Main.saveFile(openable, outfile, SaveFileMode.SAVE, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveFile(Openable openable, String outfile, SaveFileMode mode, ExeExportMode exeExportMode) throws IOException {
        File tmpFile;
        File outfileF;
        File savedFile;
        block31: {
            savedFile = new File(outfile);
            Main.startSaving(savedFile);
            if (mode == SaveFileMode.SAVEAS && openable.getOpenableList() != null && !openable.getOpenableList().isBundle()) {
                openable.setFile(outfile);
                OpenableSourceInfo sourceInfo = openable.getOpenableList().sourceInfo;
                sourceInfo.setFile(outfile);
                sourceInfo.setFileTitle(null);
                if (mainFrame != null && mainFrame.getPanel() != null) {
                    mainFrame.getPanel().refreshPins();
                }
            }
            outfileF = new File(outfile);
            tmpFile = new File(outfile + ".tmp");
            try {
                if (mode == SaveFileMode.EXE) {
                    Main.saveFileToExe((SWF)openable, exeExportMode, tmpFile);
                    break block31;
                }
                if (openable instanceof SWF) {
                    SWF swf = (SWF)openable;
                    swf.saveNestedDefineBinaryData();
                }
                try (FileOutputStream fos = new FileOutputStream(tmpFile);
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    openable.saveTo((OutputStream)bos);
                }
            }
            catch (Throwable t) {
                Main.stopSaving(savedFile);
                if (!tmpFile.exists()) throw t;
                tmpFile.delete();
                throw t;
            }
        }
        if (!tmpFile.exists()) throw new IOException("Output not found");
        if (tmpFile.length() <= 0L) throw new IOException("Output is empty");
        outfileF.delete();
        if (!tmpFile.renameTo(outfileF)) {
            tmpFile.delete();
            throw new IOException("Cannot access " + outfile);
        }
        Main.stopSaving(savedFile);
    }

    public static boolean reloadSWFs() {
        CancellableWorker.cancelBackgroundThreads();
        if (sourceInfos.isEmpty()) {
            Helper.freeMem();
            Main.showModeFrame();
            return true;
        }
        for (int i = sourceInfos.size() - 1; i >= 0; --i) {
            if (!sourceInfos.get(i).isEmpty()) continue;
            sourceInfos.remove(i);
        }
        OpenableSourceInfo[] sourceInfosCopy = new OpenableSourceInfo[sourceInfos.size()];
        sourceInfos.toArray(sourceInfosCopy);
        sourceInfos.clear();
        Main.openFile(sourceInfosCopy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void reloadApp() {
        if (debugDialog != null) {
            debugDialog.setVisible(false);
            debugDialog.dispose();
            debugDialog = null;
        }
        if (loadingDialog != null) {
            Class<Main> clazz = Main.class;
            // MONITORENTER : com.jpexs.decompiler.flash.gui.Main.class
            if (loadingDialog != null) {
                loadingDialog.setVisible(false);
                loadingDialog.dispose();
                loadingDialog = null;
            }
            // MONITOREXIT : clazz
        }
        if (loadFromMemoryFrame != null) {
            loadFromMemoryFrame.setVisible(false);
            loadFromMemoryFrame.dispose();
            loadFromMemoryFrame = null;
        }
        if (mainFrame != null) {
            mainFrame.setVisible(false);
            mainFrame.getPanel().closeAll(false, false);
            mainFrame.dispose();
            mainFrame = null;
        }
        FontTag.reload();
        Cache.clearAll();
        Main.initGui();
        Main.reloadSWFs();
    }

    public static void newFile() {
        View.checkAccess();
        NewFileDialog newFileDialog = new NewFileDialog(Main.getDefaultDialogsOwner());
        if (newFileDialog.showDialog() == 0) {
            if (mainFrame != null && !((Boolean)Configuration.openMultipleFiles.get()).booleanValue()) {
                sourceInfos.clear();
                mainFrame.getPanel().closeAll(false, false);
                mainFrame.setVisible(false);
                Helper.freeMem();
            }
            String ext = newFileDialog.isGfx() ? "gfx" : "swf";
            String fileTitle = AppStrings.translate("new.filename") + "." + ext;
            OpenableSourceInfo sourceInfo = new OpenableSourceInfo(fileTitle);
            sourceInfos.add(sourceInfo);
            OpenableList list = new OpenableList();
            list.sourceInfo = sourceInfo;
            SWF swf = new SWF();
            swf.setFile(null);
            swf.setFileTitle(fileTitle);
            swf.displayRect = new RECT(newFileDialog.getXMin(), newFileDialog.getXMax(), newFileDialog.getYMin(), newFileDialog.getYmax());
            swf.compression = newFileDialog.getCompression();
            swf.version = newFileDialog.getVersionNumber();
            swf.frameRate = newFileDialog.getFrameRate();
            swf.gfx = newFileDialog.isGfx();
            swf.setHeaderModified(true);
            FileAttributesTag f = new FileAttributesTag(swf);
            if (newFileDialog.isAs3()) {
                f.actionScript3 = true;
            }
            FileAttributesTag t = f;
            t.setTimelined((Timelined)swf);
            swf.addTag((Tag)t);
            t = new SetBackgroundColorTag(swf, new RGB(newFileDialog.getBackgroundColor()));
            t.setTimelined((Timelined)swf);
            swf.addTag((Tag)t);
            t = new ShowFrameTag(swf);
            t.setTimelined((Timelined)swf);
            swf.addTag((Tag)t);
            swf.frameCount = 1;
            swf.hasEndTag = true;
            list.add((Openable)swf);
            swf.openableList = list;
            mainFrame.getPanel().load(list, true);
            mainFrame.getPanel().setTagTreeSelectedNode(mainFrame.getPanel().getCurrentTree(), (TreeItem)swf.getTimeline().getFrame(0));
        }
    }

    public static OpenFileResult openFile(String swfFile, String fileTitle) {
        View.checkAccess();
        return Main.openFile(swfFile, fileTitle, null, true);
    }

    public static OpenFileResult openFile(String swfFile, String fileTitle, final Runnable executeAfterOpen, boolean loadSession) {
        View.checkAccess();
        try {
            File file = new File(swfFile);
            if (!file.exists()) {
                ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("open.error.fileNotFound"), AppStrings.translate("open.error"), 0);
                return OpenFileResult.NOT_FOUND;
            }
            swfFile = file.getCanonicalPath();
            OpenableSourceInfo sourceInfo = new OpenableSourceInfo(null, swfFile, fileTitle);
            OpenFileResult openResult = Main.openFile(sourceInfo, new OpenableOpened(){

                @Override
                public void opened(Openable openable) {
                    if (executeAfterOpen != null) {
                        executeAfterOpen.run();
                    }
                }
            }, loadSession);
            return openResult;
        }
        catch (IOException ex) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("open.error.cannotOpen"), AppStrings.translate("open.error"), 0);
            return OpenFileResult.ERROR;
        }
    }

    public static OpenFileResult openFile(OpenableSourceInfo sourceInfo) {
        View.checkAccess();
        return Main.openFile(sourceInfo, true);
    }

    public static OpenFileResult openFile(OpenableSourceInfo sourceInfo, boolean loadSession) {
        View.checkAccess();
        return Main.openFile(new OpenableSourceInfo[]{sourceInfo}, loadSession);
    }

    public static OpenFileResult openFile(OpenableSourceInfo sourceInfo, OpenableOpened executeAfterOpen, boolean loadSession) {
        View.checkAccess();
        return Main.openFile(new OpenableSourceInfo[]{sourceInfo}, executeAfterOpen, loadSession);
    }

    public static OpenFileResult openFile(OpenableSourceInfo sourceInfo, OpenableOpened executeAfterOpen, int reloadIndex, boolean loadSession) {
        View.checkAccess();
        return Main.openFile(new OpenableSourceInfo[]{sourceInfo}, executeAfterOpen, new int[]{reloadIndex}, loadSession);
    }

    public static OpenFileResult openFile(OpenableSourceInfo[] newSourceInfos) {
        View.checkAccess();
        return Main.openFile(newSourceInfos, true);
    }

    public static OpenFileResult openFile(OpenableSourceInfo[] newSourceInfos, boolean loadSession) {
        View.checkAccess();
        return Main.openFile(newSourceInfos, null, loadSession);
    }

    public static OpenFileResult openFile(OpenableSourceInfo[] newSourceInfos, OpenableOpened executeAfterOpen, boolean loadSession) {
        View.checkAccess();
        return Main.openFile(newSourceInfos, executeAfterOpen, null, loadSession);
    }

    public static OpenFileResult openFile(OpenableSourceInfo[] newSourceInfos, OpenableOpened executeAfterOpen, int[] reloadIndices, boolean loadSession) {
        View.checkAccess();
        if (mainFrame != null && !((Boolean)Configuration.openMultipleFiles.get()).booleanValue()) {
            sourceInfos.clear();
            mainFrame.getPanel().closeAll(false, false);
            mainFrame.setVisible(false);
            Helper.freeMem();
            reloadIndices = null;
        }
        loadingDialog.setVisible(true);
        for (int i = 0; i < newSourceInfos.length; ++i) {
            OpenableSourceInfo si = newSourceInfos[i];
            String fileName = si.getFile();
            if (fileName == null) continue;
            Configuration.addRecentFile((String)fileName);
            SharedObjectsStorage.addChangedListener(new File(fileName), new CookiesChangedListener(){
                Timer timer;

                @Override
                public void cookiesChanged(File swfFile, List<File> cookies) {
                    if (this.timer != null) {
                        return;
                    }
                    this.timer = new Timer();
                    this.timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            View.execInEventDispatchLater(new Runnable(){

                                @Override
                                public void run() {
                                    Main.getMainFrame().getPanel().refreshTree();
                                    timer = null;
                                }
                            });
                        }
                    }, 500L);
                }
            });
            if (watcher == null || !((Boolean)Configuration.checkForModifications.get()).booleanValue()) continue;
            try {
                File dir = new File(fileName).getParentFile();
                if (dir == null || watchedDirectories.containsValue(dir)) continue;
                WatchKey key = dir.toPath().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                watchedDirectories.put(key, dir);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        OpenFileWorker wrk = new OpenFileWorker(newSourceInfos, executeAfterOpen, reloadIndices, loadSession);
        wrk.execute();
        if (reloadIndices == null) {
            sourceInfos.addAll(Arrays.asList(newSourceInfos));
        } else {
            for (int i = 0; i < reloadIndices.length; ++i) {
                sourceInfos.set(reloadIndices[i], newSourceInfos[i]);
            }
        }
        return OpenFileResult.OK;
    }

    public static void closeFile(OpenableList openableList) {
        View.checkAccess();
        sourceInfos.remove(openableList.sourceInfo);
        mainFrame.getPanel().close(openableList);
    }

    public static void reloadFile(OpenableList swf) {
        View.checkAccess();
        for (Openable o : swf.items) {
            SwfSpecificCustomConfiguration cc = Configuration.getSwfSpecificCustomConfiguration((String)o.getShortPathTitle());
            if (cc == null) continue;
            cc.setCustomData("loadedImportAssets", "");
        }
        if (mainFrame != null) {
            for (Openable o : swf.items) {
                mainFrame.getPanel().closeAbcExplorer(o);
            }
        }
        Main.openFile(swf.sourceInfo, null, sourceInfos.indexOf(swf.sourceInfo), true);
    }

    public static void reloadFile(File file) {
        for (int i = 0; i < sourceInfos.size(); ++i) {
            OpenableSourceInfo info = sourceInfos.get(i);
            if (info.getFile() == null || !file.equals(new File(info.getFile()))) continue;
            Main.openFile(info, null, i, true);
        }
    }

    public static boolean closeAll(boolean onExit) {
        View.checkAccess();
        boolean closeResult = mainFrame.getPanel().closeAll(true, onExit);
        if (closeResult) {
            sourceInfos.clear();
            System.gc();
        }
        if (filesChangedDialog != null) {
            filesChangedDialog.setVisible(false);
        }
        return closeResult;
    }

    public static boolean saveSwc(SWF swf) {
        JFileChooser fc = View.getFileChooserWithIcon("bundleswc");
        fc.setCurrentDirectory(new File((String)Configuration.lastSaveDir.get()));
        String fileTitle = swf.getShortFileName();
        if (fileTitle != null) {
            fileTitle = fileTitle.contains(".") ? fileTitle.substring(0, fileTitle.lastIndexOf(".")) + ".swc" : fileTitle + ".swc";
            fc.setSelectedFile(fc.getCurrentDirectory().toPath().resolve(fileTitle).toFile());
        }
        FileFilter swcFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swc") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swc");
            }
        };
        fc.setFileFilter(swcFilter);
        if (fc.showSaveDialog(Main.getDefaultMessagesComponent()) != 0) {
            return false;
        }
        File file = Helper.fixDialogFile((File)fc.getSelectedFile());
        String fileName = file.getAbsolutePath();
        if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".swc")) {
            fileName = fileName + ".swc";
        }
        SwfToSwcExporter exporter = new SwfToSwcExporter();
        try {
            exporter.exportSwf(swf, new File(fileName), false);
        }
        catch (IOException iex) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), iex.getMessage(), AppStrings.translate("error"), 0);
            return false;
        }
        catch (InterruptedException ex) {
            return false;
        }
        Configuration.lastSaveDir.set((Object)file.getParentFile().getAbsolutePath());
        return true;
    }

    public static boolean saveFileDialog(Openable openable, SaveFileMode mode) {
        String ext = ".swf";
        switch (mode) {
            case SAVE: 
            case SAVEAS: {
                if (openable.getFile() == null) break;
                ext = com.jpexs.helpers.Path.getExtension((String)openable.getFile());
                break;
            }
            case EXE: {
                ext = ".exe";
            }
        }
        String icon = "save";
        if (mode == SaveFileMode.SAVEAS) {
            icon = "saveas";
        }
        if (mode == SaveFileMode.EXE) {
            icon = "saveasexe";
        }
        JFileChooser fc = View.getFileChooserWithIcon(icon);
        fc.setCurrentDirectory(new File((String)Configuration.lastSaveDir.get()));
        FileFilter swfFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swf") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".spl") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swf_spl");
            }
        };
        FileFilter swtFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swt") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swt");
            }
        };
        FileFilter gfxFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".gfx") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.gfx");
            }
        };
        FileFilter abcFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".abc") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.abc");
            }
        };
        ExeExportMode exeExportMode = null;
        FileFilter wrapperFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".exe") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.exe.wrapper");
            }
        };
        FileFilter projectorWinFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".exe") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.exe.projectorWin");
            }
        };
        FileFilter projectorMacFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".dmg") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.exe.projectorMac");
            }
        };
        FileFilter projectorLinuxFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.exe.projectorLinux");
            }
        };
        if (mode == SaveFileMode.EXE) {
            exeExportMode = (ExeExportMode)Configuration.exeExportMode.get();
            if (exeExportMode == null) {
                exeExportMode = ExeExportMode.WRAPPER;
            }
            fc.addChoosableFileFilter(wrapperFilter);
            fc.addChoosableFileFilter(projectorWinFilter);
            fc.addChoosableFileFilter(projectorMacFilter);
            fc.addChoosableFileFilter(projectorLinuxFilter);
            switch (exeExportMode) {
                case WRAPPER: {
                    fc.setFileFilter(wrapperFilter);
                    break;
                }
                case PROJECTOR_WIN: {
                    fc.setFileFilter(projectorWinFilter);
                    break;
                }
                case PROJECTOR_MAC: {
                    fc.setFileFilter(projectorMacFilter);
                    break;
                }
                case PROJECTOR_LINUX: {
                    fc.setFileFilter(projectorLinuxFilter);
                }
            }
        } else if (openable instanceof SWF && ((SWF)openable).gfx) {
            fc.addChoosableFileFilter(swfFilter);
            fc.setFileFilter(gfxFilter);
        } else if (openable instanceof SWF) {
            SWF swf = (SWF)openable;
            if (swf.getFile() != null && swf.getFile().toLowerCase(Locale.ENGLISH).endsWith(".swt")) {
                fc.setFileFilter(swtFilter);
                fc.addChoosableFileFilter(swfFilter);
            } else {
                fc.setFileFilter(swfFilter);
                fc.addChoosableFileFilter(swtFilter);
            }
            fc.addChoosableFileFilter(gfxFilter);
        } else if (openable instanceof ABC) {
            fc.setFileFilter(abcFilter);
        }
        String extension = ext;
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(Main.getDefaultMessagesComponent()) == 0) {
            File file = Helper.fixDialogFile((File)fc.getSelectedFile());
            FileFilter selFilter = fc.getFileFilter();
            try {
                String fileName = file.getAbsolutePath();
                if (selFilter == swfFilter) {
                    if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(extension) && !fileName.toLowerCase(Locale.ENGLISH).endsWith(".spl")) {
                        fileName = fileName + extension;
                    }
                    ((SWF)openable).gfx = false;
                }
                if (selFilter == gfxFilter) {
                    if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".gfx")) {
                        fileName = fileName + ".gfx";
                    }
                    ((SWF)openable).gfx = true;
                }
                if (selFilter == swtFilter && !fileName.toLowerCase(Locale.ENGLISH).endsWith(".swt")) {
                    fileName = fileName + ".swt";
                }
                if (selFilter == abcFilter && !fileName.toLowerCase(Locale.ENGLISH).endsWith(".abc")) {
                    fileName = fileName + ".abc";
                }
                if (selFilter == wrapperFilter) {
                    if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".exe")) {
                        fileName = fileName + ".exe";
                    }
                    exeExportMode = ExeExportMode.WRAPPER;
                }
                if (selFilter == projectorWinFilter) {
                    if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".exe")) {
                        fileName = fileName + ".exe";
                    }
                    exeExportMode = ExeExportMode.PROJECTOR_WIN;
                }
                if (selFilter == projectorMacFilter) {
                    if (!fileName.toLowerCase(Locale.ENGLISH).endsWith(".dmg")) {
                        fileName = fileName + ".dmg";
                    }
                    exeExportMode = ExeExportMode.PROJECTOR_MAC;
                }
                if (selFilter == projectorLinuxFilter) {
                    exeExportMode = ExeExportMode.PROJECTOR_LINUX;
                }
                Main.saveFile(openable, fileName, mode, exeExportMode);
                if (mode == SaveFileMode.EXE && exeExportMode != null) {
                    Configuration.exeExportMode.set((Object)exeExportMode);
                }
                Configuration.lastSaveDir.set((Object)file.getParentFile().getAbsolutePath());
                return true;
            }
            catch (Exception | OutOfMemoryError | StackOverflowError ex) {
                Main.handleSaveError(ex);
            }
        }
        return false;
    }

    public static void handleOutOfMemory(String actionMessage) {
        String errorMessage = actionMessage;
        if (!errorMessage.isEmpty()) {
            errorMessage = errorMessage + " ";
        }
        long heapMaxSize = Runtime.getRuntime().maxMemory();
        long heapMaxSizeMb = heapMaxSize / 1024L / 1024L;
        String currentMaxHeap = "" + heapMaxSizeMb + "m";
        errorMessage = errorMessage + AppStrings.translate("error.outOfMemory").replace("%maxheap%", currentMaxHeap);
        errorMessage = errorMessage + "\n";
        errorMessage = Platform.isWindows() ? errorMessage + AppStrings.translate("error.outOfMemory.windows") : errorMessage + AppStrings.translate("error.outOfMemory.unixmac");
        errorMessage = errorMessage + "\n";
        if (Helper.is64BitOs() && !Helper.is64BitJre()) {
            errorMessage = errorMessage + AppStrings.translate("error.outOfMemory.32BitJreOn64bitOs");
            errorMessage = errorMessage + "\n";
        }
        errorMessage = errorMessage + AppStrings.translate("error.outOfMemory.64bit");
        ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), errorMessage, AppStrings.translate("error.outOfMemory.title"), 0);
    }

    public static void handleSaveError(Throwable ex) {
        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "Error saving file", ex);
        if (ex instanceof OutOfMemoryError) {
            String errorMessage = AppStrings.translate("error.file.save") + ".";
            Main.handleOutOfMemory(errorMessage);
        } else {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), AppStrings.translate("error.file.save") + ": " + ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
        }
    }

    public static boolean openFileDialog() {
        View.checkAccess();
        JFileChooser fc = View.getFileChooserWithIcon("open");
        if (((Boolean)Configuration.openMultipleFiles.get()).booleanValue()) {
            fc.setMultiSelectionEnabled(true);
        }
        fc.setCurrentDirectory(new File((String)Configuration.lastOpenDir.get()));
        FileFilter allSupportedFilter = new FileFilter(){
            private final String[] supportedExtensions = new String[]{".swf", ".spl", ".swt", ".gfx", ".swc", ".zip", ".iggy", ".abc"};

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase(Locale.ENGLISH);
                for (String ext : this.supportedExtensions) {
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                String exts = Helper.joinStrings((String[])this.supportedExtensions, (String)"*%s", (String)"; ");
                return AppStrings.translate("filter.supported") + " (" + exts + ")";
            }
        };
        fc.setFileFilter(allSupportedFilter);
        FileFilter swfFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swf") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".spl") || f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swt") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swf_spl_swt");
            }
        };
        fc.addChoosableFileFilter(swfFilter);
        FileFilter swtFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swt") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swt");
            }
        };
        fc.addChoosableFileFilter(swtFilter);
        FileFilter swcFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".swc") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.swc");
            }
        };
        fc.addChoosableFileFilter(swcFilter);
        FileFilter gfxFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".gfx") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.gfx");
            }
        };
        fc.addChoosableFileFilter(gfxFilter);
        FileFilter iggyFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".iggy") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.iggy");
            }
        };
        fc.addChoosableFileFilter(iggyFilter);
        FileFilter abcFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".abc") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.abc");
            }
        };
        fc.addChoosableFileFilter(abcFilter);
        FileFilter zipFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.zip");
            }
        };
        fc.addChoosableFileFilter(zipFilter);
        FileFilter binaryFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return AppStrings.translate("filter.binary");
            }
        };
        fc.addChoosableFileFilter(binaryFilter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showOpenDialog(Main.getDefaultMessagesComponent());
        if (returnVal == 0) {
            File[] selFiles;
            Configuration.lastOpenDir.set((Object)Helper.fixDialogFile((File)fc.getSelectedFile()).getParentFile().getAbsolutePath());
            for (File file : selFiles = fc.getSelectedFiles()) {
                File selfile = Helper.fixDialogFile((File)file);
                Main.openFile(selfile.getAbsolutePath(), null);
            }
            return true;
        }
        return false;
    }

    public static void displayErrorFrame() {
        ErrorLogFrame.getInstance().setVisible(true);
    }

    private static String md5(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(data);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static void initGui() {
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println("Error: Your system does not support Graphic User Interface");
            Main.exit();
        }
        System.setProperty("sun.java2d.d3d", "false");
        System.setProperty("sun.java2d.noddraw", "true");
        if (System.getProperty("sun.java2d.uiScale") == null) {
            GraphicsConfiguration configuration;
            AffineTransform transform;
            if (!Configuration.uiScale.hasValue() && (transform = (configuration = View.getMainDefaultScreenDevice().getDefaultConfiguration()).getDefaultTransform()) != null) {
                Configuration.uiScale.set((Object)transform.getScaleX());
            }
            System.setProperty("sun.java2d.uiScale", "" + Configuration.uiScale.get());
        }
        if (((Boolean)Configuration.hwAcceleratedGraphics.get()).booleanValue()) {
            System.setProperty("sun.java2d.opengl", (Boolean)Configuration._debugMode.get() != false ? "True" : "true");
        } else {
            System.setProperty("sun.java2d.opengl", "false");
        }
        Main.initUiLang();
        Main.initLookAndFeel();
        View.execInEventDispatch(() -> {
            ErrorLogFrame.createNewInstance();
            Main.autoCheckForUpdates();
            Main.offerAssociation();
            loadingDialog = new LoadingDialog(Main.getDefaultDialogsOwner());
            try {
                watcher = FileSystems.getDefault().newWatchService();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (watcher != null) {
                watcherWorker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        while (true) {
                            WatchKey key;
                            try {
                                key = watcher.take();
                            }
                            catch (InterruptedException ex) {
                                return null;
                            }
                            for (WatchEvent<?> event : key.pollEvents()) {
                                File fullPath;
                                Path child;
                                File dir;
                                WatchEvent.Kind<?> kind = event.kind();
                                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                                WatchEvent<?> ev = event;
                                Path filename = (Path)ev.context();
                                if (SharedObjectsStorage.watchedCookieDirectories.containsKey(key)) {
                                    dir = SharedObjectsStorage.watchedCookieDirectories.get(key);
                                    child = dir.toPath().resolve(filename);
                                    fullPath = child.toFile();
                                    View.execInEventDispatchLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            SharedObjectsStorage.watchedDirectoryChanged(fullPath);
                                        }
                                    });
                                }
                                if (!((Boolean)Configuration.checkForModifications.get()).booleanValue() || !watchedDirectories.containsKey(key)) continue;
                                dir = (File)watchedDirectories.get(key);
                                child = dir.toPath().resolve(filename);
                                fullPath = child.toFile();
                                if (savedFiles.contains(fullPath)) continue;
                                for (OpenableSourceInfo info : sourceInfos) {
                                    final String infoFile = info.getFile();
                                    if (infoFile == null || !new File(infoFile).equals(fullPath)) continue;
                                    for (OpenableList list : Main.getMainFrame().getPanel().getSwfs()) {
                                        if (info != list.sourceInfo) continue;
                                        list.setModified();
                                    }
                                    View.execInEventDispatchLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            mainFrame.getPanel().refreshTree();
                                            if (filesChangedDialog == null) {
                                                filesChangedDialog = new FilesChangedDialog(mainFrame.getWindow());
                                            }
                                            filesChangedDialog.addItem(infoFile);
                                            if (!filesChangedDialog.isVisible()) {
                                                filesChangedDialog.setVisible(true);
                                            }
                                        }
                                    });
                                }
                            }
                            boolean valid = key.reset();
                            if (valid) continue;
                            SharedObjectsStorage.watchedCookieDirectories.remove(key);
                            watchedDirectories.remove(key);
                        }
                    }
                };
                watcherWorker.execute();
            }
            DebuggerTools.initDebugger().addMessageListener(new DebugAdapter(){

                @Override
                public boolean isModifyBytesSupported() {
                    return true;
                }

                @Override
                public void onLoaderModifyBytes(String clientId, final byte[] inputData, String url, final DebugLoaderDataModified modifiedListener) {
                    if (inputData.length < 3) {
                        modifiedListener.dataModified(inputData);
                        return;
                    }
                    String signature = new String(inputData, 0, 3, Utf8Helper.charset);
                    if (!SWF.swfSignatures.contains(signature)) {
                        modifiedListener.dataModified(inputData);
                        return;
                    }
                    final String hash = Main.md5(inputData);
                    final OpenableOpened afterLoad = new OpenableOpened(){

                        @Override
                        public void opened(Openable openable) {
                            try {
                                SWF mainSWF = Main.getRunningSWF();
                                File tempRunDir = mainSWF.getFile() == null ? null : new File(mainSWF.getFile()).getParentFile();
                                File tempFile = Main.createTempFileInDir(tempRunDir, "~ffdec_loader_", ".swf");
                                try (FileOutputStream fos = new FileOutputStream(tempFile);){
                                    fos.write(inputData);
                                }
                                Logger.getLogger(Main.class.getName()).log(Level.FINE, "preparing for load: {0}", hash);
                                Main.prepareSwf("loaded_" + hash, runningPreparation, tempFile, mainSWF.getFile() == null ? null : new File(mainSWF.getFile()), tempRunDir, runTempFiles);
                                byte[] outputData = Helper.readFileEx((String[])new String[]{tempFile.getAbsolutePath()});
                                tempFile.delete();
                                Logger.getLogger(Main.class.getName()).log(Level.FINE, "calling datamodified");
                                modifiedListener.dataModified(outputData);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            Logger.getLogger(Main.class.getName()).log(Level.FINE, "finished opened method");
                        }
                    };
                    for (OpenableList sl : Main.getMainFrame().getPanel().getSwfs()) {
                        for (int s = 0; s < sl.size(); ++s) {
                            Openable op = sl.get(s);
                            String t = op.getTitleOrShortFileName();
                            if (t == null) {
                                t = "";
                            }
                            if (!t.endsWith(":" + hash)) continue;
                            afterLoad.opened(op);
                            return;
                        }
                    }
                    SWF swf = Main.getRunningSWF();
                    String title = swf == null ? "?" : swf.getTitleOrShortFileName();
                    final String titleWithHash = title + ":" + hash;
                    View.execInEventDispatch(new Runnable(){

                        @Override
                        public void run() {
                            OpenableSourceInfo osi = new OpenableSourceInfo((InputStream)new ReReadableInputStream((InputStream)new ByteArrayInputStream(inputData)), null, titleWithHash);
                            Main.openFile(osi, afterLoad, true);
                        }
                    });
                }
            });
            try {
                flashDebugger = new Debugger();
                debugHandler = new DebuggerHandler();
                debugHandler.addBreakListener(new DebuggerHandler.BreakListener(){

                    @Override
                    public void doContinue() {
                        mainFrame.getPanel().clearDebuggerColors();
                    }

                    @Override
                    public void breakAt(final String scriptName, final int line, final int classIndex, final int traitIndex, final int methodIndex) {
                        View.execInEventDispatch(new Runnable(){

                            @Override
                            public void run() {
                                String hash = "main";
                                String scriptNameNoHash = scriptName;
                                if (scriptName.contains(":")) {
                                    hash = scriptName.substring(0, scriptName.indexOf(":"));
                                    scriptNameNoHash = scriptName.substring(scriptName.indexOf(":") + 1);
                                }
                                SWF swf = Main.getSwfByHash(hash);
                                mainFrame.getPanel().gotoScriptLine(swf, scriptNameNoHash, line, classIndex, traitIndex, methodIndex, Main.isDebugPCode());
                            }
                        });
                    }
                });
                debugHandler.addConnectionListener(new DebuggerHandler.ConnectionListener(){

                    @Override
                    public void connected() {
                        mainFrame.getMenu().updateComponents();
                    }

                    @Override
                    public void disconnected() {
                        if (mainFrame != null && mainFrame.getPanel() != null) {
                            mainFrame.getPanel().refreshBreakPoints();
                        }
                    }
                });
                flashDebugger.addConnectionListener((DebugConnectionListener)debugHandler);
                searchResultsStorage.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public static void startDebugger() {
        flashDebugger.startDebugger();
    }

    public static void stopDebugger() {
        flashDebugger.stopDebugger();
    }

    public static void showModeFrame() {
        Main.ensureMainFrame();
        mainFrame.setVisible(true);
    }

    private static void offerAssociation() {
        boolean offered = (Boolean)Configuration.offeredAssociation.get();
        if (!offered) {
            if (Platform.isWindows() && !ContextMenuTools.isAddedToContextMenu() && ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), "Do you want to add FFDec to context menu of SWF files?\n(Can be changed later from main menu)", "Context menu", 0, 3) == 0) {
                ContextMenuTools.addToContextMenu(true, false);
            }
            Configuration.offeredAssociation.set((Object)true);
        }
    }

    public static void initUiLang() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        try {
            Class<?> cl = Class.forName("org.pushingpixels.substance.api.SubstanceLookAndFeel");
            Field field = cl.getDeclaredField("LABEL_BUNDLE");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        UIManager.put("OptionPane.okButtonText", AppStrings.translate("button.ok"));
        UIManager.put("OptionPane.yesButtonText", AppStrings.translate("button.yes"));
        UIManager.put("OptionPane.noButtonText", AppStrings.translate("button.no"));
        UIManager.put("OptionPane.cancelButtonText", AppStrings.translate("button.cancel"));
        UIManager.put("OptionPane.messageDialogTitle", AppStrings.translate("dialog.message.title"));
        UIManager.put("OptionPane.titleText", AppStrings.translate("dialog.select.title"));
        UIManager.put("FileChooser.acceptAllFileFilterText", AppStrings.translate("FileChooser.acceptAllFileFilterText"));
        UIManager.put("FileChooser.lookInLabelText", AppStrings.translate("FileChooser.lookInLabelText"));
        UIManager.put("FileChooser.cancelButtonText", AppStrings.translate("button.cancel"));
        UIManager.put("FileChooser.cancelButtonToolTipText", AppStrings.translate("button.cancel"));
        UIManager.put("FileChooser.openButtonText", AppStrings.translate("FileChooser.openButtonText"));
        UIManager.put("FileChooser.openButtonToolTipText", AppStrings.translate("FileChooser.openButtonToolTipText"));
        UIManager.put("FileChooser.filesOfTypeLabelText", AppStrings.translate("FileChooser.filesOfTypeLabelText"));
        UIManager.put("FileChooser.fileNameLabelText", AppStrings.translate("FileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.listViewButtonToolTipText", AppStrings.translate("FileChooser.listViewButtonToolTipText"));
        UIManager.put("FileChooser.listViewButtonAccessibleName", AppStrings.translate("FileChooser.listViewButtonAccessibleName"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", AppStrings.translate("FileChooser.detailsViewButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", AppStrings.translate("FileChooser.detailsViewButtonAccessibleName"));
        UIManager.put("FileChooser.upFolderToolTipText", AppStrings.translate("FileChooser.upFolderToolTipText"));
        UIManager.put("FileChooser.upFolderAccessibleName", AppStrings.translate("FileChooser.upFolderAccessibleName"));
        UIManager.put("FileChooser.homeFolderToolTipText", AppStrings.translate("FileChooser.homeFolderToolTipText"));
        UIManager.put("FileChooser.homeFolderAccessibleName", AppStrings.translate("FileChooser.homeFolderAccessibleName"));
        UIManager.put("FileChooser.fileNameHeaderText", AppStrings.translate("FileChooser.fileNameHeaderText"));
        UIManager.put("FileChooser.fileSizeHeaderText", AppStrings.translate("FileChooser.fileSizeHeaderText"));
        UIManager.put("FileChooser.fileTypeHeaderText", AppStrings.translate("FileChooser.fileTypeHeaderText"));
        UIManager.put("FileChooser.fileDateHeaderText", AppStrings.translate("FileChooser.fileDateHeaderText"));
        UIManager.put("FileChooser.fileAttrHeaderText", AppStrings.translate("FileChooser.fileAttrHeaderText"));
        UIManager.put("FileChooser.openDialogTitleText", AppStrings.translate("FileChooser.openDialogTitleText"));
        UIManager.put("FileChooser.directoryDescriptionText", AppStrings.translate("FileChooser.directoryDescriptionText"));
        UIManager.put("FileChooser.directoryOpenButtonText", AppStrings.translate("FileChooser.directoryOpenButtonText"));
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", AppStrings.translate("FileChooser.directoryOpenButtonToolTipText"));
        UIManager.put("FileChooser.fileDescriptionText", AppStrings.translate("FileChooser.fileDescriptionText"));
        UIManager.put("FileChooser.fileNameLabelText", AppStrings.translate("FileChooser.fileNameLabelText"));
        UIManager.put("FileChooser.helpButtonText", AppStrings.translate("FileChooser.helpButtonText"));
        UIManager.put("FileChooser.helpButtonToolTipText", AppStrings.translate("FileChooser.helpButtonToolTipText"));
        UIManager.put("FileChooser.newFolderAccessibleName", AppStrings.translate("FileChooser.newFolderAccessibleName"));
        UIManager.put("FileChooser.newFolderErrorText", AppStrings.translate("FileChooser.newFolderErrorText"));
        UIManager.put("FileChooser.newFolderToolTipText", AppStrings.translate("FileChooser.newFolderToolTipText"));
        UIManager.put("FileChooser.other.newFolder", AppStrings.translate("FileChooser.other.newFolder"));
        UIManager.put("FileChooser.other.newFolder.subsequent", AppStrings.translate("FileChooser.other.newFolder.subsequent"));
        UIManager.put("FileChooser.win32.newFolder", AppStrings.translate("FileChooser.win32.newFolder"));
        UIManager.put("FileChooser.win32.newFolder.subsequent", AppStrings.translate("FileChooser.win32.newFolder.subsequent"));
        UIManager.put("FileChooser.saveButtonText", AppStrings.translate("FileChooser.saveButtonText"));
        UIManager.put("FileChooser.saveButtonToolTipText", AppStrings.translate("FileChooser.saveButtonToolTipText"));
        UIManager.put("FileChooser.saveDialogTitleText", AppStrings.translate("FileChooser.saveDialogTitleText"));
        UIManager.put("FileChooser.saveInLabelText", AppStrings.translate("FileChooser.saveInLabelText"));
        UIManager.put("FileChooser.updateButtonText", AppStrings.translate("FileChooser.updateButtonText"));
        UIManager.put("FileChooser.updateButtonToolTipText", AppStrings.translate("FileChooser.updateButtonToolTipText"));
        UIManager.put("FileChooser.detailsViewActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.detailsViewActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.detailsViewButtonToolTip.textAndMnemonic", AppStrings.translate("FileChooser.detailsViewButtonToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.fileAttrHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileAttrHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileDateHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileDateHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileNameHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileNameHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileNameLabel.textAndMnemonic", AppStrings.translate("FileChooser.fileNameLabel.textAndMnemonic"));
        UIManager.put("FileChooser.fileSizeHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileSizeHeader.textAndMnemonic"));
        UIManager.put("FileChooser.fileTypeHeader.textAndMnemonic", AppStrings.translate("FileChooser.fileTypeHeader.textAndMnemonic"));
        UIManager.put("FileChooser.filesOfTypeLabel.textAndMnemonic", AppStrings.translate("FileChooser.filesOfTypeLabel.textAndMnemonic"));
        UIManager.put("FileChooser.folderNameLabel.textAndMnemonic", AppStrings.translate("FileChooser.folderNameLabel.textAndMnemonic"));
        UIManager.put("FileChooser.homeFolderToolTip.textAndMnemonic", AppStrings.translate("FileChooser.homeFolderToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.listViewActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.listViewActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.listViewButtonToolTip.textAndMnemonic", AppStrings.translate("FileChooser.listViewButtonToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.lookInLabel.textAndMnemonic", AppStrings.translate("FileChooser.lookInLabel.textAndMnemonic"));
        UIManager.put("FileChooser.newFolderActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.newFolderActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.newFolderToolTip.textAndMnemonic", AppStrings.translate("FileChooser.newFolderToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.refreshActionLabel.textAndMnemonic", AppStrings.translate("FileChooser.refreshActionLabel.textAndMnemonic"));
        UIManager.put("FileChooser.saveInLabel.textAndMnemonic", AppStrings.translate("FileChooser.saveInLabel.textAndMnemonic"));
        UIManager.put("FileChooser.upFolderToolTip.textAndMnemonic", AppStrings.translate("FileChooser.upFolderToolTip.textAndMnemonic"));
        UIManager.put("FileChooser.viewMenuButtonAccessibleName", AppStrings.translate("FileChooser.viewMenuButtonAccessibleName"));
        UIManager.put("FileChooser.viewMenuButtonToolTipText", AppStrings.translate("FileChooser.viewMenuButtonToolTipText"));
        UIManager.put("FileChooser.viewMenuLabel.textAndMnemonic", AppStrings.translate("FileChooser.viewMenuLabel.textAndMnemonic"));
        UIManager.put("FileChooser.newFolderActionLabelText", AppStrings.translate("FileChooser.newFolderActionLabelText"));
        UIManager.put("FileChooser.listViewActionLabelText", AppStrings.translate("FileChooser.listViewActionLabelText"));
        UIManager.put("FileChooser.detailsViewActionLabelText", AppStrings.translate("FileChooser.detailsViewActionLabelText"));
        UIManager.put("FileChooser.refreshActionLabelText", AppStrings.translate("FileChooser.refreshActionLabelText"));
        UIManager.put("FileChooser.sortMenuLabelText", AppStrings.translate("FileChooser.sortMenuLabelText"));
        UIManager.put("FileChooser.viewMenuLabelText", AppStrings.translate("FileChooser.viewMenuLabelText"));
        UIManager.put("FileChooser.fileSizeKiloBytes", AppStrings.translate("FileChooser.fileSizeKiloBytes"));
        UIManager.put("FileChooser.fileSizeMegaBytes", AppStrings.translate("FileChooser.fileSizeMegaBytes"));
        UIManager.put("FileChooser.fileSizeGigaBytes", AppStrings.translate("FileChooser.fileSizeGigaBytes"));
        UIManager.put("FileChooser.folderNameLabelText", AppStrings.translate("FileChooser.folderNameLabelText"));
        UIManager.put("ColorChooser.okText", AppStrings.translate("ColorChooser.okText"));
        UIManager.put("ColorChooser.cancelText", AppStrings.translate("ColorChooser.cancelText"));
        UIManager.put("ColorChooser.resetText", AppStrings.translate("ColorChooser.resetText"));
        UIManager.put("ColorChooser.previewText", AppStrings.translate("ColorChooser.previewText"));
        UIManager.put("ColorChooser.swatchesNameText", AppStrings.translate("ColorChooser.swatchesNameText"));
        UIManager.put("ColorChooser.swatchesRecentText", AppStrings.translate("ColorChooser.swatchesRecentText"));
        UIManager.put("ColorChooser.sampleText", AppStrings.translate("ColorChooser.sampleText"));
    }

    public static String getDefaultCharacterEncoding() {
        byte[] byte_array = new byte[]{119};
        ByteArrayInputStream instream = new ByteArrayInputStream(byte_array);
        InputStreamReader streamreader = new InputStreamReader(instream);
        String defaultCharset = streamreader.getEncoding();
        return defaultCharset;
    }

    private static void initLookAndFeel() {
        if (((Boolean)Configuration.useRibbonInterface.get()).booleanValue()) {
            View.setLookAndFeel();
        } else {
            try {
                UIManager.put("substancelaf.colorizationFactor", null);
                UIManager.put("Tree.expandedIcon", null);
                UIManager.put("Tree.collapsedIcon", null);
                UIManager.put("ColorChooserUI", null);
                UIManager.put("ColorChooser.swatchesRecentSwatchSize", null);
                UIManager.put("ColorChooser.swatchesSwatchSize", null);
                UIManager.put("RibbonApplicationMenuPopupPanelUI", null);
                UIManager.put("RibbonApplicationMenuButtonUI", null);
                UIManager.put("ProgressBarUI", null);
                UIManager.put("TextField.background", null);
                UIManager.put("FormattedTextField.background", null);
                UIManager.put("CommandButtonUI", null);
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void initJna() {
        if (Platform.isWindows()) {
            String jnaTempDir = (String)Configuration.jnaTempDirectory.get();
            if (!jnaTempDir.isEmpty()) {
                System.setProperty("jna.tmpdir", jnaTempDir);
            } else {
                jnaTempDir = System.getProperty("java.io.tmpdir");
            }
            try {
                Native.toByteArray((String)"");
            }
            catch (UnsatisfiedLinkError error) {
                Main.initLookAndFeel();
                ViewMessages.showMessageDialog(null, "Cannot read JNA DLL file from current Temporary directory:\r\n" + jnaTempDir + "\r\nThe reason is probably Unicode characters in the path or in your username.\r\nIn the following dialog, please specify new temporary directory path,\r\nwhich DOES NOT contain any special Unicode characters. (Only basic latin supported)\r\nThen application restart is required.", "FFDec JNA Error", 0);
                View.execInEventDispatch(new Runnable(){

                    @Override
                    public void run() {
                        JFileChooser fc = new JFileChooser();
                        fc.setFileSelectionMode(1);
                        fc.setDialogTitle("Select new temporary directory without Unicode characters in its path");
                        if (fc.showOpenDialog(null) == 0) {
                            File dir = Helper.fixDialogFile((File)fc.getSelectedFile());
                            Configuration.jnaTempDirectory.set((Object)dir.getAbsolutePath());
                            Configuration.saveConfig();
                            System.exit(0);
                        } else {
                            System.exit(1);
                        }
                    }
                });
            }
        }
    }

    public static void initLang() {
        if (!Configuration.locale.hasValue() && Platform.isWindows()) {
            String uninstKey = "{E618D276-6596-41F4-8A98-447D442A77DB}_is1";
            uninstKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uninstKey;
            try {
                if (Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, uninstKey) && Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, uninstKey, "NSIS: Language")) {
                    String installedLoc = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, uninstKey, "NSIS: Language");
                    int lcid = Integer.parseInt(installedLoc);
                    char[] buf = new char[9];
                    int cnt = Kernel32.INSTANCE.GetLocaleInfo(lcid, 89, buf, 9);
                    String langCode = new String(buf, 0, cnt).trim().toLowerCase();
                    cnt = Kernel32.INSTANCE.GetLocaleInfo(lcid, 90, buf, 9);
                    String countryCode = new String(buf, 0, cnt).trim().toLowerCase();
                    List<String> langs = Arrays.asList(SelectLanguageDialog.getAvailableLanguages());
                    for (int i = 0; i < langs.size(); ++i) {
                        langs.set(i, langs.get(i).toLowerCase());
                    }
                    String selectedLang = null;
                    if (langs.contains(langCode + "-" + countryCode)) {
                        selectedLang = SelectLanguageDialog.getAvailableLanguages()[langs.indexOf(langCode + "-" + countryCode)];
                    } else if (langs.contains(langCode)) {
                        selectedLang = SelectLanguageDialog.getAvailableLanguages()[langs.indexOf(langCode)];
                    }
                    if (selectedLang != null) {
                        Configuration.locale.set(selectedLang);
                    }
                }
            }
            catch (Exception installedLoc) {
                // empty catch block
            }
        }
        Locale.setDefault(Locale.forLanguageTag((String)Configuration.locale.get()));
        AppStrings.updateLanguage();
        Helper.decompilationErrorAdd = AppStrings.translate((Boolean)Configuration.autoDeobfuscate.get() != false ? "deobfuscation.comment.failed" : "deobfuscation.comment.tryenable");
        ResourceBundle advancedSettingsBundle = ResourceBundle.getBundle(AppStrings.getResourcePath(AdvancedSettingsDialog.class));
        Set configurationNames = Configuration.getConfigurationFields((boolean)false, (boolean)true).keySet();
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> descriptions = new LinkedHashMap<String, String>();
        for (String name : configurationNames) {
            if (advancedSettingsBundle.containsKey("config.name." + name)) {
                titles.put(name, advancedSettingsBundle.getString("config.name." + name));
            }
            if (!advancedSettingsBundle.containsKey("config.description." + name)) continue;
            descriptions.put(name, advancedSettingsBundle.getString("config.description." + name));
        }
        Configuration.setConfigurationDescriptions(descriptions);
        Configuration.setConfigurationTitles(titles);
    }

    private static void clearTemp() {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            return;
        }
        File tempDir = new File(tempDirPath);
        if (!tempDir.exists()) {
            return;
        }
        File[] delFiles = tempDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("ffdec_cache.*\\.tmp") || name.matches("javactivex_.*\\.exe") || name.matches("temp[0-9]+\\.swf") || name.matches("ffdec_view_.*\\.swf");
            }
        });
        if (delFiles != null) {
            for (File f : delFiles) {
                try {
                    f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void decodeLaunch5jArgs(String[] args) {
        String encargs = System.getProperty("l5j.encargs");
        if ("true".equals(encargs) || "1".equals(encargs)) {
            for (int i = 0; i < args.length; ++i) {
                try {
                    args[i] = URLDecoder.decode(args[i], "UTF-8");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Main.decodeLaunch5jArgs(args);
        Main.preInitLogging();
        Main.setSessionLoaded(false);
        System.setProperty("sun.io.serialization.extendedDebugInfo", "true");
        Main.clearTemp();
        try {
            SWFDecompilerPlugin.loadPlugins();
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Failed to load plugins", ex);
        }
        AppStrings.setResourceClass(MainFrame.class);
        Main.initLogging((Boolean)Configuration._debugMode.get());
        Main.initJna();
        Main.initLang();
        if (((Boolean)Configuration.cacheOnDisk.get()).booleanValue()) {
            Cache.setStorageType((int)1);
        } else {
            Cache.setStorageType((int)2);
        }
        if (args.length == 0) {
            Main.initGui();
            Main.checkLibraryVersion();
            View.execInEventDispatch(() -> {
                if (((Boolean)Configuration.allowOnlyOneInstance.get()).booleanValue() && FirstInstance.focus()) {
                    Main.exit();
                } else {
                    Main.showModeFrame();
                    Main.reloadLastSession();
                }
            });
        } else if (args.length == 1 && "-soleditor".equals(args[0])) {
            Main.initGui();
            Main.checkLibraryVersion();
            View.execInEventDispatch(() -> {
                DefaultSyntaxKit.initKit();
                SolEditorFrame solEditor = new SolEditorFrame(true);
                solEditor.setVisible(true);
            });
        } else {
            Main.checkLibraryVersion();
            Main.setSessionLoaded(true);
            String[] filesToOpen = CommandLineArgumentParser.parseArguments(args);
            if (filesToOpen != null && filesToOpen.length > 0) {
                Main.initGui();
                View.execInEventDispatch(() -> {
                    if (((Boolean)Configuration.allowOnlyOneInstance.get()).booleanValue() && FirstInstance.openFiles(Arrays.asList(filesToOpen))) {
                        Main.exit();
                    } else {
                        for (String fileToOpen : filesToOpen) {
                            Main.openFile(fileToOpen, null);
                        }
                    }
                });
            }
        }
    }

    private static void checkLibraryVersion() {
        if (!(ApplicationInfo.version.equals("unknown") || ApplicationInfo.libraryVersion.equals("unknown") || Objects.equals(ApplicationInfo.version, ApplicationInfo.libraryVersion))) {
            logger.log(Level.WARNING, "Application version is different from library version. FFDec may not work properly.");
        }
    }

    private static void reloadLastSession() {
        String lastSession;
        boolean openingFiles = false;
        if (((Boolean)Configuration.saveSessionOnExit.get()).booleanValue() && (lastSession = (String)Configuration.lastSessionFiles.get()) != null && lastSession.length() > 0) {
            String[] filesToOpen = lastSession.split(File.pathSeparator, -1);
            ArrayList<String> exfiles = new ArrayList<String>();
            ArrayList<String> extitles = new ArrayList<String>();
            String lastSessionTitles = (String)Configuration.lastSessionFileTitles.get();
            String[] fileTitles = new String[]{};
            if (lastSessionTitles != null && !lastSessionTitles.isEmpty()) {
                fileTitles = lastSessionTitles.split(File.pathSeparator, -1);
            }
            for (int i = 0; i < filesToOpen.length; ++i) {
                if (!new File(filesToOpen[i]).exists()) continue;
                exfiles.add(filesToOpen[i]);
                if (fileTitles.length > i) {
                    extitles.add(fileTitles[i]);
                    continue;
                }
                extitles.add(null);
            }
            OpenableSourceInfo[] sourceInfos = new OpenableSourceInfo[exfiles.size()];
            for (int i = 0; i < exfiles.size(); ++i) {
                String extitle = (String)extitles.get(i);
                sourceInfos[i] = new OpenableSourceInfo(null, (String)exfiles.get(i), extitle == null || extitle.isEmpty() ? null : extitle);
            }
            if (sourceInfos.length > 0) {
                openingFiles = true;
                Main.openFile(sourceInfos, (Openable openable) -> {
                    Main.mainFrame.getPanel().tagTree.setSelectionPathString((String)Configuration.lastSessionSelection.get());
                    Main.mainFrame.getPanel().tagListTree.setSelectionPathString((String)Configuration.lastSessionTagListSelection.get());
                    Set<SWF> allSwfs = mainFrame.getPanel().getAllSwfs();
                    for (SWF s : allSwfs) {
                        String name = s.getFile() + "|" + s.getFileTitle();
                        if (!name.equals(Configuration.lastSessionEasySwf.get())) continue;
                        mainFrame.getPanel().getEasyPanel().setSwf(s);
                    }
                    Main.setSessionLoaded(true);
                    mainFrame.getPanel().reload(true);
                    mainFrame.getPanel().updateUiWithCurrentOpenable();
                }, true);
            }
        }
        if (!openingFiles) {
            Main.setSessionLoaded(true);
        }
    }

    public static String tempFile(String url) throws IOException {
        File f = new File(AppDirectoryProvider.getFFDecHome() + "saved" + File.separator);
        com.jpexs.helpers.Path.createDirectorySafe((File)f);
        return AppDirectoryProvider.getFFDecHome() + "saved" + File.separator + "asdec_" + Integer.toHexString(url.hashCode()) + ".tmp";
    }

    public static void removeTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            if (trayIcon != null) {
                tray.remove(trayIcon);
                trayIcon = null;
            }
        }
    }

    public static List<SWF> namesToSwfs(List<String> names) {
        ArrayList<SWF> ret = new ArrayList<SWF>();
        LinkedHashMap<String, SWF> swfs = new LinkedHashMap<String, SWF>();
        Main.populateAllSWFs(swfs);
        for (String name : names) {
            if (!swfs.containsKey(name)) continue;
            ret.add((SWF)swfs.get(name));
        }
        return ret;
    }

    public static void populateAllSWFs(Map<String, SWF> swfs) {
        if (mainFrame == null) {
            return;
        }
        List<OpenableList> ols = mainFrame.getPanel().getSwfs();
        for (OpenableList ol : ols) {
            for (Openable op : ol) {
                if (!(op instanceof SWF)) continue;
                SWF swf = (SWF)op;
                Main.populateSwf(swfs, swf, swf.getShortPathTitle());
            }
        }
    }

    private static void populateSwf(Map<String, SWF> ret, SWF swf, String name) {
        int pos = 1;
        String baseName = name;
        while (ret.containsKey(name)) {
            name = baseName + "[" + ++pos + "]";
        }
        ret.put(name, swf);
        for (Tag t : swf.getTags()) {
            if (!(t instanceof DefineBinaryDataTag)) continue;
            DefineBinaryDataTag binaryData = (DefineBinaryDataTag)t;
            if (binaryData.innerSwf == null) continue;
            Main.populateSwf(ret, binaryData.innerSwf, binaryData.innerSwf.getShortPathTitle());
        }
    }

    public static void exit() {
        View.saveScreen();
        if (mainFrame != null && mainFrame.getPanel() != null) {
            Main.mainFrame.getPanel().scrollPosStorage.saveScrollPos(mainFrame.getPanel().getCurrentTree().getCurrentTreeItem());
            mainFrame.getPanel().savePins();
        }
        try {
            searchResultsStorage.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Configuration.saveConfig();
        if (mainFrame != null && mainFrame.getPanel() != null) {
            mainFrame.dispose();
        }
        if (fileTxt != null) {
            try {
                fileTxt.flush();
                fileTxt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(0);
    }

    public static void about() {
        new AboutDialog(mainFrame.getWindow()).setVisible(true);
    }

    public static void advancedSettings() {
        Main.advancedSettings(null);
    }

    public static void advancedSettings(String category) {
        new AdvancedSettingsDialog(mainFrame.getWindow(), category).setVisible(true);
    }

    public static void autoCheckForUpdates() {
        Calendar lastUpdatesCheckDate;
        if (((Boolean)Configuration.checkForUpdatesAuto.get()).booleanValue() && ((lastUpdatesCheckDate = (Calendar)Configuration.lastUpdatesCheckDate.get()) == null || lastUpdatesCheckDate.getTime().getTime() < Calendar.getInstance().getTime().getTime() - (long)((Integer)Configuration.checkForUpdatesDelay.get()).intValue())) {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    Main.checkForUpdates();
                    return null;
                }
            }.execute();
        }
    }

    private static JsonValue urlGetJson(String getUrl) {
        try {
            URLConnection uc;
            String proxyAddress = (String)Configuration.updateProxyAddress.get();
            URL url = URI.create(getUrl).toURL();
            if (proxyAddress != null && !proxyAddress.isEmpty()) {
                int port = 8080;
                if (proxyAddress.contains(":")) {
                    String[] parts = proxyAddress.split(":");
                    port = Integer.parseInt(parts[1]);
                    proxyAddress = parts[0];
                }
                uc = url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAddress, port)));
            } else {
                uc = url.openConnection();
            }
            uc.setRequestProperty("User-Agent", ApplicationInfo.shortApplicationVerName);
            uc.connect();
            JsonValue value = Json.parse((Reader)new InputStreamReader(uc.getInputStream()));
            return value;
        }
        catch (IOException | NumberFormatException ex) {
            return null;
        }
    }

    public static boolean checkForUpdates() {
        JsonObject versionObj;
        String tagName;
        JsonValue allChangesInfoJson;
        String currentVersion = ApplicationInfo.version;
        if (currentVersion.equals("unknown") || currentVersion.equals("0.0.0")) {
            return false;
        }
        boolean showStable = (Boolean)Configuration.checkForUpdatesStable.get();
        boolean showNightly = (Boolean)Configuration.checkForUpdatesNightly.get();
        if (!showStable && !showNightly) {
            return false;
        }
        String stableTagName = "version" + ApplicationInfo.version_major + "." + ApplicationInfo.version_minor + "." + ApplicationInfo.version_release;
        String ignoreVersion = "-";
        String currentTagName = ApplicationInfo.nightly ? "nightly" + ApplicationInfo.version_build : stableTagName;
        if (!showNightly) {
            JsonValue latestVersionInfoJson = Main.urlGetJson("https://api.github.com/repos/jindrapetrik/jpexs-decompiler/releases/latest");
            if (latestVersionInfoJson == null) {
                return false;
            }
            String latestTagName = latestVersionInfoJson.asObject().get("tag_name").asString();
            if (currentTagName.equals(latestTagName) || stableTagName.equals(latestTagName)) {
                Configuration.lastUpdatesCheckDate.set((Object)Calendar.getInstance());
                return false;
            }
        }
        if ((allChangesInfoJson = Main.urlGetJson("https://api.github.com/repos/jindrapetrik/jpexs-decompiler/releases")) == null) {
            return false;
        }
        JsonArray arr = allChangesInfoJson.asArray();
        ArrayList<Version> versions = new ArrayList<Version>();
        for (int i = 0; i < arr.size() && !currentVersion.equals(tagName = (versionObj = arr.get(i).asObject()).get("tag_name").asString()) && !stableTagName.equals(tagName); ++i) {
            Version v = new Version();
            v.versionName = versionObj.get("name").asString();
            v.description = "";
            v.releaseDate = versionObj.get("published_at").asString();
            boolean isNightly = versionObj.get("prerelease").asBoolean();
            if (isNightly && !showNightly || !isNightly && !showStable) continue;
            versions.add(v);
        }
        if (!versions.isEmpty()) {
            View.execInEventDispatch(() -> {
                NewVersionDialog newVersionDialog = new NewVersionDialog(mainFrame == null ? null : mainFrame.getWindow(), versions);
                newVersionDialog.setVisible(true);
                Configuration.lastUpdatesCheckDate.set((Object)Calendar.getInstance());
            });
            return true;
        }
        Configuration.lastUpdatesCheckDate.set((Object)Calendar.getInstance());
        return false;
    }

    public static void clearLogFile() {
        final Logger logger = Logger.getLogger("");
        FileHandler oldFileTxt = fileTxt;
        fileTxt = null;
        if (oldFileTxt != null) {
            logger.removeHandler(fileTxt);
            oldFileTxt.flush();
            oldFileTxt.close();
        }
        String fileName = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
        try {
            fileName = AppDirectoryProvider.getFFDecHome() + "logs" + File.separator;
            fileName = (Boolean)Configuration.useDetailedLogging.get() != false ? fileName + "log-" + sdf.format(new Date()) + ".txt" : fileName + "log.txt";
            File f = new File(fileName).getParentFile();
            if (!f.exists()) {
                f.mkdir();
            }
            fileTxt = new FileHandler(fileName);
        }
        catch (IOException | SecurityException ex) {
            if (ex.getMessage().contains("lock for")) {
                for (int i = 0; i <= 100; ++i) {
                    File flog = new File(fileName + (i == 0 ? "" : "." + i));
                    File flog_lock = new File(fileName + (i == 0 ? "" : "." + i) + ".lck");
                    flog.delete();
                    flog_lock.delete();
                }
                try {
                    fileTxt = new FileHandler(fileName);
                }
                catch (IOException | SecurityException ex1) {
                    logger.log(Level.SEVERE, "Cannot initialize logging", ex);
                }
            }
            logger.log(Level.SEVERE, "Cannot initialize logging", ex);
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "Uncaught exception in thread: " + t.getName(), e);
                if (e instanceof OutOfMemoryError) {
                    Main.handleOutOfMemory("");
                }
            }
        });
        LogFormatter formatterTxt = new LogFormatter();
        if (fileTxt != null) {
            fileTxt.setFormatter(formatterTxt);
            logger.addHandler(fileTxt);
        }
        if (!GraphicsEnvironment.isHeadless() && ErrorLogFrame.hasInstance()) {
            ErrorLogFrame.getInstance().clearErrorState();
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd");
        logger.log(Level.INFO, "Date: {0}", sdf.format(new Date()));
        logger.log(Level.INFO, ApplicationInfo.applicationVerName);
        logger.log(Level.INFO, "{0} {1} {2}", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        logger.log(Level.INFO, "{0} {1} {2}", new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("os.arch")});
    }

    public static void preInitLogging() {
        File loggingFile = new File(AppDirectoryProvider.getFFDecHome() + "/logging.properties");
        if (loggingFile.exists()) {
            LogManager logManager = LogManager.getLogManager();
            try {
                logManager.readConfiguration(new FileInputStream(loggingFile));
                loggingFileLoaded = true;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void initLogging(boolean debug) {
        if (loggingFileLoaded) {
            return;
        }
        try {
            Logger logger = Logger.getLogger("");
            logger.setLevel(Configuration.logLevel);
            Handler[] handlers = logger.getHandlers();
            for (int i = handlers.length - 1; i >= 0; --i) {
                logger.removeHandler(handlers[i]);
            }
            ConsoleHandler conHan = new ConsoleHandler();
            conHan.setLevel(debug ? Level.CONFIG : Level.WARNING);
            SimpleFormatter formatterTxt = new SimpleFormatter();
            conHan.setFormatter(formatterTxt);
            logger.addHandler(conHan);
            Main.clearLogFile();
        }
        catch (Exception ex) {
            throw new RuntimeException("Problems with creating the log files");
        }
    }

    public static List<SWF> getDependencies(SWF swf) {
        List preselectedNames;
        SwfSpecificCustomConfiguration conf = Configuration.getSwfSpecificCustomConfiguration((String)swf.getShortPathTitle());
        List<SWF> dependencies = new ArrayList<SWF>();
        if (conf != null && !(preselectedNames = conf.getCustomDataAsList("abcDependencies")).isEmpty()) {
            dependencies = Main.namesToSwfs(preselectedNames);
        }
        return dependencies;
    }

    public static void showBreakpointsList() {
        SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
        Main.getMainFrame().getPanel().showBreakpointlistDialog(swf);
    }

    public static String getSwfHash(SWF swf) {
        if (swf == Main.getRunningSWF()) {
            return "main";
        }
        String tit = swf.getTitleOrShortFileName();
        if (tit != null && tit.contains(":")) {
            return "loaded_" + tit.substring(tit.lastIndexOf(":") + 1);
        }
        return "";
    }

    public static SWF getSwfByHash(String hash) {
        if ("main".equals(hash)) {
            SWF runningSwf = Main.getRunningSWF();
            if (runningSwf == null) {
                return mainFrame.getPanel().getCurrentSwf();
            }
            return runningSwf;
        }
        if (!hash.startsWith("loaded_")) {
            return null;
        }
        hash = hash.substring("loaded_".length());
        for (OpenableList sl : Main.getMainFrame().getPanel().getSwfs()) {
            for (int s = 0; s < sl.size(); ++s) {
                Openable op = sl.get(s);
                if (!(op instanceof SWF)) continue;
                String t = op.getTitleOrShortFileName();
                if (t == null) {
                    t = "";
                }
                if (!t.endsWith(":" + hash)) continue;
                return (SWF)op;
            }
        }
        return null;
    }

    public static void openSolEditor() {
        SolEditorFrame solEdit = new SolEditorFrame(false);
        solEdit.setVisible(true);
    }

    static {
        working = false;
        logger = Logger.getLogger(Main.class.getName());
        debugHandler = null;
        inited = false;
        runTempFiles = new ArrayList<File>();
        watchedDirectories = new HashMap<WatchKey, File>();
        savedFiles = Collections.synchronizedList(new ArrayList());
        searchResultsStorage = new SearchResultsStorage();
        importWorker = null;
        deobfuscatePCodeWorker = null;
        swfPrepareWorker = null;
        currentDebuggerPackage = null;
        runningSWF = null;
        runningPreparation = null;
        loggingFileLoaded = false;
        lastTimeStartWork = 0L;
        statusTimer = new Timer("status", true);
        statusTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                long nowTime;
                if (mainFrame == null) {
                    return;
                }
                MainPanel mainPanel = mainFrame.getPanel();
                if (mainPanel == null) {
                    return;
                }
                MainFrameStatusPanel sp = mainPanel.getStatusPanel();
                if (sp != null && sp.isStatusHidden() && (nowTime = System.currentTimeMillis()) > lastTimeStartWork + 5000L) {
                    mainFrame.getPanel().showOldStatus();
                }
            }
        }, 5000L, 5000L);
    }

    private static class OpenFileWorker
    extends SwingWorker {
        private final OpenableSourceInfo[] sourceInfos;
        private final OpenableOpened executeAfterOpen;
        private final int[] reloadIndices;
        private final boolean loadSession;

        public OpenFileWorker(OpenableSourceInfo sourceInfo, boolean loadSession) {
            this(sourceInfo, -1, loadSession);
        }

        public OpenFileWorker(OpenableSourceInfo sourceInfo, int reloadIndex, boolean loadSession) {
            this(sourceInfo, null, reloadIndex, loadSession);
        }

        public OpenFileWorker(OpenableSourceInfo sourceInfo, OpenableOpened executeAfterOpen, boolean loadSession) {
            this(sourceInfo, executeAfterOpen, -1, loadSession);
        }

        public OpenFileWorker(OpenableSourceInfo sourceInfo, OpenableOpened executeAfterOpen, int reloadIndex, boolean loadSession) {
            this.sourceInfos = new OpenableSourceInfo[]{sourceInfo};
            this.executeAfterOpen = executeAfterOpen;
            this.reloadIndices = new int[]{reloadIndex};
            this.loadSession = loadSession;
        }

        public OpenFileWorker(OpenableSourceInfo[] sourceInfos, boolean loadSession) {
            this(sourceInfos, null, null, loadSession);
        }

        public OpenFileWorker(OpenableSourceInfo[] sourceInfos, OpenableOpened executeAfterOpen, boolean loadSession) {
            this(sourceInfos, executeAfterOpen, null, loadSession);
        }

        public OpenFileWorker(OpenableSourceInfo[] sourceInfos, OpenableOpened executeAfterOpen, int[] reloadIndices, boolean loadSession) {
            this.sourceInfos = sourceInfos;
            this.executeAfterOpen = executeAfterOpen;
            int[] indices = new int[sourceInfos.length];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = -1;
            }
            this.reloadIndices = reloadIndices == null ? indices : reloadIndices;
            this.loadSession = loadSession;
        }

        protected Object doInBackground() throws Exception {
            boolean first = true;
            SWF firstSWF = null;
            Openable firstOpenable = null;
            ArrayList<OpenableList> openableLists = new ArrayList<OpenableList>();
            for (int index = 0; index < this.sourceInfos.length; ++index) {
                OpenableSourceInfo sourceInfo = this.sourceInfos[index];
                OpenableList openables = null;
                try {
                    Main.startWork(AppStrings.translate("work.reading.swf") + "...", null);
                    try {
                        openables = Main.parseOpenable(sourceInfo);
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof SwfOpenException) {
                            throw (SwfOpenException)cause;
                        }
                        if (cause instanceof ABCOpenException) {
                            throw (ABCOpenException)cause;
                        }
                        throw ex;
                    }
                }
                catch (OutOfMemoryError ex) {
                    logger.log(Level.SEVERE, null, ex);
                    Main.handleOutOfMemory("Cannot load SWF file.");
                    continue;
                }
                catch (SwfOpenException | ABCOpenException ex) {
                    logger.log(Level.SEVERE, null, ex);
                    ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), ex.getMessage(), AppStrings.translate("error"), 0);
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                    ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), "Cannot load SWF file: " + ex.getLocalizedMessage(), AppStrings.translate("error"), 0);
                    continue;
                }
                openableLists.add(openables);
                OpenableList openables1 = openables;
                boolean first1 = first;
                first = false;
                if (firstOpenable == null && openables1.size() > 0) {
                    firstOpenable = openables1.get(0);
                }
                if (firstSWF == null && openables1.size() > 0 && openables1.get(0) instanceof SWF) {
                    firstSWF = (SWF)openables1.get(0);
                }
                int findex = index;
                try {
                    View.execInEventDispatch(() -> {
                        Main.ensureMainFrame();
                        Main.startWork(AppStrings.translate("work.creatingwindow") + "...", null);
                        if (openables1.isEmpty()) {
                            return;
                        }
                        if (this.reloadIndices[findex] > -1) {
                            mainFrame.getPanel().loadSwfAtPos(openables1, this.reloadIndices[findex]);
                        } else {
                            mainFrame.getPanel().load(openables1, first1);
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if (mainFrame != null) {
                for (OpenableList openableList : openableLists) {
                    for (Openable openable : openableList) {
                        List preselectedNames;
                        SWF swf;
                        SwfSpecificCustomConfiguration conf;
                        if (!(openable instanceof SWF) || (conf = Configuration.getSwfSpecificCustomConfiguration((String)(swf = (SWF)openable).getShortPathTitle())) == null || (preselectedNames = conf.getCustomDataAsList("abcDependencies")).isEmpty()) continue;
                        swf.setAbcIndexDependencies(Main.namesToSwfs(preselectedNames));
                        if (mainFrame == null || mainFrame.getPanel() == null || mainFrame.getPanel().getABCPanel() == null) continue;
                        mainFrame.getPanel().getABCPanel().updateLinksLabel();
                    }
                }
            }
            SWF fswf = firstSWF;
            Openable fopenable = firstOpenable;
            View.execInEventDispatch(() -> {
                if (mainFrame == null) {
                    Main.ensureMainFrame();
                    Main.startWork(AppStrings.translate("work.creatingwindow") + "...", null);
                }
                loadingDialog.setVisible(false);
                if (mainFrame != null) {
                    mainFrame.setVisible(true);
                }
                Main.stopWork();
                if (mainFrame != null && ((Boolean)Configuration.gotoMainClassOnStartup.get()).booleanValue() && fswf != null) {
                    mainFrame.getPanel().gotoDocumentClass(fswf);
                }
                if (mainFrame != null && fopenable != null) {
                    SwfSpecificCustomConfiguration swfCustomConf;
                    SwfSpecificConfiguration swfConf = Configuration.getSwfSpecificConfiguration((String)fopenable.getShortPathTitle());
                    String resourcesPathStr = null;
                    String tagListPathStr = null;
                    if (swfConf != null) {
                        resourcesPathStr = swfConf.lastSelectedPath;
                    }
                    if ((swfCustomConf = Configuration.getSwfSpecificCustomConfiguration((String)fopenable.getShortPathTitle())) != null) {
                        resourcesPathStr = swfCustomConf.getCustomData("lastSelectedPath.resources", resourcesPathStr);
                        tagListPathStr = swfCustomConf.getCustomData("lastSelectedPath.taglist", null);
                        List breakpointsList = swfCustomConf.getCustomDataAsList("breakpoints");
                        for (String breakpoint : breakpointsList) {
                            if (!breakpoint.matches("^.*:[0-9]+$")) continue;
                            int line = Integer.parseInt(breakpoint.substring(breakpoint.lastIndexOf(":") + 1));
                            String scriptName = breakpoint.substring(0, breakpoint.lastIndexOf(":"));
                            Main.getDebugHandler().addBreakPoint(fswf, scriptName, line);
                        }
                    }
                    if (this.loadSession) {
                        if (Main.isInited()) {
                            TreePath tp;
                            AbstractTagTreeModel model;
                            if (resourcesPathStr == null) {
                                model = mainFrame.getPanel().tagTree.getFullModel();
                                TreePath treePath = tp = model == null ? null : model.getTreePath((TreeItem)fopenable);
                                if (tp != null) {
                                    mainFrame.getPanel().tagTree.setSelectionPath(tp);
                                }
                            } else {
                                mainFrame.getPanel().tagTree.setSelectionPathString(resourcesPathStr);
                            }
                            if (tagListPathStr == null) {
                                model = mainFrame.getPanel().tagListTree.getFullModel();
                                TreePath treePath = tp = model == null ? null : ((TagListTreeModel)model).getTreePath((TreeItem)fopenable);
                                if (tp != null) {
                                    mainFrame.getPanel().tagListTree.setSelectionPath(tp);
                                }
                            } else {
                                mainFrame.getPanel().tagListTree.setSelectionPathString(tagListPathStr);
                            }
                        } else {
                            mainFrame.getPanel().tagTree.setExpandPathString(resourcesPathStr);
                            mainFrame.getPanel().tagListTree.setExpandPathString(tagListPathStr);
                        }
                    }
                    mainFrame.getPanel().updateMissingNeededCharacters();
                    if (fswf != null) {
                        mainFrame.getPanel().easyPanel.setTimelined((Timelined)fswf);
                    }
                }
                if (this.executeAfterOpen != null && fopenable != null) {
                    this.executeAfterOpen.opened(fopenable);
                }
            });
            return true;
        }
    }

    private static class SwfDebugPrepare
    extends SwfRunPrepare {
        private boolean doPCode;

        public SwfDebugPrepare(boolean doPCode) {
            this.doPCode = doPCode;
        }

        @Override
        public SWF prepare(SWF instrSWF, String swfHash, List<File> tempFiles) throws InterruptedException {
            EventListener prepEventListener;
            block33: {
                prepEventListener = new EventListener(){

                    public void handleExportingEvent(String type, int index, int count, Object data) {
                    }

                    public void handleExportedEvent(String type, int index, int count, Object data) {
                    }

                    public void handleEvent(String event, Object data) {
                        if (event.equals("inject_debuginfo")) {
                            Main.startWork(AppStrings.translate("work.injecting_debuginfo") + "..." + (String)data, swfPrepareWorker);
                        }
                    }
                };
                instrSWF.addEventListener(prepEventListener);
                try {
                    File fTempFile = new File(instrSWF.getFile());
                    Main.startWork(AppStrings.translate("work.injecting_debuginfo"), swfPrepareWorker, true);
                    instrSWF.enableDebugging(true, new File("."), true, this.doPCode, swfHash);
                    try (FileOutputStream fos = new FileOutputStream(fTempFile);){
                        instrSWF.saveTo((OutputStream)fos);
                    }
                    if (instrSWF.isAS3()) break block33;
                    instrSWF = null;
                    try {
                        var7_9 = null;
                        try (FileInputStream fis = new FileInputStream(fTempFile);){
                            instrSWF = new SWF((InputStream)fis, false, false);
                        }
                        catch (Throwable throwable) {
                            var7_9 = throwable;
                            throw throwable;
                        }
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                    if (instrSWF != null) {
                        String swfFileName = fTempFile.getAbsolutePath();
                        swfFileName = swfFileName.toLowerCase(Locale.ENGLISH).endsWith(".swf") ? swfFileName.substring(0, swfFileName.length() - 4) + ".swd" : swfFileName + ".swd";
                        File swdFile = new File(swfFileName);
                        instrSWF.addEventListener(new EventListener(){

                            public void handleExportingEvent(String type, int index, int count, Object data) {
                            }

                            public void handleExportedEvent(String type, int index, int count, Object data) {
                            }

                            public void handleEvent(String event, Object data) {
                                if (event.equals("generate_swd")) {
                                    Main.startWork(AppStrings.translate("work.generating_swd") + "..." + (String)data, swfPrepareWorker);
                                }
                            }
                        });
                        Main.startWork(AppStrings.translate("work.generating_swd"), swfPrepareWorker, true);
                        if (this.doPCode) {
                            instrSWF.generatePCodeSwdFile(swdFile, Main.getPackBreakPoints(true, swfHash), swfHash);
                        } else {
                            instrSWF.generateSwdFile(swdFile, Main.getPackBreakPoints(true, swfHash), swfHash);
                        }
                        tempFiles.add(swdFile);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            instrSWF.removeEventListener(prepEventListener);
            if (!DebuggerTools.hasDebugger(instrSWF)) {
                DebuggerTools.switchDebugger(instrSWF);
            }
            DebuggerTools.injectDebugLoader(instrSWF);
            currentDebuggerPackage = instrSWF.debuggerPackage;
            return instrSWF;
        }
    }

    private static class SwfRunPrepare
    implements SwfPreparation {
        private SwfRunPrepare() {
        }

        @Override
        public SWF prepare(SWF swf, String swfHash, List<File> tempFiles) throws InterruptedException {
            if (((Boolean)Configuration.autoOpenLoadedSWFs.get()).booleanValue()) {
                if (!DebuggerTools.hasDebugger(swf)) {
                    DebuggerTools.switchDebugger(swf);
                }
                DebuggerTools.injectDebugLoader(swf);
            }
            return swf;
        }
    }

    private static interface SwfPreparation {
        public SWF prepare(SWF var1, String var2, List<File> var3) throws InterruptedException;
    }
}

