/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.decompiler.flash.ApplicationInfo;
import com.jpexs.decompiler.flash.Bundle;
import com.jpexs.decompiler.flash.OpenableSourceInfo;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.configuration.ConfigurationItem;
import com.jpexs.decompiler.flash.configuration.ConfigurationItemChangeListener;
import com.jpexs.decompiler.flash.console.ContextMenuTools;
import com.jpexs.decompiler.flash.exporters.swf.SwfFlashDevelopExporter;
import com.jpexs.decompiler.flash.exporters.swf.SwfIntelliJIdeaExporter;
import com.jpexs.decompiler.flash.exporters.swf.SwfVsCodeExporter;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ErrorLogFrame;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrame;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.MenuBuilder;
import com.jpexs.decompiler.flash.gui.OpenFileResult;
import com.jpexs.decompiler.flash.gui.ReplaceTraceDialog;
import com.jpexs.decompiler.flash.gui.SaveFileMode;
import com.jpexs.decompiler.flash.gui.SearchListener;
import com.jpexs.decompiler.flash.gui.SearchResultsDialog;
import com.jpexs.decompiler.flash.gui.SelectLanguageDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.debugger.DebuggerTools;
import com.jpexs.decompiler.flash.gui.helpers.CheckResources;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.OpenableList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import com.sun.jna.Platform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class MainFrameMenu
implements MenuBuilder {
    private final MainFrame mainFrame;
    private KeyEventDispatcher keyEventDispatcher;
    private Openable openable;
    private ConfigurationItemChangeListener<Boolean> configListenerAutoDeobfuscate;
    private ConfigurationItemChangeListener<Boolean> configListenerFlattenASPackages;
    private ConfigurationItemChangeListener<Boolean> configListenerSimplifyExpressions;
    private ConfigurationItemChangeListener<Boolean> configListenerInternalFlashViewer;
    private ConfigurationItemChangeListener<Boolean> configListenerParallelSpeedUp;
    private ConfigurationItemChangeListener<Boolean> configListenerDecompile;
    private ConfigurationItemChangeListener<Boolean> configListenerGotoMainClassOnStartup;
    private ConfigurationItemChangeListener<Boolean> configListenerAutoDeobfuscateIdentifiers;
    private ConfigurationItemChangeListener<Boolean> configListenerAutoOpenLoadedSWFs;
    protected final Map<String, MenuBuilder.HotKey> menuHotkeys = new HashMap<String, MenuBuilder.HotKey>();
    protected final Map<String, ActionListener> menuActions = new HashMap<String, ActionListener>();

    @Override
    public MenuBuilder.HotKey getMenuHotkey(String path) {
        return this.menuHotkeys.get(path);
    }

    public MainFrameMenu(MainFrame mainFrame) {
        this.registerHotKeys();
        this.mainFrame = mainFrame;
    }

    protected String translate(String key) {
        return this.mainFrame.translate(key);
    }

    protected boolean openActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        Main.openFileDialog();
        return true;
    }

    private boolean saveOpenable(Openable openable) {
        boolean saved = false;
        if (openable != null) {
            if (openable.getOpenableList() != null && openable.getOpenableList().isBundle()) {
                File savedFile = new File(openable.getOpenableList().sourceInfo.getFile());
                Main.startSaving(savedFile);
                Bundle bundle = openable.getOpenableList().bundle;
                if (!bundle.isReadOnly()) {
                    if (openable instanceof SWF) {
                        SWF swf = (SWF)openable;
                        swf.saveNestedDefineBinaryData();
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        openable.saveTo((OutputStream)baos);
                        saved = bundle.putOpenable(openable.getFileTitle(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MainFrameMenu.class.getName()).log(Level.SEVERE, "Cannot save SWF", ex);
                    }
                } else {
                    ViewMessages.showMessageDialog(this.mainFrame.getWindow(), this.translate("error.readonly.cannotSave"), this.translate("error"), 0);
                }
                Main.stopSaving(savedFile);
            } else if (openable instanceof SWF && ((SWF)openable).binaryData != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    SWF swf = (SWF)openable;
                    swf.saveNestedDefineBinaryData();
                    swf.saveTo((OutputStream)baos);
                    byte[] data = baos.toByteArray();
                    swf.binaryData.setDataBytes(new ByteArrayRange(data));
                    swf.binaryData.setModified(true);
                    swf.binaryData.getTopLevelBinaryData().pack();
                    saved = this.saveOpenable((Openable)swf.binaryData.getSwf());
                }
                catch (IOException ex) {
                    Logger.getLogger(MainFrameMenu.class.getName()).log(Level.SEVERE, "Cannot save SWF", ex);
                }
            } else if (openable.getFile() == null) {
                saved = this.saveAs(openable, SaveFileMode.SAVEAS);
            } else {
                try {
                    Main.saveFile(openable, openable.getFile());
                    saved = true;
                }
                catch (Exception | OutOfMemoryError | StackOverflowError ex) {
                    Main.handleSaveError(ex);
                }
            }
            if (saved) {
                openable.clearModified();
                this.mainFrame.getPanel().refreshTree(openable);
            }
        }
        return saved;
    }

    protected void newActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        Main.newFile();
    }

    protected boolean saveActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        return this.saveOpenable(this.openable);
    }

    protected boolean saveAllActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        List<OpenableList> openableLists = this.mainFrame.getPanel().getSwfs();
        ArrayList<Openable> allOpenables = new ArrayList<Openable>();
        for (OpenableList list : openableLists) {
            for (Openable openable : list.items) {
                allOpenables.add(openable);
            }
        }
        for (Openable openable : allOpenables) {
            if (!openable.isModified() || this.saveOpenable(openable)) continue;
            return false;
        }
        return true;
    }

    protected boolean saveAsActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        if (this.openable != null) {
            if (this.saveAs(this.openable, SaveFileMode.SAVEAS) && this.openable.getOpenableList() != null && !this.isSwfReadOnly(this.openable)) {
                this.openable.clearModified();
            }
            return true;
        }
        return false;
    }

    private boolean isSwfReadOnly(Openable openable) {
        return openable.getOpenableList() != null && openable.getOpenableList().bundle != null && openable.getOpenableList().bundle.isReadOnly();
    }

    private boolean saveAs(Openable openable, SaveFileMode mode) {
        View.checkAccess();
        if (Main.saveFileDialog(openable, mode)) {
            this.updateComponents(openable);
            return true;
        }
        return false;
    }

    protected void saveAsExeActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        if (this.openable != null) {
            this.saveAs(this.openable, SaveFileMode.EXE);
        }
    }

    private void enumerateListsToClose(Set<OpenableList> listsToClose, Openable openable, List<SWF> binaryDataClosedSwfs) {
        if (openable instanceof SWF) {
            SWF swf = (SWF)openable;
            if (swf.binaryData != null) {
                swf.binaryData.setInnerSwf(null);
                swf.clearTagSwfs();
                binaryDataClosedSwfs.add(swf);
            } else {
                listsToClose.add(swf.openableList);
            }
        } else if (openable != null) {
            listsToClose.add(openable.getOpenableList());
        }
    }

    protected void closeActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        LinkedHashSet<OpenableList> listsToClose = new LinkedHashSet<OpenableList>();
        ArrayList<SWF> binaryDataClosedSwfs = new ArrayList<SWF>();
        if (this.mainFrame.getPanel().getCurrentView() == 2) {
            SWF itemOpenable = this.mainFrame.getPanel().easyPanel.getSwf();
            this.enumerateListsToClose(listsToClose, (Openable)itemOpenable, binaryDataClosedSwfs);
        } else {
            for (TreeItem item : this.mainFrame.getPanel().getCurrentTree().getSelected()) {
                if (item instanceof OpenableList) {
                    listsToClose.add((OpenableList)item);
                    continue;
                }
                Openable itemOpenable = item.getOpenable();
                this.enumerateListsToClose(listsToClose, itemOpenable, binaryDataClosedSwfs);
            }
        }
        if (this.openable != null && !binaryDataClosedSwfs.contains(this.openable)) {
            this.enumerateListsToClose(listsToClose, this.openable, binaryDataClosedSwfs);
        }
        this.openable = null;
        for (OpenableList list : listsToClose) {
            Main.closeFile(list);
        }
        this.mainFrame.getPanel().refreshTree();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.gc();
            }
        }, 1000L);
    }

    protected boolean closeAllActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        boolean result = Main.closeAll(false);
        if (result) {
            this.openable = null;
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    System.gc();
                }
            }, 1000L);
        }
        return result;
    }

    protected void importTextActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importText((SWF)this.openable);
    }

    protected void importScriptActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importScript(this.openable);
    }

    protected void importImagesActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importImage((SWF)this.openable);
    }

    protected void importShapesActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importShape((SWF)this.openable, false);
    }

    protected void importShapesNoFillActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importShape((SWF)this.openable, true);
    }

    protected void importSpritesActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importSprite((SWF)this.openable);
    }

    protected void importMoviesActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importMovie((SWF)this.openable);
    }

    protected void importSoundsActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importSound((SWF)this.openable);
    }

    protected void importSymbolClassActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importSymbolClass((SWF)this.openable);
    }

    protected boolean exportAllActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        return this.export(false);
    }

    protected boolean exportSelectedActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return false;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        return this.export(true);
    }

    protected boolean export(boolean onlySelected) {
        View.checkAccess();
        if (this.openable != null) {
            this.mainFrame.getPanel().export(onlySelected, this.getSelectedOrCurrentOpenable());
            return true;
        }
        return false;
    }

    protected void exportFlashDevelopActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().exportFlashDevelop((SWF)this.openable);
    }

    protected void exportIdeaActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().exportIdea((SWF)this.openable);
    }

    protected void exportVsCodeActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().exportVsCode((SWF)this.openable);
    }

    protected void exportFlaActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().exportFla((SWF)this.openable);
    }

    protected void importXmlActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().importSwfXml(this.getSelectedOrCurrentOpenable());
    }

    protected void exportXmlActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().exportSwfXml(this.getSelectedOrCurrentOpenable());
    }

    private List<TreeItem> getSelectedOrCurrentOpenable() {
        List<TreeItem> sel = this.mainFrame.getPanel().getCurrentTree().getSelected();
        if (sel.isEmpty() && this.openable != null) {
            sel.add((TreeItem)this.openable);
        }
        return sel;
    }

    protected boolean searchActionPerformed(ActionEvent evt) {
        return this.search(evt, null);
    }

    protected boolean searchInTextPerformed(ActionEvent evt) {
        return this.search(evt, true);
    }

    protected boolean searchInActionPerformed(ActionEvent evt) {
        return this.search(evt, false);
    }

    protected boolean search(ActionEvent evt, Boolean searchInText) {
        View.checkAccess();
        if (this.openable != null) {
            this.mainFrame.getPanel().searchInActionScriptOrText(searchInText, this.openable, false);
            return true;
        }
        return false;
    }

    protected boolean replaceActionPerformed(ActionEvent evt) {
        if (this.openable != null) {
            this.mainFrame.getPanel().replaceText();
            return true;
        }
        return false;
    }

    protected boolean clearLog(ActionEvent evt) {
        ErrorLogFrame.getInstance().clearLog();
        return true;
    }

    protected void renameOneIdentifier(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().renameOneIdentifier((SWF)this.openable);
    }

    protected void renameColliding(ActionEvent evt) {
        View.checkAccess();
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().renameColliding(this.openable);
    }

    protected void renameInvalidIdentifiers(ActionEvent evt) {
        View.checkAccess();
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().renameIdentifiers(this.openable);
    }

    protected void deobfuscationActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        this.mainFrame.getPanel().deobfuscate();
    }

    protected void setSubLimiter(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Main.setSubLimiter(selected);
    }

    protected void switchDebugger() {
        DebuggerTools.switchDebugger((SWF)this.openable);
    }

    protected void debuggerShowLogActionPerformed(ActionEvent evt) {
        DebuggerTools.debuggerShowLog();
    }

    protected void debuggerInjectLoader(ActionEvent evt) {
        DebuggerTools.injectDebugLoader((SWF)this.openable);
        this.refreshDecompiled();
    }

    protected void debuggerReplaceTraceCallsActionPerformed(ActionEvent evt) {
        ReplaceTraceDialog rtd = new ReplaceTraceDialog(Main.getDefaultDialogsOwner(), (String)Configuration.lastDebuggerReplaceFunction.get());
        rtd.setVisible(true);
        if (rtd.getValue() != null) {
            String fname = rtd.getValue();
            DebuggerTools.replaceTraceCalls((SWF)this.openable, fname);
            this.mainFrame.getPanel().refreshDecompiled();
            Configuration.lastDebuggerReplaceFunction.set((Object)rtd.getValue());
        }
    }

    protected void clearRecentFilesActionPerformed(ActionEvent evt) {
        Configuration.recentFiles.set(null);
    }

    protected void clearRecentSearchesActionPerformed(ActionEvent evt) {
        Main.searchResultsStorage.clear();
    }

    protected void clearPinnedItemsActionPerformed(ActionEvent evt) {
        this.mainFrame.getPanel().destroyPins();
    }

    protected void removeNonScripts() {
        if (this.openable instanceof SWF) {
            return;
        }
        this.mainFrame.getPanel().removeNonScripts((SWF)this.openable);
    }

    protected void removeExceptSelected() {
        if (this.openable instanceof SWF) {
            return;
        }
        this.mainFrame.getPanel().removeExceptSelected((SWF)this.openable);
    }

    protected void refreshDecompiled() {
        this.mainFrame.getPanel().refreshDecompiled();
    }

    protected boolean previousTag(ActionEvent evt) {
        return this.mainFrame.getPanel().previousTag();
    }

    protected boolean nextTag(ActionEvent evt) {
        return this.mainFrame.getPanel().nextTag();
    }

    protected void checkResources() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(os);
        CheckResources.checkResources(stream, null);
        final String str = new String(os.toByteArray(), Utf8Helper.charset);
        JDialog dialog = new JDialog(){

            @Override
            public void setVisible(boolean bln) {
                this.setSize(new Dimension(800, 600));
                Container cnt = this.getContentPane();
                cnt.setLayout(new BorderLayout());
                String[] languages = (String[])SelectLanguageDialog.getAvailableLanguages().clone();
                languages[0] = "all";
                JComboBox<String> languagesComboBox = new JComboBox<String>(languages);
                this.add(languagesComboBox, "North");
                ScrollPane scrollPane = new ScrollPane();
                JEditorPane editor = new JEditorPane();
                editor.setEditable(false);
                editor.setText(str);
                scrollPane.add(editor);
                this.add((Component)scrollPane, "Center");
                this.setModal(true);
                View.centerScreen(this);
                languagesComboBox.addActionListener(e -> {
                    String lang = (String)languagesComboBox.getSelectedItem();
                    if (lang.equals("all")) {
                        lang = null;
                    }
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try (PrintStream stream = new PrintStream((OutputStream)os, false, "UTF-8");){
                        CheckResources.checkResources(stream, lang);
                        String str2 = new String(os.toByteArray(), Utf8Helper.charset);
                        editor.setText(str2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                });
                super.setVisible(bln);
            }
        };
        dialog.setVisible(true);
    }

    protected void checkUpdatesActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        if (!Main.checkForUpdates()) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), this.translate("update.check.nonewversion"), this.translate("update.check.title"), 1);
        }
    }

    protected void helpUsActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        String helpUsURL = "https://github.com/jindrapetrik/jpexs-decompiler";
        if (!View.navigateUrl(helpUsURL)) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), this.translate("message.helpus").replace("%url%", helpUsURL));
        }
    }

    protected void homePageActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        String homePageURL = "https://github.com/jindrapetrik/jpexs-decompiler";
        if (!View.navigateUrl(homePageURL)) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), this.translate("message.homepage").replace("%url%", homePageURL));
        }
    }

    protected void wikiActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        String wikiURL = "https://github.com/jindrapetrik/jpexs-decompiler/wiki";
        if (!View.navigateUrl(wikiURL)) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), this.translate("message.wiki").replace("%url%", wikiURL));
        }
    }

    protected void aboutActionPerformed(ActionEvent evt) {
        if (Main.isWorking()) {
            return;
        }
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        Main.about();
    }

    protected boolean reloadActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        if (!(this.openable == null || ((Boolean)Configuration.showCloseConfirmation.get()).booleanValue() && ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.confirm.reload"), this.translate("message.warning"), 0, 2) != 0)) {
            if (this.openable.getOpenableList() == null) {
                if (this.openable instanceof SWF) {
                    SWF swf = (SWF)this.openable;
                    if (swf.binaryData != null) {
                        this.mainFrame.getPanel().loadFromBinaryTag(swf.binaryData);
                    }
                }
            } else {
                Main.reloadFile(this.openable.getOpenableList());
            }
        }
        return true;
    }

    protected boolean reloadAllActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            return false;
        }
        if (this.openable != null) {
            if (!((Boolean)Configuration.showCloseConfirmation.get()).booleanValue() || ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.confirm.reloadAll"), this.translate("message.warning"), 0, 2) == 0) {
                Main.reloadApp();
            }
            return true;
        }
        Main.reloadApp();
        return true;
    }

    protected void advancedSettingsActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        Main.advancedSettings();
    }

    protected void solEditorActionPerformed(ActionEvent evt) {
        Main.openSolEditor();
    }

    protected void searchMemoryActionPerformed(ActionEvent evt) {
        Main.loadFromMemory();
    }

    protected void gotoDocumentClassOnStartupActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.gotoMainClassOnStartup.set((Object)selected);
    }

    protected void autoOpenLoadedSWFsActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.autoOpenLoadedSWFs.set((Object)selected);
    }

    protected void flattenASPackagesActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.flattenASPackages.set((Object)selected);
    }

    protected void autoRenameIdentifiersActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        if (!selected || ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.confirm.autoRenameIdentifiers") + "\r\n" + this.translate("message.confirm.on"), this.translate("message.confirm"), 2, (ConfigurationItem<Boolean>)Configuration.warningRenameIdentifiers, 0) == 0) {
            Configuration.autoRenameIdentifiers.set((Object)selected);
            this.mainFrame.getPanel().autoDeobfuscateChanged();
        } else {
            button.setSelected((Boolean)Configuration.autoRenameIdentifiers.get());
        }
    }

    protected void autoDeobfuscateIdentifiersActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.autoDeobfuscateIdentifiers.set((Object)selected);
        this.mainFrame.getPanel().autoDeobfuscateChanged();
    }

    protected void setLanguageActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            return;
        }
        new SelectLanguageDialog(Main.getDefaultDialogsOwner()).display();
    }

    protected void disableDecompilationActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.decompile.set((Object)(!selected ? 1 : 0));
        this.mainFrame.getPanel().disableDecompilationChanged();
    }

    protected void associateActionPerformed(ActionEvent evt) {
        final AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        if (selected == ContextMenuTools.isAddedToContextMenu()) {
            return;
        }
        ContextMenuTools.addToContextMenu(selected, false);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                button.setSelected(ContextMenuTools.isAddedToContextMenu());
            }
        }, 1000L);
    }

    protected void gotoDocumentClassActionPerformed(ActionEvent evt) {
        this.mainFrame.getPanel().gotoDocumentClass(this.mainFrame.getPanel().getCurrentSwf());
    }

    protected void parallelSpeedUpActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        String confStr = this.translate("message.confirm.parallel") + "\r\n";
        confStr = selected ? confStr + " " + this.translate("message.confirm.on") : confStr + " " + this.translate("message.confirm.off");
        if (ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), confStr, this.translate("message.parallel"), 2) == 0) {
            Configuration.parallelSpeedUp.set((Object)selected);
        } else {
            button.setSelected((Boolean)Configuration.parallelSpeedUp.get());
        }
    }

    protected void simplifyExpressionsActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        Configuration.simplifyExpressions.set((Object)selected);
        this.mainFrame.getPanel().autoDeobfuscateChanged();
    }

    protected void autoDeobfuscationActionPerformed(ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        boolean selected = button.isSelected();
        if (ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.confirm.autodeobfuscate") + "\r\n" + (selected ? this.translate("message.confirm.on") : this.translate("message.confirm.off")), this.translate("message.confirm"), 2, (ConfigurationItem<Boolean>)Configuration.warningDeobfuscation, 0) == 0) {
            Configuration.autoDeobfuscate.set((Object)selected);
            this.mainFrame.getPanel().autoDeobfuscateChanged();
        } else {
            button.setSelected((Boolean)Configuration.autoDeobfuscate.get());
        }
    }

    protected void exitActionPerformed(ActionEvent evt) {
        JFrame frame = (JFrame)((Object)this.mainFrame);
        frame.dispatchEvent(new WindowEvent(frame, 201));
    }

    public void updateComponents() {
        this.updateComponents(this.openable);
    }

    public void updateComponents(Openable openable) {
        boolean openableOrListSelected;
        this.openable = openable;
        boolean isRunning = Main.isRunning();
        boolean isDebugRunning = Main.isDebugRunning();
        boolean isDebugPaused = Main.isDebugPaused();
        boolean isRunningOrDebugging = isRunning || isDebugRunning;
        SWF swf = openable instanceof SWF ? (SWF)openable : null;
        boolean openableSelected = openable != null;
        boolean swfSelected = openable instanceof SWF;
        boolean abcSelected = openable instanceof ABC;
        boolean isAs3 = false;
        boolean canExportFlashDevelop = false;
        boolean canExportIdea = false;
        boolean canExportVsCode = false;
        if (swf != null) {
            isAs3 = swf.isAS3();
            canExportFlashDevelop = SwfFlashDevelopExporter.canExportSwf((SWF)swf);
            canExportIdea = SwfIntelliJIdeaExporter.canExportSwf((SWF)swf);
            canExportVsCode = SwfVsCodeExporter.canExportSwf((SWF)swf);
        }
        if (abcSelected) {
            isAs3 = true;
        }
        boolean isWorking = Main.isWorking();
        List abcList = swf != null ? swf.getAbcList() : null;
        boolean hasAbc = openableSelected && abcList != null && !abcList.isEmpty();
        boolean hasDebugger = hasAbc && DebuggerTools.hasDebugger(swf);
        MainPanel mainPanel = this.mainFrame.getPanel();
        boolean swfLoaded = mainPanel != null ? !mainPanel.getSwfs().isEmpty() : false;
        boolean swfIsNew = openableSelected && openable.getOpenableList() != null && openable.getOpenableList().sourceInfo.isEmpty();
        boolean anythingModified = mainPanel != null ? mainPanel.isModified() : false;
        boolean swfModified = swf == null ? false : swf.isModified();
        boolean allSameSwf = true;
        boolean allSameOpenable = true;
        boolean bl = openableOrListSelected = openable != null;
        if (mainPanel != null) {
            List<TreeItem> items = mainPanel.getCurrentTree().getSelected();
            SWF firstSwf = null;
            Openable firstOpenable = null;
            for (TreeItem item : items) {
                if (item instanceof OpenableList) {
                    if (items.size() == 1) {
                        openableOrListSelected = true;
                    }
                    allSameSwf = false;
                    break;
                }
                Openable fopenable = item.getOpenable();
                if (firstOpenable == null) {
                    firstOpenable = fopenable;
                } else if (fopenable != firstOpenable) {
                    allSameOpenable = false;
                }
                if (firstSwf == null) {
                    if (fopenable instanceof SWF) {
                        firstSwf = (SWF)fopenable;
                        continue;
                    }
                    allSameSwf = false;
                    break;
                }
                if (item.getOpenable() == firstSwf) continue;
                allSameSwf = false;
                break;
            }
        }
        this.setMenuEnabled("_/open", !isWorking);
        this.setMenuEnabled("/file/open", !isWorking);
        this.setMenuEnabled("_/save", openableSelected && !isWorking && swfModified);
        this.setMenuEnabled("/file/save", openableSelected && !isWorking && swfModified);
        this.setMenuEnabled("_/saveAs", openableSelected && !isWorking);
        this.setMenuEnabled("/file/saveAs", openableSelected && !isWorking);
        this.setMenuEnabled("_/saveAll", !isWorking && anythingModified);
        this.setMenuEnabled("/file/saveAll", !isWorking && anythingModified);
        this.setMenuEnabled("_/close", openableOrListSelected && !isWorking);
        this.setMenuEnabled("/file/close", openableOrListSelected && !isWorking);
        this.setMenuEnabled("_/closeAll", swfLoaded && !isWorking);
        this.setMenuEnabled("/file/closeAll", swfLoaded && !isWorking);
        this.setMenuEnabled("/file/reload", openableSelected && !swfIsNew && !isWorking);
        this.setMenuEnabled("/file/export", openableSelected);
        this.setMenuEnabled("_/exportAll", openableSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportAll", openableSelected && !isWorking);
        this.setMenuEnabled("_/exportFla", swfSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportFla", allSameSwf && openableSelected && !isWorking);
        this.setMenuEnabled("_/exportFlashDevelop", swfSelected && !isWorking && canExportFlashDevelop);
        this.setMenuEnabled("/file/export/exportFlashDevelop", allSameSwf && openableSelected && isAs3 && !isWorking && canExportFlashDevelop);
        this.setMenuEnabled("_/exportIdea", swfSelected && !isWorking && canExportIdea);
        this.setMenuEnabled("/file/export/exportIdea", allSameSwf && openableSelected && isAs3 && !isWorking && canExportIdea);
        this.setMenuEnabled("_/exportVsCode", swfSelected && !isWorking && canExportVsCode);
        this.setMenuEnabled("/file/export/exportVsCode", allSameSwf && openableSelected && isAs3 && !isWorking && canExportVsCode);
        this.setMenuEnabled("_/exportSelected", openableSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportSelected", openableSelected && !isWorking);
        this.setMenuEnabled("/file/export/exportXml", swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab", openableSelected);
        this.setMenuEnabled("/import/importtab/importText", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importScript", allSameOpenable && openableSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importImages", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importSprites", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importShapes", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importShapesNoFill", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importMovies", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importSounds", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importSymbolClass", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/import/importtab/importXml", allSameSwf && swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation", openableSelected);
        this.setMenuEnabled("/tools/deobfuscation/renameOneIdentifier", swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation/renameInvalidIdentifiers", swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation/renameColliding", swfSelected && !isWorking);
        this.setMenuEnabled("/tools/deobfuscation/deobfuscation", hasAbc);
        this.setMenuEnabled("/tools/search", openableSelected);
        this.setMenuEnabled("/tools/replace", swfSelected);
        this.setMenuEnabled("/tools/abcExplorer", isAs3);
        this.setMenuEnabled("/tools/gotoDocumentClass", hasAbc);
        this.setMenuEnabled("/tools/saveAsExe", swfSelected && !isWorking);
        this.setMenuEnabled("_/checkUpdates", !isWorking);
        this.setMenuEnabled("/help/checkUpdates", !isWorking);
        this.setMenuEnabled("/help/homePage", !isWorking);
        this.setMenuEnabled("/help/wiki", !isWorking);
        this.setMenuEnabled("_/about", !isWorking);
        this.setMenuEnabled("/help/about", !isWorking);
        this.setMenuEnabled("/file/start/run", swfSelected && !isRunningOrDebugging);
        this.setMenuEnabled("/file/start/debug", swfSelected && !isRunningOrDebugging);
        this.setMenuEnabled("/file/start/debugpcode", swfSelected && !isRunningOrDebugging);
        this.setMenuEnabled("/file/start/stop", isRunningOrDebugging);
        this.setMenuEnabled("/debugging/debug/stop", isRunningOrDebugging);
        this.setPathVisible("/debugging", isDebugRunning);
        this.setPathVisible("/debugging/debug", isDebugRunning);
        this.setMenuEnabled("/debugging/debug/stepOver", isDebugPaused);
        this.setMenuEnabled("/debugging/debug/stepInto", isDebugPaused);
        this.setMenuEnabled("/debugging/debug/stepOut", isDebugPaused);
        this.setMenuEnabled("/debugging/debug/continue", isDebugPaused);
        StringBuilder titleBuilder = new StringBuilder();
        titleBuilder.append(ApplicationInfo.applicationVerName);
        if (((Boolean)Configuration.displayFileName.get()).booleanValue() && openable != null) {
            titleBuilder.append(" - ");
            titleBuilder.append(openable.getFullPathTitle());
        }
        this.mainFrame.setTitle(titleBuilder.toString());
        if (mainPanel != null) {
            switch (mainPanel.getCurrentView()) {
                case 0: {
                    this.setGroupSelection("view", "/file/view/viewResources");
                    break;
                }
                case 3: {
                    this.setGroupSelection("view", "/file/view/viewTagList");
                    break;
                }
                case 1: {
                    this.setGroupSelection("view", "/file/view/viewHex");
                    break;
                }
                case 2: {
                    this.setGroupSelection("view", null);
                    this.setMenuChecked("/file/view/easy", true);
                }
            }
        }
    }

    private void registerHotKeys() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.keyEventDispatcher = this::dispatchKeyEvent;
        manager.addKeyEventDispatcher(this.keyEventDispatcher);
    }

    public void createMenuBar() {
        this.initMenu();
        if (this.supportsAppMenu()) {
            this.addMenuItem("_", null, null, null, 0, null, false, null, false);
            this.addMenuItem("_/open", this.translate("menu.file.open"), "open32", this::openActionPerformed, 3, this::loadRecent, false, null, false);
            this.addMenuItem("_/save", this.translate("menu.file.save"), "save32", this::saveActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/saveAll", this.translate("menu.file.saveAll"), "saveall32", this::saveAllActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/saveAs", this.translate("menu.file.saveas"), "saveas32", this::saveAsActionPerformed, 3, null, true, null, false);
            this.addSeparator("_");
            this.addMenuItem("_/exportFla", this.translate("menu.file.export.fla"), "exportfla32", this::exportFlaActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/exportFlashDevelop", this.translate("menu.file.export.flashDevelop"), "exportflashdevelop32", this::exportFlashDevelopActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/exportIdea", this.translate("menu.file.export.idea"), "exportidea32", this::exportIdeaActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/exportVsCode", this.translate("menu.file.export.vsCode"), "exportvscode32", this::exportVsCodeActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/exportAll", this.translate("menu.file.export.all"), "export32", this::exportAllActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/exportSelected", this.translate("menu.file.export.selection"), "exportsel32", this::exportSelectedActionPerformed, 3, null, true, null, false);
            this.addSeparator("_");
            this.addMenuItem("_/checkUpdates", this.translate("menu.help.checkupdates"), "update32", this::checkUpdatesActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/about", this.translate("menu.help.about"), "about32", this::aboutActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/close", this.translate("menu.file.close"), "close32", this::closeActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/closeAll", this.translate("menu.file.closeAll"), "closeall32", this::closeAllActionPerformed, 3, null, true, null, false);
            this.addMenuItem("_/$exit", this.translate("menu.file.exit"), "exit32", this::exitActionPerformed, 3, null, true, null, false);
            this.finishMenu("_");
        }
        this.addMenuItem("/file", this.translate("menu.file"), null, null, 0, null, false, null, false);
        this.addMenuItem("/file/open", this.translate("menu.file.open"), "open32", this::openActionPerformed, 3, this::loadRecent, !this.supportsMenuAction(), new MenuBuilder.HotKey("CTRL+SHIFT+O"), false);
        if (!this.supportsMenuAction()) {
            this.addMenuItem("/file/recent", this.translate("menu.recentFiles"), null, null, 0, this::loadRecent, false, null, false);
            this.finishMenu("/file/recent");
        } else {
            this.finishMenu("/file/open");
        }
        this.addMenuItem("/file/new", this.translate("menu.file.new"), "newswf32", this::newActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/file/save", this.translate("menu.file.save"), "save16", this::saveActionPerformed, 3, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+S"), false);
        this.addMenuItem("/file/saveAll", this.translate("menu.file.saveAll"), "saveall32", this::saveAllActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/saveAs", this.translate("menu.file.saveas"), "saveas16", this::saveAsActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+A"), false);
        this.addMenuItem("/file/reload", this.translate("menu.file.reload"), "reload16", this::reloadActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+R"), false);
        this.addMenuItem("/file/reloadAll", this.translate("menu.file.reloadAll"), "reload16", this::reloadAllActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/close", this.translate("menu.file.close"), "close32", this::closeActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/closeAll", this.translate("menu.file.closeAll"), "closeall32", this::closeAllActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+X"), false);
        this.addSeparator("/file");
        this.addMenuItem("/file/export", this.translate("menu.export"), null, null, 0, null, false, null, false);
        this.addMenuItem("/file/export/exportFla", this.translate("menu.file.export.fla"), "exportfla32", this::exportFlaActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/file/export/exportFlashDevelop", this.translate("menu.file.export.flashDevelop"), "exportflashdevelop32", this::exportFlashDevelopActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/export/exportIdea", this.translate("menu.file.export.idea"), "exportidea32", this::exportIdeaActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/export/exportVsCode", this.translate("menu.file.export.vsCode"), "exportvscode32", this::exportVsCodeActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/export/exportXml", this.translate("menu.file.export.xml"), "exportxml32", this::exportXmlActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/file/export/exportAll", this.translate("menu.file.export.all"), "export16", this::exportAllActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+SHIFT+E"), false);
        this.addMenuItem("/file/export/exportSelected", this.translate("menu.file.export.selection"), "exportsel16", this::exportSelectedActionPerformed, 2, null, true, null, false);
        this.finishMenu("/file/export");
        this.addMenuItem("/import", this.translate("menu.import"), null, null, 0, null, false, null, false);
        this.addMenuItem("/import/importtab", this.translate("menu.import"), null, null, 0, null, false, null, false);
        this.addMenuItem("/import/importtab/importXml", this.translate("menu.file.import.xml"), "importxml32", this::importXmlActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/import/importtab/importText", this.translate("menu.file.import.text"), "importtext32", this::importTextActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importScript", this.translate("menu.file.import.script"), "importscript32", this::importScriptActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importImages", this.translate("menu.file.import.image"), "importimage32", this::importImagesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importShapes", this.translate("menu.file.import.shape"), "importshape32", this::importShapesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importShapesNoFill", this.translate("menu.file.import.shapeNoFill"), "importshape32", this::importShapesNoFillActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importSprites", this.translate("menu.file.import.sprite"), "importsprite32", this::importSpritesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importMovies", this.translate("menu.file.import.movie"), "importmovie32", this::importMoviesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importSounds", this.translate("menu.file.import.sound"), "importsound32", this::importSoundsActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/import/importtab/importSymbolClass", this.translate("menu.file.import.symbolClass"), "importsymbolclass32", this::importSymbolClassActionPerformed, 2, null, true, null, false);
        this.finishMenu("/import/importtab");
        this.finishMenu("/import");
        this.addMenuItem("/file/start", this.translate("menu.file.start"), null, null, 0, null, false, null, false);
        this.addMenuItem("/file/start/run", this.translate("menu.file.start.run"), "play32", this::runActionPerformed, 3, null, true, new MenuBuilder.HotKey("F6"), false);
        this.addMenuItem("/file/start/stop", this.translate("menu.file.start.stop"), "stop32", this::stopActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/file/start/debug", this.translate("menu.file.start.debug"), "debug32", this::debugActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+F5"), false);
        this.addMenuItem("/file/start/debugpcode", this.translate("menu.file.start.debugpcode"), "debug32", this::debugPCodeActionPerformed, 2, null, true, null, false);
        this.finishMenu("/file/start");
        this.addMenuItem("/file/view", this.translate("menu.view"), null, null, 0, null, false, null, false);
        if (!this.supportsAppMenu()) {
            this.addToggleMenuItem("/file/view/alwaysOnTop", this.translate("menu.file.view.alwaysOnTop"), null, null, this::alwaysOnTopActionPerformed, 0, null);
        }
        this.addToggleMenuItem("/file/view/viewResources", this.translate("menu.file.view.resources"), "view", "viewresources16", this::viewResourcesActionPerformed, 2, null);
        this.addToggleMenuItem("/file/view/viewTagList", this.translate("menu.file.view.tagList"), "view", "taglist16", this::viewTagListActionPerformed, 2, null);
        this.addToggleMenuItem("/file/view/viewHex", this.translate("menu.file.view.hex"), "view", "viewhex16", this::viewHexActionPerformed, 2, null);
        this.addToggleMenuItem("/file/view/easy", this.translate("menu.file.view.easy"), null, "easy32", this::easyActionPerformed, 3, null);
        this.finishMenu("/file/view");
        this.addSeparator("/file");
        if (!this.supportsAppMenu()) {
            this.addSeparator("/file");
            this.addMenuItem("/file/exit", this.translate("menu.file.exit"), "exit32", this::exitActionPerformed, 3, null, true, null, false);
        }
        this.finishMenu("/file");
        this.addMenuItem("/debugging", this.translate("menu.debugging"), null, null, 0, null, false, null, true);
        this.addMenuItem("/debugging/debug", this.translate("menu.debugging.debug"), null, null, 0, null, false, null, false);
        this.addMenuItem("/debugging/debug/stop", this.translate("menu.file.start.stop"), "stop32", this::stopActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/debugging/debug/continue", this.translate("menu.debugging.debug.continue"), "continue32", this::continueActionPerformed, 3, null, true, new MenuBuilder.HotKey("F5"), false);
        this.addMenuItem("/debugging/debug/stepOver", this.translate("menu.debugging.debug.stepOver"), "stepover32", this::stepOverActionPerformed, 2, null, true, new MenuBuilder.HotKey("F8"), false);
        this.addMenuItem("/debugging/debug/stepInto", this.translate("menu.debugging.debug.stepInto"), "stepinto32", this::stepIntoActionPerformed, 2, null, true, new MenuBuilder.HotKey("F7"), false);
        this.addMenuItem("/debugging/debug/stepOut", this.translate("menu.debugging.debug.stepOut"), "stepout32", this::stepOutActionPerformed, 2, null, true, new MenuBuilder.HotKey("CTRL+F7"), false);
        this.finishMenu("/debugging/debug");
        this.finishMenu("/debugging");
        this.addMenuItem("/tools", this.translate("menu.tools"), null, null, 0, null, false, null, false);
        this.addMenuItem("/tools/search", this.translate("menu.tools.search"), "search16", this::searchActionPerformed, 3, this::loadRecentSearches, !this.supportsMenuAction(), null, false);
        if (!this.supportsMenuAction()) {
            this.addMenuItem("/tools/recentsearch", this.translate("menu.recentSearches"), null, null, 0, this::loadRecentSearches, false, null, false);
            this.finishMenu("/tools/recentsearch");
        } else {
            this.finishMenu("/tools/search");
        }
        this.addMenuItem("/tools/replace", this.translate("menu.tools.replace"), "replace32", this::replaceActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/tools/abcExplorer", this.translate("menu.tools.abcexplorer"), "abcexplorer32", this::abcExplorerActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/tools/gotoDocumentClass", this.translate("menu.tools.gotoDocumentClass"), "gotomainclass32", this::gotoDocumentClassActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/tools/solEditor", this.translate("menu.tools.solEditor"), "soleditor32", this::solEditorActionPerformed, 3, null, true, null, false);
        if (Platform.isWindows()) {
            this.addMenuItem("/tools/searchMemory", this.translate("menu.tools.searchMemory"), "loadmemory16", this::searchMemoryActionPerformed, 2, null, true, null, false);
        }
        this.addMenuItem("/tools/saveAsExe", this.translate("menu.file.saveasexe"), "saveasexe16", this::saveAsExeActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/tools/deobfuscation", this.translate("menu.tools.deobfuscation"), "deobfuscate16", null, 0, null, false, null, false);
        this.addMenuItem("/tools/deobfuscation/renameOneIdentifier", this.translate("menu.tools.deobfuscation.globalrename"), "rename16", this::renameOneIdentifier, 2, null, true, null, false);
        this.addMenuItem("/tools/deobfuscation/renameInvalidIdentifiers", this.translate("menu.tools.deobfuscation.renameinvalid"), "renameall16", this::renameInvalidIdentifiers, 2, null, true, null, false);
        this.addMenuItem("/tools/deobfuscation/renameColliding", this.translate("menu.tools.deobfuscation.renameColliding"), "renameall16", this::renameColliding, 2, null, true, null, false);
        this.addMenuItem("/tools/deobfuscation/deobfuscation", this.translate("menu.tools.deobfuscation.pcode"), "deobfuscate32", this::deobfuscationActionPerformed, 3, null, true, null, false);
        this.finishMenu("/tools/deobfuscation");
        this.finishMenu("/tools");
        this.addMenuItem("/settings", this.translate("menu.settings"), null, null, 0, null, false, null, false);
        this.addToggleMenuItem("/settings/autoDeobfuscation", this.translate("menu.settings.autodeobfuscation"), null, null, this::autoDeobfuscationActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/autoDeobfuscateIdentifiers", this.translate("menu.settings.autoDeobfuscateIdentifiers"), null, null, this::autoDeobfuscateIdentifiersActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/simplifyExpressions", this.translate("menu.settings.simplifyExpressions"), null, null, this::simplifyExpressionsActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/disableDecompilation", this.translate("menu.settings.disabledecompilation"), null, null, this::disableDecompilationActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/parallelSpeedUp", this.translate("menu.settings.parallelspeedup"), null, null, this::parallelSpeedUpActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/gotoMainClassOnStartup", this.translate("menu.settings.gotoMainClassOnStartup"), null, null, this::gotoDocumentClassOnStartupActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/autoOpenLoadedSWFs", this.translate("menu.settings.autoOpenLoadedSWFs"), null, null, this::autoOpenLoadedSWFsActionPerformed, 0, null);
        this.addToggleMenuItem("/settings/flattenASPackages", this.translate("menu.settings.flattenASPackages"), null, null, this::flattenASPackagesActionPerformed, 0, null);
        if (Platform.isWindows()) {
            this.addToggleMenuItem("/settings/associate", this.translate("menu.settings.addtocontextmenu"), null, null, this::associateActionPerformed, 0, null);
        }
        this.addMenuItem("/settings/language", this.translate("menu.language"), null, null, 0, null, false, null, false);
        this.addMenuItem("/settings/language/setLanguage", this.translate("menu.settings.language"), "setlanguage32", this::setLanguageActionPerformed, 3, null, true, null, false);
        this.finishMenu("/settings/language");
        this.addMenuItem("/settings/advancedSettings", this.translate("menu.advancedsettings.advancedsettings"), null, null, 0, null, false, null, false);
        this.addMenuItem("/settings/advancedSettings/advancedSettings", this.translate("menu.advancedsettings.advancedsettings"), "settings32", this::advancedSettingsActionPerformed, 3, null, true, null, false);
        this.addMenuItem("/settings/advancedSettings/clearRecentFiles", this.translate("menu.tools.otherTools.clearRecentFiles"), "clearrecent16", this::clearRecentFilesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/settings/advancedSettings/clearRecentSearches", this.translate("menu.tools.otherTools.clearRecentSearches"), "clearrecent16", this::clearRecentSearchesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/settings/advancedSettings/clearPinnedItems", this.translate("menu.tools.otherTools.clearPinnedItems"), "clearrecent16", this::clearPinnedItemsActionPerformed, 2, null, true, null, false);
        this.finishMenu("/settings/advancedSettings");
        this.finishMenu("/settings");
        this.setMenuChecked("/settings/autoDeobfuscation", (Boolean)Configuration.autoDeobfuscate.get());
        this.configListenerAutoDeobfuscate = newValue -> this.setMenuChecked("/settings/autoDeobfuscation", (boolean)newValue);
        Configuration.autoDeobfuscate.addListener(this.configListenerAutoDeobfuscate);
        this.setMenuChecked("/settings/simplifyExpressions", (Boolean)Configuration.simplifyExpressions.get());
        this.configListenerSimplifyExpressions = newValue -> this.setMenuChecked("/settings/simplifyExpressions", (boolean)newValue);
        Configuration.simplifyExpressions.addListener(this.configListenerSimplifyExpressions);
        this.setMenuChecked("/settings/parallelSpeedUp", (Boolean)Configuration.parallelSpeedUp.get());
        this.configListenerParallelSpeedUp = newValue -> this.setMenuChecked("/settings/parallelSpeedUp", (boolean)newValue);
        Configuration.parallelSpeedUp.addListener(this.configListenerParallelSpeedUp);
        this.setMenuChecked("/settings/disableDecompilation", (Boolean)Configuration.decompile.get() == false);
        this.configListenerDecompile = newValue -> this.setMenuChecked("/settings/disableDecompilation", newValue == false);
        Configuration.decompile.addListener(this.configListenerDecompile);
        this.setMenuChecked("/settings/gotoMainClassOnStartup", (Boolean)Configuration.gotoMainClassOnStartup.get());
        this.configListenerGotoMainClassOnStartup = newValue -> this.setMenuChecked("/settings/gotoMainClassOnStartup", (boolean)newValue);
        Configuration.gotoMainClassOnStartup.addListener(this.configListenerGotoMainClassOnStartup);
        this.setMenuChecked("/settings/autoDeobfuscateIdentifiers", (Boolean)Configuration.autoDeobfuscateIdentifiers.get());
        this.configListenerAutoDeobfuscateIdentifiers = newValue -> this.setMenuChecked("/settings/autoDeobfuscateIdentifiers", (boolean)newValue);
        Configuration.autoDeobfuscateIdentifiers.addListener(this.configListenerAutoDeobfuscateIdentifiers);
        this.setMenuChecked("/settings/autoOpenLoadedSWFs", (Boolean)Configuration.autoOpenLoadedSWFs.get());
        this.configListenerAutoOpenLoadedSWFs = newValue -> this.setMenuChecked("/settings/autoOpenLoadedSWFs", (boolean)newValue);
        Configuration.autoOpenLoadedSWFs.addListener(this.configListenerAutoOpenLoadedSWFs);
        this.setMenuChecked("/settings/flattenASPackages", (Boolean)Configuration.flattenASPackages.get());
        this.configListenerFlattenASPackages = newValue -> this.setMenuChecked("/settings/flattenASPackages", (boolean)newValue);
        Configuration.flattenASPackages.addListener(this.configListenerFlattenASPackages);
        if (Platform.isWindows()) {
            this.setMenuChecked("/settings/associate", ContextMenuTools.isAddedToContextMenu());
        }
        this.addMenuItem("/help", this.translate("menu.help"), null, null, 0, null, false, null, false);
        this.addMenuItem("/help/homePage", this.translate("menu.help.homepage"), "homepage16", this::homePageActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/help/wiki", this.translate("menu.help.wiki"), "wiki16", this::wikiActionPerformed, 2, null, true, null, false);
        this.addSeparator("/help");
        this.addMenuItem("/help/checkUpdates", this.translate("menu.help.checkupdates"), "update16", this::checkUpdatesActionPerformed, 2, null, true, null, false);
        this.addMenuItem("/help/about", this.translate("menu.help.about"), "about32", this::aboutActionPerformed, 3, null, true, null, false);
        this.finishMenu("/help");
        if (((Boolean)Configuration._showDebugMenu.get()).booleanValue() || ((Boolean)Configuration._debugMode.get()).booleanValue()) {
            this.addMenuItem("/debug", "# FFDec Debug #", null, null, 0, null, false, null, false);
            this.addMenuItem("/debug/removeNonScripts", "Remove non scripts", "continue16", e -> this.removeNonScripts(), 2, null, true, null, false);
            this.addMenuItem("/debug/removeExceptSelected", "Remove except selected", "continue16", e -> this.removeExceptSelected(), 2, null, true, null, false);
            this.addMenuItem("/debug/refreshDecompiled", "Refresh decompiled script", "continue16", e -> this.refreshDecompiled(), 2, null, true, null, false);
            this.addMenuItem("/debug/checkResources", "Check resources", "continue16", e -> this.checkResources(), 2, null, true, null, false);
            this.addMenuItem("/debug/callGc", "Call System.gc()", "continue16", e -> System.gc(), 2, null, true, null, false);
            this.addMenuItem("/debug/emptyCache", "Empty cache", "continue16", e -> {
                SWF nswf = this.mainFrame.getPanel().getCurrentSwf();
                if (nswf != null) {
                    nswf.clearAllCache();
                }
            }, 2, null, true, null, false);
            this.addMenuItem("/debug/emptyAllCache", "Empty all caches", "continue16", e -> Cache.clearAll(), 2, null, true, null, false);
            this.addMenuItem("/debug/memoryInformation", "Memory information", "continue16", e -> {
                String architecture = System.getProperty("sun.arch.data.model");
                Runtime runtime = Runtime.getRuntime();
                String info = "Architecture: " + architecture + Helper.newLine + "Jre 64bit: " + Helper.is64BitJre() + Helper.newLine + "Os 64bit: " + Helper.is64BitOs() + Helper.newLine + "Max: " + runtime.maxMemory() / 1024L / 1024L + "MB" + Helper.newLine + "Total: " + runtime.totalMemory() / 1024L / 1024L + "MB" + Helper.newLine + "Used: " + (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L + "MB" + Helper.newLine + "Free: " + runtime.freeMemory() / 1024L / 1024L + "MB";
                ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), info);
                SWF nswf = this.mainFrame.getPanel().getCurrentSwf();
                if (nswf != null) {
                    nswf.clearAllCache();
                }
            }, 2, null, true, null, false);
            this.addMenuItem("/debug/fixAs3Code", "Fix AS3 code", "continue16", e -> {
                SWF nswf = this.mainFrame.getPanel().getCurrentSwf();
                if (nswf != null) {
                    nswf.fixAS3Code();
                }
            }, 2, null, true, null, false);
            this.addMenuItem("/debug/openTestSwfs", "Open test SWFs", "continue16", e -> {
                OpenableSourceInfo[] sourceInfos = new OpenableSourceInfo[2];
                String mainPath = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                String path = mainPath + "\\..\\..\\libsrc\\ffdec_lib\\testdata\\as2\\as2.swf";
                sourceInfos[0] = new OpenableSourceInfo(null, path, null);
                path = mainPath + "\\..\\..\\libsrc\\ffdec_lib\\testdata\\as3\\as3.swf";
                sourceInfos[1] = new OpenableSourceInfo(null, path, null);
                Main.openFile(sourceInfos);
            }, 2, null, true, null, false);
            this.finishMenu("/debug");
        }
        this.finishMenu("");
    }

    public void showResourcesView() {
        this.viewResourcesActionPerformed(null);
    }

    public void showTagListView() {
        this.viewTagListActionPerformed(null);
    }

    private void reselectView() {
        switch (this.mainFrame.getPanel().getCurrentView()) {
            case 0: {
                this.setMenuChecked("/file/view/viewResources", true);
                break;
            }
            case 3: {
                this.setMenuChecked("/file/view/viewTagList", true);
                break;
            }
            case 1: {
                this.setMenuChecked("/file/view/viewHex", true);
                break;
            }
            case 2: {
                this.setMenuChecked("/file/view/easy", true);
            }
        }
    }

    private void alwaysOnTopActionPerformed(ActionEvent evt) {
        this.mainFrame.getWindow().setAlwaysOnTop(!this.mainFrame.getWindow().isAlwaysOnTop());
        this.setMenuChecked("/file/view/alwaysOnTop", this.mainFrame.getWindow().isAlwaysOnTop());
    }

    private void viewResourcesActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            this.reselectView();
            return;
        }
        Configuration.dumpView.set((Object)false);
        this.mainFrame.getPanel().showView(0);
        this.setGroupSelection("view", "/file/view/viewResources");
        this.setMenuChecked("/file/view/easy", false);
    }

    private void viewHexActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            this.reselectView();
            return;
        }
        Configuration.dumpView.set((Object)true);
        MainPanel mainPanel = this.mainFrame.getPanel();
        if (mainPanel.isModified()) {
            ViewMessages.showMessageDialog(Main.getDefaultMessagesComponent(), this.translate("message.warning.hexViewNotUpToDate"), this.translate("message.warning"), 2, (ConfigurationItem<Boolean>)Configuration.warningHexViewNotUpToDate);
        }
        mainPanel.showView(1);
        this.setGroupSelection("view", "/file/view/viewHex");
        this.setMenuChecked("/file/view/easy", false);
    }

    private void viewTagListActionPerformed(ActionEvent evt) {
        if (this.mainFrame.getPanel().checkEdited()) {
            this.reselectView();
            return;
        }
        Configuration.dumpView.set((Object)false);
        MainPanel mainPanel = this.mainFrame.getPanel();
        mainPanel.showView(3);
        this.setGroupSelection("view", "/file/view/viewTagList");
        this.setMenuChecked("/file/view/easy", false);
    }

    private void debuggerSwitchActionPerformed(ActionEvent evt) {
        boolean debuggerOn = this.isMenuChecked("/tools/debugger/debuggerSwitch");
        if (!debuggerOn || ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.debugger"), this.translate("dialog.message.title"), 2, 1, (ConfigurationItem<Boolean>)Configuration.displayDebuggerInfo, 0) == 0) {
            this.switchDebugger();
            this.mainFrame.getPanel().refreshDecompiled();
        } else {
            this.setMenuChecked("/tools/debugger/debuggerSwitch", false);
        }
        this.setMenuEnabled("/tools/debugger/debuggerReplaceTrace", this.isMenuChecked("/tools/debugger/debuggerSwitch"));
    }

    private void easyActionPerformed(ActionEvent evt) {
        if (this.isMenuChecked("/file/view/easy")) {
            if (!this.mainFrame.getPanel().showView(2)) {
                this.setMenuChecked("/file/view/easy", false);
            } else {
                this.setGroupSelection("view", null);
            }
        } else {
            this.setGroupSelection("view", "/file/view/viewResources");
            this.mainFrame.getPanel().showView(0);
        }
    }

    protected void loadRecentSearches(ActionEvent evt) {
        this.clearMenu("/tools/" + (this.supportsMenuAction() ? "search" : "recentsearch"));
        SWF swf = Main.getMainFrame().getPanel().getCurrentSwf();
        if (swf != null) {
            List<Integer> indices = Main.searchResultsStorage.getIndicesForOpenable((Openable)swf);
            int j = 0;
            for (int i = 0; i < indices.size(); ++i) {
                int fi = indices.get(i);
                String searched = Main.searchResultsStorage.getSearchedValueAt(fi);
                ActionListener a = e -> {
                    ArrayList<SearchListener<JPanel>> listeners = new ArrayList<SearchListener<JPanel>>();
                    listeners.add(Main.getMainFrame().getPanel().getABCPanel());
                    listeners.add(Main.getMainFrame().getPanel().getActionPanel());
                    SearchResultsDialog<Object> sr = swf.isAS3() ? new SearchResultsDialog<ScriptSearchResult>(Main.getDefaultDialogsOwner(), searched, Main.searchResultsStorage.isIgnoreCaseAt(fi), Main.searchResultsStorage.isRegExpAt(fi), listeners) : new SearchResultsDialog(Main.getDefaultDialogsOwner(), searched, Main.searchResultsStorage.isIgnoreCaseAt(fi), Main.searchResultsStorage.isRegExpAt(fi), listeners);
                    sr.setResults(Main.searchResultsStorage.getSearchResultsAt(this.mainFrame.getPanel().getAllOpenablesAndSwfs(), fi));
                    sr.setVisible(true);
                    Main.getMainFrame().getPanel().searchResultsDialogs.add(sr);
                };
                this.addMenuItem("/tools/" + (this.supportsMenuAction() ? "search" : "recentsearch") + "/" + i, j + "    " + searched, null, a, 0, null, true, null, false);
                ++j;
            }
            if (indices.size() > 0) {
                this.addMenuItem("/tools/" + (this.supportsMenuAction() ? "search" : "recentsearch") + "/clear", this.translate("menu.recentSearches.clear"), null, this::clearRecentSearchesForCurrentSwfActionPerformed, 0, null, true, null, false);
            }
        }
        this.finishMenu("/tools/" + (this.supportsMenuAction() ? "search" : "recentsearch"));
    }

    protected void clearRecentSearchesForCurrentSwfActionPerformed(ActionEvent evt) {
        if (ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.confirm.recentSearches.clear"), this.translate("message.confirm"), 2) == 0) {
            Main.searchResultsStorage.clearForOpenable(this.openable);
        }
    }

    protected void loadRecent(ActionEvent evt) {
        List recentFiles = Configuration.getRecentFiles();
        this.clearMenu("/file/" + (this.supportsMenuAction() ? "open" : "recent"));
        this.clearMenu("_/open");
        for (int i = recentFiles.size() - 1; i >= 0; --i) {
            String f = (String)recentFiles.get(i);
            ActionListener a = e -> {
                if (Main.openFile(f, null) == OpenFileResult.NOT_FOUND && ViewMessages.showConfirmDialog(Main.getDefaultMessagesComponent(), this.translate("message.confirm.recentFileNotFound"), this.translate("message.confirm"), 0) == 0) {
                    Configuration.removeRecentFile((String)f);
                }
            };
            this.addMenuItem("/file/" + (this.supportsMenuAction() ? "open" : "recent") + "/" + i, f, null, a, 0, null, true, null, false);
            this.addMenuItem("_/open/" + i, f, null, a, 0, null, true, null, false);
        }
        this.finishMenu("/file/" + (this.supportsMenuAction() ? "open" : "recent"));
        this.finishMenu("_/open");
    }

    public void dispose() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.removeKeyEventDispatcher(this.keyEventDispatcher);
        Configuration.autoDeobfuscate.removeListener(this.configListenerAutoDeobfuscate);
        Configuration.simplifyExpressions.removeListener(this.configListenerSimplifyExpressions);
        Configuration.parallelSpeedUp.removeListener(this.configListenerParallelSpeedUp);
        Configuration.decompile.removeListener(this.configListenerDecompile);
        Configuration.gotoMainClassOnStartup.removeListener(this.configListenerGotoMainClassOnStartup);
        Configuration.autoDeobfuscateIdentifiers.removeListener(this.configListenerAutoDeobfuscateIdentifiers);
        Configuration.autoOpenLoadedSWFs.removeListener(this.configListenerAutoOpenLoadedSWFs);
        Main.stopRun();
    }

    public boolean runActionPerformed(ActionEvent evt) {
        Main.run((SWF)this.openable);
        return true;
    }

    public boolean debugActionPerformed(ActionEvent evt) {
        Main.runDebug((SWF)this.openable, false);
        return true;
    }

    public boolean debugPCodeActionPerformed(ActionEvent evt) {
        Main.runDebug((SWF)this.openable, true);
        return true;
    }

    public boolean stopActionPerformed(ActionEvent evt) {
        Main.stopRun();
        return true;
    }

    public boolean pauseActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands debuggerCommands = Main.getDebugHandler().getCommands();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean stepOverActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.stepOver();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean stepIntoActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.stepInto();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean stepOutActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.stepOut();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    public boolean continueActionPerformed(ActionEvent evt) {
        try {
            DebuggerCommands cmd = Main.getDebugHandler().getCommands();
            this.mainFrame.getPanel().clearDebuggerColors();
            Main.startWork(AppStrings.translate("work.debugging") + "...", null);
            cmd.sendContinue();
        }
        catch (IOException ex) {
            Main.getDebugHandler().disconnect();
        }
        return true;
    }

    protected void abcExplorerActionPerformed(ActionEvent evt) {
        if (this.openable == null) {
            return;
        }
        this.mainFrame.getPanel().showAbcExplorer(this.openable, null);
    }

    public boolean stackActionPerformed(ActionEvent evt) {
        return true;
    }

    public boolean watchActionPerformed(ActionEvent evt) {
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        if (((JFrame)((Object)this.mainFrame)).isActive() && e.getID() == 401) {
            MenuBuilder.HotKey ek = new MenuBuilder.HotKey(e);
            for (String path : this.menuHotkeys.keySet()) {
                MenuBuilder.HotKey mk = this.menuHotkeys.get(path);
                if (!ek.equals(mk) || !this.menuActions.containsKey(path)) continue;
                this.menuActions.get(path).actionPerformed(null);
                return true;
            }
            int code = e.getKeyCode();
            if (e.isControlDown() && e.isShiftDown()) {
                switch (code) {
                    case 70: {
                        return this.searchInActionPerformed(null);
                    }
                    case 84: {
                        return this.searchInTextPerformed(null);
                    }
                    case 68: {
                        return this.clearLog(null);
                    }
                }
            } else if (e.isControlDown() && !e.isShiftDown()) {
                switch (code) {
                    case 38: {
                        return this.previousTag(null);
                    }
                    case 40: {
                        return this.nextTag(null);
                    }
                }
            }
        }
        return false;
    }

    public abstract void hilightPath(String var1);

    public abstract void setPathVisible(String var1, boolean var2);
}

