/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.helpers.TableLayoutHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import layout.TableLayout;

public class NewFileDialog
extends AppDialog {
    private final JPanel compressionEditorPanel = new JPanel();
    private final JComboBox<ComboBoxItem<SWFCompression>> compressionComboBox = new JComboBox();
    private final JComboBox<String> unitComboBox = new JComboBox();
    private final JPanel versionEditorPanel = new JPanel();
    private final JSpinner versionEditor = new JSpinner();
    private final JCheckBox gfxCheckBox = new JCheckBox();
    private final JPanel frameRateEditorPanel = new JPanel();
    private final JSpinner frameRateEditor = new JSpinner();
    private final JPanel propertiesPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final JButton okButton = new JButton(AppStrings.translate("button.ok"));
    private final JButton cancelButton = new JButton(AppStrings.translate("button.cancel"));
    private final JPanel displayRectEditorPanel = new JPanel();
    private final JSpinner widthEditor = new JSpinner();
    private final JSpinner heightEditor = new JSpinner();
    private final JPanel warningPanel = new JPanel();
    private final JLabel warningLabel = new JLabel();
    private final JRadioButton actionScript12RadioButton = new JRadioButton(this.translate("script.type.actionscript1_2"));
    private final JRadioButton actionScript3RadioButton = new JRadioButton(this.translate("script.type.actionscript3"));
    private JButton backgroundColorButton;
    private int result = -1;

    public NewFileDialog(Window owner) {
        super(owner);
        this.setTitle(this.translate("dialog.title"));
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        cnt.setLayout(new BorderLayout());
        TableLayout tl = new TableLayout((double[][])new double[][]{{-2.0, -1.0}, {-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0}});
        this.propertiesPanel.setLayout((LayoutManager)tl);
        FlowLayout layout = new FlowLayout(7);
        layout.setHgap(0);
        layout.setVgap(0);
        this.compressionEditorPanel.setLayout(layout);
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>(AppStrings.translate("header.uncompressed"), SWFCompression.NONE));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("Zlib", SWFCompression.ZLIB));
        this.compressionComboBox.addItem(new ComboBoxItem<SWFCompression>("LZMA", SWFCompression.LZMA));
        this.compressionComboBox.addActionListener(e -> this.validateHeader());
        this.compressionEditorPanel.add(this.compressionComboBox);
        this.versionEditorPanel.setLayout(layout);
        this.versionEditor.setPreferredSize(new Dimension(80, this.versionEditor.getPreferredSize().height));
        this.versionEditor.addChangeListener(e -> this.validateHeader());
        this.versionEditorPanel.add(this.versionEditor);
        this.gfxCheckBox.addActionListener(e -> this.validateHeader());
        this.frameRateEditorPanel.setLayout(layout);
        this.frameRateEditor.setPreferredSize(new Dimension(80, this.frameRateEditor.getPreferredSize().height));
        this.frameRateEditorPanel.add(this.frameRateEditor);
        this.unitComboBox.addItem(this.translate("unit.pixels"));
        this.unitComboBox.addItem(this.translate("unit.twips"));
        this.displayRectEditorPanel.setLayout(layout);
        this.displayRectEditorPanel.setMinimumSize(new Dimension(10, this.displayRectEditorPanel.getMinimumSize().height));
        this.widthEditor.setPreferredSize(new Dimension(80, this.widthEditor.getPreferredSize().height));
        this.heightEditor.setPreferredSize(new Dimension(80, this.heightEditor.getPreferredSize().height));
        this.displayRectEditorPanel.add(this.widthEditor);
        this.displayRectEditorPanel.add(new JLabel("\u00d7"));
        this.displayRectEditorPanel.add(this.heightEditor);
        this.displayRectEditorPanel.add(this.unitComboBox);
        this.warningLabel.setIcon(View.getIcon("warning16"));
        this.warningPanel.setLayout(layout);
        this.warningPanel.setBackground(new Color(255, 213, 29));
        this.warningPanel.add(this.warningLabel);
        this.warningPanel.setVisible(false);
        this.backgroundColorButton = new JButton(""){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintBorder(g);
            }
        };
        this.backgroundColorButton.setToolTipText(AppStrings.translate("button.selectcolor.hint"));
        this.backgroundColorButton.setCursor(new Cursor(12));
        this.backgroundColorButton.addActionListener(this::selectBackgroundColorActionPerformed);
        this.backgroundColorButton.setBorderPainted(true);
        this.backgroundColorButton.setBorder(BorderFactory.createBevelBorder(0));
        Dimension colorDim = new Dimension(16, 16);
        this.backgroundColorButton.setSize(colorDim);
        this.backgroundColorButton.setPreferredSize(colorDim);
        this.backgroundColorButton.setMaximumSize(colorDim);
        JPanel backgroundColorPanel = new JPanel(new BorderLayout());
        backgroundColorPanel.add((Component)this.backgroundColorButton, "West");
        this.actionScript3RadioButton.setSelected(true);
        ButtonGroup actionScriptTypeGroup = new ButtonGroup();
        actionScriptTypeGroup.add(this.actionScript12RadioButton);
        actionScriptTypeGroup.add(this.actionScript3RadioButton);
        JPanel actionScriptTypePanel = new JPanel(new FlowLayout());
        actionScriptTypePanel.add(this.actionScript12RadioButton);
        actionScriptTypePanel.add(this.actionScript3RadioButton);
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.compression")), "0,0");
        this.propertiesPanel.add((Component)this.compressionEditorPanel, "1,0");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.version")), "0,1");
        this.propertiesPanel.add((Component)this.versionEditorPanel, "1,1");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.gfx")), "0,2");
        this.propertiesPanel.add((Component)this.gfxCheckBox, "1,2");
        this.propertiesPanel.add((Component)new JLabel(AppStrings.translate("header.framerate")), "0,3");
        this.propertiesPanel.add((Component)this.frameRateEditorPanel, "1,3");
        this.propertiesPanel.add((Component)new JLabel(this.translate("canvas.size")), "0,4");
        this.propertiesPanel.add((Component)this.displayRectEditorPanel, "1,4");
        this.propertiesPanel.add((Component)this.warningPanel, "0,5,1,5");
        this.propertiesPanel.add((Component)new JLabel(this.translate("background.color")), "0,6");
        this.propertiesPanel.add((Component)backgroundColorPanel, "1,6");
        this.propertiesPanel.add((Component)new JLabel(this.translate("script.type")), "0,7");
        this.propertiesPanel.add((Component)actionScriptTypePanel, "1,7");
        cnt.add((Component)this.propertiesPanel, "Center");
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        this.buttonsPanel.setLayout(new FlowLayout());
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        cnt.add((Component)this.buttonsPanel, "South");
        TableLayoutHelper.addTableSpaces(tl, 4.0);
        this.pack();
        this.setResizable(false);
        View.centerScreen(this);
        View.setWindowIcon(this, "newswf");
        this.setModal(true);
        this.widthEditor.setValue(550);
        this.heightEditor.setValue(400);
        this.unitComboBox.setSelectedIndex(0);
        this.frameRateEditor.setValue(24);
        this.compressionComboBox.setSelectedIndex(1);
        this.versionEditor.setValue(17);
        this.backgroundColorButton.setBackground(Color.white);
    }

    private void selectBackgroundColorActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(null, AppStrings.translate("dialog.selectcolor.title"), this.backgroundColorButton.getBackground());
        if (newColor != null) {
            this.backgroundColorButton.setBackground(newColor);
        }
    }

    private boolean validateHeader() {
        int version = this.getVersionNumber();
        boolean gfx = this.gfxCheckBox.isSelected();
        SWFCompression compression = this.getCompression();
        String resultStr = "";
        boolean result = true;
        if (gfx && compression != SWFCompression.NONE && compression != SWFCompression.ZLIB) {
            resultStr = resultStr + AppStrings.translate("header.warning.unsupportedGfxCompression") + " ";
            result = false;
        }
        if (compression == SWFCompression.ZLIB && version < 6) {
            resultStr = resultStr + AppStrings.translate("header.warning.minimumZlibVersion") + " ";
            result = false;
        }
        if (compression == SWFCompression.LZMA && version < 13) {
            resultStr = resultStr + AppStrings.translate("header.warning.minimumLzmaVersion") + " ";
            result = false;
        }
        this.warningPanel.setVisible(!result);
        if (!result) {
            this.warningLabel.setText(resultStr);
        }
        return result;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int getVersionNumber() {
        return (Integer)this.versionEditor.getModel().getValue();
    }

    public SWFCompression getCompression() {
        ComboBoxItem item = (ComboBoxItem)this.compressionComboBox.getSelectedItem();
        return (SWFCompression)item.getValue();
    }

    public boolean isGfx() {
        return this.gfxCheckBox.isSelected();
    }

    public float getFrameRate() {
        return ((Number)this.frameRateEditor.getModel().getValue()).floatValue();
    }

    public int getXMin() {
        return 0;
    }

    public int getXMax() {
        return this.getUnitMultiplier() * (Integer)this.widthEditor.getModel().getValue();
    }

    public int getYMin() {
        return 0;
    }

    public int getYmax() {
        return this.getUnitMultiplier() * (Integer)this.heightEditor.getModel().getValue();
    }

    private int getUnitMultiplier() {
        return this.unitComboBox.getSelectedIndex() == 0 ? 20 : 1;
    }

    public Color getBackgroundColor() {
        return this.backgroundColorButton.getBackground();
    }

    public boolean isAs3() {
        return this.actionScript3RadioButton.isSelected();
    }
}

