/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.PinButton;
import com.jpexs.decompiler.flash.gui.WrapLayout;
import com.jpexs.decompiler.flash.gui.tagtree.TreeRoot;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PinsPanel
extends JPanel {
    private List<TreeItem> items = new ArrayList<TreeItem>();
    private TreeItem current;
    private MainPanel mainPanel;
    private PinButton lastSelectedButton;
    private PinButton currentUnpinnedButton;
    private List<PinButton> buttons = new ArrayList<PinButton>();
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private List<String> missingTagTreePaths = new ArrayList<String>();
    private List<String> missingTagListPaths = new ArrayList<String>();
    private List<String> missingScrollPos = new ArrayList<String>();
    private static final String PATHS_SEPARATOR = "{#sep#}";

    public PinsPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.setLayout(new WrapLayout(0, 5, 2));
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    public void destroy() {
        this.items.clear();
        this.missingScrollPos.clear();
        this.missingTagListPaths.clear();
        this.missingTagTreePaths.clear();
        this.rebuild();
        this.save();
    }

    public void clear() {
        for (TreeItem item : this.items) {
            String tagListPath;
            String tagTreePath = this.mainPanel.tagTree.getItemPathString(item);
            if (tagTreePath == null) {
                tagTreePath = "";
            }
            if ((tagListPath = this.mainPanel.tagListTree.getItemPathString(item)) == null) {
                tagListPath = "";
            }
            String scrollPos = this.mainPanel.scrollPosStorage.getSerializedScrollPos(item);
            this.missingTagTreePaths.add(tagTreePath);
            this.missingTagListPaths.add(tagListPath);
            this.missingScrollPos.add(scrollPos);
        }
        this.items.clear();
        this.rebuild();
        this.save();
    }

    public void setCurrent(TreeItem item) {
        if (this.lastSelectedButton != null) {
            this.lastSelectedButton.setSelected(false);
        }
        if (item == null) {
            this.current = null;
            this.rebuild();
            return;
        }
        TreeItem itemNoTs = item;
        if (item instanceof TagScript) {
            itemNoTs = ((TagScript)item).getTag();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            TreeItem item2;
            TreeItem item2NoTs = item2 = this.items.get(i);
            if (item2 instanceof TagScript) {
                item2NoTs = ((TagScript)item2).getTag();
            }
            if (item2NoTs != itemNoTs) continue;
            this.current = this.items.get(i);
            this.buttons.get(i).setSelected(true);
            this.lastSelectedButton = this.buttons.get(i);
            if (this.currentUnpinnedButton != null) {
                this.remove(this.currentUnpinnedButton);
                this.revalidate();
                this.repaint();
            }
            return;
        }
        TreeItem currentNoTs = this.current;
        if (currentNoTs instanceof TagScript) {
            currentNoTs = ((TagScript)currentNoTs).getTag();
        }
        if (currentNoTs == itemNoTs) {
            if (this.currentUnpinnedButton != null) {
                this.currentUnpinnedButton.setSelected(true);
            }
            return;
        }
        this.current = item;
        this.rebuild();
    }

    private void rebuild() {
        this.removeAll();
        this.buttons.clear();
        this.currentUnpinnedButton = null;
        boolean currentPinned = false;
        for (final TreeItem item : this.items) {
            final PinButton pinButton = new PinButton(this.mainPanel, item, true);
            pinButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!pinButton.isPinned()) {
                        PinsPanel.this.items.remove(item);
                        PinsPanel.this.rebuild();
                    }
                    PinsPanel.this.save();
                    PinsPanel.this.fireChange();
                }
            });
            pinButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PinsPanel.this.mainPanel.checkEdited()) {
                        return;
                    }
                    PinsPanel.this.current = pinButton.getItem();
                    if (PinsPanel.this.lastSelectedButton != null) {
                        PinsPanel.this.lastSelectedButton.setSelected(false);
                        if (!PinsPanel.this.lastSelectedButton.isPinned()) {
                            PinsPanel.this.remove(PinsPanel.this.lastSelectedButton);
                            PinsPanel.this.revalidate();
                            PinsPanel.this.repaint();
                        }
                    }
                    PinsPanel.this.lastSelectedButton = pinButton;
                    pinButton.setSelected(true);
                    PinsPanel.this.fireChange();
                }
            });
            this.add(pinButton);
            this.buttons.add(pinButton);
            if (item != this.current) continue;
            currentPinned = true;
            this.lastSelectedButton = pinButton;
            pinButton.setSelected(true);
        }
        if (!currentPinned && this.current != null) {
            this.lastSelectedButton = this.currentUnpinnedButton = new PinButton(this.mainPanel, this.current, false);
            this.add(this.currentUnpinnedButton);
            this.currentUnpinnedButton.setSelected(true);
            this.currentUnpinnedButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PinsPanel.this.items.add(PinsPanel.this.current);
                    PinsPanel.this.rebuild();
                    PinsPanel.this.save();
                    PinsPanel.this.fireChange();
                }
            });
        }
        this.revalidate();
        this.repaint();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    private void fireChange() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(ev);
        }
    }

    public List<TreeItem> getPinnedItems() {
        return new ArrayList<TreeItem>(this.items);
    }

    public TreeItem getCurrent() {
        return this.current;
    }

    public void setPinnedItems(List<TreeItem> items) {
        this.items = new ArrayList<TreeItem>(items);
        this.rebuild();
    }

    public void save() {
        StringBuilder tagTreePathsBuilder = new StringBuilder();
        StringBuilder tagListPathsBuilder = new StringBuilder();
        StringBuilder scrollPosesBuilder = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.missingTagTreePaths.size(); ++i) {
            if (!first) {
                tagTreePathsBuilder.append(PATHS_SEPARATOR);
                tagListPathsBuilder.append(PATHS_SEPARATOR);
                scrollPosesBuilder.append(PATHS_SEPARATOR);
            }
            tagTreePathsBuilder.append(this.missingTagTreePaths.get(i));
            tagListPathsBuilder.append(this.missingTagListPaths.get(i));
            scrollPosesBuilder.append(this.missingScrollPos.get(i));
            first = false;
        }
        for (TreeItem item : this.items) {
            String tagListPath;
            String tagTreePath = this.mainPanel.tagTree.getItemPathString(item);
            if (tagTreePath == null) {
                tagTreePath = "";
            }
            TreeItem tagListItem = item;
            if (item instanceof TagScript) {
                tagListItem = ((TagScript)item).getTag();
            }
            if ((tagListPath = this.mainPanel.tagListTree.getItemPathString(tagListItem)) == null) {
                tagListPath = "";
            }
            String scrollPos = this.mainPanel.scrollPosStorage.getSerializedScrollPos(item);
            if (!first) {
                tagTreePathsBuilder.append(PATHS_SEPARATOR);
                tagListPathsBuilder.append(PATHS_SEPARATOR);
                scrollPosesBuilder.append(PATHS_SEPARATOR);
            }
            tagTreePathsBuilder.append(tagTreePath);
            tagListPathsBuilder.append(tagListPath);
            scrollPosesBuilder.append(scrollPos);
            first = false;
        }
        Configuration.pinnedItemsTagTreePaths.set((Object)tagTreePathsBuilder.toString());
        Configuration.pinnedItemsTagListPaths.set((Object)tagListPathsBuilder.toString());
        Configuration.pinnedItemsScrollPos.set((Object)scrollPosesBuilder.toString());
    }

    public void load() {
        String PATHS_END = "{finish}";
        ArrayList<String> missingTagTreePaths = new ArrayList<String>();
        ArrayList<String> missingTagListPaths = new ArrayList<String>();
        ArrayList<String> missingScrollPos = new ArrayList<String>();
        String tagTreePathsCombined = (String)Configuration.pinnedItemsTagTreePaths.get() + PATHS_SEPARATOR + "{finish}";
        String tagListPathsCombined = (String)Configuration.pinnedItemsTagListPaths.get() + PATHS_SEPARATOR + "{finish}";
        String scrollPosCombined = (String)Configuration.pinnedItemsScrollPos.get() + PATHS_SEPARATOR + "{finish}";
        String[] tagTreePaths = tagTreePathsCombined.split(Pattern.quote(PATHS_SEPARATOR));
        String[] tagListPaths = tagListPathsCombined.split(Pattern.quote(PATHS_SEPARATOR));
        String[] scrollPoses = scrollPosCombined.split(Pattern.quote(PATHS_SEPARATOR));
        if (tagTreePaths.length != tagListPaths.length) {
            return;
        }
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (int i = 0; i < tagTreePaths.length - 1; ++i) {
            String tagTreePath = tagTreePaths[i];
            String tagListPath = tagListPaths[i];
            TreeItem item = this.mainPanel.tagTree.getTreeItemFromPathString(tagTreePath);
            if (item == null || item instanceof TreeRoot) {
                item = this.mainPanel.tagListTree.getTreeItemFromPathString(tagListPath);
            }
            String scrollPosStr = "";
            if (!((String)Configuration.pinnedItemsScrollPos.get()).isEmpty()) {
                scrollPosStr = scrollPoses[i];
            }
            if (item != null && !(item instanceof TreeRoot)) {
                items.add(item);
                this.mainPanel.scrollPosStorage.setSerializedScrollPos(item, scrollPosStr);
                continue;
            }
            missingTagTreePaths.add(tagTreePath);
            missingTagListPaths.add(tagListPath);
            missingScrollPos.add(scrollPosStr);
        }
        this.items = items;
        this.missingTagTreePaths = missingTagTreePaths;
        this.missingTagListPaths = missingTagListPaths;
        this.missingScrollPos = missingScrollPos;
        this.rebuild();
    }

    public void removeOpenable(Openable openable) {
        for (int i = 0; i < this.items.size(); ++i) {
            String tagListPath;
            TreeItem item = this.items.get(i);
            Openable itemOpenable = item.getOpenable();
            if (itemOpenable != openable && itemOpenable != null) continue;
            String tagTreePath = this.mainPanel.tagTree.getItemPathString(item);
            if (tagTreePath == null) {
                tagTreePath = "";
            }
            if ((tagListPath = this.mainPanel.tagListTree.getItemPathString(item)) == null) {
                tagListPath = "";
            }
            String scrollPos = this.mainPanel.scrollPosStorage.getSerializedScrollPos(item);
            this.missingTagTreePaths.add(tagTreePath);
            this.missingTagListPaths.add(tagListPath);
            this.missingScrollPos.add(scrollPos);
            this.items.remove(i);
            --i;
        }
        if (this.current != null && this.current.getOpenable() == openable) {
            this.current = null;
            this.lastSelectedButton = null;
        }
        this.save();
        this.rebuild();
    }

    public void replaceItem(TreeItem oldItem, TreeItem newItem) {
        TreeItem oldItemNoTs = oldItem;
        if (oldItem instanceof TagScript) {
            oldItemNoTs = ((TagScript)oldItem).getTag();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            TreeItem item2NoTs = this.items.get(i);
            if (item2NoTs instanceof TagScript) {
                item2NoTs = ((TagScript)item2NoTs).getTag();
            }
            if (item2NoTs != oldItemNoTs) continue;
            this.items.set(i, newItem);
            this.rebuild();
            break;
        }
    }

    public void removeOthers(TreeItem item) {
        this.items.clear();
        this.items.add(item);
        this.rebuild();
        this.save();
    }

    public void pin(TreeItem item) {
        if (!this.isPinned(item)) {
            this.items.add(item);
            this.rebuild();
            this.save();
        }
    }

    public int getPinCount() {
        return this.items.size();
    }

    public boolean isPinned(TreeItem item) {
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            TreeItem item2 = this.items.get(i);
            if (item2 instanceof TagScript) {
                item2 = ((TagScript)item2).getTag();
            }
            if (item2 != item) continue;
            return true;
        }
        return false;
    }

    public void removeItem(TreeItem item) {
        if (item instanceof TagScript) {
            item = ((TagScript)item).getTag();
        }
        for (int i = 0; i < this.items.size(); ++i) {
            TreeItem item2 = this.items.get(i);
            if (item2 instanceof TagScript) {
                item2 = ((TagScript)item2).getTag();
            }
            if (item2 != item) continue;
            this.items.remove(i);
            this.rebuild();
            break;
        }
    }

    public void refreshScriptPacks() {
        block0: for (int b = 0; b < this.buttons.size(); ++b) {
            PinButton button = this.buttons.get(b);
            if (!(button.getItem() instanceof ScriptPack)) continue;
            ScriptPack sp = (ScriptPack)button.getItem();
            List packs = sp.abc.getScriptPacks(null, sp.allABCs);
            for (ScriptPack sp2 : packs) {
                if (!Objects.equals(sp.getClassPath(), sp2.getClassPath())) continue;
                this.replaceItem((TreeItem)sp, (TreeItem)sp2);
                continue block0;
            }
        }
    }
}

