/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.ComboBoxItem;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReplaceCharacterDialog
extends AppDialog {
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private final JList<ComboBoxItem<CharacterTag>> charactersListBox = new JList();
    private final JTextField searchTextField = new JTextField(10);
    private DefaultListModel<ComboBoxItem<CharacterTag>> fullModel = new DefaultListModel();
    private int result = -1;

    public ReplaceCharacterDialog(Window owner) {
        super(owner);
        this.setSize(400, 150);
        this.setDefaultCloseOperation(1);
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel(this.translate("replace.with")), "West");
        JPanel searchPanel = new JPanel(new FlowLayout());
        JLabel iconSearchLabel = new JLabel(View.getIcon("search16"));
        searchPanel.add(iconSearchLabel);
        searchPanel.add(this.searchTextField);
        topPanel.add((Component)searchPanel, "East");
        cnt.add((Component)topPanel, "North");
        this.charactersListBox.setModel(new DefaultListModel());
        if (View.isOceanic()) {
            this.charactersListBox.setBackground(Color.white);
        }
        this.charactersListBox.setSelectionMode(0);
        this.charactersListBox.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ReplaceCharacterDialog.this.okButton.setEnabled(ReplaceCharacterDialog.this.charactersListBox.getSelectedIndex() > -1);
                if (ReplaceCharacterDialog.this.okButton.isEnabled()) {
                    ReplaceCharacterDialog.this.getRootPane().setDefaultButton(ReplaceCharacterDialog.this.okButton);
                } else {
                    ReplaceCharacterDialog.this.getRootPane().setDefaultButton(null);
                }
            }
        });
        this.okButton.setEnabled(false);
        JScrollPane sc = new JScrollPane(this.charactersListBox);
        sc.setPreferredSize(new Dimension(400, 300));
        cnt.add((Component)sc, "Center");
        this.charactersListBox.setCellRenderer(new CharacterTagListCellRenderer());
        JPanel panButtons = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(this.okButton);
        panButtons.add(this.cancelButton);
        cnt.add((Component)panButtons, "South");
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                String searchedText = ReplaceCharacterDialog.this.searchTextField.getText();
                ComboBoxItem selectedValue = (ComboBoxItem)ReplaceCharacterDialog.this.charactersListBox.getSelectedValue();
                DefaultListModel<ComboBoxItem> filteredModel = new DefaultListModel<ComboBoxItem>();
                int newSelectedIndex = -1;
                boolean isEmpty = searchedText.trim().isEmpty();
                for (int i = 0; i < ReplaceCharacterDialog.this.fullModel.getSize(); ++i) {
                    ComboBoxItem element = (ComboBoxItem)ReplaceCharacterDialog.this.fullModel.getElementAt(i);
                    if (!isEmpty && !element.toString().toLowerCase().contains(searchedText.toLowerCase())) continue;
                    filteredModel.addElement(element);
                    if (selectedValue != element) continue;
                    newSelectedIndex = filteredModel.size() - 1;
                }
                ReplaceCharacterDialog.this.charactersListBox.setModel(filteredModel);
                if (newSelectedIndex != -1) {
                    ReplaceCharacterDialog.this.charactersListBox.setSelectedIndex(newSelectedIndex);
                }
            }
        });
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        View.setWindowIcon(this);
        this.setTitle(this.translate("dialog.title"));
        this.pack();
        View.centerScreen(this);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public Integer getCharacterId() {
        if (this.result == -1) {
            return null;
        }
        ComboBoxItem<CharacterTag> item = this.charactersListBox.getSelectedValue();
        if (item == null) {
            return null;
        }
        return item.getValue().getCharacterId();
    }

    public int showDialog(SWF swf, int selectedCharacterId) {
        Map characters = swf.getCharacters(false);
        this.fullModel = new DefaultListModel();
        this.fullModel.clear();
        for (Integer key : characters.keySet()) {
            int characterId;
            CharacterTag character = (CharacterTag)characters.get(key);
            if (character.isImported() || (characterId = character.getCharacterId()) == selectedCharacterId) continue;
            this.fullModel.addElement(new ComboBoxItem<CharacterTag>(character.getName(), character));
        }
        this.charactersListBox.setModel(this.fullModel);
        this.setVisible(true);
        return this.result;
    }

    class CharacterTagListCellRenderer
    extends DefaultListCellRenderer {
        CharacterTagListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                ComboBoxItem comboboxItem = (ComboBoxItem)value;
                label.setIcon(AbstractTagTree.getIconForType(AbstractTagTree.getTreeNodeType((TreeItem)comboboxItem.getValue())));
            }
            return component;
        }
    }
}

