/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.treeitems.AS3ClassTreeItem;
import com.jpexs.decompiler.flash.treeitems.FolderItem;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class ScrollPosStorage {
    private final MainPanel mainPanel;
    private final List<ScrollPosItem> storage = new ArrayList<ScrollPosItem>();
    private static final String PATHS_SEPARATOR = "{#sep#}";
    private static final String POS_SEPARATOR = ";";

    public ScrollPosStorage(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    private int indexOf(TreeItem item) {
        for (int i = 0; i < this.storage.size(); ++i) {
            ScrollPosItem sitem = this.storage.get(i);
            TreeItem titem = sitem.getItem();
            if (titem == null) {
                this.storage.remove(i);
                --i;
                continue;
            }
            if (titem != item) continue;
            return i;
        }
        return -1;
    }

    public void setSerializedScrollPos(TreeItem item, String serializedScrollPos) {
        if (serializedScrollPos.isEmpty()) {
            int index = this.indexOf(item);
            if (index > -1) {
                this.storage.remove(index);
            }
            return;
        }
        String[] parts = (serializedScrollPos + POS_SEPARATOR).split(POS_SEPARATOR);
        int actionScriptScrollHorizontal = Integer.parseInt(parts[0]);
        int actionScriptScrollVertical = Integer.parseInt(parts[1]);
        int actionScriptCaret = Integer.parseInt(parts[2]);
        int pcodeScrollHorizontal = Integer.parseInt(parts[3]);
        int pcodeScrollVertical = Integer.parseInt(parts[4]);
        int pcodeCaret = Integer.parseInt(parts[5]);
        int folderPreviewScrollVertical = Integer.parseInt(parts[6]);
        int folderListScrollVertical = Integer.parseInt(parts[7]);
        int index = this.indexOf(item);
        ScrollPosItem sitem = new ScrollPosItem(item, actionScriptScrollHorizontal, actionScriptScrollVertical, actionScriptCaret, pcodeScrollHorizontal, pcodeScrollVertical, pcodeCaret, folderPreviewScrollVertical, folderListScrollVertical);
        if (index > -1) {
            this.storage.set(index, sitem);
        } else {
            this.storage.add(sitem);
        }
    }

    public String getSerializedScrollPos(TreeItem item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return "";
        }
        ScrollPosItem sitem = this.storage.get(index);
        return sitem.getActionScriptScrollHorizontal() + POS_SEPARATOR + sitem.getActionScriptScrollVertical() + POS_SEPARATOR + sitem.getActionScriptCaret() + POS_SEPARATOR + sitem.getPcodeScrollHorizontal() + POS_SEPARATOR + sitem.getPcodeScrollVertical() + POS_SEPARATOR + sitem.getPcodeCaret() + POS_SEPARATOR + sitem.getFolderPreviewScrollVertical() + POS_SEPARATOR + sitem.getFolderListScrollVertical();
    }

    public void loadScrollPos(final TreeItem item) {
        int index = this.indexOf(item);
        if (index == -1) {
            return;
        }
        final ScrollPosItem sitem = this.storage.get(index);
        this.storage.remove(index);
        this.storage.add(sitem);
        TreeItem asmItem = item;
        if (asmItem instanceof TagScript) {
            asmItem = ((TagScript)item).getTag();
        }
        if (((Boolean)Configuration.rememberScriptsScrollPos.get()).booleanValue()) {
            if (item instanceof ScriptPack) {
                this.mainPanel.getABCPanel().decompiledTextArea.runWhenLoaded(new Runnable(){

                    @Override
                    public void run() {
                        if (sitem.getActionScriptCaret() < ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getABCPanel().decompiledTextArea.getDocument().getLength()) {
                            ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getABCPanel().decompiledTextArea.setCaretPositionForCurrentScript(sitem.getActionScriptCaret(), (ScriptPack)item);
                        }
                        try {
                            ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceTextArea().setCaretPosition(sitem.getPcodeCaret());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        Timer tim = new Timer();
                        tim.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                View.execInEventDispatch(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getABCPanel().decompiledScrollPane.getHorizontalScrollBar().setValue(sitem.getActionScriptScrollHorizontal());
                                        ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getABCPanel().decompiledScrollPane.getVerticalScrollBar().setValue(sitem.getActionScriptScrollVertical());
                                        ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceScrollPane().getHorizontalScrollBar().setValue(sitem.getPcodeScrollHorizontal());
                                        ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceScrollPane().getVerticalScrollBar().setValue(sitem.getPcodeScrollVertical());
                                    }
                                });
                            }
                        }, 100L);
                    }
                });
            } else if (asmItem instanceof ASMSource) {
                this.mainPanel.getActionPanel().runWhenLoaded(new Runnable(){

                    @Override
                    public void run() {
                        if (sitem.getActionScriptCaret() < ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getActionPanel().decompiledEditor.getDocument().getLength()) {
                            ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getActionPanel().decompiledEditor.setCaretPosition(sitem.getActionScriptCaret());
                        }
                        try {
                            ((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getActionPanel().editor.setCaretPosition(sitem.getPcodeCaret());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        Timer tim = new Timer();
                        tim.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                View.execInEventDispatch(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((JScrollPane)((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getActionPanel().decompiledEditor.getParent().getParent()).getHorizontalScrollBar().setValue(sitem.getActionScriptScrollHorizontal());
                                        ((JScrollPane)((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getActionPanel().decompiledEditor.getParent().getParent()).getVerticalScrollBar().setValue(sitem.getActionScriptScrollVertical());
                                        ((JScrollPane)((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getActionPanel().editor.getParent().getParent()).getHorizontalScrollBar().setValue(sitem.getPcodeScrollHorizontal());
                                        ((JScrollPane)((ScrollPosStorage)ScrollPosStorage.this).mainPanel.getActionPanel().editor.getParent().getParent()).getVerticalScrollBar().setValue(sitem.getPcodeScrollVertical());
                                    }
                                });
                            }
                        }, 100L);
                    }
                });
            }
        }
        if (((Boolean)Configuration.rememberFoldersScrollPos.get()).booleanValue()) {
            Timer tim = new Timer();
            tim.schedule(new TimerTask(){

                @Override
                public void run() {
                    View.execInEventDispatchLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JScrollPane)((ScrollPosStorage)ScrollPosStorage.this).mainPanel.folderPreviewPanel.getParent().getParent()).getVerticalScrollBar().setValue(sitem.getFolderPreviewScrollVertical());
                            ((JScrollPane)((ScrollPosStorage)ScrollPosStorage.this).mainPanel.folderListPanel.getParent().getParent()).getVerticalScrollBar().setValue(sitem.getFolderListScrollVertical());
                        }
                    });
                }
            }, 10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveScrollPos(TreeItem item) {
        JComponent jComponent;
        boolean doSave = false;
        TreeItem asmItem = item;
        if (item instanceof TagScript) {
            asmItem = ((TagScript)item).getTag();
        }
        if (item instanceof ScriptPack) {
            doSave = true;
        }
        if (asmItem instanceof ASMSource) {
            doSave = true;
        }
        if (item instanceof FolderItem) {
            doSave = true;
        }
        if (item instanceof AS3ClassTreeItem) {
            doSave = true;
        }
        if (item instanceof AS2Package) {
            doSave = true;
        }
        if (!doSave) {
            return;
        }
        int actionScriptScrollHorizontal = 0;
        int actionScriptScrollVertical = 0;
        int actionScriptCaret = 0;
        int pcodeScrollHorizontal = 0;
        int pcodeScrollVertical = 0;
        int pcodeCaret = 0;
        if (item instanceof ScriptPack) {
            jComponent = this.mainPanel.getABCPanel().decompiledTextArea;
            synchronized (jComponent) {
                if (!this.mainPanel.getABCPanel().decompiledTextArea.isScriptLoaded()) {
                    return;
                }
                if (this.mainPanel.getABCPanel().decompiledTextArea.getScriptLeaf() != item) {
                    return;
                }
                actionScriptCaret = this.mainPanel.getABCPanel().decompiledTextArea.getCaretPosition();
                if (this.mainPanel.getABCPanel().decompiledTextArea.getSelectionStart() > 0) {
                    actionScriptCaret = this.mainPanel.getABCPanel().decompiledTextArea.getSelectionStart();
                }
                actionScriptScrollHorizontal = this.mainPanel.getABCPanel().decompiledScrollPane.getHorizontalScrollBar().getValue();
                actionScriptScrollVertical = this.mainPanel.getABCPanel().decompiledScrollPane.getVerticalScrollBar().getValue();
                pcodeScrollHorizontal = this.mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceScrollPane().getHorizontalScrollBar().getValue();
                pcodeScrollVertical = this.mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceScrollPane().getVerticalScrollBar().getValue();
                pcodeCaret = this.mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceTextArea().getCaretPosition();
                if (this.mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceTextArea().getSelectionStart() > 0) {
                    pcodeCaret = this.mainPanel.getABCPanel().detailPanel.methodTraitPanel.methodCodePanel.getSourceTextArea().getSelectionStart();
                }
            }
        }
        if (asmItem instanceof ASMSource) {
            jComponent = this.mainPanel.getActionPanel();
            synchronized (jComponent) {
                if (!this.mainPanel.getActionPanel().isScriptLoaded()) {
                    return;
                }
                if (this.mainPanel.getActionPanel().getSrc() != asmItem) {
                    return;
                }
                actionScriptScrollHorizontal = ((JScrollPane)this.mainPanel.getActionPanel().decompiledEditor.getParent().getParent()).getHorizontalScrollBar().getValue();
                actionScriptScrollVertical = ((JScrollPane)this.mainPanel.getActionPanel().decompiledEditor.getParent().getParent()).getVerticalScrollBar().getValue();
                actionScriptCaret = this.mainPanel.getActionPanel().decompiledEditor.getCaretPosition();
                if (this.mainPanel.getActionPanel().decompiledEditor.getSelectionStart() > 0) {
                    actionScriptCaret = this.mainPanel.getActionPanel().decompiledEditor.getSelectionStart();
                }
                pcodeScrollHorizontal = ((JScrollPane)this.mainPanel.getActionPanel().editor.getParent().getParent()).getHorizontalScrollBar().getValue();
                pcodeScrollVertical = ((JScrollPane)this.mainPanel.getActionPanel().editor.getParent().getParent()).getVerticalScrollBar().getValue();
                pcodeCaret = this.mainPanel.getActionPanel().editor.getCaretPosition();
                if (this.mainPanel.getActionPanel().editor.getSelectionStart() > 0) {
                    pcodeCaret = this.mainPanel.getActionPanel().editor.getSelectionStart();
                }
            }
        }
        int folderPreviewScrollVertical = 0;
        int folderListScrollVertical = 0;
        if (!(item instanceof ScriptPack) && !(item instanceof ASMSource)) {
            folderPreviewScrollVertical = ((JScrollPane)this.mainPanel.folderPreviewPanel.getParent().getParent()).getVerticalScrollBar().getValue();
        }
        if (!(item instanceof ScriptPack) && !(item instanceof ASMSource)) {
            folderListScrollVertical = ((JScrollPane)this.mainPanel.folderListPanel.getParent().getParent()).getVerticalScrollBar().getValue();
        }
        ScrollPosItem savedItem = new ScrollPosItem(item, actionScriptScrollHorizontal, actionScriptScrollVertical, actionScriptCaret, pcodeScrollHorizontal, pcodeScrollVertical, pcodeCaret, folderPreviewScrollVertical, folderListScrollVertical);
        int index = this.indexOf(item);
        if (savedItem.isEmpty()) {
            if (index > -1) {
                this.storage.remove(index);
            }
            return;
        }
        if (index > -1) {
            this.storage.set(index, savedItem);
        } else {
            this.storage.add(savedItem);
        }
        if (this.storage.size() > (Integer)Configuration.maxRememberedScrollposItems.get()) {
            for (int i = 0; i < this.storage.size(); ++i) {
                TreeItem it = this.storage.get(i).getItem();
                if (it != null && this.mainPanel.isPinned(item)) continue;
                this.storage.remove(0);
                break;
            }
        }
    }

    class ScrollPosItem {
        private final WeakReference<TreeItem> item;
        private final int actionScriptScrollHorizontal;
        private final int actionScriptScrollVertical;
        private final int actionScriptCaret;
        private final int pcodeScrollHorizontal;
        private final int pcodeScrollVertical;
        private final int pcodeCaret;
        private final int folderPreviewScrollVertical;
        private final int folderListScrollVertical;

        public TreeItem getItem() {
            return (TreeItem)this.item.get();
        }

        public int getActionScriptScrollHorizontal() {
            return this.actionScriptScrollHorizontal;
        }

        public int getActionScriptScrollVertical() {
            return this.actionScriptScrollVertical;
        }

        public int getActionScriptCaret() {
            return this.actionScriptCaret;
        }

        public int getPcodeScrollHorizontal() {
            return this.pcodeScrollHorizontal;
        }

        public int getPcodeScrollVertical() {
            return this.pcodeScrollVertical;
        }

        public int getPcodeCaret() {
            return this.pcodeCaret;
        }

        public int getFolderPreviewScrollVertical() {
            return this.folderPreviewScrollVertical;
        }

        public int getFolderListScrollVertical() {
            return this.folderListScrollVertical;
        }

        public ScrollPosItem(TreeItem item, int actionScriptScrollHorizontal, int actionScriptScrollVertical, int actionScriptCaret, int pcodeScrollHorizontal, int pcodeScrollVertical, int pcodeCaret, int folderPreviewScrollVertical, int folderListScrollVertical) {
            this.item = new WeakReference<TreeItem>(item);
            this.actionScriptScrollHorizontal = actionScriptScrollHorizontal;
            this.actionScriptScrollVertical = actionScriptScrollVertical;
            this.actionScriptCaret = actionScriptCaret;
            this.pcodeScrollHorizontal = pcodeScrollHorizontal;
            this.pcodeScrollVertical = pcodeScrollVertical;
            this.pcodeCaret = pcodeCaret;
            this.folderPreviewScrollVertical = folderPreviewScrollVertical;
            this.folderListScrollVertical = folderListScrollVertical;
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + Objects.hashCode(this.item.get());
            hash = 79 * hash + this.actionScriptScrollHorizontal;
            hash = 79 * hash + this.actionScriptScrollVertical;
            hash = 79 * hash + this.actionScriptCaret;
            hash = 79 * hash + this.pcodeScrollHorizontal;
            hash = 79 * hash + this.pcodeScrollVertical;
            hash = 79 * hash + this.pcodeCaret;
            hash = 79 * hash + this.folderPreviewScrollVertical;
            hash = 79 * hash + this.folderListScrollVertical;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScrollPosItem other = (ScrollPosItem)obj;
            if (this.actionScriptScrollHorizontal != other.actionScriptScrollHorizontal) {
                return false;
            }
            if (this.actionScriptScrollVertical != other.actionScriptScrollVertical) {
                return false;
            }
            if (this.actionScriptCaret != other.actionScriptCaret) {
                return false;
            }
            if (this.pcodeScrollHorizontal != other.pcodeScrollHorizontal) {
                return false;
            }
            if (this.pcodeScrollVertical != other.pcodeScrollVertical) {
                return false;
            }
            if (this.pcodeCaret != other.pcodeCaret) {
                return false;
            }
            if (this.folderPreviewScrollVertical != other.folderPreviewScrollVertical) {
                return false;
            }
            if (this.folderListScrollVertical != other.folderListScrollVertical) {
                return false;
            }
            return this.item.get() == other.item.get();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ScrollPosItem{");
            sb.append("actionScriptScrollHorizontal=").append(this.actionScriptScrollHorizontal);
            sb.append(", actionScriptScrollVertical=").append(this.actionScriptScrollVertical);
            sb.append(", actionScriptCaret=").append(this.actionScriptCaret);
            sb.append(", pcodeScrollHorizontal=").append(this.pcodeScrollHorizontal);
            sb.append(", pcodeScrollVertical=").append(this.pcodeScrollVertical);
            sb.append(", pcodeCaret=").append(this.pcodeCaret);
            sb.append(", folderPreviewScrollVertical=").append(this.folderPreviewScrollVertical);
            sb.append(", folderListScrollVertical=").append(this.folderListScrollVertical);
            sb.append('}');
            return sb.toString();
        }

        public boolean isEmpty() {
            if (this.actionScriptScrollHorizontal > 0) {
                return false;
            }
            if (this.actionScriptScrollVertical > 0) {
                return false;
            }
            if (this.actionScriptCaret > 0) {
                return false;
            }
            if (this.pcodeScrollHorizontal > 0) {
                return false;
            }
            if (this.pcodeScrollVertical > 0) {
                return false;
            }
            if (this.pcodeCaret > 0) {
                return false;
            }
            if (this.folderPreviewScrollVertical > 0) {
                return false;
            }
            return this.folderListScrollVertical <= 0;
        }
    }
}

