/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class SelectTagOfTypeDialog
extends AppDialog {
    private JComboBox<ComboItem> tagComboBox;
    private Tag result = null;

    public SelectTagOfTypeDialog(Window window, SWF swf, Class<?> tagType, String tagTypeName, int minFrame) {
        super(window);
        this.setTitle(this.translate("dialog.title").replace("%type%", tagTypeName));
        Container cnt = this.getContentPane();
        this.tagComboBox = new JComboBox();
        int pos = 0;
        int frame = 1;
        for (Tag t : swf.getTags()) {
            if (t instanceof ShowFrameTag) {
                ++frame;
            }
            if (frame < minFrame || !tagType.isAssignableFrom(t.getClass())) continue;
            this.tagComboBox.addItem(new ComboItem(pos, t, frame));
            ++pos;
        }
        this.tagComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ComboItem item = (ComboItem)value;
                label.setIcon(TagTree.getIconFor((TreeItem)item.tag));
                label.setText(value.toString());
                return label;
            }
        });
        JButton okButton = new JButton(this.translate("button.ok"));
        okButton.addActionListener(this::okButtonActionPerformed);
        JButton cancelButton = new JButton(this.translate("button.cancel"));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        cnt.setLayout(new BoxLayout(cnt, 1));
        cnt.add(this.tagComboBox);
        cnt.add(buttonsPanel);
        this.pack();
        this.setModal(true);
        this.setResizable(false);
        View.setWindowIcon(this);
        View.centerScreen(this);
    }

    public Tag getResult() {
        return this.result;
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = ((ComboItem)this.tagComboBox.getSelectedItem()).tag;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = null;
        this.setVisible(false);
    }

    public Tag showDialog() {
        this.result = null;
        if (this.tagComboBox.getItemCount() == 0) {
            return null;
        }
        if (this.tagComboBox.getItemCount() == 1) {
            this.result = this.tagComboBox.getItemAt((int)0).tag;
            return this.result;
        }
        this.setVisible(true);
        return this.result;
    }

    class ComboItem {
        public int index;
        public Tag tag;
        public int frame;

        public ComboItem(int index, Tag tag, int frame) {
            this.index = index;
            this.tag = tag;
            this.frame = frame;
        }

        public String toString() {
            return "" + (this.index + 1) + ". " + this.tag.toString() + " (frame " + this.frame + ")";
        }
    }
}

