/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.Zoom;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundTagPlayer
implements MediaDisplay {
    private int loopCount;
    private boolean paused = false;
    private boolean closed = false;
    private final Object playLock = new Object();
    private final SoundTag tag;
    private final Timer timer;
    private final List<MediaDisplayListener> listeners = new ArrayList<MediaDisplayListener>();
    private boolean rewindAfterStop = false;
    private AudioInputStream audioStream;
    private SourceDataLine sourceLine;
    private Thread thread;
    private long lengthInMicroSec = 0L;
    private double microsecPerByte = 0.0;
    private double positionMicrosec = 0.0;
    private Long newPositionMicrosec = null;
    private byte[] wavData = null;
    private boolean active = false;
    private static int totalInstances = 0;
    private int instanceId = totalInstances++;
    private static final int FRAME_DIVISOR = 8000;

    @Override
    public boolean canHaveRuler() {
        return false;
    }

    @Override
    public boolean canUseSnapping() {
        return false;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getActiveFlag() {
        Object object = this.playLock;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveFlag(boolean value) {
        Object object = this.playLock;
        synchronized (object) {
            this.active = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPausedFlag() {
        Object object = this.playLock;
        synchronized (object) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPausedFlag(boolean value) {
        Object object = this.playLock;
        synchronized (object) {
            this.paused = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getClosedFlag() {
        Object object = this.playLock;
        synchronized (object) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClosedFlag(boolean value) {
        Object object = this.playLock;
        synchronized (object) {
            this.closed = value;
        }
    }

    @Override
    public void addEventListener(MediaDisplayListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(MediaDisplayListener listener) {
        this.listeners.remove(listener);
    }

    public void fireMediaDisplayStateChanged() {
        for (MediaDisplayListener l : this.listeners) {
            l.mediaDisplayStateChanged(this);
        }
    }

    private void firePlayingFinished() {
        for (MediaDisplayListener l : this.listeners) {
            l.playingFinished(this);
        }
    }

    public SoundTagPlayer(final SOUNDINFO soundInfo, final SoundTag tag, int loops, boolean async) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
        this.tag = tag;
        this.loopCount = loops;
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SoundTagPlayer.this.fireMediaDisplayStateChanged();
                }
                catch (Exception ex) {
                    this.cancel();
                }
            }
        }, 100L, 100L);
        if (!async) {
            this.setPausedFlag(true);
        }
        this.thread = new Thread("Sound tag player"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SoundTagPlayer.this.openSound(soundInfo, tag);
                }
                catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
                    Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                Object ex = SoundTagPlayer.this.playLock;
                synchronized (ex) {
                    if (!SoundTagPlayer.this.paused) {
                        SoundTagPlayer.this.play();
                    }
                }
                this.setPriority(1);
                try {
                    SoundTagPlayer.this.playLoop();
                }
                catch (LineUnavailableException ex2) {
                    Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex2);
                }
                catch (Exception ex3) {
                    Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex3);
                }
            }
        };
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSound(SOUNDINFO soundInfo, SoundTag tag) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        boolean isUnCompressed;
        SWF swf = (SWF)tag.getOpenable();
        this.wavData = swf.getFromCache(soundInfo, tag);
        if (this.wavData == null) {
            List soundData = tag.getRawSoundData();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tag.getSoundFormat().createWav(soundInfo, soundData, (OutputStream)baos, tag.getInitialLatency());
            this.wavData = baos.toByteArray();
            swf.putToCache(soundInfo, tag, this.wavData);
            baos = new ByteArrayOutputStream();
        }
        long soundLength44 = 0L;
        boolean bl = isUnCompressed = tag.getSoundFormatId() == 3 || tag.getSoundFormatId() == 0;
        int sampleLen = (isUnCompressed ? (tag.getSoundSize() ? 2 : 1) : 2) * (tag.getSoundFormat().stereo ? 2 : 1);
        switch (tag.getSoundRate()) {
            case 0: {
                soundLength44 = 8L * tag.getTotalSoundSampleCount();
                this.microsecPerByte = 1000000.0 / (5512.5 * (double)sampleLen);
                break;
            }
            case 1: {
                soundLength44 = 4L * tag.getTotalSoundSampleCount();
                this.microsecPerByte = 1000000.0 / (11025.0 * (double)sampleLen);
                break;
            }
            case 2: {
                soundLength44 = 2L * tag.getTotalSoundSampleCount();
                this.microsecPerByte = 1000000.0 / (22050.0 * (double)sampleLen);
                break;
            }
            case 3: {
                soundLength44 = tag.getTotalSoundSampleCount();
                this.microsecPerByte = 1000000.0 / (44100.0 * (double)sampleLen);
            }
        }
        this.lengthInMicroSec = soundLength44 * 1000000L / 44100L;
        Object object = this.playLock;
        synchronized (object) {
            this.reloadAudioStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentFrame() {
        Object object = this.playLock;
        synchronized (object) {
            return (int)(this.positionMicrosec / 8000.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalFrames() {
        Object object = this.playLock;
        synchronized (object) {
            return (int)(this.lengthInMicroSec / 8000L);
        }
    }

    @Override
    public void pause() {
        this.setPausedFlag(true);
    }

    @Override
    public void stop() {
        this.rewindAfterStop = true;
        this.pause();
        this.rewind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.stop();
        this.timer.cancel();
        Object object = this.playLock;
        synchronized (object) {
            this.closed = true;
        }
    }

    private void reloadAudioStream() throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        this.audioStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.wavData));
        if (this.sourceLine != null) {
            this.sourceLine.drain();
            this.sourceLine.stop();
            this.sourceLine.close();
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioStream.getFormat());
        this.sourceLine = (SourceDataLine)AudioSystem.getLine(info);
        this.sourceLine.open(this.audioStream.getFormat());
        this.sourceLine.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playLoop() throws LineUnavailableException {
        block35: {
            while (true) {
                int currentLoopCount;
                byte[] data = new byte[16];
                this.setActiveFlag(true);
                long posBytes = 0L;
                try {
                    int numReadBytes = 0;
                    while (numReadBytes != -1 && !this.getClosedFlag()) {
                        if (!this.getPausedFlag()) {
                            if (this.newPositionMicrosec != null) {
                                long newPosBytes = (long)((double)this.newPositionMicrosec.longValue() / this.microsecPerByte);
                                this.audioStream.close();
                                this.reloadAudioStream();
                                this.audioStream.skip(newPosBytes);
                                this.newPositionMicrosec = null;
                                posBytes = newPosBytes;
                            }
                            if ((numReadBytes = this.audioStream.read(data, 0, data.length)) != -1) {
                                posBytes += (long)numReadBytes;
                                if (this.sourceLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                                    // empty if block
                                }
                                this.sourceLine.write(data, 0, numReadBytes);
                                Object newPosBytes = this.playLock;
                                synchronized (newPosBytes) {
                                    this.positionMicrosec = this.microsecPerByte * (double)posBytes;
                                }
                            }
                        }
                        if (!this.getPausedFlag()) continue;
                        Thread newPosBytes = this.thread;
                        synchronized (newPosBytes) {
                            try {
                                this.thread.wait(1000L);
                            }
                            catch (InterruptedException ex) {
                                Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    if (this.getClosedFlag()) {
                        this.sourceLine.drain();
                        this.sourceLine.stop();
                        this.sourceLine.close();
                    }
                    this.audioStream.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (UnsupportedAudioFileException ex) {
                    Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (this.getClosedFlag()) break;
                this.decreaseLoopCount();
                Object newPosBytes = this.playLock;
                synchronized (newPosBytes) {
                    currentLoopCount = this.loopCount;
                }
                if (currentLoopCount > 0) {
                    try {
                        this.reloadAudioStream();
                        continue;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex);
                        break block35;
                    }
                    catch (UnsupportedAudioFileException ex) {
                        Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex);
                        break block35;
                    }
                }
                this.setActiveFlag(false);
                this.firePlayingFinished();
                if (this.getClosedFlag()) {
                    this.sourceLine.drain();
                    this.sourceLine.stop();
                    this.sourceLine.close();
                    return;
                }
                Thread ex = this.thread;
                synchronized (ex) {
                    try {
                        this.thread.wait();
                    }
                    catch (InterruptedException ex2) {
                        return;
                    }
                }
                if (this.getClosedFlag()) {
                    return;
                }
                this.setActiveFlag(true);
                try {
                    this.reloadAudioStream();
                }
                catch (IOException ex2) {
                    Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex2);
                    break block35;
                }
                catch (UnsupportedAudioFileException ex3) {
                    Logger.getLogger(SoundTagPlayer.class.getName()).log(Level.SEVERE, null, ex3);
                    break block35;
                }
            }
            this.firePlayingFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play() {
        this.setPausedFlag(false);
        Thread thread = this.thread;
        synchronized (thread) {
            this.thread.notifyAll();
        }
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public void rewind() {
        this.gotoFrame(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPlaying() {
        Object object = this.playLock;
        synchronized (object) {
            return this.active && !this.paused && !this.closed;
        }
    }

    @Override
    public boolean loopAvailable() {
        return true;
    }

    @Override
    public boolean screenAvailable() {
        return false;
    }

    @Override
    public void zoom(Zoom zoom) {
    }

    @Override
    public boolean zoomAvailable() {
        return false;
    }

    @Override
    public double getZoomToFit() {
        return 1.0;
    }

    @Override
    public Zoom getZoom() {
        return null;
    }

    public SoundTag getTag() {
        return this.tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoop(boolean loop) {
        Object object = this.playLock;
        synchronized (object) {
            this.loopCount = loop ? Integer.MAX_VALUE : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotoFrame(int frame) {
        Object object = this.playLock;
        synchronized (object) {
            this.newPositionMicrosec = frame * 8000;
            this.positionMicrosec = this.newPositionMicrosec.longValue();
        }
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public float getFrameRate() {
        return 125.0f;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public BufferedImage printScreen() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseLoopCount() {
        Object object = this.playLock;
        synchronized (object) {
            if (this.loopCount > 0 && this.loopCount != Integer.MAX_VALUE) {
                --this.loopCount;
            }
        }
    }

    @Override
    public Color getBackgroundColor() {
        return Color.white;
    }

    @Override
    public void setDisplayed(boolean value) {
    }

    @Override
    public void setFrozen(boolean value) {
    }

    @Override
    public boolean isDisplayed() {
        return true;
    }

    @Override
    public boolean alwaysDisplay() {
        return true;
    }

    @Override
    public void setMuted(boolean value) {
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void clearGuides() {
    }
}

