/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.ConstructSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallSuperIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.executing.CallSuperVoidIns;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AbcIndexing;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.action.deobfuscation.BrokenScriptDetector;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.abc.ABCPanel;
import com.jpexs.decompiler.flash.gui.abc.MethodCodePanel;
import com.jpexs.decompiler.flash.gui.editor.DebuggableEditorPane;
import com.jpexs.decompiler.flash.gui.editor.VariableMarker;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightingList;
import com.jpexs.decompiler.flash.simpleparser.LinkType;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.Reference;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;

public class DecompiledEditorPane
extends DebuggableEditorPane
implements CaretListener {
    private static final Logger logger = Logger.getLogger(DecompiledEditorPane.class.getName());
    private HighlightedText highlightedText = HighlightedText.EMPTY;
    private Highlighting currentMethodHighlight;
    private Highlighting currentTraitHighlight;
    private ScriptPack script;
    public int lastTraitIndex = -4;
    public boolean ignoreCaret = false;
    private boolean reset = false;
    private final ABCPanel abcPanel;
    private int classIndex = -1;
    private boolean isStatic = false;
    private CancellableWorker setSourceWorker;
    private final List<Runnable> scriptListeners = new ArrayList<Runnable>();
    private boolean scriptLoaded = true;

    public synchronized boolean isScriptLoaded() {
        return this.scriptLoaded;
    }

    public void addScriptListener(Runnable l) {
        this.scriptListeners.add(l);
    }

    public void runWhenLoaded(final Runnable l) {
        if (this.scriptLoaded) {
            l.run();
        } else {
            this.addScriptListener(new Runnable(){

                @Override
                public void run() {
                    l.run();
                    DecompiledEditorPane.this.removeScriptListener(this);
                }
            });
        }
    }

    public ABCPanel getAbcPanel() {
        return this.abcPanel;
    }

    public void removeScriptListener(Runnable l) {
        this.scriptListeners.remove(l);
    }

    public void fireScript() {
        Runnable[] listeners;
        for (Runnable scriptListener : listeners = this.scriptListeners.toArray(new Runnable[this.scriptListeners.size()])) {
            scriptListener.run();
        }
    }

    public Trait getCurrentTrait() {
        if (this.lastTraitIndex < 0) {
            return null;
        }
        if (this.classIndex == -1) {
            return (Trait)((ScriptInfo)this.script.abc.script_info.get((int)this.script.scriptIndex)).traits.traits.get(this.lastTraitIndex);
        }
        return this.script.abc.findTraitByTraitId(this.classIndex, this.lastTraitIndex);
    }

    public synchronized ScriptPack getScriptLeaf() {
        return this.script;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public void setNoTrait() {
        this.abcPanel.detailPanel.showCard("abc.detail.unsupported", null, 0, null);
    }

    public void hilightSpecial(HighlightSpecialType type, long index) {
        int endPos;
        int startPos;
        if (this.currentMethodHighlight == null) {
            if (this.currentTraitHighlight == null) {
                return;
            }
            startPos = this.currentTraitHighlight.startPos;
            endPos = this.currentTraitHighlight.startPos + this.currentTraitHighlight.len;
        } else {
            startPos = this.currentMethodHighlight.startPos;
            endPos = this.currentMethodHighlight.startPos + this.currentMethodHighlight.len;
        }
        ArrayList<Highlighting> allh = new ArrayList<Highlighting>();
        for (Highlighting h : this.highlightedText.getTraitHighlights()) {
            if (h.getProperties().index != (long)this.lastTraitIndex) continue;
            for (Highlighting sh : this.highlightedText.getSpecialHighlights()) {
                if (sh.startPos < h.startPos || sh.startPos + sh.len >= h.startPos + h.len) continue;
                allh.add(sh);
            }
        }
        if (this.currentMethodHighlight != null) {
            for (Highlighting h : this.highlightedText.getSpecialHighlights()) {
                if (h.startPos < startPos || h.startPos + h.len >= endPos) continue;
                allh.add(h);
            }
        }
        for (Highlighting h : allh) {
            if (!h.getProperties().subtype.equals((Object)type) || h.getProperties().index != index) continue;
            this.ignoreCaret = true;
            if (h.startPos <= this.getDocument().getLength()) {
                this.setCaretPosition(h.startPos);
            }
            this.getCaret().setVisible(true);
            this.ignoreCaret = false;
            break;
        }
    }

    public void hilightOffset(long offset) {
        if (this.currentMethodHighlight == null) {
            return;
        }
        Highlighting h2 = Highlighting.searchOffset((HighlightingList)this.highlightedText.getInstructionHighlights(), (long)offset, (long)this.currentMethodHighlight.startPos, (long)(this.currentMethodHighlight.startPos + this.currentMethodHighlight.len));
        if (h2 != null) {
            this.ignoreCaret = true;
            if (h2.startPos <= this.getDocument().getLength()) {
                this.setCaretPosition(h2.startPos);
            }
            this.getCaret().setVisible(true);
            this.ignoreCaret = false;
        }
    }

    public void setClassIndex(int classIndex) {
        this.classIndex = classIndex;
    }

    private boolean displayMethod(int pos, int methodIndex, String name, Trait trait, int traitIndex, boolean isStatic) {
        Highlighting sh;
        ABC abc = this.getABC();
        if (abc == null) {
            return false;
        }
        int bi = abc.findBodyIndex(methodIndex);
        if (trait instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tm = (TraitMethodGetterSetter)trait;
            if (tm.method_info != methodIndex) {
                trait = null;
            }
        }
        if (trait instanceof TraitFunction) {
            TraitFunction tf = (TraitFunction)trait;
            if (tf.method_info != methodIndex) {
                trait = null;
            }
        }
        this.abcPanel.detailPanel.showCard("abc.detail.methodtrait", trait, traitIndex, abc);
        MethodCodePanel methodCodePanel = this.abcPanel.detailPanel.methodTraitPanel.methodCodePanel;
        if (this.reset || methodCodePanel.getMethodIndex() != methodIndex || methodCodePanel.getABC() != abc) {
            methodCodePanel.setMethod(this.scriptName, methodIndex, bi, abc, name, trait, this.script.scriptIndex);
            this.abcPanel.detailPanel.setEditMode(false);
            this.isStatic = isStatic;
        }
        boolean success = false;
        Highlighting h = Highlighting.searchPos((HighlightingList)this.highlightedText.getInstructionHighlights(), (long)pos);
        if (h != null) {
            methodCodePanel.hilightOffset(h.getProperties().offset);
            success = true;
        }
        if ((sh = Highlighting.searchPos((HighlightingList)this.highlightedText.getSpecialHighlights(), (long)pos)) != null) {
            methodCodePanel.hilighSpecial(sh.getProperties().subtype, sh.getProperties().specialValue);
            success = true;
        }
        return success;
    }

    public void displayClass(int classIndex, int scriptIndex, boolean hasScriptInitializer) {
        if (this.abcPanel.navigator.getClassIndex() != classIndex) {
            this.abcPanel.navigator.setClassIndex(classIndex, scriptIndex, hasScriptInitializer);
        }
    }

    public void resetEditing() {
        this.reset = true;
        this.caretUpdate(null);
        this.reset = false;
    }

    public int getMultinameUnderMouseCursor(Point pt, Reference<ABC> abcUsed) {
        return this.getMultinameAtPos(View.textComponentViewToModel((JTextComponent)this, pt), abcUsed);
    }

    public int getMultinameUnderCaret(Reference<ABC> abcUsed) {
        return this.getMultinameAtPos(this.getCaretPosition(), abcUsed);
    }

    public int getLocalDeclarationOfPos(int pos, Reference<DottedChain> type, Reference<LinkType> linkTypeRef) {
        Highlighting sh = Highlighting.searchPos((HighlightingList)this.highlightedText.getSpecialHighlights(), (long)pos);
        Highlighting h = Highlighting.searchPos((HighlightingList)this.highlightedText.getInstructionHighlights(), (long)pos);
        if (h == null) {
            linkTypeRef.setVal((Object)LinkType.NO_LINK);
            return -1;
        }
        HighlightingList tms = Highlighting.searchAllPos((HighlightingList)this.highlightedText.getMethodHighlights(), (long)pos);
        if (tms.isEmpty()) {
            linkTypeRef.setVal((Object)LinkType.NO_LINK);
            return -1;
        }
        for (Highlighting tm : tms) {
            HighlightingList tm_tms = Highlighting.searchAllIndexes((HighlightingList)this.highlightedText.getMethodHighlights(), (long)tm.getProperties().index);
            if (h.getProperties().declaration || sh != null && sh.getProperties().declaration) {
                linkTypeRef.setVal((Object)LinkType.NO_LINK);
                return -1;
            }
            String lname = h.getProperties().localName;
            if ("this".equals(lname)) {
                Highlighting ch = Highlighting.searchPos((HighlightingList)this.highlightedText.getClassHighlights(), (long)pos);
                int cindex = (int)ch.getProperties().index;
                ABC abc = this.getABC();
                type.setVal((Object)((InstanceInfo)abc.instance_info.get(cindex)).getName(abc.constants).getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, true));
                linkTypeRef.setVal((Object)LinkType.LINK_THIS_SCRIPT);
                return ch.startPos;
            }
            HighlightData hData = h.getProperties();
            HighlightData search = new HighlightData();
            search.declaration = hData.declaration;
            search.declaredType = hData.declaredType;
            search.localName = hData.localName;
            search.specialValue = hData.specialValue;
            if (search.isEmpty()) {
                linkTypeRef.setVal((Object)LinkType.NO_LINK);
                return -1;
            }
            search.declaration = true;
            for (Highlighting tm1 : tm_tms) {
                Highlighting rh = Highlighting.search((HighlightingList)this.highlightedText.getInstructionHighlights(), (HighlightData)search, (long)tm1.startPos, (long)(tm1.startPos + tm1.len));
                if (rh == null) {
                    rh = Highlighting.search((HighlightingList)this.highlightedText.getSpecialHighlights(), (HighlightData)search, (long)tm1.startPos, (long)(tm1.startPos + tm1.len));
                }
                if (rh == null) continue;
                type.setVal((Object)rh.getProperties().declaredType);
                linkTypeRef.setVal((Object)LinkType.LINK_OTHER_SCRIPT);
                return rh.startPos;
            }
        }
        linkTypeRef.setVal((Object)LinkType.NO_LINK);
        return -1;
    }

    public LinkType getPropertyTypeAtPos(AbcIndexing indexing, int pos, Reference<Integer> abcIndex, Reference<Integer> classIndex, Reference<Integer> traitIndex, Reference<Boolean> classTrait, Reference<Integer> multinameIndex, Reference<ABC> abcUsed, boolean currentSwfOnly, Reference<Integer> scriptIndexRef) {
        Token t;
        int m = this.getMultinameAtPos(pos, true, abcUsed);
        if (indexing == null) {
            return LinkType.NO_LINK;
        }
        SyntaxDocument sd = (SyntaxDocument)this.getDocument();
        Token lastToken = t = VariableMarker.getIdentifierTokenAt(sd, pos);
        String propName = t.getString((Document)sd);
        if (t.type != TokenType.IDENTIFIER && t.type != TokenType.KEYWORD && t.type != TokenType.REGEX) {
            return LinkType.NO_LINK;
        }
        Token prev = sd.getPrevToken(t);
        if (prev == null) {
            return LinkType.NO_LINK;
        }
        if (!".".equals(prev.getString((Document)sd))) {
            return LinkType.NO_LINK;
        }
        Highlighting sh = Highlighting.search((HighlightingList)this.highlightedText.getSpecialHighlights(), (HighlightData)new HighlightData(), (long)prev.start, (long)prev.start);
        if (sh == null) {
            return LinkType.NO_LINK;
        }
        HighlightData data = sh.getProperties();
        String parentType = data.propertyType;
        if (parentType.equals("*")) {
            return LinkType.NO_LINK;
        }
        Reference foundStatic = new Reference(null);
        AbcIndexing.TraitIndex propertyTraitIndex = indexing.findProperty(new AbcIndexing.PropertyDef(propName, (GraphTargetItem)new TypeItem(parentType), this.getABC(), data.namespaceIndex), true, !data.isStatic, true, foundStatic);
        if (propertyTraitIndex == null) {
            return LinkType.NO_LINK;
        }
        scriptIndexRef.setVal((Object)propertyTraitIndex.scriptIndex);
        List abcs = this.getABC().getSwf().getAbcList();
        int index = 0;
        boolean isCurrentSwf = false;
        for (ABCContainerTag cnt : abcs) {
            if (cnt.getABC() == propertyTraitIndex.abc) {
                abcIndex.setVal((Object)index);
                isCurrentSwf = true;
                break;
            }
            ++index;
        }
        if (currentSwfOnly && !isCurrentSwf) {
            return LinkType.NO_LINK;
        }
        abcUsed.setVal((Object)propertyTraitIndex.abc);
        index = propertyTraitIndex.abc.findClassByName(propertyTraitIndex.objType.toString());
        if (index == -1) {
            return LinkType.NO_LINK;
        }
        classIndex.setVal((Object)index);
        classTrait.setVal(foundStatic.getVal());
        Traits ts = (Boolean)foundStatic.getVal() != false ? ((ClassInfo)propertyTraitIndex.abc.class_info.get((int)index)).static_traits : ((InstanceInfo)propertyTraitIndex.abc.instance_info.get((int)index)).instance_traits;
        boolean found = false;
        for (int i = 0; i < ts.traits.size(); ++i) {
            if (ts.traits.get(i) != propertyTraitIndex.trait) continue;
            traitIndex.setVal((Object)i);
            found = true;
            break;
        }
        if (!found) {
            return LinkType.NO_LINK;
        }
        multinameIndex.setVal((Object)propertyTraitIndex.trait.name_index);
        return isCurrentSwf ? LinkType.LINK_OTHER_SCRIPT : LinkType.LINK_OTHER_FILE;
    }

    public int getMultinameAtPos(int pos, Reference<ABC> abcUsed) {
        return this.getMultinameAtPos(pos, false, abcUsed);
    }

    private int getMultinameAtPos(int pos, boolean codeOnly, Reference<ABC> abcUsed) {
        int multinameIndex = this._getMultinameAtPos(pos, codeOnly, abcUsed);
        if (multinameIndex > -1) {
            ABC abc = (ABC)abcUsed.getVal();
            multinameIndex = abc.constants.convertToQname(abc.constants, multinameIndex);
        }
        return multinameIndex;
    }

    public int _getMultinameAtPos(int pos, boolean codeOnly, Reference<ABC> abcUsed) {
        Highlighting sh;
        Highlighting th;
        Highlighting tm = Highlighting.searchPos((HighlightingList)this.highlightedText.getMethodHighlights(), (long)pos);
        Trait currentTrait = null;
        int currentMethod = -1;
        ABC abc = this.getABC();
        abcUsed.setVal((Object)abc);
        if (abc == null) {
            return -1;
        }
        if (tm != null) {
            int mi;
            currentMethod = mi = (int)tm.getProperties().index;
            int bi = abc.findBodyIndex(mi);
            Highlighting h = Highlighting.searchPos((HighlightingList)this.highlightedText.getInstructionHighlights(), (long)pos);
            if (h != null) {
                long highlightOffset = h.getProperties().offset;
                List list = ((MethodBody)abc.bodies.get((int)bi)).getCode().code;
                AVM2Instruction lastIns = null;
                AVM2Instruction selIns = null;
                for (AVM2Instruction ins : list) {
                    if (highlightOffset == ins.getAddress()) {
                        selIns = ins;
                        break;
                    }
                    if (ins.getAddress() > highlightOffset) {
                        selIns = lastIns;
                        break;
                    }
                    lastIns = ins;
                }
                if (selIns != null) {
                    if (!codeOnly && (selIns.definition instanceof ConstructSuperIns || selIns.definition instanceof CallSuperIns || selIns.definition instanceof CallSuperVoidIns)) {
                        int cindex;
                        Highlighting tc = Highlighting.searchPos((HighlightingList)this.highlightedText.getClassHighlights(), (long)pos);
                        if (tc != null && (cindex = (int)tc.getProperties().index) > -1) {
                            return ((InstanceInfo)abc.instance_info.get((int)cindex)).super_index;
                        }
                    } else {
                        for (int i = 0; i < selIns.definition.operands.length; ++i) {
                            if (selIns.definition.operands[i] != 257) continue;
                            return selIns.operands[i];
                        }
                    }
                }
            }
        }
        if (codeOnly) {
            return -1;
        }
        Highlighting ch = Highlighting.searchPos((HighlightingList)this.highlightedText.getClassHighlights(), (long)pos);
        if (ch != null && (th = Highlighting.searchPos((HighlightingList)this.highlightedText.getTraitHighlights(), (long)pos)) != null) {
            currentTrait = abc.findTraitByTraitId((int)ch.getProperties().index, (int)th.getProperties().index);
        }
        if (currentTrait instanceof TraitMethodGetterSetter) {
            currentMethod = ((TraitMethodGetterSetter)currentTrait).method_info;
        }
        if ((sh = Highlighting.searchPos((HighlightingList)this.highlightedText.getSpecialHighlights(), (long)pos)) != null) {
            switch (sh.getProperties().subtype) {
                case CLASS_NAME: 
                case TYPE_NAME: {
                    String typeName = sh.getProperties().specialValue;
                    for (int i = 1; i < abc.constants.getMultinameCount(); ++i) {
                        Multiname m = abc.constants.getMultiname(i);
                        if (m == null || !typeName.equals(m.getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, true).toRawString())) continue;
                        return i;
                    }
                    break;
                }
                case TRAIT_TYPE_NAME: {
                    if (!(currentTrait instanceof TraitSlotConst)) break;
                    TraitSlotConst ts = (TraitSlotConst)currentTrait;
                    return ts.type_index;
                }
                case TRAIT_NAME: {
                    if (currentTrait == null) break;
                    return currentTrait.name_index;
                }
                case RETURNS: {
                    if (currentMethod <= -1) break;
                    return ((MethodInfo)abc.method_info.get((int)currentMethod)).ret_type;
                }
                case PARAM: {
                    if (currentMethod <= -1) break;
                    return ((MethodInfo)abc.method_info.get((int)currentMethod)).param_types[(int)sh.getProperties().index];
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        ABC abc = this.getABC();
        if (abc == null) {
            return;
        }
        if (this.ignoreCaret) {
            return;
        }
        this.getCaret().setVisible(true);
        int pos = this.getCaretPosition();
        this.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.setIgnoreCaret(true);
        this.lastTraitIndex = -4;
        try {
            this.classIndex = -1;
            Highlighting cm = Highlighting.searchPos((HighlightingList)this.highlightedText.getClassHighlights(), (long)pos);
            if (cm != null) {
                this.classIndex = (int)cm.getProperties().index;
            }
            this.displayClass(this.classIndex, this.script.scriptIndex, this.script.isSimple || this.script.traitIndices.isEmpty());
            Highlighting tm = Highlighting.searchPos((HighlightingList)this.highlightedText.getMethodHighlights(), (long)pos);
            if (tm != null) {
                String name = "";
                if (this.classIndex > -1) {
                    name = ((InstanceInfo)abc.instance_info.get(this.classIndex)).getName(abc.constants).getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, true).toPrintableString(new LinkedHashSet(), abc.getSwf(), true);
                }
                Trait currentTrait = null;
                this.currentTraitHighlight = Highlighting.searchPos((HighlightingList)this.highlightedText.getTraitHighlights(), (long)pos);
                if (this.currentTraitHighlight != null) {
                    this.lastTraitIndex = (int)this.currentTraitHighlight.getProperties().index;
                    currentTrait = this.getCurrentTrait();
                    this.isStatic = abc.isStaticTraitId(this.classIndex, this.lastTraitIndex);
                    if (currentTrait != null) {
                        name = name + ":" + currentTrait.getName(abc).getName(new LinkedHashSet(), abc, abc.constants, null, false, true);
                    }
                    if (currentTrait instanceof TraitSlotConst) {
                        currentTrait = null;
                    }
                }
                this.displayMethod(pos, (int)tm.getProperties().index, name, currentTrait, this.lastTraitIndex, this.isStatic);
                this.currentMethodHighlight = tm;
                return;
            }
            if (this.classIndex == -1) {
                this.abcPanel.navigator.setClassIndex(-1, this.script.scriptIndex, this.script.isSimple || this.script.traitIndices.isEmpty());
            }
            this.currentTraitHighlight = Highlighting.searchPos((HighlightingList)this.highlightedText.getTraitHighlights(), (long)pos);
            if (this.currentTraitHighlight != null) {
                this.lastTraitIndex = (int)this.currentTraitHighlight.getProperties().index;
                Trait currentTrait = this.getCurrentTrait();
                if (currentTrait != null) {
                    if (currentTrait instanceof TraitClass) {
                        this.abcPanel.detailPanel.classTraitPanel.load((TraitClass)currentTrait, abc, true);
                        Trait ftrait = currentTrait;
                        int ftraitIndex = this.lastTraitIndex;
                        View.execInEventDispatch(() -> this.abcPanel.detailPanel.showCard("abc.detail.classtrait", ftrait, ftraitIndex, abc));
                        this.abcPanel.detailPanel.setEditMode(false);
                        this.currentMethodHighlight = null;
                        Highlighting spec = Highlighting.searchPos((HighlightingList)this.highlightedText.getSpecialHighlights(), (long)pos, (long)this.currentTraitHighlight.startPos, (long)(this.currentTraitHighlight.startPos + this.currentTraitHighlight.len));
                        if (spec != null) {
                            this.abcPanel.detailPanel.classTraitPanel.hilightSpecial(spec);
                        }
                        return;
                    }
                    if (currentTrait instanceof TraitSlotConst) {
                        this.abcPanel.detailPanel.slotConstTraitPanel.load((TraitSlotConst)currentTrait, abc, abc.isStaticTraitId(this.classIndex, this.lastTraitIndex));
                        Trait ftrait = currentTrait;
                        int ftraitIndex = this.lastTraitIndex;
                        View.execInEventDispatch(() -> this.abcPanel.detailPanel.showCard("abc.detail.slotconsttrait", ftrait, ftraitIndex, abc));
                        this.abcPanel.detailPanel.setEditMode(false);
                        this.currentMethodHighlight = null;
                        Highlighting spec = Highlighting.searchPos((HighlightingList)this.highlightedText.getSpecialHighlights(), (long)pos, (long)this.currentTraitHighlight.startPos, (long)(this.currentTraitHighlight.startPos + this.currentTraitHighlight.len));
                        if (spec != null) {
                            this.abcPanel.detailPanel.slotConstTraitPanel.hilightSpecial(spec);
                        }
                        return;
                    }
                }
                this.currentMethodHighlight = null;
                String name = this.classIndex == -1 ? "" : ((InstanceInfo)abc.instance_info.get(this.classIndex)).getName(abc.constants).getNameWithNamespace(new LinkedHashSet(), abc, abc.constants, true).toPrintableString(new LinkedHashSet(), abc.getSwf(), true);
                currentTrait = this.getCurrentTrait();
                this.isStatic = abc.isStaticTraitId(this.classIndex, this.lastTraitIndex);
                if (currentTrait != null) {
                    if (!name.isEmpty()) {
                        name = name + ":";
                    }
                    name = name + currentTrait.getName(abc).getName(new LinkedHashSet(), abc, abc.constants, null, false, true);
                }
                int methodId = this.classIndex > -1 ? abc.findMethodIdByTraitId(this.classIndex, this.lastTraitIndex) : ((TraitMethodGetterSetter)((ScriptInfo)abc.script_info.get((int)this.script.scriptIndex)).traits.traits.get((int)this.lastTraitIndex)).method_info;
                this.displayMethod(pos, methodId, name, currentTrait, this.lastTraitIndex, this.isStatic);
                return;
            }
            this.setNoTrait();
        }
        finally {
            this.abcPanel.detailPanel.methodTraitPanel.methodCodePanel.setIgnoreCaret(false);
        }
    }

    public void gotoLastTrait() {
        this.gotoTrait(this.lastTraitIndex);
    }

    public void gotoLastMethod() {
        if (this.currentMethodHighlight != null) {
            final int fpos = this.currentMethodHighlight.startPos;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (fpos <= DecompiledEditorPane.this.getDocument().getLength()) {
                        DecompiledEditorPane.this.setCaretPosition(fpos);
                    }
                }
            }, 100L);
        }
    }

    public void gotoClassHeader() {
        Highlighting tc = Highlighting.searchIndex((HighlightingList)this.highlightedText.getClassHighlights(), (long)this.classIndex);
        if (tc != null) {
            final int fpos = tc.startPos;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (fpos <= DecompiledEditorPane.this.getDocument().getLength()) {
                        DecompiledEditorPane.this.setCaretPosition(fpos);
                    }
                }
            }, 100L);
        }
    }

    public void gotoMethod(int methodId) {
        this.gotoMethod(methodId, null);
    }

    public void gotoMethod(int methodId, final Runnable afterHandler) {
        Highlighting tm = Highlighting.searchIndex((HighlightingList)this.highlightedText.getMethodHighlights(), (long)methodId);
        if (tm != null) {
            int pos = 0;
            if (tm.len > 1) {
                this.ignoreCaret = true;
                int startPos = tm.startPos + tm.len - 1;
                if (startPos <= this.getDocument().getLength()) {
                    this.setCaretPosition(startPos);
                }
                this.ignoreCaret = false;
            }
            final int fpos = pos = tm.startPos;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (fpos <= DecompiledEditorPane.this.getDocument().getLength()) {
                        DecompiledEditorPane.this.setCaretPosition(fpos);
                    }
                    if (afterHandler != null) {
                        afterHandler.run();
                    }
                }
            }, 100L);
        }
    }

    public void gotoTrait(int traitId) {
        boolean isScriptInit = traitId == -3;
        Highlighting tc = Highlighting.searchIndex((HighlightingList)this.highlightedText.getClassHighlights(), (long)this.classIndex);
        if (!isScriptInit && tc == null) {
            HighlightingList traitHighlights = this.highlightedText.getTraitHighlights();
            HighlightingList classHighlights = this.highlightedText.getClassHighlights();
            block0: for (Highlighting th : traitHighlights) {
                if (th.getProperties().index != (long)traitId) continue;
                for (Highlighting tc2 : classHighlights) {
                    if (tc2.startPos > th.startPos || tc2.startPos + tc2.len < th.startPos + th.len) continue;
                    continue block0;
                }
                final int fpos = th.startPos + 1;
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (fpos <= DecompiledEditorPane.this.getDocument().getLength()) {
                            DecompiledEditorPane.this.setCaretPosition(fpos);
                        }
                    }
                }, 100L);
                break;
            }
        }
        if (tc != null || isScriptInit) {
            Highlighting th = Highlighting.searchIndex((HighlightingList)this.highlightedText.getTraitHighlights(), (long)traitId, (long)(isScriptInit ? 0L : (long)tc.startPos), (long)(isScriptInit ? -1L : (long)(tc.startPos + tc.len)));
            int pos = 0;
            if (th != null) {
                if (th.len > 1) {
                    this.ignoreCaret = true;
                    int startPos = th.startPos + th.len - 1;
                    if (startPos <= this.getDocument().getLength()) {
                        this.setCaretPosition(startPos);
                    }
                    this.ignoreCaret = false;
                }
                pos = th.startPos;
            } else if (tc != null) {
                pos = tc.startPos;
            }
            final int fpos = pos;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    if (fpos <= DecompiledEditorPane.this.getDocument().getLength()) {
                        DecompiledEditorPane.this.setCaretPosition(fpos);
                    }
                }
            }, 100L);
        }
    }

    public DecompiledEditorPane(ABCPanel abcPanel) {
        this.setEditable(false);
        this.getCaret().setVisible(true);
        this.addCaretListener(this);
        this.abcPanel = abcPanel;
    }

    public synchronized void clearScript() {
        this.script = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScript(final ScriptPack scriptLeaf, boolean force) {
        boolean decompileNeeded;
        View.checkAccess();
        if (this.setSourceWorker != null) {
            this.setSourceWorker.cancel(true);
            this.setSourceWorker = null;
        }
        DecompiledEditorPane decompiledEditorPane = this;
        synchronized (decompiledEditorPane) {
            this.scriptLoaded = false;
        }
        if (!force && this.script == scriptLeaf) {
            decompiledEditorPane = this;
            synchronized (decompiledEditorPane) {
                this.scriptLoaded = true;
            }
            this.fireScript();
            return;
        }
        String sn = scriptLeaf.getClassPath().toString();
        this.setScriptName(sn, sn);
        this.abcPanel.scriptNameLabel.setText(sn);
        int scriptIndex = scriptLeaf.scriptIndex;
        ScriptInfo nscript = null;
        ABC abc = scriptLeaf.abc;
        if (scriptIndex > -1) {
            nscript = (ScriptInfo)abc.script_info.get(scriptIndex);
        }
        if (nscript == null) {
            this.highlightedText = HighlightedText.EMPTY;
            return;
        }
        HighlightedText decompiledText = SWF.getFromCache((ScriptPack)scriptLeaf);
        boolean bl = decompileNeeded = decompiledText == null;
        if (decompileNeeded) {
            CancellableWorker worker = new CancellableWorker("abc.decompiledEditorPane"){

                protected Void doInBackground() throws Exception {
                    if (decompileNeeded) {
                        DecompiledEditorPane.this.setShowMarkers(false);
                        View.execInEventDispatch(() -> DecompiledEditorPane.this.setText("// " + AppStrings.translate("work.decompiling") + "..."));
                        HighlightedText htext = SWF.getCached((ScriptPack)scriptLeaf);
                        DecompiledEditorPane.this.setShowMarkers(true);
                        View.execInEventDispatch(() -> DecompiledEditorPane.this.setSourceCompleted(scriptLeaf, htext));
                    }
                    return null;
                }

                protected void done() {
                    View.execInEventDispatch(() -> {
                        DecompiledEditorPane.this.setSourceWorker = null;
                        if (!Main.isDebugging()) {
                            Main.stopWork();
                        }
                        try {
                            this.get();
                        }
                        catch (CancellationException ex) {
                            DecompiledEditorPane.this.setShowMarkers(false);
                            DecompiledEditorPane.this.setText("// " + AppStrings.translate("work.canceled"));
                        }
                        catch (Exception ex) {
                            Throwable cause = ex;
                            if (ex instanceof ExecutionException) {
                                cause = ex.getCause();
                            }
                            DecompiledEditorPane.this.setShowMarkers(false);
                            if (cause instanceof CancellationException) {
                                DecompiledEditorPane.this.setText("// " + AppStrings.translate("work.canceled"));
                            }
                            logger.log(Level.SEVERE, "Error", cause);
                            DecompiledEditorPane.this.setText("// " + AppStrings.translate("decompilationError") + ": " + cause);
                        }
                    });
                }
            };
            worker.execute();
            this.setSourceWorker = worker;
            if (!Main.isDebugging()) {
                Main.startWork(AppStrings.translate("work.decompiling") + "...", worker);
            }
        } else {
            this.setShowMarkers(true);
            this.setSourceCompleted(scriptLeaf, decompiledText);
        }
    }

    private synchronized void setSourceCompleted(ScriptPack scriptLeaf, HighlightedText decompiledText) {
        View.checkAccess();
        if (decompiledText == null) {
            decompiledText = HighlightedText.EMPTY;
        }
        this.script = scriptLeaf;
        this.highlightedText = decompiledText;
        if (decompiledText != null) {
            BrokenScriptDetector det = new BrokenScriptDetector();
            String hilightedCode = decompiledText.text;
            if (det.codeIsBroken(hilightedCode)) {
                this.abcPanel.brokenHintPanel.setVisible(true);
            } else {
                this.abcPanel.brokenHintPanel.setVisible(false);
            }
            this.setText(hilightedCode);
            if (this.highlightedText.getClassHighlights().size() > 0) {
                try {
                    int pos = ((Highlighting)this.highlightedText.getClassHighlights().get((int)0)).startPos + 1;
                    this.setCaretPosition(pos);
                    this.caretUpdate(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.scriptLoaded = true;
        this.fireScript();
    }

    public void reloadClass() {
        View.checkAccess();
        int ci = this.classIndex;
        SWF.uncache((ScriptPack)this.script);
        if (this.script != null && this.getABC() != null) {
            this.setScript(this.script, true);
        }
        this.setNoTrait();
        this.setClassIndex(ci);
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public int getScriptIndex() {
        ScriptPack pack = this.getScriptLeaf();
        if (pack == null) {
            return -1;
        }
        return pack.scriptIndex;
    }

    private ABC getABC() {
        return this.script == null ? null : this.script.abc;
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        this.setCaretPosition(0);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.abcPanel.getDebugPanel().localsTable == null) {
            return super.getToolTipText();
        }
        Point point = new Point(e.getX(), e.getY());
        int pos = View.textComponentViewToModel((JTextComponent)this.abcPanel.decompiledTextArea, point);
        String identifier = this.abcPanel.getMainPanel().getActionPanel().getStringUnderPosition(pos, this.abcPanel.decompiledTextArea);
        if (identifier != null && !identifier.isEmpty()) {
            String tooltipText = this.abcPanel.getDebugPanel().localsTable.tryGetDebugHoverToolTipText(identifier);
            return tooltipText == null ? super.getToolTipText() : tooltipText;
        }
        return super.getToolTipText();
    }

    public synchronized void setCaretPositionForCurrentScript(int position, ScriptPack expectedScript) {
        if (expectedScript != this.script) {
            return;
        }
        if (!this.scriptLoaded) {
            return;
        }
        this.setCaretPosition(position);
    }

    @Override
    public void setCaretPosition(int position) {
        super.setCaretPosition(position);
    }
}

