/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.search.ABCSearchResult;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TraitsListItem {
    private final TraitType type;
    private final boolean isStatic;
    private final ABC abc;
    private final int classIndex;
    private final int index;
    private final int scriptIndex;
    public static String STR_INSTANCE_INITIALIZER = ABCSearchResult.STR_INSTANCE_INITIALIZER;
    public static String STR_CLASS_INITIALIZER = ABCSearchResult.STR_CLASS_INITIALIZER;
    public static String STR_SCRIPT_INITIALIZER = ABCSearchResult.STR_SCRIPT_INITIALIZER;

    public TraitsListItem(TraitType type, int index, boolean isStatic, ABC abc, int classIndex, int scriptIndex) {
        this.type = type;
        this.index = index;
        this.isStatic = isStatic;
        this.abc = abc;
        this.classIndex = classIndex;
        this.scriptIndex = scriptIndex;
    }

    public int getGlobalTraitId() {
        return this.abc.getGlobalTraitId(this.type, this.isStatic, this.classIndex, this.index);
    }

    public String toStringName() {
        if (this.type == TraitType.INITIALIZER) {
            if (!this.isStatic) {
                return "__" + STR_INSTANCE_INITIALIZER;
            }
            return "__" + STR_CLASS_INITIALIZER;
        }
        if (this.type == TraitType.SCRIPT_INITIALIZER) {
            return "__" + STR_SCRIPT_INITIALIZER;
        }
        if (this.isStatic) {
            return ((Trait)((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits.get(this.index)).getName(this.abc).getName(new LinkedHashSet(), this.abc, this.abc.constants, null, false, true);
        }
        return ((Trait)((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits.get(this.index)).getName(this.abc).getName(new LinkedHashSet(), this.abc, this.abc.constants, null, false, true);
    }

    public String toString() {
        String s = "";
        try {
            if (this.type == TraitType.SCRIPT_INITIALIZER) {
                s = STR_SCRIPT_INITIALIZER;
            } else if (this.type == TraitType.INITIALIZER) {
                s = !this.isStatic ? STR_INSTANCE_INITIALIZER : STR_CLASS_INITIALIZER;
            } else if (this.isStatic) {
                ConvertData convertData = new ConvertData();
                List traits = ((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits;
                if (this.index >= traits.size()) {
                    return "";
                }
                Trait trait = (Trait)traits.get(this.index);
                trait.convertHeader(new LinkedHashSet(), -1, null, convertData, "", this.abc, true, ScriptExportMode.AS, this.scriptIndex, this.classIndex, new NulWriter(), new ArrayList(), false);
                HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
                boolean insideInterface = false;
                if (this.classIndex > -1) {
                    insideInterface = ((InstanceInfo)this.abc.instance_info.get(this.classIndex)).isInterface();
                }
                trait.toStringHeader(new LinkedHashSet(), -1, null, DottedChain.EMPTY, convertData, "", this.abc, true, ScriptExportMode.AS, this.scriptIndex, this.classIndex, (GraphTextWriter)writer, new ArrayList(), false, insideInterface);
                writer.finishHilights();
                s = writer.toString();
            } else {
                ConvertData convertData = new ConvertData();
                List traits = ((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits;
                if (this.index >= traits.size()) {
                    return "";
                }
                Trait trait = (Trait)traits.get(this.index);
                trait.convertHeader(new LinkedHashSet(), -1, null, convertData, "", this.abc, false, ScriptExportMode.AS, this.scriptIndex, this.classIndex, new NulWriter(), new ArrayList(), false);
                HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), false);
                boolean insideInterface = false;
                if (this.classIndex > -1) {
                    insideInterface = ((InstanceInfo)this.abc.instance_info.get(this.classIndex)).isInterface();
                }
                trait.toStringHeader(new LinkedHashSet(), -1, null, DottedChain.EMPTY, convertData, "", this.abc, false, ScriptExportMode.AS, this.scriptIndex, this.classIndex, (GraphTextWriter)writer, new ArrayList(), false, insideInterface);
                writer.finishHilights();
                s = writer.toString();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(TraitsListItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        s = s.replaceAll("[ \r\n]+", " ");
        return s;
    }

    public TraitType getType() {
        return this.type;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public int getIndex() {
        return this.index;
    }
}

