/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitType;
import com.jpexs.decompiler.flash.gui.abc.TraitsListItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public final class TraitsListModel
implements ListModel<Object> {
    private List<TraitsListItem> items;
    private final ABC abc;
    private final int classIndex;
    private final int scriptIndex;
    private final boolean hasScriptInitializer;

    public void setSorted(boolean sorted) {
        if (sorted) {
            Collections.sort(this.items, new Comparator<TraitsListItem>(){

                @Override
                public int compare(TraitsListItem o1, TraitsListItem o2) {
                    return o1.toStringName().compareTo(o2.toStringName());
                }
            });
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.items = new ArrayList<TraitsListItem>();
        if (this.classIndex > -1) {
            Trait trait;
            int t;
            List traits = ((ClassInfo)this.abc.class_info.get((int)this.classIndex)).static_traits.traits;
            for (t = 0; t < traits.size(); ++t) {
                trait = (Trait)traits.get(t);
                if (!trait.isVisible(true, this.abc)) continue;
                this.items.add(new TraitsListItem(TraitType.getTypeForTrait((Trait)trait), t, true, this.abc, this.classIndex, this.scriptIndex));
            }
            traits = ((InstanceInfo)this.abc.instance_info.get((int)this.classIndex)).instance_traits.traits;
            for (t = 0; t < traits.size(); ++t) {
                trait = (Trait)traits.get(t);
                if (!trait.isVisible(false, this.abc)) continue;
                this.items.add(new TraitsListItem(TraitType.getTypeForTrait((Trait)trait), t, false, this.abc, this.classIndex, this.scriptIndex));
            }
            this.items.add(new TraitsListItem(TraitType.INITIALIZER, 0, false, this.abc, this.classIndex, this.scriptIndex));
            this.items.add(new TraitsListItem(TraitType.INITIALIZER, 0, true, this.abc, this.classIndex, this.scriptIndex));
        }
        if (this.hasScriptInitializer) {
            this.items.add(new TraitsListItem(TraitType.SCRIPT_INITIALIZER, 0, true, this.abc, this.classIndex, this.scriptIndex));
        }
    }

    public TraitsListModel(ABC abc, int classIndex, int scriptIndex, boolean sorted, boolean hasScriptInitializer) {
        this.abc = abc;
        this.classIndex = classIndex;
        this.scriptIndex = scriptIndex;
        this.hasScriptInitializer = hasScriptInitializer;
        this.reset();
        if (sorted) {
            this.setSorted(true);
        }
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

