/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.abc.tablemodels;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.graph.DottedChain;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class NamespaceTableModel
implements TableModel {
    private final ABC abc;
    private static final String[] columnNames = new String[]{"Index", "Kind", "Name"};
    private static final Class[] classes = new Class[]{Long.class, String.class, String.class};

    public NamespaceTableModel(ABC abc) {
        this.abc = abc;
    }

    @Override
    public int getRowCount() {
        if (this.abc == null) {
            return 0;
        }
        return this.abc.constants.getNamespaceCount();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return classes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return rowIndex;
            }
            case 1: {
                if (rowIndex == 0) {
                    return "-";
                }
                return this.abc.constants.getNamespace(rowIndex).getKindStr();
            }
            case 2: {
                if (rowIndex == 0) {
                    return "-";
                }
                DottedChain chain = this.abc.constants.getNamespace(rowIndex).getName(this.abc.constants);
                if (chain == null) {
                    return "-";
                }
                return chain.toRawString();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

