/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.dumpview;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCInputStream;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionListReader;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecial;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSwfNode;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.TreeNodeType;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.dumpview.DumpTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.TagTree;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.HasSwfAndTag;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class DumpTree
extends JTree {
    private static final Logger logger = Logger.getLogger(DumpTree.class.getName());
    private final MainPanel mainPanel;

    public DumpTree(DumpTreeModel treeModel, MainPanel mainPanel) {
        super(treeModel);
        this.mainPanel = mainPanel;
        this.setCellRenderer(new DumpTreeCellRenderer());
        this.setRootVisible(false);
        if (View.isOceanic()) {
            this.setBackground(Color.white);
            this.setUI(new BasicTreeUI(){
                {
                    this.setHashColor(Color.gray);
                }
            });
        }
    }

    public void createContextMenu() {
        final JPopupMenu contextPopupMenu = new JPopupMenu();
        final JMenuItem expandRecursiveMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.expandAll"));
        expandRecursiveMenuItem.addActionListener(this::expandRecursiveButtonActionPerformed);
        expandRecursiveMenuItem.setIcon(View.getIcon("expand16"));
        contextPopupMenu.add(expandRecursiveMenuItem);
        final JMenuItem saveToFileMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.saveToFile"));
        saveToFileMenuItem.addActionListener(this::saveToFileButtonActionPerformed);
        saveToFileMenuItem.setIcon(View.getIcon("saveas16"));
        contextPopupMenu.add(saveToFileMenuItem);
        final JMenuItem saveUncompressedToFileMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.saveUncompressedToFile"));
        saveUncompressedToFileMenuItem.addActionListener(this::saveUncompressedToFileButtonActionPerformed);
        saveUncompressedToFileMenuItem.setIcon(View.getIcon("saveas16"));
        contextPopupMenu.add(saveUncompressedToFileMenuItem);
        final JMenuItem closeSelectionMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.closeSwf"));
        closeSelectionMenuItem.addActionListener(this::closeSwfButtonActionPerformed);
        closeSelectionMenuItem.setIcon(View.getIcon("close16"));
        contextPopupMenu.add(closeSelectionMenuItem);
        final JMenuItem parseActionsMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.parseActions"));
        parseActionsMenuItem.addActionListener(this::parseActionsButtonActionPerformed);
        parseActionsMenuItem.setIcon(View.getIcon("parse16"));
        contextPopupMenu.add(parseActionsMenuItem);
        final JMenuItem parseAbcMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.parseABC"));
        parseAbcMenuItem.addActionListener(this::parseAbcButtonActionPerformed);
        parseAbcMenuItem.setIcon(View.getIcon("parse16"));
        contextPopupMenu.add(parseAbcMenuItem);
        final JMenuItem parseInstructionsMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.parseInstructions"));
        parseInstructionsMenuItem.addActionListener(this::parseInstructionsButtonActionPerformed);
        parseInstructionsMenuItem.setIcon(View.getIcon("parse16"));
        contextPopupMenu.add(parseInstructionsMenuItem);
        final JMenuItem showInResourcesTagMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.showInResources"));
        showInResourcesTagMenuItem.addActionListener(this::showInResourcesTagButtonActionPerformed);
        showInResourcesTagMenuItem.setIcon(View.getIcon("folder16"));
        contextPopupMenu.add(showInResourcesTagMenuItem);
        final JMenuItem showInTagListTagMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.showInTagList"));
        showInTagListTagMenuItem.addActionListener(this::showInTagListTagButtonActionPerformed);
        showInTagListTagMenuItem.setIcon(View.getIcon("taglist16"));
        contextPopupMenu.add(showInTagListTagMenuItem);
        final JMenuItem gotoActionListMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.showInResources"));
        gotoActionListMenuItem.addActionListener(this::gotoActionListButtonActionPerformed);
        gotoActionListMenuItem.setIcon(View.getIcon("folder16"));
        contextPopupMenu.add(gotoActionListMenuItem);
        final JMenuItem gotoMethodMenuItem = new JMenuItem(this.mainPanel.translate("contextmenu.showInResources"));
        gotoMethodMenuItem.addActionListener(this::gotoMethodButtonActionPerformed);
        gotoMethodMenuItem.setIcon(View.getIcon("folder16"));
        contextPopupMenu.add(gotoMethodMenuItem);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    TreePath[] paths;
                    int row = DumpTree.this.getClosestRowForLocation(e.getX(), e.getY());
                    int[] selectionRows = DumpTree.this.getSelectionRows();
                    if (!Helper.contains((int[])selectionRows, (int)row)) {
                        DumpTree.this.setSelectionRow(row);
                    }
                    if ((paths = DumpTree.this.getSelectionPaths()) == null || paths.length == 0) {
                        return;
                    }
                    closeSelectionMenuItem.setVisible(false);
                    expandRecursiveMenuItem.setVisible(false);
                    saveToFileMenuItem.setVisible(false);
                    saveUncompressedToFileMenuItem.setVisible(false);
                    parseActionsMenuItem.setVisible(false);
                    parseAbcMenuItem.setVisible(false);
                    parseInstructionsMenuItem.setVisible(false);
                    showInResourcesTagMenuItem.setVisible(false);
                    showInTagListTagMenuItem.setVisible(false);
                    gotoActionListMenuItem.setVisible(false);
                    gotoMethodMenuItem.setVisible(false);
                    if (paths.length == 1) {
                        boolean noChild;
                        DumpInfo treeNode = (DumpInfo)paths[0].getLastPathComponent();
                        DumpInfoSpecialType specialType = DumpTree.this.getSpecialType(treeNode);
                        if (treeNode instanceof DumpInfoSwfNode) {
                            closeSelectionMenuItem.setVisible(true);
                        }
                        if (treeNode.getEndByte() - treeNode.startByte > 3L) {
                            saveToFileMenuItem.setVisible(true);
                            if (specialType == DumpInfoSpecialType.ZLIB_DATA) {
                                saveUncompressedToFileMenuItem.setVisible(true);
                            }
                        }
                        boolean bl = noChild = treeNode.getChildCount() == 0;
                        if (noChild) {
                            switch (specialType) {
                                case ACTION_BYTES: {
                                    parseActionsMenuItem.setVisible(true);
                                    break;
                                }
                                case ABC_BYTES: {
                                    parseAbcMenuItem.setVisible(true);
                                    break;
                                }
                                case ABC_CODE: {
                                    parseInstructionsMenuItem.setVisible(true);
                                }
                            }
                        }
                        switch (specialType) {
                            case TAG: {
                                showInResourcesTagMenuItem.setVisible(true);
                                showInTagListTagMenuItem.setVisible(true);
                                break;
                            }
                            case ACTION_BYTES: {
                                gotoActionListMenuItem.setVisible(true);
                                break;
                            }
                            case ABC_CODE: 
                            case ABC_METHOD_BODY: {
                                gotoMethodMenuItem.setVisible(true);
                            }
                        }
                        DumpTreeModel model = DumpTree.this.getModel();
                        expandRecursiveMenuItem.setVisible(model.getChildCount(treeNode) > 0);
                    }
                    contextPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private DumpInfoSpecialType getSpecialType(DumpInfo dumpInfo) {
        DumpInfoSpecialType specialType = dumpInfo instanceof DumpInfoSpecial ? ((DumpInfoSpecial)dumpInfo).specialType : DumpInfoSpecialType.NONE;
        return specialType;
    }

    private void expandRecursiveButtonActionPerformed(ActionEvent evt) {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        View.expandTreeNodes(this, path, true);
    }

    private void saveUncompressedToFileButtonActionPerformed(ActionEvent evt) {
        this.saveToFileButtonActionPerformed(true);
    }

    private void saveToFileButtonActionPerformed(ActionEvent evt) {
        this.saveToFileButtonActionPerformed(false);
    }

    private void saveToFileButtonActionPerformed(boolean decompress) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        JFileChooser fc = new JFileChooser();
        String selDir = (String)Configuration.lastOpenDir.get();
        fc.setCurrentDirectory(new File(selDir));
        if (fc.showSaveDialog(this) == 0) {
            File sf = Helper.fixDialogFile((File)fc.getSelectedFile());
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(sf));){
                byte[] data = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf().originalUncompressedData;
                if (decompress) {
                    ((OutputStream)fos).write(SWFInputStream.uncompressByteArray((byte[])data, (int)((int)dumpInfo.startByte), (int)((int)(dumpInfo.getEndByte() - dumpInfo.startByte + 1L))));
                } else {
                    ((OutputStream)fos).write(data, (int)dumpInfo.startByte, (int)(dumpInfo.getEndByte() - dumpInfo.startByte + 1L));
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void parseActionsButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        byte[] data = swf.originalUncompressedData;
        int prevLength = (int)dumpInfo.startByte;
        try {
            SWFInputStream rri = new SWFInputStream(swf, data);
            if (prevLength != 0) {
                rri.seek((long)prevLength);
            }
            List actions = ActionListReader.getOriginalActions((SWFInputStream)rri, (int)prevLength, (int)((int)dumpInfo.getEndByte()));
            for (Action action : actions) {
                DumpInfo di = new DumpInfo(action.toString(), "Action", null, action.getAddress(), (long)action.getTotalActionLength());
                di.parent = dumpInfo;
                rri.dumpInfo = di;
                rri.seek(action.getAddress());
                rri.readAction();
                dumpInfo.getChildInfos().add(di);
            }
            this.repaint();
        }
        catch (IOException | InterruptedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void parseAbcButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        byte[] data = swf.originalUncompressedData;
        int prevLength = (int)dumpInfo.startByte;
        try {
            ABCInputStream ais = new ABCInputStream(new MemoryInputStream(data, 0, prevLength + (int)dumpInfo.lengthBytes));
            ais.seek((long)prevLength);
            ais.dumpInfo = dumpInfo;
            new ABC(ais, swf, null);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.repaint();
    }

    private void parseInstructionsButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfo dumpInfo = (DumpInfo)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        byte[] data = swf.originalUncompressedData;
        int prevLength = (int)dumpInfo.startByte;
        try {
            ABCInputStream ais = new ABCInputStream(new MemoryInputStream(data, 0, prevLength + (int)dumpInfo.lengthBytes));
            ais.seek((long)prevLength);
            ais.dumpInfo = dumpInfo;
            new AVM2Code(ais, null);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        this.repaint();
    }

    private Tag searchTimelinedForTag(Timelined timelined, long address) {
        for (Tag tag : timelined.getTags()) {
            Tag subSpriteFound;
            if ((long)tag.getOriginalRange().getPos() == address) {
                return tag;
            }
            if (!(tag instanceof DefineSpriteTag) || (subSpriteFound = this.searchTimelinedForTag((Timelined)((DefineSpriteTag)tag), address)) == null) continue;
            return subSpriteFound;
        }
        return null;
    }

    private void showInTagListTagButtonActionPerformed(ActionEvent evt) {
        long address;
        TreePath[] paths = this.getSelectionPaths();
        DumpInfoSpecial dumpInfo = (DumpInfoSpecial)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        Tag foundTag = this.searchTimelinedForTag((Timelined)swf, address = ((Long)dumpInfo.specialValue).longValue());
        if (foundTag != null) {
            this.mainPanel.getMainFrame().getMenu().showTagListView();
            this.mainPanel.setTagTreeSelectedNode(this.mainPanel.getCurrentTree(), (TreeItem)foundTag);
        }
    }

    private void showInResourcesTagButtonActionPerformed(ActionEvent evt) {
        long address;
        TreePath[] paths = this.getSelectionPaths();
        DumpInfoSpecial dumpInfo = (DumpInfoSpecial)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        Tag foundTag = this.searchTimelinedForTag((Timelined)swf, address = ((Long)dumpInfo.specialValue).longValue());
        if (foundTag != null) {
            this.mainPanel.getMainFrame().getMenu().showResourcesView();
            this.mainPanel.setTagTreeSelectedNode(this.mainPanel.getCurrentTree(), (TreeItem)foundTag);
        }
    }

    private void gotoActionListButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfoSpecial dumpInfo = (DumpInfoSpecial)paths[0].getLastPathComponent();
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        long address = (Long)dumpInfo.specialValue;
        this.mainPanel.getMainFrame().getMenu().showResourcesView();
    }

    private void gotoMethodButtonActionPerformed(ActionEvent evt) {
        TreePath[] paths = this.getSelectionPaths();
        DumpInfoSpecial dumpInfo = (DumpInfoSpecial)paths[0].getLastPathComponent();
        if (dumpInfo.specialType == DumpInfoSpecialType.ABC_CODE) {
            dumpInfo = (DumpInfoSpecial)dumpInfo.parent;
        }
        SWF swf = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf();
        int method_info = (Integer)dumpInfo.specialValue;
    }

    private void closeSwfButtonActionPerformed(ActionEvent evt) {
        Main.closeFile(this.mainPanel.getCurrentSwfList());
    }

    @Override
    public DumpTreeModel getModel() {
        return (DumpTreeModel)super.getModel();
    }

    public void expandRoot() {
        DumpTreeModel dtm = this.getModel();
        DumpInfo root = dtm.getRoot();
        this.expandPath(new TreePath(new Object[]{root}));
    }

    public void expandFirstLevelNodes() {
        DumpTreeModel dtm = this.getModel();
        DumpInfo root = dtm.getRoot();
        int childCount = dtm.getChildCount(root);
        this.expandPath(new TreePath(new Object[]{root}));
        for (int i = 0; i < childCount; ++i) {
            this.expandPath(new TreePath(new Object[]{root, dtm.getChild(root, i)}));
        }
    }

    public void expandSwfNode(SWF swf) {
        DumpTreeModel dtm = this.getModel();
        DumpInfo root = dtm.getRoot();
        int childCount = dtm.getChildCount(root);
        this.expandPath(new TreePath(new Object[]{root}));
        for (int i = 0; i < childCount; ++i) {
            DumpInfoSwfNode swfNode = (DumpInfoSwfNode)dtm.getChild(root, i);
            if (swfNode.getSwf() != swf) continue;
            this.expandPath(new TreePath(new Object[]{root, dtm.getChild(root, i)}));
            break;
        }
    }

    public Tag getOriginalTag(TreeItem item) {
        Tag tag;
        if (item instanceof Tag) {
            tag = (Tag)item;
        } else if (item instanceof HasSwfAndTag) {
            tag = ((HasSwfAndTag)item).getTag();
        } else {
            return null;
        }
        ByteArrayRange range = tag.getOriginalRange();
        if (range == null) {
            return null;
        }
        long address = range.getPos();
        return this.searchTimelinedForTag((Timelined)((SWF)item.getOpenable()), address);
    }

    public Timelined getTimelinedForItem(TreeItem item) {
        Tag original = this.getOriginalTag(item);
        if (original == null) {
            return null;
        }
        return original.getTimelined();
    }

    public int getFrameForItem(TreeItem item) {
        Tag originalTag = this.getOriginalTag(item);
        if (originalTag == null) {
            return -1;
        }
        int frame = 0;
        for (Tag t : originalTag.getTimelined().getTags()) {
            if (t == originalTag) {
                return frame;
            }
            if (!(t instanceof ShowFrameTag)) continue;
            ++frame;
        }
        return -1;
    }

    public void setSelectedItem(TreeItem item) {
        Tag tag;
        if (item instanceof Tag) {
            tag = (Tag)item;
        } else if (item instanceof HasSwfAndTag) {
            tag = ((HasSwfAndTag)item).getTag();
        } else {
            return;
        }
        ByteArrayRange range = tag.getOriginalRange();
        if (range == null) {
            return;
        }
        long address = range.getPos();
        DumpTreeModel model = this.getModel();
        DumpInfo d = model.getRoot();
        for (DumpInfo sd : d.getChildInfos()) {
            DefineButton2Tag button;
            int i;
            DumpInfoSwfNode si;
            if (!(sd instanceof DumpInfoSwfNode) || (si = (DumpInfoSwfNode)sd).getSwf() != item.getOpenable()) continue;
            DumpInfoSwfNode di = si;
            while (model.getChildCount(di) > 0) {
                boolean found = false;
                for (DumpInfo child : di.getChildInfos()) {
                    if (child.startByte > address) break;
                    if (child.getEndByte() < address) continue;
                    di = child;
                    found = true;
                }
                if (found) continue;
                break;
            }
            di = di.parent;
            TreePath selPath = model.getDumpInfoPath((DumpInfo)di);
            if (item instanceof CLIPACTIONRECORD) {
                CLIPACTIONS clipActions = ((PlaceObjectTypeTag)tag).getClipActions();
                int index = clipActions.clipActionRecords.indexOf(item);
                block3: for (DumpInfo sdi : di.getChildInfos()) {
                    if (!"clipActions".equals(sdi.name)) continue;
                    i = 0;
                    for (DumpInfo sdi2 : sdi.getChildInfos()) {
                        if (!sdi2.name.equals("record")) continue;
                        if (i == index) {
                            selPath = model.getDumpInfoPath(sdi2);
                            break block3;
                        }
                        ++i;
                    }
                }
            }
            if (item instanceof BUTTONCONDACTION) {
                button = (DefineButton2Tag)tag;
                int index = button.actions.indexOf(item);
                block5: for (DumpInfo sdi : di.getChildInfos()) {
                    if (!"actions".equals(sdi.name)) continue;
                    i = 0;
                    for (DumpInfo sdi2 : sdi.getChildInfos()) {
                        if (!sdi2.name.equals("action")) continue;
                        if (i == index) {
                            selPath = model.getDumpInfoPath(sdi2);
                            break block5;
                        }
                        ++i;
                    }
                }
            }
            if (item instanceof BUTTONRECORD) {
                button = (ButtonTag)tag;
                int index = button.getRecords().indexOf(item);
                block7: for (DumpInfo sdi : di.getChildInfos()) {
                    if (!"characters".equals(sdi.name)) continue;
                    i = 0;
                    for (DumpInfo sdi2 : sdi.getChildInfos()) {
                        if (!sdi2.name.equals("record")) continue;
                        if (i == index) {
                            selPath = model.getDumpInfoPath(sdi2);
                            break block7;
                        }
                        ++i;
                    }
                }
            }
            if (selPath == null) break;
            this.setSelectionPath(selPath);
            this.scrollPathToVisible(selPath);
            break;
        }
    }

    public class DumpTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public DumpTreeCellRenderer() {
            if (View.isOceanic()) {
                this.setUI(new BasicLabelUI());
                this.setOpaque(false);
                this.setBackgroundNonSelectionColor(Color.white);
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component ret = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (ret instanceof JLabel) {
                JLabel lab = (JLabel)ret;
                if (value instanceof DumpInfo) {
                    DumpInfo di = (DumpInfo)value;
                    TreeNodeType nodeType = null;
                    if ("".equals(di.type)) {
                        nodeType = TreeNodeType.FLASH;
                    } else if ("TAG".equals(di.type)) {
                        String name = di.name;
                        if (name == null) {
                            name = "null";
                        }
                        if (name.contains(" ")) {
                            name = name.substring(0, name.indexOf(32)).trim();
                        }
                        switch (name) {
                            case "DefineFont": 
                            case "DefineFont2": 
                            case "DefineFont3": 
                            case "DefineFont4": 
                            case "DefineCompactedFont": {
                                nodeType = TreeNodeType.FONT;
                                break;
                            }
                            case "DefineText": 
                            case "DefineText2": 
                            case "DefineEditText": {
                                nodeType = TreeNodeType.TEXT;
                                break;
                            }
                            case "DefineBits": 
                            case "DefineBitsJPEG2": 
                            case "DefineBitsJPEG3": 
                            case "DefineBitsJPEG4": 
                            case "DefineBitsLossless": 
                            case "DefineBitsLossless2": {
                                nodeType = TreeNodeType.IMAGE;
                                break;
                            }
                            case "DefineShape": 
                            case "DefineShape2": 
                            case "DefineShape3": 
                            case "DefineShape4": {
                                nodeType = TreeNodeType.SHAPE;
                                break;
                            }
                            case "DefineMorphShape": 
                            case "DefineMorphShape2": {
                                nodeType = TreeNodeType.MORPH_SHAPE;
                                break;
                            }
                            case "DefineSprite": {
                                nodeType = TreeNodeType.SPRITE;
                                break;
                            }
                            case "DefineButton": 
                            case "DefineButton2": {
                                nodeType = TreeNodeType.BUTTON;
                                break;
                            }
                            case "DefineVideoStream": {
                                nodeType = TreeNodeType.MOVIE;
                                break;
                            }
                            case "DefineSound": 
                            case "SoundStreamHead": 
                            case "SoundStreamHead2": {
                                nodeType = TreeNodeType.SOUND;
                                break;
                            }
                            case "SoundStreamBlock": {
                                nodeType = TreeNodeType.SOUND_STREAM_BLOCK;
                                break;
                            }
                            case "DefineBinaryData": {
                                nodeType = TreeNodeType.BINARY_DATA;
                                break;
                            }
                            case "DoAction": 
                            case "DoInitAction": {
                                nodeType = TreeNodeType.AS;
                                break;
                            }
                            case "DoABC": 
                            case "DoABC2": {
                                nodeType = TreeNodeType.ABC;
                                break;
                            }
                            case "ShowFrame": {
                                nodeType = TreeNodeType.FRAME;
                                break;
                            }
                            case "SetBackgroundColor": {
                                nodeType = TreeNodeType.SET_BACKGROUNDCOLOR;
                                break;
                            }
                            case "FileAttributes": {
                                nodeType = TreeNodeType.FILE_ATTRIBUTES;
                                break;
                            }
                            case "Metadata": {
                                nodeType = TreeNodeType.METADATA;
                                break;
                            }
                            case "PlaceObject": 
                            case "PlaceObject2": 
                            case "PlaceObject3": 
                            case "PlaceObject4": {
                                nodeType = TreeNodeType.PLACE_OBJECT;
                                break;
                            }
                            case "PlaceImagePrivate": {
                                nodeType = TreeNodeType.PLACE_IMAGE_PRIVATE;
                                break;
                            }
                            case "RemoveObject": 
                            case "RemoveObject2": {
                                nodeType = TreeNodeType.REMOVE_OBJECT;
                                break;
                            }
                            case "DefineScalingGrid": {
                                nodeType = TreeNodeType.SCALING_GRID;
                                break;
                            }
                            case "DefineFontInfo": 
                            case "DefineFontInfo2": {
                                nodeType = TreeNodeType.FONT_INFO;
                                break;
                            }
                            case "DefineFontName": {
                                nodeType = TreeNodeType.FONT_NAME;
                                break;
                            }
                            case "CSMSettings": {
                                nodeType = TreeNodeType.CSM_SETTINGS;
                                break;
                            }
                            case "DefineButtonCxform": {
                                nodeType = TreeNodeType.BUTTON_CXFORM;
                                break;
                            }
                            case "DefineButtonSound": {
                                nodeType = TreeNodeType.BUTTON_SOUND;
                                break;
                            }
                            case "FrameLabel": {
                                nodeType = TreeNodeType.FRAME_LABEL;
                                break;
                            }
                            case "StartSound": 
                            case "StartSound2": {
                                nodeType = TreeNodeType.START_SOUND;
                                break;
                            }
                            case "VideoFrame": {
                                nodeType = TreeNodeType.VIDEO_FRAME;
                                break;
                            }
                            case "EnableDebugger": 
                            case "EnableDebugger2": 
                            case "Protect": {
                                nodeType = TreeNodeType.ENABLE_DEBUGGER;
                                break;
                            }
                            case "EnableTelemetry": {
                                nodeType = TreeNodeType.ENABLE_TELEMETRY;
                                break;
                            }
                            case "ExportAssets": {
                                nodeType = TreeNodeType.EXPORT_ASSETS;
                                break;
                            }
                            case "ImportAssets": 
                            case "ImportAssets2": {
                                nodeType = TreeNodeType.IMPORT_ASSETS;
                                break;
                            }
                            case "JPEGTables": {
                                nodeType = TreeNodeType.JPEG_TABLES;
                                break;
                            }
                            case "ProductInfo": {
                                nodeType = TreeNodeType.PRODUCT_INFO;
                                break;
                            }
                            case "ScriptLimits": {
                                nodeType = TreeNodeType.SCRIPT_LIMITS;
                                break;
                            }
                            case "SetTabIndex": {
                                nodeType = TreeNodeType.SET_TABINDEX;
                                break;
                            }
                            case "SymbolClass": {
                                nodeType = TreeNodeType.SYMBOL_CLASS;
                                break;
                            }
                            case "DefineSceneAndFrameLabelData": {
                                nodeType = TreeNodeType.SCENE_AND_FRAME_LABEL_DATA;
                                break;
                            }
                            case "DebugID": {
                                nodeType = TreeNodeType.DEBUG_ID;
                                break;
                            }
                            case "DefineVideo": {
                                nodeType = TreeNodeType.MOVIE_REF;
                                break;
                            }
                            case "FreeCharacter": {
                                nodeType = TreeNodeType.FREE_CHARACTER;
                                break;
                            }
                            case "SyncFrame": {
                                nodeType = TreeNodeType.SYNC_FRAME;
                                break;
                            }
                            case "NameCharacter": {
                                nodeType = TreeNodeType.NAME_CHARACTER;
                                break;
                            }
                            case "DefineTextFormat": {
                                nodeType = TreeNodeType.TEXT_FORMAT;
                                break;
                            }
                            case "CharacterSet": {
                                nodeType = TreeNodeType.CHARACTER_SET;
                                break;
                            }
                            case "FontRef": {
                                nodeType = TreeNodeType.FONT_REF;
                                break;
                            }
                            case "GenCommand": {
                                nodeType = TreeNodeType.GEN_COMMAND;
                                break;
                            }
                            case "SerialNumber": {
                                nodeType = TreeNodeType.SERIAL_NUMBER;
                                break;
                            }
                            default: {
                                nodeType = TreeNodeType.OTHER_TAG;
                            }
                        }
                    }
                    if (nodeType != null) {
                        lab.setIcon(TagTree.getIconForType(nodeType));
                    }
                }
            }
            return ret;
        }
    }
}

