/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.editor.LineMarkedEditorPane;
import com.jpexs.decompiler.flash.gui.editor.OccurrencesMarker;
import com.jpexs.decompiler.flash.gui.editor.UnderlinePainter;
import com.jpexs.decompiler.flash.gui.editor.WavyUnderLinePainter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.Markers;

public class HighlightsPanel
extends JPanel {
    private final LineMarkedEditorPane editorPane;
    private Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    private Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private Map<Integer, String> errors = new LinkedHashMap<Integer, String>();
    private int scrollBarButtonSize = 0;
    private JScrollPane scrollPane;

    public HighlightsPanel(final LineMarkedEditorPane editorPane) {
        this.editorPane = editorPane;
        this.scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, editorPane);
        JScrollBar bar = new JScrollBar(1, 0, 1, 0, 100);
        this.scrollBarButtonSize = bar.getPreferredSize().width;
        this.setPreferredSize(new Dimension(16, Integer.MAX_VALUE));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                int totalLineCount = ActionUtils.getLineCount((JTextComponent)editorPane);
                Rectangle r = HighlightsPanel.this.getScrollbarTrackRect();
                int line = (e.getY() - r.y) * totalLineCount / r.height;
                int linesCountPer1Px = totalLineCount / r.height;
                if (!HighlightsPanel.this.scrollPane.getVerticalScrollBar().isVisible()) {
                    linesCountPer1Px = 0;
                }
                for (Highlighter.Highlight highlight : editorPane.getHighlighter().getHighlights()) {
                    Highlighter.HighlightPainter painter = highlight.getPainter();
                    if (painter instanceof UnderlinePainter && ((UnderlinePainter)((Object)painter)).getColor() == null || !(painter instanceof Markers.SimpleMarker)) continue;
                    try {
                        int lineNum = ActionUtils.getLineNumber((JTextComponent)editorPane, (int)highlight.getStartOffset());
                        if (lineNum < line - linesCountPer1Px || lineNum > line + linesCountPer1Px) continue;
                        editorPane.setCaretPosition(highlight.getStartOffset());
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int totalLineCount = ActionUtils.getLineCount((JTextComponent)editorPane);
                Rectangle r = HighlightsPanel.this.getScrollbarTrackRect();
                int line = (e.getY() - r.y) * totalLineCount / r.height;
                int linesCountPer1Px = totalLineCount / r.height;
                if (!HighlightsPanel.this.scrollPane.getVerticalScrollBar().isVisible()) {
                    linesCountPer1Px = 0;
                }
                int lineStart = line * r.height / totalLineCount;
                int lineEnd = (line + 1) * r.height / totalLineCount;
                if (e.getY() - r.y < lineStart - 1 || e.getY() - r.y > lineStart + 2) {
                    if (HighlightsPanel.this.getCursor() != HighlightsPanel.this.DEFAULT_CURSOR) {
                        HighlightsPanel.this.setCursor(HighlightsPanel.this.DEFAULT_CURSOR);
                    }
                    HighlightsPanel.this.setToolTipText(null);
                    return;
                }
                int currentLine = editorPane.getLine();
                for (Highlighter.Highlight highlight : editorPane.getHighlighter().getHighlights()) {
                    Highlighter.HighlightPainter painter = highlight.getPainter();
                    if (painter instanceof UnderlinePainter && ((UnderlinePainter)((Object)painter)).getColor() == null || !(painter instanceof Markers.SimpleMarker)) continue;
                    try {
                        int lineNum = ActionUtils.getLineNumber((JTextComponent)editorPane, (int)highlight.getStartOffset());
                        if (lineNum < line - linesCountPer1Px || lineNum > line + linesCountPer1Px) continue;
                        if (line != currentLine && HighlightsPanel.this.getCursor() != HighlightsPanel.this.HAND_CURSOR) {
                            HighlightsPanel.this.setCursor(HighlightsPanel.this.HAND_CURSOR);
                        }
                        if (HighlightsPanel.this.errors.containsKey(highlight.getStartOffset())) {
                            HighlightsPanel.this.setToolTipText(AppStrings.translate("highlighter.error").replace("%error%", (CharSequence)HighlightsPanel.this.errors.get(highlight.getStartOffset())));
                            return;
                        }
                        if (line != currentLine && painter instanceof OccurrencesMarker) {
                            HighlightsPanel.this.setToolTipText(AppStrings.translate("highlighter.occurrences"));
                            return;
                        }
                        if (line == currentLine) {
                            HighlightsPanel.this.setToolTipText(AppStrings.translate("highlighter.currentLine"));
                        }
                        return;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (HighlightsPanel.this.getCursor() != HighlightsPanel.this.DEFAULT_CURSOR) {
                    HighlightsPanel.this.setCursor(HighlightsPanel.this.DEFAULT_CURSOR);
                }
                HighlightsPanel.this.setToolTipText(null);
            }
        });
    }

    public void setErrors(Map<Integer, String> errors) {
        this.errors = errors;
    }

    private Rectangle getScrollbarTrackRect() {
        return new Rectangle(0, this.scrollBarButtonSize, 16, this.getHeight() + -2 * this.scrollBarButtonSize);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle r = this.getScrollbarTrackRect();
        int totalLineCount = ActionUtils.getLineCount((JTextComponent)this.editorPane);
        int h = 3;
        Highlighter.Highlight[] highlights = this.editorPane.getHighlighter().getHighlights();
        HashSet<Integer> ignoredLines = new HashSet<Integer>();
        int currentLine = this.editorPane.getLine();
        for (Highlighter.Highlight highlight : highlights) {
            Highlighter.HighlightPainter painter;
            if (highlight == null || (painter = highlight.getPainter()) instanceof UnderlinePainter && ((UnderlinePainter)((Object)painter)).getColor() == null || !(painter instanceof Markers.SimpleMarker)) continue;
            Markers.SimpleMarker simpleMarker = (Markers.SimpleMarker)painter;
            g.setColor(simpleMarker.getColor());
            try {
                int line = ActionUtils.getLineNumber((JTextComponent)this.editorPane, (int)highlight.getStartOffset());
                if (painter instanceof WavyUnderLinePainter) {
                    ignoredLines.add(line);
                } else if (ignoredLines.contains(line)) continue;
                float ratio = (float)line / (float)totalLineCount;
                int y = r.y + (int)(ratio * (float)r.height);
                g.fillRect(0, y, this.getWidth(), h);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (currentLine >= 0) {
            float ratio = (float)currentLine / (float)totalLineCount;
            int y = r.y + (int)(ratio * (float)r.height) + 1;
            g.setColor(Color.gray);
            g.fillRect(0, y, this.getWidth(), 1);
            g.fillOval(6, y - 1, 3, 3);
        }
    }
}

