/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.editor;

import com.jpexs.decompiler.flash.gui.View;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import jsyntaxpane.components.Markers;

public class WavyUnderLinePainter
extends Markers.SimpleMarker {
    public WavyUnderLinePainter(Color color) {
        super(color);
    }

    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        try {
            TextUI mapper = c.getUI();
            Color col = this.getColor();
            if (col == null) {
                col = Color.black;
            }
            g.setColor(col);
            int waveHeight = 2;
            for (int i = offs0; i < offs1; ++i) {
                Rectangle2D r = View.textUIModelToView(mapper, c, i, Position.Bias.Forward);
                Rectangle2D r1 = View.textUIModelToView(mapper, c, i + 1, Position.Bias.Forward);
                if (r1.getY() != r.getY()) continue;
                int y = (int)(r.getY() + r1.getHeight());
                int maxX = (int)r1.getX();
                boolean up = true;
                for (int x = (int)r.getX(); x < maxX; x += 2) {
                    if (up) {
                        g.drawLine(x, y, x + 2, y - waveHeight);
                    } else {
                        g.drawLine(x, y - waveHeight, x + 2, y);
                    }
                    up = !up;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, javax.swing.text.View view) {
        Rectangle r;
        g.setColor(c.getSelectionColor());
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            r = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
        } else {
            try {
                Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            }
            catch (BadLocationException e) {
                r = null;
            }
        }
        if (r != null) {
            r.width = Math.max(r.width, 1);
            this.paint(g, offs0, offs1, r, c);
        }
        return r;
    }
}

